program sin_client;
const
 snd_Click   = 'Click';   { Sound on button click            }
 snd_Fails   = 'Fails';   { Sound on operation failure       }
 dfTrouble   = 1;         { DebugFlags - Trouble             }
 dfSuccess   = 2;         { DebugFlags - Success             }
 dfViewExp   = 4;         { DebugFlags - ViewExp             }
 dfViewImp   = 8;         { DebugFlags - ViewImp             }
 DimSrv      = '&DimSrv'; { DIM server device name           }
var
 b           : Boolean;   { Temporary                        }
 s           : String;    { Temporary                        }
 Ok          : Boolean;   { Program initialization is Ok?    }
 errors      : Integer;   { Program error counter            }
 errorcode   : Integer;   { Error code for this device       }
 fixmaxavail : Integer;   { String manager leak control      }
 DebugFlags  : Integer;   { Debug bit flags                  }
 StdIn       : Record     { Standard input data:             }
  Line       : String;    { Incoming line                    }
  Cmnd,Data  : String;    { Cmnd or Cmnd=Data                }
 end;
 Click_Info  : String;    { Information on last click        }
 tagStart    : Integer;   { Start button                     }
 tagFreq     : Integer;   { Frequency value                  }
 tagAmpl     : Integer;   { Amplitude value                  }
 tagNoise    : Integer;   { Noise value                      }
 tagClick    : Integer;   { Sensor click information         }
 tagNotify   : Integer;   { Sensor click notification        }
 tagPostBox  : Integer;   { Shared data path                 }
 devDimSrv   : Integer;   { Dim server reference             }
 {
 Dialog with warning message
 }
 procedure Warning(msg:string);
 var b:boolean;
 begin
  if editstate=0 
  then msg:=edit('('+msg)+edit(')Warning')
  else b:=Echo(msg);
 end;
 {
 Report on success.
 }
 procedure Success(msg:String);
 begin
  if iand(DebugFlags,dfSuccess)<>0 then
  if length(msg)>0 then writeln(devname+' : '+msg);
 end;
 {
 Report on trouble.
 }
 procedure Trouble(msg:String);
 var b:Boolean;
 begin
  if iand(DebugFlags,dfTrouble)<>0 then
  if length(msg)>0 then writeln(devname+' ! '+msg);
  if runcount=1 then errors:=errors+1 else b:=fixerror(errorcode);
 end;
 {
 Report on data import to program.
 }
 procedure ViewImp(msg:String);
 begin
  if iand(DebugFlags,dfViewImp)<>0 then
  if length(msg)>0 then writeln(devname+' < '+msg);
 end;
 {
 Report on data export from program.
 }
 procedure ViewExp(msg:String);
 begin
  if iand(DebugFlags,dfViewExp)<>0 then
  if length(msg)>0 then writeln(devname+' > '+msg);
 end;
 {
 Initialize dialog to edit tag
 }
 procedure StartEditTag(tag:integer; Caption:string);
 var s:string;
 begin
  s:='';
  if typetag(tag)>0 then begin
   if editstate=0 then begin
    if typetag(tag)=1 then s:=str(igettag(tag)) else
    if typetag(tag)=2 then s:=str(rgettag(tag)) else
    if typetag(tag)=3 then s:=sgettag(tag) else s:='';
    if pos('?',edit('(Редактировать тег '+nametag(tag))
              +edit(' '+Caption+'|'+s)
              +edit(')StringGridEdit EDIT_TAG_'+nametag(tag)))>0
    then Warning('Error starting edit tag "'+nametag(tag)+'"!');
   end else Warning('Could not edit tag "'+nametag(tag)+'" right now!');
  end;
  s:='';
 end;
 {
 Check if tag editing done.
 }
 function CheckEditTag(tag:integer; var newValue:String):Boolean;
 var s,d:string; r:real; b:boolean;
 begin
  r:=0;
  s:='';
  d:='';
  CheckEditTag:=false;
  if editstate=1 then
  if typetag(tag)>0 then begin
   s:=edit('?ans 0');
   if extractword(1,s)='EDIT_TAG_'+nametag(tag) then begin
    if extractword(2,s)='1' then begin
     s:=edit('?ans 1');
     d:=worddelims('|');
     s:=extractword(2,s);
     d:=worddelims(d);
     if typetag(tag)=1 then begin
      r:=eval(s);
      if not isnan(r) then begin
       r:=Round(r);
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if typetag(tag)=2 then begin
      r:=eval(s);
      if not isnan(r) then begin
       newValue:=Str(r);
       CheckEditTag:=true;
      end;
     end;
     if typetag(tag)=3 then begin
      newValue:=s;
      CheckEditTag:=true;
     end;
    end;
    s:=edit('');
   end;
   if isnan(r) then Warning('Invalid input!')
  end;
  s:='';
  d:='';
 end;
 {
 Check I/O status.
 }
 function IoError:boolean;
 begin
  IoError:=false;
  if ioresult<>0 then begin
   Trouble('I/O error.');
   IoError:=true;
  end;
 end;
 {
 Read string line from standard input.
 }
 function StdIn_Readln(var s:string):boolean;
 begin
  StdIn_Readln:=false;
  if not IoError then 
  if not eof then begin
   readln(s);
   if not IoError then StdIn_Readln:=true;
  end;
 end;
 {
 Post message to DIM server.
 }
 procedure DIM_Post(msg:String);
 begin
  if Length(msg)>0 then
  if devPost(devDimSrv,msg)=0
  then Trouble('Failed devPost to '+DimSrv);
 end;
 {
 Post message to DIM server to update tag.
 Post also new tag value if data specified.
 }
 procedure DIM_UpdateTag(tag:Integer; data:String);
 begin
  if TypeTag(tag)>0 then begin
   if Length(data)=0
   then DIM_Post('##'+Str(tag)+EOL)
   else DIM_Post('##'+Str(tag)+'='+mime_encode(data)+EOL);
  end;
 end;
 {
 Send click command to server. Use encryption for network safety.
 }
 procedure Click_Send(data:String);
 begin
  DIM_UpdateTag(tagClick,crypt_encode(data,'crw-daq.ru'));
 end;
 {
 Analyse data coming from standard input.
 }
 procedure StdIn_Process(s:string);
 var p:Integer;
 begin
  ViewImp(s);
  p:=pos('=',s); if p=0 then p:=Length(s)+1;
  StdIn.Cmnd:=Trim(Copy(s,1,p-1));
  StdIn.Data:=Trim(Copy(s,p+1));
  if IsSameText('@notify',StdIn.Cmnd) then begin
   if Length(StdIn.Data)=0
   then StdIn.Data:=sGetTag(tagNotify)
   else StdIn.Data:=Trim(mime_decode(StdIn.Data));
   if (Length(StdIn.Data)>0) and not IsSameText(StdIn.Data,'Ok') then begin
    b:=Echo(devname+' ! SERVER NOTIFY:');
    b:=Echo(devname+' ! '+StdIn.Data);
    b:=WinSelect(ParamStr('MainConsole'));
   end;
  end;
  StdIn.Cmnd:='';
  StdIn.Data:='';
 end;
 {
 Read server PostBox directory.
 }
 procedure ListServerPostBox(PostBox:String);
 var i,t:Integer;
 begin
  if FileExists(PostBox) then begin
   t:=DirList(text_new,0,PostBox,'*.dat');
   b:=Echo(devname+' : List server PostBox='+PostBox);
   for i:=0 to text_numln(t)-1 do
   b:=Echo(devname+' :  '+text_getln(t,i));
   b:=text_free(t);
  end else begin
   b:=Echo(devname+' ! Could not find server PostBox='+PostBox);
  end;
 end;
 {
 Encode full sensor click information into long string...
 }
 procedure EncodeClick(var s:String);
 begin
  s:='@click'+EOL;
  s:=s+'Button='+ClickParams('Button')+EOL;
  s:=s+'Sensor='+ClickParams('Sensor')+EOL;
  s:=s+'Device='+ClickParams('Device')+EOL;
  s:=s+'Window='+ClickParams('Window')+EOL;
  s:=s+'Value='+ClickParams('Value')+EOL;
  s:=s+'Curve='+ClickParams('Curve')+EOL;
  s:=s+'Tag='+ClickParams('Tag')+EOL;
  s:=s+'Guard='+ParamStr('Guard')+EOL;
  s:=s+'User='+ParamStr('UserName')+EOL;
  s:=s+'Host='+ParamStr('HostName')+EOL;
  s:=s+'IP='+ParamStr('IPAddress')+EOL;
  s:=s+'MAC='+ParamStr('MACAddress')+EOL;
 end;
 {
 Clear all strings
 }
 procedure ClearStrings;
 begin
  s:='';
  Click_Info:='';
  StdIn.Line:='';    StdIn.Cmnd:='';    StdIn.Data:='';
  if runcount=1 then fixmaxavail:=maxavail;
  if isinf(runcount) then
  if maxavail<>fixmaxavail then Trouble('String Manager Leak = '+str(fixmaxavail-maxavail));
 end;
 {
 Initialize and check tag
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 //
 // Initialization actions on Start...
 //
 if runcount=1 then begin
  //
  // Initialize errors...
  //
  errors:=0;
  errorcode:=registererr(devname);
  //
  // Clear and initialize variables...
  //
  ClearStrings;
  DebugFlags:=val(ReadIni('DebugFlags'));
  Success('Start mmTimer='+Str(eval('@system @mmtimer 1'))+' [ms].');
  //
  // Open console window...
  //
  if val(ReadIni('OpenConsole'))>0 then begin
   s:=ParamStr('Console '+devname);
   b:=winshow(s);
   b:=windraw(s+'|top=317|left=167|Width=600|Height=317');
   b:=winselect(s);
   if val(ReadIni('OpenConsole'))>1 then b:=winhide(s);
  end;
  //
  // Open client control window...
  //
  s:='SIN_CLIENT';
  b:=winshow(s);
  b:=windraw(s+'|Top=317|Left=0|Width=400|Height=290'
              +'|Options=-Min,-Max,-Close,-Width,-Height,-HScroll,-VScroll');
  b:=winselect(s);
  //
  // Initialize tags...
  //
  InitTag(tagStart,		'sin_start',		1);
  InitTag(tagFreq,		'sin_freq',		2);
  InitTag(tagAmpl,		'sin_ampl',		2);
  InitTag(tagNoise,		'sin_noise',		2);
  InitTag(tagClick,		'sin_click',		3);
  InitTag(tagNotify,	'sin_notify',		3);
  InitTag(tagPostBox,	'sin_postbox',		3);
  //
  // Initialize DIM device reference...
  //
  devDimSrv:=RefFind('Device '+DimSrv);
  if devDimSrv=0 then Trouble('Could not find '+DimSrv);
  //
  // Is it Ok?
  //
  if errors=0 then Success('Start Ok.') else Trouble('Start Fails.');
  if errors<>0 then b:=fixerror(errorcode);
  Ok:=(errors=0);
 end else
 //
 // Finalization actions on Stop...
 //
 if isinf(runcount) then begin
  Success('Stop mmTimer='+Str(eval('@system @mmtimer 0'))+' [ms].');
  ClearStrings;
  Success('Stop.');
 end else
 //
 // Actions on Poll
 //
 if Ok then begin
  //
  // Check standard I/O errors...
  //
  if ioresult<>0 then b:=fixerror(errorcode);
  //
  // Process standard input...
  //
  while StdIn_Readln(StdIn.Line) do StdIn_Process(StdIn.Line);
  //
  // Edit tags...
  //
  if editstate=1 then begin
   if CheckEditTag(tagFreq,s)  then Click_Send(Click_Info+'NewValue='+s);
   if CheckEditTag(tagAmpl,s)  then Click_Send(Click_Info+'NewValue='+s);
   if CheckEditTag(tagNoise,s) then Click_Send(Click_Info+'NewValue='+s);
   Click_Info:='';
  end;
  if editstate=1 then begin
   Trouble('Unknown tag edition!');
   s:=edit('');
  end;
  if iand(editstate,9)<>0 then begin
   Trouble('Dialog error detected!');
   s:=edit('');
  end;
  //
  // Actions on sensor click...
  //
  if clickbutton=1 then begin
   //
   // Encode click info to send to server later...
   //
   EncodeClick(Click_Info);
   //
   // On START click, send command to server...
   //
   if IsSameText(clicksensor,'SIN_START') then begin
    Click_Send(Click_Info+'NewValue='+Str(ord(iGetTag(tagStart)=0)));
    b:=voice(snd_Click);
    Click_Info:='';
   end;
   if IsSameText(clicksensor,'SIN_FREQ') then begin
    StartEditTag(tagFreq,'Частота синусоиды');
    b:=voice(snd_Click);
   end;
   if IsSameText(clicksensor,'SIN_AMPL') then begin
    StartEditTag(tagAmpl,'Амплитуда синусоиды');
    b:=voice(snd_Click);
   end;
   if IsSameText(clicksensor,'SIN_NOISE') then begin
    StartEditTag(tagNoise,'Уровень шума');
    b:=voice(snd_Click);
   end;
   if IsSameText(clicksensor,'SIN_WAVE1')
   or IsSameText(clicksensor,'SIN_WAVE2') then begin
    b:=voice(snd_Click);
    s:='SIN_PLOT';
    b:=windraw(s+'|Top=317|Left=167|Width=600|Height=400'
                +'|Options=-Min,-Max,+Close,-Width,-Height');
    b:=winselect(s);
    ListServerPostBox(sGetTag(tagPostBox));
   end;
  end;
 end;
end.
