@echo off
SetLocal EnableExtensions EnableDelayedExpansion

chcp 65001

rem ****************************
rem APC devices config generator
rem ****************************

:Main
call :InitializeVariables
pushd "%~dp0" && call :APCDevices
popd
goto :EOF

:SetUnixPath
for /f "tokens=* delims=" %%a in ('unix path') do set "%%a"
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set devmsg=devPostMsg
set tabcrc=..\Circuits\%~n0_link.crc
set /a numhdwcfg=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=600
set /a CTRL_TOP_STEP=100
set /a TABCRC_TOP=0
set /a TABCRC_STEP=40
set /a TABCRC_LEFT=0
goto :EOF

:APCDevices
call :DeleteFiles %hdwcfg% %simcfg% %tabcrc% %diccfg% %discfg%
rem   Device        Facility DevName Identitier Simulator Port Baudrate Parity DataBits StopBits DevLabel
call :APC_COM       DEMO     APC  S1        0         2    115200   NONE   8        1        S1
call :APC_COM       DEMO     APC  S2        0         2    2400     NONE   8        1        S2
rem   Device        Facility DevName Identitier Simulator TCPPort IPClient      Polling Priority       TxSize RxSize Timeout Label
call :APC_TCP       DEMO     APC  S3        0         5300    192.168.0.110 1000    tpTimeCritical 16384  32768  1000    S3 
call :APC_TCP       DEMO     APC  S4        0         5301    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    S4 
call :APC_TCP       DEMO     APC  S5        0         5302    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    S5 
call :APC_TCP       DEMO     APC  S6        0         5303    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    S6 
call :APC_TCP       DEMO     APC  S7        0         5300    192.168.0.110 1000    tpTimeCritical 16384  32768  1000    S7 
call :APC_TCP       DEMO     APC  S8        0         5301    192.168.1.31  1000    tpTimeCritical 16384  32768  1000    S8 
type %hdwcfg%
goto :EOF

:APC_COM
call :APC_SET_COM %*
call :APC_HDW_COM %* >> %hdwcfg%
call :APC_SIM %* >> %simcfg%
call :APC_DIC %* >> %diccfg%
call :APC_DIS %* >> %discfg%
call :APC_TABCRC >> %tabcrc%
set /a CTRL_TOP+=CTRL_TOP_STEP
goto :EOF

:APC_TCP
call :APC_SET_TCP %*
call :APC_HDW_TCP %* >> %hdwcfg%
call :APC_SIM %* >> %simcfg%
call :APC_DIC %* >> %diccfg%
call :APC_DIS %* >> %discfg%
call :APC_TABCRC >> %tabcrc%
set /a CTRL_TOP+=CTRL_TOP_STEP
goto :EOF

:APC_SET_COM
set "FN=%~1"       &shift     & :: Facility name
set "DEV=%~1"      &shift     & :: Device Name
set "IDEN=%~1"     &shift     & :: Identifier
set "SIM=%~1"      &shift     & :: Simulator
set "ComPort=%~1"  &shift     & :: COM Port number
set "Baudrate=%~1" &shift     & :: Baudrate COM
set "Parity=%~1"   &shift     & :: Parity COM
set "DataBits=%~1" &shift     & :: DataBits COM
set "StopBits=%~1" &shift     & :: StopBits COM
set "DevLabel=%~1" &shift     & :: Name device in label
set "FCP=%FN:.=/%"            & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FCF=%FN:.=_%"            & :: Facility file name, i.e. FACN name with . to _ replacement
goto :EOF

:APC_SET_TCP
set "FN=%~1"       &shift     & :: Facility name
set "DEV=%~1"      &shift     & :: Device Name
set "IDEN=%~1"     &shift     & :: Device identifier name
set "SIM=%~1"      &shift     & :: Simulator
set "TcpPort=%~1"  &shift     & :: TCP Port number
set "IP=%~1"       &shift     & :: IP
set "Polling=%~1"  &shift     & :: Polling connection
set "Priority=%~1" &shift     & :: Priority connection
set "TxSize=%~1"   &shift     & :: Buffer Tx
set "RxSize=%~1"   &shift     & :: Buffer Rx
set "Timeout=%~1"  &shift     & :: Timeout connection
set "DevLabel=%~1" &shift     & :: Name device in label
set "FCP=%FN:.=/%"            & :: Facility DIM  path, i.e. FACN name with . to / replacement
set "FCF=%FN:.=_%"            & :: Facility file name, i.e. FACN name with . to _ replacement
goto :EOF

:APC_HDW_COM
echo ;***************************
echo ;***Driver for %DEV%***
echo ;***************************
echo [DeviceList]
echo ^&%FN%.%DEV%.%IDEN%.CTRL = device software Program
echo [^&%FN%.%DEV%.%IDEN%.CTRL]
echo Comment = Driver for APC Smart-UPS Series
echo InquiryPeriod = 0
echo DevicePolling = 10, tpNormal
echo DigitalFifo   = 1024
echo AnalogFifo    = 1024
echo Timeout       = 200
echo DebugFlags    = 3
echo OpenConsole   = 2
echo EncryptMethod   = RC6
echo TrustedUsers    = [TrustedUsers]
echo DIM_GuiClickTag = %FN%.%DEV%.%IDEN%.DIMGUICLICK
echo Simulator     = %SIM%
echo ProgramSource = ..\daqpas\apc_drv.pas
echo tagPrefix     = %FN%.%DEV%.%IDEN%
echo ModeConnect   = COM
echo ComPort       = %ComPort%
echo BaudRate      = %Baudrate%
echo Parity        = %Parity%
echo DataBits      = %DataBits%
echo StopBits      = %StopBits%
echo AnalogOutputs = 9
echo Link AnalogOutput 0 with curve %FN%.%DEV%.%IDEN%.UINP history 1024
echo Link AnalogOutput 1 with curve %FN%.%DEV%.%IDEN%.FREQ history 1024
echo Link AnalogOutput 2 with curve %FN%.%DEV%.%IDEN%.UOUT history 1024
echo Link AnalogOutput 3 with curve %FN%.%DEV%.%IDEN%.UBAT history 1024
echo Link AnalogOutput 4 with curve %FN%.%DEV%.%IDEN%.VBAT history 1024
echo Link AnalogOutput 5 with curve %FN%.%DEV%.%IDEN%.CBAT history 1024
echo Link AnalogOutput 6 with curve %FN%.%DEV%.%IDEN%.POUT history 1024
echo Link AnalogOutput 7 with curve %FN%.%DEV%.%IDEN%.TEMP history 1024
echo Link AnalogOutput 8 with curve %FN%.%DEV%.%IDEN%.POLL history 1024
echo DigitalOutputs = 2
echo Link DigitalOutput 0 with curve %FN%.%DEV%.%IDEN%.STATE  history 1024
echo Link DigitalOutput 1 with curve %FN%.%DEV%.%IDEN%.STATUS history 1024
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\%FN%_DATA\%DEV%\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 1
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = %FN%.%DEV%.%IDEN%.POLL_EN
echo []
echo [DataStorage]
echo %FN%.%DEV%.%IDEN%.UINP   = Curve 0 1000 Black 0 1 ; Input Voltage 220V
echo %FN%.%DEV%.%IDEN%.FREQ   = Curve 0 1000 Black 0 1 ; Input Frequency, Hz
echo %FN%.%DEV%.%IDEN%.UOUT   = Curve 0 1000 Black 0 1 ; Output Voltage
echo %FN%.%DEV%.%IDEN%.UBAT   = Curve 0 1000 Black 0 1 ; Output Battery Voltage
echo %FN%.%DEV%.%IDEN%.VBAT   = Curve 0 1000 Black 0 1 ; Battery Voltage
echo %FN%.%DEV%.%IDEN%.CBAT   = Curve 0 1000 Black 0 1 ; Battery Charge, 
echo %FN%.%DEV%.%IDEN%.POUT   = Curve 0 1000 Black 0 1 ; Output load, 
echo %FN%.%DEV%.%IDEN%.TEMP   = Curve 0 1000 Black 0 1 ; Temperature APC, Celsium
echo %FN%.%DEV%.%IDEN%.STATE  = Curve 0 1000 Black 0 1 ; State UPS
echo %FN%.%DEV%.%IDEN%.STATUS = Curve 0 1000 Black 0 1 ; Status UPS
echo %FN%.%DEV%.%IDEN%.POLL   = Curve 0 1000 Black 0 1 ; PollRate
echo []
echo [TagList]
echo %FN%.%DEV%.%IDEN%.DIMGUICLICK = string  ?    ; The DIM click sensor data
echo %FN%.%DEV%.%IDEN%.DIMCMDMY    = string  ? ; Обработчик команд от клиента      ( The DIM command handler   )
echo %FN%.%DEV%.%IDEN%.SERVMODE    = Integer 2 ; Режим работы запущенной системы
echo %FN%.%DEV%.%IDEN%.POLL_EN     = Integer 0    ; Enable Poll UPS
echo %FN%.%DEV%.%IDEN%.ENABLE      = Integer 0    ; Button "Enable/Disable UPS"
echo %FN%.%DEV%.%IDEN%.TEST        = Integer 0    ; Button "Test UPS"
echo %FN%.%DEV%.%IDEN%.UOUTSTT     = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.UBATSTT     = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.OVERSTT     = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.LOWSTT      = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.REPBAT      = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.STATUS      = Integer 0    ; Status UPS
echo %FN%.%DEV%.%IDEN%.INDIC       = String  Null ; Result last indicator test
echo %FN%.%DEV%.%IDEN%.ITSELF      = String  Null ; Result last itself test
echo %FN%.%DEV%.%IDEN%.NAME        = String  Null ; Name device
echo %FN%.%DEV%.%IDEN%.UINP        = Real    0    ; Input Voltage 220V
echo %FN%.%DEV%.%IDEN%.FREQ        = Real    0    ; Input Frequency, Hz
echo %FN%.%DEV%.%IDEN%.UOUT        = Real    0    ; Output Voltage
echo %FN%.%DEV%.%IDEN%.UBAT        = Real    0    ; Output Battery Voltage
echo %FN%.%DEV%.%IDEN%.VBAT        = Real    0    ; Battery Voltage
echo %FN%.%DEV%.%IDEN%.CBAT        = Real    0    ; Battery Charge, 
echo %FN%.%DEV%.%IDEN%.POUT        = Real    0    ; Output load, 
echo %FN%.%DEV%.%IDEN%.TEMP        = Real    0    ; Temperature UPS, Celsium
echo %FN%.%DEV%.%IDEN%.STATE       = Real    0    ; State UPS
echo %FN%.%DEV%.%IDEN%.POLLRATE    = Integer 0    ; PollRate
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.CTRL = Circuit_Window
echo [%FN%.%DEV%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\apc_ctrl.crc
echo Link sensor %DEV%.UINP    with curve %FN%.%DEV%.%IDEN%.UINP        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FREQ    with curve %FN%.%DEV%.%IDEN%.FREQ        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UOUT    with curve %FN%.%DEV%.%IDEN%.UOUT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UBAT    with tag   %FN%.%DEV%.%IDEN%.UBAT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.VBAT    with tag   %FN%.%DEV%.%IDEN%.VBAT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.CBAT    with tag   %FN%.%DEV%.%IDEN%.CBAT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POUT    with tag   %FN%.%DEV%.%IDEN%.POUT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TEMP    with tag   %FN%.%DEV%.%IDEN%.TEMP        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.ENABLE  with tag   %FN%.%DEV%.%IDEN%.ENABLE      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.STATUS  with tag   %FN%.%DEV%.%IDEN%.STATUS      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TEST    with tag   %FN%.%DEV%.%IDEN%.TEST        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POLL_EN with tag   %FN%.%DEV%.%IDEN%.POLL_EN     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UOUTSTT with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UBATSTT with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.OVERSTT with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LOWSTT  with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.REPBAT  with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.INDIC   with tag   %FN%.%DEV%.%IDEN%.INDIC       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.ITSELF  with tag   %FN%.%DEV%.%IDEN%.ITSELF      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.NAME    with tag   %FN%.%DEV%.%IDEN%.NAME        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POLL    with tag   %FN%.%DEV%.%IDEN%.POLLRATE    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TITLE   with                                        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=335^|Height=716
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SHOW @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HIDE @WinHide %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SELECT @WinSelect %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HIDE
echo []
echo [%FN%.MAIN.CTRL]
echo Link sensor @cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT with device ^&%FN%.MAIN.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.STATUS    with tag %FN%.%DEV%.%IDEN%.STATUS  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.ENABLE    with tag %FN%.%DEV%.%IDEN%.ENABLE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link Sensor SYSTEMMODE                  with tag %FN%.%DEV%.%IDEN%.SERVMODE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FN%.%DEV%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.25
echo AxisY = ^^CState channel^^N^^L___{Status}, 0, 1000
echo CurveList = %FN%.%DEV%.%IDEN%.UINP
echo CurveList = %FN%.%DEV%.%IDEN%.FREQ
echo CurveList = %FN%.%DEV%.%IDEN%.UOUT
echo CurveList = %FN%.%DEV%.%IDEN%.UBAT
echo CurveList = %FN%.%DEV%.%IDEN%.VBAT
echo CurveList = %FN%.%DEV%.%IDEN%.CBAT
echo CurveList = %FN%.%DEV%.%IDEN%.POUT
echo CurveList = %FN%.%DEV%.%IDEN%.TEMP
echo CurveList = %FN%.%DEV%.%IDEN%.STATE
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS
echo CurveList = %FN%.%DEV%.%IDEN%.POLL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo CurveList = %FN%.%DEV%.%IDEN%.UINP
echo CurveList = %FN%.%DEV%.%IDEN%.FREQ
echo CurveList = %FN%.%DEV%.%IDEN%.UOUT
echo CurveList = %FN%.%DEV%.%IDEN%.UBAT
echo CurveList = %FN%.%DEV%.%IDEN%.VBAT
echo CurveList = %FN%.%DEV%.%IDEN%.CBAT
echo CurveList = %FN%.%DEV%.%IDEN%.POUT
echo CurveList = %FN%.%DEV%.%IDEN%.TEMP
echo CurveList = %FN%.%DEV%.%IDEN%.STATE
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS
echo CurveList = %FN%.%DEV%.%IDEN%.POLL
echo []
goto :EOF

:APC_HDW_TCP
echo ;***************************
echo ;***Driver for %DEV%***
echo ;***************************
echo [DeviceList]
echo ^&%FN%.%DEV%.%IDEN%.CTRL = device software Program
echo [^&%FN%.%DEV%.%IDEN%.CTRL]
echo Comment = Driver for APC Smart-UPS Series
echo InquiryPeriod = 0
echo DevicePolling = 10, tpNormal
echo DigitalFifo   = 1024
echo AnalogFifo    = 1024
echo Timeout       = 200
echo DebugFlags    = 3
echo OpenConsole   = 2
echo EncryptMethod   = RC6
echo TrustedUsers    = [TrustedUsers]
echo DIM_GuiClickTag = %FN%.%DEV%.%IDEN%.DIMGUICLICK
echo Simulator     = %SIM%
echo ProgramSource = ..\daqpas\apc_drv.pas
echo tagPrefix     = %FN%.%DEV%.%IDEN%
echo TcpPort       = %TcpPort%
echo ClientIP      = %IP%
echo PipePooling   = %Polling%
echo PipePriority  = %Priority%
echo TxPipeSize    = %TxSize%
echo RxPipeSize    = %RxSize%
echo PipeTimeout   = %Timeout%
echo AnalogOutputs = 9
echo Link AnalogOutput 0 with curve %FN%.%DEV%.%IDEN%.UINP history 1024
echo Link AnalogOutput 1 with curve %FN%.%DEV%.%IDEN%.FREQ history 1024
echo Link AnalogOutput 2 with curve %FN%.%DEV%.%IDEN%.UOUT history 1024
echo Link AnalogOutput 3 with curve %FN%.%DEV%.%IDEN%.UBAT history 1024
echo Link AnalogOutput 4 with curve %FN%.%DEV%.%IDEN%.VBAT history 1024
echo Link AnalogOutput 5 with curve %FN%.%DEV%.%IDEN%.CBAT history 1024
echo Link AnalogOutput 6 with curve %FN%.%DEV%.%IDEN%.POUT history 1024
echo Link AnalogOutput 7 with curve %FN%.%DEV%.%IDEN%.TEMP history 1024
echo Link AnalogOutput 8 with curve %FN%.%DEV%.%IDEN%.POLL history 1024
echo DigitalOutputs = 2
echo Link DigitalOutput 0 with curve %FN%.%DEV%.%IDEN%.STATE  history 1024
echo Link DigitalOutput 1 with curve %FN%.%DEV%.%IDEN%.STATUS history 1024
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%IDEN%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo CustomIniSection  = [%IDEN%.CustomParameters]
echo CustomIniBackups  = ..\Data\%FN%_DATA\%DEV%\Custom
echo CustomIniAutoLoad = 1
echo CustomIniAutoSave = 1
echo []
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FN%_DATA\%DEV%\%IDEN%_custom.ini
echo []
echo [%IDEN%.CustomParameters.TagList]
echo TagList = %FN%.%DEV%.%IDEN%.POLL_EN
echo []
echo [DataStorage]
echo %FN%.%DEV%.%IDEN%.UINP   = Curve 0 1000 Black 0 1 ; Input Voltage 220V
echo %FN%.%DEV%.%IDEN%.FREQ   = Curve 0 1000 Black 0 1 ; Input Frequency, Hz
echo %FN%.%DEV%.%IDEN%.UOUT   = Curve 0 1000 Black 0 1 ; Output Voltage
echo %FN%.%DEV%.%IDEN%.UBAT   = Curve 0 1000 Black 0 1 ; Output Battery Voltage
echo %FN%.%DEV%.%IDEN%.VBAT   = Curve 0 1000 Black 0 1 ; Battery Voltage
echo %FN%.%DEV%.%IDEN%.CBAT   = Curve 0 1000 Black 0 1 ; Battery Charge, 
echo %FN%.%DEV%.%IDEN%.POUT   = Curve 0 1000 Black 0 1 ; Output load, 
echo %FN%.%DEV%.%IDEN%.TEMP   = Curve 0 1000 Black 0 1 ; Temperature APC, Celsium
echo %FN%.%DEV%.%IDEN%.STATE  = Curve 0 1000 Black 0 1 ; State UPS
echo %FN%.%DEV%.%IDEN%.STATUS = Curve 0 1000 Black 0 1 ; Status UPS
echo %FN%.%DEV%.%IDEN%.POLL   = Curve 0 1000 Black 0 1 ; PollRate
echo []
echo [TagList]
echo %FN%.%DEV%.%IDEN%.DIMGUICLICK = string  ?    ; The DIM click sensor data
echo %FN%.%DEV%.%IDEN%.DIMCMDMY    = string  ? ; Обработчик команд от клиента      ( The DIM command handler   )
echo %FN%.%DEV%.%IDEN%.SERVMODE    = Integer 2 ; Режим работы запущенной системы
echo %FN%.%DEV%.%IDEN%.POLL_EN     = Integer 0    ; Enable Poll UPS
echo %FN%.%DEV%.%IDEN%.ENABLE      = Integer 0    ; Button "Enable/Disable UPS"
echo %FN%.%DEV%.%IDEN%.TEST        = Integer 0    ; Button "Test UPS"
echo %FN%.%DEV%.%IDEN%.UOUTSTT     = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.UBATSTT     = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.OVERSTT     = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.LOWSTT      = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.REPBAT      = Integer 0    ; Indicator state UPS
echo %FN%.%DEV%.%IDEN%.STATUS      = Integer 0    ; Status UPS
echo %FN%.%DEV%.%IDEN%.INDIC       = String  Null ; Result last indicator test
echo %FN%.%DEV%.%IDEN%.ITSELF      = String  Null ; Result last itself test
echo %FN%.%DEV%.%IDEN%.NAME        = String  Null ; Name device
echo %FN%.%DEV%.%IDEN%.UINP        = Real    0    ; Input Voltage 220V
echo %FN%.%DEV%.%IDEN%.FREQ        = Real    0    ; Input Frequency, Hz
echo %FN%.%DEV%.%IDEN%.UOUT        = Real    0    ; Output Voltage
echo %FN%.%DEV%.%IDEN%.UBAT        = Real    0    ; Output Battery Voltage
echo %FN%.%DEV%.%IDEN%.VBAT        = Real    0    ; Battery Voltage
echo %FN%.%DEV%.%IDEN%.CBAT        = Real    0    ; Battery Charge, 
echo %FN%.%DEV%.%IDEN%.POUT        = Real    0    ; Output load, 
echo %FN%.%DEV%.%IDEN%.TEMP        = Real    0    ; Temperature UPS, Celsium
echo %FN%.%DEV%.%IDEN%.STATE       = Real    0    ; State UPS
echo %FN%.%DEV%.%IDEN%.POLLRATE    = Integer 0    ; PollRate
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.CTRL = Circuit_Window
echo [%FN%.%DEV%.%IDEN%.CTRL]
echo Circuit = ..\Circuits\apc_ctrl.crc
echo Link sensor %DEV%.UINP    with curve %FN%.%DEV%.%IDEN%.UINP        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.FREQ    with curve %FN%.%DEV%.%IDEN%.FREQ        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UOUT    with curve %FN%.%DEV%.%IDEN%.UOUT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UBAT    with tag   %FN%.%DEV%.%IDEN%.UBAT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.VBAT    with tag   %FN%.%DEV%.%IDEN%.VBAT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.CBAT    with tag   %FN%.%DEV%.%IDEN%.CBAT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POUT    with tag   %FN%.%DEV%.%IDEN%.POUT        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TEMP    with tag   %FN%.%DEV%.%IDEN%.TEMP        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.ENABLE  with tag   %FN%.%DEV%.%IDEN%.ENABLE      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.STATUS  with tag   %FN%.%DEV%.%IDEN%.STATUS      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TEST    with tag   %FN%.%DEV%.%IDEN%.TEST        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POLL_EN with tag   %FN%.%DEV%.%IDEN%.POLL_EN     device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UOUTSTT with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.UBATSTT with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.OVERSTT with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.LOWSTT  with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.REPBAT  with tag   %FN%.%DEV%.%IDEN%.STATE       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.INDIC   with tag   %FN%.%DEV%.%IDEN%.INDIC       device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.ITSELF  with tag   %FN%.%DEV%.%IDEN%.ITSELF      device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.NAME    with tag   %FN%.%DEV%.%IDEN%.NAME        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.POLL    with tag   %FN%.%DEV%.%IDEN%.POLLRATE    device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %DEV%.TITLE   with                                        device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=335^|Height=716
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HOME @WinDraw %FN%.%DEV%.%IDEN%.CTRL^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SHOW @WinShow %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.HIDE @WinHide %FN%.%DEV%.%IDEN%.CTRL
echo @cron.tab %FN%.%DEV%.%IDEN%.CTRL.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.CTRL.SELECT @WinSelect %FN%.%DEV%.%IDEN%.CTRL
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.CTRL.HIDE
echo []
echo [%FN%.MAIN.CTRL]
echo Link sensor @cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT with device ^&%FN%.MAIN.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.STATUS    with tag %FN%.%DEV%.%IDEN%.STATUS  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link sensor %FN%.%DEV%.%IDEN%.ENABLE    with tag %FN%.%DEV%.%IDEN%.ENABLE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo Link Sensor SYSTEMMODE                  with tag %FN%.%DEV%.%IDEN%.SERVMODE  device ^&%FN%.%DEV%.%IDEN%.CTRL
echo []
echo [Windows]
echo %FN%.%DEV%.%IDEN%.PARAM.PLOT = Curve_Window
echo [%FN%.%DEV%.%IDEN%.PARAM.PLOT]
echo AxisX = ^^R{Hours}___^^N^^CTime, 0, 0.25
echo AxisY = ^^CState channel^^N^^L___{Status}, 0, 1000
echo CurveList = %FN%.%DEV%.%IDEN%.UINP
echo CurveList = %FN%.%DEV%.%IDEN%.FREQ
echo CurveList = %FN%.%DEV%.%IDEN%.UOUT
echo CurveList = %FN%.%DEV%.%IDEN%.UBAT
echo CurveList = %FN%.%DEV%.%IDEN%.VBAT
echo CurveList = %FN%.%DEV%.%IDEN%.CBAT
echo CurveList = %FN%.%DEV%.%IDEN%.POUT
echo CurveList = %FN%.%DEV%.%IDEN%.TEMP
echo CurveList = %FN%.%DEV%.%IDEN%.STATE
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS
echo CurveList = %FN%.%DEV%.%IDEN%.POLL
echo []
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME @WinDraw %FN%.%DEV%.%IDEN%.PARAM.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SHOW @WinShow %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE @WinHide %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.tab %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT 0 0 0
echo @cron.job %FN%.%DEV%.%IDEN%.PARAM.PLOT.SELECT @WinSelect %FN%.%DEV%.%IDEN%.PARAM.PLOT
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HOME
echo @cron.job %FN%.MAIN.CTRL.HOME @cron.run %FN%.%DEV%.%IDEN%.PARAM.PLOT.HIDE
echo []
echo [^&DATSRV]
echo CurveList = %FN%.%DEV%.%IDEN%.UINP
echo CurveList = %FN%.%DEV%.%IDEN%.FREQ
echo CurveList = %FN%.%DEV%.%IDEN%.UOUT
echo CurveList = %FN%.%DEV%.%IDEN%.UBAT
echo CurveList = %FN%.%DEV%.%IDEN%.VBAT
echo CurveList = %FN%.%DEV%.%IDEN%.CBAT
echo CurveList = %FN%.%DEV%.%IDEN%.POUT
echo CurveList = %FN%.%DEV%.%IDEN%.TEMP
echo CurveList = %FN%.%DEV%.%IDEN%.STATE
echo CurveList = %FN%.%DEV%.%IDEN%.STATUS
echo CurveList = %FN%.%DEV%.%IDEN%.POLL
echo []
goto :EOF

:APC_SIM
echo [^&%FN%.%DEV%.%IDEN%.CTRL]
echo Simulator = 1
echo []
rem Include hardware config if one not done yet
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
echo.
goto :EOF

:APC_DIS
unix dimcfg ^
  -n section "[&%FN%.%DEV%.%IDEN%.CTRL]" ^
  -n print    DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dis_cmnd   %FCP%/%DEV%/%IDEN%/DIMCMDMY ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMCMDMY ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DIMCMDMY=%%**" ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMCMDMY ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/POLL_EN ^
  -n tag        %FN%.%DEV%.%IDEN%.POLL_EN ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/ENABLE ^
  -n tag        %FN%.%DEV%.%IDEN%.ENABLE ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/TEST ^
  -n tag        %FN%.%DEV%.%IDEN%.TEST ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/STATUS ^
  -n tag        %FN%.%DEV%.%IDEN%.STATUS ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/INDIC ^
  -n tag        %FN%.%DEV%.%IDEN%.INDIC ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/ITSELF ^
  -n tag        %FN%.%DEV%.%IDEN%.ITSELF ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/NAME ^
  -n tag        %FN%.%DEV%.%IDEN%.NAME ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/UINP ^
  -n tag        %FN%.%DEV%.%IDEN%.UINP ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/FREQ ^
  -n tag        %FN%.%DEV%.%IDEN%.FREQ ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/UOUT ^
  -n tag        %FN%.%DEV%.%IDEN%.UOUT ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/UBAT ^
  -n tag        %FN%.%DEV%.%IDEN%.UBAT ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/VBAT ^
  -n tag        %FN%.%DEV%.%IDEN%.VBAT ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/CBAT ^
  -n tag        %FN%.%DEV%.%IDEN%.CBAT ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/POUT ^
  -n tag        %FN%.%DEV%.%IDEN%.POUT ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/TEMP ^
  -n tag        %FN%.%DEV%.%IDEN%.TEMP ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/STATE ^
  -n tag        %FN%.%DEV%.%IDEN%.STATE ^
  -n end ^
  -n dis_info   %FCP%/%DEV%/%IDEN%/POLLRATE ^
  -n tag        %FN%.%DEV%.%IDEN%.POLLRATE ^
  -n end ^
  -n
echo.
goto :EOF

:APC_DIC
unix dimcfg ^
  -n section "[&%FN%.%DEV%.%IDEN%.CTRL]" ^
  -n print    DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMGUICLICK ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMGUICLICK ^
  -n end ^
  -n dic_cmnd   %FCP%/%DEV%/%IDEN%/DIMCMDMY ^
  -n tag        %FN%.%DEV%.%IDEN%.DIMCMDMY ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/POLL_EN ^
  -n tag        %FN%.%DEV%.%IDEN%.POLL_EN ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.POLL_EN" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/ENABLE ^
  -n tag        %FN%.%DEV%.%IDEN%.ENABLE ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.ENABLE" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/TEST ^
  -n tag        %FN%.%DEV%.%IDEN%.TEST ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.TEST" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/STATUS ^
  -n tag        %FN%.%DEV%.%IDEN%.STATUS ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.STATUS" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/INDIC ^
  -n tag        %FN%.%DEV%.%IDEN%.INDIC ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.INDIC" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/ITSELF ^
  -n tag        %FN%.%DEV%.%IDEN%.ITSELF ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.ITSELF" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/NAME ^
  -n tag        %FN%.%DEV%.%IDEN%.NAME ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.NAME" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/UINP ^
  -n tag        %FN%.%DEV%.%IDEN%.UINP ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.UINP" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/FREQ ^
  -n tag        %FN%.%DEV%.%IDEN%.FREQ ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.FREQ" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/UOUT ^
  -n tag        %FN%.%DEV%.%IDEN%.UOUT ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.UOUT" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/UBAT ^
  -n tag        %FN%.%DEV%.%IDEN%.UBAT ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.UBAT" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/VBAT ^
  -n tag        %FN%.%DEV%.%IDEN%.VBAT ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.VBAT" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/CBAT ^
  -n tag        %FN%.%DEV%.%IDEN%.CBAT ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.CBAT" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/POUT ^
  -n tag        %FN%.%DEV%.%IDEN%.POUT ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.POUT" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/TEMP ^
  -n tag        %FN%.%DEV%.%IDEN%.TEMP ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.TEMP" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/STATE ^
  -n tag        %FN%.%DEV%.%IDEN%.STATE ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.STATE" ^
  -n end ^
  -n dic_info   %FCP%/%DEV%/%IDEN%/POLLRATE ^
  -n tag        %FN%.%DEV%.%IDEN%.POLLRATE ^
  -n %devmsg% "&%FN%.%DEV%.%IDEN%.CTRL @DimTagUpdate=%FN%.%DEV%.%IDEN%.POLLRATE" ^
  -n end ^
  -n
echo.
goto :EOF

:APC_TABCRC
set /a YPOS=TABCRC_TOP+80
echo [SensorList]
echo Sensor = @cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT
echo [@cron+@cron.run+%FN%.%DEV%.%IDEN%.CTRL.SELECT]
echo Pos = 10, %YPOS%
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:18
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_12_20_24_lightsteelblue1_ptmono.bmp %DevLabel%
echo Hint = %FN%.%DEV%.%IDEN%.CTRL: Открыть окно управления %IDEN%
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.STATUS
echo [%FN%.%DEV%.%IDEN%.STATUS]
echo Pos = 220, %YPOS%
echo Painter(v) = (glBorderBevel=2)+(glBorderColor=clGray)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:18
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_silver_ptmono.bmp ВЫКЛЮЧЕН
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_lime_ptmono.bmp   ОТ+СЕТИ
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_yellow_ptmono.bmp ОТ+БАТ.
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    WARNING
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    REFUSED
echo Tag#6 = 5, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_red_ptmono.bmp    TIMEOUT
echo Tag#7 = 6, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_9_20_24_yellow_ptmono.bmp SIMULATOR
echo Hint = %FN%.%DEV%.%IDEN%.STATE: Состояние устройства
echo []
echo [SensorList]
echo Sensor = %FN%.%DEV%.%IDEN%.ENABLE
echo [%FN%.%DEV%.%IDEN%.ENABLE]
echo Pos = 380, %YPOS%
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=2)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:14
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_7_20_24_silver_ptmono.bmp Вкл.UPS
echo Tag#2 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_7_20_24_lime_ptmono.bmp   Выкл.UPS
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_7_20_24_yellow_ptmono.bmp Выкл-ие
echo Tag#4 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\ledbmp_7_20_24_yellow_ptmono.bmp Вкл-ие
echo Hint = %FN%.%DEV%.%IDEN%.ENABLE: Вкл/выкл %DEV%.%IDEN%
echo []
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF
