@echo off
SetLocal EnableExtensions EnableDelayedExpansion

rem *****************************
rem AKIP devices config generator
rem *****************************

:Main 
cls
call :InitializeVariables
pushd "%~dp0" && call :AKIPDevices
popd
echo Done.
unix sleep 6
goto :EOF

:InitializeVariables
set hdwcfg=%~n0_hdw.cfg
set simcfg=%~n0_sim.cfg
set diccfg=%~n0_dic.cfg
set discfg=%~n0_dis.cfg
set devmsg=devPostMsg
set tabcrc=..\Circuits\%~n0_link.crc
set /a numhdwcfg=0
set /a CTRL_TOP=0
set /a CTRL_LEFT=840
set /a CTRL_TOP_STEP=70
set /a CTRL_TOP_STEP_PAR=150
set /a TABCRC_TOP=35
set /a TABCRC_STEP=70
set fileprefix=
set mainprefix=AKIP
set mode=online & ::   
goto :EOF

:AKIPDevices
call :DeleteFiles %hdwcfg% %simcfg% %diccfg% %discfg% %tabcrc%
rem  Device Facility                Identifier HostName     Polling TimeOut
call :AKIP  PRGK100.PRPI1.AKIP      OSC0       172.21.4.209 50      1000
::type %hdwcfg% %simcfg% %diccfg% %discfg%
goto :EOF

:AKIP
call :AKIP_SET %*
call :AKIP_HDW %*        >> %hdwcfg%
call :AKIP_SIM %*        >> %simcfg%
call :AKIP_TABCRC        >> %tabcrc%
call :AKIP_DIC %*        >> %diccfg%
call :AKIP_DIS %*        >> %discfg%
set /a CTRL_TOP+=CTRL_TOP_STEP
set /a CTRL_LEFT_CALC+=CTRL_LEFT
goto :EOF

:AKIP_SET
set "FN=%~1"       &shift & :: Facility name
set "ID=%~1"       &shift & :: Identifier
set "HostName=%~1" &shift & :: Host Name
set "Polling=%~1"  &shift & :: Polling
set "TimeOut=%~1"  &shift & :: Time Out
set "FNF=%FN:.=_%"        & :: Facility   file name, i.e. FN name with . to _ replacement
set "FNP=%FN:.=/%"        & :: Facility   DIM  name, i.e. FN name with . to / replacement
set "IDF=%ID:.=_%"        & :: Identifier file name, i.e. ID name with . to _ replacement
set "IDP=%ID:.=/%"        & :: Identifier DIM  name, i.e. ID name with . to / replacement
goto :EOF

:AKIP_HDW
echo ;**********************
echo ; Driver for %FN%.%ID%
echo ;**********************
echo [DeviceList]
echo ^&%FN%.%ID%.CTRL = device software program
echo [^&%FN%.%ID%.CTRL]
echo Comment          = Hardware driver for AKIP device
echo InquiryPeriod    = 0
echo DevicePolling    = 10, tpHigher
echo ProgramSource    = ..\DaqPas\%fileprefix%akip_drv.pas
echo DigitalFifo      = 1024
echo AnalogFifo       = 1024
echo DebugFlags       = 3
echo OpenConsole      = 1
echo Simulator        = 0
echo PipeTimeOut      = %TimeOut%
echo PipeTimeGap      = 0
echo PollPeriod       = %Polling%
echo DefaultBaseDir   = ..\..\%mainprefix%_DATA\Experiment\Common\
echo DefaultExpDir    = test1\
echo WaveTimeOut      = 60000
echo WatchDogDeadline = 150000
echo HostName         = %HostName%
echo TCPPort          = 5025
echo tagPrefix        = %FN%.%ID%
echo filePrefix       = %IDF%
echo HelpFile         = ..\Help\akip.htm
echo EncryptMethod    = RC6
echo TrustedUsers     = [TrustedUsers]
echo CalcDevName      = ^&%FN%.%ID%.CALC
echo AnalogOutputs    = 15
echo Link AnalogOutput 0  with curve %FN%.%ID%.ACQ.POIN        history 1000
echo Link AnalogOutput 1  with curve %FN%.%ID%.ACQ.SMPLRT      history 1000
echo Link AnalogOutput 2  with curve %FN%.%ID%.CN1.SCAL        history 1000
echo Link AnalogOutput 3  with curve %FN%.%ID%.CN2.SCAL        history 1000
echo Link AnalogOutput 4  with curve %FN%.%ID%.CN3.SCAL        history 1000
echo Link AnalogOutput 5  with curve %FN%.%ID%.CN4.SCAL        history 1000
echo Link AnalogOutput 6  with curve %FN%.%ID%.TIM.DEL         history 1000
echo Link AnalogOutput 7  with curve %FN%.%ID%.TIM.SCAL        history 1000
echo Link AnalogOutput 8  with curve %FN%.%ID%.TRIG.EDGE.HLDEV history 1000
echo Link AnalogOutput 9  with curve %FN%.%ID%.TRIG.EDGE.HLDT  history 1000
echo Link AnalogOutput 10 with curve %FN%.%ID%.TRIG.EDGE.LEV   history 1000
echo Link AnalogOutput 11 with curve %FN%.%ID%.WAV.INT         history 1000
echo Link AnalogOutput 12 with curve %FN%.%ID%.WAV.MAXP        history 1000
echo Link AnalogOutput 13 with curve %FN%.%ID%.WAV.POIN        history 1000
echo Link AnalogOutput 14 with curve %FN%.%ID%.WAV.STAR        history 1000
echo DigitalOutputs = 2
echo Link DigitalOutput 0 with curve %FN%.%ID%.POLL.RATE       history 1000
echo Link DigitalOutput 1 with curve %FN%.%ID%.ERROR.CNT       history 1000
echo ;------ Save custom parameters to INI file
echo CustomIniTagList  = [%FN%.%ID%.CustomParameters.TagList]
echo CustomIniFileRef  = ..\Data\%FNF%_%IDF%_custom.ini
echo CustomIniSection  = [%FN%.%ID%.CustomParameters]
echo CustomIniBackups  = ..\..\%mainprefix%_DATA\%FNF%_%IDF%\Custom
echo CustomIniAutoLoad = 0
echo CustomIniAutoSave = 0
echo []
echo.
echo [ConfigFileList]
echo ConfigFile = ..\Data\%FNF%_%IDF%_custom.ini
echo []
echo.
echo [%FN%.%ID%.CustomParameters.TagList]
echo TagList = %FN%.%ID%.POLL.ENABLE
echo TagList = %FN%.%ID%.ACQ.MDEP
echo TagList = %FN%.%ID%.ACQ.POIN
echo TagList = %FN%.%ID%.ACQ.SEQ
echo TagList = %FN%.%ID%.ACQ.SMPLRT
echo TagList = %FN%.%ID%.ACQ.TYP
echo TagList = %FN%.%ID%.CN1.COUP
echo TagList = %FN%.%ID%.CN2.COUP
echo TagList = %FN%.%ID%.CN3.COUP
echo TagList = %FN%.%ID%.CN4.COUP
echo TagList = %FN%.%ID%.CN1.IMP
echo TagList = %FN%.%ID%.CN2.IMP
echo TagList = %FN%.%ID%.CN3.IMP
echo TagList = %FN%.%ID%.CN4.IMP
echo TagList = %FN%.%ID%.CN1.OFFS
echo TagList = %FN%.%ID%.CN2.OFFS
echo TagList = %FN%.%ID%.CN3.OFFS
echo TagList = %FN%.%ID%.CN4.OFFS
echo TagList = %FN%.%ID%.CN1.SCAL
echo TagList = %FN%.%ID%.CN2.SCAL
echo TagList = %FN%.%ID%.CN3.SCAL
echo TagList = %FN%.%ID%.CN4.SCAL
echo TagList = %FN%.%ID%.CN1.SWIT
echo TagList = %FN%.%ID%.CN2.SWIT
echo TagList = %FN%.%ID%.CN3.SWIT
echo TagList = %FN%.%ID%.CN4.SWIT
echo TagList = %FN%.%ID%.TIM.DEL
echo TagList = %FN%.%ID%.TIM.SCAL
echo TagList = %FN%.%ID%.TRIG.MODE
echo TagList = %FN%.%ID%.TRIG.TYP
echo TagList = %FN%.%ID%.TRIG.EDGE.COUP
echo TagList = %FN%.%ID%.TRIG.EDGE.HLDEV
echo TagList = %FN%.%ID%.TRIG.EDGE.HLDT
echo TagList = %FN%.%ID%.TRIG.EDGE.HOLD
echo TagList = %FN%.%ID%.TRIG.EDGE.HST
echo TagList = %FN%.%ID%.TRIG.EDGE.LEV
echo TagList = %FN%.%ID%.TRIG.EDGE.NREJ
echo TagList = %FN%.%ID%.TRIG.EDGE.SLOP
echo TagList = %FN%.%ID%.TRIG.EDGE.SOUR
echo TagList = %FN%.%ID%.WAV.INT
echo TagList = %FN%.%ID%.WAV.POIN
echo TagList = %FN%.%ID%.WAV.SOUR
echo TagList = %FN%.%ID%.WAV.STAR
echo TagList = %FN%.%ID%.WAV.WIDT
echo TagList = %FN%.%ID%.CHECK.CURVE
echo TagList = %FN%.%ID%.MODECALCDEV
echo []
echo.
echo [TagList]
echo %FN%.%ID%.DIMGUICLICK     = String  ? ; The DIM click sensor data
echo %FN%.%ID%.DIMCMDMY        = String  ? ; The DIM command handler
echo %FN%.%ID%.CLOCK           = String  ? ; Server time
echo %FN%.%ID%.SERVID          = String  ? ; Server id
echo %FN%.%ID%.POLL.ENABLE     = Integer 1 ; Enable polling flag
echo %FN%.%ID%.POLL.RATE       = Integer 0 ; Polling rate, poll/sec
echo %FN%.%ID%.ERROR.CNT       = Integer 0 ; Device error counter
echo %FN%.%ID%.IDENT           = String  ? ; Identifies the instrument type and software version
echo %FN%.%ID%.OPC             = Integer 0 ; Places an ASCII "1" when all pending device operations have completed
echo %FN%.%ID%.AUT             = Integer 0 ; Automatically adjust trigger
echo %FN%.%ID%.ACQ.MDEP        = String  0 ; Maximum memory depth
echo %FN%.%ID%.ACQ.POIN        = Real    0 ; Number sampled points curent waveform
echo %FN%.%ID%.ACQ.SEQ         = Integer 0 ; Sequence acquisition mode
echo %FN%.%ID%.ACQ.SMPLRT      = Real    0 ; Curent sampling rate
echo %FN%.%ID%.ACQ.TYP         = String  0 ; Type data acquisition 
echo %FN%.%ID%.CN1.COUP        = String  0 ; Coupling mode 1 channel
echo %FN%.%ID%.CN2.COUP        = String  0 ; Coupling mode 2 channel
echo %FN%.%ID%.CN3.COUP        = String  0 ; Coupling mode 3 channel
echo %FN%.%ID%.CN4.COUP        = String  0 ; Coupling mode 4 channel
echo %FN%.%ID%.CN1.IMP         = String  0 ; Impedance setting 1 channel
echo %FN%.%ID%.CN2.IMP         = String  0 ; Impedance setting 2 channel
echo %FN%.%ID%.CN3.IMP         = String  0 ; Impedance setting 3 channel
echo %FN%.%ID%.CN4.IMP         = String  0 ; Impedance setting 4 channel
echo %FN%.%ID%.CN1.SCAL        = Real    0 ; Vertical sensitivity 1 channel
echo %FN%.%ID%.CN2.SCAL        = Real    0 ; Vertical sensitivity 2 channel
echo %FN%.%ID%.CN3.SCAL        = Real    0 ; Vertical sensitivity 3 channel
echo %FN%.%ID%.CN4.SCAL        = Real    0 ; Vertical sensitivity 4 channel
echo %FN%.%ID%.CN1.OFFS        = Real    0 ; Vertical offset 1 channel
echo %FN%.%ID%.CN2.OFFS        = Real    0 ; Vertical offset 2 channel
echo %FN%.%ID%.CN3.OFFS        = Real    0 ; Vertical offset 3 channel
echo %FN%.%ID%.CN4.OFFS        = Real    0 ; Vertical offset 4 channel
echo %FN%.%ID%.CN1.SWIT        = Integer 0 ; Display function of the channel 1
echo %FN%.%ID%.CN2.SWIT        = Integer 0 ; Display function of the channel 2
echo %FN%.%ID%.CN3.SWIT        = Integer 0 ; Display function of the channel 3
echo %FN%.%ID%.CN4.SWIT        = Integer 0 ; Display function of the channel 4
echo %FN%.%ID%.CN1.WAVFORM     = String  0 ; WaveForm for Channel 1
echo %FN%.%ID%.CN2.WAVFORM     = String  0 ; WaveForm for Channel 2
echo %FN%.%ID%.CN3.WAVFORM     = String  0 ; WaveForm for Channel 3
echo %FN%.%ID%.CN4.WAVFORM     = String  0 ; WaveForm for Channel 4
echo %FN%.%ID%.TIM.DEL         = Real    0 ; Main timebase delay
echo %FN%.%ID%.TIM.SCAL        = Real    0 ; Horizontal scale
echo %FN%.%ID%.TRIG.MODE       = String  0 ; Mode trigger
echo %FN%.%ID%.TRIG.RUN        = Integer 0 ; Oscilloscope run
echo %FN%.%ID%.TRIG.STAT       = String  0 ; Status trigger
echo %FN%.%ID%.TRIG.STOP       = Integer 0 ; Oscilloscope stop
echo %FN%.%ID%.TRIG.TYP        = String  0 ; Type trigger
echo %FN%.%ID%.TRIG.EDGE.COUP  = String  0 ; Coupling mode edge trigger
echo %FN%.%ID%.TRIG.EDGE.HLDEV = Integer 0 ; Number holdoff events edge trigger
echo %FN%.%ID%.TRIG.EDGE.HLDT  = Real    0 ; Holdoff time edge trigger
echo %FN%.%ID%.TRIG.EDGE.HOLD  = String  0 ; Holdoff type edge trigger
echo %FN%.%ID%.TRIG.EDGE.HST   = String  0 ; Initial position edge trigger holdoff
echo %FN%.%ID%.TRIG.EDGE.LEV   = Real    0 ; Trigger level edge trigger
echo %FN%.%ID%.TRIG.EDGE.NREJ  = Integer 0 ; State noise rejection
echo %FN%.%ID%.TRIG.EDGE.SLOP  = String  0 ; Slope edge trigger
echo %FN%.%ID%.TRIG.EDGE.SOUR  = String  0 ; Trigger source edge trigger
echo %FN%.%ID%.WAV.SOUR        = String  0 ; Source waveform 
echo %FN%.%ID%.WAV.STAR        = Integer 0 ; Starting data point waveform
echo %FN%.%ID%.WAV.INT         = Integer 0 ; Interval between data points waveform
echo %FN%.%ID%.WAV.POIN        = Integer 0 ; Number waveform points
echo %FN%.%ID%.WAV.MAXP        = Integer 0 ; Maximum points one piece
echo %FN%.%ID%.WAV.WIDT        = String  0 ; Current output format for transfer waveform data
echo %FN%.%ID%.WAV.DATA        = Integer 0 ; Waveform data
echo %FN%.%ID%.BASEDIR         = String  0 ; Base catalog directory
echo %FN%.%ID%.EXPDIR          = String  0 ; Experiment directory
echo %FN%.%ID%.EXTRACTNUM      = String  0 ; Extraction number
echo %FN%.%ID%.MODECALCDEV     = Integer 0 ; Status calculate device
echo %FN%.%ID%.FILENAME        = String  - ; Name handling file
echo %FN%.%ID%.FILENAMEBTN     = Integer 0 ; Chose handling file
echo %FN%.%ID%.WAV.COPY        = Integer 0 ; Copy processed information
echo %FN%.%ID%.CALCUL          = Integer 0 ; Calculate selected file
echo %FN%.%ID%.DRAW.CURVE      = Integer 0 ; Drawing curve wave form
echo %FN%.%ID%.CHECK.CURVE     = Integer 0 ; Check automatical drawing curve
echo %FN%.%ID%.TIMDELAY        = Real    0 ; Time delay
echo %FN%.%ID%.TIMSCALE        = Real    0 ; Time scale
echo %FN%.%ID%.ACQSMPLRTE      = Real    0 ; Acquire sampling rate
echo %FN%.%ID%.CN1.SCALE       = Real    0 ; Vertical sensitivity 1 channel (loadable)
echo %FN%.%ID%.CN1.OFFSET      = Real    0 ; Vertical offset 1 channel (loadable)
echo %FN%.%ID%.CN2.SCALE       = Real    0 ; Vertical sensitivity 2 channel (loadable)
echo %FN%.%ID%.CN2.OFFSET      = Real    0 ; Vertical offset 2 channel (loadable)
echo %FN%.%ID%.CN3.SCALE       = Real    0 ; Vertical sensitivity 3 channel (loadable)
echo %FN%.%ID%.CN3.OFFSET      = Real    0 ; Vertical offset 3 channel (loadable)
echo %FN%.%ID%.CN4.SCALE       = Real    0 ; Vertical sensitivity 4 channel (loadable)
echo %FN%.%ID%.CN4.OFFSET      = Real    0 ; Vertical offset 4 channel (loadable)
echo %FN%.%ID%.WAVESAVESTT     = Integer 0 ; Status waveforms copy and save
echo %FN%.%ID%.STATUS          = Integer 0 ; Driver status
echo %FN%.%ID%.DEF.DIRBASE     = String  0 ; Default base catalog directory
echo %FN%.%ID%.DEF.DIREXP      = String  0 ; Default experiment directory
echo []
echo.
echo [DataStorage]
echo %FN%.%ID%.POLL.RATE       = Curve 0 10 Black   15 1
echo %FN%.%ID%.ERROR.CNT       = Curve 0 10 Black   15 1
echo %FN%.%ID%.ACQ.POIN        = Curve 0 10 Black   15 1
echo %FN%.%ID%.ACQ.SMPLRT      = Curve 0 10 Black   15 1
echo %FN%.%ID%.CN1.SCAL        = Curve 0 10 Black   15 1
echo %FN%.%ID%.CN2.SCAL        = Curve 0 10 Black   15 1
echo %FN%.%ID%.CN3.SCAL        = Curve 0 10 Black   15 1
echo %FN%.%ID%.CN4.SCAL        = Curve 0 10 Black   15 1
echo %FN%.%ID%.TIM.DEL         = Curve 0 10 Black   15 1
echo %FN%.%ID%.TIM.SCAL        = Curve 0 10 Black   15 1
echo %FN%.%ID%.TRIG.EDGE.HLDEV = Curve 0 10 Black   15 1
echo %FN%.%ID%.TRIG.EDGE.HLDT  = Curve 0 10 Black   15 1
echo %FN%.%ID%.TRIG.EDGE.LEV   = Curve 0 10 Black   15 1
echo %FN%.%ID%.WAV.INT         = Curve 0 10 Black   15 1
echo %FN%.%ID%.WAV.MAXP        = Curve 0 10 Black   15 1
echo %FN%.%ID%.WAV.POIN        = Curve 0 10 Black   15 1
echo %FN%.%ID%.WAV.STAR        = Curve 0 10 Black   15 1
echo %FN%.%ID%.CN1.WAVEPOINT   = Curve 0 10 Yellow  15 1
echo %FN%.%ID%.CN2.WAVEPOINT   = Curve 0 10 Magenta 15 1
echo %FN%.%ID%.CN3.WAVEPOINT   = Curve 0 10 Blue    15 1
echo %FN%.%ID%.CN4.WAVEPOINT   = Curve 0 10 Green   15 1
echo %FN%.%ID%.STATUS          = Curve 0 10 Black   15 1
echo []
echo.
echo [Windows]
echo %FN%.%ID%.PARAM = Circuit_Window
echo [%FN%.%ID%.PARAM]
echo Circuit = ..\Circuits\%fileprefix%akip_ctrl_param.crc
echo Link sensor AKIP.CLOCK                with tag %FN%.%ID%.CLOCK           device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.SERVID               with tag %FN%.%ID%.SERVID          device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.POLL.ENABLE          with tag %FN%.%ID%.POLL.ENABLE     device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.ERROR.CNT            with tag %FN%.%ID%.ERROR.CNT       device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.POLL.RATE            with tag %FN%.%ID%.POLL.RATE       device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.IDENT                with tag %FN%.%ID%.IDENT           device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.RUN             with tag %FN%.%ID%.TRIG.RUN        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.STOP            with tag %FN%.%ID%.TRIG.STOP       device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN1.COUP             with tag %FN%.%ID%.CN1.COUP        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN2.COUP             with tag %FN%.%ID%.CN2.COUP        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN3.COUP             with tag %FN%.%ID%.CN3.COUP        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN4.COUP             with tag %FN%.%ID%.CN4.COUP        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN1.IMP              with tag %FN%.%ID%.CN1.IMP         device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN2.IMP              with tag %FN%.%ID%.CN2.IMP         device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN3.IMP              with tag %FN%.%ID%.CN3.IMP         device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN4.IMP              with tag %FN%.%ID%.CN4.IMP         device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN1.SCAL             with tag %FN%.%ID%.CN1.SCAL        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN2.SCAL             with tag %FN%.%ID%.CN2.SCAL        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN3.SCAL             with tag %FN%.%ID%.CN3.SCAL        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN4.SCAL             with tag %FN%.%ID%.CN4.SCAL        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN1.OFFS             with tag %FN%.%ID%.CN1.OFFS        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN2.OFFS             with tag %FN%.%ID%.CN2.OFFS        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN3.OFFS             with tag %FN%.%ID%.CN3.OFFS        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN4.OFFS             with tag %FN%.%ID%.CN4.OFFS        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN1.SWIT             with tag %FN%.%ID%.CN1.SWIT        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN2.SWIT             with tag %FN%.%ID%.CN2.SWIT        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN3.SWIT             with tag %FN%.%ID%.CN3.SWIT        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.CN4.SWIT             with tag %FN%.%ID%.CN4.SWIT        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.ACQ.MDEP             with tag %FN%.%ID%.ACQ.MDEP        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.ACQ.TYP              with tag %FN%.%ID%.ACQ.TYP         device ^&%FN%.%ID%.CTRL
echo link sensor AKIP.ACQ.SEQ              with tag %FN%.%ID%.ACQ.SEQ         device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.ACQ.POIN             with tag %FN%.%ID%.ACQ.POIN        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.STAT            with tag %FN%.%ID%.TRIG.STAT       device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TIM.SCAL             with tag %FN%.%ID%.TIM.SCAL        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TIM.DEL              with tag %FN%.%ID%.TIM.DEL         device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.WAV.MAXP             with tag %FN%.%ID%.WAV.MAXP        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.COUP       with tag %FN%.%ID%.TRIG.EDGE.COUP  device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.HOLD       with tag %FN%.%ID%.TRIG.EDGE.HOLD  device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.HST        with tag %FN%.%ID%.TRIG.EDGE.HST   device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.WAV.SOUR             with tag %FN%.%ID%.WAV.SOUR        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.NREJ       with tag %FN%.%ID%.TRIG.EDGE.NREJ  device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.LEV        with tag %FN%.%ID%.TRIG.EDGE.LEV   device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.HLDT       with tag %FN%.%ID%.TRIG.EDGE.HLDT  device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.HLDEV      with tag %FN%.%ID%.TRIG.EDGE.HLDEV device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.SLOP       with tag %FN%.%ID%.TRIG.EDGE.SLOP  device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.WAV.WIDT             with tag %FN%.%ID%.WAV.WIDT        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.WAV.STAR             with tag %FN%.%ID%.WAV.STAR        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.WAV.INT              with tag %FN%.%ID%.WAV.INT         device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.WAV.POIN             with tag %FN%.%ID%.WAV.POIN        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.TYP             with tag %FN%.%ID%.TRIG.TYP        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.MODE            with tag %FN%.%ID%.TRIG.MODE       device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.TRIG.EDGE.SOUR       with tag %FN%.%ID%.TRIG.EDGE.SOUR  device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.WAV.DATA             with tag %FN%.%ID%.WAV.DATA        device ^&%FN%.%ID%.CTRL
echo Link sensor AKIP.DEF.BASE.DIR         with tag %FN%.%ID%.DEF.DIRBASE     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.DEF.EXP.DIR          with tag %FN%.%ID%.DEF.DIREXP      device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.COPY.BASE.DIR        with tag %FN%.%ID%.BASEDIR         device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.COPY.EXP.DIR         with tag %FN%.%ID%.EXPDIR          device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.OSC.FILE.NAME        with tag %FN%.%ID%.FILENAME        device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.SELECT.FILE          with tag %FN%.%ID%.FILENAMEBTN     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.STATUS.GET.DATA      with tag %FN%.%ID%.WAVESAVESTT     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.STATUS.SAVE.OSC.FILE with tag %FN%.%ID%.WAVESAVESTT     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.STATUS.SAVE.CSV.FILE with tag %FN%.%ID%.WAVESAVESTT     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.STATUS.COPY.OSC.FILE with tag %FN%.%ID%.WAVESAVESTT     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.STATUS.COPY.CSV.FILE with tag %FN%.%ID%.WAVESAVESTT     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.WAV.CALC             with tag %FN%.%ID%.CALCUL          device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.WAV.COPY             with tag %FN%.%ID%.WAV.COPY        device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.STATUS.DEVICE        with tag %FN%.%ID%.MODECALCDEV     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.DRAW.CURVE           with tag %FN%.%ID%.DRAW.CURVE      device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.CHECK.CURVE          with tag %FN%.%ID%.CHECK.CURVE     device ^&%FN%.%ID%.CALC
echo Link sensor AKIP.TOOLS                                              with device ^&%FN%.%ID%.CTRL
echo []
echo.
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%ID%.PARAM.HOME 0 0 0
echo @cron.job %FN%.%ID%.PARAM.HOME @WinShow %FN%.%ID%.PARAM
echo @cron.job %FN%.%ID%.PARAM.HOME @WinDraw %FN%.%ID%.PARAM^|Left=%CTRL_LEFT%^|Top=%CTRL_TOP%^|Width=820^|Height=600
echo @cron.job %FN%.%ID%.PARAM.HOME @WinDraw %FN%.%ID%.PARAM^|Options=-Min,-Max,+Close,-VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%ID%.PARAM.HOME @WinDraw %FN%.%ID%.PARAM^|Options=+Top,+Left,+Width,+Height
echo @cron.tab %FN%.%ID%.PARAM.SHOW 0 0 0
echo @cron.job %FN%.%ID%.PARAM.SHOW @WinShow %FN%.%ID%.PARAM
echo @cron.tab %FN%.%ID%.PARAM.HIDE 0 0 0
echo @cron.job %FN%.%ID%.PARAM.HIDE @WinHide %FN%.%ID%.PARAM
echo @cron.tab %FN%.%ID%.PARAM.SELECT 0 0 0
echo @cron.job %FN%.%ID%.PARAM.SELECT @WinSelect %FN%.%ID%.PARAM
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FN%.%ID%.PARAM.HOME
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FN%.%ID%.PARAM.HIDE
echo []
echo.
echo [%mainprefix%.MAIN.CTRL]
echo Link sensor @cron+@cron.run+%FN%.%ID%.PARAM.SELECT                      with device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.STATUS             with tag %FN%.%ID%.STATUS           device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.TRIG.STAT          with tag %FN%.%ID%.TRIG.STAT        device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.TYPE               with tag %FN%.%ID%.TRIG.TYP         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.TRIG.MODE          with tag %FN%.%ID%.TRIG.MODE        device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN1.COUP         with tag %FN%.%ID%.CN1.COUP         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN1.IMP          with tag %FN%.%ID%.CN1.IMP          device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN1.OFFS         with tag %FN%.%ID%.CN1.OFFS         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN1.SCAL         with tag %FN%.%ID%.CN1.SCAL         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN1.SWIT         with tag %FN%.%ID%.CN1.SWIT         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN2.COUP         with tag %FN%.%ID%.CN2.COUP         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN2.IMP          with tag %FN%.%ID%.CN2.IMP          device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN2.OFFS         with tag %FN%.%ID%.CN2.OFFS         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN2.SCAL         with tag %FN%.%ID%.CN2.SCAL         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN2.SWIT         with tag %FN%.%ID%.CN2.SWIT         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN3.COUP         with tag %FN%.%ID%.CN3.COUP         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN3.IMP          with tag %FN%.%ID%.CN3.IMP          device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN3.OFFS         with tag %FN%.%ID%.CN3.OFFS         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN3.SCAL         with tag %FN%.%ID%.CN3.SCAL         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN3.SWIT         with tag %FN%.%ID%.CN3.SWIT         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN4.COUP         with tag %FN%.%ID%.CN4.COUP         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN4.IMP          with tag %FN%.%ID%.CN4.IMP          device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN4.OFFS         with tag %FN%.%ID%.CN4.OFFS         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN4.SCAL         with tag %FN%.%ID%.CN4.SCAL         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.CHAN4.SWIT         with tag %FN%.%ID%.CN4.SWIT         device ^&%FN%.%ID%.CTRL
echo Link sensor %FN%.%ID%.STATUS.GET.DATA    with tag %FN%.%ID%.WAVESAVESTT      device ^&%FN%.%ID%.CALC
echo Link sensor %FN%.%ID%.STATUS.SAVE.OSC    with tag %FN%.%ID%.WAVESAVESTT      device ^&%FN%.%ID%.CALC
echo Link sensor %FN%.%ID%.STATUS.SAVE.CSV    with tag %FN%.%ID%.WAVESAVESTT      device ^&%FN%.%ID%.CALC
echo Link sensor %FN%.%ID%.STATUS.COPY.OSC    with tag %FN%.%ID%.WAVESAVESTT      device ^&%FN%.%ID%.CALC
echo Link sensor %FN%.%ID%.STATUS.COPY.CSV    with tag %FN%.%ID%.WAVESAVESTT      device ^&%FN%.%ID%.CALC
echo []
echo.
echo [^&DATSRV]
echo CurveList = %FN%.%ID%.ACQ.SMPLRT
echo CurveList = %FN%.%ID%.WAV.POIN
echo CurveList = %FN%.%ID%.POLL.RATE
echo CurveList = %FN%.%ID%.ERROR.CNT
echo CurveList = %FN%.%ID%.ACQ.POIN
echo CurveList = %FN%.%ID%.CN1.SCAL
echo CurveList = %FN%.%ID%.CN2.SCAL
echo CurveList = %FN%.%ID%.CN3.SCAL
echo CurveList = %FN%.%ID%.CN4.SCAL
echo CurveList = %FN%.%ID%.TIM.DEL
echo CurveList = %FN%.%ID%.TIM.SCAL
echo CurveList = %FN%.%ID%.TRIG.EDGE.HLDEV
echo CurveList = %FN%.%ID%.TRIG.EDGE.HLDT
echo CurveList = %FN%.%ID%.TRIG.EDGE.LEV
echo CurveList = %FN%.%ID%.WAV.STAR
echo CurveList = %FN%.%ID%.WAV.INT
echo CurveList = %FN%.%ID%.WAV.MAXP
echo CurveList = %FN%.%ID%.STATUS
echo []
echo.
echo [DeviceList]
echo ^&%FN%.%ID%.CALC = device software program
echo [^&%FN%.%ID%.CALC]
echo ProgramSource    = ..\DAQPAS\akip_waveform.pas
echo MainProg         = ^&%FN%.%ID%.CTRL
echo DebugFlags       = 3
echo OpenConsole      = 1
echo WatchDogDeadline = 150000
echo tagPrefix        = %FN%.%ID%
echo filePrefix       = %IDF%
echo CalcDevMode      = %mode%
echo Sim              = 0
echo AnalogOutputs    = 5
echo Link AnalogOutput 0 with curve %FN%.%ID%.CN1.WAVEPOINT history 1000
echo Link AnalogOutput 1 with curve %FN%.%ID%.CN2.WAVEPOINT history 1000
echo Link AnalogOutput 2 with curve %FN%.%ID%.CN3.WAVEPOINT history 1000
echo Link AnalogOutput 3 with curve %FN%.%ID%.CN4.WAVEPOINT history 1000
echo Link AnalogOutput 4 with curve %FN%.%ID%.STATUS        history 1000
echo []
echo.
echo [Windows]
echo %FN%.%ID%.PLOT = Curve_Window
echo [%FN%.%ID%.PLOT]
echo AxisX = ^^R{}___^^N^^C, 0, 0
echo AxisY = ^^C^^N^^L___{%}, 0, 0
echo []
echo.
echo [%FN%.%ID%.PLOT]
echo CurveList = %FN%.%ID%.CN1.WAVEPOINT
echo CurveList = %FN%.%ID%.CN2.WAVEPOINT
echo CurveList = %FN%.%ID%.CN3.WAVEPOINT
echo CurveList = %FN%.%ID%.CN4.WAVEPOINT
echo []
echo.
echo [^&CronSrv.StartupScript]
echo @cron.tab %FN%.%ID%.PLOT.HOME 0 0 0
echo @cron.job %FN%.%ID%.PLOT.HOME @WinShow %FN%.%ID%.PLOT
echo @cron.job %FN%.%ID%.PLOT.HOME @WinDraw %FN%.%ID%.PLOT^|Left=167^|Top=120^|Height=600^|Width=1000
echo @cron.job %FN%.%ID%.PLOT.HOME @WinDraw %FN%.%ID%.PLOT^|Options=-Min,-Max,+Close,+VScroll,-HScroll,+StatusBar
echo @cron.job %FN%.%ID%.PLOT.HOME @WinDraw %FN%.%ID%.PLOT^|Options=+Top,+Left,-Width,-Height
echo @cron.tab %FN%.%ID%.PLOT.SHOW 0 0 0
echo @cron.job %FN%.%ID%.PLOT.SHOW @WinShow %FN%.%ID%.PLOT
echo @cron.tab %FN%.%ID%.PLOT.HIDE 0 0 0
echo @cron.job %FN%.%ID%.PLOT.HIDE @WinHide %FN%.%ID%.PLOT
echo @cron.tab %FN%.%ID%.PLOT.SELECT 0 0 0
echo @cron.job %FN%.%ID%.PLOT.SELECT @WinSelect %FN%.%ID%.PLOT
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FN%.%ID%.PLOT.HOME
echo @cron.job %mainprefix%.MAIN.CTRL.HOME @cron.run %FN%.%ID%.PLOT.HIDE
echo []
goto :EOF

:AKIP_SIM
echo [^&%FN%.%ID%.CTRL]
echo Simulator = 1
echo []
echo [^&%FN%.%ID%.CALC]
echo Sim = 1
echo []
if "%numhdwcfg%" == "0" ( set /a numhdwcfg=numhdwcfg+1 ) else ( goto :EOF )
echo [ConfigFileList]
echo ConfigFile = %hdwcfg%
echo []
goto :EOF

:AKIP_TABCRC
set /a YPOS=TABCRC_TOP+20
set /a YPOSPAR=YPOS+30
set /a YPOSCN2=YPOS+15
set /a YPOSCN3=YPOSCN2+15
set /a YPOSCN4=YPOSCN3+15
echo [Circuit]
echo GeneralMap = ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_800_530_4_silver.bmp
echo Hint =   
echo ToolBarHeight = 0
echo []
echo.
echo [ConfigFileList] ; Include the Painter GUI Library
echo ConfigFile = ~~\Resource\DaqSite\Default\Painter.crc
echo []
echo ;****************
echo ;%FN%.%ID%
echo ;****************
echo [SensorList]
echo Sensor = @cron+@cron.run+%FN%.%ID%.PARAM.SELECT
echo [@cron+@cron.run+%FN%.%ID%.PARAM.SELECT]
echo Pos = 5, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10\Color:Black
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_135_30_24_lightsteelblue1.bmp %ID%
echo Hint = %FN%.%ID%.CTRL -    
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.STATUS
echo [%FN%.%ID%.STATUS]
echo Pos = 145, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:9\Color:Black
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_gray.bmp "Off"
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_lime.bmp "Ok"
echo Tag#3 = 2, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_yellow.bmp "TimeOut"
echo Tag#4 = 3, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_red.bmp "FalseTrig"
echo Tag#5 = 4, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_red.bmp "Refuse"
echo Tag#6 = 5, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_yellow.bmp "Simulator"
echo Tag#7 = 6, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_red.bmp "Warning"
echo Hint = %FN%.%ID%.STATUS -  
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.TRIG.STAT
echo [%FN%.%ID%.TRIG.STAT]
echo Pos = 145, %YPOSPAR%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_30_24_aqua.bmp 
echo Hint = %FN%.%ID%.TRIG.STAT -  
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.TYPE
echo [%FN%.%ID%.TYPE]
echo Pos = 240, %YPOS%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_110_30_24_white.bmp 
echo Hint = %FN%.%ID%.TYPE -    1 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.TRIG.MODE
echo [%FN%.%ID%.TRIG.MODE]
echo Pos = 240, %YPOSPAR%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_110_30_24_white.bmp 
echo Hint = %FN%.%ID%.TRIG.MODE -  
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN1.SWIT
echo [%FN%.%ID%.CHAN1.SWIT]
echo Pos = 355, %YPOS%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_gray.bmp "Channel 1"
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_lime.bmp "Channel 1"
echo Hint = %FN%.%ID%.CHAN1.SWIT - 1   
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN2.SWIT
echo [%FN%.%ID%.CHAN2.SWIT]
echo Pos = 355, %YPOSCN2%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_gray.bmp "Channel 2"
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_lime.bmp "Channel 2"
echo Hint = %FN%.%ID%.CHAN2.SWIT - 2   
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN3.SWIT
echo [%FN%.%ID%.CHAN3.SWIT]
echo Pos = 355, %YPOSCN3%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_gray.bmp "Channel 3"
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_lime.bmp "Channel 3"
echo Hint = %FN%.%ID%.CHAN3.SWIT - 3   
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN4.SWIT
echo [%FN%.%ID%.CHAN4.SWIT]
echo Pos = 355, %YPOSCN4%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo TagEval(v) = isbit(v,0)
echo Painter(v) = (glButtonBit=0)+(glButtonBevel=1)+(glButtonMoveX=1)+(glButtonMoveY=1)
echo Painter(v) = [Painter(v).GuiLib.SimpleButton]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_gray.bmp "Channel 4"
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_lime.bmp "Channel 4"
echo Hint = %FN%.%ID%.CHAN4.SWIT - 4   
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN1.COUP
echo [%FN%.%ID%.CHAN1.COUP]
echo Pos = 445, %YPOS%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN1.COUP -    1 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN2.COUP
echo [%FN%.%ID%.CHAN2.COUP]
echo Pos = 445, %YPOSCN2%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN2.COUP -    2 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN3.COUP
echo [%FN%.%ID%.CHAN3.COUP]
echo Pos = 445, %YPOSCN3%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN3.COUP -    3 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN4.COUP
echo [%FN%.%ID%.CHAN4.COUP]
echo Pos = 445, %YPOSCN4%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN4.COUP -    4 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN1.IMP
echo [%FN%.%ID%.CHAN1.IMP]
echo Pos = 515, %YPOS%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN1.IMP -   1 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN2.IMP
echo [%FN%.%ID%.CHAN2.IMP]
echo Pos = 515, %YPOSCN2%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN2.IMP -   2 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN3.IMP
echo [%FN%.%ID%.CHAN3.IMP]
echo Pos = 515, %YPOSCN3%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN3.IMP -   3 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN4.IMP
echo [%FN%.%ID%.CHAN4.IMP]
echo Pos = 515, %YPOSCN4%
echo LED = 1, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN4.IMP -   4 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN1.OFFS
echo [%FN%.%ID%.CHAN1.OFFS]
echo Pos = 585, %YPOS%
echo LED = 5, 4, 0, %5.4E, Name:PT_Mono\Style:[Bold]\Size:9
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN1.OFFS -   1 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN2.OFFS
echo [%FN%.%ID%.CHAN2.OFFS]
echo Pos = 585, %YPOSCN2%
echo LED = 5, 4, 0, %5.4E, Name:PT_Mono\Style:[Bold]\Size:9
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN2.OFFS -   2 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN3.OFFS
echo [%FN%.%ID%.CHAN3.OFFS]
echo Pos = 585, %YPOSCN3%
echo LED = 5, 4, 0, %5.4E, Name:PT_Mono\Style:[Bold]\Size:9
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN3.OFFS -   3 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN4.OFFS
echo [%FN%.%ID%.CHAN4.OFFS]
echo Pos = 585, %YPOSCN4%
echo LED = 5, 4, 0, %5.4E, Name:PT_Mono\Style:[Bold]\Size:9
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_90_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN4.OFFS -   4 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN1.SCAL
echo [%FN%.%ID%.CHAN1.SCAL]
echo Pos = 675, %YPOS%
echo LED = 1, 2, 0, %1.2g, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN1.SCAL -   1   Volts/div
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN2.SCAL
echo [%FN%.%ID%.CHAN2.SCAL]
echo Pos = 675, %YPOSCN2%
echo LED = 1, 2, 0, %1.2g, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN2.SCAL -   2   Volts/div
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN3.SCAL
echo [%FN%.%ID%.CHAN3.SCAL]
echo Pos = 675, %YPOSCN3%
echo LED = 1, 2, 0, %1.2g, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN3.SCAL -   3   Volts/div
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.CHAN4.SCAL
echo [%FN%.%ID%.CHAN4.SCAL]
echo Pos = 675, %YPOSCN4%
echo LED = 1, 2, 0, %1.2g, Name:PT_Mono\Style:[Bold]\Size:10
echo Painter(v) = (glBorderBevel=1)+(glBorderColor=clBlack)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_70_15_24_white.bmp 
echo Hint = %FN%.%ID%.CHAN4.SCAL -   4   Volts/div
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.STATUS.GET.DATA
echo [%FN%.%ID%.STATUS.GET.DATA]
echo Pos = 5,%YPOSPAR%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:8
echo TagEval(v) = isbit(v,0)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_silver.bmp DAT
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_lime.bmp DAT
echo Hint = %FN%.%ID%.STATUS.GET.DATA -    
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.STATUS.SAVE.OSC
echo [%FN%.%ID%.STATUS.SAVE.OSC]
echo Pos = 32,%YPOSPAR%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:8
echo TagEval(v) = isbit(v,1)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_silver.bmp OCS
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_lime.bmp OCS
echo Hint = %FN%.%ID%.STATUS.SAVE.OSC -   OSC 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.STATUS.SAVE.CSV
echo [%FN%.%ID%.STATUS.SAVE.CSV]
echo Pos = 59,%YPOSPAR%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:8
echo TagEval(v) = isbit(v,2)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_silver.bmp CVS
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_lime.bmp CVS
echo Hint = %FN%.%ID%.STATUS.SAVE.CSV -   CSV 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.STATUS.COPY.OSC
echo [%FN%.%ID%.STATUS.COPY.OSC]
echo Pos = 86,%YPOSPAR%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:8
echo TagEval(v) = isbit(v,3)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_silver.bmp OCC
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_lime.bmp OCC
echo Hint = %FN%.%ID%.STATUS.COPY.OSC -   OSC 
echo []
echo.
echo [SensorList]
echo Sensor = %FN%.%ID%.STATUS.COPY.CSV
echo [%FN%.%ID%.STATUS.COPY.CSV]
echo Pos = 113,%YPOSPAR%
echo LED = 0, 0, 0, *, Name:PT_Mono\Style:[Bold]\Size:8
echo TagEval(v) = isbit(v,4)
echo Painter(v) = [Painter(v).GuiLib.SimpleBorder]
echo Tag#1 = 0, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_silver.bmp CVC
echo Tag#2 = 1, ~~\Resource\DaqSite\StdLib\Bitmaps\barbmp_27_30_24_lime.bmp CVC
echo Hint = %FN%.%ID%.STATUS.COPY.CSV -   CSV 
echo []
echo.
set /a TABCRC_TOP+=TABCRC_STEP
goto :EOF

:AKIP_DIS
unix dimcfg ^
  -n section "[&%FN%.%ID%.CTRL]" ^
  -n print DimServerMode = 1 ^
  -n end ^
  -n dis_cmnd %FNP%/%IDP%/DIMCMDMY ^
  -n tag      %FN%.%ID%.DIMCMDMY ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DIMCMDMY=%%**" ^
  -n end ^
  -n dis_cmnd %FNP%/%IDP%/DIMGUICLICK ^
  -n tag      %FN%.%ID%.DIMGUICLICK ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DIMGUICLICK=%%**" ^
  -n end ^
  -n dic_cmnd %FNP%/%IDP%/DIMGUICLICK ^
  -n tag      %FN%.%ID%.DIMGUICLICK ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CLOCK ^
  -n tag      %FN%.%ID%.CLOCK ^
  -n end ^
  -n dis_info %FNP%/%IDP%/SERVID ^
  -n tag      %FN%.%ID%.SERVID ^
  -n end ^
  -n dis_info %FNP%/%IDP%/STATUS ^
  -n tag      %FN%.%ID%.STATUS ^
  -n end ^
  -n dis_info %FNP%/%IDP%/SINGLE_START_STOP ^
  -n tag      %FN%.%ID%.TRIG.STAT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WFM_SAVE_STATUS ^
  -n tag      %FN%.%ID%.WAVESAVESTT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/POLL/ENABLE ^
  -n tag      %FN%.%ID%.POLL.ENABLE ^
  -n end ^
  -n dis_info %FNP%/%IDP%/POLL/RATE ^
  -n tag      %FN%.%ID%.POLL.RATE ^
  -n end ^
  -n dis_info %FNP%/%IDP%/ERROR/CNT ^
  -n tag      %FN%.%ID%.ERROR.CNT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/IDENT ^
  -n tag      %FN%.%ID%.IDENT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/OPC ^
  -n tag      %FN%.%ID%.OPC ^
  -n end ^
  -n dis_info %FNP%/%IDP%/AUT ^
  -n tag      %FN%.%ID%.AUT ^
  -n end ^
  -n
unix dimcfg ^
  -n dis_info %FNP%/%IDP%/ACQ/MDEP ^
  -n tag      %FN%.%ID%.ACQ.MDEP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/ACQ/POIN ^
  -n tag      %FN%.%ID%.ACQ.POIN ^
  -n end ^
  -n dis_info %FNP%/%IDP%/ACQ/SEQ ^
  -n tag      %FN%.%ID%.ACQ.SEQ ^
  -n end ^
  -n dis_info %FNP%/%IDP%/ACQ/SAMPLERATE ^
  -n tag      %FN%.%ID%.ACQ.SMPLRT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/ACQ/TYP ^
  -n tag      %FN%.%ID%.ACQ.TYP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN1/COUP ^
  -n tag      %FN%.%ID%.CN1.COUP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN2/COUP ^
  -n tag      %FN%.%ID%.CN2.COUP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN3/COUP ^
  -n tag      %FN%.%ID%.CN3.COUP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN4/COUP ^
  -n tag      %FN%.%ID%.CN4.COUP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN1/IMP ^
  -n tag      %FN%.%ID%.CN1.IMP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN2/IMP ^
  -n tag      %FN%.%ID%.CN2.IMP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN3/IMP ^
  -n tag      %FN%.%ID%.CN3.IMP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN4/IMP ^
  -n tag      %FN%.%ID%.CN4.IMP ^
  -n end ^
  -n
unix dimcfg ^
  -n dis_info %FNP%/%IDP%/CN1/SCAL ^
  -n tag      %FN%.%ID%.CN1.SCAL ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN2/SCAL ^
  -n tag      %FN%.%ID%.CN2.SCAL ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN3/SCAL ^
  -n tag      %FN%.%ID%.CN3.SCAL ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN4/SCAL ^
  -n tag      %FN%.%ID%.CN4.SCAL ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN1/OFFS ^
  -n tag      %FN%.%ID%.CN1.OFFS ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN2/OFFS ^
  -n tag      %FN%.%ID%.CN2.OFFS ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN3/OFFS ^
  -n tag      %FN%.%ID%.CN3.OFFS ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN4/OFFS ^
  -n tag      %FN%.%ID%.CN4.OFFS ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN1/SWIT ^
  -n tag      %FN%.%ID%.CN1.SWIT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN2/SWIT ^
  -n tag      %FN%.%ID%.CN2.SWIT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN3/SWIT ^
  -n tag      %FN%.%ID%.CN3.SWIT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/CN4/SWIT ^
  -n tag      %FN%.%ID%.CN4.SWIT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TIM/DEL ^
  -n tag      %FN%.%ID%.TIM.DEL ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TIM/SCAL ^
  -n tag      %FN%.%ID%.TIM.SCAL ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/MODE ^
  -n tag      %FN%.%ID%.TRIG.MODE ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/RUN ^
  -n tag      %FN%.%ID%.TRIG.RUN ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/STAT ^
  -n tag      %FN%.%ID%.TRIG.STAT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/STOP ^
  -n tag      %FN%.%ID%.TRIG.STOP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/TYP ^
  -n tag      %FN%.%ID%.TRIG.TYP ^
  -n end ^
  -n
unix dimcfg ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/COUP ^
  -n tag      %FN%.%ID%.TRIG.EDGE.COUP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/HLDEV ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HLDEV ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/HLDT ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HLDT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/HOLD ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HOLD ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/HST ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HST ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/LEV ^
  -n tag      %FN%.%ID%.TRIG.EDGE.LEV ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/NREJ ^
  -n tag      %FN%.%ID%.TRIG.EDGE.NREJ ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/SLOP ^
  -n tag      %FN%.%ID%.TRIG.EDGE.SLOP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/TRIG/EDGE/SOUR ^
  -n tag      %FN%.%ID%.TRIG.EDGE.SOUR ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WAV/SOUR ^
  -n tag      %FN%.%ID%.WAV.SOUR ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WAV/STAR ^
  -n tag      %FN%.%ID%.WAV.STAR ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WAV/INT ^
  -n tag      %FN%.%ID%.WAV.INT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WAV/POIN ^
  -n tag      %FN%.%ID%.WAV.POIN ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WAV/MAXP ^
  -n tag      %FN%.%ID%.WAV.MAXP ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WAV/WIDT ^
  -n tag      %FN%.%ID%.WAV.WIDT ^
  -n end ^
  -n dis_info %FNP%/%IDP%/WAV/DATA ^
  -n tag      %FN%.%ID%.WAV.DATA ^
  -n end ^
  -n dis_info %FNP%/%IDP%/MODECALCDEV ^
  -n tag      %FN%.%ID%.MODECALCDEV ^
  -n end ^
  -n dis_info %FNP%/%IDP%/DIRBASE ^
  -n tag      %FN%.%ID%.BASEDIR ^
  -n end ^
  -n dis_info %FNP%/%IDP%/DIREXP ^
  -n tag      %FN%.%ID%.EXPDIR ^
  -n end ^
  -n
echo.
goto :EOF

:AKIP_DIC
unix dimcfg ^
  -n section "[&%FN%.%ID%.CTRL]" ^
  -n print DimClientMode = 1 ^
  -n end ^
  -n dic_cmnd %FNP%/%IDP%/DIMGUICLICK ^
  -n tag      %FN%.%ID%.DIMGUICLICK ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CLOCK ^
  -n tag      %FN%.%ID%.CLOCK ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CLOCK" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/SERVID ^
  -n tag      %FN%.%ID%.SERVID ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.SERVID" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/POLL/ENABLE ^
  -n tag      %FN%.%ID%.POLL.ENABLE ^
  -n end ^
  -n dic_info %FNP%/%IDP%/POLL/RATE ^
  -n tag      %FN%.%ID%.POLL.RATE ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.POLL.RATE" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/ERROR/CNT ^
  -n tag      %FN%.%ID%.ERROR.CNT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.ERROR.CNT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/STATUS ^
  -n tag      %FN%.%ID%.STATUS ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.STATUS" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/IDENT ^
  -n tag      %FN%.%ID%.IDENT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.IDENT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/OPC ^
  -n tag      %FN%.%ID%.OPC ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.OPC" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/AUT ^
  -n tag      %FN%.%ID%.AUT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.AUT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/ACQ/MDEP ^
  -n tag      %FN%.%ID%.ACQ.MDEP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.ACQ.MDEP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/ACQ/POIN ^
  -n tag      %FN%.%ID%.ACQ.POIN ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.ACQ.POIN" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/ACQ/SEQ ^
  -n tag      %FN%.%ID%.ACQ.SEQ ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.ACQ.SEQ" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/ACQ/SAMPLERATE ^
  -n tag      %FN%.%ID%.ACQ.SMPLRT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.ACQ.SMPLRT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/ACQ/TYP ^
  -n tag      %FN%.%ID%.ACQ.TYP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.ACQ.TYP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN1/COUP ^
  -n tag      %FN%.%ID%.CN1.COUP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN1.COUP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN2/COUP ^
  -n tag      %FN%.%ID%.CN2.COUP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN2.COUP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN3/COUP ^
  -n tag      %FN%.%ID%.CN3.COUP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN3.COUP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN4/COUP ^
  -n tag      %FN%.%ID%.CN4.COUP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN4.COUP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN1/IMP ^
  -n tag      %FN%.%ID%.CN1.IMP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN1.IMP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN2/IMP ^
  -n tag      %FN%.%ID%.CN2.IMP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN2.IMP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN3/IMP ^
  -n tag      %FN%.%ID%.CN3.IMP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN3.IMP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN4/IMP ^
  -n tag      %FN%.%ID%.CN4.IMP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN4.IMP" ^
  -n end ^
  -n
unix dimcfg ^
  -n dic_info %FNP%/%IDP%/CN1/SCAL ^
  -n tag      %FN%.%ID%.CN1.SCAL ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN1.SCAL" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN2/SCAL ^
  -n tag      %FN%.%ID%.CN2.SCAL ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN2.SCAL" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN3/SCAL ^
  -n tag      %FN%.%ID%.CN3.SCAL ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN3.SCAL" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN4/SCAL ^
  -n tag      %FN%.%ID%.CN4.SCAL ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN4.SCAL" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN1/OFFS ^
  -n tag      %FN%.%ID%.CN1.OFFS ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN1.OFFS" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN2/OFFS ^
  -n tag      %FN%.%ID%.CN2.OFFS ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN2.OFFS" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN3/OFFS ^
  -n tag      %FN%.%ID%.CN3.OFFS ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN3.OFFS" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN4/OFFS ^
  -n tag      %FN%.%ID%.CN4.OFFS ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN4.OFFS" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN1/SWIT ^
  -n tag      %FN%.%ID%.CN1.SWIT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN1.SWIT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN2/SWIT ^
  -n tag      %FN%.%ID%.CN2.SWIT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN2.SWIT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN3/SWIT ^
  -n tag      %FN%.%ID%.CN3.SWIT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN3.SWIT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/CN4/SWIT ^
  -n tag      %FN%.%ID%.CN4.SWIT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.CN4.SWIT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TIM/DEL ^
  -n tag      %FN%.%ID%.TIM.DEL ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TIM.DEL" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TIM/SCAL ^
  -n tag      %FN%.%ID%.TIM.SCAL ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TIM.SCAL" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/MODE ^
  -n tag      %FN%.%ID%.TRIG.MODE ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.MODE" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/RUN ^
  -n tag      %FN%.%ID%.TRIG.RUN ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.RUN" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/STAT ^
  -n tag      %FN%.%ID%.TRIG.STAT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.STAT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/STOP ^
  -n tag      %FN%.%ID%.TRIG.STOP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.STOP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/TYP ^
  -n tag      %FN%.%ID%.TRIG.TYP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.TYP" ^
  -n end ^
  -n
unix dimcfg ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/COUP ^
  -n tag      %FN%.%ID%.TRIG.EDGE.COUP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.COUP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/HLDEV ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HLDEV ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.HLDEV" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/HLDT ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HLDT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.HLDT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/HOLD ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HOLD ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.HOLD" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/HST ^
  -n tag      %FN%.%ID%.TRIG.EDGE.HST ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.HST" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/LEV ^
  -n tag      %FN%.%ID%.TRIG.EDGE.LEV ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.LEV" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/NREJ ^
  -n tag      %FN%.%ID%.TRIG.EDGE.NREJ ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.NREJ" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/SLOP ^
  -n tag      %FN%.%ID%.TRIG.EDGE.SLOP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.SLOP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/TRIG/EDGE/SOUR ^
  -n tag      %FN%.%ID%.TRIG.EDGE.SOUR ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.EDGE.SOUR" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WAV/SOUR ^
  -n tag      %FN%.%ID%.WAV.SOUR ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAV.SOUR" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WAV/STAR ^
  -n tag      %FN%.%ID%.WAV.STAR ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAV.STAR" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WAV/INT ^
  -n tag      %FN%.%ID%.WAV.INT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAV.INT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WAV/POIN ^
  -n tag      %FN%.%ID%.WAV.POIN ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAV.POIN" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WAV/MAXP ^
  -n tag      %FN%.%ID%.WAV.MAXP ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAV.MAXP" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WAV/WIDT ^
  -n tag      %FN%.%ID%.WAV.WIDT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAV.WIDT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WAV/DATA ^
  -n tag      %FN%.%ID%.WAV.DATA ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAV.DATA" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/SINGLE_START_STOP ^
  -n tag      %FN%.%ID%.TRIG.STAT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.TRIG.STAT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/WFM_SAVE_STATUS ^
  -n tag      %FN%.%ID%.WAVESAVESTT ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.WAVESAVESTT" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/MODECALCDEV ^
  -n tag      %FN%.%ID%.MODECALCDEV ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.MODECALCDEV" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/DIRBASE ^
  -n tag      %FN%.%ID%.BASEDIR ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.BASEDIR" ^
  -n end ^
  -n dic_info %FNP%/%IDP%/DIREXP ^
  -n tag      %FN%.%ID%.EXPDIR ^
  -n %devmsg% "&%FN%.%ID%.CTRL @DimTagUpdate=%FN%.%ID%.EXPDIR" ^
  -n end ^
  -n
echo.
goto :EOF

:DeleteFiles
if "%~1" == "" goto :EOF
if exist "%~1" del /f /q "%~1"
shift & goto :DeleteFiles
goto :EOF