{------------------------------------------------------------------------------}
{                                                                              }
{                           Author Yuriy Kopnin                                }
{                            Package VisuaTech                                 }
{                                 LGPL                                         }
{                                                                              }
{------------------------------------------------------------------------------}

unit regvtcomponents;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, formdesig, LResources, XDBGrids,
  xDBControls, xFormsBar, PropEdits, ImgList, GraphPropEdits,
  xColumnImageEdotors, BarCodeHook, Graphics, math, Types;

type

  { TxImageIndexPropertyEditor }

  TxImageIndexPropertyEditor = class(TImageIndexPropertyEditor)
    function GetImageList: TCustomImageList; override;
    function GetAttributes: TPropertyAttributes; override;
    procedure ListDrawValue(const CurValue: ansistring; Index:integer;
      ACanvas: TCanvas;  const ARect: TRect; AState: TPropEditDrawState); override;
    procedure ListMeasureHeight(const {%H-}AValue: ansistring; {%H-}Index:integer;
      ACanvas:TCanvas; var AHeight: Integer); override;
  end;

procedure Register;

implementation

uses typinfo, ActnList, Menus;

procedure Register;
begin
  RegisterComponents('VisualTech', [TDesignerManager]);
  RegisterComponents('VisualTech', [TxDBGrid]);
  RegisterComponents('VisualTech', [TDBEditButton]);
  RegisterComponents('VisualTech', [TLabeledDBEdit]);
  RegisterComponents('VisualTech', [TLabeledDBCombo]);
  RegisterComponents('VisualTech', [TLabeledDBLookupCombo]);
  RegisterComponents('VisualTech', [TxDBCheckBox]);
  RegisterComponents('VisualTech', [TxSpeedBtn]);
  RegisterComponents('VisualTech', [TxBitBtn]);
  RegisterComponents('VisualTech', [TxLabeledEdit]);
  RegisterComponents('VisualTech', [TxLabeledCombo]);
  RegisterComponents('VisualTech', [TxEditButton]);
  RegisterComponents('VisualTech', [TFormsBar]);
  //RegisterComponents('VisualTech', [TActionPanel]);
  RegisterComponents('VisualTech',[TBarCodeHook]);

  RegisterPropertyEditor(TypeInfo(TImageIndex), TxEditButton, 'ImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TDBEditButton, 'ImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TxEditButton, 'DownImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TDBEditButton, 'DownImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TxSpeedBtn, 'ImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TxBitBtn, 'ImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImageIndex), TxSpeedBtn, 'DownImageIndex', TxImageIndexPropertyEditor);
  RegisterPropertyEditor(TypeInfo(TImagesIndexes), TxColumn, 'ImagesIndexes', TImagesIndexesProperty);
  RegisterPropertyEditor(TypeInfo(TImagesIndexes), TxColumn, 'xImagesIndexes', TxImagesIndexesProperty);
end;

{ TxImageIndexPropertyEditor }

function TxImageIndexPropertyEditor.GetImageList: TCustomImageList;
var
  Persistent: TPersistent;
  Component: TComponent absolute Persistent;
  PropInfo: PPropInfo;
  Obj: TObject;
begin
  Result := nil;
  Persistent := GetComponent(0);
  if not (Persistent is TComponent) then Exit;

  if Persistent is TAction then
    Persistent := TAction(Persistent).ActionList;
  if Persistent = nil then Exit;

  PropInfo := TypInfo.GetPropInfo(Component, 'ImageList');
  if PropInfo = nil then PropInfo := TypInfo.GetPropInfo(Component, 'Images');
  if PropInfo = nil then Exit;
  Obj := GetObjectProp(Component, PropInfo);
  if Obj is TCustomImageList then
      Exit(TCustomImageList(Obj));
end;

function TxImageIndexPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paValueList, paCustomDrawn, paRevertable, paPickList];
end;

procedure TxImageIndexPropertyEditor.ListDrawValue(const CurValue: ansistring;
  Index: integer; ACanvas: TCanvas; const ARect: TRect;
  AState: TPropEditDrawState);
var
  Images: TCustomImageList;
  R: TRect;
  OldColor: TColor;
  AHeight, Dx: Integer;
  Style : TTextStyle;
begin
  if GetDefaultOrdValue <> NoDefaultValue then
    Dec(Index);
  Images := GetImageList;
  R := ARect;
  AHeight := R.Bottom - R.Top;
  if Assigned(Images) then
  begin
    if (pedsInComboList in AState) and not (pedsInEdit in AState) then
    begin
      OldColor := ACanvas.Brush.Color;
      if pedsSelected in AState then
        ACanvas.Brush.Color := clHighlight
      else
        ACanvas.Brush.Color := clWhite;
      ACanvas.FillRect(R);
      ACanvas.Brush.Color := OldColor;
    end;

    if Images.Height <= AHeight then
    begin
      Dx := (AHeight - Images.Height) div 2;
      Images.Draw(ACanvas, R.Left + Dx, R.Top + Dx, Index, True);
    end
    else
    begin
      R.Right := R.Left + R.Bottom - R.Top;
      InflateRect(R, -2, -2);
      Images.StretchDraw(ACanvas, Index, R, True);
    end;

    R := ARect;
    R.Left := R.Left + AHeight + 2;

    With Style do begin
      Alignment := taLeftJustify;
      Layout := tlCenter;
      Opaque := False;
      Clipping := True;
      ShowPrefix := True;
      WordBreak := False;
      SingleLine := True;
      SystemFont := False;
    end;

    ACanvas.TextRect(R, R.Left+2, R.Top, CurValue, Style);
  end;
  //inherited ListDrawValue(CurValue, Index, ACanvas, R, AState);
end;

procedure TxImageIndexPropertyEditor.ListMeasureHeight(
  const AValue: ansistring; Index: integer; ACanvas: TCanvas;
  var AHeight: Integer);
begin
  AHeight := ACanvas.TextHeight('1');
end;

initialization
{$I visualdesign.lrs}

end.

