unit GridFilter;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, db;

type

  { TGridFilterForm }

  TGridFilterForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    CheckBox1: TCheckBox;
    Edit1: TEdit;
    Panel1: TPanel;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    procedure Button1Click(Sender: TObject);
    procedure Button1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState
      );
    procedure Button2Click(Sender: TObject);
    procedure Edit1Enter(Sender: TObject);
    procedure Edit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormDestroy(Sender: TObject);
  private
  protected
  public
    Field: TField;
  end;

var
  GridFilterForm: TGridFilterForm;

implementation

uses XDBGrids, LCLType, LazUTF8;

{$R *.lfm}

{ TGridFilterForm }

procedure TGridFilterForm.FormClose(Sender: TObject;
  var CloseAction: TCloseAction);
begin
  CloseAction := caFree;
end;

procedure TGridFilterForm.FormDestroy(Sender: TObject);
begin
  TxDBGrid(Owner).SetFocus;
end;

procedure TGridFilterForm.Button1Click(Sender: TObject);
var
  Grid: TxDBGrid;
begin
  Grid := TxDBGrid(Owner);

  Grid.ResetFilter;
  Grid.ActivateFilter(Field.FieldName, Edit1.Text, CheckBox1.Checked, RadioButton1.Checked);
end;

procedure TGridFilterForm.Button1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key = VK_ESCAPE then Close;
end;

procedure TGridFilterForm.Button2Click(Sender: TObject);
var
  Grid: TxDBGrid;
begin
  Grid := TxDBGrid(Owner);
  Grid.ResetFilter;
end;

procedure TGridFilterForm.Edit1Enter(Sender: TObject);
begin
  Edit1.SelStart := UTF8CharacterLength(PChar(Edit1.Text));
  Edit1.SelLength := 0;
end;

procedure TGridFilterForm.Edit1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case Key of
    VK_ESCAPE: Close;
    VK_RETURN:
    begin
      if Shift = [ssCtrl] then
      begin
        Button1.Click;
        Close;
      end
      else
        Button1.Click;
    end;
  end;
end;

end.

