{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit dpi_Misc;

{$mode objfpc}{$H+}

interface

uses SysUtils, Classes, dpCompil, TypInfo, Variants;

type

  { TSuMiscImport }

  TSuMiscImport = class(TClassImporter)
    //function BarChart_AddBar(Instance: TObject; var Params: Variant): Variant;
    //function BarChart_BarCount(Instance: TObject; var Params: Variant): Variant;
    //function BarChart_Clear(Instance: TObject; var Params: Variant): Variant;
    //function BarChart_GetBar(Instance: TObject; var Params: Variant): Variant;
    function DateEdit_DateGet(Instance: Pointer): Variant;
    procedure DateEdit_DateSet(Instance: Pointer; AValue: Variant);
  private
  protected
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterPublic(AType: TDpType); override;
  end;

implementation

uses Dialogs, Spin, Arrow, Calendar, EditBtn, FileCtrl, //BarChart,
  ButtonPanel, ShellCtrls, Graphics;

{ TSuMiscImport }

{function TSuMiscImport.BarChart_AddBar(Instance: TObject; var Params: Variant
  ): Variant;
begin
 Result := TSuPtr(TBarChart(Instance).AddBar(Params[0], Params[1], TColor(Integer(Params[2]))));
end;

function TSuMiscImport.BarChart_BarCount(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TBarChart(Instance).BarCount;
end;

function TSuMiscImport.BarChart_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TBarChart(Instance).Clear;
end;

function TSuMiscImport.BarChart_GetBar(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr(TBarChart(Instance).GetBar(Params[0]));
end;}

function TSuMiscImport.DateEdit_DateGet(Instance: Pointer): Variant;
begin
  Result := TDateEdit(Instance).Date;
end;

procedure TSuMiscImport.DateEdit_DateSet(Instance: Pointer; AValue: Variant);
begin
  TDateEdit(Instance).Date := AValue;
end;

procedure TSuMiscImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TColorButton);
  AddClass(TSpinEdit);
  AddClass(TFloatSpinEdit);
  AddClass(TArrow);
  AddClass(TCalendar);
  AddClass(TEditButton);
  AddClass(TFileNameEdit);
  AddClass(TDirectoryEdit);
  AddClass(TDateEdit).ClassImporter := Self;
  AddClass(TCalcEdit);
  AddClass(TFileListBox);
  AddClass(TFilterComboBox);
  //AddClass(TBar);
  //AddClass(TBarChartItems);
  //AddClass(TBarChart).ClassImporter := Self;
  AddClass(TPanelBitBtn);
  AddClass(TButtonPanel);
  AddClass(TShellTreeView);
  AddClass(TShellListView);
end;

procedure TSuMiscImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TArrowType));
  AddType(TypeInfo(TShadowType));
  AddType(TypeInfo(TDisplaySetting));
  AddType(TypeInfo(TCalendarPart));
  AddType(TypeInfo(TDialogKind));
  AddType(TypeInfo(TDateOrder));
  AddType(TypeInfo(TFileAttr));
  AddType(TypeInfo(TFileType));
  AddType(TypeInfo(TButtonOrder));
  AddType(TypeInfo(TPanelButton));
  AddType(TypeInfo(TPanelButtons));
  //AddType(TypeInfo(TPosLabel));

end;

procedure TSuMiscImport.RegisterPublic(AType: TDpType);
begin
  {if AType.ValueClassType = TBarChart then
  begin
    AType.AddMethod('procedure Clear', @BarChart_Clear);
    AType.AddMethod('function AddBar(const SName: string; Value: integer; AColor: TColor): TBar', @BarChart_AddBar);
    AType.AddMethod('function BarCount: Integer', @BarChart_BarCount);
    AType.AddMethod('function GetBar(SId: integer): TBar', @BarChart_GetBar);
  end
  else}
  if AType.ValueClassType = TDateEdit then
  begin
    AType.AddProp('Date', 'TDateTime', @DateEdit_DateGet, @DateEdit_DateSet);
  end;
end;

end.

