unit dpi_LazReport;

{$mode objfpc}{$H+}

{$I SetComponent.inc}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Variants;

type

  { TLazReportImport }

  TLazReportImport = class(TClassImporter)
    function frEMFPages_Add(Instance: TObject; var Params: Variant): Variant;
    function frEMFPages_Clear(Instance: TObject; var Params: Variant): Variant;
    function frEMFPages_Count(Instance: Pointer): Variant;
    function frEMFPages_Delete(Instance: TObject; var Params: Variant): Variant;
    function frEMFPages_Insert(Instance: TObject; var Params: Variant): Variant;
    function frObject_Assign(Instance: TObject; var Params: Variant): Variant;
    function frObject_MemoGet(Instance: Pointer): Variant;
    procedure frObject_MemoSet(Instance: Pointer; AValue: Variant);
    function frPages_Add(Instance: TObject; var Params: Variant): Variant;
    function frPages_Clear(Instance: TObject; var Params: Variant): Variant;
    function frPages_Count(Instance: Pointer): Variant;
    function frPages_Delete(Instance: TObject; var Params: Variant): Variant;
    function frPages_PageByName(Instance: TObject; var Params: Variant
      ): Variant;
    function frPages_Pages(Instance: TObject; var Params: Variant): Variant;
    function frPage_AdvanceRow(Instance: TObject; var Params: Variant): Variant;
    function frPage_BottomMargin(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_ChangePaper(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_Clear(Instance: TObject; var Params: Variant): Variant;
    function frPage_ColCountGet(Instance: Pointer): Variant;
    procedure frPage_ColCountSet(Instance: Pointer; AValue: Variant);
    function frPage_ColGapGet(Instance: Pointer): Variant;
    procedure frPage_ColGapSet(Instance: Pointer; AValue: Variant);
    function frPage_ColWidthGet(Instance: Pointer): Variant;
    procedure frPage_ColWidthSet(Instance: Pointer; AValue: Variant);
    function frPage_Create(Instance: TObject; var Params: Variant): Variant;
    function frPage_CreatePage(Instance: TObject; var Params: Variant): Variant;
    function frPage_CurBottomYGet(Instance: Pointer): Variant;
    procedure frPage_CurBottomYSet(Instance: Pointer; AValue: Variant);
    function frPage_CurYGet(Instance: Pointer): Variant;
    procedure frPage_CurYSet(Instance: Pointer; AValue: Variant);
    function frPage_Delete(Instance: TObject; var Params: Variant): Variant;
    function frPage_FindObject(Instance: TObject; var Params: Variant): Variant;
    function frPage_FindObjectByID(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_FindRTObject(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_LastBandTypeGet(Instance: Pointer): Variant;
    procedure frPage_LastBandTypeSet(Instance: Pointer; AValue: Variant);
    function frPage_LastRowHeightGet(Instance: Pointer): Variant;
    procedure frPage_LastRowHeightSet(Instance: Pointer; AValue: Variant);
    function frPage_LayoutOrderGet(Instance: Pointer): Variant;
    procedure frPage_LayoutOrderSet(Instance: Pointer; AValue: Variant);
    function frPage_LeftMargin(Instance: TObject; var Params: Variant): Variant;
    function frPage_MarginsGet(Instance: Pointer): Variant;
    procedure frPage_MarginsSet(Instance: Pointer; AValue: Variant);
    function frPage_NewColumn(Instance: TObject; var Params: Variant): Variant;
    function frPage_NewPage(Instance: TObject; var Params: Variant): Variant;
    function frPage_NextColumn(Instance: TObject; var Params: Variant): Variant;
    function frPage_OrientationGet(Instance: Pointer): Variant;
    procedure frPage_OrientationSet(Instance: Pointer; AValue: Variant);
    function frPage_PrintToPrevPageGet(Instance: Pointer): Variant;
    procedure frPage_PrintToPrevPageSet(Instance: Pointer; AValue: Variant);
    function frPage_RightMargin(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_RowsLayout(Instance: TObject; var Params: Variant): Variant;
    function frPage_RowStartedGet(Instance: Pointer): Variant;
    procedure frPage_RowStartedSet(Instance: Pointer; AValue: Variant);
    function frPage_ShowBandByName(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_ShowBandByType(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_StartColumn(Instance: TObject; var Params: Variant
      ): Variant;
    function frPage_StartRowsLayoutNonDataBand(Instance: TObject;
      var Params: Variant): Variant;
    function frPage_TopMargin(Instance: TObject; var Params: Variant): Variant;
    function frPage_UseMarginsGet(Instance: Pointer): Variant;
    procedure frPage_UseMarginsSet(Instance: Pointer; AValue: Variant);
    function frPreview_AllPagesGet(Instance: Pointer): Variant;
    function frPreview_Connect(Instance: TObject; var Params: Variant): Variant;
    function frPreview_Edit(Instance: TObject; var Params: Variant): Variant;
    function frPreview_ExportTo(Instance: TObject; var Params: Variant
      ): Variant;
    function frPreview_Find(Instance: TObject; var Params: Variant): Variant;
    function frPreview_First(Instance: TObject; var Params: Variant): Variant;
    function frPreview_Last(Instance: TObject; var Params: Variant): Variant;
    function frPreview_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function frPreview_Next(Instance: TObject; var Params: Variant): Variant;
    function frPreview_OnePage(Instance: TObject; var Params: Variant): Variant;
    function frPreview_PageGet(Instance: Pointer): Variant;
    procedure frPreview_PageSet(Instance: Pointer; AValue: Variant);
    function frPreview_PageWidth(Instance: TObject; var Params: Variant
      ): Variant;
    function frPreview_Prev(Instance: TObject; var Params: Variant): Variant;
    function frPreview_Print(Instance: TObject; var Params: Variant): Variant;
    function frPreview_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function frPreview_TwoPages(Instance: TObject; var Params: Variant
      ): Variant;
    function frPreview_ZoomGet(Instance: Pointer): Variant;
    procedure frPreview_ZoomSet(Instance: Pointer; AValue: Variant);
    function frReport_ChangePrinter(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_Clear(Instance: TObject; var Params: Variant): Variant;
    function frReport_CommentsGet(Instance: Pointer): Variant;
    procedure frReport_CommentsSet(Instance: Pointer; AValue: Variant);
    function frReport_DesignReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_EditPreparedReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_EMFPagesGet(Instance: Pointer): Variant;
    //function frReport_ExportTo(Instance: TObject; var Params: Variant): Variant;
    function frReport_FileNameGet(Instance: Pointer): Variant;
    procedure frReport_FileNameSet(Instance: Pointer; AValue: Variant);
    function frReport_FillQueryParams(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_FinalPassGet(Instance: Pointer): Variant;
    procedure frReport_FinalPassSet(Instance: Pointer; AValue: Variant);
    function frReport_FindObject(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_FindVariable(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_GetCategoryList(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_GetVariableValue(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_GetVarList(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_KeyWordsGet(Instance: Pointer): Variant;
    procedure frReport_KeyWordsSet(Instance: Pointer; AValue: Variant);
    function frReport_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_LoadFromXMLFile(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_LoadFromXMLStream(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_LoadPreparedReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_LoadTemplate(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_PagesGet(Instance: Pointer): Variant;
    function frReport_PrepareReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_PrintPreparedReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_ReportAutorGet(Instance: Pointer): Variant;
    procedure frReport_ReportAutorSet(Instance: Pointer; AValue: Variant);
    function frReport_ReportCreateDateGet(Instance: Pointer): Variant;
    procedure frReport_ReportCreateDateSet(Instance: Pointer; AValue: Variant);
    function frReport_ReportLastChangeGet(Instance: Pointer): Variant;
    procedure frReport_ReportLastChangeSet(Instance: Pointer; AValue: Variant);
    function frReport_ReportVersionBuildGet(Instance: Pointer): Variant;
    procedure frReport_ReportVersionBuildSet(Instance: Pointer; AValue: Variant
      );
    function frReport_ReportVersionMajorGet(Instance: Pointer): Variant;
    procedure frReport_ReportVersionMajorSet(Instance: Pointer; AValue: Variant
      );
    function frReport_ReportVersionMinorGet(Instance: Pointer): Variant;
    procedure frReport_ReportVersionMinorSet(Instance: Pointer; AValue: Variant
      );
    function frReport_ReportVersionReleaseGet(Instance: Pointer): Variant;
    procedure frReport_ReportVersionReleaseSet(Instance: Pointer;
      AValue: Variant);
    function frReport_SavePreparedReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_SaveTemplate(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_SaveToXMLFile(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_SaveToXMLStream(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_ShowPreparedReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_ShowReport(Instance: TObject; var Params: Variant
      ): Variant;
    function frReport_SubjectGet(Instance: Pointer): Variant;
    procedure frReport_SubjectSet(Instance: Pointer; AValue: Variant);
    function frReport_TerminatedGet(Instance: Pointer): Variant;
    procedure frReport_TerminatedSet(Instance: Pointer; AValue: Variant);
    function frReport_ValuesGet(Instance: Pointer): Variant;
    procedure frReport_ValuesSet(Instance: Pointer; AValue: Variant);
    function frReport_VariablesGet(Instance: Pointer): Variant;
    procedure frReport_VariablesSet(Instance: Pointer; AValue: Variant);
    function frValues_AddValue(Instance: TObject; var Params: Variant): Variant;
    function frValues_Clear(Instance: TObject; var Params: Variant): Variant;
    function frValues_FindVariable(Instance: TObject; var Params: Variant
      ): Variant;
    function frValues_ItemsGet(Instance: Pointer): Variant;
    procedure frValues_ItemsSet(Instance: Pointer; AValue: Variant);
    function frValues_ObjectsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function frValue_DataSetGet(Instance: Pointer): Variant;
    procedure frValue_DataSetSet(Instance: Pointer; AValue: Variant);
    function frValue_DSetGet(Instance: Pointer): Variant;
    procedure frValue_DSetSet(Instance: Pointer; AValue: Variant);
    function frValue_FieldGet(Instance: Pointer): Variant;
    procedure frValue_FieldSet(Instance: Pointer; AValue: Variant);
    function frValue_OtherKindGet(Instance: Pointer): Variant;
    procedure frValue_OtherKindSet(Instance: Pointer; AValue: Variant);
    function frValue_TypGet(Instance: Pointer): Variant;
    procedure frValue_TypSet(Instance: Pointer; AValue: Variant);
    function frVariables_Clear(Instance: TObject; var Params: Variant): Variant;
    function frVariables_Count(Instance: Pointer): Variant;
    function frVariables_Delete(Instance: TObject; var Params: Variant
      ): Variant;
    function frVariables_IndexOf(Instance: TObject; var Params: Variant
      ): Variant;
    function frVariables_NameGet(Instance: TObject; var Params: Variant
      ): Variant;
    function frVariables_ValueGet(Instance: TObject; var Params: Variant
      ): Variant;
    function frVariables_ValueSet(Instance: TObject; var Params: Variant
      ): Variant;
    function frVariables_VariableGet(Instance: TObject; var Params: Variant
      ): Variant;
    function frVariables_VariableSet(Instance: TObject; var Params: Variant
      ): Variant;
    function frView_Create(Instance: TObject; var Params: Variant): Variant;
    function frView_FillColorGet(Instance: Pointer): Variant;
    procedure frView_FillColorSet(Instance: Pointer; AValue: Variant);
    function frView_FormatGet(Instance: Pointer): Variant;
    procedure frView_FormatSet(Instance: Pointer; AValue: Variant);
    function frView_FrameColorGet(Instance: Pointer): Variant;
    procedure frView_FrameColorSet(Instance: Pointer; AValue: Variant);
    function frView_FramesGet(Instance: Pointer): Variant;
    procedure frView_FramesSet(Instance: Pointer; AValue: Variant);
    function frView_FrameStyleGet(Instance: Pointer): Variant;
    procedure frView_FrameStyleSet(Instance: Pointer; AValue: Variant);
    function frView_FrameWidthGet(Instance: Pointer): Variant;
    procedure frView_FrameWidthSet(Instance: Pointer; AValue: Variant);
    function frView_StretchedGet(Instance: Pointer): Variant;
    procedure frView_StretchedSet(Instance: Pointer; AValue: Variant);
  private
    function frPage_pgSizeGet(Instance: Pointer): Variant;
    procedure frPage_pgSizeSet(Instance: Pointer; AValue: Variant);
    function frPrinter_OrientationGet(Instance: Pointer): Variant;
    procedure frPrinter_OrientationSet(Instance: Pointer; AValue: Variant);
    function frPrinter_PaperHeightGet(Instance: Pointer): Variant;
    procedure frPrinter_PaperHeightSet(Instance: Pointer; AValue: Variant);
    function frPrinter_PaperSizeGet(Instance: Pointer): Variant;
    procedure frPrinter_PaperSizeSet(Instance: Pointer; AValue: Variant);
    function frPrinter_PaperSizesNumGet(Instance: Pointer): Variant;
    procedure frPrinter_PaperSizesNumSet(Instance: Pointer; AValue: Variant);
    function frPrinter_PaperWidthGet(Instance: Pointer): Variant;
    procedure frPrinter_PaperWidthSet(Instance: Pointer; AValue: Variant);
    function frPrinter_PrinterGet(Instance: Pointer): Variant;
    procedure frPrinter_PrinterSet(Instance: Pointer; AValue: Variant);
    function frReport_PrepareDesigner(Instance: TObject; var Params: Variant
      ): Variant;
    function fr_PrinterIndexGet(Instance: Pointer): Variant;
    procedure fr_PrinterIndexSet(Instance: Pointer; AValue: Variant);
    function fr_PrintersGet(Instance: Pointer): Variant;
    function Printer_Abort(Instance: TObject; var Params: Variant): Variant;
    function Printer_BeginDoc(Instance: TObject; var Params: Variant): Variant;
    function Printer_CanPrintGet(Instance: Pointer): Variant;
    function Printer_CanvasGet(Instance: Pointer): Variant;
    function Printer_CopiesGet(Instance: Pointer): Variant;
    procedure Printer_CopiesSet(Instance: Pointer; AValue: Variant);
    function Printer_EndDoc(Instance: TObject; var Params: Variant): Variant;
    function Printer_FileNameGet(Instance: Pointer): Variant;
    procedure Printer_FileNameSet(Instance: Pointer; AValue: Variant);
    function Printer_FontsGet(Instance: Pointer): Variant;
    function Printer_PageHeightGet(Instance: Pointer): Variant;
    function Printer_PageNumberGet(Instance: Pointer): Variant;
    function Printer_PageWidthGet(Instance: Pointer): Variant;
    function Printer_PrinterIndexGet(Instance: Pointer): Variant;
    procedure Printer_PrinterIndexSet(Instance: Pointer; AValue: Variant);
    function Printer_PrinterNameGet(Instance: Pointer): Variant;
    function Printer_PrintersGet(Instance: Pointer): Variant;
    function Printer_PrinterTypeGet(Instance: Pointer): Variant;
    function Printer_PrintingGet(Instance: Pointer): Variant;
    function Printer_Refresh(Instance: TObject; var Params: Variant): Variant;
    function Printer_SetPrinter(Instance: TObject; var Params: Variant
      ): Variant;
    function Printer_TitleGet(Instance: Pointer): Variant;
    procedure Printer_TitleSet(Instance: Pointer; AValue: Variant);
  protected
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;
    procedure AddObjects(AddObject: TAddObjectProc); override;
  end;


implementation

uses
  LR_Class, LR_DBSet, LR_BarC, LR_RRect,LR_Shape, LR_ChBox, LR_DSet, LR_E_TXT,
  LR_E_HTM, LR_E_CSV, LR_Desgn, LR_View, Graphics, Printers, dpEvnthadlrs,
  LR_DBRel, LR_Intrp, LR_Pars, LR_Const, LazUTF8, dpUtils, LR_Prntr,
  math {$IFDEF LRCAIROEXP}, lr_e_cairo {$EndIf};

type

  { TdpFunctionLibrary }

  TdpFunctionLibrary = class(TfrFunctionLibrary)
  public
    constructor Create; override;
    procedure DoFunction(FNo: Integer; p1, p2, p3: Variant; var val: Variant); override;
    procedure UpdateDescriptions; override;
  end;

  {TPrintReportEventHandler}
  TPrintReportEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TfrReport);
  end;


  { TFunctionEventHandler }

  TFunctionEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(const AName: String; p1, p2, p3: Variant; var Val: Variant);
  end;

  { TDetailEventHandler }

  TDetailEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(const ParName: String; var ParValue: Variant);
  end;

  { TBeginEndDocEventHandler }

  TBeginEndDocEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler;
  end;

  { TBeginEndPageEventHandler }

  TBeginEndPageEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(pgNo: Integer);
  end;

  { TEnterRectEventHandler }

  TEnterRectEventHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Memo: TStringList; View: TfrView);
  end;


{ TExtFunctionLibrary }

function SumProp(V: Variant; SmallFormat, FirstUpper: Boolean): string;
const
  Kop = 'коп.';
  Kopeek = 'копеек';
  Kopeiki = 'копейки';
  Kopeika = 'копейка';
  Rub = 'руб. ';
  Rubl = 'рубль ';
  Rubley = 'рублей ';
  Rublya = 'рубля ';
  Tisach = 'тысяч ';
  Tisacha = 'тысяча ';
  Tisachi = 'тысячи ';
  Million = 'миллион ';
  Millionov = 'миллионов ';
  Milliona = 'миллиона ';
  Milliard = 'миллиард ';
  Milliardov = 'миллиардов ';
  Milliarda = 'миллиарда ';
var
  I, Ps: Integer;
  Len: Integer;
  IntStr: string;
  IntProp: string;
  FracStr, S, S2: string;
  Summa: string;
  Mlrd, Mln, Tis: Boolean;
  C: Char;
begin
  Summa := V;
  Mlrd := False;
  Mln := False;
  Tis:= False;
  I := LastDelimiter('.,', Summa);
  if I <> 0 then
  begin
      IntStr := Copy(Summa, 1, I - 1);
      FracStr := Copy(Summa, I + 1, 255);
      Len := Length(FracStr);
      if Len = 1 then
      begin
        FracStr := FracStr + '0';
        Inc(Len);
      end;

      if SmallFormat then
      begin
        FracStr := FracStr + ' ' + Kop;
      end
      else
      begin
        if (FracStr[Len] = '0') or (FracStr[Len] > '4') or ((FracStr[Len - 1] = '1')) then FracStr := FracStr + ' ' + Kopeek
        else
        if (FracStr[Len] = '1') and (FracStr[Len - 1] <> '1') then FracStr := FracStr + ' ' + Kopeika
        else
        if FracStr[Len - 1] <> '1' then
          FracStr := FracStr + ' ' + Kopeiki
        else
          FracStr := FracStr + ' ' + Kopeek;
        end;
    end
    else
    begin
      IntStr := Summa;
      if SmallFormat then
        FracStr := '00 ' + Kop
      else
        FracStr := '00 копеек';
    end;
    Len := Length(IntStr) + 1;
    IntProp := '';
    if Len > 0 then
    begin
      I := 1;
      while I < Len do
      begin
        Ps := Len - I;
        if IntStr[I] <> '0' then
        begin
          case Ps of
            10..12: Mlrd := True;
            7..9: Mln := True;
            4..6: Tis := True;
          end;
        end;
        Inc(I);
      end;
      I := 1;
      while I < Len do
      begin
        Ps := Len - I;
        Case Ps of
          3, 6, 9, 12:
          begin
            if IntStr[I] = '1' then IntProp := IntProp + 'сто '
            else
            if IntStr[I] = '2' then IntProp := IntProp + 'двести '
            else
            if IntStr[I] = '3' then IntProp := IntProp + 'триста '
            else
            if IntStr[I] = '4' then IntProp := IntProp + 'четыреста '
            else
            if IntStr[I] = '5' then IntProp := IntProp + 'пятьсот '
            else
            if IntStr[I] = '6' then IntProp := IntProp + 'шестьсот '
            else
            if IntStr[I] = '7' then IntProp := IntProp + 'семьсот '
            else
            if IntStr[I] = '8' then IntProp := IntProp + 'восемьсот '
            else
            if IntStr[I] = '9' then IntProp := IntProp + 'девятьсот ';
          end;
          2, 5, 8, 11:
          begin
            if IntStr[I] = '1' then
            begin
              if IntStr[I + 1] = '1' then
                IntProp := IntProp + 'одинадцать '
              else
              if IntStr[I + 1] = '2' then
                IntProp := IntProp + 'двенадцать '
              else
              if IntStr[I + 1] = '3' then
                IntProp := IntProp + 'тринадцать '
              else
              if IntStr[I + 1] = '4' then
                IntProp := IntProp + 'четырнадцать '
              else
              if IntStr[I + 1] = '5' then
                IntProp := IntProp + 'пятнадцать '
              else
              if IntStr[I + 1] = '6' then
                IntProp := IntProp + 'шестнадцать '
              else
              if IntStr[I + 1] = '7' then
                IntProp := IntProp + 'семнадцать '
              else
              if IntStr[I + 1] = '8' then
                IntProp := IntProp + 'восемнадцать '
              else
              if IntStr[I + 1] = '9' then
                IntProp := IntProp + 'девятнадцать '
              else
              if IntStr[I + 1] = '0' then
                IntProp := IntProp + 'десять ';
              case Ps of
                2:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                5: if Tis then IntProp := IntProp + Tisach;
                8: if Mln then IntProp := IntProp + Millionov;
                11: if Mlrd then IntProp := IntProp + Milliardov;
              end;
              Inc(I);
            end
            else
            if IntStr[I] = '2' then IntProp := IntProp + 'двадцать '
            else
            if IntStr[I] = '3' then IntProp := IntProp + 'тридцать '
            else
            if IntStr[I] = '4' then IntProp := IntProp + 'сорок '
            else
            if IntStr[I] = '5' then IntProp := IntProp + 'пятьдесят '
            else
            if IntStr[I] = '6' then IntProp := IntProp + 'шестьдесят '
            else
            if IntStr[I] = '7' then IntProp := IntProp + 'семьдесят '
            else
            if IntStr[I] = '8' then IntProp := IntProp + 'восемьдесят '
            else
            if IntStr[I] = '9' then IntProp := IntProp + 'девяносто ';
          end;
          1, 4, 7, 10:
          begin
            if IntStr[I] = '1' then
            begin
              if Ps = 4 then
                IntProp := IntProp + 'одна '
              else
                IntProp := IntProp + 'один ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubl;
                end;
                4: if Tis then IntProp := IntProp + Tisacha;
                7: if Mln then IntProp := IntProp + Million;
                10: if Mlrd then IntProp := IntProp + Milliard;
              end;
            end
            else
            if IntStr[I] = '2' then
            begin
              if Ps = 4 then
                IntProp := IntProp + 'две '
              else
                IntProp := IntProp + 'два ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rublya;
                end;
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '3' then
            begin
              IntProp := IntProp + 'три ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rublya;
                end;
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '4' then
            begin
              IntProp := IntProp + 'четыре ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rublya;
                end;
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '5' then
            begin
              IntProp := IntProp + 'пять ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '6' then
            begin
              IntProp := IntProp + 'шесть ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '7' then
            begin
              IntProp := IntProp + 'семь ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '8' then
            begin
              IntProp := IntProp + 'восемь ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '9' then
            begin
              IntProp := IntProp + 'девять ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end;
            if IntStr[I] = '0' then
            begin
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end;
          end;
        end;
        Inc(I);
      end;
    end;
  Result := IntProp + FracStr;
  if FirstUpper then
  begin
    S2 := UTF8UpperCase(Result);
    Result := UTF8Copy(S2, 1, 1) + UTF8Copy(Result, 2, UTF8Length(Result) - 1);

    {S2 := dp_UTF8ToAnsi(UTF8UpperCase(Result));
    S := dp_UTF8ToAnsi(Result);
    S[1] := S2[1];
    Result := dp_AnsiToUTF8(S);}
  end;
end;

function IntPropis(V: Variant; FirstUpper: Boolean): string;
const
  Tisach = 'тысяч ';
  Tisacha = 'тысяча ';
  Tisachi = 'тысячи ';
  Million = 'миллион ';
  Millionov = 'миллионов ';
  Milliona = 'миллиона ';
  Milliard = 'миллиард ';
  Milliardov = 'миллиардов ';
  Milliarda = 'миллиарда ';
var
  I, Ps: Integer;
  Len: Integer;
  IntStr: string;
  IntProp: string;
  S, S2: string;
  Summa: string;
  Mlrd, Mln, Tis: Boolean;
  C: Char;
begin
  Summa := V;
  Mlrd := False;
  Mln := False;
  Tis:= False;
  I := LastDelimiter('.,', Summa);
  if I <> 0 then
      IntStr := Copy(Summa, 1, I - 1)
  else
      IntStr := Summa;

  Len := Length(IntStr) + 1;
  IntProp := '';
  if Len > 0 then
  begin
      I := 1;
      while I < Len do
      begin
        Ps := Len - I;
        if IntStr[I] <> '0' then
        begin
          case Ps of
            10..12: Mlrd := True;
            7..9: Mln := True;
            4..6: Tis := True;
          end;
        end;
        Inc(I);
      end;
      I := 1;
      while I < Len do
      begin
        Ps := Len - I;
        Case Ps of
          3, 6, 9, 12:
          begin
            if IntStr[I] = '1' then IntProp := IntProp + 'сто '
            else
            if IntStr[I] = '2' then IntProp := IntProp + 'двести '
            else
            if IntStr[I] = '3' then IntProp := IntProp + 'триста '
            else
            if IntStr[I] = '4' then IntProp := IntProp + 'четыреста '
            else
            if IntStr[I] = '5' then IntProp := IntProp + 'пятьсот '
            else
            if IntStr[I] = '6' then IntProp := IntProp + 'шестьсот '
            else
            if IntStr[I] = '7' then IntProp := IntProp + 'семьсот '
            else
            if IntStr[I] = '8' then IntProp := IntProp + 'восемьсот '
            else
            if IntStr[I] = '9' then IntProp := IntProp + 'девятьсот ';
          end;
          2, 5, 8, 11:
          begin
            if IntStr[I] = '1' then
            begin
              if IntStr[I + 1] = '1' then
                IntProp := IntProp + 'одинадцать '
              else
              if IntStr[I + 1] = '2' then
                IntProp := IntProp + 'двенадцать '
              else
              if IntStr[I + 1] = '3' then
                IntProp := IntProp + 'тринадцать '
              else
              if IntStr[I + 1] = '4' then
                IntProp := IntProp + 'четырнадцать '
              else
              if IntStr[I + 1] = '5' then
                IntProp := IntProp + 'пятнадцать '
              else
              if IntStr[I + 1] = '6' then
                IntProp := IntProp + 'шестнадцать '
              else
              if IntStr[I + 1] = '7' then
                IntProp := IntProp + 'семнадцать '
              else
              if IntStr[I + 1] = '8' then
                IntProp := IntProp + 'восемнадцать '
              else
              if IntStr[I + 1] = '9' then
                IntProp := IntProp + 'девятнадцать '
              else
              if IntStr[I + 1] = '0' then
                IntProp := IntProp + 'десять ';
              case Ps of
                5: if Tis then IntProp := IntProp + Tisach;
                8: if Mln then IntProp := IntProp + Millionov;
                11: if Mlrd then IntProp := IntProp + Milliardov;
              end;
              Inc(I);
            end
            else
            if IntStr[I] = '2' then IntProp := IntProp + 'двадцать '
            else
            if IntStr[I] = '3' then IntProp := IntProp + 'тридцать '
            else
            if IntStr[I] = '4' then IntProp := IntProp + 'сорок '
            else
            if IntStr[I] = '5' then IntProp := IntProp + 'пятьдесят '
            else
            if IntStr[I] = '6' then IntProp := IntProp + 'шестьдесят '
            else
            if IntStr[I] = '7' then IntProp := IntProp + 'семьдесят '
            else
            if IntStr[I] = '8' then IntProp := IntProp + 'восемьдесят '
            else
            if IntStr[I] = '9' then IntProp := IntProp + 'девяносто ';
          end;
          1, 4, 7, 10:
          begin
            if IntStr[I] = '1' then
            begin
              if Ps = 4 then
                IntProp := IntProp + 'одна '
              else
                IntProp := IntProp + 'один ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisacha;
                7: if Mln then IntProp := IntProp + Million;
                10: if Mlrd then IntProp := IntProp + Milliard;
              end;
            end
            else
            if IntStr[I] = '2' then
            begin
              if Ps = 4 then
                IntProp := IntProp + 'две '
              else
                IntProp := IntProp + 'два ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '3' then
            begin
              IntProp := IntProp + 'три ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '4' then
            begin
              IntProp := IntProp + 'четыре ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '5' then
            begin
              IntProp := IntProp + 'пять ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '6' then
            begin
              IntProp := IntProp + 'шесть ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '7' then
            begin
              IntProp := IntProp + 'семь ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '8' then
            begin
              IntProp := IntProp + 'восемь ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '9' then
            begin
              IntProp := IntProp + 'девять ';
              case Ps of
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end;
            if IntStr[I] = '0' then
            begin
              case Ps of
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end;
          end;
        end;
        Inc(I);
      end;
  end;

  if FirstUpper then
  begin
    S2 := UTF8UpperCase(IntProp);
    Result := UTF8Copy(S2, 1, 1) + UTF8Copy(IntProp, 2, UTF8Length(IntProp) - 1);
  end
  else
    Result := IntProp;
end;

function TPrintReportEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TPrintReportEventHandler.CallHandler;
end;

procedure TPrintReportEventHandler.CallHandler(Sender: TfrReport);
begin
  if Proc <> nil then
  begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Exec;
  end;
end;

constructor TdpFunctionLibrary.Create;
begin
  inherited Create;
  Add('SUMPROP');
  Add('INTPROPIS');
  Add('CEIL');
end;

procedure TdpFunctionLibrary.DoFunction(FNo: Integer; p1, p2, p3: Variant;
  var val: Variant);
begin
  val := 0;
  case FNo of
    0: val := SumProp(frParser.Calc(p1), frParser.Calc(P2), frParser.Calc(P3));
    1: val := IntPropis(frParser.Calc(p1), frParser.Calc(P2));
    2: val := ceil(frParser.Calc(p1));
  end;
end;

procedure TdpFunctionLibrary.UpdateDescriptions;
begin
  AddFunctionDesc('SUMPROP', SStringCategory, 'SUMPROP(<Value>, <SmallFormat>, <UpperFirst>)/Return money as text');
  AddFunctionDesc('INTPROPIS', SStringCategory, 'INTPROPIS(<Value>, <UpperFirst>)/Return Integer digit as text');
  AddFunctionDesc('CEIL', SMathCategory, 'CEIL(<Value>)/Round up');
end;

{ TFunctionEventHandler }

function TFunctionEventHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TFunctionEventHandler.CallHandler;
end;

procedure TFunctionEventHandler.CallHandler(const AName: String; p1, p2,
  p3: Variant; var Val: Variant);
begin
  Proc.Param[0].Value := AName;
  Proc.Param[1].Value := p1;
  Proc.Param[2].Value := p2;
  Proc.Param[3].Value := p3;
  Proc.Param[4].Value := Val;
  Proc.Exec;
  Val := Proc.Param[4].Value;
end;

{ TEnterRectEventHandler }

function TEnterRectEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TEnterRectEventHandler.CallHandler;
end;

procedure TEnterRectEventHandler.CallHandler(Memo: TStringList; View: TfrView);
begin
  Proc.Param[0].Value := TSuPtr( Memo );
  Proc.Param[1].Value := TSuPtr( View );
  Proc.Exec;
end;


{ TBeginEndPageEventHandler }

function TBeginEndPageEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TBeginEndPageEventHandler.CallHandler;
end;

procedure TBeginEndPageEventHandler.CallHandler(pgNo: Integer);
begin
  Proc.Param[0].Value := pgNo;
  Proc.Exec;
end;

{ TDetailEventHandler }

function TDetailEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDetailEventHandler.CallHandler;
end;

procedure TDetailEventHandler.CallHandler(const ParName: String;
  var ParValue: Variant);
begin
  Proc.Param[0].Value := ParName;
  Proc.Param[1].Value := ParValue;
  Proc.Exec;
  ParValue := Proc.Param[1].Value;
end;

{ TBeginDocEventHandler }

function TBeginEndDocEventHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TBeginEndDocEventHandler.CallHandler;
end;

procedure TBeginEndDocEventHandler.CallHandler;
begin
  Proc.Exec;
end;


{ TLazReportImport }

function TLazReportImport.frEMFPages_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrEMFPages(Instance).Add(TfrPage( TSuPtr( Params[0] ) ));
end;

function TLazReportImport.frEMFPages_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrEMFPages(Instance).Clear;
end;

function TLazReportImport.frEMFPages_Count(Instance: Pointer): Variant;
begin
  Result := TfrEMFPages(Instance).Count;
end;

function TLazReportImport.frEMFPages_Delete(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrEMFPages(Instance).Delete(Params[0]);
end;

function TLazReportImport.frEMFPages_Insert(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrEMFPages(Instance).Insert(Params[0], TfrPage( TSuPtr( Params[1] ) ));
end;

function TLazReportImport.frObject_Assign(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrObject(Instance).Assign(TfrView(TSuPtr(Params[0])));
end;

function TLazReportImport.frObject_MemoGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TfrObject(Instance).Memo);
end;

procedure TLazReportImport.frObject_MemoSet(Instance: Pointer; AValue: Variant);
begin
  TfrObject(Instance).Memo := TfrMemoStrings( TSuPtr(AValue) );
end;

function TLazReportImport.frPages_Add(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPages(Instance).Add(Params[0]);
end;

function TLazReportImport.frPages_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPages(Instance).Clear;
end;

function TLazReportImport.frPages_Count(Instance: Pointer): Variant;
begin
  Result := TfrPages(Instance).Count;
end;

function TLazReportImport.frPages_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPages(Instance).Delete(Params[0]);
end;

function TLazReportImport.frPages_PageByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TfrPages(Instance).PageByName(Params[0]) );
end;

function TLazReportImport.frPages_Pages(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TfrPages(Instance).Pages[Params[0]] );
end;

function TLazReportImport.frPage_AdvanceRow(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPage(Instance).AdvanceRow(TfrBand( TSuPtr(Params[0]) ));
end;

function TLazReportImport.frPage_BottomMargin(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPage(Instance).BottomMargin;
end;

function TLazReportImport.frPage_ChangePaper(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPage(Instance).ChangePaper(Params[0], Params[1], Params[2], Params[3]);
end;

function TLazReportImport.frPage_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPage(Instance).Clear;
end;

function TLazReportImport.frPage_ColCountGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).ColCount;
end;

procedure TLazReportImport.frPage_ColCountSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrPage(Instance).ColCount:= AValue;
end;

function TLazReportImport.frPage_ColGapGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).ColGap;
end;

procedure TLazReportImport.frPage_ColGapSet(Instance: Pointer; AValue: Variant);
begin
  TfrPage(Instance).ColGap := AValue;
end;

function TLazReportImport.frPage_ColWidthGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).ColWidth;
end;

procedure TLazReportImport.frPage_ColWidthSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrPage(Instance).ColWidth := AValue;
end;

function TLazReportImport.frPage_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TfrPage(Instance).Create(Params[0], Params[1], Params[2], Params[3]) );
end;

function TLazReportImport.frPage_CreatePage(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TfrPage(Instance).CreatePage );
end;

function TLazReportImport.frPage_CurBottomYGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).CurBottomY;
end;

procedure TLazReportImport.frPage_CurBottomYSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).CurBottomY := AValue;
end;

function TLazReportImport.frPage_CurYGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).CurY;
end;

procedure TLazReportImport.frPage_CurYSet(Instance: Pointer; AValue: Variant);
begin
  TfrPage(Instance).CurY := AValue;
end;

function TLazReportImport.frPage_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPage(Instance).Delete(Params[0]);
end;

function TLazReportImport.frPage_FindObject(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TfrPage(Instance).FindObject(Params[0]) );
end;

function TLazReportImport.frPage_FindObjectByID(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPage(Instance).FindObjectByID(Params[0]);
end;

function TLazReportImport.frPage_FindRTObject(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TfrPage(Instance).FindRTObject(Params[0]) );
end;

function TLazReportImport.frPage_LastBandTypeGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).LastBandType;
end;

procedure TLazReportImport.frPage_LastBandTypeSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).LastBandType := AValue;
end;

function TLazReportImport.frPage_LastRowHeightGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).LastRowHeight;
end;

procedure TLazReportImport.frPage_LastRowHeightSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).LastRowHeight := AValue;
end;

function TLazReportImport.frPage_LayoutOrderGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).LayoutOrder;
end;

procedure TLazReportImport.frPage_LayoutOrderSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).LayoutOrder := AValue;
end;

function TLazReportImport.frPage_LeftMargin(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPage(Instance).LeftMargin;
end;

function TLazReportImport.frPage_MarginsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TfrPage(Instance).Margins );
end;

procedure TLazReportImport.frPage_MarginsSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrPage(Instance).Margins := TfrRect( TSuPtr( AValue ) );
end;

function TLazReportImport.frPage_NewColumn(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPage(Instance).NewColumn(TfrBand(TSuPtr( Params[0] )));
end;

function TLazReportImport.frPage_NewPage(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPage(Instance).NewPage;
end;

function TLazReportImport.frPage_NextColumn(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPage(Instance).NextColumn(TfrBand( TSuPtr( Params[0] ) ));
end;

function TLazReportImport.frPage_OrientationGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).Orientation;
end;

procedure TLazReportImport.frPage_OrientationSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).Orientation := AValue;
end;

function TLazReportImport.frPage_PrintToPrevPageGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).PrintToPrevPage;
end;

procedure TLazReportImport.frPage_PrintToPrevPageSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).PrintToPrevPage := AValue;
end;

function TLazReportImport.frPage_RightMargin(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPage(Instance).RightMargin;
end;

function TLazReportImport.frPage_RowsLayout(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPage(Instance).RowsLayout;
end;

function TLazReportImport.frPage_RowStartedGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).RowStarted;
end;

procedure TLazReportImport.frPage_RowStartedSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).RowStarted := AValue;
end;

function TLazReportImport.frPage_ShowBandByName(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPage(Instance).ShowBandByName(Params[0]);
end;

function TLazReportImport.frPage_ShowBandByType(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPage(Instance).ShowBandByType(Params[0]);
end;

function TLazReportImport.frPage_StartColumn(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPage(Instance).StartColumn;
end;

function TLazReportImport.frPage_StartRowsLayoutNonDataBand(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPage(Instance).StartRowsLayoutNonDataBand(TfrBand( TSuPtr( Params[0] ) ));
end;

function TLazReportImport.frPage_TopMargin(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPage(Instance).TopMargin;
end;

function TLazReportImport.frPage_UseMarginsGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).UseMargins;
end;

procedure TLazReportImport.frPage_UseMarginsSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPage(Instance).UseMargins := AValue;
end;

function TLazReportImport.frPreview_AllPagesGet(Instance: Pointer): Variant;
begin
  Result := TfrPreview(Instance).AllPages;
end;

function TLazReportImport.frPreview_Connect(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPreview(Instance).Connect(Pointer(TSuPtr(Params[0])));
end;

function TLazReportImport.frPreview_Edit(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPreview(Instance).Edit;
end;

function TLazReportImport.frPreview_ExportTo(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrPreview(Instance).ExportTo(Params[0]);
end;

function TLazReportImport.frPreview_Find(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPreview(Instance).Find;
end;

function TLazReportImport.frPreview_First(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPreview(Instance).First;
end;

function TLazReportImport.frPreview_Last(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPreview(Instance).Last;
end;

function TLazReportImport.frPreview_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPreview(Instance).LoadFromFile;
end;

function TLazReportImport.frPreview_Next(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPreview(Instance).Next;
end;

function TLazReportImport.frPreview_OnePage(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPreview(Instance).OnePage;
end;

function TLazReportImport.frPreview_PageGet(Instance: Pointer): Variant;
begin
  Result := TfrPreview(Instance).Page;
end;

procedure TLazReportImport.frPreview_PageSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrPreview(Instance).Page := AValue;
end;

function TLazReportImport.frPreview_PageWidth(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPreview(Instance).PageWidth;
end;

function TLazReportImport.frPreview_Prev(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrPreview(Instance).Prev;
end;

function TLazReportImport.frPreview_Print(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TfrPreview(Instance).Print;
end;

function TLazReportImport.frPreview_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPreview(Instance).SaveToFile;
end;

function TLazReportImport.frPreview_TwoPages(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrPreview(Instance).TwoPages;
end;

function TLazReportImport.frPreview_ZoomGet(Instance: Pointer): Variant;
begin
  Result := TfrPreview(Instance).Zoom;
end;

procedure TLazReportImport.frPreview_ZoomSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrPreview(Instance).Zoom := AValue;
end;

function TLazReportImport.frReport_ChangePrinter(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrReport(Instance).ChangePrinter(Params[0], Params[1]);
end;

function TLazReportImport.frReport_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrReport(Instance).Clear;
end;

function TLazReportImport.frReport_CommentsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TfrReport(Instance).Comments);
end;

procedure TLazReportImport.frReport_CommentsSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).Comments := TStringList(TSuPtr(AValue));
end;

function TLazReportImport.frReport_DesignReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).DesignReport;
end;

function TLazReportImport.frReport_EditPreparedReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).EditPreparedReport(Params[0]);
end;

function TLazReportImport.frReport_EMFPagesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TfrReport(Instance).EMFPages );
end;

{function TLazReportImport.frReport_ExportTo(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).ExportTo(TfrExportFilterClass(TSuPtr(Params[0])), Params[1]);
end;}

function TLazReportImport.frReport_FileNameGet(Instance: Pointer): Variant;
begin
  Result := TfrReport(Instance).FileName;
end;

procedure TLazReportImport.frReport_FileNameSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).FileName := AValue;
end;

function TLazReportImport.frReport_FillQueryParams(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).FillQueryParams;
end;

function TLazReportImport.frReport_FinalPassGet(Instance: Pointer): Variant;
begin
  Result := TfrReport(Instance).FinalPass;
end;

procedure TLazReportImport.frReport_FinalPassSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).FinalPass := AValue;
end;

function TLazReportImport.frReport_FindObject(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TfrReport(Instance).FindObject(Params[0]) );
end;

function TLazReportImport.frReport_FindVariable(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrReport(Instance).FindVariable(Params[0]);
end;

function TLazReportImport.frReport_GetCategoryList(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).GetCategoryList(TStrings(TSuPtr(Params[0])));
end;

function TLazReportImport.frReport_GetVariableValue(Instance: TObject;
  var Params: Variant): Variant;
var
  VarValue: Variant;
begin
  VarValue := Params[1];
  TfrReport(Instance).GetVariableValue(Params[0], Params[1]);
  Params[1] := VarValue;
end;

function TLazReportImport.frReport_GetVarList(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).GetVarList(Params[0], TStrings(TSuPtr(Params[1])));
end;

function TLazReportImport.frReport_KeyWordsGet(Instance: Pointer): Variant;
begin
  Result := TfrReport(Instance).KeyWords;
end;

procedure TLazReportImport.frReport_KeyWordsSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).KeyWords := AValue;
end;

function TLazReportImport.frReport_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).LoadFromFile(Params[0]);
end;

function TLazReportImport.frReport_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).LoadFromStream(TStream(TSuPtr(Params[0])));
end;

function TLazReportImport.frReport_LoadFromXMLFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).LoadFromXMLFile(Params[0]);
end;

function TLazReportImport.frReport_LoadFromXMLStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).LoadFromXMLStream(TStream( TSuPtr( Params[0] ) ));
end;

function TLazReportImport.frReport_LoadPreparedReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).LoadPreparedReport(Params[0]);
end;

function TLazReportImport.frReport_LoadTemplate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).LoadTemplate(Params[0], TStrings(TSuPtr(Params[1])), TBitmap(TSuPtr(Params[2])), Params[3]);
end;

function TLazReportImport.frReport_PagesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TfrReport(Instance).Pages);
end;

function TLazReportImport.frReport_PrepareReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrReport(Instance).PrepareReport;
end;

function TLazReportImport.frReport_PrintPreparedReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).PrintPreparedReport(Params[0], Params[1]);
end;

function TLazReportImport.frReport_ReportAutorGet(Instance: Pointer): Variant;
begin
  Result := TfrReport(Instance).ReportAutor;
end;

procedure TLazReportImport.frReport_ReportAutorSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).ReportAutor := AValue;
end;

function TLazReportImport.frReport_ReportCreateDateGet(Instance: Pointer
  ): Variant;
begin
  Result := TfrReport(Instance).ReportCreateDate;
end;

procedure TLazReportImport.frReport_ReportCreateDateSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).ReportCreateDate := AValue;
end;

function TLazReportImport.frReport_ReportLastChangeGet(Instance: Pointer
  ): Variant;
begin
  Result := TfrReport(Instance).ReportLastChange;
end;

procedure TLazReportImport.frReport_ReportLastChangeSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).ReportLastChange := AValue;
end;

function TLazReportImport.frReport_ReportVersionBuildGet(Instance: Pointer
  ): Variant;
begin
  Result := TfrReport(Instance).ReportVersionBuild;
end;

procedure TLazReportImport.frReport_ReportVersionBuildSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).ReportVersionBuild := AValue;
end;

function TLazReportImport.frReport_ReportVersionMajorGet(Instance: Pointer
  ): Variant;
begin
  Result := TfrReport(Instance).ReportVersionMajor;
end;

procedure TLazReportImport.frReport_ReportVersionMajorSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).ReportVersionMajor := AValue;
end;

function TLazReportImport.frReport_ReportVersionMinorGet(Instance: Pointer
  ): Variant;
begin
  Result := TfrReport(Instance).ReportVersionMinor;
end;

procedure TLazReportImport.frReport_ReportVersionMinorSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).ReportVersionMinor := AValue;
end;

function TLazReportImport.frReport_ReportVersionReleaseGet(Instance: Pointer
  ): Variant;
begin
  Result := TfrReport(Instance).ReportVersionRelease;
end;

procedure TLazReportImport.frReport_ReportVersionReleaseSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).ReportVersionRelease := AValue;
end;

function TLazReportImport.frReport_SavePreparedReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).SavePreparedReport(Params[0]);
end;

function TLazReportImport.frReport_SaveTemplate(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).SaveTemplate(Params[0], TStrings(TSuPtr(Params[1])), TBitmap(TSuPtr(Params[2])));
end;

function TLazReportImport.frReport_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TfrReport(Instance).SaveToFile(S);
end;

function TLazReportImport.frReport_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TLazReportImport.frReport_SaveToXMLFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).SaveToXMLFile(Params[0]);
end;

function TLazReportImport.frReport_SaveToXMLStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).SaveToXMLStream(TStream(TSuPtr(Params[0])));
end;

function TLazReportImport.frReport_ShowPreparedReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).ShowPreparedReport;
end;

function TLazReportImport.frReport_ShowReport(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrReport(Instance).ShowReport;
end;

function TLazReportImport.frReport_SubjectGet(Instance: Pointer): Variant;
begin
  Result := TfrReport(Instance).Subject;
end;

procedure TLazReportImport.frReport_SubjectSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).Subject := AValue;
end;

function TLazReportImport.frReport_TerminatedGet(Instance: Pointer): Variant;
begin
  Result := TfrReport(Instance).Terminated;
end;

procedure TLazReportImport.frReport_TerminatedSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).Terminated := AValue;
end;

function TLazReportImport.frReport_ValuesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TfrReport(Instance).Values );
end;

procedure TLazReportImport.frReport_ValuesSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrReport(Instance).Values := TfrValues( TSuPtr(AValue) );
end;

function TLazReportImport.frReport_VariablesGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TfrReport(Instance).Variables);
end;

procedure TLazReportImport.frReport_VariablesSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrReport(Instance).Variables := TStrings(TSuPtr(AValue));
end;

function TLazReportImport.frValues_AddValue(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrValues(Instance).AddValue;
end;

function TLazReportImport.frValues_Clear(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TfrValues(Instance).Clear;
end;

function TLazReportImport.frValues_FindVariable(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TfrValues(Instance).FindVariable(Params[0]) );
end;

function TLazReportImport.frValues_ItemsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TfrValues(Instance).Items );
end;

procedure TLazReportImport.frValues_ItemsSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrValues(Instance).Items := TStringList( TSuPtr( AValue ) );
end;

function TLazReportImport.frValues_ObjectsGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TfrValues(Instance).Objects[Params[0]] );
end;

function TLazReportImport.frValue_DataSetGet(Instance: Pointer): Variant;
begin
  Result := TfrValue(Instance).DataSet;
end;

procedure TLazReportImport.frValue_DataSetSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrValue(Instance).DataSet := AValue;
end;

function TLazReportImport.frValue_DSetGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TfrValue(Instance).DSet );
end;

procedure TLazReportImport.frValue_DSetSet(Instance: Pointer; AValue: Variant);
begin
  TfrValue(Instance).DSet := TfrTDataSet( TSuPtr(AValue) );
end;

function TLazReportImport.frValue_FieldGet(Instance: Pointer): Variant;
begin
  Result := TfrValue(Instance).Field;
end;

procedure TLazReportImport.frValue_FieldSet(Instance: Pointer; AValue: Variant);
begin
  TfrValue(Instance).Field := AValue;
end;

function TLazReportImport.frValue_OtherKindGet(Instance: Pointer): Variant;
begin
  Result := TfrValue(Instance).OtherKind;
end;

procedure TLazReportImport.frValue_OtherKindSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrValue(Instance).OtherKind := AValue;
end;

function TLazReportImport.frValue_TypGet(Instance: Pointer): Variant;
begin
  Result := TfrValue(Instance).Typ;
end;

procedure TLazReportImport.frValue_TypSet(Instance: Pointer; AValue: Variant);
begin
  TfrValue(Instance).Typ := AValue;
end;

function TLazReportImport.frVariables_Clear(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrVariables(Instance).Clear;
end;

function TLazReportImport.frVariables_Count(Instance: Pointer): Variant;
begin
  Result := TfrVariables(Instance).Count;
end;

function TLazReportImport.frVariables_Delete(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrVariables(Instance).Delete(Params[0]);
end;

function TLazReportImport.frVariables_IndexOf(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrVariables(Instance).IndexOf(Params[0]);
end;

function TLazReportImport.frVariables_NameGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrVariables(Instance).Name[Params[0]];
end;

function TLazReportImport.frVariables_ValueGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrVariables(Instance).Variable[Params[0]];
end;

function TLazReportImport.frVariables_ValueSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrVariables(Instance).Value[Params[0]] := Params[1];
end;

function TLazReportImport.frVariables_VariableGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TfrVariables(Instance).Variable[Params[0]];
end;

function TLazReportImport.frVariables_VariableSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  TfrVariables(Instance).Variable[Params[0]] := Params[1];
end;

function TLazReportImport.frView_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TfrView.Create( TfrPage(TSuPtr(Params[0])) ) );
end;

function TLazReportImport.frView_FillColorGet(Instance: Pointer): Variant;
begin
  Result := TfrView(Instance).FillColor;
end;

procedure TLazReportImport.frView_FillColorSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrView(Instance).FillColor := AValue;
end;

function TLazReportImport.frView_FormatGet(Instance: Pointer): Variant;
begin
  Result := TfrView(Instance).Format;
end;

procedure TLazReportImport.frView_FormatSet(Instance: Pointer; AValue: Variant);
begin
  TfrView(Instance).Format := AValue;
end;

function TLazReportImport.frView_FrameColorGet(Instance: Pointer): Variant;
begin
  Result := TfrView(Instance).FrameColor;
end;

procedure TLazReportImport.frView_FrameColorSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrView(Instance).FrameColor := AValue;
end;


type
  PfrFrameBorders = ^TfrFrameBorders;

function TLazReportImport.frView_FramesGet(Instance: Pointer): Variant;
begin
  Result := Longint( TfrView(Instance).Frames );
end;

procedure TLazReportImport.frView_FramesSet(Instance: Pointer; AValue: Variant);
var
  FrBord: PfrFrameBorders;
begin
  FrBord := PfrFrameBorders(TSuPtr(AValue));
  TfrView(Instance).Frames := FrBord^;
end;

function TLazReportImport.frView_FrameStyleGet(Instance: Pointer): Variant;
begin
  Result := TfrView(Instance).FrameStyle;
end;

procedure TLazReportImport.frView_FrameStyleSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrView(Instance).FrameStyle := AValue;
end;

function TLazReportImport.frView_FrameWidthGet(Instance: Pointer): Variant;
begin
  Result := TfrView(Instance).FrameWidth;
end;

procedure TLazReportImport.frView_FrameWidthSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrView(Instance).FrameWidth := AValue;
end;

function TLazReportImport.frView_StretchedGet(Instance: Pointer): Variant;
begin
  Result := TfrView(Instance).Stretched;
end;

procedure TLazReportImport.frView_StretchedSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrView(Instance).Stretched := AValue;
end;

function TLazReportImport.frPage_pgSizeGet(Instance: Pointer): Variant;
begin
  Result := TfrPage(Instance).pgSize;
end;

procedure TLazReportImport.frPage_pgSizeSet(Instance: Pointer; AValue: Variant);
begin
  TfrPage(Instance).pgSize := AValue;
end;

function TLazReportImport.frPrinter_OrientationGet(Instance: Pointer): Variant;
begin
  Result := TfrPrinter(Instance).Orientation;
end;

procedure TLazReportImport.frPrinter_OrientationSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPrinter(Instance).Orientation := AValue;
end;

function TLazReportImport.frPrinter_PaperHeightGet(Instance: Pointer): Variant;
begin
  Result := TfrPrinter(Instance).PaperHeight;
end;

procedure TLazReportImport.frPrinter_PaperHeightSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPrinter(Instance).PaperHeight := AValue;
end;

function TLazReportImport.frPrinter_PaperSizeGet(Instance: Pointer): Variant;
begin
  Result := TfrPrinter(Instance).PaperSize;
end;

procedure TLazReportImport.frPrinter_PaperSizeSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPrinter(Instance).PaperSize := AValue;
end;

function TLazReportImport.frPrinter_PaperSizesNumGet(Instance: Pointer
  ): Variant;
begin
  Result := TfrPrinter(Instance).PaperSizesNum;
end;

procedure TLazReportImport.frPrinter_PaperSizesNumSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPrinter(Instance).PaperSizesNum := AValue;
end;

function TLazReportImport.frPrinter_PaperWidthGet(Instance: Pointer): Variant;
begin
  Result := TfrPrinter(Instance).PaperWidth;
end;

procedure TLazReportImport.frPrinter_PaperWidthSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPrinter(Instance).PaperWidth:= AValue;
end;

function TLazReportImport.frPrinter_PrinterGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TfrPrinter(Instance).Printer );
end;

procedure TLazReportImport.frPrinter_PrinterSet(Instance: Pointer;
  AValue: Variant);
begin
  TfrPrinter(Instance).Printer := TPrinter( TSuPtr(AValue) );
end;

function TLazReportImport.frReport_PrepareDesigner(Instance: TObject;
  var Params: Variant): Variant;
begin
  if not Assigned(frDesigner)  and Assigned(ProcedureInitDesigner)  then
    ProcedureInitDesigner();
end;

function TLazReportImport.fr_PrinterIndexGet(Instance: Pointer): Variant;
begin
  Result := TfrPrinter(Instance).PrinterIndex;
end;

procedure TLazReportImport.fr_PrinterIndexSet(Instance: Pointer; AValue: Variant
  );
begin
  TfrPrinter(Instance).PrinterIndex := AValue;
end;

function TLazReportImport.fr_PrintersGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TfrPrinter(Instance).Printers );
end;

function TLazReportImport.Printer_Abort(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TPrinter(Instance).Abort;
end;

function TLazReportImport.Printer_BeginDoc(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPrinter(Instance).BeginDoc;
end;

function TLazReportImport.Printer_CanPrintGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).CanPrint;
end;

function TLazReportImport.Printer_CanvasGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPrinter(Instance).Canvas );
end;

function TLazReportImport.Printer_CopiesGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).Copies;
end;

procedure TLazReportImport.Printer_CopiesSet(Instance: Pointer; AValue: Variant
  );
begin
  TPrinter(Instance).Copies := AValue;
end;

function TLazReportImport.Printer_EndDoc(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TPrinter(Instance).EndDoc;
end;

function TLazReportImport.Printer_FileNameGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).FileName;
end;

procedure TLazReportImport.Printer_FileNameSet(Instance: Pointer;
  AValue: Variant);
begin
  TPrinter(Instance).FileName := AValue;
end;

function TLazReportImport.Printer_FontsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPrinter(Instance).Fonts );
end;

function TLazReportImport.Printer_PageHeightGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).PageHeight;
end;

function TLazReportImport.Printer_PageNumberGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).PageNumber;
end;

function TLazReportImport.Printer_PageWidthGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).PageWidth;
end;

function TLazReportImport.Printer_PrinterIndexGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).PrinterIndex;
end;

procedure TLazReportImport.Printer_PrinterIndexSet(Instance: Pointer;
  AValue: Variant);
begin
  TPrinter(Instance).PrinterIndex := AValue;
end;

function TLazReportImport.Printer_PrinterNameGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).PrinterName;
end;

function TLazReportImport.Printer_PrintersGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TPrinter(Instance).Printers);
end;

function TLazReportImport.Printer_PrinterTypeGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).PrinterType;
end;

function TLazReportImport.Printer_PrintingGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).Printing;
end;

function TLazReportImport.Printer_Refresh(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TPrinter(Instance).Refresh;
end;

function TLazReportImport.Printer_SetPrinter(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPrinter(Instance).SetPrinter(Params[0]);
end;

function TLazReportImport.Printer_TitleGet(Instance: Pointer): Variant;
begin
  Result := TPrinter(Instance).Title;
end;

procedure TLazReportImport.Printer_TitleSet(Instance: Pointer; AValue: Variant);
begin
  TPrinter(Instance).Title := AValue;
end;

procedure TLazReportImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TfrReport).ClassImporter := Self;
  AddClass(TfrDBDataSet);
  AddClass(TfrCompositeReport); //.ClassImporter := Self;
  AddClass(TfrUserDataset);
  AddClass(TfrTextExport);
  AddClass(TfrHTMExport);
  AddClass(TfrCSVExport);
  AddClass(TfrDesigner);
  AddClass(TfrPreview).ClassImporter := Self;

  AddClass(TfrObject).ClassImporter := Self;
  AddClass(TfrView).ClassImporter := Self;
  AddClass(TfrMemoView);
  AddClass(TfrBarCodeObject);
  AddClass(TfrBarCodeView);
  AddClass(TfrShapeObject);
  AddClass(TfrShapeView);
  AddClass(TfrCheckBoxObject);
  AddClass(TfrCheckBoxView);
  AddClass(TfrRoundRectObject);
  AddClass(TfrRoundRectView);
  AddClass(TfrPictureView);//.ClassImporter := Self;
  AddClass(TfrBand);
  //AddClass(TfrExportFilterClass);
  AddClass(TfrRect);
  AddClass(TfrPage).ClassImporter := Self;
  AddClass(TfrPages).ClassImporter := Self;
  AddClass(TfrEMFPages).ClassImporter := Self;
  AddClass(TfrMemoStrings);

  AddClass(TfrValues).ClassImporter := Self;
  AddClass(TfrValue).ClassImporter := Self;

  AddClass(TfrTDataSet);
  AddClass(TfrTField);
  AddClass(TfrTBlobField);
  AddClass(TfrVariables).ClassImporter := Self;

  AddClass(TfrPrinter).ClassImporter := Self;
  AddClass(TPrinter).ClassImporter := Self;
  {$IfDef LRCAIROEXP}
  AddClass(TlrCairoExport);
  {$EndIf}
  //frVariables;
end;

procedure TLazReportImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TfrReport then
  begin
    AType.AddMethod('procedure Clear', @frReport_Clear);
    AType.AddMethod('function FindVariable(Variable: String): Integer', @frReport_FindVariable);
    AType.AddMethod('procedure GetVariableValue(const s: String; var aValue: Variant)', @frReport_GetVariableValue);
    AType.AddMethod('procedure GetVarList(CatNo: Integer; List: TStrings)', @frReport_GetVarList);
    AType.AddMethod('procedure GetCategoryList(List: TStrings)', @frReport_GetCategoryList);
    AType.AddMethod('function FindObject(const aName: String): TfrObject', @frReport_FindObject);
    AType.AddMethod('procedure FillQueryParams', @frReport_FillQueryParams);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @frReport_LoadFromStream);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @frReport_SaveToStream);
    AType.AddMethod('procedure LoadFromFile(const FName: String)', @frReport_LoadFromFile);
    AType.AddMethod('procedure LoadFromXMLFile(const Fname: String)', @frReport_LoadFromXMLFile);
    AType.AddMethod('procedure LoadFromXMLStream(const Stream: TStream)', @frReport_LoadFromXMLStream);
    AType.AddMethod('procedure SaveToFile(FName: String)', @frReport_SaveToFile);
    AType.AddMethod('procedure SaveToXMLFile(const FName: String)', @frReport_SaveToXMLFile);
    AType.AddMethod('procedure SaveToXMLStream(const Stream: TStream)', @frReport_SaveToXMLStream);
    AType.AddMethod('procedure LoadTemplate(const fname: String; comm: TStrings; Bmp: TBitmap; Load: Boolean)', @frReport_LoadTemplate);
    AType.AddMethod('procedure SaveTemplate(const fname: String; comm: TStrings; Bmp: TBitmap)', @frReport_SaveTemplate);
    AType.AddMethod('procedure LoadPreparedReport(const FName: String)', @frReport_LoadPreparedReport);
    AType.AddMethod('procedure SavePreparedReport(const FName: String)', @frReport_SavePreparedReport);
    AType.AddMethod('procedure DesignReport', @frReport_DesignReport);
    AType.AddMethod('procedure PrepareDsigner', @frReport_PrepareDesigner);
    AType.AddMethod('function PrepareReport: Boolean', @frReport_PrepareReport);
    //AType.AddMethod('procedure ExportTo(FilterClass: TfrExportFilterClass; const aFileName: String)', @frReport_ExportTo);
    AType.AddMethod('procedure ShowReport', @frReport_ShowReport);
    AType.AddMethod('procedure ShowPreparedReport', @frReport_ShowPreparedReport);
    AType.AddMethod('procedure PrintPreparedReport(const PageNumbers: String; Copies: Integer)', @frReport_PrintPreparedReport);
    AType.AddMethod('function ChangePrinter(OldIndex, NewIndex: Integer): Boolean', @frReport_ChangePrinter);
    AType.AddMethod('procedure EditPreparedReport(PageIndex: Integer)', @frReport_EditPreparedReport);

    AType.AddProp('Subject', 'string', @frReport_SubjectGet, @frReport_SubjectSet);
    AType.AddProp('KeyWords', 'string', @frReport_KeyWordsGet, @frReport_KeyWordsSet);
    AType.AddProp('Comments', 'TStringList', @frReport_CommentsGet, @frReport_CommentsSet);
    AType.AddProp('ReportAutor', 'string', @frReport_ReportAutorGet, @frReport_ReportAutorSet);
    AType.AddProp('ReportVersionMajor', 'string', @frReport_ReportVersionMajorGet, @frReport_ReportVersionMajorSet);
    AType.AddProp('ReportVersionMinor', 'string', @frReport_ReportVersionMinorGet, @frReport_ReportVersionMinorSet);
    AType.AddProp('ReportVersionRelease', 'string', @frReport_ReportVersionReleaseGet, @frReport_ReportVersionReleaseSet);
    AType.AddProp('ReportVersionBuild', 'string', @frReport_ReportVersionBuildGet, @frReport_ReportVersionBuildSet);
    AType.AddProp('ReportCreateDate', 'TDateTime', @frReport_ReportCreateDateGet, @frReport_ReportCreateDateSet);
    AType.AddProp('ReportLastChange', 'TDateTime', @frReport_ReportLastChangeGet, @frReport_ReportLastChangeSet);

    AType.AddProp('Pages', 'TfrPages', @frReport_PagesGet);
    AType.AddProp('EMFPages', 'TfrEMFPages', @frReport_EMFPagesGet);
    AType.AddProp('Variables', 'TStrings', @frReport_VariablesGet, @frReport_VariablesSet);
    AType.AddProp('Values', 'TfrValues', @frReport_ValuesGet, @frReport_ValuesSet);

    AType.AddProp('FinalPass', 'Boolean', @frReport_FinalPassGet, @frReport_FinalPassSet);
    AType.AddProp('FileName', 'String', @frReport_FileNameGet, @frReport_FileNameSet);
    AType.AddProp('Terminated', 'Boolean', @frReport_TerminatedGet, @frReport_TerminatedSet);
  end
  else
  if AType.ValueClassType = TfrPreview then
  begin
    AType.AddMethod('procedure Connect(Doc: TfrReport)', @frPreview_Connect);
    AType.AddMethod('procedure OnePage', @frPreview_OnePage);
    AType.AddMethod('procedure TwoPages', @frPreview_TwoPages);
    AType.AddMethod('procedure PageWidth', @frPreview_PageWidth);
    AType.AddMethod('procedure First', @frPreview_First);
    AType.AddMethod('procedure Next', @frPreview_Next);
    AType.AddMethod('procedure Prev', @frPreview_Prev);
    AType.AddMethod('procedure Last', @frPreview_Last);
    AType.AddMethod('procedure SaveToFile', @frPreview_SaveToFile);
    AType.AddMethod('procedure LoadFromFile', @frPreview_LoadFromFile);
    AType.AddMethod('function Print: boolean', @frPreview_Print);
    AType.AddMethod('procedure Edit', @frPreview_Edit);
    AType.AddMethod('procedure Find', @frPreview_Find);
    AType.AddMethod('function ExportTo(AFileName: string): boolean', @frPreview_ExportTo);

    AType.AddProp('AllPages', 'Integer', @frPreview_AllPagesGet);
    AType.AddProp('Page', 'Integer', @frPreview_PageGet, @frPreview_PageSet);
    AType.AddProp('Zoom', 'Double', @frPreview_ZoomGet, @frPreview_ZoomSet);
  end
  else
  if AType.ValueClassType = TfrObject then
  begin
    AType.AddMethod('procedure Assign(From: TfrView)', @frObject_Assign);
    AType.AddProp('Memo', 'TfrMemoStrings', @frObject_MemoGet, @frObject_MemoSet);

  end
  else
  if AType.ValueClassType = TfrView then
  begin
    AType.AddMethod('constructor Create(From: TfrView)', @frView_Create);
    AType.AddProp('FillColor', 'TColor', @frView_FillColorGet, @frView_FillColorSet);
    AType.AddProp('Stretched', 'Boolean', @frView_StretchedGet, @frView_StretchedSet);
    AType.AddProp('Frames', 'TfrFrameBorders', @frView_FramesGet, @frView_FramesSet);
    AType.AddProp('FrameColor', 'TColor', @frView_FrameColorGet, @frView_FrameColorSet);
    AType.AddProp('FrameStyle', 'TfrFrameStyle', @frView_FrameStyleGet, @frView_FrameStyleSet);
    AType.AddProp('FrameWidth', 'Double', @frView_FrameWidthGet, @frView_FrameWidthSet);
    AType.AddProp('Format', 'Integer', @frView_FormatGet, @frView_FormatSet);
  end
  else
  if AType.ValueClassType = TfrPage then
  begin
    AType.AddMethod('constructor Create(ASize, AWidth, AHeight: Integer; AOr: TPrinterOrientation)', @frPage_Create);
    AType.AddMethod('constructor CreatePage', @frPage_CreatePage);
    AType.AddMethod('function TopMargin: Integer', @frPage_TopMargin);
    AType.AddMethod('function BottomMargin: Integer', @frPage_BottomMargin);
    AType.AddMethod('function LeftMargin: Integer', @frPage_LeftMargin);
    AType.AddMethod('function RightMargin: Integer', @frPage_RightMargin);
    AType.AddMethod('procedure Clear', @frPage_Clear);
    AType.AddMethod('procedure Delete(Index: Integer)', @frPage_Delete);
    AType.AddMethod('function FindObjectByID(ID: Integer): Integer', @frPage_FindObjectByID);
    AType.AddMethod('function FindObject(const aName: String): TfrObject', @frPage_FindObject);
    AType.AddMethod('function FindRTObject(const aName: String): TfrObject', @frPage_FindRTObject);
    AType.AddMethod('procedure ChangePaper(ASize, AWidth, AHeight: Integer; AOr: TPrinterOrientation)', @frPage_ChangePaper);
    AType.AddMethod('procedure ShowBandByName(const s: String)', @frPage_ShowBandByName);
    AType.AddMethod('procedure ShowBandByType(bt: TfrBandType)', @frPage_ShowBandByType);
    AType.AddMethod('procedure NewPage', @frPage_NewPage);
    AType.AddMethod('procedure NewColumn(Band: TfrBand)', @frPage_NewColumn);
    AType.AddMethod('procedure NextColumn(Band: TFrBand)', @frPage_NextColumn);
    AType.AddMethod('function RowsLayout: boolean', @frPage_RowsLayout);
    AType.AddMethod('procedure StartColumn', @frPage_StartColumn);
    AType.AddMethod('procedure StartRowsLayoutNonDataBand(Band: TfrBand)', @frPage_StartRowsLayoutNonDataBand);
    AType.AddMethod('function  AdvanceRow(Band: TfrBand): boolean', @frPage_AdvanceRow);

    AType.AddProp('ColCount', 'Integer', @frPage_ColCountGet, @frPage_ColCountSet);
    AType.AddProp('ColWidth', 'Integer', @frPage_ColWidthGet, @frPage_ColWidthSet);
    AType.AddProp('ColGap', 'Integer', @frPage_ColGapGet, @frPage_ColGapSet);
    AType.AddProp('UseMargins', 'Boolean', @frPage_UseMarginsGet, @frPage_UseMarginsSet);
    AType.AddProp('Margins', 'TfrRect', @frPage_MarginsGet, @frPage_MarginsSet);
    AType.AddProp('PrintToPrevPage', 'Boolean', @frPage_PrintToPrevPageGet, @frPage_PrintToPrevPageSet);
    AType.AddProp('Orientation', 'TPrinterOrientation', @frPage_OrientationGet, @frPage_OrientationSet);
    AType.AddProp('LayoutOrder', 'TLayoutOrder', @frPage_LayoutOrderGet, @frPage_LayoutOrderSet);
    AType.AddProp('LastRowHeight', 'Integer', @frPage_LastRowHeightGet, @frPage_LastRowHeightSet);
    AType.AddProp('RowStarted', 'boolean', @frPage_RowStartedGet, @frPage_RowStartedSet);
    AType.AddProp('LastBandType', 'TfrBandType', @frPage_LastBandTypeGet, @frPage_LastBandTypeSet);
    AType.AddProp('CurY', 'Integer', @frPage_CurYGet, @frPage_CurYSet);
    AType.AddProp('CurBottomY', 'Integer', @frPage_CurBottomYGet, @frPage_CurBottomYSet);
    AType.AddProp('pgSize', 'Integer', @frPage_pgSizeGet, @frPage_pgSizeSet);

  end
  else
  if AType.ValueClassType = TfrPages then
  begin
    AType.AddMethod('procedure Clear', @frPages_Clear);
    AType.AddMethod('procedure Add(const aClassName: string=''TfrPageReport'')', @frPages_Add);
    AType.AddMethod('procedure Delete(Index: Integer)', @frPages_Delete);
    //AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @frPages_LoadFromStream);
    //AType.AddMethod('procedure SaveToStream(Stream: TStream)', @frPages_SaveToStream);
    AType.AddMethod('function PageByName(APageName:string):TfrPage', @frPages_PageByName);
    AType.AddIndexedProp('Pages', 'TfrPage', 'Integer', @frPages_Pages);
    AType.AddProp('Count', 'Integer', @frPages_Count);
  end
  else
  if AType.ValueClassType = TfrEMFPages then
  begin
    AType.AddMethod('procedure Clear', @frEMFPages_Clear);
    AType.AddMethod('procedure Add(APage: TfrPage)', @frEMFPages_Add);
    AType.AddMethod('procedure Insert(Index: Integer; APage: TfrPage)', @frEMFPages_Insert);
    AType.AddMethod('procedure Delete(Index: Integer)', @frEMFPages_Delete);
    AType.AddProp('Count', 'Integer', @frEMFPages_Count);
  end
  else
  if AType.ValueClassType = TfrValues then
  begin
    AType.AddMethod('function AddValue: Integer', @frValues_AddValue);
    AType.AddMethod('function FindVariable(const s: String): TfrValue', @frValues_FindVariable);
    AType.AddMethod('procedure Clear', @frValues_Clear);
    AType.AddProp('Items', 'TStringList', @frValues_ItemsGet, @frValues_ItemsSet);
    AType.AddIndexedProp('Objects', 'TfrValue', 'Integer', @frValues_ObjectsGet);
  end
  else
  if AType.ValueClassType = TfrValue then
  begin
    AType.AddProp('Typ', 'TfrValueType', @frValue_TypGet, @frValue_TypSet);
    AType.AddProp('OtherKind', 'Integer', @frValue_OtherKindGet, @frValue_OtherKindSet);
    AType.AddProp('DataSet', 'String', @frValue_DataSetGet, @frValue_DataSetSet);
    AType.AddProp('Field', 'String', @frValue_FieldGet, @frValue_FieldSet);
    AType.AddProp('DSet', 'TfrTDataSet', @frValue_DSetGet, @frValue_DSetSet);
  end
  else
  if AType.ValueClassType = TfrVariables then
  begin
    AType.AddMethod('procedure Clear', @frVariables_Clear);
    AType.AddMethod('procedure Delete(Index: Integer)', @frVariables_Delete);
    AType.AddMethod('function IndexOf(aName: String): Integer', @frVariables_IndexOf);
    AType.AddProp('Count', 'Integer', @frVariables_Count);
    AType.AddIndexedProp('Variable', 'Variant', 'String', @frVariables_VariableGet, @frVariables_VariableSet);
    AType.AddIndexedProp('Value', 'Variant', 'Integer', @frVariables_ValueGet, @frVariables_ValueSet);
    AType.AddIndexedProp('Name', 'String', 'Integer', @frVariables_NameGet);
  end
  else
  if AType.ValueClassType = TfrPrinter then
  begin
    AType.AddProp('Orientation', 'TPrinterOrientation', @frPrinter_OrientationGet, @frPrinter_OrientationSet);
    AType.AddProp('PaperSize', 'Integer', @frPrinter_PaperSizeGet, @frPrinter_PaperSizeSet);
    AType.AddProp('PaperWidth', 'Integer', @frPrinter_PaperWidthGet, @frPrinter_PaperWidthSet);
    AType.AddProp('PaperHeight', 'Integer', @frPrinter_PaperHeightGet, @frPrinter_PaperHeightSet);
    AType.AddProp('PaperSizesNum', 'Integer', @frPrinter_PaperSizesNumGet, @frPrinter_PaperSizesNumSet);
    AType.AddProp('Printer', 'TPrinter', @frPrinter_PrinterGet, @frPrinter_PrinterSet);
    AType.AddProp('PrinterIndex', 'Integer', @fr_PrinterIndexGet, @fr_PrinterIndexSet);
    AType.AddProp('Printers', 'TStringList', @fr_PrintersGet);
  end
  else
  if AType.ValueClassType = TPrinter then
  begin
    AType.AddProp('PrinterIndex', 'integer', @Printer_PrinterIndexGet, @Printer_PrinterIndexSet);
    AType.AddProp('PrinterName', 'string', @Printer_PrinterNameGet);
    AType.AddProp('Printing', 'Boolean', @Printer_PrintingGet);
    AType.AddProp('PrinterType', 'TPrinterType', @Printer_PrinterTypeGet);
    AType.AddProp('CanPrint', 'Boolean', @Printer_CanPrintGet);
    AType.AddProp('Copies', 'Integer', @Printer_CopiesGet, @Printer_CopiesSet);
    AType.AddProp('Printers', 'TStrings', @Printer_PrintersGet);
    AType.AddProp('FileName', 'string', @Printer_FileNameGet, @Printer_FileNameSet);
    AType.AddProp('Fonts', 'TStrings', @Printer_FontsGet);
    AType.AddProp('Canvas', 'TCanvas', @Printer_CanvasGet);
    AType.AddProp('PageHeight', 'Integer', @Printer_PageHeightGet);
    AType.AddProp('PageWidth', 'Integer', @Printer_PageWidthGet);
    AType.AddProp('PageNumber', 'Integer', @Printer_PageNumberGet);
    AType.AddProp('Title', 'string', @Printer_TitleGet, @Printer_TitleSet);
    AType.AddMethod('procedure SetPrinter(aName : String)', @Printer_SetPrinter);
    AType.AddMethod('procedure Abort', @Printer_Abort);
    AType.AddMethod('procedure BeginDoc', @Printer_BeginDoc);
    AType.AddMethod('procedure EndDoc', @Printer_EndDoc);
    AType.AddMethod('procedure Refresh', @Printer_Refresh);
  end;
end;

procedure TLazReportImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TfrBandType));
  AddType(TypeInfo(TfrBandTypes));
  AddType(TypeInfo(TfrDataSetPosition));
  AddType(TypeInfo(TfrValueType));
  AddType(TypeInfo(TfrPageMode));
  AddType(TypeInfo(TfrBandRecType));
  AddType(TypeInfo(TfrRgnType));
  AddType(TypeInfo(TfrReportType));
  //AddType(TypeInfo(TfrStreamMode));
  AddType(TypeInfo(TfrFrameBorder));
  AddType(TypeInfo(TfrFrameBorders));
  AddType(TypeInfo(TfrFrameStyle));
  AddType(TypeInfo(TLayoutOrder));
  AddType(TypeInfo(TPrinterOrientation));
  AddType(TypeInfo(TPrinterType));
  AddType(TypeInfo(TfrPageType));
  AddType(TypeInfo(TfrReportOption));
  AddType(TypeInfo(TfrReportOptions));
end;

procedure TLazReportImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TPrintReportEvent), TPrintReportEventHandler);
  RegisterHandler(TypeInfo(TBeginDocEvent), TBeginEndDocEventHandler);
  RegisterHandler(TypeInfo(TEndDocEvent), TBeginEndDocEventHandler);
  RegisterHandler(TypeInfo(TDetailEvent), TDetailEventHandler);
  RegisterHandler(TypeInfo(TBeginPageEvent), TBeginEndPageEventHandler);
  RegisterHandler(TypeInfo(TEndPageEvent), TBeginEndPageEventHandler);
  RegisterHandler(TypeInfo(TBeginBandEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TEndBandEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TEnterRectEvent), TEnterRectEventHandler);
  //TfrProgressEvent and TBeginPageEvent call equally
  RegisterHandler(TypeInfo(TfrProgressEvent), TBeginEndPageEventHandler);
  //TBeginColumnEvent and TBeginBandEvent call equally
  RegisterHandler(TypeInfo(TBeginColumnEvent), TBeginEndPageEventHandler);
  RegisterHandler(TypeInfo(TManualBuildEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TFunctionEvent), TFunctionEventHandler);

end;

procedure TLazReportImport.AddObjects(AddObject: TAddObjectProc);
begin
  AddObject('frVariables', frVariables);
  AddObject('Prn', Prn);
end;

initialization
  frRegisterFunctionLibrary(TdpFunctionLibrary);

end.

