unit dpi_AtolKKM;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, Variants, Controls, KKM_Atol;

type

  PDeviseState = ^TDeviseState;
  PDeviseType = ^TDeviseType;

  { TAtolKKMImport }

  TAtolKKMImport = class(TClassImporter)
    function AtollKKM_AccessPasswordGet(Instance: Pointer): Variant;
    procedure AtollKKM_AccessPasswordSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_BatteryLowGet(Instance: Pointer): Variant;
    function AtollKKM_Beep(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_BeginDocument(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_BufferPDEmptyGet(Instance: Pointer): Variant;
    function AtollKKM_BufferPDFullGet(Instance: Pointer): Variant;
    function AtollKKM_CancelCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_CaptionGet(Instance: Pointer): Variant;
    procedure AtollKKM_CaptionSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_CashIncome(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_CashOutcome(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_CheckNumberGet(Instance: Pointer): Variant;
    function AtollKKM_CheckStateGet(Instance: Pointer): Variant;
    function AtollKKM_CheckSumGet(Instance: Pointer): Variant;
    function AtollKKM_CheckTypeGet(Instance: Pointer): Variant;
    procedure AtollKKM_CheckTypeSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_CloseCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_CountGet(Instance: Pointer): Variant;
    procedure AtollKKM_CountSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_CoverOpenedGet(Instance: Pointer): Variant;
    function AtollKKM_CutCheck(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_DemoPrint(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_DepartmentGet(Instance: Pointer): Variant;
    procedure AtollKKM_DepartmentSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_DeviseStateGet(Instance: Pointer): Variant;
    function AtollKKM_DeviseTypeGet(Instance: Pointer): Variant;
    function AtollKKM_ECRDateTimeGet(Instance: Pointer): Variant;
    function AtollKKM_EndDocument(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_ErrorCodeGet(Instance: Pointer): Variant;
    function AtollKKM_ErrorCodeStrGet(Instance: Pointer): Variant;
    function AtollKKM_GetRegister(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_GetStatus(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_GetStatus1(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_KKMConectedGet(Instance: Pointer): Variant;
    function AtollKKM_LoadParams(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_ModeGet(Instance: Pointer): Variant;
    function AtollKKM_OpenCheck(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_OpenSession(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_OutOfPaperGet(Instance: Pointer): Variant;
    function AtollKKM_PaperErrorGet(Instance: Pointer): Variant;
    function AtollKKM_Payment(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_PriceGet(Instance: Pointer): Variant;
    procedure AtollKKM_PriceSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_PrintClishe(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_PrinterCutMechanismErrorGet(Instance: Pointer): Variant;
    function AtollKKM_PrinterOverheatErrorGet(Instance: Pointer): Variant;
    function AtollKKM_PrintLine(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_PrintPurposeGet(Instance: Pointer): Variant;
    procedure AtollKKM_PrintPurposeSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_PrintReportCounted(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_PrintReportHours(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_PrintReportSection(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_PrintString(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_QuantityGet(Instance: Pointer): Variant;
    procedure AtollKKM_QuantitySet(Instance: Pointer; AValue: Variant);
    function AtollKKM_ReadModel(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_RegisterNumberGet(Instance: Pointer): Variant;
    procedure AtollKKM_RegisterNumberSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_Registration(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_ReportX(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_ReportZ(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_ResetMode(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_ResetSummary(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_Return(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_SerialNumberGet(Instance: Pointer): Variant;
    function AtollKKM_SessionOpenedGet(Instance: Pointer): Variant;
    function AtollKKM_SetMode(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_SetSubMode(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_ShowProperties(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_StoreParams(Instance: TObject; var Params: Variant
      ): Variant;
    function AtollKKM_Storno(Instance: TObject; var Params: Variant): Variant;
    function AtollKKM_SubModeGet(Instance: Pointer): Variant;
    procedure AtollKKM_SubModeSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_SummGet(Instance: Pointer): Variant;
    procedure AtollKKM_SummSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_TestModeGet(Instance: Pointer): Variant;
    procedure AtollKKM_TestModeSet(Instance: Pointer; AValue: Variant);
    function AtollKKM_TypeCloseGet(Instance: Pointer): Variant;
    procedure AtollKKM_TypeCloseSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_CheckNumGet(Instance: Pointer): Variant;
    procedure TDeviseState_CheckNumSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_CheckStateGet(Instance: Pointer): Variant;
    procedure TDeviseState_CheckStateSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_CheckSumGet(Instance: Pointer): Variant;
    procedure TDeviseState_CheckSumSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_DecimalSepGet(Instance: Pointer): Variant;
    procedure TDeviseState_DecimalSepSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_FabNumberGet(Instance: Pointer): Variant;
    procedure TDeviseState_FabNumberSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_FlagsGet(Instance: Pointer): Variant;
    procedure TDeviseState_FlagsSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_KKMDateGet(Instance: Pointer): Variant;
    procedure TDeviseState_KKMDateSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_KKMTimeGet(Instance: Pointer): Variant;
    procedure TDeviseState_KKMTimeSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_KssNumberGet(Instance: Pointer): Variant;
    procedure TDeviseState_KssNumberSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_ModeGet(Instance: Pointer): Variant;
    function TDeviseState_ModelGet(Instance: Pointer): Variant;
    procedure TDeviseState_ModelSet(Instance: Pointer; AValue: Variant);
    procedure TDeviseState_ModeSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_NumberInHallGet(Instance: Pointer): Variant;
    procedure TDeviseState_NumberInHallSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_NumSmenaGet(Instance: Pointer): Variant;
    procedure TDeviseState_NumSmenaSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_PortGet(Instance: Pointer): Variant;
    procedure TDeviseState_PortSet(Instance: Pointer; AValue: Variant);
    function TDeviseState_VersionGet(Instance: Pointer): Variant;
    procedure TDeviseState_VersionSet(Instance: Pointer; AValue: Variant);
    function TDeviseType_KKMModelGet(Instance: Pointer): Variant;
    procedure TDeviseType_KKMModelSet(Instance: Pointer; AValue: Variant);
    function TDeviseType_KKMNameGet(Instance: Pointer): Variant;
    procedure TDeviseType_KKMNameSet(Instance: Pointer; AValue: Variant);
    function TDeviseType_ModeGet(Instance: Pointer): Variant;
    procedure TDeviseType_ModeSet(Instance: Pointer; AValue: Variant);
    function TDeviseType_ProtocolTypeGet(Instance: Pointer): Variant;
    procedure TDeviseType_ProtocolTypeSet(Instance: Pointer; AValue: Variant);
    function TDeviseType_ProtocolVersionGet(Instance: Pointer): Variant;
    procedure TDeviseType_ProtocolVersionSet(Instance: Pointer; AValue: Variant
      );
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
       override;
    procedure RegisterPublic(AType: TDpType); override;
  end;

implementation

uses
  dpUtils;

{ TAtolKKMImport }

function TAtolKKMImport.AtollKKM_AccessPasswordGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).AccessPassword;
end;

procedure TAtolKKMImport.AtollKKM_AccessPasswordSet(Instance: Pointer;
  AValue: Variant);
begin
  TAtollKKM(Instance).AccessPassword := AValue;
end;

function TAtolKKMImport.AtollKKM_BatteryLowGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).BatteryLow;
end;

function TAtolKKMImport.AtollKKM_Beep(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TAtollKKM(Instance).Beep;
end;

function TAtolKKMImport.AtollKKM_BeginDocument(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).BeginDocument;
end;

function TAtolKKMImport.AtollKKM_BufferPDEmptyGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).BufferPDEmpty;
end;

function TAtolKKMImport.AtollKKM_BufferPDFullGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).BufferPDFull;
end;

function TAtolKKMImport.AtollKKM_CancelCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).CancelCheck;
end;

function TAtolKKMImport.AtollKKM_CaptionGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).Caption;
end;

procedure TAtolKKMImport.AtollKKM_CaptionSet(Instance: Pointer; AValue: Variant
  );
begin
   TAtollKKM(Instance).Caption := AValue;
end;

function TAtolKKMImport.AtollKKM_CashIncome(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).CashIncome;
end;

function TAtolKKMImport.AtollKKM_CashOutcome(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).CashOutcome;
end;

function TAtolKKMImport.AtollKKM_CheckNumberGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).CheckNumber;
end;

function TAtolKKMImport.AtollKKM_CheckStateGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).CheckState;
end;

function TAtolKKMImport.AtollKKM_CheckSumGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).CheckSum;
end;

function TAtolKKMImport.AtollKKM_CheckTypeGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).CheckType;
end;

procedure TAtolKKMImport.AtollKKM_CheckTypeSet(Instance: Pointer;
  AValue: Variant);
begin
  TAtollKKM(Instance).CheckType:= AValue;
end;

function TAtolKKMImport.AtollKKM_CloseCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).CloseCheck;
end;

function TAtolKKMImport.AtollKKM_CountGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).Count;
end;

procedure TAtolKKMImport.AtollKKM_CountSet(Instance: Pointer; AValue: Variant);
begin
  TAtollKKM(Instance).Count := AValue;
end;

function TAtolKKMImport.AtollKKM_CoverOpenedGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).CoverOpened;
end;

function TAtolKKMImport.AtollKKM_CutCheck(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TAtollKKM(Instance).CutCheck;
end;

function TAtolKKMImport.AtollKKM_DemoPrint(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).DemoPrint;
end;

function TAtolKKMImport.AtollKKM_DepartmentGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).Department;
end;

procedure TAtolKKMImport.AtollKKM_DepartmentSet(Instance: Pointer;
  AValue: Variant);
begin
  TAtollKKM(Instance).Department := AValue;
end;

function TAtolKKMImport.AtollKKM_DeviseStateGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( @TAtollKKM(Instance).DeviseState );
end;

function TAtolKKMImport.AtollKKM_DeviseTypeGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( @TAtollKKM(Instance).DeviseType );
end;

function TAtolKKMImport.AtollKKM_ECRDateTimeGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).ECRDateTime;
end;

function TAtolKKMImport.AtollKKM_EndDocument(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).EndDocument;
end;

function TAtolKKMImport.AtollKKM_ErrorCodeGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).ErrorCode;
end;

function TAtolKKMImport.AtollKKM_ErrorCodeStrGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).ErrorCodeStr;
end;

function TAtolKKMImport.AtollKKM_GetRegister(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).GetRegister;
end;

function TAtolKKMImport.AtollKKM_GetStatus(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).GetStatus;
end;

function TAtolKKMImport.AtollKKM_GetStatus1(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).GetStatus1;
end;

function TAtolKKMImport.AtollKKM_KKMConectedGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).KKMConected;
end;

function TAtolKKMImport.AtollKKM_LoadParams(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).LoadParams(TStrings(TSuPtr(Params[0])));
end;

function TAtolKKMImport.AtollKKM_ModeGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).Mode;
end;

function TAtolKKMImport.AtollKKM_OpenCheck(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).OpenCheck;
end;

function TAtolKKMImport.AtollKKM_OpenSession(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).OpenSession;
end;

function TAtolKKMImport.AtollKKM_OutOfPaperGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).OutOfPaper;
end;

function TAtolKKMImport.AtollKKM_PaperErrorGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).PaperError;
end;

function TAtolKKMImport.AtollKKM_Payment(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TAtollKKM(Instance).Payment;
end;

function TAtolKKMImport.AtollKKM_PriceGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).Price;
end;

procedure TAtolKKMImport.AtollKKM_PriceSet(Instance: Pointer; AValue: Variant);
begin
  TAtollKKM(Instance).Price := AValue;
end;

function TAtolKKMImport.AtollKKM_PrintClishe(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).PrintClishe;
end;

function TAtolKKMImport.AtollKKM_PrinterCutMechanismErrorGet(Instance: Pointer
  ): Variant;
begin
  Result := TAtollKKM(Instance).PrinterCutMechanismError;
end;

function TAtolKKMImport.AtollKKM_PrinterOverheatErrorGet(Instance: Pointer
  ): Variant;
begin
  Result := TAtollKKM(Instance).PrinterOverheatError;
end;

function TAtolKKMImport.AtollKKM_PrintLine(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).PrintLine(Params[0]);
end;

function TAtolKKMImport.AtollKKM_PrintPurposeGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).PrintPurpose;
end;

procedure TAtolKKMImport.AtollKKM_PrintPurposeSet(Instance: Pointer;
  AValue: Variant);
begin
  TAtollKKM(Instance).PrintPurpose := AValue;
end;

function TAtolKKMImport.AtollKKM_PrintReportCounted(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).PrintReportCounted;
end;

function TAtolKKMImport.AtollKKM_PrintReportHours(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).PrintReportHours;
end;

function TAtolKKMImport.AtollKKM_PrintReportSection(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).PrintReportSection;
end;

function TAtolKKMImport.AtollKKM_PrintString(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).PrintString;
end;

function TAtolKKMImport.AtollKKM_QuantityGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).Quantity;
end;

procedure TAtolKKMImport.AtollKKM_QuantitySet(Instance: Pointer; AValue: Variant
  );
begin
  TAtollKKM(Instance).Quantity := AValue;
end;

function TAtolKKMImport.AtollKKM_ReadModel(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).ReadModel;
end;

function TAtolKKMImport.AtollKKM_RegisterNumberGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).RegisterNumber;
end;

procedure TAtolKKMImport.AtollKKM_RegisterNumberSet(Instance: Pointer;
  AValue: Variant);
begin
  TAtollKKM(Instance).RegisterNumber := AValue;
end;

function TAtolKKMImport.AtollKKM_Registration(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).Registration;
end;

function TAtolKKMImport.AtollKKM_ReportX(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TAtollKKM(Instance).ReportX(Params[0]);
end;

function TAtolKKMImport.AtollKKM_ReportZ(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TAtollKKM(Instance).ReportZ;
end;

function TAtolKKMImport.AtollKKM_ResetMode(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).ResetMode;
end;

function TAtolKKMImport.AtollKKM_ResetSummary(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).ResetSummary;
end;

function TAtolKKMImport.AtollKKM_Return(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TAtollKKM(Instance).Return;
end;

function TAtolKKMImport.AtollKKM_SerialNumberGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).SerialNumber;
end;

function TAtolKKMImport.AtollKKM_SessionOpenedGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).SessionOpened;
end;

function TAtolKKMImport.AtollKKM_SetMode(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TAtollKKM(Instance).SetMode(Params[0]);
end;

function TAtolKKMImport.AtollKKM_SetSubMode(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).SetSubMode(Params[0]);
end;

function TAtolKKMImport.AtollKKM_ShowProperties(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TAtollKKM(Instance).ShowProperties;
end;

function TAtolKKMImport.AtollKKM_StoreParams(Instance: TObject;
  var Params: Variant): Variant;
begin
  TAtollKKM(Instance).StoreParams(TStrings(TSuPtr(Params[0])));
end;

function TAtolKKMImport.AtollKKM_Storno(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TAtollKKM(Instance).Storno;
end;

function TAtolKKMImport.AtollKKM_SubModeGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).SubMode;
end;

procedure TAtolKKMImport.AtollKKM_SubModeSet(Instance: Pointer; AValue: Variant
  );
begin
  TAtollKKM(Instance).SubMode := AValue;
end;

function TAtolKKMImport.AtollKKM_SummGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).Summ;
end;

procedure TAtolKKMImport.AtollKKM_SummSet(Instance: Pointer; AValue: Variant);
begin
  TAtollKKM(Instance).Summ := AValue;
end;

function TAtolKKMImport.AtollKKM_TestModeGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).TestMode;
end;

procedure TAtolKKMImport.AtollKKM_TestModeSet(Instance: Pointer; AValue: Variant
  );
begin
  TAtollKKM(Instance).TestMode := AValue;
end;

function TAtolKKMImport.AtollKKM_TypeCloseGet(Instance: Pointer): Variant;
begin
  Result := TAtollKKM(Instance).TypeClose;
end;

procedure TAtolKKMImport.AtollKKM_TypeCloseSet(Instance: Pointer;
  AValue: Variant);
begin
  TAtollKKM(Instance).TypeClose := AValue;
end;

function TAtolKKMImport.TDeviseState_CheckNumGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.CheckNum;
end;

procedure TAtolKKMImport.TDeviseState_CheckNumSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.CheckNum:= AValue;
end;

function TAtolKKMImport.TDeviseState_CheckStateGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.CheckState;
end;

procedure TAtolKKMImport.TDeviseState_CheckStateSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.CheckState := AValue;
end;

function TAtolKKMImport.TDeviseState_CheckSumGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.CheckSum;
end;

procedure TAtolKKMImport.TDeviseState_CheckSumSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.CheckSum := AValue;
end;

function TAtolKKMImport.TDeviseState_DecimalSepGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.DecimalSep;
end;

procedure TAtolKKMImport.TDeviseState_DecimalSepSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.DecimalSep:= AValue;
end;

function TAtolKKMImport.TDeviseState_FabNumberGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.FabNumber;
end;

procedure TAtolKKMImport.TDeviseState_FabNumberSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.FabNumber:= AValue;
end;

function TAtolKKMImport.TDeviseState_FlagsGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.Flags;
end;

procedure TAtolKKMImport.TDeviseState_FlagsSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.Flags := AValue;
end;

function TAtolKKMImport.TDeviseState_KKMDateGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.KKMDate;
end;

procedure TAtolKKMImport.TDeviseState_KKMDateSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.KKMDate := AValue;
end;

function TAtolKKMImport.TDeviseState_KKMTimeGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.KKMTime;
end;

procedure TAtolKKMImport.TDeviseState_KKMTimeSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.KKMTime:= AValue;
end;

function TAtolKKMImport.TDeviseState_KssNumberGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.KssNumber;
end;

procedure TAtolKKMImport.TDeviseState_KssNumberSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.KssNumber:= AValue;
end;

function TAtolKKMImport.TDeviseState_ModeGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.Mode;
end;

function TAtolKKMImport.TDeviseState_ModelGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.Model;
end;

procedure TAtolKKMImport.TDeviseState_ModelSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.Model:= AValue;
end;

procedure TAtolKKMImport.TDeviseState_ModeSet(Instance: Pointer; AValue: Variant
  );
begin
  PDeviseState(Instance)^.Mode := AValue;
end;

function TAtolKKMImport.TDeviseState_NumberInHallGet(Instance: Pointer
  ): Variant;
begin
  Result := PDeviseState(Instance)^.NumberInHall;
end;

procedure TAtolKKMImport.TDeviseState_NumberInHallSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.NumberInHall := AValue;
end;

function TAtolKKMImport.TDeviseState_NumSmenaGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.NumSmena;
end;

procedure TAtolKKMImport.TDeviseState_NumSmenaSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.NumSmena:= AValue;
end;

function TAtolKKMImport.TDeviseState_PortGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.Port;
end;

procedure TAtolKKMImport.TDeviseState_PortSet(Instance: Pointer; AValue: Variant
  );
begin
  PDeviseState(Instance)^.Port:= AValue;
end;

function TAtolKKMImport.TDeviseState_VersionGet(Instance: Pointer): Variant;
begin
  Result := PDeviseState(Instance)^.Version;
end;

procedure TAtolKKMImport.TDeviseState_VersionSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseState(Instance)^.Version := AValue;
end;

function TAtolKKMImport.TDeviseType_KKMModelGet(Instance: Pointer): Variant;
begin
  Result := PDeviseType(Instance)^.KKMModel;
end;

procedure TAtolKKMImport.TDeviseType_KKMModelSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseType(Instance)^.KKMModel:= AValue;
end;

function TAtolKKMImport.TDeviseType_KKMNameGet(Instance: Pointer): Variant;
begin
  Result := PDeviseType(Instance)^.KKMName;
end;

procedure TAtolKKMImport.TDeviseType_KKMNameSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseType(Instance)^.KKMName := AValue;
end;

function TAtolKKMImport.TDeviseType_ModeGet(Instance: Pointer): Variant;
begin
  Result := PDeviseType(Instance)^.Mode;
end;

procedure TAtolKKMImport.TDeviseType_ModeSet(Instance: Pointer; AValue: Variant
  );
begin
  PDeviseType(Instance)^.Mode := AValue;
end;

function TAtolKKMImport.TDeviseType_ProtocolTypeGet(Instance: Pointer): Variant;
begin
  Result := PDeviseType(Instance)^.ProtocolType;
end;

procedure TAtolKKMImport.TDeviseType_ProtocolTypeSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseType(Instance)^.ProtocolType := AValue;
end;

function TAtolKKMImport.TDeviseType_ProtocolVersionGet(Instance: Pointer
  ): Variant;
begin
  Result := PDeviseType(Instance)^.ProtocolVersion;
end;

procedure TAtolKKMImport.TDeviseType_ProtocolVersionSet(Instance: Pointer;
  AValue: Variant);
begin
  PDeviseType(Instance)^.ProtocolVersion := AValue;
end;

procedure TAtolKKMImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddRecord('TDeviseType', SizeOf(TDeviseType)).ClassImporter := Self;
  AddRecord('TDeviseState', SizeOf(TDeviseState)).ClassImporter := Self;
  AddClass(TAtollKKM).ClassImporter := Self;
end;

procedure TAtolKKMImport.RegisterPublic(AType: TDpType);
begin
  if AType.BaseType = btRecord then
  begin
    if AType.Name = 'tdevisetype' then
    begin
      AType.AddProp('ProtocolVersion', 'Integer',
        @TDeviseType_ProtocolVersionGet, @TDeviseType_ProtocolVersionSet);
      AType.AddProp('ProtocolType', 'Integer',
        @TDeviseType_ProtocolTypeGet, @TDeviseType_ProtocolTypeSet);
      AType.AddProp('KKMModel', 'Integer',
        @TDeviseType_KKMModelGet, @TDeviseType_KKMModelSet);
      AType.AddProp('Mode', 'Integer',
        @TDeviseType_ModeGet, @TDeviseType_ModeSet);
      AType.AddProp('KKMName', 'string',
        @TDeviseType_KKMNameGet, @TDeviseType_KKMNameSet);
    end
    else
    if AType.Name = 'tdevisestate' then
    begin
      AType.AddProp('KssNumber', 'Byte',
        @TDeviseState_KssNumberGet, @TDeviseState_KssNumberSet);
      AType.AddProp('NumberInHall', 'Byte',
        @TDeviseState_NumberInHallGet, @TDeviseState_NumberInHallSet);
      AType.AddProp('KKMDate', 'TDateTime',
        @TDeviseState_KKMDateGet, @TDeviseState_KKMDateSet);
      AType.AddProp('KKMTime', 'TDateTime',
        @TDeviseState_KKMTimeGet, @TDeviseState_KKMTimeSet);
      AType.AddProp('Flags', 'Byte',
        @TDeviseState_FlagsGet, @TDeviseState_FlagsSet);
      AType.AddProp('FabNumber', 'DWord',
        @TDeviseState_FabNumberGet, @TDeviseState_FabNumberSet);
      AType.AddProp('Model', 'Byte',
        @TDeviseState_ModelGet, @TDeviseState_ModelSet);
      AType.AddProp('Version', 'string',
        @TDeviseState_VersionGet, @TDeviseState_VersionSet);
      AType.AddProp('Mode', 'Byte',
        @TDeviseState_ModeGet, @TDeviseState_ModeSet);
      AType.AddProp('CheckNum', 'integer',
        @TDeviseState_CheckNumGet, @TDeviseState_CheckNumSet);
      AType.AddProp('NumSmena', 'integer',
        @TDeviseState_NumSmenaGet, @TDeviseState_NumSmenaSet);
      AType.AddProp('CheckState', 'byte',
        @TDeviseState_CheckStateGet, @TDeviseState_CheckStateSet);
      AType.AddProp('CheckSum', 'Currency',
        @TDeviseState_CheckSumGet, @TDeviseState_CheckSumSet);
      AType.AddProp('DecimalSep', 'byte',
        @TDeviseState_DecimalSepGet, @TDeviseState_DecimalSepSet);
      AType.AddProp('Port', 'byte',
        @TDeviseState_PortGet, @TDeviseState_PortSet);
    end;
  end
  else
  if AType.ValueClassType = TAtollKKM then
  begin
    AType.AddMethod('procedure LoadParams(ParList:TStrings)', @AtollKKM_LoadParams);
    AType.AddMethod('procedure StoreParams(ParList:TStrings)', @AtollKKM_StoreParams);
    AType.AddMethod('procedure Beep', @AtollKKM_Beep);
    AType.AddMethod('procedure CutCheck', @AtollKKM_CutCheck);
    AType.AddMethod('procedure PrintLine(ALine:string)', @AtollKKM_PrintLine);
    AType.AddMethod('procedure PrintClishe', @AtollKKM_PrintClishe);
    AType.AddMethod('procedure ReadModel', @AtollKKM_ReadModel);
    AType.AddMethod('procedure DemoPrint', @AtollKKM_DemoPrint);
    AType.AddMethod('procedure ReportZ', @AtollKKM_ReportZ);
    AType.AddMethod('procedure ReportX(AReportType:Byte)', @AtollKKM_ReportX);
    AType.AddMethod('procedure PrintReportSection', @AtollKKM_PrintReportSection);
    AType.AddMethod('procedure PrintReportHours', @AtollKKM_PrintReportHours);
    AType.AddMethod('procedure PrintReportCounted', @AtollKKM_PrintReportCounted);
    AType.AddMethod('procedure GetStatus1', @AtollKKM_GetStatus1);
    AType.AddMethod('function CancelCheck: integer', @AtollKKM_CancelCheck);
    AType.AddMethod('function CashIncome: integer', @AtollKKM_CashIncome);
    AType.AddMethod('function CashOutcome:integer', @AtollKKM_CashOutcome);
    AType.AddMethod('function CloseCheck: Integer', @AtollKKM_CloseCheck);
    AType.AddMethod('function ShowProperties: boolean', @AtollKKM_ShowProperties);
    AType.AddMethod('function GetRegister: integer', @AtollKKM_GetRegister);
    AType.AddMethod('function GetStatus: integer', @AtollKKM_GetStatus);
    AType.AddMethod('function OpenCheck: integer', @AtollKKM_OpenCheck);
    AType.AddMethod('function OpenSession: integer', @AtollKKM_OpenSession);
    AType.AddMethod('function Payment: integer', @AtollKKM_Payment);
    AType.AddMethod('function PrintString: integer', @AtollKKM_PrintString);
    AType.AddMethod('function Registration: integer', @AtollKKM_Registration);
    AType.AddMethod('function Return: integer', @AtollKKM_Return);
    AType.AddMethod('function Storno: integer', @AtollKKM_Storno);
    AType.AddMethod('function SetMode(AMode: Byte): integer', @AtollKKM_SetMode);
    AType.AddMethod('procedure ResetMode', @AtollKKM_ResetMode);
    AType.AddMethod('function ResetSummary: integer', @AtollKKM_ResetSummary);
    AType.AddMethod('procedure BeginDocument', @AtollKKM_BeginDocument);
    AType.AddMethod('procedure EndDocument', @AtollKKM_EndDocument);
    AType.AddMethod('procedure SetSubMode(AValue: byte)', @AtollKKM_SetSubMode);

    AType.AddProp('BufferPDEmpty', 'Boolean', @AtollKKM_BufferPDEmptyGet);
    AType.AddProp('BufferPDFull', 'boolean', @AtollKKM_BufferPDFullGet);
    AType.AddProp('KKMConected', 'boolean', @AtollKKM_KKMConectedGet);
    AType.AddProp('DeviseType', 'TDeviseType', @AtollKKM_DeviseTypeGet);
    AType.AddProp('DeviseState', 'TDeviseState', @AtollKKM_DeviseStateGet);
    AType.AddProp('SubMode', 'byte',
      @AtollKKM_SubModeGet, @AtollKKM_SubModeSet);
    AType.AddProp('CheckSum', 'Currency', @AtollKKM_CheckSumGet);
    AType.AddProp('BatteryLow', 'boolean', @AtollKKM_BatteryLowGet);
    AType.AddProp('Caption', 'string',
      @AtollKKM_CaptionGet, @AtollKKM_CaptionSet);
    AType.AddProp('CheckNumber', 'integer', @AtollKKM_CheckNumberGet);
    AType.AddProp('CheckState', 'integer', @AtollKKM_CheckStateGet);
    AType.AddProp('CheckType', 'Byte',
      @AtollKKM_CheckTypeGet, @AtollKKM_CheckTypeSet);
    AType.AddProp('Count', 'integer',
      @AtollKKM_CountGet, @AtollKKM_CountSet);
    AType.AddProp('CoverOpened', 'Boolean', @AtollKKM_CoverOpenedGet);
    AType.AddProp('Department', 'integer',
      @AtollKKM_DepartmentGet, @AtollKKM_DepartmentSet);
    AType.AddProp('ECRDateTime', 'TDateTime', @AtollKKM_ECRDateTimeGet);
    AType.AddProp('ErrorCode', 'integer', @AtollKKM_ErrorCodeGet);
    AType.AddProp('ErrorCodeStr', 'string', @AtollKKM_ErrorCodeStrGet);
    AType.AddProp('Mode', 'byte', @AtollKKM_ModeGet);
    AType.AddProp('OutOfPaper', 'boolean', @AtollKKM_OutOfPaperGet);
    AType.AddProp('PaperError', 'boolean', @AtollKKM_PaperErrorGet);
    AType.AddProp('Price', 'Currency',
      @AtollKKM_PriceGet, @AtollKKM_PriceSet);
    AType.AddProp('PrinterCutMechanismError', 'boolean',
      @AtollKKM_PrinterCutMechanismErrorGet);
    AType.AddProp('PrinterOverheatError', 'boolean',
      @AtollKKM_PrinterOverheatErrorGet);
    AType.AddProp('PrintPurpose', 'byte',
      @AtollKKM_PrintPurposeGet, @AtollKKM_PrintPurposeSet);
    AType.AddProp('Quantity', 'Double',
      @AtollKKM_QuantityGet, @AtollKKM_QuantitySet);
    AType.AddProp('RegisterNumber', 'byte',
      @AtollKKM_RegisterNumberGet, @AtollKKM_RegisterNumberSet);
    AType.AddProp('SerialNumber', 'string', @AtollKKM_SerialNumberGet);
    AType.AddProp('SessionOpened', 'boolean', @AtollKKM_SessionOpenedGet);
    AType.AddProp('Summ', 'Currency', @AtollKKM_SummGet, @AtollKKM_SummSet);
    AType.AddProp('TestMode', 'boolean',
      @AtollKKM_TestModeGet, @AtollKKM_TestModeSet);
    AType.AddProp('TypeClose', 'integer',
      @AtollKKM_TypeCloseGet, @AtollKKM_TypeCloseSet);
    AType.AddProp('AccessPassword', 'integer',
      @AtollKKM_AccessPasswordGet, @AtollKKM_AccessPasswordSet);
  end;
end;

end.

