{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                    LGPL                                      }
{                                                                              }
{------------------------------------------------------------------------------}

unit CrossMachineMain;

{$mode objfpc}{$H+}

interface

{$I SetComponent.inc}

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, LCLIntf,
  ComCtrls, dpCompil, ExtCtrls, projoption, dpUtils, typinfo, DpCompilMsg,
  LCLType, XMLRead, DOM, XMLCyrDecode, simpleipc, dpi_mettyps,
  xdbf;

type

  TNodeObject = class
  private
  protected
  public
    UseNode: Boolean;
    ObjClassName: string;
    Code: string;
    Obj: string;
    //BreakPoints: TBreakPointsList;
  end;

  TLastDebugUnit = record
    AUnitName: string;
    NO: TNodeObject;
  end;

  TSetMach = procedure;

  { TCrossApp }

  TCrossApp = class(TComponent)
  private
    FI: Integer;
    Splash: TForm;
    FTimer: TTimer;
    FPrjOpt: TProjectOptions;
    RGN1, RGN2: HRgn;
    MainUnit: TDpString;
    FReadRoot: TComponent;
    //FCurReadComponent: TComponent;
    FReadNode: TNodeObject;
    FDebug: Boolean;
    FBreakPointsExist: Boolean;
    FErrList: TStringList;
    FormShowProp: PPropInfo;
    FormShowMethod: TMethod;
  protected
    EngineDir: string;
    ConfigDir: string;
    DpIniDir: string;
    AppDirLocal: string;
    LastDebugUnit: TLastDebugUnit;
    FLibHandle: Cardinal;
    PB: TProgressBar;
    ObjectData: TDpClassData;
    StartTime: Cardinal;
    DebugServer: TSimpleIPCServer;
    DebugClient: TSimpleIPCClient;
    BreakPointList: TStringList;
    GetBreakpontList: Boolean;
    EVarList: TStringList;
    procedure RunScriptApp;
    procedure OnTimer(Sender: TObject);
    function GetObjClassName(Value: string): string;
    function GetUnitSource(AUnitName: string): string;

    function GetClassResurce(AClassName: string): string;
    procedure ReaderSetFrameMethodProp(Reader: TReader; Instance: TPersistent;
      PropInfo: PPropInfo; const TheMethodName: string;
      var Handled: boolean);
    procedure ReaderReadStringProp(Sender:TObject;
        const Instance: TPersistent; PropInfo: PPropInfo;
        var Content:string);
    procedure TextToFrame(S: string; var Frame: TFrame);


    function TextToObject(Obj: string; Instance: TComponent): TComponent;

    function GetNodeOfObjClassName(var ObjClassName: string): TNodeObject;
    function GetNodeOfUnitName(AUnitName: TDpString): TNodeObject;
    {procedure FindMethod(Reader: TReader; const AMethodName: string;
      var Address: Pointer; var Error: Boolean);}
    //procedure ReadComponentSetName(Reader: TReader; Component: TComponent; var AName: string);
    procedure OnScriptMessage(AMessage: TDpString);
    procedure OnScriptError(AMessage: TDpCompilerMessage);
    procedure OnScriptAddConst(AddConst: TAddConstProc);
    procedure AddScriptObject(AddObject: TAddObjectProc);
    procedure AddScriptMethod(AddMethod: TAddMethodProc);
    procedure DebugProc(AUnitName: TDpString; ACol, ARow: Integer);
    //procedure UpdateBreakPointsList;
    procedure AfterCallProc(Proc: TDpCustomProc);
    function OnCreateScriptForm(AOwner: TComponent; AType: TDpType): TForm;
    function OnCreateDataModule(AOwner: TComponent; AType: TDpType): TDataModule;
    function OnCreateFrame(AOwner: TComponent; AType: TDpType): TFrame;
    procedure OnAddClassImport(AddImporter: TAddImporterProc);
    function GetSumProp(V: Variant; SmallFormat: Boolean): string;
    function IsUnitExits(AUnitName: string): Boolean;
    function LoadExternalUnit(ProjLang, ExtPath: string): Boolean;
    procedure LoadExternal(ProjLang: string);
    procedure ReaderSetMethodProp(Reader: TReader; Instance: TPersistent;
      PropInfo: PPropInfo; const TheMethodName: string;
      var Handled: boolean);
    procedure OnDebugMessage(Sender: TObject);
    procedure OnMessageQueued(Sender: TObject);
    procedure CheckMessage(Sender: TObject);
    procedure OnAppExeption(Sender: TObject; E: Exception);
  public

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function CheckEngineVersion(ChkVMajor, ChkVMinor, ChkVRevision: Integer): Boolean;
  published
    function Call_DebugValue(Instence: TObject; var Params: Variant): Variant;
    function Call_GetSumProp(Instence: TObject; var Params: Variant): Variant;
    function Call_GetEngineVersion(Instence: TObject; var Params: Variant): Variant;
    function Call_CheckEngineVersion(Instence: TObject; var Params: Variant): Variant;
  end;

var
  CrossApp: TCrossApp;
  FStopped: Boolean;
  Script: TDpCompiler;
  ObjectList: TStringList;
  ConfFile: string;
  ConfigPath: string;
  ConfigFile: string;
  //ScriptFileName: string;
  SU_START, SU_CLOSE, SU_RUN, SU_BP, SU_NEXT, SU_RESET, SU_HANDLE: Integer;
  FTrace: Boolean;
  FLinked: Boolean;
  BSMRecipient: DWORD;
  DesignHandle: string;
  ErrConfigLoad: Boolean = False;

implementation

uses ComponentExport, SuFrame, LResources, AppConst,
  httpsend, Translations, XDBGrids, db, BufDataset, xdbf_idxfile, ftpsend,
  {$IFDEF IBX}  IB, IBCustomDataSet, {$ENDIF}
  {$IfDef ZEOS} ZDataset, ZAbstractRODataset, {$EndIf}
  LazUTF8, synautil, CodeUtils, expandenvvar, LazFileUtils;

{$R *.lfm}

{ TCrossApp }

procedure ConvetToUTF8LocalConst;
begin
  DefaultFormatSettings.ShortMonthNames[1]:='января';
  DefaultFormatSettings.ShortMonthNames[2]:='февраля';
  DefaultFormatSettings.ShortMonthNames[3]:='марта';
  DefaultFormatSettings.ShortMonthNames[4]:='апреля';
  DefaultFormatSettings.ShortMonthNames[5]:='мая';
  DefaultFormatSettings.ShortMonthNames[6]:='июня';
  DefaultFormatSettings.ShortMonthNames[7]:='июля';
  DefaultFormatSettings.ShortMonthNames[8]:='августа';
  DefaultFormatSettings.ShortMonthNames[9]:='сентября';
  DefaultFormatSettings.ShortMonthNames[10]:='октября';
  DefaultFormatSettings.ShortMonthNames[11]:='ноября';
  DefaultFormatSettings.ShortMonthNames[12]:='декабря';

  DefaultFormatSettings.LongMonthNames[1]:='Январь';
  DefaultFormatSettings.LongMonthNames[2]:='Февраль';
  DefaultFormatSettings.LongMonthNames[3]:='Март';
  DefaultFormatSettings.LongMonthNames[4]:='Апрель';
  DefaultFormatSettings.LongMonthNames[5]:='Май';
  DefaultFormatSettings.LongMonthNames[6]:='Июнь';
  DefaultFormatSettings.LongMonthNames[7]:='Июль';
  DefaultFormatSettings.LongMonthNames[8]:='Август';
  DefaultFormatSettings.LongMonthNames[9]:='Сентябрь';
  DefaultFormatSettings.LongMonthNames[10]:='Октябрь';
  DefaultFormatSettings.LongMonthNames[11]:='Ноябрь';
  DefaultFormatSettings.LongMonthNames[12]:='Декабрь';

  DefaultFormatSettings.LongDayNames[1]:='Воскресенье';
  DefaultFormatSettings.LongDayNames[2]:='Понедельник';
  DefaultFormatSettings.LongDayNames[3]:='Вторник';
  DefaultFormatSettings.LongDayNames[4]:='Среда';
  DefaultFormatSettings.LongDayNames[5]:='Четверг';
  DefaultFormatSettings.LongDayNames[6]:='Пятница';
  DefaultFormatSettings.LongDayNames[7]:='Суббота';

  DefaultFormatSettings.ShortDayNames[1]:='Вс';
  DefaultFormatSettings.ShortDayNames[2]:='Пн';
  DefaultFormatSettings.ShortDayNames[3]:='Вт';
  DefaultFormatSettings.ShortDayNames[4]:='Ср';
  DefaultFormatSettings.ShortDayNames[5]:='Чт';
  DefaultFormatSettings.ShortDayNames[6]:='Пт';
  DefaultFormatSettings.ShortDayNames[7]:='Сб';
end;

procedure InitLocale;
begin
  DefaultFormatSettings.LongDateFormat:='dd.mm.yyyy';
  DefaultFormatSettings.ShortDateFormat:=DefaultFormatSettings.LongDateFormat;
  DefaultFormatSettings.DateSeparator:='.';
  DefaultFormatSettings.TimeSeparator:=':';
  DefaultFormatSettings.ThousandSeparator:=' ';
  DefaultFormatSettings.CurrencyString:='р.';
  ConvetToUTF8LocalConst;
end;

function GetSpecialFolderPath(folder : integer) : string;
begin
  Result := '';
end;

procedure GetDBSortingField(DataSet: TDataSet; var SortedFieldName: string; var Desc: Boolean);
var
  S: string;
  I, L: Integer;
  xDBF: TxDbf;
begin
  SortedFieldName := '';
  Desc:= False;
  {$IFDEF IBX}
  if DataSet is TIBDataSet then
  begin
    S := UTF8UpperCase(TIBDataSet(DataSet).OrderFields);
    if S <> '' then
    begin
      I := Pos(',', S);
      if I > 0 then
      begin
        L := Length(S);
        Delete(S, I, L - I + 1);
      end;
      I := Pos(' DESC', S);
      if I > 0 then
      begin
        Desc := True;
        Delete(S, I, 5);
      end;
      I := Pos('.', S);
      if I > 0 then
        Delete(S, 1, I);
    end;
    SortedFieldName := Trim(S);
  end
  else
  {$EndIf}
  {$IfDef ZEOS}
  if DataSet is TZAbstractRODataset then
  begin
    S := UTF8UpperCase(TZAbstractRODataset(DataSet).SortedFields);
    if S <> '' then
    begin
      I := Pos(',', S);
      if I > 0 then
      begin
        L := Length(S);
        Delete(S, I, L - I + 1);
      end;
      Desc := TZAbstractRODataset(DataSet).SortType = stDescending;
    end
    else
    if DataSet is TZQuery then;
    begin
      S := UTF8UpperCase(TZQuery(DataSet).IndexFieldNames);
      if S <> '' then
      begin
        I := Pos(',', S);
        if I > 0 then
        begin
          L := Length(S);
          Delete(S, I, L - I + 1);
        end;
        Desc := False;
      end
    end;
    SortedFieldName := Trim(S);
  end
  else
  {$ENDIF}
  if DataSet is TxDbf then
  begin
    xDBF := TxDbf(DataSet);
    S := xDBF.IndexName;
    if S <> '' then
    begin

      for I := 0 to xDBF.Indexes.Count - 1 do
      begin
        if xDbf.Indexes.Items[I].IndexFile = S then
        begin
          SortedFieldName := xDbf.Indexes.Items[I].SortField;
          Desc := ixDescending in xDbf.Indexes.Items[I].Options;
          Break;
        end;
      end;
    end;
  end;
end;

procedure OnAutoSortDataset(DataSet: TDataSet; Column: TxColumn; CellCursorPos: TCellCursorPos);
var
  DIDef: TDbfIndexDef;
begin
  {$IFDEF IBX}
  if DataSet is TIBCustomDataSet then
  begin
    if CellCursorPos = ccpTop then
    begin
      if Column.Sorted = soxAscending then
      begin
        TIBCustomDataSet(DataSet).OrderFields := Column.FieldName + ' DESC';
        Column.Sorted := soxDescending;
      end
      else
      begin
        TIBCustomDataSet(DataSet).OrderFields := Column.FieldName;
        Column.Sorted := soxAscending;
      end;
    end
    else
    begin
      if Column.xSorted = soxAscending then
      begin
        TIBCustomDataSet(DataSet).OrderFields := Column.xFieldName + ' DESC';
        Column.xSorted:= soxDescending;
      end
      else
      begin
        TIBCustomDataSet(DataSet).OrderFields := Column.xFieldName;
        Column.xSorted:= soxAscending;
      end;

    end;
  end
  else
  {$ENDIF}
  {$IFDEF ZEOS}
  if DataSet is TZQuery then
  begin
    if CellCursorPos = ccpTop then
    begin
      if Column.Sorted = soxAscending then
      begin
        TZQuery(DataSet).IndexFieldNames := Column.FieldName + ' DESC';
        Column.Sorted:= soxDescending;
      end
      else
      begin
        TZQuery(DataSet).IndexFieldNames := Column.FieldName;
        Column.Sorted:= soxAscending;
      end;
    end
    else
    begin
      if Column.xSorted = soxAscending then
      begin
        TZQuery(DataSet).IndexFieldNames := Column.xFieldName + ' DESC';
        Column.xSorted:= soxDescending;
      end
      else
      begin
        TZQuery(DataSet).IndexFieldNames := Column.xFieldName;
        Column.xSorted:= soxAscending;
      end;
    end;
  end
  else
  {$EndIf}
  if DataSet is TCustomBufDataset then
  begin
    if CellCursorPos = ccpTop then
    begin
      TCustomBufDataset(DataSet).IndexFieldNames := Column.FieldName;
      Column.Sorted:= soxAscending;
    end
    else
    begin
      TCustomBufDataset(DataSet).IndexFieldNames := Column.xFieldName;
      Column.xSorted:= soxAscending;
    end;
  end
  else
  if DataSet is TxDbf then
  begin
    if CellCursorPos = ccpTop then
    begin
      DIDef := TxDbf(DataSet).Indexes.GetIndexByField(Column.FieldName);
      if DIDef = nil then
        TxDbf(DataSet).AddIndex(Column.FieldName, Column.FieldName, [ixCaseInsensitive]);
      TxDbf(DataSet).IndexFieldNames := Column.FieldName;
      if TxDbf(DataSet).IndexName <> '' then
        Column.Sorted:= soxAscending;
    end
    else
    begin
      TxDbf(DataSet).IndexName := Column.xFieldName;
      Column.xSorted:= soxAscending;
    end;
  end;
end;

{TCrossApp}

destructor TCrossApp.Destroy;
var
  I: Integer;
begin
  if (Application.MainForm <> nil) and Assigned(Application.MainForm.OnDestroy) then
  begin
    Application.MainForm.OnDestroy(Application.MainForm);
    Application.MainForm.OnDestroy := nil;
  end;

  I := 0;
  while I < ObjectList.Count do
  begin
    TNodeObject(ObjectList.Objects[I]).Obj := '';
    TNodeObject(ObjectList.Objects[I]).Code := '';
    TNodeObject(ObjectList.Objects[I]).Free;
    Inc(I);
  end;
  ObjectList.Clear;
  ObjectList.Free;
  FErrList.Free;
  EVarList.Free;
  if DebugServer <> nil then
  begin
    DebugServer.OnMessageQueued := nil;
    if DebugClient.Active then
    begin
      DebugClient.SendStringMessage('9:');
      DebugClient.Disconnect;
    end;
    if DebugServer.Active then DebugServer.StopServer;
    Application.ProcessMessages;
    Application.ReleaseComponent(DebugServer);
    DebugServer := nil;
    Application.ReleaseComponent(DebugClient);
    DebugClient := nil;
  end;

  BreakPointList.Free;
  {Script.Reset;
  Script.free;
  Script := nil;}
  inherited Destroy;
end;

function TCrossApp.CheckEngineVersion(ChkVMajor, ChkVMinor, ChkVRevision: Integer): Boolean;
begin
  Result := True;
  if VMajor < ChkVMajor then
    Result := False
  else if VMajor = ChkVMajor then
  begin
    if VMinor < ChkVMinor then Result := False
    else if VMinor = ChkVMinor then
      if VRevision < ChkVRevision then Result := False
  end;
end;

function TCrossApp.Call_DebugValue(Instence: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  if DebugClient <> nil then
  begin
    S := Params[0];
    DebugClient.SendStringMessage('11:' + S);
  end;
end;

function TCrossApp.IsUnitExits(AUnitName: string): Boolean;
var
  I: Integer;
  S: string;
begin
  AUnitName:= UTF8LowerCase(AUnitName);
  Result := False;
  for I := 0 to ObjectList.Count - 1 do
  begin
    S := UTF8LowerCase(ObjectList.Strings[I]);
    if S = AUnitName then
    begin
      Result := True;
      Break;
    end;
  end;
end;

function TCrossApp.LoadExternalUnit(ProjLang, ExtPath: string): Boolean;
type
  TUseFileType = (ufHttp, ufFtp, ufFile);
var
  ExtFileName, CodeExt, FileExt, AFileName, MdFileName, AFName: string;
  ExtDoc: TXMLDocument;
  ExtNode: TDOMElement;
  ExtStream: TMemoryStream;
  NodeObj: TNodeObject;
  FTP: TFTPSend;
  SL, FL: TStringList;
  Prot, User, Pass, Host, Port, Path, Para: string;
  I, N: Integer;
  fs: TSearchRec;
  ufType: TUseFileType;
begin
  Result := False;
  //ExtPath:= FPrjOpt.ExpandExternalPath;
  ufType:= ufFile;
  if ExtPath <> '' then
  begin
    if Pos('ftp://', ExtPath) = 1 then
      ufType:= ufFtp
    else
    if (Pos('http://', ExtPath) = 1) or (Pos('https://', ExtPath) = 1) then
      ufType:= ufHttp;
  end;

  if ufType = ufFtp then
  begin
    ExtDoc := nil;
    FTP := TFTPSend.Create;
    try
      ParseURL(ExtPath, Prot, User, Pass, Host, Port, Path, Para);
      FTP.TargetHost := Host;
      FTP.TargetPort := Port;
      FTP.UserName := User;
      FTP.Password := Pass;
      if FTP.Login then
      begin
        CodeExt := '.pas';
        if ProjLang = ALterLanguage then CodeExt := '.dp';

        if FTP.ChangeWorkingDir(Path) then
        begin
          Result := True;
          if FTP.List(Path, False) then
          begin
            for I := 0 to FTP.FtpList.Count - 1 do
            begin
              ExtFileName := FTP.FtpList.Items[I].FileName;
              FileExt:= ExtractFileExt(ExtFileName);
              if SameText(FileExt, CodeExt) then
              begin
                if FTP.RetrieveFile(ExtFileName, False) then
                begin
                  ExtStream := TMemoryStream.Create;
                  SL := TStringList.Create;
                  try
                    FTP.DataStream.Seek(0, soFromBeginning);
                    SL.LoadFromStream(FTP.DataStream);
                    AFileName := ExtractFileNameWithoutExt(ExtFileName);
                    MdFileName := AFileName + '.md';

                    NodeObj := TNodeObject.Create;
                    NodeObj.Code := SL.Text;
                    ObjectList.AddObject(AFileName, NodeObj);

                    for N := 0 to FTP.FtpList.Count - 1 do
                    begin
                      AFName:= ExtractFileName(FTP.FtpList.Items[N].FileName);
                      if UTF8CompareText(MdFileName, AFName) = 0 then
                      begin
                        if FTP.RetrieveFile(FTP.FtpList.Items[N].FileName, False) then
                        begin
                          FTP.DataStream.Seek(0, soFromBeginning);
                          ReadXMLFile(ExtDoc, FTP.DataStream);
                          ExtNode := ExtDoc.FirstChild as TDOMElement;
                          if ExtNode.TagName = 'Object' then
                          begin
                            NodeObj.ObjClassName := ExtNode.AttribStrings['ClassName'];
                            NodeObj.Obj := ExtNode.TextContent;
                          end
                          else
                            raise Exception.Create(AFName + ' не содержит метаданных');
                        end;
                        Break;
                      end;
                    end;
                  finally
                    ExtStream.Free;
                    SL.Free;
                    if Assigned(ExtDoc) then ExtDoc.Free;
                  end;
                end;
              end;
            end;
          end;
        end;
        FTP.Logout;
      end;
    finally
      FTP.Free;
    end;
  end
  else
  if ufType = ufFile then
  begin
    if DirectoryExists(ExtPath) then
    begin
      Result := True;
      SL := TStringList.Create;
      FL := TStringList.Create;
      try
        ExtPath := ExtPath + DirectorySeparator;
        CodeExt := '.pas';
        if ProjLang = ALterLanguage then CodeExt := '.dp';
        if FindFirst(ExtPath  + '*.*', faAnyFile, fs) = 0 then
        begin
          Repeat
            if (fs.Attr and faDirectory) <> faDirectory then
            begin
              ExtFileName := fs.Name;
              FL.Append(ExtFileName);
            end;
          until FindNext(fs) <> 0;
          FindClose(fs);
        end;
        for I := 0 to FL.Count - 1 do
        begin
          ExtFileName := FL.Strings[I];
          FileExt := ExtractFileExt(ExtFileName);
          if SameText(FileExt, CodeExt) then
          begin
            SL.LoadFromFile(ExtPath + ExtFileName);
            AFileName:= ExtractFileNameWithoutExt(ExtFileName);
            NodeObj := TNodeObject.Create;
            NodeObj.Code := SL.Text;
            ObjectList.AddObject(AFileName, NodeObj);
            MdFileName := ExtPath + AFileName + '.md';
            if FileExists(MdFileName) then
            begin
              ReadXMLFile(ExtDoc, MdFileName);
              ExtNode := ExtDoc.FirstChild as TDOMElement;
              if ExtNode.TagName = 'Object' then
              begin
                NodeObj.ObjClassName := ExtNode.AttribStrings['ClassName'];
                NodeObj.Obj := ExtNode.TextContent;
              end
              else
                raise Exception.Create(AFName + ' не содержит метаданных');
            end;
          end;
        end;
      finally
        SL.Free;
        FL.Free;
      end;
    end;
  end
end;

procedure TCrossApp.LoadExternal(ProjLang: string);
var
  I: Integer;
  SL: TStringList;
  APath: string;
begin
  SL := TStringList.Create;
  try
    SL.Delimiter:= ';';
    SL.DelimitedText:= FPrjOpt.ExternalPath;
    for I := 0 to SL.Count - 1 do
    begin
      APath := FPrjOpt.ExpandPath(SL.Strings[I]);
      if APath <> '' then
      begin
        if LoadExternalUnit(ProjLang, APath) then Break;
      end;
    end;
  finally
    SL.Free;
  end;
end;

constructor TCrossApp.Create(AOwner: TComponent);
var
  Ext, aName, aValue: string;
  SL: TStringList;
  Stream: TStream;
  XMLDocument: TXMLDocument;
  XNode, SNode: TDOMElement;
  S: string;
  GUID: TGuid;
  FTP: TFTPSend;
  Prot, User, Pass, Host, Port, Path, Para: string;
  StrStream, DecodeStream: TStringStream;
  VI: Integer;

  procedure CreateSplashForm;
  var
    Image: Timage;
  begin
    Splash := TForm.Create(Self);
    Splash.FormStyle := fsStayOnTop;
    Splash.BorderStyle := bsNone;
    Splash.ClientWidth := FPrjOpt.Picture.Width;
    Splash.ClientHeight := FPrjOpt.Picture.Height + 20;
    PB := TProgressBar.Create(Splash);
    PB.Name := 'PBar';
    PB.Height := 15;
    PB.Parent := Splash;
    PB.Align := alBottom;
    PB.Step := 1;
    PB.Smooth := True;
    Image := TImage.Create(Splash);
    Image.Parent := Splash;
    Image.Align := alClient;
    Image.Picture.Assign(FPrjOpt.Picture);
    Splash.Position := poScreenCenter;
    FTimer := TTimer.Create(Self);
    FTimer.OnTimer := @OnTimer;
    FTimer.Interval := 3000;
    FTimer.Enabled := True;
    RGN1 := CreateRectRgn(0, 0, Splash.ClientWidth, Splash.ClientHeight - 20);
    RGN2 := CreateRectRgn(0, Splash.ClientHeight - 15, Splash.ClientWidth, Splash.ClientHeight);
    CombineRgn(RGN1, RGN1, RGN2, RGN_OR);
    DeleteObject(RGN2);
    Splash.Show;
    SetWindowRgn(Splash.Handle, RGN1, false);
    //Splash.Repaint;
  end;

  procedure ReadNode(XMLNode: TDOMElement; IsMain: Boolean);
  var
    CodeXMLNode, ObjXMLNode, ChNode: TDOMElement;
    NodeObj: TNodeObject;
    Obj, Code, ObjClassName, NodeName: string;

  begin
    while XMLNode <> nil do
    begin
      Code := '';
      Obj := '';
      CodeXMLNode := XMLNode.FindNode('Code') as TDOMElement;
      if CodeXMLNode <> nil then
      begin
        Code := CodeXMLNode.TextContent;
        if IsMain then
          MainUnit := Code;
      end;
      ObjXMLNode := XMLNode.FindNode('Object') as TDOMElement;
      if ObjXMLNode <> nil then
      begin
        ObjClassName := ObjXMLNode.AttribStrings['ClassName'];
        Obj := ObjXMLNode.TextContent;
      end;
      if (Obj <> '') or (Code <> '') then
      begin
        NodeObj := TNodeObject.Create;
        if IsMain then
          NodeObj.UseNode := True
        else
          NodeObj.UseNode := False;
        NodeObj.Obj := Obj;
        NodeObj.Code := Code;
        NodeObj.ObjClassName := ObjClassName;
        NodeName:= XMLNode.TagName;
        ObjectList.AddObject(NodeName, NodeObj);
      end;
      IsMain := False;
      ChNode := XMLNode.FindNode('Child') as TDOMElement;
      if ChNode <> nil then
      begin
        ChNode := ChNode.FirstChild as TDOMElement;
        if ChNode <> nil then
        begin
          if ChNode.TagName <> '' then ReadNode(ChNode, False);
        end;
      end;
      XMLNode := XMLNode.NextSibling as TDOMElement;
    end;
  end;

begin
  inherited Create(AOwner);
  SetVersion(Application.ExeName, AppVersion, VMajor, VMinor, VRevision);
  Application.UpdateFormatSettings:=false;
  ErrConfigLoad:= False;
  Application.OnException := @OnAppExeption;
  Application.ProcessMessages;
  BreakPointList := TStringList.Create;
  StartTime := GetTickCount;
  PB := nil;
  FStopped := False;
  FTrace := False;
  FLinked := False;
  Self.Name := 'DPApplication';
  SystemParametersInfo(SPI_SETBEEP, 0, nil, 0 );
  ConfigFile := ParamStr(1);
  EngineDir := ExtractFilePath(Application.ExeName);
  FDebug := False;
  FErrList := TStringList.Create;
  Script := TDpCompiler.Create(Application);
  Script.Name := 'PScript';
  Script.UseTranscription := True;
  Script.OnGetUnitSource := @GetUnitSource;
  Script.OnAddObject := @AddScriptObject;
  Script.OnAddMethod := @AddScriptMethod;
  Script.OnCreateForm := @OnCreateScriptForm;
  Script.OnCreateFrame := @OnCreateFrame;
  Script.OnCreateDataModule := @OnCreateDataModule;
  Script.OnAddClassImporter := @OnAddClassImport;

  Script.OnError := @OnScriptError;
  Script.OnAddConst := @OnScriptAddConst;
  FBreakPointsExist := False;
  DebugServer := nil;
  DebugClient := nil;
  if (ParamStr(2) = 'D') or (ParamStr(2) = 'T') then
  begin
    if ParamStr(3) <> '' then
    begin
      DebugServer := TSimpleIPCServer.Create(Self);
      CreateGUID(GUID);
      DebugServer.ServerID := GUIDToString(GUID);
      DebugServer.OnMessage := @OnDebugMessage;
      DebugServer.OnMessageQueued := @OnMessageQueued;
      DebugServer.Global := True;
      {$IFDEF UNIX}
      DebugServer.Threaded := True;
      DebugServer.SynchronizeEvents := True;
      {$ELSE}
      DebugServer.Threaded := False;
      DebugServer.SynchronizeEvents := False;
      {$ENDIF}
      DebugServer.StartServer;
      DebugClient := TSimpleIPCClient.Create(Self);
      DesignHandle := ParamStr(3);
      DebugClient.ServerID := DesignHandle;
      DebugClient.Connect;
      if DebugClient.Active then
      begin
        FDebug := True;
        GetBreakpontList := True;
        Script.OnExecuteInstruction := @DebugProc;
        DebugClient.SendStringMessage('0:' + DebugServer.ServerID);
      end;
      if ParamStr(2) = 'T' then
      begin
        FTrace := True;
      end;

      Script.OnCompilerMessage := @OnScriptMessage;
      Script.OnAfterCallProc := @AfterCallProc;
    end;

  end;

  ObjectList := TStringList.Create;
  //ConfFile для отладки, чтобы запустить приложение не передавая его через параметр
  ConfigFile := ConfFile;
  if ConfigFile = '' then
    ConfigFile := ParamStr(1);

  PB := nil;
  FTimer := nil;
  FPrjOpt := TProjectOptions.Create(Self);
  FPrjOpt.Language := 'PASCAL';

  SL := nil;
  XMLDocument := nil;
  Stream := nil;
  //ScriptFileName := '';
  SL := TStringList.Create;
  EVarList := TStringList.Create;
  try

  if ConfigFile <> '' then
  begin
    {$IfDef UNIX}
       DpIniDir := GetUserDir + '.DieselPascal' + DirectorySeparator;
     {$Else}
       DpIniDir := GetUserDir + 'DieselPascal' + DirectorySeparator;
     {$EndIf}
    Ext:= ExtractFileExt(ConfigFile);
    //ScriptFileName := ExtractFileName(ConfigFile);
    ConfigDir := ExtractFilePath(ConfigFile);
    SetEnvironmentVariable('DIESEL_SCRIPT_NAME', ConfigFile);
    SetEnvironmentVariable('DIESEL_EXE_DIR', EngineDir);
    SetEnvironmentVariable('DIESEL_SCRIPT_DIR', ExtractFilePath(ConfigFile));
    SetEnvironmentVariable('DIESEL_EXE_PID', IntToStr(GetProcessID));
    SetEnvironmentVariable('DIESEL_LOCALSET_DIR', DpIniDir);

    if FileExists(EngineDir + 'evars.cfg') then
    begin
      SL.LoadFromFile(EngineDir + 'evars.cfg');
      for VI := 0 to SL.Count - 1 do
      begin
        SL.GetNameValue(VI, aName, aValue);
        SetEnvironmentVariable(UTF8UpperCase(aName), aValue);
      end;
      EVarList.Assign(SL);
    end;

    if FileExists(DpIniDir + 'evars.cfg') then
    begin
      SL.LoadFromFile(DpIniDir + 'evars.cfg');
      for VI := 0 to SL.Count - 1 do
      begin
        SL.GetNameValue(VI, aName, aValue);
        SetEnvironmentVariable(UTF8UpperCase(aName), aValue);
        EVarList.Append(SL.Strings[VI]);
      end;
    end;



    if (Pos('http://', ConfigFile) = 1) or (Pos('https://', ConfigFile) = 1) then
    begin

      if HttpGetText(ConfigFile, SL) then
        Stream := TStringStream.Create(SL.Text);
    end
    else
    if Pos('ftp://', ConfigFile) = 1 then
    begin
      FTP := TFTPSend.Create;
      try
        ParseURL(ConfigFile, Prot, User, Pass, Host, Port, Path, Para);
        FTP.TargetHost := Host;
        FTP.TargetPort := Port;
        FTP.UserName := User;
        FTP.Password := Pass;
        if FTP.Login then
        begin
          if FTP.RetrieveFile(Path, False) then
          begin
            Stream := TMemoryStream.Create;
            FTP.DataStream.Seek(0, soFromBeginning);
            Stream.CopyFrom(FTP.DataStream, FTP.DataStream.Size);
            Stream.Seek(0, soFromBeginning);
          end;
          FTP.Logout;
        end;
      finally
        FTP.Free;
      end;
    end
    else
    if FileExists(ConfigFile) then
    begin
      Stream := TFileStream.Create(ConfigFile, fmOpenRead);
    end;

    if Stream <> nil then
    begin
      if Ext = '.sm9' then
      begin
        Stream.Seek(0, soFromBeginning);
        StrStream := TStringStream.Create('');
        try
          StrStream.CopyFrom(Stream, Stream.Size);
          S := DecodeStr(StrStream.DataString);
          DecodeStream := TStringStream.Create(S);
          try
            ReadXMLFile(XMLDocument, DecodeStream);
          finally
            DecodeStream.Free;
          end;

        finally
          StrStream.Free;
        end;
      end
      else
        ReadXMLFile(XMLDocument, Stream);

      try
          XNode := XMLDocument.DocumentElement;
          if XNode.TagName <> 'CrossEngineApp' then  Exception.Create('Неподдерживаемый формат файла');

          SNode := XNode.FindNode('Options') as TDOMElement;
          if SNode <> nil then
          begin
            S := SNode.TextContent;
            FReadNode := nil;
            TextToObject(S, FPrjOpt);
            if FPrjOpt.Title <> '' then Application.Title := AnsiToUtf8(FPrjOpt.Title);
            if not FPrjOpt.AppIcon.Empty then
            begin
              Application.Icon.Clear;
              Application.Icon := FPrjOpt.AppIcon;
              Application.ProcessMessages;
            end;

            Script.SuLanguage := slPascal;
            if FPrjOpt.Language = ALterLanguage then
              Script.SuLanguage := slPPlus;
            if (FPrjOpt.MinVMajor <> 0) or (FPrjOpt.MinVMinor <> 0) or (FPrjOpt.MinVRevision <> 0) then
            begin
              if not CheckEngineVersion(FPrjOpt.MinVMajor, FPrjOpt.MinVMinor, FPrjOpt.MinVRevision) then
              begin
                S := 'Программа не может работать с этой версией машины Дизель-Паксаль.'#13#10#13#10;
                S := S + 'Требуется обновление до версии: ';
                S := S + IntToStr(FPrjOpt.MinVMajor) + '.' +
                  IntToStr(FPrjOpt.MinVMinor) + '.' +
                  IntToStr(FPrjOpt.MinVRevision) + #13#10;
                S := S + 'Текущая версия: ' + IntToStr(VMajor) + '.' +
                  IntToStr(VMinor) + '.' + IntToStr(VRevision);
                ShowMessage(S);
                ErrConfigLoad:= True;
              end;
            end;
          end;

          Splash := nil;
          if not ErrConfigLoad then
          begin
            if FPrjOpt.Picture.Width > 0 then CreateSplashForm;

            FPrjOpt.Picture.Assign(nil);
            SNode := XNode.FindNode('Metadata') as TDOMElement;

            if SNode <> nil then
            begin
              SNode := SNode.FirstChild as TDOMElement;
              ReadNode(SNode, True);
              if FPrjOpt.ExternalPath <> '' then
                LoadExternal(FPrjOpt.Language);
            end;
          end;

        finally
           if XMLDocument <> nil then
            XMLDocument.Free;
           Stream.Free;
        end;
    end
    else ErrConfigLoad:= True;
  end
  else ErrConfigLoad:= True;

  finally
    SL.Free;
    FPrjOpt.Free;
  end;

  if ErrConfigLoad then Exit;

  if Splash <> nil then
  begin
    if PB <> nil then PB.Max := ObjectList.Count;
  end;
  XDBGrids.GetDataSortField := @GetDBSortingField;
  XDBGrids.AutoSortDataSet:= @OnAutoSortDataset;
  RunScriptApp;
end;

procedure TCrossApp.RunScriptApp;
var
  S: TDpString;
  I: Integer;
  NodeObj: TNodeObject;
begin
  Script.Reset;
  if Script.Compile then
  begin
    if FDebug then
    begin
      S := '';
      if Script.MainProc <> nil then S := Script.MainProc.OriginalName;

      for I := 0 to ObjectList.Count -1 do
      begin
        NodeObj := TNodeObject(ObjectList.Objects[I]);
        if not NodeObj.UseNode then
          OnScriptMessage('Модуль ' + ObjectList.Strings[i] + ' ни где не используется');
      end;

      OnScriptMessage(S + ': Старт');
      if StartTime <> 0 then
      begin
        StartTime := GetTickCount - StartTime;
        OnScriptMessage(S + ': Общее время запуска приложения: ' + FloatToStr(StartTime / 1000) + ' сек');
      end;

      //try
        Script.Run;
      {except on E: Exception do
        begin
          if DebugClient.Active then
            DebugClient.SendStringMessage('2:' + E.Message);
        end;
      end;}
    end
    else
      Script.Run;
  end
  else
    Application.Terminate;
end;

function TCrossApp.OnCreateScriptForm(AOwner: TComponent; AType: TDpType): TForm;
var
  ResursName: string;
  NodeObj: TNodeObject;
begin
  Result := nil;
  ResursName := string(AType.ResursName);
  NodeObj := GetNodeOfObjClassName(ResursName);
  if NodeObj = nil then
  begin
    NodeObj := GetNodeOfUnitName(AType.DeclUnit);
    if (NodeObj <> nil) and (NodeObj.ObjClassName = '') then NodeObj.ObjClassName := ResursName
    else NodeObj := nil;
  end;

  FormShowProp := nil;
  if NodeObj <> nil then
  begin
    FReadNode := NodeObj;
    if Application.MainForm = nil then
      Application.CreateForm(TForm, Result)
    else
      Result := TForm.CreateNew(AOwner);
    ObjectData := Script.AddEmptyData(Result);
    TextToObject(NodeObj.Obj, Result);
    if FormShowProp <> nil then
    begin
      SetMethodProp(Result, FormShowProp, FormShowMethod);
      //if Assigned(Result.OnShow) then Result.OnShow(Result);
    end;
  end
  else
  begin
    Result := TForm.Create(AOwner);
    ObjectData := Script.AddEmptyData(Result);
  end;
end;

function TCrossApp.OnCreateDataModule(AOwner: TComponent; AType: TDpType): TDataModule;
var
  ResursName: string;
  NodeObj: TNodeObject;
begin
  ResursName := string(AType.ResursName);
  NodeObj := GetNodeOfObjClassName(ResursName);
  if NodeObj = nil then
  begin
    NodeObj := GetNodeOfUnitName(AType.DeclUnit);
    if (NodeObj <> nil) and (NodeObj.ObjClassName = '') then NodeObj.ObjClassName := ResursName
    else NodeObj := nil;
  end;
  if NodeObj <> nil then
  begin
    FReadNode := NodeObj;
    Result := TDataModule.CreateNew(AOwner);
    ObjectData := Script.AddEmptyData(Result);
    TextToObject(NodeObj.Obj, Result);
    //if Assigned(Result.OnCreate) then Result.OnCreate(Result);
  end
  else
  begin
    Result := TDataModule.CreateNew(AOwner);
    ObjectData := Script.AddEmptyData(Result);
  end;
end;

function TCrossApp.OnCreateFrame(AOwner: TComponent; AType: TDpType): TFrame;
var
  ResursName: string;
  NodeObj: TNodeObject;
begin
  ResursName := string(AType.ResursName);
  NodeObj := GetNodeOfObjClassName(ResursName);
  if NodeObj = nil then
  begin
    NodeObj := GetNodeOfUnitName(AType.DeclUnit);
    if (NodeObj <> nil) and (NodeObj.ObjClassName = '') then NodeObj.ObjClassName := ResursName
    else NodeObj := nil;
  end;
  if NodeObj <> nil then
  begin
    FReadNode := NodeObj;
    Result := TSuFrame.Create(AOwner);
    ObjectData := Script.AddEmptyData(Result);
    TextToObject(NodeObj.Obj, Result);

  end
  else
  begin
    Result := TSuFrame.Create(AOwner);
    ObjectData := Script.AddEmptyData(Result);
  end;
end;

procedure TCrossApp.DebugProc(AUnitName: TDpString; ACol, ARow: Integer);
var
  S: string;
  I, N, R: Integer;
  UName: string;
begin
  if FDebug then
  begin

    if BreakPointList.Count > 0 then
    begin
      UName:= UTF8LowerCase(AUnitName) + '=';
      for I := 0 to BreakPointList.Count - 1 do
      begin
        S := BreakPointList.Strings[I];
        if Pos(UName, S) = 1 then
        begin
          N := LastDelimiter('=', S);
          if N > 0 then
          begin
            Delete(S, 1, N);
            R := StrToInt(S);
            if R = ARow then
            begin
              FTrace := True;
            end;
          end;
        end;
      end;
    end;

    if FTrace then
    begin
      FStopped := True;
      S := '5:' + AUnitName + '=' + IntToStr(ACol + 1) + ',' + IntToStr(ARow + 1);
      DebugClient.SendStringMessage(S);
      while FStopped do
      begin
        Application.ProcessMessages;
      end;
    end;
  end;
end;

{procedure TCrossApp.UpdateBreakPointsList;
var
  BPList: TStringList;
  I, N, SaveN, C: Integer;
  S, UName, SNum: string;
  NO: TNodeObject;
begin

end;}

procedure TCrossApp.AfterCallProc(Proc: TDpCustomProc);
begin
  if FDebug then
  begin
    if FTrace then
    begin
      DebugClient.SendStringMessage('7:');
    end;
  end;
end;

procedure TCrossApp.OnAddClassImport(AddImporter: TAddImporterProc);
begin
  AddImporters(AddImporter);
end;

procedure TCrossApp.OnTimer(Sender: TObject);
begin
  if Splash <> nil then
  begin
   Splash.Free;
   Splash := nil;
   if RGN1 <> 0 then DeleteObject(RGN1);
  end;
  FTimer.Enabled := False;
end;

function TCrossApp.GetUnitSource(AUnitName: string): string;
var
  I: Integer;
  NodeObj: TNodeObject;
  UtfName, S: string;
begin
  if PB <> nil then
  begin
    Inc(FI);
    PB.Position := FI;
    Application.ProcessMessages;
  end;
  Result := '';
  UtfName:= UTF8LowerCase(AUnitName);
  if UtfName = '!' then
  begin
    Result := MainUnit;
    Exit;
  end;

  for I := 0 to ObjectList.Count -1 do
  begin
    S := UTF8LowerCase(ObjectList.Strings[I]);
    if UtfName = S then
    begin
      NodeObj := TNodeObject(ObjectList.Objects[I]);
      NodeObj.UseNode := True;
      Result := NodeObj.Code;
      Break;
    end;
  end;
end;

function TCrossApp.GetClassResurce(AClassName: string): string;
var
  I: Integer;
  NodeObj: TNodeObject;
begin
  Result := '';
  for I := 0 to ObjectList.Count - 1 do
  begin
    NodeObj := TNodeObject(ObjectList.Objects[I]);
    if SameText(NodeObj.ObjClassName, AClassName) then
    begin
      Result := NodeObj.Obj;
      Break;
    end;
  end;
end;

procedure TCrossApp.ReaderReadStringProp(Sender: TObject;
  const Instance: TPersistent; PropInfo: PPropInfo; var Content: string);
var
  SaveName: string;
  Frame: TFrame;
  NodeObj, SaveNode: TNodeObject;
begin
  if (Instance is TSuFrame) and (TComponent(Instance).Owner <> nil) then
  begin
    if PropInfo^.Name = 'VirtualClassName' then
    begin
        NodeObj := GetNodeOfObjClassName(Content);
        if NodeObj <> nil then
        begin
          Frame := TFrame(Instance);
          SaveNode := FReadNode;
          FReadNode := NodeObj;
          try
            SaveName := Frame.Name;
            TextToFrame(NodeObj.Obj, Frame);
            Frame.Name := SaveName;
          finally
            FReadNode := SaveNode;
          end;

        end;
    end;
  end;
end;

function TCrossApp.GetObjClassName(Value: string): string;
var
  I: Integer;
begin
  Result := '';
  if Value <> '' then
  begin
    I := Pos(':', Value);
    if I > 8 then
    begin
      Result := 'T' + Copy(Value, 8, I - 8);
    end;
  end;
end;

{procedure TCrossApp.ReadComponentSetName(Reader: TReader; Component: TComponent; var AName: string);
begin
  FCurReadComponent := Component;
end;}

procedure TCrossApp.AddScriptObject(AddObject: TAddObjectProc);
begin
  AddScriptObj(AddObject);
end;

procedure TCrossApp.OnScriptAddConst(AddConst: TAddConstProc);
var
  VI: Integer;
  aName, aValue: string;
begin
  ScriptAddConst(AddConst);
  AddConst('ConfigPath', 'string', ConfigDir);
  AddConst('DIESEL_SCRIPT_DIR', 'string', ConfigDir);
  AddConst('DIESEL_SCRIPT_NAME', 'string', ConfigFile);
  AddConst('DIESEL_EXE_DIR', 'string', EngineDir);
  AddConst('DIESEL_EXE_PID', 'DWORD', GetProcessID);
  AddConst('DIESEL_LOCALSET_DIR', 'string', DpIniDir);
  for VI := 0 to EVarList.Count - 1 do
  begin
    EVarList.GetNameValue(VI, aName, aValue);
    if (aName <> '') and (aValue <> '') then
      AddConst(UTF8UpperCase(aName), 'string', aValue);
  end;
  EVarList.Clear;
end;

procedure TCrossApp.AddScriptMethod(AddMethod: TAddMethodProc);
begin
  AddMethod('function GetSumProp(V: Variant; SmallFormat: Boolean): string', @Call_GetSumProp);
  AddMethod('procedure GetEngineVersion(Out VMajor, VMinor, VRevision: Integer)', @Call_GetEngineVersion);
  AddMethod('function CheckEngineVersion(VMajor, VMinor, VRevision: Integer): Boolean', @Call_CheckEngineVersion);
  AddMethod('procedure DebugValue(V: Variant)', @Call_DebugValue);
end;

procedure TCrossApp.OnScriptMessage(AMessage: TDpString);
begin
  if not FDebug then Exit;
  if DebugClient.Active then
  begin
    DebugClient.SendStringMessage('1:' + AMessage);
  end;
end;

procedure TCrossApp.OnScriptError(AMessage: TDpCompilerMessage);
begin
  if (DebugClient <> nil) and DebugClient.Active then
  begin
    DebugClient.SendStringMessage('2:' + AMessage.MessageStr);
  end;
end;

function TCrossApp.GetNodeOfUnitName(AUnitName: TDpString): TNodeObject;
var
  I: Integer;
begin
  Result := nil;
  I := 0;
  while I < ObjectList.Count do
  begin
    if CompareText(AUnitName, ObjectList.Strings[I]) = 0 then
    begin
      Result := TNodeObject(ObjectList.Objects[I]);
      Exit;
    end;
    Inc(I);
  end;
end;

function TCrossApp.GetNodeOfObjClassName(var ObjClassName: string): TNodeObject;
var
  I: Integer;
  NodeObj: TNodeObject;
begin
  Result := nil;
  if ObjClassName = '' then Exit;
  I := 0;
  while I < ObjectList.Count do
  begin
    NodeObj := TNodeObject(ObjectList.Objects[I]);
    if SameText(ObjClassName, NodeObj.ObjClassName) then
    begin
      Result := NodeObj;
      Exit;
    end;
    Inc(I);
  end;
end;

procedure TCrossApp.ReaderSetMethodProp(Reader: TReader; Instance: TPersistent;
  PropInfo: PPropInfo; const TheMethodName: string; var Handled: boolean);
var
  C: TComponent;
  M: TMethod;
  MethodAddr: Pointer;
  ATypeInfo: PTypeInfo;
  TypeData: PTypeData;
  Proc: TSuProc;
  RefProc: TRefProc;
  IO: TIdentObject;
  I: Integer;
begin
  if FReadNode = nil then Exit;
  Handled := True;
  C := TComponent(Instance);

  //ищем метод скрипта - обработчик события
  Proc := nil;
  IO := ObjectData.Find(TheMethodName);
  if (IO <> nil) then Proc := TSuProc(IO);

  if Proc = nil then
  begin
    Proc := Script.GetClassMethod(TDpString(FReadNode.ObjClassName), TDpString(TheMethodName));
    if Proc <> nil then
    begin
      RefProc := TRefProc.Create(Script);
      RefProc.Proc := Proc;
      RefProc.RefObj.Value := TSuPtr(Reader.Root);
      ObjectData.AddObject(RefProc);
      Proc := RefProc;
    end;
  end;

  if Proc <> nil then
  begin
       //Получаем информацию о типе метода – свойства.
      ATypeInfo := PropInfo^.PropType;
      TypeData := GetTypeData(ATypeInfo);
      I := TypeData^.ParamCount - 1;
      if Proc.ParamCount <> I then
      begin
        ShowMessage(Proc.DeclUnit + '.' + Proc.Name + ' неверное количество параметров при вызове');
      end;

      //Получаем обработчик из процедуры скрипта
      MethodAddr := Proc.CreateEventHandler(ATypeInfo);
      if (PropInfo <> nil) and (MethodAddr <> nil) then
      begin
         {Если адрес метода найден, то
         устанавливаем связь с обработчиком события}
        M.Data := Proc.EventHandler;
        M.Code := MethodAddr;
        if (C is TForm) and (Proc.Name = 'formshow') then
        begin
          FormShowProp := PropInfo;
          FormShowMethod := M;
        end
        else
          SetMethodProp(C, PropInfo, M);
      end;
  end;
end;

procedure TCrossApp.OnDebugMessage(Sender: TObject);
var
  S: string;
  I: Integer;
begin
  S := DebugServer.StringMessage;
  if S = '9:' then
  begin
    if FStopped then FStopped := False;
    if FTrace then FTrace := False;
  end
  else
  if S = '8:' then
  begin
    if FStopped then
    begin
      FTrace := True;
      FStopped := False;
    end;
  end
  else
  if Pos('5:', S) = 1 then
  begin
    Delete(S, 1, 2);
    BreakPointList.Add(UTF8LowerCase(S));
  end
  else
  if Pos('6:', S) = 1 then
  begin
    Delete(S, 1, 2);
    I := BreakPointList.IndexOf(UTF8LowerCase(S));
    if I >= 0 then
      BreakPointList.Delete(I);
  end
  else
  if S = '4:' then
   GetBreakpontList := False
end;

procedure TCrossApp.OnMessageQueued(Sender: TObject);
begin
  DebugServer.ReadMessage;
end;

procedure TCrossApp.CheckMessage(Sender: TObject);
begin
  DebugServer.PeekMessage(5, True);
end;

procedure TCrossApp.OnAppExeption(Sender: TObject; E: Exception);
var
  S: string;
  {$IFDEF IBX}
  SL: TStringList;
  SQLErrCode, IBErrCode: LongInt;
  {$ENDIF}
begin
  //Application.Flags:= Application.Flags + [AppHandlingException];
  if (not Application.Terminated) and (AppInitialized in Application.Flags) then
  begin
    Application.DisableIdleHandler;
    try
      S := E.Message;
      if FindInvalidUTF8Character(PChar(S), Length(S), False) > 0 then
        S := dp_AnsiToUTF8(S);

      {$IFDEF IBX}
      if E is EIBInterBaseError then
      begin
        SQLErrCode := EIBInterBaseError(E).SQLCode;
        IBErrCode:= EIBInterBaseError(E).IBErrorCode;
        if (SQLErrCode = -836) and ((IBErrCode = 335544517) or
        (IBErrCode = 335544848))  then
        begin
          SL := TStringList.Create;
          SL.Text:= S;
          if SL.Count > 2 then
            S := SL.Strings[2];
          SL.Free;

        end;
      end;
      {$ENDIF}

      if FTrace then
      begin
        DebugClient.SendStringMessage('3:' + S);
      end;

      Application.MessageBox(PChar(S), PChar(Application.Title), MB_OK or MB_ICONERROR);
    finally
      Application.EnableIdleHandler;
    end;
  end;
end;

procedure TCrossApp.ReaderSetFrameMethodProp(Reader: TReader;
  Instance: TPersistent; PropInfo: PPropInfo; const TheMethodName: string;
  var Handled: boolean);
var
  C: TComponent;
  M: TMethod;
  MethodAddr: Pointer;
  ATypeInfo: PTypeInfo;
  TypeData: PTypeData;
  Proc: TSuProc;
  RefProc: TRefProc;
  I: Integer;
begin
  if FReadNode = nil then Exit;
  Handled := True;
  C := TComponent(Instance);

  //ищем метод скрипта - обработчик события
  Proc := nil;
  Proc := Script.GetClassMethod(FReadNode.ObjClassName, TheMethodName);
  if Proc <> nil then
  begin
    RefProc := TRefProc.Create(Script);
    ObjectData.AddObject(RefProc);
    RefProc.Proc := Proc;
    RefProc.RefObj.Value := TSuPtr(Reader.Root);
    Proc := RefProc;
    Proc.Name := Reader.Root.Name + TheMethodName;
  end;

  if Proc <> nil then
  begin
      //Получаем информацию о типе метода – свойства.
      ATypeInfo := PropInfo^.PropType;
      TypeData := GetTypeData(ATypeInfo);
      I := TypeData^.ParamCount - 1;
      if Proc.ParamCount <> I then
      begin
        ShowMessage(Proc.DeclUnit + '.' + Proc.Name + ' неверное количество параметров при вызове');
      end;

      //Получаем обработчик из процедуры скрипта
      MethodAddr := Proc.CreateEventHandler(ATypeInfo);
      if (PropInfo <> nil) and (MethodAddr <> nil) then
      begin
         {Если адрес метода найден, то
         устанавливаем связь с обработчиком события}
        M.Data := Proc.EventHandler;
        M.Code := MethodAddr;
        SetMethodProp(C, PropInfo, M);
      end;
  end;
end;

function TCrossApp.TextToObject(Obj: string; Instance: TComponent): TComponent;
var
  StrStream:TStringStream;
  BinStream: TMemoryStream;
  Reader: TReader;
begin
  //if Instance = nil then Exit;
  StrStream := TStringStream.Create(Obj);
  try
    BinStream := TMemoryStream.Create;
    try
      ObjectTextToBinary(StrStream, BinStream);
      BinStream.Seek(0, soFromBeginning);
      //FCurReadComponent := nil;
      FReadRoot := Instance;
      Reader := TReader.Create(BinStream, 4096);
      Reader.OnSetMethodProperty := @ReaderSetMethodProp;
      Reader.OnReadStringProperty := @ReaderReadStringProp;
      try
        Result := Reader.ReadRootComponent(Instance);
      finally
        Reader.Free;
      end;
    finally
      BinStream.Free;
    end;
  finally
    StrStream.Free;
  end;
end;

procedure TCrossApp.TextToFrame(S: string; var Frame: TFrame);
var
  StrStream:TStringStream;
  BinStream: TMemoryStream;
  Reader: TReader;
  R: TRect;
  Align: TAlign;
  SetPos: Boolean;
begin
  SetPos := False;
  if Frame = nil then Exit;
  begin
    R := Frame.BoundsRect;
    Align := Frame.Align;
    SetPos := True;
  end;
  StrStream := TStringStream.Create(s);
  try

     BinStream := TMemoryStream.Create;
     try
        ObjectTextToBinary(StrStream, BinStream);
        BinStream.Seek(0, soFromBeginning);
        Reader := TReader.Create(BinStream, 4096);
        Reader.OnSetMethodProperty := @ReaderSetFrameMethodProp;
        try
          Reader.ReadRootComponent(Frame);

          //Frame.Name := LFMComponentName;
        finally
          Reader.Free;
        end;
     finally
       BinStream.Free;
     end;
  finally
   StrStream.Free;

  end;
  if SetPos then
  begin
    Frame.Align := Align;
    Frame.BoundsRect := R;
  end
end;

function TCrossApp.GetSumProp(V: Variant; SmallFormat: Boolean): string;
const
  Kop = 'коп.';
  Kopeek = 'копеек';
  Kopeiki = 'копейки';
  Kopeika = 'копейка';
  Rub = 'руб. ';
  Rubl = 'рубль ';
  Rubley = 'рублей ';
  Rublya = 'рубля ';
  Tisach = 'тысяч ';
  Tisacha = 'тысяча ';
  Tisachi = 'тысячи ';
  Million = 'миллион ';
  Millionov = 'миллионов ';
  Milliona = 'миллиона ';
  Milliard = 'миллиард ';
  Milliardov = 'миллиардов ';
  Milliarda = 'миллиарда ';
var
  I, Ps: Integer;
  Len: Integer;
  IntStr: string;
  IntProp: string;
  FracStr: string;
  Summa: string;
  Mlrd, Mln, Tis: Boolean;
begin
  Summa := V;
  Mlrd := False;
  Mln := False;
  Tis:= False;
  I := LastDelimiter('.,', Summa);
  if I <> 0 then
  begin
      IntStr := Copy(Summa, 1, I - 1);
      FracStr := Copy(Summa, I + 1, 255);
      Len := Length(FracStr);
      if Len = 1 then
      begin
        FracStr := FracStr + '0';
        Inc(Len);
      end;

      if SmallFormat then
      begin
        FracStr := FracStr + ' ' + Kop;
      end
      else
      begin
        if (FracStr[Len] = '0') or (FracStr[Len] > '4') or ((FracStr[Len - 1] = '1')) then FracStr := FracStr + ' ' + Kopeek
        else
        if (FracStr[Len] = '1') and (FracStr[Len - 1] <> '1') then FracStr := FracStr + ' ' + Kopeika
        else
        if FracStr[Len - 1] <> '1' then
          FracStr := FracStr + ' ' + Kopeiki
        else
          FracStr := FracStr + ' ' + Kopeek;
        end;
    end
    else
    begin
      IntStr := Summa;
      if SmallFormat then
        FracStr := '00 ' + Kop
      else
        FracStr := '00 копеек';
    end;
    Len := Length(IntStr) + 1;
    IntProp := '';
    if Len > 0 then
    begin
      I := 1;
      while I < Len do
      begin
        Ps := Len - I;
        if IntStr[I] <> '0' then
        begin
          case Ps of
            10..12: Mlrd := True;
            7..9: Mln := True;
            4..6: Tis := True;
          end;
        end;
        Inc(I);
      end;
      I := 1;
      while I < Len do
      begin
        Ps := Len - I;
        Case Ps of
          3, 6, 9, 12:
          begin
            if IntStr[I] = '1' then IntProp := IntProp + 'сто '
            else
            if IntStr[I] = '2' then IntProp := IntProp + 'двести '
            else
            if IntStr[I] = '3' then IntProp := IntProp + 'триста '
            else
            if IntStr[I] = '4' then IntProp := IntProp + 'четыреста '
            else
            if IntStr[I] = '5' then IntProp := IntProp + 'пятьсот '
            else
            if IntStr[I] = '6' then IntProp := IntProp + 'шестьсот '
            else
            if IntStr[I] = '7' then IntProp := IntProp + 'семьсот '
            else
            if IntStr[I] = '8' then IntProp := IntProp + 'восемьсот '
            else
            if IntStr[I] = '9' then IntProp := IntProp + 'девятьсот ';
          end;
          2, 5, 8, 11:
          begin
            if IntStr[I] = '1' then
            begin
              if IntStr[I + 1] = '1' then
                IntProp := IntProp + 'одинадцать '
              else
              if IntStr[I + 1] = '2' then
                IntProp := IntProp + 'двенадцать '
              else
              if IntStr[I + 1] = '3' then
                IntProp := IntProp + 'тринадцать '
              else
              if IntStr[I + 1] = '4' then
                IntProp := IntProp + 'четырнадцать '
              else
              if IntStr[I + 1] = '5' then
                IntProp := IntProp + 'пятнадцать '
              else
              if IntStr[I + 1] = '6' then
                IntProp := IntProp + 'шестнадцать '
              else
              if IntStr[I + 1] = '7' then
                IntProp := IntProp + 'семнадцать '
              else
              if IntStr[I + 1] = '8' then
                IntProp := IntProp + 'восемнадцать '
              else
              if IntStr[I + 1] = '9' then
                IntProp := IntProp + 'девятнадцать '
              else
              if IntStr[I + 1] = '0' then
                IntProp := IntProp + 'десять ';
              case Ps of
                2:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                5: if Tis then IntProp := IntProp + Tisach;
                8: if Mln then IntProp := IntProp + Millionov;
                11: if Mlrd then IntProp := IntProp + Milliardov;
              end;
              Inc(I);
            end
            else
            if IntStr[I] = '2' then IntProp := IntProp + 'двадцать '
            else
            if IntStr[I] = '3' then IntProp := IntProp + 'тридцать '
            else
            if IntStr[I] = '4' then IntProp := IntProp + 'сорок '
            else
            if IntStr[I] = '5' then IntProp := IntProp + 'пятьдесят '
            else
            if IntStr[I] = '6' then IntProp := IntProp + 'шестьдесят '
            else
            if IntStr[I] = '7' then IntProp := IntProp + 'семьдесят '
            else
            if IntStr[I] = '8' then IntProp := IntProp + 'восемьдесят '
            else
            if IntStr[I] = '9' then IntProp := IntProp + 'девяносто ';
          end;
          1, 4, 7, 10:
          begin
            if IntStr[I] = '1' then
            begin
              if Ps = 4 then
                IntProp := IntProp + 'одна '
              else
                IntProp := IntProp + 'один ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubl;
                end;
                4: if Tis then IntProp := IntProp + Tisacha;
                7: if Mln then IntProp := IntProp + Million;
                10: if Mlrd then IntProp := IntProp + Milliard;
              end;
            end
            else
            if IntStr[I] = '2' then
            begin
              if Ps = 4 then
                IntProp := IntProp + 'две '
              else
                IntProp := IntProp + 'два ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rublya;
                end;
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '3' then
            begin
              IntProp := IntProp + 'три ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rublya;
                end;
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '4' then
            begin
              IntProp := IntProp + 'четыре ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rublya;
                end;
                4: if Tis then IntProp := IntProp + Tisachi;
                7: if Mln then IntProp := IntProp + Milliona;
                10: if Mlrd then IntProp := IntProp + Milliarda;
              end;
            end
            else
            if IntStr[I] = '5' then
            begin
              IntProp := IntProp + 'пять ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '6' then
            begin
              IntProp := IntProp + 'шесть ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '7' then
            begin
              IntProp := IntProp + 'семь ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '8' then
            begin
              IntProp := IntProp + 'восемь ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end
            else
            if IntStr[I] = '9' then
            begin
              IntProp := IntProp + 'девять ';
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end;
            if IntStr[I] = '0' then
            begin
              case Ps of
                1:
                begin
                  if SmallFormat then
                    IntProp := IntProp + Rub
                  else
                    IntProp := IntProp + Rubley;
                end;
                4: if Tis then IntProp := IntProp + Tisach;
                7: if Mln then IntProp := IntProp + Millionov;
                10: if Mlrd then IntProp := IntProp + Milliardov;
              end;
            end;
          end;
        end;
        Inc(I);
      end;
    end;
  Result := IntProp + FracStr;
end;

function TCrossApp.Call_GetSumProp(Instence: TObject; var Params: Variant): Variant;
begin
  Result := GetSumProp(Params[0], Params[1]);
end;

function TCrossApp.Call_GetEngineVersion(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Params[0] := VMajor;
  Params[1] := VMinor;
  Params[2] := VRevision;
end;

function TCrossApp.Call_CheckEngineVersion(Instence: TObject;
  var Params: Variant): Variant;
var
  ChkMajor, ChkMinor, ChkRevision: Integer;
begin
  ChkMajor := Params[0];
  ChkMinor := Params[1];
  ChkRevision := Params[2];
  Result := CheckEngineVersion(ChkMajor, ChkMinor, ChkRevision);
end;

initialization
  InitLocale;
  TranslateResourceStrings('lclstrconsts.po');

end.

