{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit CodeUtils;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

type
  TOnCodeStr = function (Str: string): string;

var
  OnEncodeString: TOnCodeStr;
  OnDecodeString: TOnCodeStr;

function EncodeStr(Str: string): string;
function DecodeStr(Str: string): string;

implementation

uses synacode;

function EncodeStr(Str: string): string;
begin
  if Assigned(OnEncodeString) then
    Result := OnEncodeString(Str)
  else
    Result := EncodeBase64(Str);
end;

function DecodeStr(Str: string): string;
begin
  if Assigned(OnDecodeString) then
    Result := OnDecodeString(Str)
  else
    Result := DecodeBase64(Str);
end;


end.

