{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit dpi_Methods;

{$mode objfpc}{$H+}
{$codepage utf8}

interface

uses
  Classes, SysUtils, LConvEncoding, dpi_mettyps;

type

  { TMethods }

  TMethods = class(TMethodsDef)
  private
    R: TRect;
    procedure AddMethod(Add_Method: TAddMethodProc); override;
    function Call_DateToISO8601(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_GetEnvironmentString(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_GetEnvironmentVariableCount(Instance: TObject;
      var Params: Variant): Variant;
    function Call_GetLocalTimeOffset(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_ISO8601ToDate(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_LocalTimeToUniversal(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_RunCommand(Instance: TObject; var Params: Variant): Variant;
    function Call_RunCommandInDir(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_ScanDateTime(Instance: TObject; var Params: Variant): Variant;
    function Call_SetTimeOffsetUTC(Instance: TObject; var Params: Variant
      ): Variant;
    function Call_UniversalTimeToLocal(Instance: TObject; var Params: Variant
      ): Variant;
  published
    {functions}
    function Call_ShowMessage(Instance: TObject; var Params: Variant): Variant;
    function Call_InputBox(Instance: TObject; var Params: Variant): Variant;
    function Call_RaiseException(Instance: TObject; var Params: Variant): Variant;
    function Call_MessageBox(Instance: TObject; var Params: Variant): Variant;
    function Call_CreateOleObject(Instance: TObject; var Params: Variant): Variant;
    function Call_GetActiveOleObject(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToInt(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToInt64(Instance: TObject; var Params: Variant): Variant;
    function Call_IntToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToFloat(Instance: TObject; var Params: Variant): Variant;
    function Call_FloatToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_DateToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_TimeToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_DateTimeToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_BoolToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_VarToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToDate(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToTime(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToDateTime(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToBool(Instance: TObject; var Params: Variant): Variant;
    function Call_StrToCurr(Instance: TObject; var Params: Variant): Variant;
    function Call_CurrToStr(Instance: TObject; var Params: Variant): Variant;
    function Call_RemoveChar(Instance: TObject; var Params: Variant): Variant;
    function UnpackFIO(Instance: TObject; var Params: Variant): Variant;
    function IntString(Instance: TObject; var Params: Variant): Variant;

    function Call_FormatDateTime(Instance: TObject; var Params: Variant): Variant;
    function Call_FormatFloat(Instance: TObject; var Params: Variant): Variant;
    function Call_FormatMaskText(Instance: TObject; var Params: Variant): Variant;

    function Call_FileExists(Instance: TObject; var Params: Variant): Variant;
    function Call_DirectoryExists(Instance: TObject; var Params: Variant): Variant;
    function Call_ExtractFilePath(Instance: TObject; var Params: Variant): Variant;
    function Call_ExtractFileName(Instance: TObject; var Params: Variant): Variant;
    function Call_ExtractFileExt(Instance: TObject; var Params: Variant): Variant;
    function Call_ExtractFileDir(Instance: TObject; var Params: Variant): Variant;
    function Call_ExtractFileDrive(Instance: TObject; var Params: Variant): Variant;
    function Call_CreateDir(Instance: TObject; var Params: Variant): Variant;
    function Call_DeleteFile(Instance: TObject; var Params: Variant): Variant;
    function Call_CopyFile(Instance: TObject; var Params: Variant): Variant;
    function Call_RenameFile(Instance: TObject; var Params: Variant): Variant;
    function Call_RemoveDir(Instance: TObject; var Params: Variant): Variant;
    function Call_FilenameToURL(Instance: TObject; var Params: Variant): Variant;
    function Call_ReplaceFileExt(Instance: TObject; var Params: Variant): Variant;

    function Call_GetDirList(Instance: TObject; var Params: Variant): Variant;
    function Call_GetFileList(Instance: TObject; var Params: Variant): Variant;

    function Call_Random(Instance: TObject; var Params: Variant): Variant;
    function Call_IRandom(Instance: TObject; var Params: Variant): Variant;
    function Call_Randomize(Instance: TObject; var Params: Variant): Variant;

    function Call_VarIsEmpty(Instance: TObject; var Params: Variant): Variant;
    function Call_VarIsClear(Instance: TObject; var Params: Variant): Variant;
    function Call_VarIsNull(Instance: TObject; var Params: Variant): Variant;
    function Call_VarType(Instance: TObject; var Params: Variant): Variant;
    function Call_VarArrayOf(Instance: TObject; var Params: Variant): Variant;
    function Call_VarArrayCreate(Instance: TObject; var Params: Variant): Variant;

    function Call_Round(Instance: TObject; var Params: Variant): Variant;
    function Call_RoundTo(Instance: TObject; var Params: Variant): Variant;
    function Call_Ceil(Instance: TObject; var Params: Variant): Variant;

    function Call_Cos(Instance: TObject; var Params: Variant): Variant;
    function Call_Sin(Instance: TObject; var Params: Variant): Variant;
    function Call_Abs(Instance: TObject; var Params: Variant): Variant;
    function Call_Sqr(Instance: TObject; var Params: Variant): Variant;
    function Call_Int(Instance: TObject; var Params: Variant): Variant;
    function Call_Frac(Instance: TObject; var Params: Variant): Variant;
    function Call_Sqrt(Instance: TObject; var Params: Variant): Variant;
    function Call_ArcTan(Instance: TObject; var Params: Variant): Variant;
    function Call_Tan(Instance: TObject; var Params: Variant): Variant;
    function Call_Exp(Instance: TObject; var Params: Variant): Variant;
    function Call_Ln(Instance: TObject; var Params: Variant): Variant;


    function Call_EncodeDate(Instance: TObject; var Params: Variant): Variant;
    function Call_DecodeDate(Instance: TObject; var Params: Variant): Variant;
    function Call_EncodeTime(Instance: TObject; var Params: Variant): Variant;
    function Call_DecodeTime(Instance: TObject; var Params: Variant): Variant;
    function Call_Date(Instance: TObject; var Params: Variant): Variant;
    function Call_Time(Instance: TObject; var Params: Variant): Variant;
    function Call_Now(Instance: TObject; var Params: Variant): Variant;
    function Call_DayOfWeek(Instance: TObject; var Params: Variant): Variant;
    function Call_IsLeapYear(Instance: TObject; var Params: Variant): Variant;
    function Call_DaysInMonth(Instance: TObject; var Params: Variant): Variant;
    function Call_IncDay(Instance: TObject; var Params: Variant): Variant;
    function Call_IncMonth(Instance: TObject; var Params: Variant): Variant;
    function Call_IncWeek(Instance: TObject; var Params: Variant): Variant;
    function Call_IncYear(Instance: TObject; var Params: Variant): Variant;
    function Call_IncMinute(Instance: TObject; var Params: Variant): Variant;
    function Call_IncSecond(Instance: TObject; var Params: Variant): Variant;
    function Call_IncMilliSecond(Instance: TObject; var Params: Variant): Variant;
    function Call_DaysBetween(Instance: TObject; var Params: Variant): Variant;
    function Call_MonthsBetween(Instance: TObject; var Params: Variant): Variant;
    function Call_YearsBetween(Instance: TObject; var Params: Variant): Variant;
    function Call_WeeksBetween(Instance: TObject; var Params: Variant): Variant;
    function Call_StartOfTheDay(Instance: TObject; var Params: Variant): Variant;
    function Call_EndOfTheDay(Instance: TObject; var Params: Variant): Variant;
    function Call_StartOfTheMonth(Instance: TObject; var Params: Variant): Variant;
    function Call_EndOfTheMonth(Instance: TObject; var Params: Variant): Variant;
    function Call_StartOfTheWeek(Instance: TObject; var Params: Variant): Variant;
    function Call_EndOfTheWeek(Instance: TObject; var Params: Variant): Variant;
    function Call_StartOfTheYear(Instance: TObject; var Params: Variant): Variant;
    function Call_EndOfTheYear(Instance: TObject; var Params: Variant): Variant;
    function Call_GetCurrentDir(Instance: TObject; var Params: Variant): Variant;
    function Call_GetUserDir(Instance: TObject; var Params: Variant): Variant;
    function Call_MonthOfTheYear(Instance: TObject; var Params: Variant): Variant;
    function Call_DateTimeToUnix(Instance: TObject; var Params: Variant): Variant;
    function Call_UnixToDateTime(Instance: TObject; var Params: Variant): Variant;
    function Call_CreateStrGUID(Instance: TObject; var Params: Variant): Variant;

    function Call_Length(Instance: TObject; var Params: Variant): Variant;
    function Call_AnsiStrLength(Instance: TObject; var Params: Variant): Variant;
    function Call_ArrayLength(Instance: TObject; var Params: Variant): Variant;
    function Call_Copy(Instance: TObject; var Params: Variant): Variant;
    function Call_Pos(Instance: TObject; var Params: Variant): Variant;
    function Call_Delete(Instance: TObject; var Params: Variant): Variant;
    function Call_Insert(Instance: TObject; var Params: Variant): Variant;
    function Call_Uppercase(Instance: TObject; var Params: Variant): Variant;
    function Call_Lowercase(Instance: TObject; var Params: Variant): Variant;
    function Call_AnsiUppercase(Instance: TObject; var Params: Variant): Variant;
    function Call_AnsiLowercase(Instance: TObject; var Params: Variant): Variant;
    function Call_AnsiPos(Instance: TObject; var Params: Variant): Variant;
    function Call_AnsiDelete(Instance: TObject; var Params: Variant): Variant;
    function Call_AnsiInsert(Instance: TObject; var Params: Variant): Variant;
    function Call_Trim(Instance: TObject; var Params: Variant): Variant;
    function Call_NameCase(Instance: TObject; var Params: Variant): Variant;
    function Call_CompareText(Instance: TObject; var Params: Variant): Variant;
    function Call_SameText(Instance: TObject; var Params: Variant): Variant;
    function Call_SetLength(Instance: TObject; var Params: Variant): Variant;
    function Call_SetArrayLength(Instance: TObject; var Params: Variant): Variant;
    function Call_LastDelimiter(Instance: TObject; var Params: Variant): Variant;
    function Call_IsDigit(Instance: TObject; var Params: Variant): Variant;
    function Call_IsLetter(Instance: TObject; var Params: Variant): Variant;
    function Call_IsSimbol(Instance: TObject; var Params: Variant): Variant;
    function Call_IsNumericStr(Instance: TObject; var Params: Variant): Variant;


    function Call_Inc(Instance: TObject; var Params: Variant): Variant;
    function Call_Dec(Instance: TObject; var Params: Variant): Variant;
    function Call_Sleep(Instance: TObject; var Params: Variant): Variant;
    function Call_Trunc(Instance: TObject; var Params: Variant): Variant;
    function Call_Assigned(Instance: TObject; var Params: Variant): Variant;

    function Call_Rect(Instance: TObject; var Params: Variant): Variant;
    function Call_Bounds(Instance: TObject; var Params: Variant): Variant;
    function Call_UTF8Decode(Instance: TObject; var Params: Variant): Variant;
    function Call_UTF8Encode(Instance: TObject; var Params: Variant): Variant;
    function Call_AnsiToUTF8(Instance: TObject; var Params: Variant): Variant;
    function Call_UTF8ToAnsi(Instance: TObject; var Params: Variant): Variant;
    function Call_DOSCPToUTF8(Instance: TObject; var Params: Variant): Variant;
    function Call_UTF8ToDOSCP(Instance: TObject; var Params: Variant): Variant;
    function Call_UTF8ToUCS2BE(Instance: TObject; var Params: Variant): Variant;
    function Call_UTF8ToUCS2LE(Instance: TObject; var Params: Variant): Variant;
    function Call_UCS2LEToUTF8(Instance: TObject; var Params: Variant): Variant;
    function Call_UCS2BEToUTF8(Instance: TObject; var Params: Variant): Variant;
    function Call_Ord(Instance: TObject; var Params: Variant): Variant;
    function Call_Chr(Instance: TObject; var Params: Variant): Variant;
    function Call_MD5String(Instance: TObject; var Params: Variant): Variant;

    function Call_ShellExecute(Instance: TObject; var Params: Variant): Variant;
    function Call_FindDefaultBrowser(Instance: TObject; var Params: Variant): Variant;
    function Call_OpenURL(Instance: TObject; var Params: Variant): Variant;
    function Call_OpenDocument(Instance: TObject; var Params: Variant): Variant;
    function Call_GetTickCount(Instance: TObject; var Params: Variant): Variant;
    function Call_SetKeyboardLayot(Instance: TObject; var Params: Variant): Variant;
    function Call_ActivateKeyboardLayot(Instance: TObject; var Params: Variant): Variant;
    function Call_GetSystemMetrics(Instance: TObject; var Params: Variant): Variant;
    function Call_GetUnassigned(Instance: TObject; var Params: Variant): Variant;
    function Call_SetFontQuality(Instance: TObject; var Params: Variant): Variant;
    function Call_GetOSVersion(Instance: TObject; var Params: Variant): Variant;
    function Call_InstanceRunning(Instance: TObject; var Params: Variant): Variant;
    function Call_ParamStr(Instance: TObject; var Params: Variant): Variant;
    function Call_ParamCount(Instance: TObject; var Params: Variant): Variant;

    function Call_ParseURL(Instance: TObject; var Params: Variant): Variant;
    function Call_GetMobileTel(Instance: TObject; var Params: Variant): Variant;
    function Call_GetMobilePhone(Instance: TObject; var Params: Variant): Variant;
  end;

var
  Met: TMethods;

implementation

uses Dialogs, Variants, LCLType, dateutils, strutils, math, maskutils,
  process, Controls,
  {$IFDEF WINDOWS}
  ComObj, Windows,
  {$ENDIF}
  {$IFDEF LINUX}
  unixutil,
  {$ENDIF}
  Forms, dpCompil, dpUtils, TypInfo, LCLIntf, LazFileUtils,
  synautil, LazUTF8, Graphics, UniInstance, md5, dpi_Classes;

var
  scriptuoendsproc: TDpCustomProc;

function GetLinuxSpecialDir(XDG_Const: string): string;
{$IFDEF LINUX}
var
  UDirsFile, S: string;
  SL: TStringList;
{$ENDIF}
begin
  Result := '';
  {$IFDEF LINUX}
  if DirectoryExists(GetUserDir + '.config/') then
  begin
      UDirsFile := GetUserDir + '.config/user-dirs.dirs';
      if FileExists(UDirsFile) then
      begin
        SL := TStringList.Create;
        try
          SL.LoadFromFile(UDirsFile);
          S := SL.Values[XDG_Const];
          if S <> '' then
          begin
            if S[1] = '"' then
            begin
              Delete(S, 1, 1);
              Delete(S, Length(S), 1);
            end;
            if Pos('$HOME/', S) = 1 then
            begin
              Delete(S, 1, 6);
              S := GetUserDir + S;
            end;
            Result := S;
          end;
        finally
          SL.Free;
        end;
      end;
  end;
  {$ENDIF}
end;

procedure TMethods.AddMethod(Add_Method: TAddMethodProc);
begin
  Add_Method('function IntToStr(I: Int64): String', @Call_IntToStr);
  Add_Method('function FloatToStr(E: Extended): String', @Call_FloatToStr);
  Add_Method('function DateToStr(const DateTime: TDateTime): String', @Call_DateToStr);
  Add_Method('function TimeToStr(const Date: TDateTime): String', @Call_TimeToStr);
  Add_Method('function DateTimeToStr(const Date: TDateTime): String', @Call_DateTimeToStr);
  Add_Method('function BoolToStr(B: Boolean): String', @Call_BoolToStr);
  Add_Method('function VarToStr(V: Variant): String', @Call_VarToStr);
  Add_Method('function StrToInt(S: String): Integer', @Call_StrToInt);
  Add_Method('function StrToInt64(S: String): Int64', @Call_StrToInt64);
  Add_Method('function StrToFloat(S: String): Extended', @Call_StrToFloat);
  Add_Method('function StrToDate(S: string; Format: TFormatSet = nil): TDateTime', @Call_StrToDate);
  Add_Method('function StrToTime(S: string; Format: TFormatSet = nil): TDateTime', @Call_StrToTime);
  Add_Method('function StrToDateTime(S: string; F: TFormatSet = nil): TDateTime', @Call_StrToDateTime);
  Add_Method('function StrToBool(S: string): Boolean', @Call_StrToBool);
  Add_Method('function StrToCurr(S: string): Currency', @Call_StrToCurr);
  Add_Method('function CurrToStr(Cur: Currency): string', @Call_StrToCurr);
  Add_Method('procedure RemoveChar(var S: string; C: string)', @Call_RemoveChar);
  Add_Method('procedure UnpackFIO(S: string; var Fam, Imja, Otch: string)', @UnpackFIO);
  Add_Method('function IntString(Template: string; AValue: Integer): string', @IntString);

  Add_Method('function FormatDateTime(Fmt: String; DateTime: TDateTime): String', @Call_FormatDateTime);
  Add_Method('function FormatFloat(Fmt: String; Value: Extended): String', @Call_FormatFloat);
  Add_Method('function FormatMaskText(EditMask: string; Value: string): String', @Call_FormatMaskText);

  Add_Method('function EncodeDate(Year, Month, Day: Integer): TDateTime', @Call_EncodeDate);
  Add_Method('procedure DecodeDate(DateTime: TDateTime; var Year, Month, Day: Integer);', @Call_DecodeDate);
  Add_Method('function EncodeTime(Hour, Min, Sec, MSec: Word): TDateTime', @Call_EncodeTime);
  Add_Method('procedure DecodeTime(Time: TDateTime; var Hour, Min, Sec, MSec: Word)', @Call_DecodeTime);
  Add_Method('function Date: TDateTime', @Call_Date);
  Add_Method('function Time: TDateTime', @Call_Time);
  Add_Method('function Now: TDateTime', @Call_Now);
  Add_Method('function DayOfWeek(const DateTime: TDateTime): word', @Call_DayOfWeek);
  Add_Method('function IsLeapYear(Year: Integer): Boolean', @Call_IsLeapYear);
  Add_Method('function DaysInMonth(ADate: TDateTime): Integer', @Call_DaysInMonth);
  Add_Method('function IncDay(ADate: TDateTime; ANumberOfDays: Integer = 1): TDateTime', @Call_IncDay);
  Add_Method('function IncMonth(ADate: TDateTime; ANumberOfMonth: Integer = 1): TDateTime', @Call_IncMonth);
  Add_Method('function IncWeek(ADate: TDateTime; ANumberOfWeek: Integer = 1): TDateTime', @Call_IncWeek);
  Add_Method('function IncYear(ADate: TDateTime; ANumberOfYear: Integer = 1): TDateTime', @Call_IncYear);
  Add_Method('function IncMinute(const AValue: TDateTime; ANumberOfMinutes: Int64 = 1): TDateTime', @Call_IncMinute);
  Add_Method('Function IncSecond(const AValue: TDateTime; ANumberOfSeconds: Int64 = 1): TDateTime', @Call_IncSecond);
  Add_Method('function IncMilliSecond(const AValue: TDateTime; const ANumberOfMilliSeconds: Int64 = 1): TDateTime', @Call_IncMilliSecond);
  Add_Method('function DaysBetween(const ANow, AThen: TDateTime): Integer', @Call_DaysBetween);
  Add_Method('function MonthsBetween(const ANow, AThen: TDateTime): Integer', @Call_MonthsBetween);
  Add_Method('function YearsBetween(const ANow, AThen: TDateTime): Integer', @Call_YearsBetween);
  Add_Method('function WeeksBetween(const ANow, AThen: TDateTime): Integer', @Call_WeeksBetween);
  Add_Method('function StartOfTheDay(const AValue: TDateTime): TDateTime', @Call_StartOfTheDay);
  Add_Method('function EndOfTheDay(const AValue: TDateTime): TDateTime', @Call_EndOfTheDay);
  Add_Method('function StartOfTheMonth(const AValue: TDateTime): TDateTime', @Call_StartOfTheMonth);
  Add_Method('function EndOfTheMonth(const AValue: TDateTime): TDateTime', @Call_EndOfTheMonth);
  Add_Method('function StartOfTheWeek(const AValue: TDateTime): TDateTime', @Call_StartOfTheWeek);
  Add_Method('function EndOfTheWeek(const AValue: TDateTime): TDateTime', @Call_EndOfTheWeek);
  Add_Method('function StartOfTheYear(const AValue: TDateTime): TDateTime', @Call_StartOfTheYear);
  Add_Method('function EndOfTheYear(const AValue: TDateTime): TDateTime', @Call_EndOfTheYear);
  Add_Method('function GetCurrentDir: string', @Call_GetCurrentDir);
  Add_Method('function GetUserDir: string', @Call_GetUserDir);
  Add_Method('function MonthOfTheYear(const AValue: TDateTime): Word', @Call_MonthOfTheYear);
  Add_Method('function DateTimeToUnix(D: TDateTime): Int64', @Call_DateTimeToUnix);
  Add_Method('function UnixToDateTime(U: Int64): TDateTime', @Call_UnixToDateTime);
  Add_Method('function CreateStrGUID: string', @Call_CreateStrGUID);
  Add_Method('function UniversalTimeToLocal(UT: TDateTime; TZOffset: Integer = 0): TDateTime', @Call_UniversalTimeToLocal);
  Add_Method('function LocalTimeToUniversal(LT: TDateTime; TZOffset: Integer = 0): TDateTime', @Call_LocalTimeToUniversal);
  Add_Method('function GetLocalTimeOffset: Integer', @Call_GetLocalTimeOffset);
  Add_Method('function DateToISO8601(const ADate: TDateTime; AInputIsUTC: Boolean = True): string', @Call_DateToISO8601);
  Add_Method('function ISO8601ToDate(const DateString: string; ReturnUTC : Boolean = True): TDateTime', @Call_ISO8601ToDate);
  Add_Method('function ScanDateTime(const Pattern:string;const s:string;startpos:integer=1): tdatetime', @Call_ScanDateTime);
  Add_Method('procedure SetTimeOffsetUTC(ValMinutes: Integer)', @Call_SetTimeOffsetUTC);

  Add_Method('function Length(S: string): Integer', @Call_Length);
  Add_Method('function AnsiStrLength(S: string): Integer', @Call_AnsiStrLength);
  Add_Method('function ArrayLength(A: Array): Integer', @Call_ArrayLength);
  Add_Method('function Copy(S: string; From, Count: Integer): string', @Call_Copy);
  Add_Method('function Pos(SubStr, Str: string): Integer', @Call_Pos);
  Add_Method('procedure Delete(var S: string; From, Count: Integer)', @Call_Delete);
  Add_Method('procedure Insert(s: String; var s2: String; pos: Integer)', @Call_Insert);
  Add_Method('function Uppercase(S: string): string', @Call_Uppercase);
  Add_Method('function Lowercase(S: string): string', @Call_Lowercase);

  Add_Method('function AnsiPos(SubStr, Str: ansistring): Integer', @Call_AnsiPos);
  Add_Method('procedure AnsiDelete(var S: ansistring; From, Count: Integer)', @Call_AnsiDelete);
  Add_Method('procedure AnsiInsert(s: ansistring; var s2: ansistring; pos: Integer)', @Call_AnsiInsert);
  Add_Method('function AnsiUppercase(S: ansistring): ansistring', @Call_AnsiUppercase);
  Add_Method('function AnsiLowercase(S: ansistring): ansistring', @Call_AnsiLowercase);

  Add_Method('function Trim(S: string): string', @Call_Trim);
  Add_Method('function NameCase(S: string): string', @Call_NameCase);
  Add_Method('function CompareText(s, s1: String): Integer', @Call_CompareText);
  Add_Method('function SameText(s, s1: String): Boolean', @Call_SameText);
  Add_Method('procedure SetLength(var S: string; NewLength: Integer)', @Call_SetLength);
  Add_Method('procedure SetArrayLength(var S: Variant; NewLength: Integer)', @Call_SetArrayLength);
  Add_Method('function LastDelimiter(const Delimiters, S: string): Integer', @Call_LastDelimiter);
  Add_Method('function IsDigit(const C: Char): Boolean', @Call_IsDigit);
  Add_Method('function IsLetter(const C: Char): Boolean', @Call_IsLetter);
  Add_Method('function IsSimbol(const C: Char): Boolean', @Call_IsSimbol);
  Add_Method('function IsNumericStr(S: string): Boolean', @Call_IsNumericStr);

  Add_Method('function Trunc(X: double): Integer', @Call_Trunc);
  Add_Method('function Int(X: Extended): Extended', @Call_Int);
  Add_Method('function Frac(X: Extended): Extended', @Call_Frac);
  Add_Method('function Sqrt(e: Extended): Extended', @Call_Sqrt);
  Add_Method('function Abs(X: Double): Integer', @Call_Abs);
  Add_Method('function Cos(X: Extended): Extended', @Call_Cos);
  Add_Method('function Sin(X: Extended): Extended', @Call_Sin);
  Add_Method('function ArcTan(X: Extended): Extended', @Call_ArcTan);
  Add_Method('function Tan(X: Extended): Extended', @Call_Tan);
  Add_Method('function Exp(X: Extended): Extended', @Call_Exp);
  Add_Method('function Ln(X: Extended): Extended', @Call_Ln);
  Add_Method('function Sqr(X: Double): Extended', @Call_Sqr);
  Add_Method('function Round(X: double): Int64', @Call_Round);
  Add_Method('function Ceil(X: double): Int64', @Call_Ceil);
  Add_Method('function RoundTo(const AValue: Extended; const ADigit: Integer): Extended', @Call_RoundTo);

  Add_Method('function VarIsEmpty(V: Variant): Boolean', @Call_VarIsEmpty);
  Add_Method('function VarIsClear(V: Variant): Boolean', @Call_VarIsClear);
  Add_Method('function VarIsNull(V: Variant): Boolean', @Call_VarIsNull);
  Add_Method('function VarType(V: Variant): Word', @Call_VarType);
  Add_Method('function VarArrayOf(A: array): Variant', @Call_VarArrayOf);
  Add_Method('function VarArrayCreate(const Bounds: array of Integer; AVarType: TVarType): Variant', @Call_VarArrayCreate);

  Add_Method('function FileExists(FileName: String): Boolean', @Call_FileExists);
  Add_Method('function DirectoryExists(Dirctory: String): Boolean', @Call_DirectoryExists);
  Add_Method('function ExtractFilePath(FileName: String): string', @Call_ExtractFilePath);
  Add_Method('function ExtractFileExt(FileName: String): string', @Call_ExtractFileExt);
  Add_Method('function ExtractFileDir(FileName: String): string', @Call_ExtractFileDir);
  Add_Method('function ExtractFileName(FileName: String): string', @Call_ExtractFileName);
  Add_Method('function ExtractFileDrive(FileName: String): string', @Call_ExtractFileDrive);
  Add_Method('function CreateDir(const Dir: String): Boolean', @Call_CreateDir);
  Add_Method('function DeleteFile(const AFile: String): Boolean', @Call_DeleteFile);
  Add_Method('function CopyFile(const SourceName, NewName: String; OverrideQuery: Boolean): Boolean', @Call_CopyFile);
  Add_Method('function RenameFile(const FileName, NewName: String): Boolean', @Call_RenameFile);
  Add_Method('function RemoveDir(const Dir: String): Boolean', @Call_RemoveDir);
  Add_Method('function FilenameToURL(const Filename: string): string', @Call_FilenameToURL);
  Add_Method('procedure GetDirList(const Path: string; SL: TStrings)', @Call_GetDirList);
  Add_Method('procedure GetFileList(const Path: string; const Mask: string; SL: TStrings)', @Call_GetFileList);
  Add_Method('function ReplaceFileExt(const FileName, NewExt: string): string', @Call_ReplaceFileExt);

  Add_Method('function Random: Extended', @Call_Random);
  Add_Method('function IRandom(X: Integer): Integer', @Call_IRandom);
  Add_Method('procedure Randomize', @Call_Randomize);

  Add_Method('procedure Inc(var I: Integer; ICnt: Integer = 1)', @Call_Inc);
  Add_Method('procedure Dec(var I: Integer; ICnt: Integer = 1)', @Call_Dec);
  Add_Method('procedure Sleep(dwMilliseconds: Cardinal)', @Call_Sleep);
  Add_Method('procedure ShowMessage(S: String)', @Call_ShowMessage);
  Add_Method('function Inputbox(const ACaption, APrompt, ADefautl: String): string', @Call_InputBox);
  Add_Method('procedure RaiseException(S: String)', @Call_RaiseException);
  Add_Method('function MessageBox(const Text, Caption: string; Flags: Integer): Integer', @Call_MessageBox);

  Add_Method('function CreateOleObject(S: String): IDispatch', @Call_CreateOleObject);
  Add_Method('function GetActiveOleObject(S: String): IDispatch', @Call_GetActiveOleObject);
  Add_Method('function Assigned(P: Pointer): Boolean', @Call_Assigned);
  Add_Method('function UTF8Decode(S: String): WideString', @Call_UTF8Decode);
  Add_Method('function UTF8Encode(S: WideString): String', @Call_UTF8Encode);
  Add_Method('function AnsiToUTF8(S: AnsiString): String', @Call_AnsiToUTF8);
  Add_Method('function UTF8ToAnsi(S: String): String', @Call_UTF8ToAnsi);
  Add_Method('function DOSCPToUTF8(const s: string): string', @Call_DOSCPToUTF8);
  Add_Method('function UTF8ToDOSCP(const s: string): string', @Call_UTF8ToDOSCP);
  Add_Method('function UTF8ToUCS2BE(const s: string): string', @Call_UTF8ToUCS2BE);
  Add_Method('function UTF8ToUCS2LE(const s: string): string', @Call_UTF8ToUCS2LE);
  Add_Method('function UCS2BEToUTF8(const s: string): string', @Call_UCS2BEToUTF8);
  Add_Method('function UCS2LEToUTF8(const s: string): string', @Call_UCS2LEToUTF8);
  Add_Method('function Ord(X: Ordinal): Integer', @Call_Ord);
  Add_Method('function Chr(B: Integer): string', @Call_Chr);
  Add_Method('function MD5String(S: string): string', @Call_MD5String);

  Add_Method('function ShellExecute(Handle: HWND; Operation: string; FileName: string; Parametrs: string; Directory: string; CmdShow: longint): THandle', @Call_ShellExecute);
  Add_Method('function FindDefaultBrowser(out ABrowser, AParams: String): Boolean', @Call_FindDefaultBrowser);
  Add_Method('function OpenURL(AURL: String): Boolean', @Call_OpenURL);
  Add_Method('function OpenDocument(APath: String): Boolean', @Call_OpenDocument);
  Add_Method('function GetTickCount: Cardinal', @Call_GetTickCount);
  Add_Method('function Rect(Left, Top, Right, Bottom: Integer): TRect', @Call_Rect);
  Add_Method('function Bounds(Left, Top, Wdith, Height: Integer): TRect', @Call_Bounds);

  Add_Method('procedure SetKeyboardLayot(AParam: string)', @Call_SetKeyboardLayot);
  Add_Method('procedure ActivateKeyboardLayot(HKL: THandle, Flags: Cardinal)', @Call_ActivateKeyboardLayot);
  Add_Method('function GetSystemMetrics(nIndex: Integer): Integer', @Call_GetSystemMetrics);
  Add_Method('function Unassigned: Variant', @Call_GetUnassigned);
  Add_Method('procedure SetFontQuality(fq: TFontQuality)', @Call_SetFontQuality);
  Add_Method('function GetOSVersion: string', @Call_GetOSVersion);
  Add_Method('function InstanceRunning(const Identifier: String; SendParameters: Boolean = False): Boolean', @Call_InstanceRunning);
  Add_Method('function ParamStr(AIndex: Integer): string', @Call_ParamStr);
  Add_Method('function ParamCount: Longint', @Call_ParamCount);
  Add_Method('function GetEnvironmentVariableCount : Integer', @Call_GetEnvironmentVariableCount);
  Add_Method('function GetEnvironmentString(Index : Integer): string', @Call_GetEnvironmentString);

  Add_Method('function RunCommandInDir(const curdir,cmdline: string; out outputstring: string): boolean', @Call_RunCommandInDir);
  Add_Method('function RunCommand(const cmdline: string; var outputstring: string):Boolean', @Call_RunCommand);

  Add_Method('function ParseURL(URL: string; var Prot, User, Pass, Host, Port, Path, Para: string): string', @Call_ParseURL);
  Add_Method('procedure GetMobileTel(S: string; SL: TSTrings; FirstNumber: string)', @Call_GetMobileTel);
  Add_Method('function GetMobilePhone(S: string; SL: TSTrings; FirstNumber, ControlNumber: string): Boolean', @Call_GetMobilePhone);

  Add_Method('процедура Сообщение(Стр: строка)', @Call_ShowMessage);
  Add_Method('функция ВвестиСтроку(конст аНадпись, аПодсказака, аПоУмолчанию: строка): строка', @Call_InputBox);
  Add_Method('процедура СоздатьИсключение(Сообщ: строка)', @Call_RaiseException);
  Add_Method('функция ОкноСообщения(конст Текст, Надпись: строка; Флаги: Целое): Целое', @Call_MessageBox);

  Add_Method('функция ЦелоеВСтроку(Ц: Целое64): строка', @Call_IntToStr);
  Add_Method('функция ДробноеВСтроку(Е: Расширенное): строка', @Call_FloatToStr);
  Add_Method('функция ДатаВСтроку(конст ДатаВремя: ТДатаВремя): строка', @Call_DateToStr);
  Add_Method('функция ВремяВСтроку(конст Дата: ТДатаВремя): строка', @Call_TimeToStr);
  Add_Method('функция ДатаВремяВСтроку(конст Дата: ТДатаВремя): строка', @Call_DateTimeToStr);
  Add_Method('функция ЛогическоеВСтроку(B: Логическое): строка', @Call_BoolToStr);
  Add_Method('функция ВариантВСтроку(Вр: Вариант): строка', @Call_VarToStr);
  Add_Method('функция СтрокуВЦелое(Стр: строка): Целое', @Call_StrToInt);
  Add_Method('функция СтрокуВЦелое64(Стр: строка): Целое64', @Call_StrToInt64);
  Add_Method('функция СтрокуВДробное(Стр: строка): Расширенное', @Call_StrToFloat);
  Add_Method('функция СтрокуВДату(Стр: строка; Формат: ТНастройкиФормата = nil): ТДатаВремя', @Call_StrToDate);
  Add_Method('функция СтрокуВоВремя(Стр: строка): ТДатаВремя', @Call_StrToTime);
  Add_Method('функция СтрокуВДатуВремя(Стр: строка; Формат: ТНастройкиФормата = nil): ТДатаВремя', @Call_StrToDateTime);
  Add_Method('функция СтрокуВЛогическое(Стр: строка): Логическое', @Call_StrToBool);


end;

function TMethods.Call_DateToISO8601(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := DateToISO8601(Params[0], Params[1]);
end;

function TMethods.Call_GetEnvironmentString(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := GetEnvironmentString(Params[0]);
end;

function TMethods.Call_GetEnvironmentVariableCount(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := GetEnvironmentVariableCount;
end;

function TMethods.Call_GetLocalTimeOffset(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := GetLocalTimeOffset;
end;

function TMethods.Call_ISO8601ToDate(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := ISO8601ToDate(Params[0], Params[1]);
end;

function TMethods.Call_LocalTimeToUniversal(Instance: TObject;
  var Params: Variant): Variant;
var
  D: TDateTime;
  TZOffset: Integer;
begin
  D := Params[0];
  TZOffset:= Params[1];
  if TZOffset = 0 then
    Result := LocalTimeToUniversal(D)
  else
    Result := LocalTimeToUniversal(D, TZOffset);
end;

function TMethods.Call_RunCommand(Instance: TObject; var Params: Variant
  ): Variant;
var
  CmdLine: TProcessString;
  OutString: string;
begin
  CmdLine:= Params[0];
  OutString:= Params[1];
  Result := RunCommand(CmdLine, OutString);
  Params[1] := OutString;
end;

function TMethods.Call_RunCommandInDir(Instance: TObject; var Params: Variant
  ): Variant;
var
  CurDir, CmdLine: TProcessString;
  outputstring: string;
begin
  CurDir := Params[0];
  CmdLine := Params[1];
  outputstring := Params[2];
  Result := RunCommandInDir(CurDir, CmdLine, outputstring);
  Params[2] := outputstring;
end;

function TMethods.Call_ScanDateTime(Instance: TObject; var Params: Variant
  ): Variant;
var
  Pattern, S: string;
  StartPos: Integer;
begin
  Pattern:= Params[0];
  S := Params[1];
  StartPos:= Params[2];
  Result := ScanDateTime(Pattern, S, StartPos);
end;

function TMethods.Call_SetTimeOffsetUTC(Instance: TObject; var Params: Variant
  ): Variant;
begin
  {$IFDEF LINUX}
  Tzseconds := Params[0];
  {$ENDIF}
end;

function TMethods.Call_UniversalTimeToLocal(Instance: TObject;
  var Params: Variant): Variant;
var
  D: TDateTime;
  TZOffset: Integer;
begin
  D := Params[0];
  TZOffset:= Params[1];
  if TZOffset = 0 then
    Result := UniversalTimeToLocal(D)
  else
    Result := UniversalTimeToLocal(D, TZOffset);
end;

function TMethods.Call_ShowMessage(Instance: TObject;
   var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  ShowMessage(S);
end;

function TMethods.Call_InputBox(Instance: TObject; var Params: Variant): Variant;
begin
  Result := InputBox(Params[0], Params[1], Params[2]);
end;

function TMethods.Call_RaiseException(Instance: TObject;
   var Params: Variant): Variant;
begin
  raise Exception.Create(Params[0]);
end;

function TMethods.Call_MessageBox(Instance: TObject; var Params: Variant
  ): Variant;
var
  Txt, Capt: string;
begin
  Txt := Params[0]; Capt := Params[1];
  Result := Application.MessageBox(PChar(Txt), PChar(Capt), Params[2]);
end;

function TMethods.Call_StrToInt(Instance: TObject;
   var Params: Variant): Variant;
begin
  Result := StrToInt(Params[0]);
end;

function TMethods.Call_StrToInt64(Instance: TObject; var Params: Variant
  ): Variant;
var
  Res: Int64;
begin
  Res := Params[0];
  Result := Res;
end;

function TMethods.Call_IntToStr(Instance: TObject;
   var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := S;
end;

function TMethods.Call_StrToFloat(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
  I: Integer;
begin
  S := Params[0];
  I := LastDelimiter(',.', S);
  if I > 0 then S[I] := FormatSettings.DecimalSeparator;
  Result := StrToFloat(S);
end;

function TMethods.Call_FloatToStr(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := S;
end;


function TMethods.Call_CreateOleObject(Instance: TObject;
   var Params: Variant): Variant;
begin
  {$IFDEF WINDOWS}
  Result := CreateOleObject(Params[0]);
  {$ELSE}
    Result := Unassigned;
  {$ENDIF}
end;

function TMethods.Call_GetActiveOleObject(Instance: TObject; var Params: Variant
  ): Variant;
begin
  {$IFDEF WINDOWS}
  Result := GetActiveOleObject(Params[0]);
  {$ELSE}
    Result := Unassigned;
  {$ENDIF}
end;


function TMethods.Call_FileExists(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := FileExists(Params[0]);
end;

function TMethods.Call_DirectoryExists(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := DirectoryExists(Params[0]);
end;

function TMethods.Call_ExtractFilePath(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := ExtractFilePath(Params[0]);
end;

function TMethods.Call_ExtractFileName(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := ExtractFileName(Params[0])
end;

function TMethods.Call_ExtractFileExt(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := ExtractFileExt(Params[0]);
end;

function TMethods.Call_ExtractFileDir(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := ExtractFileDir(Params[0])
end;

function TMethods.Call_ExtractFileDrive(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := ExtractFileDrive(Params[0])
end;

function TMethods.Call_CreateDir(Instance: TObject; var Params: Variant): Variant;
begin
  Result := CreateDir(Params[0]);
end;

function TMethods.Call_DeleteFile(Instance: TObject; var Params: Variant): Variant;
begin
  Result := SysUtils.DeleteFile(Params[0]);
end;

function TMethods.Call_CopyFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  SourceStram, DestStream: TFileStream;
  S, SourceFile, DestFile: string;
  OverrideQuery: Boolean;
begin
  Result := False;
  SourceFile := Params[0];
  DestFile := Params[1];
  OverrideQuery := Params[2];

  if (SourceFile = '') or (DestFile = '') then Exit;
  if not FileExists(SourceFile) then
  begin
    S := 'Файл ' + SourceFile + ' не найден';
    Exception.Create(S);
  end;

  if OverrideQuery then
  begin
    if FileExists(DestFile) then
    begin
      S := 'Файл ' + DestFile + ' существует, перезаписать?';
      if Application.MessageBox(PChar(S), 'Копирование файла', MB_YESNO or MB_ICONQUESTION) = IDNO then
      begin
        Application.MessageBox('Операция отменена', 'Копирование файла', MB_OK or MB_ICONINFORMATION);
        Exit;
      end;
    end;
  end;

  SourceStram := TFileStream.Create(SourceFile, fmOpenRead);
  DestStream := TFileStream.Create(DestFile, fmCreate);
  try
    DestStream.CopyFrom(SourceStram, SourceStram.Size);
  finally
    DestStream.Free;
    SourceStram.Free;
  end;

  Result := True;
end;

function TMethods.Call_RenameFile(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := RenameFile(Params[0], Params[1]);
end;

function TMethods.Call_RemoveDir(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := RemoveDir(Params[0]);
end;

function TMethods.Call_FilenameToURL(Instance: TObject; var Params: Variant
  ): Variant;
var
    i: Integer;
    ResultStr: string;
begin
  ResultStr := Params[0];
  {$warnings off}
    if PathDelim<>'/' then
      for i:=1 to length(ResultStr) do
        if ResultStr[i]=PathDelim then
          ResultStr[i]:='/';
  {$warnings on}
  if ResultStr<>'' then
      ResultStr:='file:///'+ResultStr;
  Result := ResultStr;
end;

function TMethods.Call_ReplaceFileExt(Instance: TObject; var Params: Variant
  ): Variant;
var
  AFileName: string;
  NewExt: string;
  I, L: Integer;
begin
  AFileName := Params[0];
  NewExt := Params[1];
  I := LastDelimiter('.', AFileName);
  if I > 0 then
  begin
    L := Length(AFileName);
    Delete(AFileName, I, L - I + 1);
  end;
  Result := AFileName;
  if (NewExt <> '') and (NewExt <> '.') then
  begin
    if NewExt[1] = '.' then
      Result := AFileName + NewExt
    else
      Result := AFileName + '.' + NewExt;
  end;
end;

function TMethods.Call_GetDirList(Instance: TObject; var Params: Variant): Variant;
var
  SR: TSearchRec;
  FindStr, Path: string;
  SL: TStrings;
begin
  Path := Params[0] + DirectorySeparator;
  SL := TStrings(TSuPtr(Params[1]));
  FindStr := Path + DirectorySeparator + '*';
  if SysUtils.FindFirst(FindStr, faDirectory, SR) = 0 then
  begin
    repeat
      if (SR.Attr and faDirectory) > 0 then
      begin
        if (SR.Name <> '.') and (SR.Name <> '..') then  SL.Append(SR.Name);
      end;
    until SysUtils.FindNext(SR) <> 0;
    SysUtils.FindClose(SR);
  end;
end;

function TMethods.Call_GetFileList(Instance: TObject; var Params: Variant): Variant;
var
  SR: TSearchRec;
  FindStr, Mask, Path: string;
  SL: TStrings;
begin
  Path := Params[0];
  Mask := Params[1];
  SL := TStrings(TSuPtr(Params[2]));
  if Mask = '' then Exit;
  FindStr := Path + DirectorySeparator + Mask;
  if SysUtils.FindFirst(FindStr, faAnyFile, SR) = 0 then
  begin
    repeat
      //if SR.Attr <> faDirectory then SL.Append(SR.Name);
      if (SR.Attr and faDirectory) = 0 then SL.Append(SR.Name);
    until SysUtils.FindNext(SR) <> 0;
    SysUtils.FindClose(SR);
  end;
end;

function TMethods.Call_Random(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Random;
end;

function TMethods.Call_IRandom(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Random(Params[0]);
end;

function TMethods.Call_Randomize(Instance: TObject; var Params: Variant): Variant;
begin
  Randomize;
end;

function TMethods.Call_VarIsEmpty(Instance: TObject; var Params: Variant): Variant;
begin
  Result := VarIsEmpty(Params[0])
end;

function TMethods.Call_VarIsClear(Instance: TObject; var Params: Variant): Variant;
begin
  Result := VarIsClear(Params[0])
end;

function TMethods.Call_VarIsNull(Instance: TObject; var Params: Variant): Variant;
begin
  Result := VarIsNull(Params[0])
end;

function TMethods.Call_VarType(Instance: TObject; var Params: Variant): Variant;
begin
  Result := VarType(Params[0]);
end;

function TMethods.Call_Trunc(Instance: TObject; var Params: Variant): Variant;
var
  X: Extended;
begin
  X := Params[0];
  Result := Trunc(X);
end;

function TMethods.Call_Round(Instance: TObject; var Params: Variant): Variant;
var
  X: Extended;
begin
  X := Params[0];
  Result := Round(X);
end;

function TMethods.Call_RoundTo(Instance: TObject; var Params: Variant): Variant;
var
  E: Extended;
begin
  E := Params[0];
  Result := RoundTo(E, Params[1]);
end;

function TMethods.Call_Ceil(Instance: TObject; var Params: Variant): Variant;
var
  X: Extended;
begin
  X := Params[0];
  Result := ceil64(X);
end;

function  TMethods.Call_Assigned(Instance: TObject; var Params: Variant): Variant;
var
  M: TMethod;
  IO: TIdentObject;
begin
  Result := False;
  IO := TIdentObject(TSuPtr(Params[0]));
  if IO <> nil then
  begin
    Result := True;
    if IO is TAdresExpression then
    begin
      Result := TAdresExpression(IO).AssignedValue;
    end
    else
    if IO is TClassPropObject then
    begin
      if TClassPropObject(IO).Prop^.PropType^.Kind = tkMethod then
      begin
        M := GetMethodProp(TObject(TSuPtr(TClassPropObject(IO).Val.Value)), TClassPropObject(IO).Prop);
        Result := M.Code <> nil;
      end;
    end;
  end;
end;

function TMethods.Call_Rect(Instance: TObject; var Params: Variant): Variant;
begin
  R.Left := Params[0];
  R.Top := Params[1];
  R.Right := Params[2];
  R.Bottom := Params[3];
  Result := TSuPtr(@R);
end;

function TMethods.Call_Bounds(Instance: TObject; var Params: Variant): Variant;
begin
  R := Bounds(Params[0], Params[1], Params[2], Params[3]);
  Result := TSuPtr(@R);
end;

function TMethods.Call_UTF8Decode(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
  US: UnicodeString;
begin
  S := Params[0];
  US := UTF8Decode(S);
  Result := US;
end;

function TMethods.Call_UTF8Encode(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: UnicodeString;
begin
  S := Params[0];
  Result := UTF8Encode(S);
end;

function TMethods.Call_AnsiToUTF8(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: AnsiString;
begin
  S := Params[0];
  Result := dp_AnsiToUTF8(S);
end;

function TMethods.Call_UTF8ToAnsi(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := dp_UTF8ToAnsi(S);
end;

function TMethods.Call_DOSCPToUTF8(Instance: TObject; var Params: Variant
  ): Variant;

begin
  Result := dp_DOSCPToUTF8(Params[0]);
end;

function TMethods.Call_UTF8ToDOSCP(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := dp_UTF8ToDOSCP(Params[0]);
end;

function TMethods.Call_UTF8ToUCS2BE(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := UTF8ToUCS2BE(S);
end;

function TMethods.Call_UTF8ToUCS2LE(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := UTF8ToUCS2LE(S);
end;

function TMethods.Call_UCS2LEToUTF8(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := UCS2LEToUTF8(S);
end;

function TMethods.Call_UCS2BEToUTF8(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := UCS2BEToUTF8(S);
end;

type EVarOrd = class(Exception);

function VarOrd(var Param:Variant):Integer;
var ii:Integer; si:SmallInt; ih:ShortInt; bt:Byte; wd:Word; lw:LongWord;
var qi:Int64; qw:QWord; bl:Boolean; er:LongInt; s:String;
begin
  case VarType(Param) of
    varSmallInt : begin si:=Param; Result:=Ord(si); end;
    varInteger  : begin ii:=Param; Result:=Ord(ii); end;
    varShortInt : begin ih:=Param; Result:=Ord(ih); end;
    varError    : begin er:=Param; Result:=Ord(er); end;
    varByte     : begin bt:=Param; Result:=Ord(bt); end;
    varWord     : begin wd:=Param; Result:=Ord(wd); end;
    varLongWord : begin lw:=Param; Result:=Ord(lw); end;
    varInt64    : begin qi:=Param; Result:=Ord(qi); end;
    varQWord    : begin qw:=Param; Result:=Ord(qw); end;
    varBoolean  : begin bl:=Param; Result:=Ord(bl); end;
    varOleStr,
    varString,
    varUString:   begin
                   S:=Param;
                   if (S='') then Result:=Ord(#0) else begin
                    if (FindInvalidUTF8Character(PChar(S), Length(S))=-1) then S:=dp_UTF8ToAnsi(S);
                    if (S='') then Result:=Ord(#0) else Result:=Ord(S[1]);
                   end;
                  end;
    else          raise EVarOrd.CreateFmt('Invalid OrdVar type %d.',[VarType(Param)]);
  end;
end;

function TMethods.Call_Ord(Instance: TObject; var Params: Variant): Variant;
begin
  Result := VarOrd(Params[0]);
end;

function TMethods.Call_Chr(Instance: TObject; var Params: Variant): Variant;
var
  I: Integer;
  C: Char;
  S: string;
begin
  I := Params[0];
  C := chr(I);
  S := C;
  Result := dp_AnsiToUTF8(S);
end;

function TMethods.Call_MD5String(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := MD5Print(MD5String(S));
end;

function TMethods.Call_ShellExecute(Instance: TObject; var Params: Variant
  ): Variant;
var
  LI: PtrUInt;
  H: THandle;
  Operation: string;
  FileName: string;
  Parameters: string;
  Directory: string;
  L6: LongInt;
{$IfNDef WINDOWS}
  P: TProcess;
{$EndIf}
begin
  LI := Params[0];
  H := LI;
  Operation := Params[1];
  FileName := Params[2];
  Parameters := Params[3];
  Directory := Params[4];
  L6 := Params[5];
  {$IfDef WINDOWS}
    Operation := Operation;
    FileName := FileName;
    Parameters := Parameters;
    Directory := Directory;
    Result := ShellExecute(H, PChar(Operation), PChar(FileName), PChar(Parameters), PChar(Directory), L6);
  {$Else}
    Result := 0;
    P := TProcess.Create(nil);
    try
      P.ShowWindow := swoShowNormal;
      case L6 of
        SW_SHOW: P.ShowWindow := swoShow;
        SW_MINIMIZE: P.ShowWindow:= swoMinimize;
        SW_SHOWMAXIMIZED: P.ShowWindow := swoShowMaximized;
        SW_SHOWMINIMIZED: P.ShowWindow := swoShowMinimized;
        SW_SHOWDEFAULT: P.ShowWindow := swoShowDefault;
        SW_SHOWNOACTIVATE: P.ShowWindow:= swoShowNoActivate;
        SW_HIDE: P.ShowWindow:= swoHIDE;
        SW_RESTORE: P.ShowWindow := swoRestore;
        SW_SHOWNA: P.ShowWindow:= swoShowNA;
        SW_SHOWMINNOACTIVE: P.ShowWindow:= swoshowMinNOActive;
      end;
      P.Options := [];
      P.StartupOptions:=[suoUseShowWindow];
      P.CurrentDirectory:= Directory;
      if Parameters <> '' then FileName := FileName + ' ' + Parameters;
      P.CommandLine := FileName;
      P.Execute;
    finally
      P.Free;
    end;
  {$EndIf}
end;

function TMethods.Call_FindDefaultBrowser(Instance: TObject; var Params: Variant
  ): Variant;
var
  ABrowser, AParams: string;
begin
  ABrowser := Params[0];
  AParams := Params[1];
  Result := FindDefaultBrowser(ABrowser, AParams);
  Params[0] := ABrowser;
  Params[1] := AParams;
end;

function TMethods.Call_OpenURL(Instance: TObject; var Params: Variant): Variant;
begin
  Result := OpenURL(Params[0]);
end;

function TMethods.Call_OpenDocument(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := OpenDocument(Params[0]);
end;

function TMethods.Call_GetTickCount(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := GetTickCount;
end;

function TMethods.Call_SetKeyboardLayot(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  {$IFDEF WINDOWS}
    L: THandle;
  {$ENDIF}

  {
  {$IFDEF UNIX}
    P: TProcess;
  {$ENDIF}
  }

begin
  S := Params[0];
  S := LowerCase(S);
  {$IFDEF WINDOWS}
    L := 0;
    if SameText(S, 'ru') then
      L := 68748313
    else
    if SameText(S, 'en') then
      L := 67699721;
    if L <> 0 then
      ActivateKeyboardLayout(L, 0);

  {$ELSE}
     {
     {$IFDEF UNIX}
      P := TProcess.Create(nil);
      try
        //P.CommandLine := 'setxkbmap -layout ''ru,us'' -option ''grp:alt_shift_toggle''';

        if S = 'ru' then
          P.CommandLine := 'setxkbmap -layout "ru,us"'
        else
          P.CommandLine := 'setxkbmap -layout "us,ru"';

        P.Options := P.Options + [poWaitOnExit];
        P.Execute;
      finally
        P.Free;
      end;
     {$ENDIF}
     }
  {$ENDIF}
end;

function TMethods.Call_ActivateKeyboardLayot(Instance: TObject;
  var Params: Variant): Variant;
var
  HKL: THandle;
  Flags: Cardinal;
begin
  {$IFDEF WINDOWS}
    HKL := Params[0];
    Flags := Params[1];
    ActivateKeyboardLayout(HKL, Flags);
  {$ENDIF}
end;

function TMethods.Call_GetSystemMetrics(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := GetSystemMetrics(Params[0]);
end;

function TMethods.Call_GetUnassigned(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := Unassigned;
end;

function TMethods.Call_SetFontQuality(Instance: TObject; var Params: Variant
  ): Variant;
begin
  DefFontData.Quality := Params[0];
  Screen.HintFont.Quality:= Params[0];
end;

{$IFDEF WINDOWS}
function TMethods.Call_GetOSVersion(Instance: TObject; var Params: Variant
  ): Variant;
var
  Vers: TOSVERSIONINFO;
begin
  Result := 'Windows';
  Vers.dwOSVersionInfoSize := sizeof(TOSVersionInfo);
  if GetVersionEx(@Vers) then
  begin
    Result := 'Windows-' + IntToStr(Vers.DwMajorVersion) + '-' + IntToStr(Vers.dwMinorVersion);
  end;
end;
{$ELSE}
function TMethods.Call_GetOSVersion(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := 'Unix';
end;

{$ENDIF}

function TMethods.Call_InstanceRunning(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := InstanceRunning(Params[0]);
end;

function TMethods.Call_ParamStr(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := ParamStrUTF8(Params[0]);
end;

function TMethods.Call_ParamCount(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := Paramcount;
end;

function TMethods.Call_ParseURL(Instance: TObject; var Params: Variant
  ): Variant;
var
  URL, Prot, User, Pass, Host, Port, Path, Para: string;
begin
  URL:= Params[0];
  Prot := Params[1];
  User := Params[2];
  Pass := Params[3];
  Host := Params[4];
  Port := Params[5];
  Path := Params[6];
  Para := Params[7];
  Result := ParseURL(URL, Prot, User, Pass, Host, Port, Path, Para);
  Params[1] := Prot;
  Params[2] := User;
  Params[3] := Pass;
  Params[4] := Host;
  Params[5] := Port;
  Params[6] := Path;
  Params[7] := Para;
end;

function TMethods.Call_GetMobileTel(Instance: TObject; var Params: Variant
  ): Variant;
var
  S, OriginS, FirstNumber: string;
  SL: TStrings;
  TelNumber: string;
  L, I, LL: Integer;

  procedure CheckNumber(ANum: string);
  var
    N: Integer;
    ResNum: string;
  begin
    N := Length(ANum);
    ResNum := '';
    if N = 10 then
    begin
      if ANum[1] = '9' then
      begin
        ResNum := FirstNumber[1] + ANum;
        SL.Append(ResNum);
      end;
    end
    else
    if N = 11 then
    begin
      if ANum[2] = '9' then
      begin
        ResNum := ANum;
        ResNum[1] := FirstNumber[1];
        SL.Append(ResNum);
      end;
    end;
  end;

begin
  OriginS := Params[0];
  SL := TStrings(TSuPtr(Params[1]));
  FirstNumber := Params[2];
  S := dp_UTF8ToAnsi(Trim(OriginS));
  L := Length(S);
  TelNumber := '';
  for I := 1 to L do
  begin
    if S[I] in ['0'..'9'] then
      TelNumber := TelNumber + S[I]
    else
    if (S[I] = ' ') then
    begin
      if (I < L) and (S[I + 1] = ' ') then
      begin
        if TelNumber <> '' then
        begin
          CheckNumber(TelNumber);
          TelNumber := '';
        end;
      end
      else
      begin
        LL := Length(TelNumber);
        if L in [10, 11] then
        begin
          CheckNumber(TelNumber);
          TelNumber := '';
        end;
      end;
    end
    else
    if (S[I] = ',') or (S[I] = ';') then
    begin
      CheckNumber(TelNumber);
      TelNumber := '';
    end;

  end;
  CheckNumber(TelNumber);
end;

//function TMethods.Call_GetMobilePhone(Instance: TObject; var Params: Variant
//  ): Variant;
//var
//  S, OriginS, FirstNumber, ControlNumber: string;
//  SL: TStrings;
//  TelNumber: string;
//  L, I, LL: Integer;
//
//  procedure CheckNumber(ANum: string);
//  var
//    N: Integer;
//    ResNum: string;
//  begin
//    N := Length(ANum);
//    ResNum := '';
//    if N = 10 then
//    begin
//      if ANum[1] = ControlNumber[1] then
//      begin
//        ResNum := FirstNumber + ANum;
//        SL.Append(ResNum);
//      end;
//    end
//    else
//    if N = 11 then
//    begin
//      if ANum[2] = ControlNumber[1] then
//      begin
//        ResNum := ANum;
//        if FirstNumber <> '' then
//        begin
//          Delete(ResNum, 1, 1);
//          ResNum := FirstNumber + ResNum;
//        end;
//        SL.Append(ResNum);
//      end;
//    end;
//  end;
//begin
//  Result := False;
//  OriginS := Params[0];
//  SL := TStrings(TSuPtr(Params[1]));
//  FirstNumber := Params[2];
//  ControlNumber := Params[3];
//  if ControlNumber = '' then Exit;
//  S := dp_UTF8ToAnsi(Trim(OriginS));
//  L := Length(S);
//  TelNumber := '';
//  for I := 1 to L do
//  begin
//    if S[I] in ['0'..'9'] then
//      TelNumber := TelNumber + S[I]
//    else
//    if (S[I] = ' ') then
//    begin
//      if (I < L) and (S[I] = ' ') then
//      begin
//        if TelNumber <> '' then
//        begin
//          CheckNumber(TelNumber);
//          TelNumber := '';
//        end;
//      end
//      else
//      begin
//        LL := Length(TelNumber);
//        if L in [10, 11] then
//        begin
//          CheckNumber(TelNumber);
//          TelNumber := '';
//        end;
//      end;
//    end
//    else
//    if (S[I] = ',') or (S[I] = ';') then
//    begin
//      CheckNumber(TelNumber);
//      TelNumber := '';
//    end;
//
//  end;
//  CheckNumber(TelNumber);
//  Result := True;
//end;

function TMethods.Call_GetMobilePhone(Instance: TObject; var Params: Variant
  ): Variant;
var
  S, OriginS, FirstNumber, ControlNumber: string;
  SL: TStrings;
  TelNumber: string;
  L, I, LL: Integer;

  procedure CheckNumber(ANum: string);
  var
    N: Integer;
    ResNum: string;
  begin
    N := Length(ANum);
    ResNum := '';
    if N = 10 then
    begin
      if ANum[1] = ControlNumber[1] then
      begin
        ResNum := FirstNumber + ANum;
        SL.Append(ResNum);
      end;
    end
    else
    if N = 11 then
    begin
      if ANum[2] = ControlNumber[1] then
      begin
        ResNum := ANum;
        Delete(ResNum, 1, 1);
        if FirstNumber <> '' then
          ResNum := FirstNumber + ResNum;
        SL.Append(ResNum);
      end;
    end;
  end;
begin
  Result := False;
  OriginS := Params[0];
  SL := TStrings(TSuPtr(Params[1]));
  FirstNumber := Params[2];
  ControlNumber := Params[3];
  if ControlNumber = '' then Exit;
  S := dp_UTF8ToAnsi(Trim(OriginS));
  L := Length(S);
  TelNumber := '';
  for I := 1 to L do
  begin
    if S[I] in ['0'..'9'] then
    begin
      TelNumber := TelNumber + S[I];
    end
    else
    if S[I] in [' ', ',', ';', '+'] then
    begin
      if TelNumber <> '' then CheckNumber(TelNumber);
      TelNumber :=  '';
    end;
  end;
  if TelNumber <> '' then CheckNumber(TelNumber);
  Result := True;
end;

function TMethods.Call_Cos(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Cos(Params[0]);
end;

function TMethods.Call_Sin(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Sin(Params[0]);
end;

function TMethods.Call_Abs(Instance: TObject; var Params: Variant): Variant;
var
  V: ValReal;
begin
  V := Params[0];
  Result := Abs(V);
end;

function TMethods.Call_Sqr(Instance: TObject; var Params: Variant): Variant;
var
  V: ValReal;
begin
  V := Params[0];
  Result := Sqr(V)
end;

function TMethods.Call_DateToStr(Instance: TObject; var Params: Variant): Variant;
begin
  Result := DateToStr(Params[0]);
end;

function TMethods.Call_TimeToStr(Instance: TObject; var Params: Variant): Variant;
begin
  Result := TimeToStr(Params[0]);
end;

function TMethods.Call_DateTimeToStr(Instance: TObject; var Params: Variant): Variant;
begin
  Result := DateTimeToStr(Params[0]);
end;

function TMethods.Call_BoolToStr(Instance: TObject; var Params: Variant): Variant;
begin
  Result := BoolToStr(Params[0]);
end;

function TMethods.Call_VarToStr(Instance: TObject; var Params: Variant): Variant;
begin
  Result := VarToStr(Params[0]);
end;

function TMethods.Call_StrToDate(Instance: TObject; var Params: Variant): Variant;
var
  F: TFormatSet;
  S: string;
begin
  S := Params[0];
  F := TFormatSet(TSuPtr(Params[1]));
  if F = nil then
    Result := StrToDate(S)
  else
    Result := StrToDate(S, F.F);
end;

function TMethods.Call_StrToTime(Instance: TObject; var Params: Variant): Variant;
var
  F: TFormatSet;
  S: string;
begin
  S := Params[0];
  F := TFormatSet(TSuPtr(Params[1]));
  if F = nil then
    Result := StrToTime(S)
  else
    Result := StrToTime(S, F.F);
end;

function TMethods.Call_StrToDateTime(Instance: TObject; var Params: Variant): Variant;
var
  F: TFormatSet;
  S: string;
begin
  S := Params[0];
  F := TFormatSet(TSuPtr(Params[1]));
  if F = nil then
    Result := StrToDateTime(S)
  else
    Result := StrToDateTime(S, F.F);
end;

function TMethods.Call_StrToBool(Instance: TObject; var Params: Variant): Variant;
begin
  Result := StrToBool(Params[0]);
end;

function TMethods.Call_StrToCurr(Instance: TObject; var Params: Variant
  ): Variant;
var
  C: Currency;
begin
  C := Params[0];
  Result := C;
end;

function TMethods.Call_CurrToStr(Instance: TObject; var Params: Variant
  ): Variant;
var
  C: Currency;
begin
  C := Params[0];
  Result := CurrToStr(C);
end;

function TMethods.Call_RemoveChar(Instance: TObject; var Params: Variant
  ): Variant;
var
  S, CS: string;
  C: Char;
  L, I, N: Integer;
begin
  S := Params[0];
  CS := Params[1];
  if CS = '' then Exit;
  if S = '' then Exit;

  I := UTF8Pos(CS, S);
  N := UTF8Length(CS);
  while I > 0 do
  begin
    UTF8Delete(S, I, N);
    I := UTF8Pos(CS, S);
  end;
  Params[0] := S;
end;

function TMethods.UnpackFIO(Instance: TObject; var Params: Variant): Variant;
var
  Fam, Imja, Otch, S: string;
  P, EndP, PP: PChar;
  I, L, N, StartN, SpaceCount: Integer;
begin
  S := Params[0];
  L := Length(S);
  SetLength(S, L + 1);
  S[L + 1] := #0;
  SpaceCount := 1;
  Fam := '';
  Imja := '';
  Otch := '';
  if L > 0 then
  begin
    P := @S[1];
    N := 1;
    StartN := N;
    while P^ <> #0 do
    begin
      if P^ = ' ' then
      begin
        case SpaceCount of
          1: Fam := UTF8Copy(S, StartN, N - StartN);
          2: Imja := UTF8Copy(S, StartN, N - StartN);
          3: Otch := UTF8Copy(S, StartN, N - StartN);
          else
            Break;
        end;
        Inc(SpaceCount, 1);
        if SpaceCount > 3 then Break;
        PP := P;
        while PP^ = ' ' do
        begin
          I := UTF8CharacterLength(PP);
          Inc(PP, I);
          Inc(N, 1);
        end;
        P := PP;
        StartN := N;
      end
      else
      begin
        I := UTF8CharacterLength(P);
        Inc(P, I);
        Inc(N, 1);
      end;
    end;
  end;
  if N <> StartN then
    case SpaceCount of
      1: Fam := UTF8Copy(S, StartN, N - StartN);
      2: Imja := UTF8Copy(S, StartN, N - StartN);
      3: Otch := UTF8Copy(S, StartN, N - StartN);
    end;

  Params[1] := Fam;
  Params[2] := Imja;
  Params[3] := Otch;
end;

function TMethods.IntString(Instance: TObject; var Params: Variant): Variant;
var
  StrTemplate: string;
  AValue: Integer;
  L1, L2: Integer;
begin
  StrTemplate:= Params[0];
  AValue := Params[1];
  Result := IntToStr(AValue);
  L1 := Length(Result);
  L2 := Length(StrTemplate);
  if L1 < L2 then
  begin
    Result := Copy(StrTemplate, 1, L2 - L1) + Result;
  end;
end;

function TMethods.Call_FormatDateTime(Instance: TObject; var Params: Variant): Variant;
begin
  Result := FormatDateTime(Params[0], Params[1]);
end;

function TMethods.Call_FormatFloat(Instance: TObject; var Params: Variant): Variant;
begin
  Result := FormatFloat(Params[0], Params[1]);
end;

function TMethods.Call_FormatMaskText(Instance: TObject; var Params: Variant): Variant;
begin
  Result := FormatMaskText(Params[0], Params[1]);
end;

function TMethods.Call_EncodeDate(Instance: TObject; var Params: Variant): Variant;
begin
  Result := EncodeDate(Params[0], Params[1], Params[2]);
end;

function TMethods.Call_DecodeDate(Instance: TObject; var Params: Variant): Variant;
var
  Yr, Mn, Dy: Word;
begin
  DecodeDate(Params[0], Yr, Mn, Dy);
  Params[1] := Yr;
  Params[2] := Mn;
  Params[3] := Dy;
end;

function TMethods.Call_EncodeTime(Instance: TObject; var Params: Variant): Variant;
begin
  Result := EncodeTime(Params[0], Params[1], Params[2], Params[3]);
end;

function TMethods.Call_DecodeTime(Instance: TObject; var Params: Variant): Variant;
var
  Hr, Mn, Sc, Msc: Word;
begin
  DecodeTime(Params[0], Hr, Mn, Sc, Msc);
  Params[1] := Hr;
  Params[2] := Mn;
  Params[3] := Sc;
  Params[4] := Msc;
end;

function TMethods.Call_Date(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Date;
end;

function TMethods.Call_Time(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Time;
end;

function TMethods.Call_Now(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Now;
end;

function TMethods.Call_DayOfWeek(Instance: TObject; var Params: Variant): Variant;
begin
  Result := DayOfWeek(Params[0]);
end;

function TMethods.Call_IsLeapYear(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := IsLeapYear(Params[0]);
end;

function TMethods.Call_DaysInMonth(Instance: TObject;
  var Params: Variant): Variant;
var
  D: TDateTime;
begin
  D := Params[0];
  Result := DaysInMonth(D);
end;

function TMethods.Call_IncDay(Instance: TObject; var Params: Variant): Variant;
begin
  Result := IncDay(Params[0], Params[1]);
end;

function TMethods.Call_IncMonth(Instance: TObject; var Params: Variant): Variant;
begin
  Result := IncMonth(Params[0], Params[1]);
end;

function TMethods.Call_IncWeek(Instance: TObject; var Params: Variant): Variant;
begin
  Result := IncWeek(Params[0], Params[1]);
end;

function TMethods.Call_IncYear(Instance: TObject; var Params: Variant): Variant;
begin
  Result := IncYear(Params[0], Params[1]);
end;

function TMethods.Call_IncMinute(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := IncMinute(Params[0], Params[1]);
end;

function TMethods.Call_IncSecond(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := IncSecond(Params[0], Params[1]);
end;

function TMethods.Call_IncMilliSecond(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := IncMilliSecond(Params[0], Params[1]);
end;

function  TMethods.Call_DaysBetween(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := DaysBetween(Params[0], Params[1]);
end;

function TMethods.Call_MonthsBetween(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := MonthsBetween(Params[0], Params[1])
end;

function TMethods.Call_YearsBetween(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := YearsBetween(Params[0], Params[1])
end;

function TMethods.Call_WeeksBetween(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := WeeksBetween(Params[0], Params[1])
end;

function TMethods.Call_StartOfTheDay(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := StartOfTheDay(Params[0])
end;

function TMethods.Call_EndOfTheDay(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := EndOfTheDay(Params[0])
end;

function TMethods.Call_StartOfTheMonth(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := StartOfTheMonth(Params[0])
end;

function TMethods.Call_EndOfTheMonth(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := EndOfTheMonth(Params[0])
end;

function TMethods.Call_StartOfTheWeek(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := StartOfTheWeek(Params[0])
end;

function TMethods.Call_EndOfTheWeek(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := EndOfTheWeek(Params[0])
end;

function TMethods.Call_StartOfTheYear(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := StartOfTheYear(Params[0])
end;

function TMethods.Call_EndOfTheYear(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := EndOfTheYear(Params[0]);
end;

function TMethods.Call_GetCurrentDir(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := GetCurrentDir;
end;

function TMethods.Call_GetUserDir(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := GetUserDir;
end;

function TMethods.Call_MonthOfTheYear(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := MonthOfTheYear(Params[0]);
end;

function TMethods.Call_DateTimeToUnix(Instance: TObject; var Params: Variant
  ): Variant;
var
  D: TDateTime;
begin
  D := Params[0];
  Result := Round((D - 25569) * 86400);
end;

function TMethods.Call_UnixToDateTime(Instance: TObject; var Params: Variant
  ): Variant;
var
  U: Int64;
  D: TDateTime;
begin
  U := Params[0];
  D := U / 86400 + 25569;
  Result := D;
end;

function TMethods.Call_CreateStrGUID(Instance: TObject; var Params: Variant
  ): Variant;
var
  GUID: TGuid;
  S: string;
  L: Integer;
begin
  CreateGUID(GUID);
  S := GUIDToString(GUID);
  if Result <> '' then
  begin
    Delete(S, 1, 1);
    L := Length(S);
    Delete(S, L, 1);
  end;
  Result := S;
end;

function TMethods.Call_Length(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := UTF8Length(S);
end;

function TMethods.Call_AnsiStrLength(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := Length(S);
end;

function TMethods.Call_ArrayLength(Instance: TObject; var Params: Variant): Variant;
var
  V: Variant;
begin
  V := Params[0];
  Result := VarArrayHighBound(V, 1);
end;

function TMethods.Call_Copy(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
  I1, I2: Integer;
begin
  S := Params[0];
  I1 := Params[1];
  I2 := Params[2];
  Result := UTF8Copy(S, I1, I2);
end;

function TMethods.Call_Pos(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Pos(Params[0], Params[1]);
end;

function TMethods.Call_Delete(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
  I1, I2: Integer;
begin
  S := Params[0];
  I1 := Params[1];
  I2 := Params[2];
  UTF8Delete(S, I1, I2);
  Params[0] := S;
end;

function TMethods.Call_Insert(Instance: TObject; var Params: Variant): Variant;
var
  S, SubS: string;
  I: Integer;
begin
  SubS := Params[0];
  S := Params[1];
  I := Params[2];
  UTF8Insert(SubS, S, I);
  Params[1] := S;
end;

function TMethods.Call_Uppercase(Instance: TObject; var Params: Variant): Variant;
var
  S: String;
begin
  S := Params[0];
  Result := UTF8UpperCase(S);
end;

function TMethods.Call_Lowercase(Instance: TObject; var Params: Variant): Variant;
var
  S: String;
begin
  S := Params[0];
  Result := UTF8LowerCase(S);
end;

function TMethods.Call_AnsiUppercase(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := AnsiUpperCase(S);
end;

function TMethods.Call_AnsiLowercase(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  Result := AnsiLowerCase(S);
end;

function TMethods.Call_AnsiPos(Instance: TObject; var Params: Variant): Variant;
var
  SubS, S: string;
begin
  SubS := Params[0];
  S := Params[1];
  Result := AnsiPos(SubS, S);
end;

function TMethods.Call_AnsiDelete(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: AnsiString;
begin
  S := Params[0];
  Delete(S, Params[1], Params[2]);
end;

function TMethods.Call_AnsiInsert(Instance: TObject; var Params: Variant
  ): Variant;
var
  S1, S2: AnsiString;
begin
  S1 := Params[0];
  S2 := Params[1];
  Insert(S1, S2, Params[2]);
end;

function TMethods.Call_Trim(Instance: TObject; var Params: Variant): Variant;
begin
  Result := UTF8Trim(Params[0]);
end;

function TMethods.Call_NameCase(Instance: TObject; var Params: Variant): Variant;
var
  S, LowerStr, UpperStr: String;
  I: Integer;
begin
  S := Params[0];
  UpperStr := dp_UTF8ToAnsi(UTF8UpperCase(S));
  LowerStr:= dp_UTF8ToAnsi(UTF8LowerCase(S));
  for I := 1 to Length(LowerStr) do
  begin
    if I = 1 then
    begin
      LowerStr[I] := UpperStr[I];
    end
    else
    if I < Length(LowerStr) then
    begin
      if LowerStr[I] = ' ' then
      begin
        LowerStr[I + 1] := UpperStr[I + 1];
      end;
    end;
  end;
  Result := dp_AnsiToUTF8(LowerStr);
end;

function TMethods.Call_CompareText(Instance: TObject; var Params: Variant): Variant;
begin
  Result := UTF8CompareText(Params[0], Params[1]);
end;

function TMethods.Call_SameText(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := SameText(Params[0], Params[1]);
end;

function TMethods.Call_SetLength(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  SetLength(S, Integer(Params[1]));
  Params[0] := S;
end;

function TMethods.Call_SetArrayLength(Instance: TObject; var Params: Variant): Variant;
var
  V: Variant;
  I: Integer;
begin
  V := Params[0];
  I := Params[1];
  VarArrayRedim(V, I);
  Params[0] := V;
end;

function TMethods.Call_LastDelimiter(Instance: TObject; var Params: Variant): Variant;
var
  S1, S2: string;
begin
  S1 := Params[0];
  S2 := Params[1];
  S1 := dp_UTF8ToAnsi(S1);
  S2 := dp_UTF8ToAnsi(S2);
  Result := LastDelimiter(S1, S2);
end;

function TMethods.Call_IsDigit(Instance: TObject; var Params: Variant): Variant;
var
  S: string;
begin
  Result := False;
  S := Params[0];
  if S <> '' then
    if S[1] in ['0'..'9'] then Result := True;
end;

function TMethods.Call_IsLetter(Instance: TObject; var Params: Variant
  ): Variant;
var
  S, S1: string;
  C: Char;
  I: Integer;
begin
  Result := False;
  S1 := Params[0];
  if S1 <> '' then
  begin
    S := dp_UTF8ToAnsi(S1);
    C := S[1];
    I := Ord(C);
    if (I = 32) or ((I >= 65) and (I <= 90)) or ((I >= 97) and (I < 122))
    //CP1251
    or ((I >= 192) and (I <= 255)) or (I = 168) or (I = 184) then Result := True;
  end;
end;

function TMethods.Call_IsSimbol(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  C: Char;
  I: Integer;
begin
  Result := False;
  S := Params[0];
  if S <> '' then
  begin
    S := dp_UTF8ToAnsi(S);
    C := S[1];
    I := Ord(C);
    if I in [33..47, 58..64, 91..96, 123..126, 128..191] then Result := True;
  end;
end;

function TMethods.Call_IsNumericStr(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
  L, I: Integer;
begin
  Result := True;
  S := Params[0];
  L := Length(S);
  for I := 1 to L do
    if not (S[I] in ['0'..'9']) then
    begin
      Result := False;
      Break;
    end;
end;

function TMethods.Call_Int(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Int(Params[0]);
end;

function TMethods.Call_Frac(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Frac(Params[0]);
end;

function TMethods.Call_Sqrt(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Sqrt(Params[0]);
end;

function TMethods.Call_ArcTan(Instance: TObject; var Params: Variant): Variant;
begin
  Result := ArcTan(Params[0]);
end;

function TMethods.Call_Tan(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Sin(Params[0]) / Cos(Params[0])
end;

function TMethods.Call_Exp(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Exp(Params[0]);
end;

function TMethods.Call_Ln(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Ln(Params[0]);
end;

function TMethods.Call_Inc(Instance: TObject; var Params: Variant): Variant;
var
  I, I2: Integer;
begin
  I := Params[0];
  I2 := Params[1];
  Inc(I, I2);
  Params[0] := I;
end;

function TMethods.Call_Dec(Instance: TObject; var Params: Variant): Variant;
var
  I, I2: Integer;
begin
  I := Params[0];
  I2 := Params[1];
  Dec(I, I2);
  Params[0] := I;
end;

function TMethods.Call_VarArrayOf(Instance: TObject; var Params: Variant): Variant;
begin
  Result := Params[0]
end;

function TMethods.Call_VarArrayCreate(Instance: TObject; var Params: Variant): Variant;
var
  A: Array of PtrInt;
  V: Variant;
  I, HBound: Integer;
begin
  V := Params[0];
  HBound := VarArrayHighBound(V, 1);
  SetLength(A, HBound);
  for I := 0 to HBound - 1 do
    A[I] := V[I];
  Result := VarArrayCreate(A, Params[1]);
end;

function TMethods.Call_Sleep(Instance: TObject; var Params: Variant): Variant;
begin
  Sleep(Params[0]);
end;

initialization
  scriptuoendsproc := nil;
  Met := TMethods.Create;
  MethodDefList.Add(Met);

finalization
  Met.Free;
end.

