unit dpi_Graphics;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, dpi_mettyps;

type

  { TGraphicsImport }

  TGraphicsImport = class(TClassImporter)
    function Icon_Delete(Instance: TObject; var Params: Variant): Variant;
    function Picture_BitmapGet(Instance: Pointer): Variant;
    procedure Picture_BitmapSet(Instance: Pointer; AValue: Variant);
    function Picture_GraphicGet(Instance: Pointer): Variant;
    procedure Picture_GraphicSet(Instance: Pointer; AValue: Variant);
    function Picture_HeightGet(Instance: Pointer): Variant;
    function Picture_IconGet(Instance: Pointer): Variant;
    procedure Picture_IconSet(Instance: Pointer; AValue: Variant);
    function Picture_JpegGet(Instance: Pointer): Variant;
    procedure Picture_JpegSet(Instance: Pointer; AValue: Variant);
    function Picture_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function Picture_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function Picture_LoadFromStreamWithFileExt(Instance: TObject;
      var Params: Variant): Variant;
    function Picture_PixmapGet(Instance: Pointer): Variant;
    procedure Picture_PixmapSet(Instance: Pointer; AValue: Variant);
    function Picture_PNGGet(Instance: Pointer): Variant;
    procedure Picture_PNGSet(Instance: Pointer; AValue: Variant);
    function Picture_PNMGet(Instance: Pointer): Variant;
    procedure Picture_PNMSet(Instance: Pointer; AValue: Variant);
    function Picture_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function Picture_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function Picture_SaveToStreamWithFileExt(Instance: TObject;
      var Params: Variant): Variant;
    function Picture_WidthGet(Instance: Pointer): Variant;
    function RasterImage_FreeImage(Instance: TObject; var Params: Variant
      ): Variant;
    function RasterImage_Mask(Instance: TObject; var Params: Variant): Variant;
    function TBitmap_Create(Instance: TObject; var Params: Variant): Variant;
    function TGraphic_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function TGraphic_MimeTypeGet(Instance: Pointer): Variant;
    function TGraphic_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function TGraphic_TransparentGet(Instance: Pointer): Variant;
    procedure TGraphic_TransparentSet(Instance: Pointer; AValue: Variant);
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
    function Create_Object(AClass: TClass): TObject; override;
  published
    {methods}
    function Call_RGBToColor(Instence: TObject; var Params: Variant): Variant;
    function Call_ColorToRGB(Instence: TObject; var Params: Variant): Variant;
    {TBrush support}
    function TBrush_GetBitmap(Instance: Pointer): Variant;
    procedure TBrush_SetBitmap(Instance: Pointer; AValue: Variant);
    {TCanvas support}
    function TCanvas_Arc(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_Chord(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_CopyRect(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_Draw(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_FillRect(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_DrawFocusRect(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_Ellipse(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_FloodFill(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_FrameRect(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_LineTo(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_MoveTo(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_Pie(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_Rectangle(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_Refresh(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_RoundRect(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_StretchDraw(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_TextOut(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_TextRect(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_TextHeight(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_TextWidth(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_PenPosGet(Instance: Pointer): Variant;
    procedure TCanvas_PenPosSet(Instance: Pointer; AValue: Variant);
    function TCanvas_Handle_Get(Instance: Pointer): Variant;
    procedure TCanvas_HandleSet(Instance: Pointer; AValue: Variant);
    function TCanvas_Pixels_Get(Instance: TObject;
       var Params: Variant): Variant;
    function TCanvas_Pixels_Set(Instance: TObject;
       var Params: Variant): Variant;


    function TCAnvas_PenGet(Instance: Pointer): Variant;
    procedure TCanvas_PenSet(Instance: Pointer; AValue: Variant);
    function TCanvas_BrushGet(Instance: Pointer): Variant;
    procedure TCanvas_BrushSet(Instance: Pointer; AValue: Variant);

    function TGraphic_LoadFromFile(Instance: TObject;
       var Params: Variant): Variant;
    function TGraphic_SaveToFile(Instance: TObject;
       var Params: Variant): Variant;
    function TGraphic_HeightGet(Instance: Pointer): Variant;
    procedure TGraphic_HeightSet(Instance: Pointer; AValue: Variant);
    function TGraphic_WidthGet(Instance: Pointer): Variant;
    procedure TGraphic_WidthSet(Instance: Pointer; AValue: Variant);
    function RasterImage_CanvasGet(Instance: Pointer): Variant;
  end;

implementation

uses Graphics, dpUtils, Types, GraphType, FileUtil;

procedure TGraphicsImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('cmBlackness', 'Integer', cmBlackness);
  AddConst('cmDstInvert', 'Integer', cmDstInvert);
  AddConst('cmMergeCopy', 'Integer', cmMergeCopy);
  AddConst('cmMergePaint', 'Integer', cmMergePaint);
  AddConst('cmNotSrcCopy', 'Integer', cmNotSrcCopy);
  AddConst('cmNotSrcErase', 'Integer', cmNotSrcErase);
  AddConst('cmPatCopy', 'Integer', cmPatCopy);
  AddConst('cmPatInvert', 'Integer', cmPatInvert);
  AddConst('cmPatPaint', 'Integer', cmPatPaint);
  AddConst('cmSrcAnd', 'Integer', cmSrcAnd);
  AddConst('cmSrcCopy', 'Integer', cmSrcCopy);
  AddConst('cmSrcErase', 'Integer', cmSrcErase);
  AddConst('cmSrcInvert', 'Integer', cmSrcInvert);
  AddConst('cmSrcPaint', 'Integer', cmSrcPaint);
  AddConst('cmWhiteness', 'Integer', cmWhiteness);
end;

procedure TGraphicsImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('TFontName', btString);
  AddType('TCopyMode', btInt);
  AddType('HDC', btInt);
  //AddType('TColorRef', btInt);

end;

procedure TGraphicsImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function RGBToColor(R, G, B: Byte): TColor', @Call_RGBToColor);
  AddMethod('function ColorToRGB(Color: TColor): Longint', @Call_ColorToRGB);
  {AddMethod('', @Call_);
  AddMethod('', @Call_);
  AddMethod('', @Call_);
  AddMethod('', @Call_);
  AddMethod('', @Call_);
  AddMethod('', @Call_);
  AddMethod('', @Call_);}
end;

function TGraphicsImport.Create_Object(AClass: TClass): TObject;
begin
  Result := nil;
  if AClass = TBitmap then Result := TBitmap.Create
  else
  if AClass = TFont then Result := TFont.Create
  else
  if AClass = TPen then Result := TPen.Create
  else
  if AClass = TBrush then Result := TBrush.Create
  else
  if AClass = TCanvas then Result := TCanvas.Create
  else
  if AClass = TGraphic then Result := TGraphic.Create
  else
  if AClass = TPicture then Result := TPicture.Create
  else
  if AClass = TIcon then Result := TIcon.Create
  else
  if AClass = TPixmap then Result := TPixmap.Create
  else
  if AClass = TPortableAnyMapGraphic then Result := TPortableNetworkGraphic.Create
  else
  if AClass = TPortableAnyMapGraphic then Result := TPortableAnyMapGraphic.Create
  else
  if AClass = TJPEGImage then Result := TJPEGImage.Create
  else
  if AClass = TGIFImage then Result := TGIFImage.Create;
end;

function TGraphicsImport.Call_RGBToColor(Instence: TObject; var Params: Variant
  ): Variant;
var
  R, G, B: Byte;
begin
  R := Params[0];
  G := Params[1];
  B := Params[2];
  Result := RGBToColor(R, G, B);
end;

function TGraphicsImport.Call_ColorToRGB(Instence: TObject; var Params: Variant
  ): Variant;
begin
  Result := ColorToRGB(Params[0]);
end;

function TGraphicsImport.Icon_Delete(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TIcon(Instance).Delete(Params[0]);
end;

function TGraphicsImport.Picture_BitmapGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPicture(Instance).Bitmap );
end;

procedure TGraphicsImport.Picture_BitmapSet(Instance: Pointer; AValue: Variant);
begin
  TPicture(Instance).Bitmap := TBitmap( TSuPtr(AValue) );
end;

function TGraphicsImport.Picture_GraphicGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPicture(Instance).Graphic );
end;

procedure TGraphicsImport.Picture_GraphicSet(Instance: Pointer; AValue: Variant
  );
begin
  TPicture(Instance).Graphic := TGraphic( TSuPtr(AValue) );
end;

function TGraphicsImport.Picture_HeightGet(Instance: Pointer): Variant;
begin
  Result := TPicture(Instance).Height;
end;

function TGraphicsImport.Picture_IconGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPicture(Instance).Icon );
end;

procedure TGraphicsImport.Picture_IconSet(Instance: Pointer; AValue: Variant);
begin
  TPicture(Instance).Icon := TIcon( TSuPtr(AValue) );
end;

function TGraphicsImport.Picture_JpegGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPicture(Instance).Jpeg );
end;

procedure TGraphicsImport.Picture_JpegSet(Instance: Pointer; AValue: Variant);
begin
  TPicture(Instance).Jpeg := TJPEGImage( TSuPtr(AValue) );
end;

function TGraphicsImport.Picture_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPicture(Instance).LoadFromFile(Params[0]);
end;

function TGraphicsImport.Picture_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPicture(Instance).LoadFromStream(TStream( TSuPtr(Params[0]) ));
end;

function TGraphicsImport.Picture_LoadFromStreamWithFileExt(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPicture(Instance).LoadFromStreamWithFileExt(TStream( TSuPtr(Params[0]) ), Params[1]);
end;

function TGraphicsImport.Picture_PixmapGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPicture(Instance).Pixmap );
end;

procedure TGraphicsImport.Picture_PixmapSet(Instance: Pointer; AValue: Variant);
begin
  TPicture(Instance).Pixmap := TPixmap( TSuPtr(AValue) );
end;

function TGraphicsImport.Picture_PNGGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPicture(Instance).PNG );
end;

procedure TGraphicsImport.Picture_PNGSet(Instance: Pointer; AValue: Variant);
begin
  TPicture(Instance).PNG := TPortableNetworkGraphic( TSuPtr(AValue) );
end;

function TGraphicsImport.Picture_PNMGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TPicture(Instance).PNM );
end;

procedure TGraphicsImport.Picture_PNMSet(Instance: Pointer; AValue: Variant);
begin
  TPicture(Instance).PNM := TPortableAnyMapGraphic( TSuPtr(AValue) );
end;

function TGraphicsImport.Picture_SaveToFile(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPicture(Instance).SaveToFile(Params[0], Params[1]);
end;

function TGraphicsImport.Picture_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPicture(Instance).SaveToStream(TStream(TSuPtr(Params[0])));
end;

function TGraphicsImport.Picture_SaveToStreamWithFileExt(Instance: TObject;
  var Params: Variant): Variant;
begin
  TPicture(Instance).SaveToStreamWithFileExt( TStream(TSuPtr(Params[0])), Params[1] );
end;

function TGraphicsImport.Picture_WidthGet(Instance: Pointer): Variant;
begin
  Result := TPicture(Instance).Width;
end;


function TGraphicsImport.RasterImage_FreeImage(Instance: TObject;
  var Params: Variant): Variant;
begin
  TRasterImage(Instance).FreeImage;
end;

function TGraphicsImport.RasterImage_Mask(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TRasterImage(Instance).Mask(Params[0]);
end;

function TGraphicsImport.TBitmap_Create(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TBitmap.Create );
end;

function TGraphicsImport.TGraphic_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TGraphic(Instance).LoadFromStream(TStream( TSuPtr( Params[0] ) ));
end;

function TGraphicsImport.TGraphic_MimeTypeGet(Instance: Pointer): Variant;
begin
  Result := TGraphic(Instance).MimeType;
end;

function TGraphicsImport.TGraphic_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TGraphic(Instance).SaveToStream(TStream( TSuPtr( Params[0] ) ));
end;

function TGraphicsImport.TGraphic_TransparentGet(Instance: Pointer): Variant;
begin
  Result := TGraphic(Instance).Transparent;
end;

procedure TGraphicsImport.TGraphic_TransparentSet(Instance: Pointer;
  AValue: Variant);
begin
  TGraphic(Instance).Transparent := AValue;
end;

procedure TGraphicsImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TFontPitch));
  AddType(TypeInfo(TFontCharset));
  AddType(TypeInfo(TFontStyle));
  AddType(TypeInfo(TFontStyles));
  AddType(TypeInfo(TFontQuality));

  AddType(TypeInfo(TPenStyle));
  AddType(TypeInfo(TPenMode));

  AddType(TypeInfo(TBrushStyle));

  AddType(TypeInfo(TFillStyle), 'TFillStyle');
  AddType(TypeInfo(TFillMode));

  AddType(TypeInfo(TCanvasStates));
  AddType(TypeInfo(TCanvasState));
  AddType(TypeInfo(TCanvasOrientation));
  AddType(TypeInfo(TTransparentMode));

  AddType(TypeInfo(TGraphicsDrawEffect));
  AddType(TypeInfo(TGraphicsColor));
  AddType(TypeInfo(TGraphicsFillStyle));
end;

procedure TGraphicsImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(TFont).ClassImporter := Self;
  AddClass(TPen).ClassImporter := Self;
  AddClass(TBrush).ClassImporter := Self;
  AddClass(TCanvas).ClassImporter := Self;
  AddClass(TGraphic).ClassImporter := Self;
  AddClass(TPicture).ClassImporter := Self;
  AddClass(TRasterImage).ClassImporter := Self;
  AddClass(TBitmap).ClassImporter := Self;
  AddClass(TIcon).ClassImporter := Self;
  AddClass(TPixmap).ClassImporter := Self;
  AddClass(TPortableNetworkGraphic);
  AddClass(TPortableAnyMapGraphic);
  AddClass(TJpegImage).ClassImporter := Self;
  AddClass(TGIFImage).ClassImporter := Self;
end;

procedure TGraphicsImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TGraphic then
  begin
    AType.AddMethod('procedure LoadFromFile(FileName: string)', @TGraphic_LoadFromFile);
    AType.AddMethod('procedure SaveToFile(FileName: string)', @TGraphic_SaveToFile);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @TGraphic_SaveToStream);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @TGraphic_LoadFromStream);
    AType.AddProp('Height', 'Integer', @TGraphic_HeightGet, @TGraphic_HeightSet);
    AType.AddProp('Width', 'Integer', @TGraphic_WidthGet, @TGraphic_WidthSet);
    AType.AddProp('Transparent', 'Boolean', @TGraphic_TransparentGet, @TGraphic_TransparentSet);
    AType.AddProp('MimeType', 'string', @TGraphic_MimeTypeGet);
  end
  else
  if AType.ValueClassType = TBrush then
  begin
    AType.AddProp('Bitmap', 'TBitmap', @TBrush_GetBitmap, @TBrush_SetBitmap);
  end
  else
  if AType.ValueClassType = TCanvas then
  begin
    AType.AddMethod('procedure Arc(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer)', @TCanvas_Arc);
    AType.AddMethod('procedure Chord(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer)', @TCanvas_Chord);
    AType.AddMethod('procedure CopyRect(const Dest: TRect; Canvas: TCanvas; const Source: TRect)', @TCanvas_CopyRect);
    AType.AddMethod('procedure Draw(X, Y: Integer; Graphic: TGraphic)', @TCanvas_Draw);
    AType.AddMethod('procedure FillRect(Left, Top, Right, Bottom: Integer)', @TCanvas_FillRect);
    AType.AddMethod('procedure DrawFocusRect(Left, Top, Right, Bottom: Integer)', @TCanvas_DrawFocusRect);
    AType.AddMethod('procedure Ellipse(X1, Y1, X2, Y2: Integer)', @TCanvas_Ellipse);
    AType.AddMethod('procedure FloodFill(X, Y: Integer; Color: TColor; FillStyle: TFillStyle)', @TCanvas_FloodFill);
    AType.AddMethod('procedure FrameRect(Left, Top, Right, Bottom: Integer)', @TCanvas_FrameRect);
    AType.AddMethod('procedure LineTo(X, Y: Integer)', @TCanvas_LineTo);
    AType.AddMethod('procedure MoveTo(X, Y: Integer)', @TCanvas_MoveTo);
    AType.AddMethod('procedure Pie(X1, Y1, X2, Y2, X3, Y3, X4, Y4: Integer)', @TCanvas_Pie);
    AType.AddMethod('procedure Rectangle(X1, Y1, X2, Y2: Integer)', @TCanvas_Rectangle);
    AType.AddMethod('procedure Refresh', @TCanvas_Refresh);
    AType.AddMethod('procedure RoundRect(X1, Y1, X2, Y2, X3, Y3: Integer)', @TCanvas_RoundRect);
    AType.AddMethod('procedure StretchDraw(Left, Top, Right, Bottom: Integer; Graphic: TGraphic)', @TCanvas_StretchDraw);
    AType.AddMethod('procedure TextOut(X, Y: Integer; const Text: string)', @TCanvas_TextOut);
    AType.AddMethod('procedure TextRect(RectLeft, RectTop, RectRight, RectBottom, X, Y: Integer; const Text: string)', @TCanvas_TextRect);
    AType.AddMethod('function TextHeight(const Text: string): Integer', @TCanvas_TextHeight);
    AType.AddMethod('function TextWidth(const Text: string): Integer', @TCanvas_TextWidth);
    AType.AddProp('PenPos', 'TPoint', @TCanvas_PenPosGet, @TCanvas_PenPosSet);
    AType.AddProp('Handle', 'HDC', @TCanvas_Handle_Get, @TCanvas_HandleSet);
    AType.AddIndexedProp('Pixels', 'TColor', 'Integer, Integer', @TCanvas_Pixels_Get, @TCanvas_Pixels_Set);
  end
  else
  if AType.ValueClassType = TRasterImage then
  begin
    AType.AddMethod('procedure Mask(ATransparentColor: TColor)', @RasterImage_Mask);
    AType.AddMethod('procedure FreeImage', @RasterImage_FreeImage);
    AType.AddProp('Canvas', 'TCanvas', @RasterImage_CanvasGet);
  end
  else
  if AType.ValueClassType = TIcon then
  begin
    AType.AddMethod('procedure Delete(Aindex: Integer)', @Icon_Delete);
  end
  else
  if AType.ValueClassType = TPicture then
  begin
    AType.AddProp('Bitmap', 'TBitmap', @Picture_BitmapGet, @Picture_BitmapSet);
    AType.AddProp('Icon', 'TIcon', @Picture_IconGet, @Picture_IconSet);
    AType.AddProp('Jpeg', 'TJpegImage', @Picture_JpegGet, @Picture_JpegSet);
    AType.AddProp('Pixmap', 'TPixmap', @Picture_PixmapGet, @Picture_PixmapSet);
    AType.AddProp('PNG', 'TPortableNetworkGraphic', @Picture_PNGGet, @Picture_PNGSet);
    AType.AddProp('PNM', 'TPortableAnyMapGraphic', @Picture_PNMGet, @Picture_PNMSet);
    AType.AddProp('Graphic', 'TGraphic', @Picture_GraphicGet, @Picture_GraphicSet);
    AType.AddProp('Height', 'Integer', @Picture_HeightGet);
    AType.AddProp('Width', 'Integer', @Picture_WidthGet);
    AType.AddMethod('procedure SaveToFile(const Filename: string; const FileExt: string = '')', @Picture_SaveToFile);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @Picture_SaveToStream);
    AType.AddMethod('procedure SaveToStreamWithFileExt(Stream: TStream; const FileExt: string)', @Picture_SaveToStreamWithFileExt);
    AType.AddMethod('procedure LoadFromFile(const Filename: string)', @Picture_LoadFromFile);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @Picture_LoadFromStream);
    AType.AddMethod('procedure LoadFromStreamWithFileExt(Stream: TStream; const FileExt: string)', @Picture_LoadFromStreamWithFileExt);
  end;
end;


{TBrush support}

function TGraphicsImport.TBrush_GetBitmap(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TBrush(Instance).Bitmap);
end;

procedure TGraphicsImport.TBrush_SetBitmap(Instance: Pointer; AValue: Variant);
begin
  TBrush(Instance).Bitmap := TBitmap(TSuPtr(AValue));
end;

{TCanvas support}

function TGraphicsImport.TCanvas_Arc(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Arc(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5], Params[6], Params[7]);
end;

function TGraphicsImport.TCanvas_Chord(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Chord(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5], Params[6], Params[7]);
end;

function TGraphicsImport.TCanvas_CopyRect(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).CopyRect(PRect(TSuPtr(Params[0]))^, TCanvas(TSuPtr(Params[1])), PRect(TSuPtr(Params[2]))^);
end;

function TGraphicsImport.TCanvas_Draw(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Draw(Params[0], Params[1], TGraphic(TSuPtr(Params[2])));
end;

function TGraphicsImport.TCanvas_FillRect(Instance: TObject;
       var Params: Variant): Variant;
var
  R: TRect;
begin
  R.Left := Params[0];
  R.Top:= Params[1];
  R.Right:= Params[2];
  R.Bottom:= Params[3];
  TCanvas(Instance).FillRect(R);
end;

function TGraphicsImport.TCanvas_DrawFocusRect(Instance: TObject;
       var Params: Variant): Variant;
var
  R: TRect;
begin
  R.Left:= Params[0];
  R.Top:= Params[1];
  R.Right:= Params[2];
  R.Bottom:=Params[3];
  TCanvas(Instance).DrawFocusRect(R);
end;

function TGraphicsImport.TCanvas_Ellipse(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Ellipse(Params[0], Params[1], Params[2], Params[3]);
end;

function TGraphicsImport.TCanvas_FloodFill(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).FloodFill(Params[0], Params[1], TColor(Params[2]), TFillStyle(Params[3]));
end;

function TGraphicsImport.TCanvas_FrameRect(Instance: TObject;
       var Params: Variant): Variant;
var
  R: TRect;
begin
  R.Left:= Params[0];
  R.Top:= Params[1];
  R.Right:= Params[2];
  R.Bottom:= Params[3];
  TCanvas(Instance).FrameRect(R);
end;

function TGraphicsImport.TCanvas_LineTo(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).LineTo(Params[0], Params[1]);
end;

function TGraphicsImport.TCanvas_MoveTo(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).MoveTo(Params[0], Params[1]);
end;

function TGraphicsImport.TCanvas_Pie(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Pie(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5], Params[6], Params[7]);
end;

function TGraphicsImport.TCanvas_Rectangle(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Rectangle(Params[0], Params[1], Params[2], Params[3]);
end;

function TGraphicsImport.TCanvas_Refresh(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Refresh;
end;

function TGraphicsImport.TCanvas_RoundRect(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).RoundRect(Params[0], Params[1], Params[2], Params[3], Params[4], Params[5]);
end;

function TGraphicsImport.TCanvas_StretchDraw(Instance: TObject;
       var Params: Variant): Variant;
var
  R: TRect;
begin
  R.Left := Params[0];
  R.Top := Params[1];
  R.Right := Params[2];
  R.Bottom := Params[3];
  TCanvas(Instance).StretchDraw(R, TGraphic(TSuPtr(Params[4])));
end;

function TGraphicsImport.TCanvas_TextOut(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).TextOut(Params[0], Params[1], Params[2]);
end;

function TGraphicsImport.TCanvas_TextRect(Instance: TObject;
       var Params: Variant): Variant;
var
  R: TRect;
begin
  R.Left := Params[0];
  R.Top := Params[1];
  R.Right := Params[2];
  R.Bottom:= Params[3];
  TCanvas(Instance).TextRect(R, Params[4], Params[5], Params[6]);
end;

function TGraphicsImport.TCanvas_TextHeight(Instance: TObject;
       var Params: Variant): Variant;
begin
  Result := TCanvas(Instance).TextHeight(Params[0])
end;

function TGraphicsImport.TCanvas_TextWidth(Instance: TObject;
       var Params: Variant): Variant;
begin
  Result := TCanvas(Instance).TextWidth(Params[0])
end;

function TGraphicsImport.TCanvas_PenPosGet(Instance: Pointer): Variant;
var
  P: PPoint;
begin
  New(P);
  P^ := TCanvas(Instance).PenPos;
  Result := TSuPtr(P);
end;

procedure TGraphicsImport.TCanvas_PenPosSet(Instance: Pointer; AValue: Variant);
begin
  TCanvas(Instance).PenPos := PPoint(TSuPtr(AValue))^;
end;

function TGraphicsImport.TCanvas_Handle_Get(Instance: Pointer): Variant;
begin
  Result := TCanvas(Instance).Handle;
end;

procedure TGraphicsImport.TCanvas_HandleSet(Instance: Pointer; AValue: Variant);
begin
  TCanvas(Instance).Handle :=  THandle(AValue);
end;

function TGraphicsImport.TCanvas_Pixels_Get(Instance: TObject;
       var Params: Variant): Variant;
begin
  Result := TCanvas(Instance).Pixels[Params[0], Params[1]];
end;

function TGraphicsImport.TCanvas_Pixels_Set(Instance: TObject;
       var Params: Variant): Variant;
begin
  TCanvas(Instance).Pixels[Params[0], Params[1]] := Params[2]
end;

function TGraphicsImport.TCAnvas_PenGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCanvas(Instance).Pen);
end;

procedure TGraphicsImport.TCanvas_PenSet(Instance: Pointer; AValue: Variant);
begin
  TCanvas(Instance).Pen := TPen(TSuPtr(AValue));
end;

function TGraphicsImport.TCanvas_BrushGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TCanvas(Instance).Brush);
end;

procedure TGraphicsImport.TCanvas_BrushSet(Instance: Pointer; AValue: Variant);
begin
  TCanvas(Instance).Brush := TBrush(TSuPtr(AValue));
end;

function TGraphicsImport.TGraphic_LoadFromFile(Instance: TObject;
       var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TGraphic(Instance).LoadFromFile(S);
end;

function TGraphicsImport.TGraphic_SaveToFile(Instance: TObject;
       var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TGraphic(Instance).SaveToFile(S);
end;

function TGraphicsImport.TGraphic_HeightGet(Instance: Pointer): Variant;
begin
  Result := TGraphic(Instance).Height;
end;

procedure TGraphicsImport.TGraphic_HeightSet(Instance: Pointer; AValue: Variant);
begin
  TGraphic(Instance).Height := AValue;
end;

function TGraphicsImport.TGraphic_WidthGet(Instance: Pointer): Variant;
begin
  Result := TGraphic(Instance).Width;
end;

procedure TGraphicsImport.TGraphic_WidthSet(Instance: Pointer; AValue: Variant);
begin
  TGraphic(Instance).Width := AValue;
end;

function TGraphicsImport.RasterImage_CanvasGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TBitmap(Instance).Canvas);
end;

end.

