{**************************************************************************}
{ Библиотека работы с платёжными терминалами пластиковых карт              }
{ в стандарте, предоставляемым Сбербанком                                  }
{ Free Pascal Compiler версии 3.1.1 и Lazarus 1.9 и выше.                  }
{ Лагунов Алексей (С) 2017  alexs75.at.yandex.ru                           }
{**************************************************************************}

unit sbrf_pc_consts;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

function sbpcErrorCodeToMsg(ACode:integer):string;

resourcestring

  sSBRFEMsg12 = 'Эта версия не поддерживает режим РС-3'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg36 = 'В пинпаде нет ключа в ячейке 9'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg99 = 'Пинпад не подключен'#13'Проверить кабели, идущие к пинпаду. Если все на месте, обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg101 = 'Операция не поддерживается.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg233 = 'Пинпад не подключен'#13'Нет связи с устройством.Если это внешнее устройство, проверьте, включено ли оно, подключен ли кабель связи.';
  sSBRFEMsg238 = 'Пинпад отключился'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg248 = 'Динамическая память закончилась'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg249 = 'На терминал передана команда не содержащая обязательные параметры'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg250 = 'Внутренняя ошибка: операция отменена'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg252 = 'Внутренняя ошибка: операция не поддерживается'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg253 = 'Аппаратный сбой. Устройство ещё не готово.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg361 = 'Нарушился контакт с чипом карты.'#13'Вытащить карту, протереть чип мягкой тканью и повторить операцию.';
  sSBRFEMsg362 = 'Карта не читается'#13'Вытащить карту, протереть чип мягкой тканью и повторить операцию.';
  sSBRFEMsg363 = 'Карта не читается. Попробуйте магн.ридер'#13'Вытащить карту, протереть чип мягкой тканью и повторить операцию.';
  sSBRFEMsg364 = 'Карта не читается'#13'Вытащить карту, протереть чип мягкой тканью и повторить операцию.';
  sSBRFEMsg402 = 'Карта не была выдана. Изымите карту!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg403 = 'ПИН неверен'#13'Объяснить клиенту его ошибку и повторить операцию.';
  sSBRFEMsg405 = 'ПИН блокирован'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg500 = 'Карта терминала старой версии!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg505 = 'Карта терминала заполнена. Выполните инкассацию'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg507 = 'Срок действия карты истек'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg514 = 'На терминале установлена неверная дата'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg521 = 'На карте недостаточно средств'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg561 = 'Нарушен список операций на карте. Изымите карту!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg579 = 'Карта блокирована. Изымите карту!'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg584 = 'Сегодня по этой карте больше операций делать нельзя'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg585 = 'Период обслуживания истек'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg586 = 'Превышен лимит, разрешенный без связи с банком'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg705 = 'Карта блокирована. Изымите карту!'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg706 = 'Карта блокирована'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg708 = 'ПИН зачисления заблокирован'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg709 = 'ПИН списания заблокирован'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg2000 = 'Операция прервана клиентом'#13'Возможно, при вводе ПИНа клиент случайно нажал красную клавишу на пинпаде. Повторить операцию.';
  sSBRFEMsg2002 = 'Превышено время ожидания'#13'Повторить операцию. На ввод ПИНа дается 1 минута.';
  sSBRFEMsg2008 = 'Для этой карты операция запрещена'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg3162 = 'Срок действия карты СБЕРКАРТ окончен. Эта ошибка не должна вылезти в проме.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4073 = 'Биосканер не подключен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4100 = 'Нет связи с банком'#13'Повторить операцию. Если за 2-3 попытки провести операцию не удается, обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4101 = 'На терминале нет стоп-листа. Выполните инкассацию'#13'Выполнить инкассацию карты терминала и повторить операцию.';
  sSBRFEMsg4102 = 'На терминале нет таблицы комиссий'#13'Выполнить инкассацию карты терминала и повторить операцию.';
  sSBRFEMsg4106 = 'ПИН неверен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4107 = 'ПИН блокирован'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4108 = 'Номер карты неверен'#13'Повторить операцию. Если за 2-3 попытки провести операцию не удается, обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4110 = 'Карта терм.заполнена.Выполните инкассацию'#13'Выполнить инкассацию карты терминала и повторить операцию.';
  sSBRFEMsg4111 = 'Стоп-лист устарел. Выполните инкассацию'#13'Выполнить инкассацию карты терминала и повторить операцию.';
  sSBRFEMsg4112 = 'Неверный стоп-лист.Выполните инкассацию'#13'Выполнить инкассацию карты терминала и повторить операцию.';
  sSBRFEMsg4113 = 'Превышен лимит операций за сутки'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg4115 = 'Для таких карт ручной ввод запрещен'#13'Операция возможна только при условии, что карта будет считана через ридер, а не введена вручную с клавиатуры.';
  sSBRFEMsg4116 = 'Цифры не совпадают!'#13'Операция возможна только при условии, что карта будет считана через ридер, а не введена вручную с клавиатуры.';
  sSBRFEMsg4117 = 'Клиент отказался от ввода ПИНа'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4118 = 'Операции не найдены'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4119 = 'Нет связи с банком'#13'Повторить операцию. Если за 2-3 попытки провести операцию не удается, обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4120 = 'Пинпад не подключен или не загружены ключи'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4121 = 'Терминал неисправен!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4122 = 'Ошибка смены ключей!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4123 = 'Сначала выполните сверку итогов'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4124 = 'Не загружены ключи'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4125 = 'На карте есть чип. Вставьте карту чипом'#13'Вставить карту в чиповый ридер и продолжить операцию.';
  sSBRFEMsg4128 = 'Ошибка настройки терминала'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4130 = 'Память заполнена. Сделайте сверку ито- гов или инкассацию.'#13'Выполнить сверку итогов и повторить операцию.';
  sSBRFEMsg4131 = 'Пинпад был заменен. Выполните загрузку параметров'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4132 = 'Операция отклонена картой'#13'Повторить операцию. Если ошибка повторяется, отказать клиенту.';
  sSBRFEMsg4133 = 'Неверный код ответа по протоколу VISA2'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4134 = 'Сначала выполните сверку итогов'#13'Выполнить сверку итогов и повторить операцию.';
  sSBRFEMsg4135 = 'Неверно настроены отделы в терминале'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4136 = 'Требуется более свежая версия прошивки в пинпаде'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4137 = 'ПИНы не совпадают. Попробуйте еще раз.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4138 = 'Карта отправителя и получателя не могут совпадать.'#13'Повторить операцию  и ввести номера карт правильно.';
  sSBRFEMsg4139 = 'Нет адреса для связи.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4148 = 'Карта в стоп-листе!'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg4149 = 'На карте нет имени держателя'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg4150 = 'Превышен лимит операций'#13'Выполнить операцию с установкой связи с банком.';
  sSBRFEMsg4151 = 'Срок действия карты истек'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg4157 = 'Превышена максимальная сумма операции.'#13'Отказать клиенту. Предложить выполнить операцию на меньшую сумму.';
  sSBRFEMsg4159 = 'Валюта операции не поддерживается бесконтактным ридером'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4174 = 'Файл не найден'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4175 = 'Слишком большой файл'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4176 = 'Неизвестная версия Vivopay'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4185 = 'Неверная карта администратора'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4186 = 'Ключ уже введен!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4187 = 'Неверный номер карты'#13'Повторить ввод номера карты.';
  sSBRFEMsg4188 = 'Неверный  срок действия карты'#13'Повторить ввод срока действия карты.';
  sSBRFEMsg4189 = 'Недопустимое значение!'#13'Ввести допустимое значение изменяемого параметра.';
  sSBRFEMsg4190 = 'Карта не читается. Попробуйте магн.ридер'#13'Используйте магнитный считыватель для чтения карты.';
  sSBRFEMsg4203 = 'Терминал не зарегистрирован'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4204 = 'Внутренняя ошибка сервера'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4205 = 'Ошибка связи с хостом'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4206 = 'Нарушение протокола'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4207 = 'Нарушение формата сообщений'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4208 = 'Ошибка базы данных'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4209 = 'Некорректные данные'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4210 = 'Ошибка шифрования'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4211 = 'Отсутствует ключ'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4220 = 'Не указан код региона для удаленной загрузки'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4221 = 'Не удалось восстановить связь с ККМ после удаленной загрузки'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4222 = 'Память заполнена. Необходимо отправить чеки на сервер'#13'Отправьте чеки на сервер и повторите операцию';
  sSBRFEMsg4300 = 'От ККМ поступило недостаточно параметров'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4303 = 'Такая карта не обслуживается'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4313 = 'Номер карты не соответствует исходному'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4314 = 'Это не карта СБЕРКАРТ'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4315 = 'Разрешены только отмены в текущей смене'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4319 = 'Сумма не должна превышать 42 млн.'#13'Проведите операцию на меньшую сумму или уменьшите количество товара';
  sSBRFEMsg4323 = 'Номер карты не совпадает с исходным'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg4325 = 'Сумма не указана!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4326 = 'Карта прочитана не полностью. Повторите считывание карты.'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg4327 = 'Нет товаров для отображения'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4328 = 'Информация о товаре  отсутствует или неполна.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4329 = 'Справочник товаров переполнен.  Выполните сверку.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4330 = 'Товар не найден.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4334 = 'Карта не считана. Либо цикл ожидания карты прерван нажатием клавиши ESC, либо истек таймаут.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4336 = 'Валюта указана неверно.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4337 = 'Из кассовой программы передан неверный тип карты.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4342 = 'Ошибка: невозможно запустить диалоговое окно UPOS.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4351 = 'Настроечные файлы *.tlv не найдены'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4355 = 'Этот палец уже зарегистрирован в базе'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4358 = 'Палец не опознан!'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4362 = 'Пинпад временно заблокирован. Повторите операцию через 15 сек.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4363 = 'Превышена сумма оригинальной операции'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4365 = 'Режим электронного захвата подписи не поддерживается'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4366 = 'Рассчитанная скидка меньше минимально допустимой.'#13'Введенная или расчитанная сумма скидки меньше минимально допустимой. Если скидка вводилась вручную - увеличьте сумму скидки, в противном случае обратитесь в подразделение банка, установившее терминал';
  sSBRFEMsg4367 = 'RKL: неверный формат запроса'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4368 = 'RKL: не создана ключевая пара СА'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4369 = 'RKL: не загружен сертификат хоста'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4370 = 'RKL: не загружен публичный ключ СА'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4371 = 'Текущая версия ОС не поддерживает RKL'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4372 = 'RKL: хост CA дает некорректный ответ. Необходимо перезагрузить терминал'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4380 = 'Штатная сверка итогов не выполнена.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4381 = 'Неверный формат QR-кода'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4382 = 'Количество товара не должно превышать 4 млн. 200 тыс. единиц'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4383 = 'Не удалось открыть сканирующее устройство'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4384 = 'Считаны не все данные'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4385 = 'Неверный номер пользователя'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4388 = 'Место закончилось. Передайте чеки в банк.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4389 = 'Чек уже успешно передан'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4400 = 'Возможно, карта преждевременно вынута'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4401 = 'Позвоните в банк по т.(800)775-55-55 (495)544-45-46 (495)788-92-74'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4402 = 'Позвоните в банк'#13'Позвонить в службу авторизации Сбербанка и следовать указаниям оператора.';
  sSBRFEMsg4403 = 'Терминал заблокирован. Обратитесь в банк.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4404 = 'Изымите карту'#13'Позвонить в службу авторизации Сбербанка и следовать указаниям оператора.';
  sSBRFEMsg4405 = 'Отказано'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4406 = 'Общая ошибка'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4407 = 'Изымите карту'#13'Изъять карту и отказать клиенту в проведении операции.';
  sSBRFEMsg4408 = 'Отказано'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в любое отделение Сбербанка.';
  sSBRFEMsg4410 = 'Позвоните в Амекс по т. 8(800)2006203 или   8(495)6443054'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в любое отделение Сбербанка.';
  sSBRFEMsg4411 = 'Отказано'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в любое отделение Сбербанка.';
  sSBRFEMsg4412 = 'Транзакция неверна'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4413 = 'Сумма неверна'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4414 = 'Карта неверна'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в любое отделение Сбербанка.';
  sSBRFEMsg4419 = 'Повторите позже'#13'Операция в данный момент невозможна. Повторить операцию через 10-15 минут.';
  sSBRFEMsg4433 = 'Изымите карту'#13'Изъять карту и отказать клиенту в проведении операции.';
  sSBRFEMsg4438 = 'Изымите карту'#13'Изъять карту и отказать клиенту в проведении операции.';
  sSBRFEMsg4441 = 'Изымите карту'#13'Изъять карту и отказать клиенту в проведении операции.';
  sSBRFEMsg4443 = 'Изымите карту'#13'Изъять карту и отказать клиенту в проведении операции.';
  sSBRFEMsg4450 = 'Отказано'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4451 = 'Недостаточно средств'#13'Отказать клиенту в проведении операции.';
  sSBRFEMsg4454 = 'Срок действия карты истек'#13'Отказать клиенту в проведении операции.';
  sSBRFEMsg4455 = 'ПИН неверен'#13'Объяснить клиенту его ошибку и повторить операцию.';
  sSBRFEMsg4457 = 'Транзакция не разрешена картой'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в любое отделение Сбербанка.';
  sSBRFEMsg4458 = 'Транзакция не разрешена терминалом'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4461 = 'Исчерпан лимит'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4462 = 'Карта ограничена'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4465 = 'Исчерпан лимит'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4468 = 'Повторите позже'#13'Операция в данный момент невозможна. Повторить операцию через 10-15 минут.';
  sSBRFEMsg4475 = 'ПИН заблокирован'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg4476 = 'Нет исходной операции'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4478 = 'Счет неверен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4481 = 'Повторите позже'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4482 = 'Отказано'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4483 = 'Ошибка обработки ПИНа'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4486 = 'Ошибка обработки ПИНа'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4488 = 'Ошибка обработки ПИНа'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4489 = 'МАС-код неверен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4490 = 'Неверная контрольная информация'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4491 = 'Эмитент недоступен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4493 = 'Транзакция запрещена'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4494 = 'Повторная транзакция'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4495 = 'Отказано'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4496 = 'Ошибка системы'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4497 = 'Повторите операцию позже'#13'Операция в данный момент невозможна. Повторить операцию через 10-15 минут.';
  sSBRFEMsg4498 = 'МАС-код неверен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4499 = 'Ошибка формата'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg4710 = 'Такая карта не обслуживается'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5001 = 'Отказ карты при выборе приложения'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5002 = 'Отказ карты. Некорректный ответ.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5003 = 'Отказ карты. Некорректный ответ.'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5015 = 'Операция отменена клиентом'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5029 = 'Такая карта не обслуживается'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5042 = 'Ключ удаленной загрузки неверен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5044 = 'Нужно позвонить в банк'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5053 = 'На карте неверные данные (номер карты не совпадает со 2-й дорожкой)'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5055 = 'Карта отклонила операцию'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5063 = 'Карта не ведет историю операций'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5075 = 'Необходимо вставить  карту в чиповый ридер'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5084 = 'Введите пароль на телефоне'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5100 = 'Подлинность данных не проверена'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5101 = 'Ошибка проверки SDA'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5102 = 'На карте нет нужных данных'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5103 = 'Карта в стоп-листе'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5104 = 'Ошибка проверки DDA'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5105 = 'Ошибка проверки CDA'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5108 = 'Неверная версия приложения EMV'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5109 = 'Срок действия карты истек'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5110 = 'Срок действия карты еще не настал'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5111 = 'Для этой карты такая операция запрещена'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк по месту выдачи карты.';
  sSBRFEMsg5112 = 'Карта  только что выдана'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5116 = 'Личность клиента не проверена'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5117 = 'Неизвестный код CVM'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5118 = 'ПИН блокирован'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5119 = 'Пин-пад неисправен'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5120 = 'Клиент не ввел ПИН'#13'Возможно, при вводе ПИНа клиент случайно нажал красную клавишу на пинпаде. Повторить операцию, объяснив клиенту, что без ввода ПИНа операция невозможна.';
  sSBRFEMsg5124 = 'Такая сумма требует связи с банком'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5125 = 'Превышен нижний лимит карты'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5126 = 'Превышен верхний лимит карты'#13'Обратиться к персоналу Сбербанка, который устанавливал терминал.';
  sSBRFEMsg5133 = 'Операция отклонена картой'#13'Операция невозможна. Отказать клиенту в проведении операции и посоветовать обратиться в банк.';

  sSBRFEMsg444 = 'Истек срок действия карты (СБЕРКАРТ)';
  sSBRFEMsg518 = 'На терминале установлена неверная дата';
  sSBRFEMsg572 = 'Истек срок действия карты (СБЕРКАРТ)';
  sSBRFEMsg574 = 'Карта заблокирована (СБЕРКАРТ)';
  sSBRFEMsg2004 = 'Карта заблокирована (СБЕРКАРТ)';
  sSBRFEMsg3001 = 'Недостаточно средств для загрузки на карту (СБЕРКАРТ)';
  sSBRFEMsg3002 = 'По карте клиента числится прерванная загрузка средств (СБЕРКАРТ)';
  sSBRFEMsg3019 = 'На сервере проводятся регламентные работы (СБЕРКАРТ)';
  sSBRFEMsg4103 = 'Ошибка обмена с чипом карты';
  sSBRFEMsg4140 = 'Неверно указаны сумма или код авторизации в команде SUSPEND из кассовой программы';
  sSBRFEMsg4141 = 'Невозможно выполнить команду SUSPEND: не найден файл SHCN.D';
  sSBRFEMsg4142 = 'Не удалось выполнить команду ROLLBACK из кассовой прграммы';
  sSBRFEMsg4143 = 'На терминале слишком старый стоп-лист';
  sSBRFEMsg4144 = 'Неверный формат стоп-листа на терминале (для торговли в самолете без авторизации)';
  sSBRFEMsg4152 = 'На карте нет списка транзакций (ПРО100)';
  sSBRFEMsg4153 = 'Список транзакций на карте имеет неизвестный формат (ПРО100)';
  sSBRFEMsg4154 = 'Невозможно распечатать список транзакций карты, потому что его можно считать только с чипа, а прочитана магнитная полоса (ПРО100)';
  sSBRFEMsg4155 = 'Список транзакций пуст (ПРО100)';
  sSBRFEMsg4160 = 'Неверный ответ от карты при считывании биометрических данных';
  sSBRFEMsg4161 = 'На терминале нет файла с биометрическим сертификатом BSCP.CR';
  sSBRFEMsg4162 = 'Ошибка расшифровки биометрического сертификата карты. Возможно, неверный файл BSCP.CR';
  sSBRFEMsg4165 = 'Ошибка взаимной аутентификации биосканера и карты. Возможно, неверный файл BSCP.CR';
  sSBRFEMsg4168 = 'Ошибка расшифровки шаблонов пальцев, считанных с карты';
  sSBRFEMsg4171 = 'Вответе хоста на запрос enrollment’a нет биометрической криптограммы';
  sSBRFEMsg4202 = 'Сбой при удаленной загрузке: неверное смещение в данных';
  sSBRFEMsg4301 = 'Кассовая программа передала в UPOS недопустимый тип операции';
  sSBRFEMsg4302 = 'Кассовая программа передала в UPOS недопустимый тип карты';
  sSBRFEMsg4305 = 'Ошибка инициализации библиотеки sb_kernel.dll. Кассовая программа ожидает библиотеку с более свежей версией';
  sSBRFEMsg4306 = 'Библиотека sb_kernel.dll не была инициализирована. Эта ошибка может разово возникать после обновления библиотеки через удаленную загрузку. Нужно просто повторить операцию.';
  sSBRFEMsg4308 = 'В старых версиях этим кодом обозначалась любая из проблем, которые сейчас обозначаются кодами 4331-4342';
  sSBRFEMsg4309 = 'Печатать нечего. Эта ошибка возникает в интегрированных решениях, которые выполнены не вполне корректно: в случае любой ошибки (нет связи, ПИН неверен, неверный ключ KLK и т.д.) кассовая программа все равно запрашивает у библиотеки sb_kernel.dll образ чека для печати. Поскольку по умолчанию библиотека при отказах чек не формирует, то на запрос чека она возвращает кассовой программе код 4309 – печатать нечего, нет документа для печати. Исходный код ошибки (тот, который обозначает причину отказа) кассовая программа при этом забывает';
  sSBRFEMsg4310 = 'Кассовая программа передала в UPOS недопустимый трек2';
  sSBRFEMsg4332 = 'Сверка итогов не выполнена (причина неизвестна, но печатать в итоге нечего)';
  sSBRFEMsg4333 = 'Распечатать контрольную ленту невозможно (причина неизвестна, но печатать в итоге нечего)';
  sSBRFEMsg4335 = 'Сумма не введена при операции ввода слипа';
  sSBRFEMsg4338 = 'Вызвана операция по карте СБЕРКАРТ, но прочитать карту СБЕРКАРТ не удалось';
  sSBRFEMsg4339 = 'Вызвана недопустимая операция по карте СБЕРКАРТ';
  sSBRFEMsg4340 = 'Ошибка повторного считывания карты СБЕРКАРТ';
  sSBRFEMsg4341 = 'Вызвана операция по карте СБЕРКАРТ, но вставлена карта другого типа, либо не вставлена никакая';
  sSBRFEMsg5026 = 'Ошибка проверки RSA-подписи. На терминале отсутствует (или некорректный) один из ключей из раздела «Ключи EMV»';

  sSBRFEMsgOther = 'Другая ошибка - %d';

implementation


function sbpcErrorCodeToMsg(ACode:integer):string;
begin
  case ACode of
    0:Result:='Нет ошибок';
    12:Result:=sSBRFEMsg12;
    36:Result:=sSBRFEMsg36;
    99:Result:=sSBRFEMsg99;
    101:Result:=sSBRFEMsg101;
    233:Result:=sSBRFEMsg233;
    238:Result:=sSBRFEMsg238;
    248:Result:=sSBRFEMsg248;
    249:Result:=sSBRFEMsg249;
    250:Result:=sSBRFEMsg250;
    252:Result:=sSBRFEMsg252;
    253:Result:=sSBRFEMsg253;
    361:Result:=sSBRFEMsg361;
    362:Result:=sSBRFEMsg362;
    363:Result:=sSBRFEMsg363;
    364:Result:=sSBRFEMsg364;
    402:Result:=sSBRFEMsg402;
    403:Result:=sSBRFEMsg403;
    405:Result:=sSBRFEMsg405;
    500:Result:=sSBRFEMsg500;
    505:Result:=sSBRFEMsg505;
    507:Result:=sSBRFEMsg507;
    514:Result:=sSBRFEMsg514;
    521:Result:=sSBRFEMsg521;
    561:Result:=sSBRFEMsg561;
    579:Result:=sSBRFEMsg579;
    584:Result:=sSBRFEMsg584;
    585:Result:=sSBRFEMsg585;
    586:Result:=sSBRFEMsg586;
    705:Result:=sSBRFEMsg705;
    706:Result:=sSBRFEMsg706;
    708:Result:=sSBRFEMsg708;
    709:Result:=sSBRFEMsg709;
    2000:Result:=sSBRFEMsg2000;
    2002:Result:=sSBRFEMsg2002;
    2008:Result:=sSBRFEMsg2008;
    3162:Result:=sSBRFEMsg3162;
    4073:Result:=sSBRFEMsg4073;
    4100:Result:=sSBRFEMsg4100;
    4101:Result:=sSBRFEMsg4101;
    4102:Result:=sSBRFEMsg4102;
    4106:Result:=sSBRFEMsg4106;
    4107:Result:=sSBRFEMsg4107;
    4108:Result:=sSBRFEMsg4108;
    4110:Result:=sSBRFEMsg4110;
    4111:Result:=sSBRFEMsg4111;
    4112:Result:=sSBRFEMsg4112;
    4113:Result:=sSBRFEMsg4113;
    4115:Result:=sSBRFEMsg4115;
    4116:Result:=sSBRFEMsg4116;
    4117:Result:=sSBRFEMsg4117;
    4118:Result:=sSBRFEMsg4118;
    4119:Result:=sSBRFEMsg4119;
    4120:Result:=sSBRFEMsg4120;
    4121:Result:=sSBRFEMsg4121;
    4122:Result:=sSBRFEMsg4122;
    4123:Result:=sSBRFEMsg4123;
    4124:Result:=sSBRFEMsg4124;
    4125:Result:=sSBRFEMsg4125;
    4128:Result:=sSBRFEMsg4128;
    4130:Result:=sSBRFEMsg4130;
    4131:Result:=sSBRFEMsg4131;
    4132:Result:=sSBRFEMsg4132;
    4133:Result:=sSBRFEMsg4133;
    4134:Result:=sSBRFEMsg4134;
    4135:Result:=sSBRFEMsg4135;
    4136:Result:=sSBRFEMsg4136;
    4137:Result:=sSBRFEMsg4137;
    4138:Result:=sSBRFEMsg4138;
    4139:Result:=sSBRFEMsg4139;
    4148:Result:=sSBRFEMsg4148;
    4149:Result:=sSBRFEMsg4149;
    4150:Result:=sSBRFEMsg4150;
    4151:Result:=sSBRFEMsg4151;
    4157:Result:=sSBRFEMsg4157;
    4159:Result:=sSBRFEMsg4159;
    4174:Result:=sSBRFEMsg4174;
    4175:Result:=sSBRFEMsg4175;
    4176:Result:=sSBRFEMsg4176;
    4185:Result:=sSBRFEMsg4185;
    4186:Result:=sSBRFEMsg4186;
    4187:Result:=sSBRFEMsg4187;
    4188:Result:=sSBRFEMsg4188;
    4189:Result:=sSBRFEMsg4189;
    4190:Result:=sSBRFEMsg4190;
    4203:Result:=sSBRFEMsg4203;
    4204:Result:=sSBRFEMsg4204;
    4205:Result:=sSBRFEMsg4205;
    4206:Result:=sSBRFEMsg4206;
    4207:Result:=sSBRFEMsg4207;
    4208:Result:=sSBRFEMsg4208;
    4209:Result:=sSBRFEMsg4209;
    4210:Result:=sSBRFEMsg4210;
    4211:Result:=sSBRFEMsg4211;
    4220:Result:=sSBRFEMsg4220;
    4221:Result:=sSBRFEMsg4221;
    4222:Result:=sSBRFEMsg4222;
    4300:Result:=sSBRFEMsg4300;
    4303:Result:=sSBRFEMsg4303;
    4313:Result:=sSBRFEMsg4313;
    4314:Result:=sSBRFEMsg4314;
    4315:Result:=sSBRFEMsg4315;
    4319:Result:=sSBRFEMsg4319;
    4323:Result:=sSBRFEMsg4323;
    4325:Result:=sSBRFEMsg4325;
    4326:Result:=sSBRFEMsg4326;
    4327:Result:=sSBRFEMsg4327;
    4328:Result:=sSBRFEMsg4328;
    4329:Result:=sSBRFEMsg4329;
    4330:Result:=sSBRFEMsg4330;
    4334:Result:=sSBRFEMsg4334;
    4336:Result:=sSBRFEMsg4336;
    4337:Result:=sSBRFEMsg4337;
    4342:Result:=sSBRFEMsg4342;
    4351:Result:=sSBRFEMsg4351;
    4355:Result:=sSBRFEMsg4355;
    4358:Result:=sSBRFEMsg4358;
    4362:Result:=sSBRFEMsg4362;
    4363:Result:=sSBRFEMsg4363;
    4365:Result:=sSBRFEMsg4365;
    4366:Result:=sSBRFEMsg4366;
    4367:Result:=sSBRFEMsg4367;
    4368:Result:=sSBRFEMsg4368;
    4369:Result:=sSBRFEMsg4369;
    4370:Result:=sSBRFEMsg4370;
    4371:Result:=sSBRFEMsg4371;
    4372:Result:=sSBRFEMsg4372;
    4380:Result:=sSBRFEMsg4380;
    4381:Result:=sSBRFEMsg4381;
    4382:Result:=sSBRFEMsg4382;
    4383:Result:=sSBRFEMsg4383;
    4384:Result:=sSBRFEMsg4384;
    4385:Result:=sSBRFEMsg4385;
    4388:Result:=sSBRFEMsg4388;
    4389:Result:=sSBRFEMsg4389;
    4400:Result:=sSBRFEMsg4400;
    4401:Result:=sSBRFEMsg4401;
    4402:Result:=sSBRFEMsg4402;
    4403:Result:=sSBRFEMsg4403;
    4404:Result:=sSBRFEMsg4404;
    4405:Result:=sSBRFEMsg4405;
    4406:Result:=sSBRFEMsg4406;
    4407:Result:=sSBRFEMsg4407;
    4408:Result:=sSBRFEMsg4408;
    4410:Result:=sSBRFEMsg4410;
    4411:Result:=sSBRFEMsg4411;
    4412:Result:=sSBRFEMsg4412;
    4413:Result:=sSBRFEMsg4413;
    4414:Result:=sSBRFEMsg4414;
    4419:Result:=sSBRFEMsg4419;
    4433:Result:=sSBRFEMsg4433;
    4438:Result:=sSBRFEMsg4438;
    4441:Result:=sSBRFEMsg4441;
    4443:Result:=sSBRFEMsg4443;
    4450:Result:=sSBRFEMsg4450;
    4451:Result:=sSBRFEMsg4451;
    4454:Result:=sSBRFEMsg4454;
    4455:Result:=sSBRFEMsg4455;
    4457:Result:=sSBRFEMsg4457;
    4458:Result:=sSBRFEMsg4458;
    4461:Result:=sSBRFEMsg4461;
    4462:Result:=sSBRFEMsg4462;
    4465:Result:=sSBRFEMsg4465;
    4468:Result:=sSBRFEMsg4468;
    4475:Result:=sSBRFEMsg4475;
    4476:Result:=sSBRFEMsg4476;
    4478:Result:=sSBRFEMsg4478;
    4481:Result:=sSBRFEMsg4481;
    4482:Result:=sSBRFEMsg4482;
    4483:Result:=sSBRFEMsg4483;
    4486:Result:=sSBRFEMsg4486;
    4488:Result:=sSBRFEMsg4488;
    4489:Result:=sSBRFEMsg4489;
    4490:Result:=sSBRFEMsg4490;
    4491:Result:=sSBRFEMsg4491;
    4493:Result:=sSBRFEMsg4493;
    4494:Result:=sSBRFEMsg4494;
    4495:Result:=sSBRFEMsg4495;
    4496:Result:=sSBRFEMsg4496;
    4497:Result:=sSBRFEMsg4497;
    4498:Result:=sSBRFEMsg4498;
    4499:Result:=sSBRFEMsg4499;
    4710:Result:=sSBRFEMsg4710;
    5001:Result:=sSBRFEMsg5001;
    5002:Result:=sSBRFEMsg5002;
    5003:Result:=sSBRFEMsg5003;
    5015:Result:=sSBRFEMsg5015;
    5029:Result:=sSBRFEMsg5029;
    5042:Result:=sSBRFEMsg5042;
    5044:Result:=sSBRFEMsg5044;
    5053:Result:=sSBRFEMsg5053;
    5055:Result:=sSBRFEMsg5055;
    5063:Result:=sSBRFEMsg5063;
    5075:Result:=sSBRFEMsg5075;
    5084:Result:=sSBRFEMsg5084;
    5100:Result:=sSBRFEMsg5100;
    5101:Result:=sSBRFEMsg5101;
    5102:Result:=sSBRFEMsg5102;
    5103:Result:=sSBRFEMsg5103;
    5104:Result:=sSBRFEMsg5104;
    5105:Result:=sSBRFEMsg5105;
    5108:Result:=sSBRFEMsg5108;
    5109:Result:=sSBRFEMsg5109;
    5110:Result:=sSBRFEMsg5110;
    5111:Result:=sSBRFEMsg5111;
    5112:Result:=sSBRFEMsg5112;
    5116:Result:=sSBRFEMsg5116;
    5117:Result:=sSBRFEMsg5117;
    5118:Result:=sSBRFEMsg5118;
    5119:Result:=sSBRFEMsg5119;
    5120:Result:=sSBRFEMsg5120;
    5124:Result:=sSBRFEMsg5124;
    5125:Result:=sSBRFEMsg5125;
    5126:Result:=sSBRFEMsg5126;
    5133:Result:=sSBRFEMsg5133;

    444:Result:=sSBRFEMsg444;
    518:Result:=sSBRFEMsg518;
    572:Result:=sSBRFEMsg572;
    574:Result:=sSBRFEMsg574;
    2004:Result:=sSBRFEMsg2004;
    3001:Result:=sSBRFEMsg3001;
    3002:Result:=sSBRFEMsg3002;
    3019:Result:=sSBRFEMsg3019;
    4103:Result:=sSBRFEMsg4103;
    4140:Result:=sSBRFEMsg4140;
    4141:Result:=sSBRFEMsg4141;
    4142:Result:=sSBRFEMsg4142;
    4143:Result:=sSBRFEMsg4143;
    4144:Result:=sSBRFEMsg4144;
    4152:Result:=sSBRFEMsg4152;
    4153:Result:=sSBRFEMsg4153;
    4154:Result:=sSBRFEMsg4154;
    4155:Result:=sSBRFEMsg4155;
    4160:Result:=sSBRFEMsg4160;
    4161:Result:=sSBRFEMsg4161;
    4162:Result:=sSBRFEMsg4162;
    4165:Result:=sSBRFEMsg4165;
    4168:Result:=sSBRFEMsg4168;
    4171:Result:=sSBRFEMsg4171;
    4202:Result:=sSBRFEMsg4202;
    4301:Result:=sSBRFEMsg4301;
    4302:Result:=sSBRFEMsg4302;
    4305:Result:=sSBRFEMsg4305;
    4306:Result:=sSBRFEMsg4306;
    4308:Result:=sSBRFEMsg4308;
    4309:Result:=sSBRFEMsg4309;
    4310:Result:=sSBRFEMsg4310;
    4332:Result:=sSBRFEMsg4332;
    4333:Result:=sSBRFEMsg4333;
    4335:Result:=sSBRFEMsg4335;
    4338:Result:=sSBRFEMsg4338;
    4339:Result:=sSBRFEMsg4339;
    4340:Result:=sSBRFEMsg4340;
    4341:Result:=sSBRFEMsg4341;
    5026:Result:=sSBRFEMsg5026;
  else
    Result:=Format(sSBRFEMsgOther, [ACode]);
  end;
end;


end.

