//Интерфейс универсального драйвера к ККМ АТОЛ
//Версия 10.6.2.0
//Исходный файл libfptr10.h
//Версия для FPC - Лагунов А.А. (c) alexs, 2018-2020
// alexs75@yandex.ru

unit libfptr10;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

const
  {$IFDEF WINDOWS}
  slibFPPtr10FileName = 'fptr10.dll';
  aFirstStrChar = 1;
  {$ENDIF}
  {$IFDEF LINUX}
  slibFPPtr10FileName = 'libfptr10.so';
  aFirstStrChar = 0;
  {$ENDIF}

  atolAPIVersion = '10.6.2.0';
type
  PWchar_t = Pointer;
  {$IFDEF WINDOWS}
  TAtollWideString = WideString;
  {$ENDIF}
  {$IFDEF LINUX}
  TAtollWideString = UCS4String;
  {$ENDIF}

(*
#ifndef ATOL_DTOX_FPTR_H
#define ATOL_DTOX_FPTR_H

#if defined(_WIN32) || defined(_WIN32_WCE)
#  if defined(DTOX_LIBRARY)
#    define DTOX_SHARED_EXPORT __declspec(dllexport)
#  else
#    define DTOX_SHARED_EXPORT __declspec(dllimport)
#  endif
#  define DTOX_SHARED_CCA __cdecl
#elif defined(__linux__) || defined(ANDROID)
#  if __GNUC__ >= 4
#    define DTOX_SHARED_EXPORT __attribute__((visibility("default")))
#  else
#    define DTOX_SHARED_EXPORT
#  endif
#  define DTOX_SHARED_CCA
#elif defined(__APPLE__)
#  define DTOX_SHARED_EXPORT __attribute__((visibility("default")))
#  define DTOX_SHARED_CCA
#else
#  define DTOX_SHARED_EXPORT
#  define DTOX_SHARED_CCA __attribute__ ((cdecl))
#endif

#ifndef uchar
typedef unsigned char uchar;
#endif

#ifndef uint
typedef unsigned int uint;
#endif
*)
type
  libfptr_handle = Pointer;
  TLibFPtrHandle = libfptr_handle;
  PLibFPtrHandle = ^TLibFPtrHandle;

(*
#ifdef __cplusplus
extern "C"
{
#endif
*)

  libfptr_error = (
    LIBFPTR_OK = 0,
    LIBFPTR_ERROR_CONNECTION_DISABLED,
    LIBFPTR_ERROR_NO_CONNECTION,
    LIBFPTR_ERROR_PORT_BUSY,
    LIBFPTR_ERROR_PORT_NOT_AVAILABLE,
    LIBFPTR_ERROR_INCORRECT_DATA,
    LIBFPTR_ERROR_INTERNAL,
    LIBFPTR_ERROR_UNSUPPORTED_CAST,
    LIBFPTR_ERROR_NO_REQUIRED_PARAM,
    LIBFPTR_ERROR_INVALID_SETTINGS,
    LIBFPTR_ERROR_NOT_CONFIGURED,
    LIBFPTR_ERROR_NOT_SUPPORTED,
    LIBFPTR_ERROR_INVALID_MODE,
    LIBFPTR_ERROR_INVALID_PARAM,
    LIBFPTR_ERROR_NOT_LOADED,
    LIBFPTR_ERROR_UNKNOWN,

    LIBFPTR_ERROR_INVALID_SUM,
    LIBFPTR_ERROR_INVALID_QUANTITY,
    LIBFPTR_ERROR_CASH_COUNTER_OVERFLOW,
    LIBFPTR_ERROR_LAST_OPERATION_STORNO_DENIED,
    LIBFPTR_ERROR_STORNO_BY_CODE_DENIED,
    LIBFPTR_ERROR_LAST_OPERATION_NOT_REPEATABLE,
    LIBFPTR_ERROR_DISCOUNT_NOT_REPEATABLE,
    LIBFPTR_ERROR_DISCOUNT_DENIED,
    LIBFPTR_ERROR_INVALID_COMMODITY_CODE,
    LIBFPTR_ERROR_INVALID_COMMODITY_BARCODE,
    LIBFPTR_ERROR_INVALID_COMMAND_FORMAT,
    LIBFPTR_ERROR_INVALID_COMMAND_LENGTH,
    LIBFPTR_ERROR_BLOCKED_IN_DATE_INPUT_MODE,
    LIBFPTR_ERROR_NEED_DATE_ACCEPT,
    LIBFPTR_ERROR_NO_MORE_DATA,
    LIBFPTR_ERROR_NO_ACCEPT_OR_CANCEL,
    LIBFPTR_ERROR_BLOCKED_BY_REPORT_INTERRUPTION,
    LIBFPTR_ERROR_DISABLE_CASH_CONTROL_DENIED,
    LIBFPTR_ERROR_MODE_BLOCKED,
    LIBFPTR_ERROR_CHECK_DATE_TIME,
    LIBFPTR_ERROR_DATE_TIME_LESS_THAN_FS,
    LIBFPTR_ERROR_CLOSE_ARCHIVE_DENIED,
    LIBFPTR_ERROR_COMMODITY_NOT_FOUND,
    LIBFPTR_ERROR_WEIGHT_BARCODE_WITH_INVALID_QUANTITY,
    LIBFPTR_ERROR_RECEIPT_BUFFER_OVERFLOW,
    LIBFPTR_ERROR_QUANTITY_TOO_FEW,
    LIBFPTR_ERROR_STORNO_TOO_MUCH,
    LIBFPTR_ERROR_BLOCKED_COMMODITY_NOT_FOUND,
    LIBFPTR_ERROR_NO_PAPER,
    LIBFPTR_ERROR_COVER_OPENED,
    LIBFPTR_ERROR_PRINTER_FAULT,
    LIBFPTR_ERROR_MECHANICAL_FAULT,
    LIBFPTR_ERROR_INVALID_RECEIPT_TYPE,
    LIBFPTR_ERROR_INVALID_UNIT_TYPE,
    LIBFPTR_ERROR_NO_MEMORY,
    LIBFPTR_ERROR_PICTURE_NOT_FOUND,
    LIBFPTR_ERROR_NONCACH_PAYMENTS_TOO_MUCH,
    LIBFPTR_ERROR_RETURN_DENIED,
    LIBFPTR_ERROR_PAYMENTS_OVERFLOW,
    LIBFPTR_ERROR_BUSY,
    LIBFPTR_ERROR_GSM,
    LIBFPTR_ERROR_INVALID_DISCOUNT,
    LIBFPTR_ERROR_OPERATION_AFTER_DISCOUNT_DENIED,
    LIBFPTR_ERROR_INVALID_DEPARTMENT,
    LIBFPTR_ERROR_INVALID_PAYMENT_TYPE,
    LIBFPTR_ERROR_MULTIPLICATION_OVERFLOW,
    LIBFPTR_ERROR_DENIED_BY_SETTINGS,
    LIBFPTR_ERROR_TOTAL_OVERFLOW,
    LIBFPTR_ERROR_DENIED_IN_ANNULATION_RECEIPT,
    LIBFPTR_ERROR_JOURNAL_OVERFLOW,
    LIBFPTR_ERROR_NOT_FULLY_PAID,
    LIBFPTR_ERROR_DENIED_IN_RETURN_RECEIPT,
    LIBFPTR_ERROR_SHIFT_EXPIRED,
    LIBFPTR_ERROR_DENIED_IN_SELL_RECEIPT,
    LIBFPTR_ERROR_FISCAL_MEMORY_OVERFLOW,
    LIBFPTR_ERROR_INVALID_PASSWORD,
    LIBFPTR_ERROR_JOURNAL_BUSY,
    LIBFPTR_ERROR_DENIED_IN_CLOSED_SHIFT,
    LIBFPTR_ERROR_INVALID_TABLE_NUMBER,
    LIBFPTR_ERROR_INVALID_ROW_NUMBER,
    LIBFPTR_ERROR_INVALID_FIELD_NUMBER,
    LIBFPTR_ERROR_INVALID_DATE_TIME,
    LIBFPTR_ERROR_INVALID_STORNO_SUM,
    LIBFPTR_ERROR_CHANGE_CALCULATION,
    LIBFPTR_ERROR_NO_CASH,
    LIBFPTR_ERROR_DENIED_IN_CLOSED_RECEIPT,
    LIBFPTR_ERROR_DENIED_IN_OPENED_RECEIPT,
    LIBFPTR_ERROR_DENIED_IN_OPENED_SHIFT,
    LIBFPTR_ERROR_SERIAL_NUMBER_ALREADY_ENTERED,
    LIBFPTR_ERROR_TOO_MUCH_REREGISTRATIONS,
    LIBFPTR_ERROR_INVALID_SHIFT_NUMBER,
    LIBFPTR_ERROR_INVALID_SERIAL_NUMBER,
    LIBFPTR_ERROR_INVALID_RNM_VATIN,
    LIBFPTR_ERROR_FISCAL_PRINTER_NOT_ACTIVATED,
    LIBFPTR_ERROR_SERIAL_NUMBER_NOT_ENTERED,
    LIBFPTR_ERROR_NO_MORE_REPORTS,
    LIBFPTR_ERROR_MODE_NOT_ACTIVATED,
    LIBFPTR_ERROR_RECORD_NOT_FOUND_IN_JOURNAL,
    LIBFPTR_ERROR_INVALID_LICENSE,
    LIBFPTR_ERROR_NEED_FULL_RESET,
    LIBFPTR_ERROR_DENIED_BY_LICENSE,
    LIBFPTR_ERROR_DISCOUNT_CANCELLATION_DENIED,
    LIBFPTR_ERROR_CLOSE_RECEIPT_DENIED,
    LIBFPTR_ERROR_INVALID_ROUTE_NUMBER,
    LIBFPTR_ERROR_INVALID_START_ZONE_NUMBER,
    LIBFPTR_ERROR_INVALID_END_ZONE_NUMBER,
    LIBFPTR_ERROR_INVALID_RATE_TYPE,
    LIBFPTR_ERROR_INVALID_RATE,
    LIBFPTR_ERROR_FISCAL_MODULE_EXCHANGE,
    LIBFPTR_ERROR_NEED_TECHNICAL_SUPPORT,
    LIBFPTR_ERROR_SHIFT_NUMBERS_DID_NOT_MATCH,
    LIBFPTR_ERROR_DEVICE_NOT_FOUND,
    LIBFPTR_ERROR_EXTERNAL_DEVICE_CONNECTION,
    LIBFPTR_ERROR_DISPENSER_INVALID_STATE,
    LIBFPTR_ERROR_INVALID_POSITIONS_COUNT,
    LIBFPTR_ERROR_DISPENSER_INVALID_NUMBER,
    LIBFPTR_ERROR_INVALID_DIVIDER,
    LIBFPTR_ERROR_FN_ACTIVATION_DENIED,
    LIBFPTR_ERROR_PRINTER_OVERHEAT,
    LIBFPTR_ERROR_FN_EXCHANGE,
    LIBFPTR_ERROR_FN_INVALID_FORMAT,
    LIBFPTR_ERROR_FN_INVALID_STATE,
    LIBFPTR_ERROR_FN_FAULT,
    LIBFPTR_ERROR_FN_CRYPTO_FAULT,
    LIBFPTR_ERROR_FN_EXPIRED,
    LIBFPTR_ERROR_FN_OVERFLOW,
    LIBFPTR_ERROR_FN_INVALID_DATE_TIME,
    LIBFPTR_ERROR_FN_NO_MORE_DATA,
    LIBFPTR_ERROR_FN_TOTAL_OVERFLOW,
    LIBFPTR_ERROR_BUFFER_OVERFLOW,
    LIBFPTR_ERROR_PRINT_SECOND_COPY_DENIED,
    LIBFPTR_ERROR_NEED_RESET_JOURNAL,
    LIBFPTR_ERROR_TAX_SUM_TOO_MUCH,
    LIBFPTR_ERROR_TAX_ON_LAST_OPERATION_DENIED,
    LIBFPTR_ERROR_INVALID_FN_NUMBER,
    LIBFPTR_ERROR_TAX_CANCEL_DENIED,
    LIBFPTR_ERROR_LOW_BATTERY,
    LIBFPTR_ERROR_FN_INVALID_COMMAND,
    LIBFPTR_ERROR_FN_COMMAND_OVERFLOW,
    LIBFPTR_ERROR_FN_NO_TRANSPORT_CONNECTION,
    LIBFPTR_ERROR_FN_CRYPTO_HAS_EXPIRED,
    LIBFPTR_ERROR_FN_RESOURCE_HAS_EXPIRED,
    LIBFPTR_ERROR_INVALID_MESSAGE_FROM_OFD,
    LIBFPTR_ERROR_FN_HAS_NOT_SEND_DOCUMENTS,
    LIBFPTR_ERROR_FN_TIMEOUT,
    LIBFPTR_ERROR_FN_SHIFT_EXPIRED,
    LIBFPTR_ERROR_FN_INVALID_TIME_DIFFERENCE,
    LIBFPTR_ERROR_INVALID_TAXATION_TYPE,
    LIBFPTR_ERROR_INVALID_TAX_TYPE,
    LIBFPTR_ERROR_INVALID_COMMODITY_PAYMENT_TYPE,
    LIBFPTR_ERROR_INVALID_COMMODITY_CODE_TYPE,
    LIBFPTR_ERROR_EXCISABLE_COMMODITY_DENIED,
    LIBFPTR_ERROR_FISCAL_PROPERTY_WRITE,
    LIBFPTR_ERROR_INVALID_COUNTER_TYPE,
    LIBFPTR_ERROR_CUTTER_FAULT,
    LIBFPTR_ERROR_REPORT_INTERRUPTED,
    LIBFPTR_ERROR_INVALID_LEFT_MARGIN,
    LIBFPTR_ERROR_INVALID_ALIGNMENT,
    LIBFPTR_ERROR_INVALID_TAX_MODE,
    LIBFPTR_ERROR_FILE_NOT_FOUND,
    LIBFPTR_ERROR_PICTURE_TOO_BIG,
    LIBFPTR_ERROR_INVALID_BARCODE_PARAMS,
    LIBFPTR_ERROR_FISCAL_PROPERTY_DENIED,
    LIBFPTR_ERROR_FN_INTERFACE,
    LIBFPTR_ERROR_DATA_DUPLICATE,
    LIBFPTR_ERROR_NO_REQUIRED_FISCAL_PROPERTY,
    LIBFPTR_ERROR_FN_READ_DOCUMENT,
    LIBFPTR_ERROR_FLOAT_OVERFLOW,
    LIBFPTR_ERROR_INVALID_SETTING_VALUE,
    LIBFPTR_ERROR_HARD_FAULT,
    LIBFPTR_ERROR_FN_NOT_FOUND,
    LIBFPTR_ERROR_INVALID_AGENT_FISCAL_PROPERTY,
    LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1002_1056,
    LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1002_1017,
    LIBFPTR_ERROR_SCRIPT,
    LIBFPTR_ERROR_INVALID_USER_MEMORY_INDEX,
    LIBFPTR_ERROR_NO_ACTIVE_OPERATOR,
    LIBFPTR_ERROR_REGISTRATION_REPORT_INTERRUPTED,
    LIBFPTR_ERROR_CLOSE_FN_REPORT_INTERRUPTED,
    LIBFPTR_ERROR_OPEN_SHIFT_REPORT_INTERRUPTED,
    LIBFPTR_ERROR_OFD_EXCHANGE_REPORT_INTERRUPTED,
    LIBFPTR_ERROR_CLOSE_RECEIPT_INTERRUPTED,
    LIBFPTR_ERROR_FN_QUERY_INTERRUPTED,
    LIBFPTR_ERROR_RTC_FAULT,
    LIBFPTR_ERROR_MEMORY_FAULT,
    LIBFPTR_ERROR_CHIP_FAULT,
    LIBFPTR_ERROR_TEMPLATES_CORRUPTED,
    LIBFPTR_ERROR_INVALID_MAC_ADDRESS,
    LIBFPTR_ERROR_INVALID_SCRIPT_NUMBER,
    LIBFPTR_ERROR_SCRIPTS_FAULT,
    LIBFPTR_ERROR_INVALID_SCRIPTS_VERSION,
    LIBFPTR_ERROR_INVALID_CLICHE_FORMAT,
    LIBFPTR_ERROR_WAIT_FOR_REBOOT,
    LIBFPTR_ERROR_NO_LICENSE,
    LIBFPTR_ERROR_INVALID_FFD_VERSION,
    LIBFPTR_ERROR_CHANGE_SETTING_DENIED,
    LIBFPTR_ERROR_INVALID_NOMENCLATURE_TYPE,
    LIBFPTR_ERROR_INVALID_GTIN,
    LIBFPTR_ERROR_NEGATIVE_MATH_RESULT,
    LIBFPTR_ERROR_FISCAL_PROPERTIES_COMBINATION,
    LIBFPTR_ERROR_OPERATOR_LOGIN,
    LIBFPTR_ERROR_INVALID_INTERNET_CHANNEL,
    LIBFPTR_ERROR_DATETIME_NOT_SYNCRONIZED,
    LIBFPTR_ERROR_JOURNAL,
    LIBFPTR_ERROR_DENIED_IN_OPENED_DOC,
    LIBFPTR_ERROR_DENIED_IN_CLOSED_DOC,
    LIBFPTR_ERROR_LICENSE_MEMORY_OVERFLOW,
    LIBFPTR_ERROR_NEED_CANCEL_DOCUMENT,
    LIBFPTR_ERROR_REGISTERS_NOT_INITIALIZED,
    LIBFPTR_ERROR_TOTAL_REQUIRED,
    LIBFPTR_ERROR_SETTINGS_FAULT,
    LIBFPTR_ERROR_COUNTERS_FAULT,
    LIBFPTR_ERROR_USER_MEMORY_FAULT,
    LIBFPTR_ERROR_SERVICE_COUNTERS_FAULT,
    LIBFPTR_ERROR_ATTRIBUTES_FAULT,
    LIBFPTR_ERROR_ALREADY_IN_UPDATE_MODE,
    LIBFPTR_ERROR_INVALID_FIRMWARE,
    LIBFPTR_ERROR_INVALID_CHANNEL,
    LIBFPTR_ERROR_INTERFACE_DOWN,
    LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1212_1030,
    LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1214,
    LIBFPTR_ERROR_INVALID_FISCAL_PROPERTY_VALUE_1212,
    LIBFPTR_ERROR_SYNC_TIME,
    LIBFPTR_ERROR_VAT18_VAT20_IN_RECEIPT,
    LIBFPTR_ERROR_PICTURE_NOT_CLOSED,
    LIBFPTR_ERROR_INTERFACE_BUSY,
    LIBFPTR_ERROR_INVALID_PICTURE_NUMBER,
    LIBFPTR_ERROR_INVALID_CONTAINER,
    LIBFPTR_ERROR_ARCHIVE_CLOSED,
    LIBFPTR_ERROR_NEED_REGISTRATION,
    LIBFPTR_ERROR_DENIED_DURING_UPDATE,
    LIBFPTR_ERROR_INVALID_TOTAL,
    LIBFPTR_ERROR_MARKING_CODE_CONFLICT,
    LIBFPTR_ERROR_INVALID_RECORDS_ID,
    LIBFPTR_ERROR_INVALID_SIGNATURE,
    LIBFPTR_ERROR_INVALID_EXCISE_SUM,
    LIBFPTR_ERROR_NO_DOCUMENTS_FOUND_IN_JOURNAL,
    LIBFPTR_ERROR_INVALID_SCRIPT_TYPE,
    LIBFPTR_ERROR_INVALID_SCRIPT_NAME,
    LIBFPTR_ERROR_INVALID_POSITIONS_COUNT_WITH_1162,
    LIBFPTR_ERROR_INVALID_UC_COUNTER,
    LIBFPTR_ERROR_INVALID_UC_TAG,
    LIBFPTR_ERROR_INVALID_UC_IDX,
    LIBFPTR_ERROR_INVALID_UC_SIZE,
    LIBFPTR_ERROR_INVALID_UC_CONFIG,
    LIBFPTR_ERROR_CONNECTION_LOST,
    LIBFPTR_ERROR_UNIVERSAL_COUNTERS_FAULT,
    LIBFPTR_ERROR_INVALID_TAX_SUM,
    LIBFPTR_ERROR_INVALID_MARKING_CODE_TYPE,
    LIBFPTR_ERROR_LICENSE_HARD_FAULT,
    LIBFPTR_ERROR_LICENSE_INVALID_SIGN,
    LIBFPTR_ERROR_LICENSE_INVALID_SERIAL,
    LIBFPTR_ERROR_LICENSE_INVALID_TIME,
    LIBFPTR_ERROR_DOCUMENT_CANCELED,
    LIBFPTR_ERROR_INVALID_SCRIPT_PARAMS,
    LIBFPTR_ERROR_CLICHE_TOO_LONG,

    LIBFPTR_ERROR_BASE_WEB = 500,
    LIBFPTR_ERROR_RECEIPT_PARSE_ERROR,
    LIBFPTR_ERROR_INTERRUPTED_BY_PREVIOUS_ERRORS,
    LIBFPTR_ERROR_DRIVER_SCRIPT_ERROR,
    LIBFPTR_ERROR_VALIDATE_FUNC_NOT_FOUND,
    LIBFPTR_ERROR_WEB_FAIL,
    LIBFPTR_ERROR_WEB_END = 599,

    LIBFPTR_ERROR_USERS_SCRIPTS_BASE = 1000,
    LIBFPTR_ERROR_USERS_SCRIPTS_END = 1999
  );

  TLibFPtr_Error = libfptr_error;

  libfptr_param = (
    LIBFPTR_PARAM_FIRST = 65536,
    LIBFPTR_PARAM_TEXT = LIBFPTR_PARAM_FIRST,
    LIBFPTR_PARAM_TEXT_WRAP,
    LIBFPTR_PARAM_ALIGNMENT,

    LIBFPTR_PARAM_FONT,
    LIBFPTR_PARAM_FONT_DOUBLE_WIDTH,
    LIBFPTR_PARAM_FONT_DOUBLE_HEIGHT,
    LIBFPTR_PARAM_LINESPACING,
    LIBFPTR_PARAM_BRIGHTNESS,

    LIBFPTR_PARAM_MODEL,
    LIBFPTR_PARAM_RECEIPT_TYPE,
    LIBFPTR_PARAM_REPORT_TYPE,
    LIBFPTR_PARAM_MODE,
    LIBFPTR_PARAM_EXTERNAL_DEVICE_TYPE,
    LIBFPTR_PARAM_EXTERNAL_DEVICE_DATA,
    LIBFPTR_PARAM_FREQUENCY,
    LIBFPTR_PARAM_DURATION,
    LIBFPTR_PARAM_CUT_TYPE,
    LIBFPTR_PARAM_DRAWER_ON_TIMEOUT,
    LIBFPTR_PARAM_DRAWER_OFF_TIMEOUT,
    LIBFPTR_PARAM_DRAWER_ON_QUANTITY,
    LIBFPTR_PARAM_TIMEOUT_ENQ,
    LIBFPTR_PARAM_COMMAND_BUFFER,
    LIBFPTR_PARAM_ANSWER_BUFFER,
    LIBFPTR_PARAM_SERIAL_NUMBER,
    LIBFPTR_PARAM_MANUFACTURER_CODE,
    LIBFPTR_PARAM_NO_NEED_ANSWER,
    LIBFPTR_PARAM_INFO_DISCOUNT_SUM,
    LIBFPTR_PARAM_USE_ONLY_TAX_TYPE,
    LIBFPTR_PARAM_PAYMENT_TYPE,
    LIBFPTR_PARAM_PAYMENT_SUM,
    LIBFPTR_PARAM_REMAINDER,
    LIBFPTR_PARAM_CHANGE,
    LIBFPTR_PARAM_DEPARTMENT,
    LIBFPTR_PARAM_TAX_TYPE,
    LIBFPTR_PARAM_TAX_SUM,
    LIBFPTR_PARAM_TAX_MODE,
    LIBFPTR_PARAM_RECEIPT_ELECTRONICALLY,
    LIBFPTR_PARAM_USER_PASSWORD,
    LIBFPTR_PARAM_SCALE,
    LIBFPTR_PARAM_LEFT_MARGIN,
    LIBFPTR_PARAM_BARCODE,
    LIBFPTR_PARAM_BARCODE_TYPE,
    LIBFPTR_PARAM_BARCODE_PRINT_TEXT,
    LIBFPTR_PARAM_BARCODE_VERSION,
    LIBFPTR_PARAM_BARCODE_CORRECTION,
    LIBFPTR_PARAM_BARCODE_COLUMNS,
    LIBFPTR_PARAM_BARCODE_INVERT,
    LIBFPTR_PARAM_HEIGHT,
    LIBFPTR_PARAM_WIDTH,
    LIBFPTR_PARAM_FILENAME,
    LIBFPTR_PARAM_PICTURE_NUMBER,
    LIBFPTR_PARAM_DATA_TYPE,
    LIBFPTR_PARAM_OPERATOR_ID,
    LIBFPTR_PARAM_LOGICAL_NUMBER,
    LIBFPTR_PARAM_DATE_TIME,
    LIBFPTR_PARAM_FISCAL,
    LIBFPTR_PARAM_SHIFT_STATE,
    LIBFPTR_PARAM_CASHDRAWER_OPENED,
    LIBFPTR_PARAM_RECEIPT_PAPER_PRESENT,
    LIBFPTR_PARAM_COVER_OPENED,
    LIBFPTR_PARAM_SUBMODE,
    LIBFPTR_PARAM_RECEIPT_NUMBER,
    LIBFPTR_PARAM_DOCUMENT_NUMBER,
    LIBFPTR_PARAM_SHIFT_NUMBER,
    LIBFPTR_PARAM_RECEIPT_SUM,
    LIBFPTR_PARAM_RECEIPT_LINE_LENGTH,
    LIBFPTR_PARAM_RECEIPT_LINE_LENGTH_PIX,
    LIBFPTR_PARAM_MODEL_NAME,
    LIBFPTR_PARAM_UNIT_VERSION,
    LIBFPTR_PARAM_PRINTER_CONNECTION_LOST,
    LIBFPTR_PARAM_PRINTER_ERROR,
    LIBFPTR_PARAM_CUT_ERROR,
    LIBFPTR_PARAM_PRINTER_OVERHEAT,
    LIBFPTR_PARAM_UNIT_TYPE,
    LIBFPTR_PARAM_LICENSE_NUMBER,
    LIBFPTR_PARAM_LICENSE_ENTERED,
    LIBFPTR_PARAM_LICENSE,
    LIBFPTR_PARAM_SUM,
    LIBFPTR_PARAM_COUNT,
    LIBFPTR_PARAM_COUNTER_TYPE,
    LIBFPTR_PARAM_STEP_COUNTER_TYPE,
    LIBFPTR_PARAM_ERROR_TAG_NUMBER,
    LIBFPTR_PARAM_TABLE,
    LIBFPTR_PARAM_ROW,
    LIBFPTR_PARAM_FIELD,
    LIBFPTR_PARAM_FIELD_VALUE,
    LIBFPTR_PARAM_FN_DATA_TYPE,
    LIBFPTR_PARAM_TAG_NUMBER,
    LIBFPTR_PARAM_TAG_VALUE,
    LIBFPTR_PARAM_DOCUMENTS_COUNT,
    LIBFPTR_PARAM_FISCAL_SIGN,
    LIBFPTR_PARAM_DEVICE_FFD_VERSION,
    LIBFPTR_PARAM_FN_FFD_VERSION,
    LIBFPTR_PARAM_FFD_VERSION,
    LIBFPTR_PARAM_CHECK_SUM,
    LIBFPTR_PARAM_COMMODITY_NAME,
    LIBFPTR_PARAM_PRICE,
    LIBFPTR_PARAM_QUANTITY,
    LIBFPTR_PARAM_POSITION_SUM,
    LIBFPTR_PARAM_FN_TYPE,
    LIBFPTR_PARAM_FN_VERSION,
    LIBFPTR_PARAM_REGISTRATIONS_REMAIN,
    LIBFPTR_PARAM_REGISTRATIONS_COUNT,
    LIBFPTR_PARAM_NO_ERROR_IF_NOT_SUPPORTED,
    LIBFPTR_PARAM_OFD_EXCHANGE_STATUS,
    LIBFPTR_PARAM_FN_ERROR_DATA,
    LIBFPTR_PARAM_FN_ERROR_CODE,
    LIBFPTR_PARAM_ENVD_MODE,
    LIBFPTR_PARAM_DOCUMENT_CLOSED,
    LIBFPTR_PARAM_JSON_DATA,
    LIBFPTR_PARAM_COMMAND_SUBSYSTEM,
    LIBFPTR_PARAM_FN_OPERATION_TYPE,
    LIBFPTR_PARAM_FN_STATE,
    LIBFPTR_PARAM_ENVD_MODE_ENABLED,
    LIBFPTR_PARAM_SETTING_ID,
    LIBFPTR_PARAM_SETTING_VALUE,
    LIBFPTR_PARAM_MAPPING_KEY,
    LIBFPTR_PARAM_MAPPING_VALUE,
    LIBFPTR_PARAM_COMMODITY_PIECE,
    LIBFPTR_PARAM_POWER_SOURCE_TYPE,
    LIBFPTR_PARAM_BATTERY_CHARGE,
    LIBFPTR_PARAM_VOLTAGE,
    LIBFPTR_PARAM_USE_BATTERY,
    LIBFPTR_PARAM_BATTERY_CHARGING,
    LIBFPTR_PARAM_CAN_PRINT_WHILE_ON_BATTERY,
    LIBFPTR_PARAM_MAC_ADDRESS,
    LIBFPTR_PARAM_FN_FISCAL,
    LIBFPTR_PARAM_NETWORK_ERROR,
    LIBFPTR_PARAM_OFD_ERROR,
    LIBFPTR_PARAM_FN_ERROR,
    LIBFPTR_PARAM_COMMAND_CODE,
    LIBFPTR_PARAM_PRINTER_TEMPERATURE,
    LIBFPTR_PARAM_RECORDS_TYPE,
    LIBFPTR_PARAM_OFD_FISCAL_SIGN,
    LIBFPTR_PARAM_HAS_OFD_TICKET,
    LIBFPTR_PARAM_NO_SERIAL_NUMBER,
    LIBFPTR_PARAM_RTC_FAULT,
    LIBFPTR_PARAM_SETTINGS_FAULT,
    LIBFPTR_PARAM_COUNTERS_FAULT,
    LIBFPTR_PARAM_USER_MEMORY_FAULT,
    LIBFPTR_PARAM_SERVICE_COUNTERS_FAULT,
    LIBFPTR_PARAM_ATTRIBUTES_FAULT,
    LIBFPTR_PARAM_FN_FAULT,
    LIBFPTR_PARAM_INVALID_FN,
    LIBFPTR_PARAM_HARD_FAULT,
    LIBFPTR_PARAM_MEMORY_MANAGER_FAULT,
    LIBFPTR_PARAM_SCRIPTS_FAULT,
    LIBFPTR_PARAM_FULL_RESET,
    LIBFPTR_PARAM_WAIT_FOR_REBOOT,
    LIBFPTR_PARAM_SCALE_PERCENT,
    LIBFPTR_PARAM_FN_NEED_REPLACEMENT,
    LIBFPTR_PARAM_FN_RESOURCE_EXHAUSTED,
    LIBFPTR_PARAM_FN_MEMORY_OVERFLOW,
    LIBFPTR_PARAM_FN_OFD_TIMEOUT,
    LIBFPTR_PARAM_FN_CRITICAL_ERROR,
    LIBFPTR_PARAM_OFD_MESSAGE_READ,
    LIBFPTR_PARAM_DEVICE_MIN_FFD_VERSION,
    LIBFPTR_PARAM_DEVICE_MAX_FFD_VERSION,
    LIBFPTR_PARAM_DEVICE_UPTIME,
    LIBFPTR_PARAM_NOMENCLATURE_TYPE,
    LIBFPTR_PARAM_GTIN,
    LIBFPTR_PARAM_FN_DOCUMENT_TYPE,
    LIBFPTR_PARAM_NETWORK_ERROR_TEXT,
    LIBFPTR_PARAM_FN_ERROR_TEXT,
    LIBFPTR_PARAM_OFD_ERROR_TEXT,
    LIBFPTR_PARAM_USER_SCRIPT_ID,
    LIBFPTR_PARAM_USER_SCRIPT_PARAMETER,
    LIBFPTR_PARAM_USER_MEMORY_OPERATION,
    LIBFPTR_PARAM_USER_MEMORY_DATA,
    LIBFPTR_PARAM_USER_MEMORY_STRING,
    LIBFPTR_PARAM_USER_MEMORY_ADDRESS,
    LIBFPTR_PARAM_FN_PRESENT,
    LIBFPTR_PARAM_BLOCKED,
    LIBFPTR_PARAM_DOCUMENT_PRINTED,
    LIBFPTR_PARAM_DISCOUNT_SUM,
    LIBFPTR_PARAM_SURCHARGE_SUM,
    LIBFPTR_PARAM_LK_USER_CODE,
    LIBFPTR_PARAM_LICENSE_COUNT,
    LIBFPTR_PARAM_DEFER,
    LIBFPTR_PARAM_CAP_54FZ,
    LIBFPTR_PARAM_CAP_MANUAL_CLICHE_CONTROL,
    LIBFPTR_PARAM_CAP_PAYMENTS_COUNT,
    LIBFPTR_PARAM_FIRMWARE_CHUNK_SIZE,
    LIBFPTR_PARAM_FIRMWARE_CHUNK_DATA,
    LIBFPTR_PARAM_FN_FLAGS,
    LIBFPTR_PARAM_PRINT_FOOTER,
    LIBFPTR_PARAM_PUBLIC_KEY,
    LIBFPTR_PARAM_MAGIC_NUMBER,
    LIBFPTR_PARAM_SIGN,
    LIBFPTR_PARAM_SOFT_NAME,
    LIBFPTR_PARAM_SESSION_CODE,
    LIBFPTR_PARAM_ETHERNET_CONFIG_TIMEOUT,
    LIBFPTR_PARAM_ETHERNET_DHCP,
    LIBFPTR_PARAM_ETHERNET_IP,
    LIBFPTR_PARAM_ETHERNET_MASK,
    LIBFPTR_PARAM_ETHERNET_GATEWAY,
    LIBFPTR_PARAM_ETHERNET_PORT,
    LIBFPTR_PARAM_ETHERNET_DNS_IP,
    LIBFPTR_PARAM_ETHERNET_DNS_STATIC,
    LIBFPTR_PARAM_STORE_IN_JOURNAL,
    LIBFPTR_PARAM_NEW_PLATFORM,
    LIBFPTR_PARAM_UNIT_RELEASE_VERSION,
    LIBFPTR_PARAM_USE_VAT18,
    LIBFPTR_PARAM_TAG_NAME,
    LIBFPTR_PARAM_TAG_TYPE,
    LIBFPTR_PARAM_TAG_IS_COMPLEX,
    LIBFPTR_PARAM_TAG_IS_REPEATABLE,
    LIBFPTR_PARAM_SHIFT_AUTO_OPENED,
    LIBFPTR_PARAM_CONTAINER_FIRMWARE_VERSION,
    LIBFPTR_PARAM_CONTAINER_CONFIGURATION_VERSION,
    LIBFPTR_PARAM_CONTAINER_BOOTLOADER_VERSION,
    LIBFPTR_PARAM_CONTAINER_SCRIPTS_VERSION,
    LIBFPTR_PARAM_PAPER_NEAR_END,
    LIBFPTR_PARAM_REPORT_ELECTRONICALLY,
    LIBFPTR_PARAM_ACTIVATION_METHOD,
    LIBFPTR_PARAM_KEYS,
    LIBFPTR_PARAM_UIN,
    LIBFPTR_PARAM_VERSION,
    LIBFPTR_PARAM_PUBLIC_KEY_SIGN,
    LIBFPTR_PARAM_CAP_DISABLE_PRINT_REPORTS,
    LIBFPTR_PARAM_REGISTRATION_NUMBER,
    LIBFPTR_PARAM_PIXEL_BUFFER,
    LIBFPTR_PARAM_REPEAT_NUMBER,
    LIBFPTR_PARAM_FIELD_TYPE,
    LIBFPTR_PARAM_MARKING_CODE,
    LIBFPTR_PARAM_CONTAINER_DIRECT_BOOT_VERSION,
    LIBFPTR_PARAM_SCRIPT_NAME,
    LIBFPTR_PARAM_SCRIPT_HASH,
    LIBFPTR_PARAM_RECORDS_ID,
    LIBFPTR_PARAM_USER_SCRIPT_RESULT_1,
    LIBFPTR_PARAM_USER_SCRIPT_RESULT_2,
    LIBFPTR_PARAM_USER_SCRIPT_RESULT_3,
    LIBFPTR_PARAM_USER_SCRIPT_RESULT_4,
    LIBFPTR_PARAM_USER_SCRIPT_RESULT_5,
    LIBFPTR_PARAM_IS_USER_SCRIPT,
    LIBFPTR_PARAM_DOCUMENT_NUMBER_END,
    LIBFPTR_PARAM_SHIFT_NUMBER_END,
    LIBFPTR_PARAM_SCRIPT_CODE,
    LIBFPTR_PARAM_SCRIPT_RESULT,
    LIBFPTR_PARAM_SCRIPT_TYPE,
    LIBFPTR_PARAM_WIFI_CONFIG_TIMEOUT,
    LIBFPTR_PARAM_WIFI_DHCP,
    LIBFPTR_PARAM_WIFI_IP,
    LIBFPTR_PARAM_WIFI_MASK,
    LIBFPTR_PARAM_WIFI_GATEWAY,
    LIBFPTR_PARAM_WIFI_PORT,
    LIBFPTR_PARAM_UC_VERSION,
    LIBFPTR_PARAM_UC_AVAILABLE_MEMORY,
    LIBFPTR_PARAM_UC_USED_MEMORY_BY_SUMS,
    LIBFPTR_PARAM_UC_USED_MEMORY_BY_QUANTITIES,
    LIBFPTR_PARAM_UC_LAYER_1,
    LIBFPTR_PARAM_UC_FLAGS_1,
    LIBFPTR_PARAM_UC_MASK_1,
    LIBFPTR_PARAM_UC_LAYER_VALUE_1,
    LIBFPTR_PARAM_UC_LAYER_2,
    LIBFPTR_PARAM_UC_FLAGS_2,
    LIBFPTR_PARAM_UC_MASK_2,
    LIBFPTR_PARAM_UC_LAYER_VALUE_2,
    LIBFPTR_PARAM_UC_LAYER_3,
    LIBFPTR_PARAM_UC_FLAGS_3,
    LIBFPTR_PARAM_UC_MASK_3,
    LIBFPTR_PARAM_UC_LAYER_VALUE_3,
    LIBFPTR_PARAM_UC_LAYER_4,
    LIBFPTR_PARAM_UC_FLAGS_4,
    LIBFPTR_PARAM_UC_MASK_4,
    LIBFPTR_PARAM_UC_LAYER_VALUE_4,
    LIBFPTR_PARAM_RECEIPTS_COUNT,
    LIBFPTR_PARAM_PAYMENTS_SUM_CASH,
    LIBFPTR_PARAM_PAYMENTS_SUM_ELECTRONICALLY,
    LIBFPTR_PARAM_PAYMENTS_SUM_PREPAID,
    LIBFPTR_PARAM_PAYMENTS_SUM_CREDIT,
    LIBFPTR_PARAM_PAYMENTS_SUM_OTHER,
    LIBFPTR_PARAM_TAXES_SUM_VAT20,
    LIBFPTR_PARAM_TAXES_SUM_VAT120,
    LIBFPTR_PARAM_TAXES_SUM_VAT10,
    LIBFPTR_PARAM_TAXES_SUM_VAT110,
    LIBFPTR_PARAM_TAXES_SUM_VAT0,
    LIBFPTR_PARAM_TAXES_SUM_NO,
    LIBFPTR_PARAM_CORRECTIONS_COUNT,
    LIBFPTR_PARAM_CORRECTIONS_SUM,
    LIBFPTR_PARAM_FN_COUNTERS_TYPE,
    LIBFPTR_PARAM_FN_DAYS_REMAIN,
    LIBFPTR_PARAM_FREE_MEMORY,
    LIBFPTR_PARAM_FN_MAX_FFD_VERSION,
    LIBFPTR_PARAM_RECEIPTS_SUM,
    LIBFPTR_PARAM_LICENSE_NAME,
    LIBFPTR_PARAM_UNIVERSAL_COUNTERS_FAULT,
    LIBFPTR_PARAM_USE_LICENSES,
    LIBFPTR_PARAM_LICENSE_VALID_FROM,
    LIBFPTR_PARAM_LICENSE_VALID_UNTIL,
    LIBFPTR_PARAM_MARKING_CODE_TYPE,
    LIBFPTR_PARAM_SETTING_NAME,
    LIBFPTR_PARAM_SETTING_TYPE,
    LIBFPTR_PARAM_FONT_WIDTH,
    LIBFPTR_PARAM_REMOTE_CALL,
    LIBFPTR_PARAM_SCRIPT_PARAMS,
    LIBFPTR_PARAM_IGNORE_EMPTY,

    LIBFPTR_PARAM_LAST
  );
  Tlibfptr_param  = libfptr_param;

  libfptr_model = (
    LIBFPTR_MODEL_UNKNOWN = 0,
    LIBFPTR_MODEL_ATOL_AUTO = 500,
    LIBFPTR_MODEL_ATOL_11F = 67,
    LIBFPTR_MODEL_ATOL_15F = 78,
    LIBFPTR_MODEL_ATOL_20F = 81,
    LIBFPTR_MODEL_ATOL_22F = 63,
    LIBFPTR_MODEL_ATOL_25F = 57,
    LIBFPTR_MODEL_ATOL_27F = 87,
    LIBFPTR_MODEL_ATOL_30F = 61,
    LIBFPTR_MODEL_ATOL_42FS = 77,
    LIBFPTR_MODEL_ATOL_50F = 80,
    LIBFPTR_MODEL_ATOL_52F = 64,
    LIBFPTR_MODEL_ATOL_55F = 62,
    LIBFPTR_MODEL_ATOL_60F = 75,
    LIBFPTR_MODEL_ATOL_77F = 69,
    LIBFPTR_MODEL_ATOL_90F = 72,
    LIBFPTR_MODEL_ATOL_91F = 82,
    LIBFPTR_MODEL_ATOL_92F = 84,
    LIBFPTR_MODEL_ATOL_SIGMA_10 = 86,
    LIBFPTR_MODEL_ATOL_SIGMA_7F = 90,
    LIBFPTR_MODEL_ATOL_SIGMA_8F = 91,
    LIBFPTR_MODEL_KAZNACHEY_FA = 76,
    LIBFPTR_MODEL_ATOL_1F = 93
  );
  Tlibfptr_model = libfptr_model;

const
  LIBFPTR_SETTING_LIBRARY_PATH                = 'LibraryPath';
  LIBFPTR_SETTING_MODEL                       = 'Model';
  LIBFPTR_SETTING_PORT                        = 'Port';
  LIBFPTR_SETTING_BAUDRATE                    = 'BaudRate';
  LIBFPTR_SETTING_BITS                        = 'Bits';
  LIBFPTR_SETTING_PARITY                      = 'Parity';
  LIBFPTR_SETTING_STOPBITS                    = 'StopBits';
  LIBFPTR_SETTING_IPADDRESS                   = 'IPAddress';
  LIBFPTR_SETTING_IPPORT                      = 'IPPort';
  LIBFPTR_SETTING_MACADDRESS                  = 'MACAddress';
  LIBFPTR_SETTING_COM_FILE                    = 'ComFile';
  LIBFPTR_SETTING_USB_DEVICE_PATH             = 'UsbDevicePath';
  LIBFPTR_SETTING_BT_AUTOENABLE               = 'AutoEnableBluetooth';
  LIBFPTR_SETTING_BT_AUTODISABLE              = 'AutoDisableBluetooth';
  LIBFPTR_SETTING_ACCESS_PASSWORD             = 'AccessPassword';
  LIBFPTR_SETTING_USER_PASSWORD               = 'UserPassword';
  LIBFPTR_SETTING_OFD_CHANNEL                 = 'OfdChannel';
  LIBFPTR_SETTING_EXISTED_COM_FILES           = 'ExistedComFiles';
  LIBFPTR_SETTING_SCRIPTS_PATH                = 'ScriptsPath';
  LIBFPTR_SETTING_DOCUMENTS_JOURNAL_PATH      = 'DocumentsJournalPath';
  LIBFPTR_SETTING_USE_DOCUMENTS_JOURNAL       = 'UseDocumentsJournal';
  LIBFPTR_SETTING_AUTO_RECONNECT              = 'AutoReconnect';
  LIBFPTR_SETTING_INVERT_CASH_DRAWER_STATUS   = 'InvertCashDrawerStatus';

type
  libfptr_port = (
    LIBFPTR_PORT_COM = 0,
    LIBFPTR_PORT_USB,
    LIBFPTR_PORT_TCPIP,
    LIBFPTR_PORT_BLUETOOTH
  );
  Tlibfptr_port = libfptr_port;

  libfptr_baudrate = (
    LIBFPTR_PORT_BR_1200 = 1200,
    LIBFPTR_PORT_BR_2400 = 2400,
    LIBFPTR_PORT_BR_4800 = 4800,
    LIBFPTR_PORT_BR_9600 = 9600,
    LIBFPTR_PORT_BR_19200 = 19200,
    LIBFPTR_PORT_BR_38400 = 38400,
    LIBFPTR_PORT_BR_57600 = 57600,
    LIBFPTR_PORT_BR_115200 = 115200,
    LIBFPTR_PORT_BR_230400 = 230400,
    LIBFPTR_PORT_BR_460800 = 460800,
    LIBFPTR_PORT_BR_921600 = 921600
  );
  Tlibfptr_baudrate = libfptr_baudrate;

  libfptr_bits = (
    LIBFPTR_PORT_BITS_7 = 7,
    LIBFPTR_PORT_BITS_8 = 8
  );
  Tlibfptr_bits = libfptr_bits;

  libfptr_parity = (
    LIBFPTR_PORT_PARITY_NO = 0,
    LIBFPTR_PORT_PARITY_ODD,
    LIBFPTR_PORT_PARITY_EVEN,
    LIBFPTR_PORT_PARITY_MARK,
    LIBFPTR_PORT_PARITY_SPACE
  );
  Tlibfptr_parity = libfptr_parity;

  libfptr_stopbits = (
    LIBFPTR_PORT_SB_1 = 0,
    LIBFPTR_PORT_SB_1_5,
    LIBFPTR_PORT_SB_2
  );
  Tlibfptr_stopbits = libfptr_stopbits;

  libfptr_barcode_type = (
    LIBFPTR_BT_EAN_8 = 0,
    LIBFPTR_BT_EAN_13,
    LIBFPTR_BT_UPC_A,
    LIBFPTR_BT_UPC_E,
    LIBFPTR_BT_CODE_39,
    LIBFPTR_BT_CODE_93,
    LIBFPTR_BT_CODE_128,
    LIBFPTR_BT_CODABAR,
    LIBFPTR_BT_ITF,
    LIBFPTR_BT_ITF_14,
    LIBFPTR_BT_GS1_128,
    LIBFPTR_BT_QR,
    LIBFPTR_BT_PDF417,
    LIBFPTR_BT_AZTEC,
    LIBFPTR_BT_CODE_39_EXTENDED
  );
  Tlibfptr_barcode_type = libfptr_barcode_type;

  libfptr_barcode_correction = (
    LIBFPTR_BC_DEFAULT = 0,
    LIBFPTR_BC_0,
    LIBFPTR_BC_1,
    LIBFPTR_BC_2,
    LIBFPTR_BC_3,
    LIBFPTR_BC_4,
    LIBFPTR_BC_5,
    LIBFPTR_BC_6,
    LIBFPTR_BC_7,
    LIBFPTR_BC_8
  );
  Tlibfptr_barcode_correction = libfptr_barcode_correction;

  libfptr_tax_mode = (
    LIBFPTR_TM_POSITION = 0,
    LIBFPTR_TM_UNIT
  );
  Tlibfptr_tax_mode = libfptr_tax_mode;

  libfptr_step_counter_type = (
    LIBFPTR_SCT_OVERALL = 0,
    LIBFPTR_SCT_FORWARD
  );
  Tlibfptr_step_counter_type = libfptr_step_counter_type;

  libfptr_counter_type = (
    LIBFPTR_CT_ROLLUP = 0,
    LIBFPTR_CT_RESETTABLE
  );
  Tlibfptr_counter_type = libfptr_counter_type;

  libfptr_shift_state = (
    LIBFPTR_SS_CLOSED = 0,
    LIBFPTR_SS_OPENED,
    LIBFPTR_SS_EXPIRED
  );
  Tlibfptr_shift_state = libfptr_shift_state;

  libfptr_cut_type= (
    LIBFPTR_CT_FULL = 0,
    LIBFPTR_CT_PART
  );
  Tlibfptr_cut_type = libfptr_cut_type;

  libfptr_alignment = (
    LIBFPTR_ALIGNMENT_LEFT = 0,
    LIBFPTR_ALIGNMENT_CENTER,
    LIBFPTR_ALIGNMENT_RIGHT
  );
  Tlibfptr_alignment = libfptr_alignment;

  libfptr_text_wrap = (
    LIBFPTR_TW_NONE = 0,
    LIBFPTR_TW_WORDS,
    LIBFPTR_TW_CHARS
  );
  Tlibfptr_text_wrap = libfptr_text_wrap;

  libfptr_fn_type = (
    LIBFPTR_FNT_DEBUG = 0,
    LIBFPTR_FNT_RELEASE,
    LIBFPTR_FNT_UNKNOWN
  );
  Tlibfptr_fn_type = libfptr_fn_type;

  libfptr_fn_state = (
    LIBFPTR_FNS_INITIAL = 0,
    LIBFPTR_FNS_CONFIGURED = 1,
    LIBFPTR_FNS_FISCAL_MODE = 3,
    LIBFPTR_FNS_POSTFISCAL_MODE = 7,
    LIBFPTR_FNS_ACCESS_ARCHIVE = 15
  );
  Tlibfptr_fn_state = libfptr_fn_state;

  libfptr_receipt_type = (
    LIBFPTR_RT_CLOSED = 0,
    LIBFPTR_RT_SELL = 1,
    LIBFPTR_RT_SELL_RETURN = 2,
    LIBFPTR_RT_SELL_CORRECTION = 7,
    LIBFPTR_RT_SELL_RETURN_CORRECTION = 8,
    LIBFPTR_RT_BUY = 4,
    LIBFPTR_RT_BUY_RETURN = 5,
    LIBFPTR_RT_BUY_CORRECTION = 9,
    LIBFPTR_RT_BUY_RETURN_CORRECTION = 10
  );
  Tlibfptr_receipt_type = libfptr_receipt_type;

  libfptr_report_type = (
    LIBFPTR_RT_CLOSE_SHIFT = 0,
    LIBFPTR_RT_X,
    LIBFPTR_RT_LAST_DOCUMENT,
    LIBFPTR_RT_OFD_EXCHANGE_STATUS,
    LIBFPTR_RT_KKT_DEMO,
    LIBFPTR_RT_KKT_INFO,
    LIBFPTR_RT_OFD_TEST,
    LIBFPTR_RT_FN_DOC_BY_NUMBER,
    LIBFPTR_RT_QUANTITY,
    LIBFPTR_RT_DEPARTMENTS,
    LIBFPTR_RT_OPERATORS,
    LIBFPTR_RT_HOURS,
    LIBFPTR_RT_FN_REGISTRATIONS,
    LIBFPTR_RT_FN_SHIFT_TOTAL_COUNTERS,
    LIBFPTR_RT_FN_TOTAL_COUNTERS,
    LIBFPTR_RT_FN_NOT_SENT_DOCUMENTS_COUNTERS,
    LIBFPTR_RT_COMMODITIES_BY_TAXATION_TYPES,
    LIBFPTR_RT_COMMODITIES_BY_DEPARTMENTS,
    LIBFPTR_RT_COMMODITIES_BY_SUMS,
    LIBFPTR_RT_START_SERVICE,
    LIBFPTR_RT_DISCOUNTS,
    LIBFPTR_RT_JOURNAL_DOCUMENT_BY_NUMBERS,
    LIBFPTR_RT_JOURNAL_DOCUMENT_BY_SHIFTS,
    LIBFPTR_RT_CLOSE_SHIFT_REPORTS
  );
  Tlibfptr_report_type = libfptr_report_type;

  libfptr_payment_type = (
    LIBFPTR_PT_CASH = 0,
    LIBFPTR_PT_ELECTRONICALLY,
    LIBFPTR_PT_PREPAID,
    LIBFPTR_PT_CREDIT,
    LIBFPTR_PT_OTHER,
    LIBFPTR_PT_6,
    LIBFPTR_PT_7,
    LIBFPTR_PT_8,
    LIBFPTR_PT_9,
    LIBFPTR_PT_10
  );
  Tlibfptr_payment_type = libfptr_payment_type;

  libfptr_tax_type = (
    LIBFPTR_TAX_DEPARTMENT = 0,
    LIBFPTR_TAX_VAT18 = 1,
    LIBFPTR_TAX_VAT10,
    LIBFPTR_TAX_VAT118,
    LIBFPTR_TAX_VAT110,
    LIBFPTR_TAX_VAT0,
    LIBFPTR_TAX_NO,
    LIBFPTR_TAX_VAT20,
    LIBFPTR_TAX_VAT120
  );
  Tlibfptr_tax_type = libfptr_tax_type;

  libfptr_external_device_type = (
    LIBFPTR_EXTERNAL_DEVICE_DISPLAY = 0,
    LIBFPTR_EXTERNAL_DEVICE_PINPAD,
    LIBFPTR_EXTERNAL_DEVICE_MODEM,
    LIBFPTR_EXTERNAL_DEVICE_BARCODE_SCANNER
  );
  Tlibfptr_external_device_type = libfptr_external_device_type;

  libfptr_kkt_data_type = (
    LIBFPTR_DT_STATUS = 0,
    LIBFPTR_DT_CASH_SUM,
    LIBFPTR_DT_UNIT_VERSION,
    LIBFPTR_DT_PICTURE_INFO,
    LIBFPTR_DT_LICENSE_ACTIVATED,
    LIBFPTR_DT_REGISTRATIONS_SUM,
    LIBFPTR_DT_REGISTRATIONS_COUNT,
    LIBFPTR_DT_PAYMENT_SUM,
    LIBFPTR_DT_CASHIN_SUM,
    LIBFPTR_DT_CASHIN_COUNT,
    LIBFPTR_DT_CASHOUT_SUM,
    LIBFPTR_DT_CASHOUT_COUNT,
    LIBFPTR_DT_REVENUE,
    LIBFPTR_DT_DATE_TIME,
    LIBFPTR_DT_SHIFT_STATE,
    LIBFPTR_DT_RECEIPT_STATE,
    LIBFPTR_DT_SERIAL_NUMBER,
    LIBFPTR_DT_MODEL_INFO,
    LIBFPTR_DT_RECEIPT_LINE_LENGTH,
    LIBFPTR_DT_CUTTER_RESOURCE,
    LIBFPTR_DT_STEP_RESOURCE,
    LIBFPTR_DT_TERMAL_RESOURCE,
    LIBFPTR_DT_ENVD_MODE,
    LIBFPTR_DT_SHIFT_TAX_SUM,
    LIBFPTR_DT_RECEIPT_TAX_SUM,
    LIBFPTR_DT_NON_NULLABLE_SUM,
    LIBFPTR_DT_RECEIPT_COUNT,
    LIBFPTR_DT_CANCELLATION_COUNT_ALL,
    LIBFPTR_DT_CANCELLATION_SUM,
    LIBFPTR_DT_CANCELLATION_SUM_ALL,
    LIBFPTR_DT_POWER_SOURCE_STATE,
    LIBFPTR_DT_CANCELLATION_COUNT,
    LIBFPTR_DT_NON_NULLABLE_SUM_BY_PAYMENTS,
    LIBFPTR_DT_PRINTER_TEMPERATURE,
    LIBFPTR_DT_FATAL_STATUS,
    LIBFPTR_DT_MAC_ADDRESS,
    LIBFPTR_DT_DEVICE_UPTIME,
    LIBFPTR_DT_RECEIPT_BYTE_COUNT,
    LIBFPTR_DT_DISCOUNT_AND_SURCHARGE_SUM,
    LIBFPTR_DT_LK_USER_CODE,
    LIBFPTR_DT_LAST_SENT_OFD_DOCUMENT_DATE_TIME,
    LIBFPTR_DT_SHORT_STATUS,
    LIBFPTR_DT_PICTURES_ARRAY_INFO,
    LIBFPTR_DT_ETHERNET_INFO,
    LIBFPTR_DT_SCRIPTS_INFO,
    LIBFPTR_DT_SHIFT_TOTALS,
    LIBFPTR_DT_WIFI_INFO,
    LIBFPTR_DT_FONT_INFO
  );
  Tlibfptr_kkt_data_type = libfptr_kkt_data_type;

  libfptr_fn_data_type = (
    LIBFPTR_FNDT_TAG_VALUE,
    LIBFPTR_FNDT_OFD_EXCHANGE_STATUS,
    LIBFPTR_FNDT_FN_INFO,
    LIBFPTR_FNDT_LAST_REGISTRATION,
    LIBFPTR_FNDT_LAST_RECEIPT,
    LIBFPTR_FNDT_LAST_DOCUMENT,
    LIBFPTR_FNDT_SHIFT,
    LIBFPTR_FNDT_FFD_VERSIONS,
    LIBFPTR_FNDT_VALIDITY,
    LIBFPTR_FNDT_REG_INFO,
    LIBFPTR_FNDT_DOCUMENTS_COUNT_IN_SHIFT,
    LIBFPTR_FNDT_ERRORS,
    LIBFPTR_FNDT_TICKET_BY_DOC_NUMBER,
    LIBFPTR_FNDT_DOCUMENT_BY_NUMBER,
    LIBFPTR_FNDT_REGISTRATION_TLV,
    LIBFPTR_FNDT_ERROR_DETAIL,
    LIBFPTR_FNDT_VALIDITY_DAYS,
    LIBFPTR_FNDT_FREE_MEMORY,
    LIBFPTR_FNDT_TOTALS
  );
  Tlibfptr_fn_data_type = libfptr_fn_data_type;

  libfptr_ffd_version = (
    LIBFPTR_FFD_UNKNOWN = 0,
    LIBFPTR_FFD_1_0 = 100,
    LIBFPTR_FFD_1_0_5 = 105,
    LIBFPTR_FFD_1_1 = 110
  );
  Tlibfptr_ffd_version = libfptr_ffd_version;

  libfptr_taxation_type = (
    LIBFPTR_TT_DEFAULT = $00,
    LIBFPTR_TT_OSN = $01,
    LIBFPTR_TT_USN_INCOME = $02,
    LIBFPTR_TT_USN_INCOME_OUTCOME = $04,
    LIBFPTR_TT_ENVD = $08,
    LIBFPTR_TT_ESN = $10,
    LIBFPTR_TT_PATENT = $20
  );
  Tlibfptr_taxation_type = libfptr_taxation_type;

  libfptr_unit_type = (
    LIBFPTR_UT_FIRMWARE,
    LIBFPTR_UT_CONFIGURATION,
    LIBFPTR_UT_TEMPLATES,
    LIBFPTR_UT_CONTROL_UNIT,
    LIBFPTR_UT_BOOT
  );
  Tlibfptr_unit_type = libfptr_unit_type;

  libfptr_fn_operation_type = (
    LIBFPTR_FNOP_REGISTRATION = 0,
    LIBFPTR_FNOP_CHANGE_FN,
    LIBFPTR_FNOP_CHANGE_PARAMETERS,
    LIBFPTR_FNOP_CLOSE_ARCHIVE
  );
  Tlibfptr_fn_operation_type = libfptr_fn_operation_type;

  libfptr_agent_type = (
    LIBFPTR_AT_NONE = $00,
    LIBFPTR_AT_BANK_PAYING_AGENT = $01,
    LIBFPTR_AT_BANK_PAYING_SUBAGENT = $02,
    LIBFPTR_AT_PAYING_AGENT = $04,
    LIBFPTR_AT_PAYING_SUBAGENT = $08,
    LIBFPTR_AT_ATTORNEY = $10,
    LIBFPTR_AT_COMMISSION_AGENT = $20,
    LIBFPTR_AT_ANOTHER = $40
  );
  Tlibfptr_agent_type = libfptr_agent_type;

  libfptr_ofd_channel = (
    LIBFPTR_OFD_CHANNEL_NONE = 0,
    LIBFPTR_OFD_CHANNEL_USB,
    LIBFPTR_OFD_CHANNEL_PROTO,
    LIBFPTR_OFD_CHANNEL_AUTO = LIBFPTR_OFD_CHANNEL_PROTO
  );
  Tlibfptr_ofd_channel = libfptr_ofd_channel;

  libfptr_power_source_type = (
    LIBFPTR_PST_POWER_SUPPLY = 0,
    LIBFPTR_PST_RTC_BATTERY,
    LIBFPTR_PST_BATTERY
  );
  Tlibfptr_power_source_type = libfptr_power_source_type;

  libfptr_records_type = (
    LIBFPTR_RT_LAST_DOCUMENT_LINES,
    LIBFPTR_RT_FN_DOCUMENT_TLVS,
    LIBFPTR_RT_EXEC_USER_SCRIPT,
    LIBFPTR_RT_FIRMWARE,
    LIBFPTR_RT_LICENSES,
    LIBFPTR_RT_FN_REGISTRATION_TLVS,
    LIBFPTR_RT_PARSE_COMPLEX_ATTR,
    LIBFPTR_RT_FN_SUM_COUNTERS,
    LIBFPTR_RT_FN_QUANTITY_COUNTERS,
    LIBFPTR_RT_FN_UNSENT_DOCS_COUNTERS,
    LIBFPTR_RT_SETTINGS
  );
  Tlibfptr_records_type = libfptr_records_type;

  libfptr_nomenclature_type = (
    LIBFPTR_NT_FURS = 0,
    LIBFPTR_NT_MEDICINES,
    LIBFPTR_NT_TOBACCO,
    LIBFPTR_NT_SHOES
  );
  Tlibfptr_nomenclature_type = libfptr_nomenclature_type;

  libfptr_fn_document_type = (
    LIBFPTR_FN_DOC_REGISTRATION = 1,
    LIBFPTR_FN_DOC_OPEN_SHIFT = 2,
    LIBFPTR_FN_DOC_RECEIPT = 3,
    LIBFPTR_FN_DOC_BSO = 4,
    LIBFPTR_FN_DOC_CLOSE_SHIFT = 5,
    LIBFPTR_FN_DOC_CLOSE_FN = 6,
    LIBFPTR_FN_DOC_OPERATOR_CONFIRMATION = 7,
    LIBFPTR_FN_DOC_REREGISTRATION = 11,
    LIBFPTR_FN_DOC_EXCHANGE_STATUS = 21,
    LIBFPTR_FN_DOC_CORRECTION = 31,
    LIBFPTR_FN_DOC_BSO_CORRECTION = 41
  );
  Tlibfptr_fn_document_type = libfptr_fn_document_type;

  libfptr_log_level = (
    LIBFPTR_LOG_ERROR = 0,
    LIBFPTR_LOG_WARN,
    LIBFPTR_LOG_INFO,
    LIBFPTR_LOG_DEBUG
  );
  Tlibfptr_log_level = libfptr_log_level;

  libfptr_user_memory_operation = (
    LIBFPTR_UMO_GET_SIZE = 0,
    LIBFPTR_UMO_READ_DATA,
    LIBFPTR_UMO_WRITE_DATA,
    LIBFPTR_UMO_READ_STRING,
    LIBFPTR_UMO_WRITE_STRING,
    LIBFPTR_UMO_COMMIT
  );

  libfptr_gui_parent = (
    LIBFPTR_GUI_PARENT_NATIVE = 0,
    LIBFPTR_GUI_PARENT_QT
  );
  Tlibfptr_gui_parent = libfptr_gui_parent;

  libfptr_defer_type = (
    LIBFPTR_DEFER_NONE = 0,
    LIBFPTR_DEFER_PRE,
    LIBFPTR_DEFER_POST,
    LIBFPTR_DEFER_OVERLAY
  );
  Tlibfptr_defer_type = libfptr_defer_type;

  libfptr_tag_type = (
    LIBFPTR_TAG_TYPE_STLV = 0,
    LIBFPTR_TAG_TYPE_STRING,
    LIBFPTR_TAG_TYPE_ARRAY,
    LIBFPTR_TAG_TYPE_FVLN,
    LIBFPTR_TAG_TYPE_BITS,
    LIBFPTR_TAG_TYPE_BYTE,
    LIBFPTR_TAG_TYPE_VLN,
    LIBFPTR_TAG_TYPE_UINT_16,
    LIBFPTR_TAG_TYPE_UINT_32,
    LIBFPTR_TAG_TYPE_UNIX_TIME,
    LIBFPTR_TAG_TYPE_BOOL
  );
  Tlibfptr_tag_type = libfptr_tag_type;

  libfptr_field_type = (
    LIBFPTR_FT_BYTE_ARRAY = 0,
    LIBFPTR_FT_BIN,
    LIBFPTR_FT_BCD,
    LIBFPTR_FT_STRING,
    LIBFPTR_FT_STRING_NULL_TERM
  );
  Tlibfptr_field_type = libfptr_field_type;


  libfptr_script_type = (
    LIBFPTR_SCRIPT_EXECUTABLE = 0,
    LIBFPTR_SCRIPT_JSON,
    LIBFPTR_SCRIPT_SETTINGS
  );
  Tlibfptr_script_type = libfptr_script_type;

  libfptr_uc_layer = (
    LIBFPTR_UCL_UNUSED = 0,
    LIBFPTR_UCL_RECEIPT_TYPE,
    LIBFPTR_UCL_TAXATION_TYPE,
    LIBFPTR_UCL_TAX_TYPE,
    LIBFPTR_UCL_PRODUCT_TYPE,
    LIBFPTR_UCL_PAYMENT_METHOD,
    LIBFPTR_UCL_USER_3,
    LIBFPTR_UCL_USER_4,
    LIBFPTR_UCL_USER_5,
    LIBFPTR_UCL_USER_6
  );
  Tlibfptr_uc_layer = libfptr_uc_layer;

  libfptr_uc_flag = (
    LIBFPTR_UCF_CALC_SUMS = 1,
    LIBFPTR_UCF_CALC_QUANTITIES = 2,
    LIBFPTR_UCF_CALC_SUMS_OTHERS = 4,
    LIBFPTR_UCF_CALC_QUANTITIES_OTHERS = 8
  );
  Tlibfptr_uc_flag = libfptr_uc_flag;

  libfptr_fn_counter_type = (
    LIBFPTR_FNCT_SHIFT = 0,
    LIBFPTR_FNCT_NON_NULLABLE
  );
  Tlibfptr_fn_counter_type = libfptr_fn_counter_type;

  libfptr_marking_code_type = (
    LIBFPTR_MCT_OTHER = 0,
    LIBFPTR_MCT_EGAIS_20,
    LIBFPTR_MCT_EGAIS_30
  );
  Tlibfptr_marking_code_type = libfptr_marking_code_type;

  libfptr_setting_type = (
    LIBFPTR_ST_NUMBER = 0,
    LIBFPTR_ST_STRING,
    LIBFPTR_ST_BOOL
  );
  Tlibfptr_setting_type = libfptr_setting_type;

  libfptr_firmware_type = (
    LIBFPTR_FWT_FIRMWARE = 0,
    LIBFPTR_FWT_SCRIPTS = 2
  );
  Tlibfptr_firmware_type = libfptr_firmware_type;

const
  LIBFPTR_UC_OTHERS = 4294967295;

type
  //Tlibfptr_user_memory_operation = libfptr_user_memory_operation;


  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_init_library(void *params);
  Tlibfptr_init_library = procedure(Params:Pointer); cdecl;

  //DTOX_SHARED_EXPORT const char *DTOX_SHARED_CCA libfptr_get_version_string();
  Tlibfptr_get_version_string = function():PChar; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_create(libfptr_handle *handle);
  Tlibfptr_create = function(Handle:PLibFPtrHandle):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_create_with_id(libfptr_handle *handle, const wchar_t *id);
  Tlibfptr_create_with_id = function(Handle:PLibFPtrHandle; id:PWchar_t):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_set_settings(libfptr_handle handle, const wchar_t *settings);
  Tlibfptr_set_settings = function(Handle:PLibFPtrHandle; Settings:PWchar_t):integer; cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_destroy(libfptr_handle *handle);
  Tlibfptr_destroy = procedure(Handle:PLibFPtrHandle); cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_get_settings(libfptr_handle handle, wchar_t *value, int size);
  Tlibfptr_get_settings = function(Handle:PLibFPtrHandle; Value:PWchar_t; Size:Integer):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_get_single_setting(libfptr_handle handle, const wchar_t *key, wchar_t *value, int size);
  Tlibfptr_get_single_setting = function(Handle:PLibFPtrHandle; Key:PWchar_t; Value:PWchar_t; Size:Integer):integer; cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_single_setting(libfptr_handle handle, const wchar_t *key, const wchar_t *value);
  Tlibfptr_set_single_setting = procedure(Handle:PLibFPtrHandle; Key:PWchar_t; Value:PWchar_t); cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_apply_single_settings(libfptr_handle handle);
  Tlibfptr_apply_single_settings = function(Handle:PLibFPtrHandle):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_open(libfptr_handle handle);
  Tlibfptr_open = function(Handle:TLibFPtrHandle):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_close(libfptr_handle handle);
  Tlibfptr_close = function(Handle:TLibFPtrHandle):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_is_opened(libfptr_handle handle);
  Tlibfptr_is_opened = function(Handle:TLibFPtrHandle):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_error_code(libfptr_handle handle);
  Tlibfptr_error_code = function (Handle:TLibFPtrHandle):integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_error_description(libfptr_handle handle, wchar_t *value, int size);
  Tlibfptr_error_description = function(Handle:TLibFPtrHandle; Value:PWchar_t; Size:Integer):integer; cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_reset_error(libfptr_handle handle);
  Tlibfptr_reset_error = procedure(Handle:TLibFPtrHandle);cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_param_bool(libfptr_handle handle, int param_id, int value);
  Tlibfptr_set_param_bool = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:Integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_param_int(libfptr_handle handle, int param_id, uint value);
  Tlibfptr_set_param_int = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:Cardinal); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_param_double(libfptr_handle handle, int param_id, double value);
  Tlibfptr_set_param_double = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:Double); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_param_str(libfptr_handle handle, int param_id, const wchar_t *value);
  Tlibfptr_set_param_str = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:PWchar_t); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_param_datetime(libfptr_handle handle, int param_id, int year, int month, int day, int hour, int minute, int second);
  Tlibfptr_set_param_datetime = procedure(Handle:TLibFPtrHandle; param_id:Integer; Year:integer; month:integer; day:integer; hour:integer; minute:integer; second:integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_param_bytearray(libfptr_handle handle, int param_id, const uchar *value, int size);
  Tlibfptr_set_param_bytearray = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:PChar; Size:Integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_non_printable_param_bool(libfptr_handle handle, int param_id, int value);
  Tlibfptr_set_non_printable_param_bool = procedure(Handle:TLibFPtrHandle; param_id:Integer;  value:Integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_non_printable_param_int(libfptr_handle handle, int param_id, uint value);
  Tlibfptr_set_non_printable_param_int = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:Cardinal); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_non_printable_param_double(libfptr_handle handle, int param_id, double value);
  Tlibfptr_set_non_printable_param_double = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:Double); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_non_printable_param_str(libfptr_handle handle, int param_id, const wchar_t *value);
  Tlibfptr_set_non_printable_param_str = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:PWchar_t); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_non_printable_param_datetime(libfptr_handle handle, int param_id, int year, int month, int day, int hour, int minute, int second);
  Tlibfptr_set_non_printable_param_datetime = procedure(Handle:TLibFPtrHandle; param_id:Integer; Year:Integer; Month:Integer; Day:Integer; Hour:Integer; Minute:Integer; Second:Integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_non_printable_param_bytearray(libfptr_handle handle, int param_id, const uchar *value, int size);
  Tlibfptr_set_non_printable_param_bytearray = procedure(Handle:TLibFPtrHandle; param_id:Integer; Value:PChar; Size:Integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_user_param_bool(libfptr_handle handle, int param_id, int value);
  Tlibfptr_set_user_param_bool = procedure(Handle:TLibFPtrHandle; param_id:Integer; value:Integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_user_param_int(libfptr_handle handle, int param_id, uint value);
  Tlibfptr_set_user_param_int = procedure(Handle:TLibFPtrHandle; param_id:Integer; value:Cardinal); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_user_param_double(libfptr_handle handle, int param_id, double value);
  Tlibfptr_set_user_param_double = procedure(Handle:TLibFPtrHandle; param_id:Integer; value:Double); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_user_param_str(libfptr_handle handle, int param_id, const wchar_t *value);
  Tlibfptr_set_user_param_str = procedure(Handle:TLibFPtrHandle; param_id:Integer; value:PWchar_t); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_user_param_datetime(libfptr_handle handle, int param_id, int year, int month, int day, int hour, int minute, int second);
  Tlibfptr_set_user_param_datetime = procedure(Handle:TLibFPtrHandle; param_id:Integer; year:Integer; month:Integer; day:Integer; hour:Integer; minute:Integer; second:Integer); cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_set_user_param_bytearray(libfptr_handle handle, int param_id, const uchar *value, int size);
  Tlibfptr_set_user_param_bytearray = procedure(Handle:TLibFPtrHandle; param_id:Integer; value:PChar; size:Integer); cdecl;

  Tlibfptr_get_param_bool = function(Handle:TLibFPtrHandle; Param_id:integer):integer; cdecl;

  //DTOX_SHARED_EXPORT uint DTOX_SHARED_CCA libfptr_get_param_int(libfptr_handle handle, int param_id);
  Tlibfptr_get_param_int = function(Handle:TLibFPtrHandle; Param_id:integer):integer; cdecl;

  //DTOX_SHARED_EXPORT double DTOX_SHARED_CCA libfptr_get_param_double(libfptr_handle handle, int param_id);
  Tlibfptr_get_param_double = function(Handle:TLibFPtrHandle; Param_id:integer):double; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_get_param_str(libfptr_handle handle, int param_id, wchar_t *value, int size);
  Tlibfptr_get_param_str = function(Handle:TLibFPtrHandle; Param_id:integer; Value:PWchar_t; Size:Integer):integer; cdecl;

  //DTOX_SHARED_EXPORT void DTOX_SHARED_CCA libfptr_get_param_datetime(libfptr_handle handle, int param_id, int *year, int *month, int *day, int *hour, int *minute, int *second);
  Tlibfptr_get_param_datetime = procedure (Handle:TLibFPtrHandle; Param_id:integer; Year:PInteger; Month:PInteger; Day:PInteger; Hour:PInteger; Minute:PInteger; Second:PInteger); cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_get_param_bytearray(libfptr_handle handle, int param_id, uchar *value, int size);
  Tlibfptr_get_param_bytearray = function(Handle:TLibFPtrHandle; Param_id:integer; Value:PChar; Size:Integer):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_reset_params(libfptr_handle handle);
  Tlibfptr_reset_params = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_run_command(libfptr_handle handle);
  Tlibfptr_run_command = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_beep(libfptr_handle handle);
  Tlibfptr_beep = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_open_drawer(libfptr_handle handle);
  Tlibfptr_open_drawer = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_cut(libfptr_handle handle);
  Tlibfptr_cut = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_device_poweroff(libfptr_handle handle);
  Tlibfptr_device_poweroff = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_device_reboot(libfptr_handle handle);
  Tlibfptr_device_reboot = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_open_shift(libfptr_handle handle);
  Tlibfptr_open_shift = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_reset_summary(libfptr_handle handle);
  Tlibfptr_reset_summary = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_init_device(libfptr_handle handle);
  Tlibfptr_init_device = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_query_data(libfptr_handle handle);
  Tlibfptr_query_data = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_cash_income(libfptr_handle handle);
  Tlibfptr_cash_income = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_cash_outcome(libfptr_handle handle);
  Tlibfptr_cash_outcome = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_open_receipt(libfptr_handle handle);
  Tlibfptr_open_receipt = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_cancel_receipt(libfptr_handle handle);
  Tlibfptr_cancel_receipt = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_close_receipt(libfptr_handle handle);
  Tlibfptr_close_receipt = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_check_document_closed(libfptr_handle handle);
  Tlibfptr_check_document_closed = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_receipt_total(libfptr_handle handle);
  Tlibfptr_receipt_total = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_receipt_tax(libfptr_handle handle);
  Tlibfptr_receipt_tax = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_registration(libfptr_handle handle);
  Tlibfptr_registration = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_payment(libfptr_handle handle);
  Tlibfptr_payment = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_report(libfptr_handle handle);
  Tlibfptr_report = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_print_text(libfptr_handle handle);
  Tlibfptr_print_text = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_print_cliche(libfptr_handle handle);
  Tlibfptr_print_cliche = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_begin_nonfiscal_document(libfptr_handle handle);
  Tlibfptr_begin_nonfiscal_document = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_end_nonfiscal_document(libfptr_handle handle);
  Tlibfptr_end_nonfiscal_document = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_print_barcode(libfptr_handle handle);
  Tlibfptr_print_barcode = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_print_picture(libfptr_handle handle);
  Tlibfptr_print_picture = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_print_picture_by_number(libfptr_handle handle);
  Tlibfptr_print_picture_by_number = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_upload_picture_from_file(libfptr_handle handle);
  Tlibfptr_upload_picture_from_file = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_download_picture(libfptr_handle handle);
  Tlibfptr_download_picture = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_clear_pictures(libfptr_handle handle);
  Tlibfptr_clear_pictures = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_write_device_setting_raw(libfptr_handle handle);
  Tlibfptr_write_device_setting_raw = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_read_device_setting_raw(libfptr_handle handle);
  Tlibfptr_read_device_setting_raw = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_commit_settings(libfptr_handle handle);
  Tlibfptr_commit_settings = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_init_settings(libfptr_handle handle);
  Tlibfptr_init_settings = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_reset_settings(libfptr_handle handle);
  Tlibfptr_reset_settings = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_write_date_time(libfptr_handle handle);
  Tlibfptr_write_date_time = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_write_license(libfptr_handle handle);
  Tlibfptr_write_license = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_fn_operation(libfptr_handle handle);
  Tlibfptr_fn_operation = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_fn_query_data(libfptr_handle handle);
  Tlibfptr_fn_query_data = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_fn_write_attributes(libfptr_handle handle);
  Tlibfptr_fn_write_attributes = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_external_device_power_on(libfptr_handle handle);
  Tlibfptr_external_device_power_on = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_external_device_power_off(libfptr_handle handle);
  Tlibfptr_external_device_power_off = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_external_device_write_data(libfptr_handle handle);
  Tlibfptr_external_device_write_data = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_external_device_read_data(libfptr_handle handle);
  Tlibfptr_external_device_read_data = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_operator_login(libfptr_handle handle);
  Tlibfptr_operator_login = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_process_json(libfptr_handle handle);
  Tlibfptr_process_json = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_read_device_setting(libfptr_handle handle);
  Tlibfptr_read_device_setting = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_write_device_setting(libfptr_handle handle);
  Tlibfptr_write_device_setting = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_begin_read_records(libfptr_handle handle);
  Tlibfptr_begin_read_records = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_read_next_record(libfptr_handle handle);
  Tlibfptr_read_next_record = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_end_read_records(libfptr_handle handle);
  Tlibfptr_end_read_records = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_user_memory_operation(libfptr_handle handle);
  Tlibfptr_user_memory_operation = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_continue_print(libfptr_handle handle);
  Tlibfptr_continue_print = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_init_mgm(libfptr_handle handle);
  Tlibfptr_init_mgm = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_util_form_tlv(libfptr_handle handle);
  Tlibfptr_util_form_tlv = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_util_mapping(libfptr_handle handle);
  Tlibfptr_util_mapping = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_util_form_nomenclature(libfptr_handle handle);
  Tlibfptr_util_form_nomenclature = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_log_write(const wchar_t *tag, int level, const wchar_t *message);
  Tlibfptr_log_write = function(Tag:PWchar_t; Level:Integer; Message:PWchar_t):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_show_properties(libfptr_handle handle, int parentType, void *parent);
  Tlibfptr_show_properties = function(Handle:TLibFPtrHandle; ParentType:Integer; Parent:Pointer):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_read_model_flags(libfptr_handle handle);
  Tlibfptr_read_model_flags = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_line_feed(libfptr_handle handle);
  Tlibfptr_line_feed = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_flash_firmware(libfptr_handle handle);
  Tlibfptr_flash_firmware = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_soft_lock_init(libfptr_handle handle);
  Tlibfptr_soft_lock_init = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_soft_lock_query_session_code(libfptr_handle handle);
  Tlibfptr_soft_lock_query_session_code = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_soft_lock_validate(libfptr_handle handle);
  Tlibfptr_soft_lock_validate = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_util_calc_tax(libfptr_handle handle);
  Tlibfptr_util_calc_tax = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_util_tag_info(libfptr_handle handle);
  Tlibfptr_util_tag_info = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_bluetooth_remove_paired_devices(libfptr_handle handle);
  Tlibfptr_bluetooth_remove_paired_devices = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_util_container_versions(libfptr_handle handle);
  Tlibfptr_util_container_versions = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_activate_licenses(libfptr_handle handle);
  Tlibfptr_activate_licenses = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_remove_licenses(libfptr_handle handle);
  Tlibfptr_remove_licenses = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_enter_keys(libfptr_handle handle);
  Tlibfptr_enter_keys = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_validate_keys(libfptr_handle handle);
  Tlibfptr_validate_keys = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_enter_serial_number(libfptr_handle handle);
  Tlibfptr_enter_serial_number = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_get_serial_number_request(libfptr_handle handle);
  Tlibfptr_get_serial_number_request = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_upload_pixel_buffer(libfptr_handle handle);
  Tlibfptr_upload_pixel_buffer = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_download_pixel_buffer(libfptr_handle handle);
  Tlibfptr_download_pixel_buffer = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_print_pixel_buffer(libfptr_handle handle);
  Tlibfptr_print_pixel_buffer = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_util_convert_tag_value(libfptr_handle handle);
  Tlibfptr_util_convert_tag_value = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_parse_marking_code(libfptr_handle handle);
  Tlibfptr_parse_marking_code = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_call_script(libfptr_handle handle);
  Tlibfptr_call_script = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_set_header_lines(libfptr_handle handle);
  Tlibfptr_set_header_lines = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_set_footer_lines(libfptr_handle handle);
  Tlibfptr_set_footer_lines = function(Handle:TLibFPtrHandle):Integer; cdecl;


  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_upload_picture_cliche(libfptr_handle handle);
  Tlibfptr_upload_picture_cliche = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_upload_picture_memory(libfptr_handle handle);
  Tlibfptr_upload_picture_memory = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_upload_pixel_buffer_cliche(libfptr_handle handle);
  Tlibfptr_upload_pixel_buffer_cliche = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_upload_pixel_buffer_memory(libfptr_handle handle);
  Tlibfptr_upload_pixel_buffer_memory = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_exec_driver_script(libfptr_handle handle);
  Tlibfptr_exec_driver_script = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_upload_driver_script(libfptr_handle handle);
  Tlibfptr_upload_driver_script = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_exec_driver_script_by_id(libfptr_handle handle);
  Tlibfptr_exec_driver_script_by_id = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_write_universal_counters_settings(libfptr_handle handle);
  Tlibfptr_write_universal_counters_settings = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_read_universal_counters_settings(libfptr_handle handle);
  Tlibfptr_read_universal_counters_settings = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_query_universal_counters_state(libfptr_handle handle);
  Tlibfptr_query_universal_counters_state = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_reset_universal_counters(libfptr_handle handle);
  Tlibfptr_reset_universal_counters = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_cache_universal_counters(libfptr_handle handle);
  Tlibfptr_cache_universal_counters = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_read_universal_counter_sum(libfptr_handle handle);
  Tlibfptr_read_universal_counter_sum = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_read_universal_counter_quantity(libfptr_handle handle);
  Tlibfptr_read_universal_counter_quantity = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_clear_universal_counters_cache(libfptr_handle handle);
  Tlibfptr_clear_universal_counters_cache = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_disable_ofd_channel(libfptr_handle handle);
  Tlibfptr_disable_ofd_channel = function(Handle:TLibFPtrHandle):Integer; cdecl;
  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_enable_ofd_channel(libfptr_handle handle);
  Tlibfptr_enable_ofd_channel = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_validate_json(libfptr_handle handle);
  Tlibfptr_validate_json = function(Handle:TLibFPtrHandle):Integer; cdecl;

  //DTOX_SHARED_EXPORT int DTOX_SHARED_CCA libfptr_log_write_ex(libfptr_handle handle,
  //                                                             const wchar_t *tag, int level,
  //                                                             const wchar_t *message);
  Tlibfptr_log_write_ex = function(Handle:TLibFPtrHandle; Tag:PWchar_t; Level:Integer; Message:PWchar_t):Integer; cdecl;

function AtollWideStrToString(const AValue:TAtollWideString):string;
function StringToAtollWideStr(const AValue:string):TAtollWideString;
implementation

function AtollWideStrToString(const AValue:TAtollWideString):string;
begin
  {$IFDEF WINDOWS}
  Result:=AValue;
  {$ENDIF}
  {$IFDEF LINUX}
  Result:=UCS4StringToWideString(AValue);
  {$ENDIF}
end;

function StringToAtollWideStr(const AValue: string): TAtollWideString;
begin
  {$IFDEF WINDOWS}
  Result:=AValue;
  {$ENDIF}
  {$IFDEF LINUX}
  Result:=WideStringToUCS4String(AValue);
  {$ENDIF}
end;

end.

