unit ManEdit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  xDBControls;

type

  { TManEditForm }

  TManEditForm = class(TForm)
    Button1: TButton;
    Button2: TButton;
    OpenDialog1: TOpenDialog;
    xEditButton1: TxEditButton;
    xLabeledEdit1: TxLabeledEdit;
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure xEditButton1ButtonClick(Sender: TObject);
    procedure xEditButton1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure xLabeledEdit1Enter(Sender: TObject);
  private
    { private declarations }
  public
    CheckName: Boolean;
  end;

var
  ManEditForm: TManEditForm;

implementation

uses DManagerMain, LCLType, LazFileUtils;

{$R *.lfm}

{ TManEditForm }

procedure TManEditForm.FormClose(Sender: TObject; var CloseAction: TCloseAction
  );
begin
  CloseAction:= caHide;
  if ModalResult = mrOK then
  begin
    if xEditButton1.Text = '' then
    begin
      ShowMessage('Не указан путь к приложению');
      xEditButton1.SetFocus;
      CloseAction := caNone;
    end
    else
    if xLabeledEdit1.Text = '' then
    begin
      ShowMessage('Не указано наименование');
      xLabeledEdit1.SetFocus;
      CloseAction := caNone;
    end
    else
    if CheckName then
    begin
      if MainForm.NameExist(xLabeledEdit1.Text) then
      begin
        CloseAction:= caNone;
        ShowMessage('Такое наименование уже есть');
      end;
    end;
  end;
end;

procedure TManEditForm.xEditButton1ButtonClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    xEditButton1.Text := OpenDialog1.FileName;
end;

procedure TManEditForm.xEditButton1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if (Key = VK_RETURN) and (Shift = []) then
    SelectNext(TWinControl(Sender), True, False);
end;

procedure TManEditForm.xLabeledEdit1Enter(Sender: TObject);
var
  AFileName: string;
begin
  if (xLabeledEdit1.Text = '') and (xEditButton1.Text <> '') then
  begin
    AFileName := ExtractFileName(xEditButton1.Text);
    xLabeledEdit1.Text := ExtractFileNameWithoutExt(AFileName);
  end;
end;

end.

