unit dpi_regexp;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo, dpi_mettyps;

type

  { TRegExprImport }

  TRegExprImport = class(TClassImporter)
    function RegExpr_Compile(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_CompilerErrorPosGet(Instance: Pointer): Variant;
    function RegExpr_Dump(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_Exec(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_ExecNext(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_ExecOffset(Instance: TObject; var Params: Variant
      ): Variant;
    function RegExpr_ExecPos(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_ExpressionGet(Instance: Pointer): Variant;
    procedure RegExpr_ExpressionSet(Instance: Pointer; AValue: Variant);
    function RegExpr_Get(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_InputStringGet(Instance: Pointer): Variant;
    procedure RegExpr_InputStringSet(Instance: Pointer; AValue: Variant);
    function RegExpr_LastError(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_LinePairedSeparatorGet(Instance: Pointer): Variant;
    procedure RegExpr_LinePairedSeparatorSet(Instance: Pointer; AValue: Variant
      );
    function RegExpr_LineSeparatorsGet(Instance: Pointer): Variant;
    procedure RegExpr_LineSeparatorsSet(Instance: Pointer; AValue: Variant);
    function RegExpr_MatchGet(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_MatchPosGet(Instance: TObject; var Params: Variant
      ): Variant;
    function RegExpr_ModifierGGet(Instance: Pointer): Variant;
    procedure RegExpr_ModifierGSet(Instance: Pointer; AValue: Variant);
    function RegExpr_ModifierIGet(Instance: Pointer): Variant;
    procedure RegExpr_ModifierISet(Instance: Pointer; AValue: Variant);
    function RegExpr_ModifierMGet(Instance: Pointer): Variant;
    procedure RegExpr_ModifierMSet(Instance: Pointer; AValue: Variant);
    function RegExpr_ModifierRGet(Instance: Pointer): Variant;
    procedure RegExpr_ModifierRSet(Instance: Pointer; AValue: Variant);
    function RegExpr_ModifierSGet(Instance: Pointer): Variant;
    procedure RegExpr_ModifierSSet(Instance: Pointer; AValue: Variant);
    function RegExpr_ModifierStrGet(Instance: Pointer): Variant;
    procedure RegExpr_ModifierStrSet(Instance: Pointer; AValue: Variant);
    function RegExpr_ModifierXGet(Instance: Pointer): Variant;
    procedure RegExpr_ModifierXSet(Instance: Pointer; AValue: Variant);
    function RegExpr_Replace(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_SpaceCharsGet(Instance: Pointer): Variant;
    procedure RegExpr_SpaceCharsSet(Instance: Pointer; AValue: Variant);
    function RegExpr_Split(Instance: TObject; var Params: Variant): Variant;
    function RegExpr_SubExprMatchCountGet(Instance: Pointer): Variant;
    function RegExpr_Substitute(Instance: TObject; var Params: Variant
      ): Variant;
    function RegExpr_WordCharsGet(Instance: Pointer): Variant;
    procedure RegExpr_WordCharsSet(Instance: Pointer; AValue: Variant);

    function RegExp_ExecRegExpr(Instance: TObject; var Params: Variant
      ): Variant;
    function RegExp_SplitRegExpr(Instance: TObject; var Params: Variant
      ): Variant;
    function RegExp_ReplaceRegExpr(Instance: TObject; var Params: Variant
      ): Variant;
    function RegExp_RegExprSubExpressions(Instance: TObject; var Params: Variant
      ): Variant;
  public
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    function Create_Object(AClass: TClass): TObject; override;
    procedure AddMethods(AddMethod: TAddMethodProc); override;
  end;

implementation

uses RegExpr;

{ TRegExprImport }

function TRegExprImport.RegExpr_Compile(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TRegExpr(Instance).Compile;
end;

function TRegExprImport.RegExpr_CompilerErrorPosGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).CompilerErrorPos;
end;

function TRegExprImport.RegExpr_Dump(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TRegExpr(Instance).Dump;
end;

function TRegExprImport.RegExpr_Exec(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: RegExprString;
begin
  S := Params[0];
  Result := TRegExpr(Instance).Exec(S);
end;

function TRegExprImport.RegExpr_ExecNext(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TRegExpr(Instance).ExecNext;
end;

function TRegExprImport.RegExpr_ExecOffset(Instance: TObject;
  var Params: Variant): Variant;
var
  Offset: PtrInt;
begin
  Offset := Params[0];
  Result := TRegExpr(Instance).Exec(Offset);
end;

function TRegExprImport.RegExpr_ExecPos(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TRegExpr(Instance).ExecPos(Params[0]);
end;

function TRegExprImport.RegExpr_ExpressionGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).Expression;
end;

procedure TRegExprImport.RegExpr_ExpressionSet(Instance: Pointer;
  AValue: Variant);
begin
  TRegExpr(Instance).Expression := AValue;
end;

function TRegExprImport.RegExpr_Get(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TRegExpr(Instance).MatchLen[Params[0]];
end;

function TRegExprImport.RegExpr_InputStringGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).InputString;
end;

procedure TRegExprImport.RegExpr_InputStringSet(Instance: Pointer;
  AValue: Variant);
begin
  TRegExpr(Instance).InputString := AValue;
end;

function TRegExprImport.RegExpr_LastError(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TRegExpr(Instance).LastError;
end;

function TRegExprImport.RegExpr_LinePairedSeparatorGet(Instance: Pointer
  ): Variant;
begin
  Result := TRegExpr(Instance).LinePairedSeparator;
end;

procedure TRegExprImport.RegExpr_LinePairedSeparatorSet(Instance: Pointer;
  AValue: Variant);
begin
  TRegExpr(Instance).LinePairedSeparator := AValue;
end;

function TRegExprImport.RegExpr_LineSeparatorsGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).LineSeparators;
end;

procedure TRegExprImport.RegExpr_LineSeparatorsSet(Instance: Pointer;
  AValue: Variant);
begin
  TRegExpr(Instance).LineSeparators := AValue;
end;

function TRegExprImport.RegExpr_MatchGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TRegExpr(Instance).Match[Params[0]];
end;

function TRegExprImport.RegExpr_MatchPosGet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TRegExpr(Instance).MatchPos[Params[0]];
end;

function TRegExprImport.RegExpr_ModifierGGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).ModifierG;
end;

procedure TRegExprImport.RegExpr_ModifierGSet(Instance: Pointer; AValue: Variant
  );
begin
  TRegExpr(Instance).ModifierG := AValue;
end;

function TRegExprImport.RegExpr_ModifierIGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).ModifierI;
end;

procedure TRegExprImport.RegExpr_ModifierISet(Instance: Pointer; AValue: Variant
  );
begin
  TRegExpr(Instance).ModifierI := AValue;
end;

function TRegExprImport.RegExpr_ModifierMGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).ModifierM;
end;

procedure TRegExprImport.RegExpr_ModifierMSet(Instance: Pointer; AValue: Variant
  );
begin
  TRegExpr(Instance).ModifierM := AValue;
end;

function TRegExprImport.RegExpr_ModifierRGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).ModifierR;
end;

procedure TRegExprImport.RegExpr_ModifierRSet(Instance: Pointer; AValue: Variant
  );
begin
  TRegExpr(Instance).ModifierR := AValue;
end;

function TRegExprImport.RegExpr_ModifierSGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).ModifierS;
end;

procedure TRegExprImport.RegExpr_ModifierSSet(Instance: Pointer; AValue: Variant
  );
begin
  TRegExpr(Instance).ModifierS := AValue;
end;

function TRegExprImport.RegExpr_ModifierStrGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).ModifierStr;
end;

procedure TRegExprImport.RegExpr_ModifierStrSet(Instance: Pointer;
  AValue: Variant);
begin
  TRegExpr(Instance).ModifierStr := AValue;
end;

function TRegExprImport.RegExpr_ModifierXGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).ModifierX;
end;

procedure TRegExprImport.RegExpr_ModifierXSet(Instance: Pointer; AValue: Variant
  );
begin
  TRegExpr(Instance).ModifierX := AValue;
end;

function TRegExprImport.RegExpr_Replace(Instance: TObject; var Params: Variant
  ): Variant;
var
  AInputStr, AReplStr: RegExprString;
  AUseSubst: Boolean;
begin
  AInputStr := Params[0];
  AReplStr := Params[1];
  AUseSubst := Params[2];
  Result := TRegExpr(Instance).Replace(AInputStr, AReplStr, AUseSubst);
end;

function TRegExprImport.RegExpr_SpaceCharsGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).SpaceChars;
end;

procedure TRegExprImport.RegExpr_SpaceCharsSet(Instance: Pointer;
  AValue: Variant);
begin
  TRegExpr(Instance).SpaceChars := AValue;
end;

function TRegExprImport.RegExpr_Split(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: RegExprString;
  SL: TStrings;
begin
  S := Params[0];
  SL := TStrings( TSuPtr(Params[1]) );
  TRegExpr(Instance).Split(S, SL);
end;

function TRegExprImport.RegExpr_SubExprMatchCountGet(Instance: Pointer
  ): Variant;
begin
  Result := TRegExpr(Instance).SubExprMatchCount;
end;

function TRegExprImport.RegExpr_Substitute(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TRegExpr(Instance).Substitute(Params[0]);
end;

function TRegExprImport.RegExpr_WordCharsGet(Instance: Pointer): Variant;
begin
  Result := TRegExpr(Instance).WordChars;
end;

procedure TRegExprImport.RegExpr_WordCharsSet(Instance: Pointer; AValue: Variant
  );
begin
  TRegExpr(Instance).WordChars := AValue;
end;

function TRegExprImport.RegExp_ExecRegExpr(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := ExecRegExpr(Params[0], Params[1]);
end;

function TRegExprImport.RegExp_SplitRegExpr(Instance: TObject;
  var Params: Variant): Variant;
var
  SL: TStrings;
begin
  SL := TStrings(TSuPtr( Params[2] ));
  SplitRegExpr(Params[0], Params[1], SL);
end;

function TRegExprImport.RegExp_ReplaceRegExpr(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := ReplaceRegExpr(Params[0], Params[1], Params[2], Params[3]);
end;

function TRegExprImport.RegExp_RegExprSubExpressions(Instance: TObject;
  var Params: Variant): Variant;
var
  ASubExp: TStrings;
begin
  ASubExp := TStrings( TSuPtr(Params[1]) );
  Result := RegExprSubExpressions(Params[0], ASubExp, Params[2]);
end;

procedure TRegExprImport.AddClasses(AddClass: TAddClassProc;
  AddRecord: TAddRecordProc);
begin
  AddClass(TRegExpr).ClassImporter := Self;
end;

procedure TRegExprImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TRegExpr then
  begin
    AType.AddProp('Expression', 'string', @RegExpr_ExpressionGet, @RegExpr_ExpressionSet);
    AType.AddProp('ModifierStr', 'string', @RegExpr_ModifierStrGet, @RegExpr_ModifierStrSet);
    AType.AddProp('ModifierI', 'Boolean', @RegExpr_ModifierIGet, @RegExpr_ModifierISet);
    AType.AddProp('ModifierR', 'Boolean', @RegExpr_ModifierRGet, @RegExpr_ModifierRSet);
    AType.AddProp('ModifierS', 'Boolean', @RegExpr_ModifierSGet, @RegExpr_ModifierSSet);
    AType.AddProp('ModifierG', 'Boolean', @RegExpr_ModifierGGet, @RegExpr_ModifierGSet);
    AType.AddProp('ModifierM', 'Boolean', @RegExpr_ModifierMGet, @RegExpr_ModifierMSet);
    AType.AddProp('ModifierX', 'boolean', @RegExpr_ModifierXGet, @RegExpr_ModifierXSet);
    AType.AddProp('InputString', 'string', @RegExpr_InputStringGet, @RegExpr_InputStringSet);
    AType.AddProp('SubExprMatchCount', 'Integer', @RegExpr_SubExprMatchCountGet);
    AType.AddProp('CompilerErrorPos', 'LongInt', @RegExpr_CompilerErrorPosGet);
    AType.AddProp('SpaceChars', 'string', @RegExpr_SpaceCharsGet, @RegExpr_SpaceCharsSet);
    AType.AddProp('WordChars', 'string', @RegExpr_WordCharsGet, @RegExpr_WordCharsSet);
    AType.AddProp('LineSeparators', 'string', @RegExpr_LineSeparatorsGet, @RegExpr_LineSeparatorsSet);
    AType.AddProp('LinePairedSeparator', 'string', @RegExpr_LinePairedSeparatorGet, @RegExpr_LinePairedSeparatorSet);
    AType.AddIndexedProp('MatchPos','LongInt','Integer', @RegExpr_MatchPosGet);
    AType.AddIndexedProp('MatchLen','LongInt','Integer', @RegExpr_Get);
    AType.AddIndexedProp('Match','string','integer', @RegExpr_MatchGet);
    AType.AddMethod('function Exec(const AInputString: string): boolean', @RegExpr_Exec);
    AType.AddMethod('function ExecOffset(AOffset: LongInt): boolean', @RegExpr_ExecOffset);
    AType.AddMethod('function ExecNext: boolean', @RegExpr_ExecNext);
    AType.AddMethod('function ExecPos(AOffset: LongInt): boolean', @RegExpr_ExecPos);
    AType.AddMethod('function Substitute(const ATemplate: string): string', @RegExpr_Substitute);
    AType.AddMethod('procedure Split (AInputStr: string; APieces: TStrings)', @RegExpr_Split);
    AType.AddMethod('function Replace (AInputStr: string; const AReplaceStr: string; AUseSubstitution: boolean): string', @RegExpr_Replace);
    AType.AddMethod('function LastError: integer', @RegExpr_LastError);
    AType.AddMethod('procedure Compile', @RegExpr_Compile);
    AType.AddMethod('function Dump: string', @RegExpr_Dump);

  end;
end;

function TRegExprImport.Create_Object(AClass: TClass): TObject;
begin
  Result := nil;
  if AClass = TRegExpr then Result := TRegExpr.Create;
end;

procedure TRegExprImport.AddMethods(AddMethod: TAddMethodProc);
begin
  AddMethod('function ExecRegExpr(const ARegExpr, AInputStr: string): boolean', @RegExp_ExecRegExpr);
  AddMethod('procedure SplitRegExpr(const ARegExpr, AInputStr: string; APieces: TStrings)', @RegExp_SplitRegExpr);
  AddMethod('function ReplaceRegExpr(const ARegExpr, AInputStr, AReplaceStr: string; AUseSubstitution: boolean): string', @RegExp_ReplaceRegExpr);
  AddMethod('function RegExprSubExpressions(const ARegExpr: string; ASubExprs: TStrings; AExtendedSyntax: boolean): LongInt', @RegExp_RegExprSubExpressions);
end;

end.

