{------------------------------------------------------------------------------}
{                                                                              }
{                               Yuriy Kopnin                                   }
{                                   LGPL                                       }
{                                                                              }
{------------------------------------------------------------------------------}
unit ComponentExport;

{$mode objfpc}{$H+}

interface

{$I SetComponent.inc}

uses
  Classes, SysUtils, Menus, StdCtrls, ExtCtrls, ActnList, Buttons,
  MaskEdit, CheckLst, Forms, PairSplitter, ColorBox, ValEdit, Controls,
  dpCompil, LCLType, dpUtils, Dialogs, ExtDlgs, BufDataset,
  dbf, SdfData, memds,
  {$IFDEF SYNAPSE} SuSynapse, {$ENDIF}
  {$IFDEF DEVARTDAC}
  SuDevartDB, VirtualTable,
    {$IFDEF IBDAC} IBC, IBCScript, IBCAlerter, IBCLoader,
      IBCSQLMonitor, IbDacVcl, IBCAdmin, CRBatchMove, suibdac,
      IBCSQLEdits,
    {$ENDIF}
  {$ENDIF}
  {$IFDEF IBX}
    IBQuery, IBCustomDataSet, IBDatabase, IBSQL, IBStoredProc,
    SuIBX, IBUpdateSQL, IBEvents, IBSQLMonitor, IBBatchMove, IBTable,
    IBExtract, IBDatabaseInfo, IBServices,
  {$ENDIF}
  {$IFDEF ZEOS}
  ZConnection, ZDataset, ZSqlUpdate, ZConnectionGroup, ZGroupedConnection,
  ZStoredProcedure, ZSqlMetadata, ZSqlProcessor, ZSqlMonitor, ZSequence,
  ZIBEventAlerter, ZPgEventAlerter, SuZEOSImport,
  {$ENDIF}
  {$IFDEF LAZREPORT}
  LR_Class, LR_DBSet, LR_BarC, LR_RRect,LR_Shape, LR_ChBox, LR_DSet, LR_E_TXT,
  LR_E_HTM, LR_E_CSV, LR_Desgn, LR_View, lr_barcodes2d, lr_PDF417,
  dpi_LazReport, {$IfDef LRCAIROEXP} lr_e_cairo, {$EndIf}
  {$IFDEF LRADDFUNC} lrAddFunctionLibrary,{$ENDIF}
  {$ENDIF}
  {$IFDEF JSON}
  dpi_JSON,
  {$ENDIF}
  {$IFDEF REGEXPRES}
  dpi_regexp,
  {$EndIf}
  {$IfDef CHART}
  TAGraph, TASources, TADbSource, dpi_chart, TATransformations, TAStyles,
  TAIntervalSources,
  {$EndIf}
  {$IFDEF FASTREPORT}
  frxLazarusComponentEditors,
  frxDesgn, frxClass, frxDCtrl,
  frxBarcode,  frxPreview, frxCross,  frxPrinter,
  frxGradient, frxDBSet, SuFRImport, frxChBox,

  {frxRich, frxChart, frxOLE, frxDMPExport, frxExportImage, frxExportRTF,
  frxExportXML, frxExportXLS, frxExportHTML, frxGZip, frxExportPDF,
  frxExportText, frxExportCSV, frxExportMail,
  frxExportODF, frxCrypt,}

  {$EndIf}
  {$IFDEF FPHTTPSERV}
  dpi_fphttpserv, fphttpserver, fphttpclient,
  {$ENDIF}
  {$IFDEF WINDOWS}
  activexcontainer,
  {$ENDIF}
  db;

type
  TComponentRegProc = procedure (PanelName: string; AClass: TComponentClass) of Object;

  TCompletionItemType = (citProp, citIndexProp, citObject, citVariable, citProc, citFunc,
    citField, citKwd, citTable, citInParam, citOutParam, citConst, citList, citType);

  TGetSupportProc = procedure (AType: TCompletionItemType; AName, AParam, AResult: string) of Object;


procedure RegComponent(RegisterComonent: TComponentRegProc);
procedure AddImporters(AddImporter: TAddImporterProc);
procedure AddScriptObj(AddObject: TAddObjectProc);
procedure ScriptAddConst(AddConst: TAddConstProc);
procedure GetDefaultContextList(GetProc: TGetSupportProc);

var
  Compil: TDpCompiler;

implementation

uses DbCtrls, DBGrids, xDBGrids, ComCtrls, PopupNotifier, process, XMLConf,
  Spin, Arrow, Calendar, EditBtn, FileCtrl, ButtonPanel, XMLPropStorage,
  IniPropStorage, ShellCtrls, xDBControls, dpi_VisualTech, dpi_Misc,
  dpi_System, SuFrame, xFormsBar, dpi_Xml, xdbf,
  {$IFDEF UOS} dpi_uos,{$ENDIF}
  {$IfDef ATOLKKM} dpi_AtolKKM, KKM_Atol,{$EndIf}
  {$IfDef FP_SPREADSHEET}
  dpi_fpspreadsheet, fpspreadsheetctrls,
  fpspreadsheetgrid,
  {$EndIf}
  {$IFDEF WINDOWS} dpi_activex, {$ENDIF}
  {$IFDEF WINAPI_CLASS}
  dpi_WinApi,
  {$ENDIF}
  Grids, BarCodeHook;

procedure RegComponent(RegisterComonent: TComponentRegProc);
var
  S: string;
begin
  S := 'Standard';
  RegisterComonent(S, TMainMenu);
  RegisterComonent(S, TPopupMenu);
  RegisterComonent(S, TButton);
  RegisterComonent(S, TLabel);
  RegisterComonent(S, TEdit);
  RegisterComonent(S, TMemo);
  RegisterComonent(S, TToggleBox);
  RegisterComonent(S, TCheckBox);
  RegisterComonent(S, TListBox);
  RegisterComonent(S, TComboBox);
  RegisterComonent(S, TGroupBox);
  RegisterComonent(S, TRadioGroup);
  RegisterComonent(S, TCheckGroup);
  RegisterComonent(S, TPanel);
  RegisterComonent(S, TActionList);

  //RegisterComponentEditor(TActionList, TActionListEditor);

  S := 'Additional';
  RegisterComonent(S, TBitBtn);
  RegisterComonent(S, TSpeedButton);
  RegisterComonent(S, TStaticText);
  RegisterComonent(S, TImage);
  RegisterComonent(S, TShape);
  RegisterComonent(S, TBevel);
  RegisterComonent(S, TLabeledEdit);
  RegisterComonent(S, TSplitter);
  RegisterComonent(S, TTrayIcon);
  RegisterComonent(S, TMaskEdit);
  RegisterComonent(S, TCheckListBox);
  RegisterComonent(S, TScrollBox);
  RegisterComonent(S, TApplicationProperties);
  RegisterComonent(S, TPairSplitter);
  RegisterComonent(S, TColorBox);
  RegisterComonent(S, TColorListBox);
  RegisterComonent(S, TStringGrid);
  RegisterComonent(S, TValueListEditor);

  S := 'Common Controls';
  RegisterComonent(S, TTrackBar);
  RegisterComonent(S, TProgressBar);
  RegisterComonent(S, TTreeView);
  RegisterComonent(S, TListView);
  RegisterComonent(S, TStatusBar);
  RegisterComonent(S, TToolBar);
  RegisterComonent(S, TUpDown);
  RegisterComonent(S, TPageControl);
  RegisterComonent(S, TTabControl);
  RegisterComonent(S, THeaderControl);
  RegisterComonent(S, TImageList);
  RegisterComonent(S, TPopupNotifier);

  S := 'Dialogs';
  RegisterComonent(S, TOpenDialog);
  RegisterComonent(S, TSaveDialog);
  RegisterComonent(S, TSelectDirectoryDialog);
  RegisterComonent(S, TColorDialog);
  RegisterComonent(S, TFontDialog);
  RegisterComonent(S, TFindDialog);
  RegisterComonent(S, TReplaceDialog);
  RegisterComonent(S, TOpenPictureDialog);
  RegisterComonent(S, TSavePictureDialog);
  RegisterComonent(S, TCalendarDialog);
  RegisterComonent(S, TCalculatorDialog);

  S := 'System';
  RegisterComonent(S, TTimer);
  RegisterComonent(S, TIdleTimer);
  RegisterComonent(S, TProcess);
  //RegisterComonent(S, TXMLConfig);

  S := 'Misc';
  RegisterComonent(S, TColorButton);
  RegisterComonent(S, TSpinEdit);
  RegisterComonent(S, TFloatSpinEdit);
  RegisterComonent(S, TArrow);
  RegisterComonent(S, TCalendar);
  RegisterComonent(S, TEditButton);
  RegisterComonent(S, TFileNameEdit);
  RegisterComonent(S, TDirectoryEdit);
  RegisterComonent(S, TDateEdit);
  RegisterComonent(S, TCalcEdit);
  RegisterComonent(S, TFileListBox);
  RegisterComonent(S, TFilterComboBox);
  //RegisterComonent(S, TXMLPropStorage);
  //RegisterComonent(S, TIniPropStorage);
  //RegisterComonent(S, TBarChart);
  RegisterComonent(S, TButtonPanel);
  RegisterComonent(S, TShellTreeView);
  RegisterComonent(S, TShellListView);

  S := 'Data Controls';
  RegisterComonent(S, TDBNavigator);
  RegisterComonent(S, TDBText);
  RegisterComonent(S, TDBEdit);
  RegisterComonent(S, TDBMemo);
  RegisterComonent(S, TDBImage);
  RegisterComonent(S, TDBListBox);
  RegisterComonent(S, TDBLookupListBox);
  RegisterComonent(S, TDBComboBox);
  RegisterComonent(S, TDBLookupComboBox);
  RegisterComonent(S, TDBCheckBox);
  RegisterComonent(S, TDBRadioGroup);
  RegisterComonent(S, TDBCalendar);
  RegisterComonent(S, TDBGroupBox);
  RegisterComonent(S, TDBGrid);

  S := 'Data Access';
  RegisterComonent(S, TDataSource);
  RegisterComonent(S, TMemDataset);
  RegisterComonent(S, TBufDataset);
  RegisterComonent(S, TxDbf);
  {$IFDEF DEVARTDAC}
  RegisterComonent(S, TVirtualTable);
  RegisterComonent(S, TCRBatchMove);
  {$ENDIF}
  RegisterComonent(S, TSdfDataSet);
  RegisterComonent(S, TFixedFormatDataSet);

  S := 'VisualTech';
  RegisterComonent(S, TFormsBar);
  RegisterComonent(S, TLabeledDBEdit);
  RegisterComonent(S, TDBEditButton);
  RegisterComonent(S, TLabeledDBCombo);
  RegisterComonent(S, TLabeledDBLookupCombo);
  RegisterComonent(S, TxDBGrid);
  RegisterComonent(S, TxDBCheckBox);
  RegisterComonent(S, TxSpeedBtn);
  RegisterComonent(S, TxBitBtn);
  RegisterComonent(S, TxLabeledEdit);
  RegisterComonent(S, TxLabeledCombo);
  RegisterComonent(S, TxEditButton);
  RegisterComonent(S, TBarCodeHook);

  {$IFDEF IBDAC}
  S := 'IBDAC';
  RegisterComonent(S, TIBCConnection);
  RegisterComonent(S, TIBCTransaction);
  RegisterComonent(S, TIBCQuery);
  RegisterComonent(S, TIBCTable);
  RegisterComonent(S, TIBCStoredProc);
  RegisterComonent(S, TIBCSQL);
  RegisterComonent(S, TIBCScript);
  RegisterComonent(S, TIBCUpdateSQL);
  RegisterComonent(S, TIBCDataSource);
  RegisterComonent(S, TIBCAlerter);
  RegisterComonent(S, TIBCLoader);
  RegisterComonent(S, TIBCMetaData);
  RegisterComonent(S, TIBCSQLMonitor);
  RegisterComonent(S, TIBCConnectDialog);
  RegisterComonent(S, TIBCEncryptor);

  S := 'IBDAC Services';
  RegisterComonent(S, TIBCConfigService);
  RegisterComonent(S, TIBCBackupService);
  RegisterComonent(S, TIBCRestoreService);
  RegisterComonent(S, TIBCValidationService);
  RegisterComonent(S, TIBCStatisticalService);
  RegisterComonent(S, TIBCLogService);
  RegisterComonent(S, TIBCSecurityService);
  RegisterComonent(S, TIBCServerProperties);
  RegisterComonent(S, TIBCLicensingService);
  RegisterComonent(S, TIBCTraceService);
  {$ENDIF}
  {$IFDEF ZEOS}
  S := 'Zeos Access';
  RegisterComonent(S, TZConnection);
  RegisterComonent(S, TZReadOnlyQuery);
  RegisterComonent(S, TZQuery);
  RegisterComonent(S, TZTable);
  RegisterComonent(S, TZUpdateSQL);
  RegisterComonent(S, TZStoredProc);
  RegisterComonent(S, TZSQLMetadata);
  RegisterComonent(S, TZSQLProcessor);
  RegisterComonent(S, TZSQLMonitor);
  RegisterComonent(S, TZSequence);
  RegisterComonent(S, TZIBEventAlerter);
  RegisterComonent(S, TZPgEventAlerter);
  {$ENDIF}
  {$IFDEF IBX}
  S := 'Firebird';
  RegisterComonent(S, TIBDataBase);
  RegisterComonent(S, TIBTransaction);
  RegisterComonent(S, TIBDataSet);
  RegisterComonent(S, TIBQuery);
  RegisterComonent(S, TIBStoredProc);
  RegisterComonent(S, TIBUpdateSQL);
  RegisterComonent(S, TIBSQL);
  RegisterComonent(S, TIBDatabaseInfo);
  RegisterComonent(S, TIBSQLMonitor);
  RegisterComonent(S, TIBBatchMove);
  RegisterComonent(S, TIBTable);
  RegisterComonent(S, TIBExtract);
  RegisterComonent(S, TIBEvents);
  S := 'Firebird Admin';
  RegisterComonent(S, TIBConfigService);
  RegisterComonent(S, TIBBackupService);
  RegisterComonent(S, TIBRestoreService);
  RegisterComonent(S, TIBValidationService);
  RegisterComonent(S, TIBStatisticalService);
  RegisterComonent(S, TIBLogService);
  RegisterComonent(S, TIBSecurityService);
  //RegisterComonent(S, TIBServerProperties);
  {$ENDIF}
  {$IFDEF LAZREPORT}
  S := 'LazReport';
  RegisterComonent(S, TfrReport);
  RegisterComonent(S, TfrDBDataSet);
  RegisterComonent(S, TfrBarCodeObject);
  RegisterComonent(S, TfrBarCode2d);
  RegisterComonent(S, TfrPDF417);
  RegisterComonent(S, TfrRoundRectObject);
  RegisterComonent(S, TfrShapeObject);
  RegisterComonent(S, TfrCheckBoxObject);
  RegisterComonent(S, TfrCompositeReport);
  RegisterComonent(S, TfrUserDataset);
  RegisterComonent(S, TfrTextExport);
  RegisterComonent(S, TfrHTMExport);
  RegisterComonent(S, TfrCSVExport);
  RegisterComonent(S, TfrDesigner);
  RegisterComonent(S, TfrPreview);
    //{$IfDef LRCAIROEXP}
    //RegisterComonent(S, TlrCairoExport);
    //{$EndIf}
  {$ENDIF}
  {$IFDEF FASTREPORT}
  S := 'FastReport 4';
  RegisterComonent(S, TfrxReport);
  RegisterComonent(S, TfrxUserDataSet);
  RegisterComonent(S, TfrxDBDataset);
  {RegisterComonent(S, TfrxCheckBoxObject);
  RegisterComonent(S, TfrxGradientObject);
  RegisterComonent(S, TfrxCrossObject);}
  {$ENDIF}
  {$IfDef ATOLKKM}
  S := 'TradeEquipment';
  RegisterComonent(S, TAtollKKM);
  {$EndIf}
  {$IfDef CHART}
  S := 'Chart';
  RegisterComonent(S, TChart);
  RegisterComonent(S, TListChartSource);
  RegisterComonent(S, TDbChartSource);
  RegisterComonent(S, TChartStyles);
  RegisterComonent(S, TChartAxisTransformations);
  RegisterComonent(S, TIntervalChartSource);
  RegisterComonent(S, TDateTimeIntervalChartSource);
  {$EndIf}
  {$IfDef FP_SPREADSHEET}
  S := 'FPSpreadSheet';
  RegisterComonent(S, TsWorkbookSource);
  RegisterComonent(S, TsWorkbookTabControl);
  RegisterComonent(S, TsCellEdit);
  RegisterComonent(S, TsCellIndicator);
  RegisterComonent(S, TsCellCombobox);
  RegisterComonent(S, TsSpreadsheetInspector);
  RegisterComonent(S, TsWorksheetGrid);
  {$EndIf}
  {$IfDef WINDOWS}
  S := 'ActiveX';
  RegisterComonent(S, TActiveXContainer);
  {$EndIf}

  {$IfDef FPHTTPSERV}
  S := 'fpWeb';
  RegisterComonent(S, TFPHttpServer);
  RegisterComonent(S, TFPHTTPClient);
  {$EndIf}
end;

procedure AddImporters(AddImporter: TAddImporterProc);
begin
  AddImporter(TVisualTechImport);
  AddImporter(TSuMiscImport);
  AddImporter(TSuSystemImport);
  AddImporter(TXMLImport);

  {$IFDEF DEVARTDAC}
    AddImporter(TDevartDacImport);
    {$IFDEF IBDAC}
    AddImporter(TIBDacImport);
    {$ENDIF}
  {$ENDIF}

  {$IFDEF SYNAPSE} AddImporter(TSynapseImport); {$ENDIF}

  {$IFDEF ZEOS} AddImporter(TZEOSImport); {$ENDIF}

  {$IFDEF IBX} AddImporter(TIBXImport); {$ENDIF}

  {$IFDEF LAZREPORT} AddImporter(TLazReportImport); {$ENDIF}

  {$IFDEF FASTREPORT}AddImporter(TFRImport); {$ENDIF}

  {$IFDEF UOS} AddImporter(TdpUOSImport); {$EndIf}

  {$IfDef ATOLKKM} AddImporter(TAtolKKMImport); {$EndIf}

  {$IfDef FP_SPREADSHEET} AddImporter(TSpradSheetImport); {$EndIf}

  {$IfDef JSON} AddImporter(TJSONImport); {$EndIf}

  {$IfDef REGEXPRES} AddImporter(TRegExprImport); {$EndIf}

  {$IfDef CHART} AddImporter(TChartImport); {$EndIf}

  {$IFDEF WINDOWS} AddImporter(TActiveXImport); {$ENDIF}

  {$IFDEF WINAPI_CLASS}AddImporter(TWinApiImport);{$ENDIF}

  {$IfDef FPHTTPSERV} AddImporter(TFpHttpServImport); {$EndIf}


end;

procedure AddScriptObj(AddObject: TAddObjectProc);
begin
  AddObject('Application', Application);
  AddObject('Screen', Screen);
  AddObject('Mouse', Mouse);
  //AddObject('Clipboard', Clipboard);

end;

procedure ScriptAddConst(AddConst: TAddConstProc);
begin
  AddConst('SW_HIDE', 'Integer', SW_HIDE);
  AddConst('SW_SHOWNORMAL', 'Integer', SW_SHOWNORMAL);
  AddConst('SW_NORMAL', 'Integer', SW_NORMAL);
  AddConst('SW_SHOWMINIMIZED', 'Integer', SW_SHOWMINIMIZED);
  AddConst('SW_SHOWMAXIMIZED', 'Integer', SW_SHOWMAXIMIZED);
  AddConst('SW_MAXIMIZE', 'Integer', SW_MAXIMIZE);
  AddConst('SW_SHOWNOACTIVATE', 'Integer', SW_SHOWNOACTIVATE);
  AddConst('SW_SHOW', 'Integer', SW_SHOW);
  AddConst('SW_MINIMIZE', 'Integer', SW_MINIMIZE);
  AddConst('SW_SHOWMINNOACTIVE', 'Integer', SW_SHOWMINNOACTIVE);
  AddConst('SW_SHOWNA', 'Integer', SW_SHOWNA);
  AddConst('SW_RESTORE', 'Integer', SW_RESTORE);
  AddConst('SW_SHOWDEFAULT', 'Integer', SW_SHOWDEFAULT);
  AddConst('SW_MAX', 'Integer', SW_MAX);
  AddConst('SW_SCROLLCHILDREN', 'Integer', SW_SCROLLCHILDREN);
  AddConst('SW_INVALIDATE', 'Integer', SW_INVALIDATE);
  AddConst('SW_ERASE', 'Integer', SW_ERASE);
  AddConst('SW_SMOOTHSCROLL', 'Integer', SW_SMOOTHSCROLL);
  {$IFDEF WINDOWS}
  AddConst('WINDOWS', 'Boolean', True);
  AddConst('LINUX', 'Boolean', False);
  AddConst('MACOS', 'Boolean', False);
  {$ENDIF}

  {$IFDEF LINUX}
  AddConst('LINUX', 'Boolean', True);
  AddConst('WINDOWS', 'Boolean', False);
  AddConst('MACOS', 'Boolean', False);
  {$ENDIF}

  {$IFDEF MACOS}
  AddConst('MACOS', 'Boolean', True);
  AddConst('LINUX', 'Boolean', False);
  AddConst('WINDOWS', 'Boolean', False);
  {$ENDIF}
end;

procedure GetDefaultContextList(GetProc: TGetSupportProc);
var
  I, N: Integer;
  SyType: TDpType;
  SuObj: TIdentObject;
  AValue, S: string;
  ITip: TCompletionItemType;
  Proc: TDpCustomProc;
  Param, VarPref, ConstPref: string;
begin
  if Compil <> nil then
  begin
    VarPref := 'var ';
    ConstPref := 'const ';

    for I := 0 to Compil.TypeTable.Count - 1 do
    begin
      SyType := Compil.TypeTable.Items[I];
      AValue := '';
      if SyType.BaseType = btRecord then AValue := 'record';
      GetProc(citType, SyType.OriginalName, '', AValue);
    end;

    for I := 0 to Compil.ExternalObject.Count - 1 do
    begin
      SuObj := Compil.ExternalObject.Items[I];
      case SuObj.IdentType of
        itType:
          GetProc(citType, SuObj.OriginalName, '', '');
        itClassComponent:
          GetProc(citObject, SuObj.OriginalName, '', '');
        itProp:
          GetProc(citProp, SuObj.OriginalName, '', '');
        itConst:
        begin
          S := SuObj.Value;
          if S <> '' then S := ' = ' + S;
          AValue := SuObj.ValueType.OriginalName + S;
          GetProc(citConst, SuObj.OriginalName, '', AValue);
        end;
        itVar, itParam, itClassVar:
          GetProc(citVariable, SuObj.OriginalName, '', SuObj.ValueType.OriginalName);
        itProc:
        begin
          ITip := citProc;
          AValue := '';
          Proc := TDpCustomProc(SuObj);
          if Proc.FIsFunction then
          begin
            ITip := citFunc;
            AValue := Proc.ValueType.OriginalName;
          end;
          Param := '';
          for N := 0 to Proc.ParamCount - 1 do
          begin
            if N > 0 then Param := Param + ', ';
            if Proc.Param[N].AsPointer then Param := Param + VarPref
            else
            if Proc.Param[N].OnlyRead then Param := Param + ConstPref;
            Param := Param + Proc.Param[N].OriginalName + ': ' + Proc.Param[N].ValueType.OriginalName;
          end;
          GetProc(ITip, SuObj.OriginalName, Param, AValue);
        end;
        else
          GetProc(citVariable, SuObj.OriginalName, '', '');
      end;
    end;
  end;
end;

end.

