unit dpi_DB;

{$mode objfpc}{$H+}
{$M+}

interface

uses
  Classes, SysUtils, dpCompil, TypInfo;

type

  { TDataImport }

  TDataImport = class(TClassImporter)
    function BlobField_BlobSize(Instance: Pointer): Variant;
    function BlobField_LoadFromFile(Instance: TObject; var Params: Variant
      ): Variant;
    function BlobField_LoadFromStream(Instance: TObject; var Params: Variant
      ): Variant;
    function BlobField_ModifiedGet(Instance: Pointer): Variant;
    procedure BlobField_ModifiedSet(Instance: Pointer; AValue: Variant);
    function BlobField_SaveToFile(Instance: TObject; var Params: Variant
      ): Variant;
    function BlobField_SaveToStream(Instance: TObject; var Params: Variant
      ): Variant;
    function BlobField_TransliterateGet(Instance: Pointer): Variant;
    procedure BlobField_TransliterateSet(Instance: Pointer; AValue: Variant);
    function BlobField_ValueGet(Instance: Pointer): Variant;
    procedure BlobField_ValueSet(Instance: Pointer; AValue: Variant);
    function Field_EditMaskGet(Instance: Pointer): Variant;
    procedure Field_EditMaskSet(Instance: Pointer; AValue: Variant);
    function TDataSet_BookmarkValid(Instance: TObject; var Params: Variant
      ): Variant;
    function TDataSet_FreeBookmark(Instance: TObject; var Params: Variant
      ): Variant;
    function TDataSet_GetBookmark(Instance: TObject; var Params: Variant
      ): Variant;
    function TDataSet_GotoBookmark(Instance: TObject; var Params: Variant
      ): Variant;
    function TFielDefs_Add(Instance: TObject; var Params: Variant): Variant;
    function TFielDefs_AddFieldDef(Instance: TObject; var Params: Variant
      ): Variant;
    function TFielDefs_AddSize(Instance: TObject; var Params: Variant): Variant;
    function TFielDefs_AddSizeR(Instance: TObject; var Params: Variant
      ): Variant;
    function TFielDefs_Assign(Instance: TObject; var Params: Variant): Variant;
    function TFielDefs_Find(Instance: TObject; var Params: Variant): Variant;
    function TFielDefs_ItemsGet(Instance: TObject; var Params: Variant
      ): Variant;
    function TFielDefs_ItemsSet(Instance: TObject; var Params: Variant
      ): Variant;
    function TField_IsBlob(Instance: TObject; var Params: Variant): Variant;

  private
    function Field_CalculatedGet(Instance: Pointer): Variant;
    procedure Field_CalculatedSet(Instance: Pointer; AValue: Variant);
    function Field_CanModifyGet(Instance: Pointer): Variant;
    function Field_DataSetGet(Instance: Pointer): Variant;
    procedure Field_DataSetSet(Instance: Pointer; AValue: Variant);
    function Field_DisplayNameGet(Instance: Pointer): Variant;
    function Field_DisplayTextGet(Instance: Pointer): Variant;
    function Field_FieldDefGet(Instance: Pointer): Variant;
    function Field_FieldNoGet(Instance: Pointer): Variant;
    function Field_IsIndexFieldGet(Instance: Pointer): Variant;
    function Field_SizeGet(Instance: Pointer): Variant;
    procedure Field_SizeSet(Instance: Pointer; AValue: Variant);
    function Field_TextGet(Instance: Pointer): Variant;
    procedure Field_TextSet(Instance: Pointer; AValue: Variant);
    function TDataSet_FieldDefsGet(Instance: Pointer): Variant;
    procedure TDataSet_FieldDefsSet(Instance: Pointer; AValue: Variant);
    function TFielDef_CharSizeGet(Instance: Pointer): Variant;
    function TFielDef_CreateField(Instance: TObject; var Params: Variant
      ): Variant;
    function TFielDef_InternalCalcFieldGet(Instance: Pointer): Variant;
    procedure TFielDef_InternalCalcFieldSet(Instance: Pointer; AValue: Variant);
    function TFielDef_RequiredGet(Instance: Pointer): Variant;
    procedure TFielDef_RequiredSet(Instance: Pointer; AValue: Variant);
    function TField_FocusControl(Instance: TObject; var Params: Variant
      ): Variant;
  public
    procedure AddTypes(AddType: TAddTypeProc); override;
    procedure AddSimpleTypes(AddType: TAddSimpleTypeProc); override;
    procedure AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc); override;
    procedure RegisterPublic(AType: TDpType); override;
    procedure AddConsts(AddConst: TAddConstProc); override;
    procedure RegisterHandlers(RegisterHandler: TRegHandlerProc); override;

  published
    {Support TField}
    function TField_Bool_Get(Instance: Pointer): Variant;
    procedure TField_Bool_Set(Instance: Pointer; AValue: Variant);
    function TField_Curen_Get(Instance: Pointer): Variant;
    procedure TField_Curen_Set(Instance: Pointer; AValue: Variant);
    function TField_DateTime_Get(Instance: Pointer): Variant;
    procedure TField_DateTime_Set(Instance: Pointer; AValue: Variant);
    function TField_Float_Get(Instance: Pointer): Variant;
    procedure TField_Float_Set(Instance: Pointer; AValue: Variant);
    function TField_Int_Get(Instance: Pointer): Variant;
    procedure TField_Int_Set(Instance: Pointer; AValue: Variant);
    function TField_LageInt_Get(Instance: Pointer): Variant;
    procedure TField_LageInt_Set(Instance: Pointer; AValue: Variant);
    function TField_String_Get(Instance: Pointer): Variant;
    procedure TField_String_Set(Instance: Pointer; AValue: Variant);
    function TField_Variant_Get(Instance: Pointer): Variant;
    procedure TField_Variant_Set(Instance: Pointer; AValue: Variant);
    function TField_Value_Get(Instance: Pointer): Variant;
    procedure TField_Value_Set(Instance: Pointer; AValue: Variant);
    function TField_Text_Get(Instance: Pointer): Variant;
    procedure TField_Text_Set(Instance: Pointer; AValue: Variant);
    function TField_IsNull_Get(Instance: Pointer): Variant;
    function TField_OldValue_Get(Instance: Pointer): Variant;
    function TField_NewValue_Get(Instance: Pointer): Variant;
    procedure TField_NewValue_Set(Instance: Pointer; AValue: Variant);
    function TField_Clear(Instance: TObject; var Params: Variant): Variant;
    {Support TFields}
    function TFields_Add(Instance: TObject; var Params: Variant): Variant;
    function TFields_FindField(Instance: TObject; var Params: Variant): Variant;
    function TFields_FN(Instance: TObject; var Params: Variant): Variant;
    function TFields_FBN(Instance: TObject; var Params: Variant): Variant;
    function TFields_GetFieldNames(Instance: TObject; var Params: Variant): Variant;
    function TFields_IndexOf(Instance: TObject; var Params: Variant): Variant;
    function TFields_Remove(Instance: TObject; var Params: Variant): Variant;
    function TFields_Count_Get(Instance: Pointer): Variant;
    function TFields_DataSet_Get(Instance: Pointer): Variant;
    function TFields_Fields_Get(Instance: TObject; var Params: Variant): Variant;
    function TFields_Fields_Set(Instance: TObject; var Params: Variant): Variant;
    {TParam}
    function TParam_Clear(Instance: TObject; var Params: Variant): Variant;
    function TParam_Bool_Get(Instance: Pointer): Variant;
    procedure TParam_Bool_Set(Instance: Pointer; AValue: Variant);
    function TParam_Curen_Get(Instance: Pointer): Variant;
    procedure TParam_Curen_Set(Instance: Pointer; AValue: Variant);
    function TParam_DateTime_Get(Instance: Pointer): Variant;
    procedure TParam_DateTime_Set(Instance: Pointer; AValue: Variant);
    function TParam_Float_Get(Instance: Pointer): Variant;
    procedure TParam_Float_Set(Instance: Pointer; AValue: Variant);
    function TParam_Date_Get(Instance: Pointer): Variant;
    procedure TParam_Date_Set(Instance: Pointer; AValue: Variant);
    function TParam_Time_Get(Instance: Pointer): Variant;
    procedure TParam_Time_Set(Instance: Pointer; AValue: Variant);
    function TParam_Int_Get(Instance: Pointer): Variant;
    procedure TParam_Int_Set(Instance: Pointer; AValue: Variant);
    function TParam_LageInt_Get(Instance: Pointer): Variant;
    procedure TParam_LageInt_Set(Instance: Pointer; AValue: Variant);
    function TParam_String_Get(Instance: Pointer): Variant;
    procedure TParam_String_Set(Instance: Pointer; AValue: Variant);
    function TParam_Value_Get(Instance: Pointer): Variant;
    procedure TParam_Value_Set(Instance: Pointer; AValue: Variant);
    function TParam_Text_Get(Instance: Pointer): Variant;
    procedure TParam_Text_Set(Instance: Pointer; AValue: Variant);
    function TParam_IsNull_Get(Instance: Pointer): Variant;
    function TParam_AsBlob_Get(Instance: Pointer): Variant;
    procedure TParam_AsBlob_Set(Instance: Pointer; AValue: Variant);
    {TParams}
    {$IFDEF DelphiXE}
    function TParams_AddParameter(Instance: TObject; var Params: Variant): Variant;
    {$ENDIF}
    function TParams_AsignValues(Instance: TObject; var Params: Variant): Variant;
    function TParams_AddParam(Instance: TObject; var Params: Variant): Variant;
    function TParams_RemoveParam(Instance: TObject; var Params: Variant): Variant;
    function TParams_CreateParam(Instance: TObject; var Params: Variant): Variant;
    function TParams_GetParamList(Instance: TObject; var Params: Variant): Variant;
    function TParams_IsEqual(Instance: TObject; var Params: Variant): Variant;
    function TParams_PN(Instance: TObject; var Params: Variant): Variant;
    function TParams_FindParam(Instance: TObject; var Params: Variant): Variant;
    function TParams_Items_Get(Instance: TObject; var Params: Variant): Variant;
    function TParam_Items_Set(Instance: TObject; var Params: Variant): Variant;
    function TParams_PValues_Get(Instance: TObject; var Params: Variant): Variant;
    function TParams_PValues_Set(Instance: TObject; var Params: Variant): Variant;
    {TDataSet}
    function TDataSet_Append(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Cancel(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_ClearFields(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Close(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_ControlsDisabled(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_CreateBlobStream(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Delete(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_DisabelControls(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Edit(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_EnableControls(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_FBN(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_FindField(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_FindFirst(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_FindLast(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_FindNext(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_FindPrior(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_First(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_GetFieldList(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_GetFieldNames(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Insert(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_IsEmpty(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_IsLinkedTo(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_IsSequenced(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Last(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Locate(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_MoveBy(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Next(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Open(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Post(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Prior(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Refresh(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Resync(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_UpdateCursorPos(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_UpdateRecord(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_UpdateStatus(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Bof(Instance: Pointer): Variant;
    function TDataSet_CanModify(Instance: Pointer): Variant;
    function TDataSet_Eof(Instance: Pointer): Variant;
    function TDataSet_FieldCount(Instance: Pointer): Variant;
    function TDataSet_Filds_Get(Instance: Pointer): Variant;
    function TDataSet_FieldValues_Get(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_FieldValues_Set(Instance: TObject; var Params: Variant): Variant;
    function TDataSet_Found(Instance: Pointer): Variant;
    function TDataSet_IsUniDirectional(Instance: Pointer): Variant;
    function TDataSet_Modified(Instance: Pointer): Variant;
    function TDataSet_RecordCount(Instance: Pointer): Variant;
    function TDataSet_RecNo_Get(Instance: Pointer): Variant;
    procedure TDataSet_RecNo_Set(Instance: Pointer; AValue: Variant);
    function TDataSet_State(Instance: Pointer): Variant;
    {TCustomConnection}
    function CustomConnection_Close(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomConnection_DataSetCount(Instance: Pointer): Variant;
    function CustomConnection_GetDataSet(Instance: TObject; var Params: Variant
      ): Variant;
    function CustomConnection_Open(Instance: TObject; var Params: Variant
      ): Variant;
  end;

implementation

uses DB, dpEvntHadlrs, dpUtils, LazUTF8;

type
  TFilterRecordHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(DataSet: TObject; var Accept: Boolean);
  end;

  TDataSetErrorHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(DataSet: TDataSet; E: EDatabaseError;
      var Action: TDataAction);
  end;

function TDataImport.CustomConnection_Close(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomConnection(Instance).Close;
end;

function TDataImport.CustomConnection_DataSetCount(Instance: Pointer): Variant;
begin
  Result := TCustomConnection(Instance).DataSetCount;
end;

function TDataImport.CustomConnection_GetDataSet(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TCustomConnection(Instance).DataSets[Params[0]] );
end;

function TDataImport.CustomConnection_Open(Instance: TObject;
  var Params: Variant): Variant;
begin
  TCustomConnection(Instance).Open;
end;

function TDataImport.BlobField_BlobSize(Instance: Pointer): Variant;
begin
  Result := TBlobField(Instance).BlobSize;
end;

function TDataImport.BlobField_LoadFromFile(Instance: TObject;
  var Params: Variant): Variant;
var
  S: string;
begin
  S := Params[0];
  TBlobField(Instance).LoadFromFile(S);
end;

function TDataImport.BlobField_LoadFromStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlobField(Instance).LoadFromStream(TStream( TSuPtr( Params[0] ) ));
end;

function TDataImport.BlobField_ModifiedGet(Instance: Pointer): Variant;
begin
  Result := TBlobField(Instance).Modified;
end;

procedure TDataImport.BlobField_ModifiedSet(Instance: Pointer; AValue: Variant);
begin
  TBlobField(Instance).Modified := AValue;
end;

function TDataImport.BlobField_SaveToFile(Instance: TObject; var Params: Variant
  ): Variant;
var
  S: string;
begin
  S := Params[0];
  TBlobField(Instance).SaveToFile(S);
end;

function TDataImport.BlobField_SaveToStream(Instance: TObject;
  var Params: Variant): Variant;
begin
  TBlobField(Instance).SaveToStream(TStream( TSuPtr(Params[0]) ));
end;

function TDataImport.BlobField_TransliterateGet(Instance: Pointer): Variant;
begin
  Result := TBlobField(Instance).Transliterate;
end;

procedure TDataImport.BlobField_TransliterateSet(Instance: Pointer;
  AValue: Variant);
begin
  TBlobField(Instance).Transliterate := AValue;
end;

function TDataImport.BlobField_ValueGet(Instance: Pointer): Variant;
begin
  Result := TBlobField(Instance).Value;
end;

procedure TDataImport.BlobField_ValueSet(Instance: Pointer; AValue: Variant);
begin
  TBlobField(Instance).Value := AValue;
end;

function TDataImport.Field_EditMaskGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).EditMask;
end;

procedure TDataImport.Field_EditMaskSet(Instance: Pointer; AValue: Variant);
var
  S: string;
begin
  S := AValue;
  TField(Instance).EditMask := S;
end;

function TDataImport.TDataSet_BookmarkValid(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).BookmarkValid(Pointer(TSuPtr(Params[0])));
end;

function TDataImport.TDataSet_FreeBookmark(Instance: TObject;
  var Params: Variant): Variant;
begin
  TDataSet(Instance).FreeBookmark(Pointer(TSuPtr(Params[0])));
end;

function TDataImport.TDataSet_GetBookmark(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TDataSet(Instance).GetBookmark );
end;

function TDataImport.TDataSet_GotoBookmark(Instance: TObject;
  var Params: Variant): Variant;
begin
  TDataSet(Instance).GotoBookmark(Pointer(TSuPtr(Params[0])));
end;

function TDataImport.TFielDefs_Add(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADataType: TFieldType;
begin
  AName:= Params[0];
  ADataType := Params[1];
  TFieldDefs(Instance).Add(AName, ADataType);
end;

function TDataImport.TFielDefs_AddFieldDef(Instance: TObject;
  var Params: Variant): Variant;
begin
  Result := TSuPtr( TFieldDefs(Instance).AddFieldDef );
end;

function TDataImport.TFielDefs_AddSize(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADataType: TFieldType;
  ASize: word;
begin
  AName:= Params[0];
  ADataType := Params[1];
  ASize := Params[2];
  TFieldDefs(Instance).Add(AName, ADataType, ASize);
end;

function TDataImport.TFielDefs_AddSizeR(Instance: TObject; var Params: Variant
  ): Variant;
var
  AName: string;
  ADataType: TFieldType;
  ASize: word;
  ARequired: Boolean;
begin
  AName:= Params[0];
  ADataType := Params[1];
  ASize := Params[2];
  ARequired := Params[3];
  TFieldDefs(Instance).Add(AName, ADataType, ASize, ARequired);
end;

function TDataImport.TFielDefs_Assign(Instance: TObject; var Params: Variant
  ): Variant;
var
  AFieldDefs: TFieldDefs;
begin
  AFieldDefs := TFieldDefs( TSuPtr(Params[0]) );
  TFieldDefs(Instance).Assign(AFieldDefs);
end;

function TDataImport.TFielDefs_Find(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TFieldDefs(Instance).Find(Params[0]) );
end;

function TDataImport.TFielDefs_ItemsGet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TFieldDefs(Instance).Items[Params[0]] );
end;

function TDataImport.TFielDefs_ItemsSet(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TFieldDefs(Instance).Items[Params[0]] := TFieldDef( TSuPtr(Params[1]) );
end;

function TDataImport.TField_IsBlob(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TField(Instance).IsBlob;
end;

function TDataImport.Field_CalculatedGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).Calculated;
end;

procedure TDataImport.Field_CalculatedSet(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).Calculated := AValue;
end;

function TDataImport.Field_CanModifyGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).CanModify;
end;

function TDataImport.Field_DataSetGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TField(Instance).DataSet );
end;

procedure TDataImport.Field_DataSetSet(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).DataSet := TDataSet(TSuPtr(AValue));
end;

function TDataImport.Field_DisplayNameGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).DisplayName;
end;

function TDataImport.Field_DisplayTextGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).DisplayText;
end;

function TDataImport.Field_FieldDefGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr( TField(Instance).FieldDef );
end;

function TDataImport.Field_FieldNoGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).FieldNo;
end;

function TDataImport.Field_IsIndexFieldGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).IsIndexField;
end;

function TDataImport.Field_SizeGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).Size;
end;

procedure TDataImport.Field_SizeSet(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).Size := AValue;
end;

function TDataImport.Field_TextGet(Instance: Pointer): Variant;
begin
  Result := TField(Instance).Text;
end;

procedure TDataImport.Field_TextSet(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).Text := AValue;
end;

function TDataImport.TDataSet_FieldDefsGet(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDataSet(Instance).FieldDefs);
end;

procedure TDataImport.TDataSet_FieldDefsSet(Instance: Pointer; AValue: Variant);
begin
  TDataSet(Instance).FieldDefs := TFieldDefs(TSuPtr(AValue));
end;

function TDataImport.TFielDef_CharSizeGet(Instance: Pointer): Variant;
begin
  Result := TFieldDef(Instance).CharSize;
end;

function TDataImport.TFielDef_CreateField(Instance: TObject; var Params: Variant
  ): Variant;
begin
  Result := TSuPtr( TFieldDef(Instance).CreateField(TComponent(TSuPtr(Params[0]))) );
end;

function TDataImport.TFielDef_InternalCalcFieldGet(Instance: Pointer): Variant;
begin
  Result := TFieldDef(Instance).InternalCalcField;
end;

procedure TDataImport.TFielDef_InternalCalcFieldSet(Instance: Pointer;
  AValue: Variant);
begin
  TFieldDef(Instance).InternalCalcField := AValue;
end;

function TDataImport.TFielDef_RequiredGet(Instance: Pointer): Variant;
begin
  Result := TFieldDef(Instance).Required;
end;

procedure TDataImport.TFielDef_RequiredSet(Instance: Pointer; AValue: Variant);
begin
  TFieldDef(Instance).Required := AValue;
end;

function TDataImport.TField_FocusControl(Instance: TObject; var Params: Variant
  ): Variant;
begin
  TField(Instance).FocusControl;
end;

procedure TDataImport.AddTypes(AddType: TAddTypeProc);
begin
  AddType(TypeInfo(TFieldType));
  AddType(TypeInfo(TDataSetState));
  AddType(TypeInfo(TDataEvent));
  AddType(TypeInfo(TUpdateStatus));
  AddType(TypeInfo(TUpdateStatusSet));
  AddType(TypeInfo(TUpdateAction));
  AddType(TypeInfo(TUpdateMode));
  AddType(TypeInfo(TUpdateKind));

  AddType(TypeInfo(TIndexOption));
  AddType(TypeInfo(TIndexOptions));
  AddType(TypeInfo(TFieldKind));
  AddType(TypeInfo(TFieldKinds));
  AddType(TypeInfo(TBlobType));
 // AddType(TypeInfo(TBookmark));

  {Param}
  AddType(TypeInfo(TParamType));
  AddType(TypeInfo(TParamTypes));

  AddType(TypeInfo(TDataAction));
  AddType(TypeInfo(TBlobStreamMode));
  AddType(TypeInfo(TLocateOption));
  AddType(TypeInfo(TLocateOptions));
  AddType(TypeInfo(TFilterOption));
  AddType(TypeInfo(TFilterOptions));
  AddType(TypeInfo(TResyncMode));

end;

procedure TDataImport.AddSimpleTypes(AddType: TAddSimpleTypeProc);
begin
  AddType('TBlobData', btString);
  AddType('TEditMask', btString);
  AddType('TBookMark', btInt);
end;

procedure TDataImport.AddClasses(AddClass: TAddClassProc; AddRecord: TAddRecordProc);
begin
  AddClass(EDatabaseError).ClassImporter := Self;
  AddClass(EUpdateError).ClassImporter := Self;
  AddClass(TFieldDef).ClassImporter := Self;
  AddClass(TFieldDefs).ClassImporter := Self;
  AddClass(TFields).ClassImporter := Self;
  AddClass(TLookupList).ClassImporter := Self;

  AddClass(TCustomConnection).ClassImporter := Self;

  {TFields}
  AddClass(TField).ClassImporter := Self;
  AddClass(TStringField);
  AddClass(TWideStringField);
  AddClass(TNumericField);
  AddClass(TIntegerField);
  AddClass(TSmallintField);
  AddClass(TLargeintField);
  AddClass(TLongintField);
  AddClass(TWordField);
  AddClass(TAutoIncField);
  AddClass(TFloatField);
  AddClass(TCurrencyField);
  AddClass(TBooleanField);
  AddClass(TDateTimeField);
  AddClass(TDateField);
  AddClass(TTimeField);
  AddClass(TBinaryField);
  AddClass(TBytesField);
  AddClass(TVarBytesField);
  AddClass(TBCDField);
  AddClass(TBlobField).ClassImporter := Self;
  AddClass(TMemoField);
  AddClass(TWideMemoField);
  AddClass(TGraphicField);
  AddClass(TVariantField);
  AddClass(TGuidField);
  AddClass(TDataLink).ClassImporter := Self;
  AddClass(TDetailDataLink).ClassImporter := Self;
  AddClass(TMasterDataLink).ClassImporter := Self;
  AddClass(TDataSource).ClassImporter := Self;
  AddClass(TCheckConstraint).ClassImporter := Self;
  AddClass(TCheckConstraints).ClassImporter := Self;

  {Param}
  AddClass(TParam).ClassImporter := Self;
  AddClass(TParams).ClassImporter := Self;

  AddClass(TDataSet).ClassImporter := Self;
end;

procedure TDataImport.AddConsts(AddConst: TAddConstProc);
begin
  AddConst('rmExact', 'Integer', 0);
  AddConst('rmCenter', 'Integer', 1);
end;

procedure TDataImport.RegisterHandlers(RegisterHandler: TRegHandlerProc);
begin
  RegisterHandler(TypeInfo(TDataSetNotifyEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TFilterRecordEvent), TFilterRecordHandler);
  RegisterHandler(TypeInfo(TFieldNotifyEvent), TSuNotifyHandler);
  RegisterHandler(TypeInfo(TDataSetErrorEvent), TDataSetErrorHandler);
end;

procedure TDataImport.RegisterPublic(AType: TDpType);
begin
  if AType.ValueClassType = TFieldDef then
  begin
    AType.AddMethod('function CreateField(AOwner: TComponent): TField ', @TFielDef_CreateField);
    AType.AddProp('InternalCalcField', 'Boolean', @TFielDef_InternalCalcFieldGet, @TFielDef_InternalCalcFieldSet);
    AType.AddProp('Required','Boolean', @TFielDef_RequiredGet, @TFielDef_RequiredSet);
    AType.AddProp('CharSize','Word', @TFielDef_CharSizeGet);

  end
  else
  if AType.ValueClassType = TFieldDefs then
  begin
    AType.AddMethod('procedure Add(const AName: string; ADataType: TFieldType)', @TFielDefs_Add);
    AType.AddMethod('procedure AddSize(const AName: string; ADataType: TFieldType; ASize: Word)', @TFielDefs_AddSize);
    AType.AddMethod('procedure AddSizeR(const AName: string; ADataType: TFieldType; ASize: Word; ARequired: Boolean)', @TFielDefs_AddSizeR);
    AType.AddMethod('function AddFieldDef: TFieldDef', @TFielDefs_AddFieldDef);
    AType.AddMethod('procedure Assign(FieldDefs: TFieldDefs)', @TFielDefs_Assign);
    AType.AddMethod('function Find(const AName: string): TFieldDef', @TFielDefs_Find);
    AType.AddIndexedProp('Items', 'TFieldDef', 'Longint', @TFielDefs_ItemsGet, @TFielDefs_ItemsSet);
  end
  else
  if AType.ValueClassType = TField then
  begin
    AType.AddProp('AsBoolean', 'Boolean', @TField_Bool_Get, @TField_Bool_Set);
    AType.AddProp('AsCurrency', 'Currency', @TField_Curen_Get, @TField_Curen_Set);
    AType.AddProp('AsDateTime', 'TDateTime', @TField_DateTime_Get, @TField_DateTime_Set);
    AType.AddProp('AsFloat', 'Double', @TField_Float_Get, @TField_Float_Set);
    AType.AddProp('AsInteger', 'Integer', @TField_Int_Get, @TField_Int_Set);
    AType.AddProp('AsLargeInt', 'Largeint', @TField_LageInt_Get, @TField_LageInt_Set);
    AType.AddProp('AsString', 'String', @TField_String_Get, @TField_String_Set);
    AType.AddProp('AsVariant', 'Variant', @TField_Variant_Get, @TField_Variant_Set);
    AType.AddProp('Value', 'Variant', @TField_Value_Get, @TField_Value_Set);
    AType.AddProp('Text', 'string', @TField_Text_Get, @TField_Text_Set);
    AType.AddProp('IsNull', 'Boolean', @TField_IsNull_Get, nil);
    AType.AddProp('OldValue', 'Variant', @TField_OldValue_Get, nil);
    AType.AddProp('NewValue', 'Variant', @TField_NewValue_Get, @TField_NewValue_Set);
    AType.AddProp('EditMask', 'string', @Field_EditMaskGet, @Field_EditMaskSet);
    AType.AddProp('DataSet', 'TDataSet', @Field_DataSetGet, @Field_DataSetSet);
    AType.AddProp('DisplayName', 'String', @Field_DisplayNameGet);
    AType.AddProp('DisplayText', 'String', @Field_DisplayTextGet);
    AType.AddProp('FieldDef', 'TFieldDef', @Field_FieldDefGet);
    AType.AddProp('FieldNo', 'Longint', @Field_FieldNoGet);
    AType.AddProp('IsIndexField', 'Boolean', @Field_IsIndexFieldGet);
    AType.AddProp('Size', 'Integer', @Field_SizeGet, @Field_SizeSet);
    AType.AddProp('Text', 'string', @Field_TextGet, @Field_TextSet);
    AType.AddProp('CanModify', 'Boolean', @Field_CanModifyGet);
    AType.AddProp('Calculated', 'Boolean', @Field_CalculatedGet, @Field_CalculatedSet);
    AType.AddMethod('procedure Clear', @TField_Clear);
    AType.AddMethod('function IsBlob: Boolean', @TField_IsBlob);
    AType.AddMethod('procedure FocusControl', @TField_FocusControl);
  end
  else
  if AType.ValueClassType = TBlobField then
  begin
    AType.AddMethod('procedure LoadFromFile(const FileName: string)', @BlobField_LoadFromFile);
    AType.AddMethod('procedure LoadFromStream(Stream: TStream)', @BlobField_LoadFromStream);
    AType.AddMethod('procedure SaveToFile(const FileName: string)', @BlobField_SaveToFile);
    AType.AddMethod('procedure SaveToStream(Stream: TStream)', @BlobField_SaveToStream);
    AType.AddProp('BlobSize', 'Longint', @BlobField_BlobSize);
    AType.AddProp('Modified', 'Boolean', @BlobField_ModifiedGet, @BlobField_ModifiedSet);
    AType.AddProp('Value', 'string', @BlobField_ValueGet, @BlobField_ValueSet);
    AType.AddProp('Transliterate', 'Boolean', @BlobField_TransliterateGet, @BlobField_TransliterateSet);
  end
  else
  if AType.ValueClassType = TFields then
  begin
    AType.AddMethod('procedure Add(Field: TField)', @TFields_Add);
    AType.AddMethod('function FindField(const FieldName: string): TField', @TFields_FindField);
    AType.AddMethod('function FieldByName(const FieldName: string): TField', @TFields_FN);
    AType.AddMethod('function FN(const FieldName: string): TField', @TFields_FN);
    AType.AddMethod('function FieldByNumber(FieldNo: Integer): TField', @TFields_FBN);
    AType.AddMethod('procedure GetFieldNames(List: TStrings)', @TFields_GetFieldNames);
    AType.AddMethod('function IndexOf(Field: TField): Integer', @TFields_IndexOf);
    AType.AddMethod('procedure Remove(Field: TField)', @TFields_Remove);
    AType.AddProp('Count', 'Integer', @TFields_Count_Get, nil);
    AType.AddProp('DataSet', 'TDataSet', @TFields_DataSet_Get, nil);
    AType.AddIndexedProp('Fields', 'TField', 'Integer', @TFields_Fields_Get, @TFields_Fields_Set);
  end
  else
  if AType.ValueClassType = TParam then
  begin
    AType.AddMethod('procedure Clear', @TParam_Clear);
    AType.AddProp('AsBoolean', 'Boolean', @TParam_Bool_Get, @TParam_Bool_Set);
    AType.AddProp('AsCurrency', 'Currency', @TParam_Curen_Get, @TParam_Curen_Set);
    AType.AddProp('AsDateTime', 'TDateTime', @TParam_DateTime_Get, @TParam_DateTime_Set);
    AType.AddProp('AsFloat', 'Double', @TParam_Float_Get, @TParam_Float_Set);
    AType.AddProp('AsDate', 'TDateTime', @TParam_Date_Get, @TParam_Date_Set);
    AType.AddProp('AsTime', 'TDateTime', @TParam_Time_Get, @TParam_Time_Set);
    AType.AddProp('AsInteger', 'Integer', @TParam_Int_Get, @TParam_Int_Set);
    AType.AddProp('AsLargeInt', 'Largeint', @TParam_LageInt_Get, @TParam_LageInt_Set);
    AType.AddProp('AsString', 'String', @TParam_String_Get, @TParam_String_Set);
    AType.AddProp('Value', 'Variant', @TParam_Value_Get, @TParam_Value_Set);
    AType.AddProp('Text', 'string', @TParam_Text_Get, @TParam_Text_Set);
    AType.AddProp('IsNull', 'Boolean', @TParam_IsNull_Get, nil);
    AType.AddProp('AsBlob', 'TBlobData', @TParam_AsBlob_Get, @TParam_AsBlob_Set);
  end
  else
  if AType.ValueClassType = TParams then
  begin
    AType.AddMethod('procedure AssignValues(Value: TParams)', @TParams_AsignValues);
    AType.AddMethod('procedure AddParam(Value: TParam)', @TParams_AddParam);
    AType.AddMethod('procedure RemoveParam(Value: TParam)', @TParams_RemoveParam);
    AType.AddMethod('function CreateParam(FldType: TFieldType; const ParamName: string; ParamType: TParamType): TParam', @TParams_CreateParam);
    AType.AddMethod('procedure GetParamList(List: TList; const ParamNames: string)', @TParams_GetParamList);
    AType.AddMethod('function IsEqual(Value: TParams): Boolean', @TParams_IsEqual);
    AType.AddMethod('function ParamByName(const Value: string): TParam', @TParams_PN);
    AType.AddMethod('function PN(const Value: string): TParam', @TParams_PN);
    AType.AddMethod('function FindParam(const Value: string): TParam', @TParams_FindParam);
    AType.AddIndexedProp('Items', 'TParam', 'Integer', @TParams_Items_Get, @TParam_Items_Set);
    AType.AddIndexedProp('ParamValues', 'Variant', 'String', @TParams_PValues_Get, @TParams_PValues_Set);
  end
  else
  if AType.ValueClassType = TDataSet then
  begin
    AType.AddMethod('procedure Append', @TDataSet_Append);
    AType.AddMethod('procedure Cancel', @TDataSet_Cancel);
    AType.AddMethod('procedure ClearFields', @TDataSet_ClearFields);
    AType.AddMethod('procedure Close', @TDataSet_Close);
    AType.AddMethod('function  ControlsDisabled: Boolean', @TDataSet_ControlsDisabled);
    AType.AddMethod('function CreateBlobStream(Field: TField; Mode: TBlobStreamMode): TStream', @TDataSet_CreateBlobStream);
    AType.AddMethod('procedure Delete', @TDataSet_Delete);
    AType.AddMethod('procedure DisableControls', @TDataSet_DisabelControls);
    AType.AddMethod('procedure Edit', @TDataSet_Edit);
    AType.AddMethod('procedure EnableControls', @TDataSet_EnableControls);
    AType.AddMethod('function FieldByName(const FieldName: string): TField', @TDataSet_FBN);
    AType.AddMethod('function FN(const FieldName: string): TField', @TDataSet_FBN);
    AType.AddMethod('function FindField(const FieldName: string): TField', @TDataSet_FindField);
    AType.AddMethod('function FF(const FieldName: string): TField', @TDataSet_FindField);
    AType.AddMethod('function FindFirst: Boolean', @TDataSet_FindFirst);
    AType.AddMethod('function FindLast: Boolean', @TDataSet_FindLast);
    AType.AddMethod('function FindNext: Boolean', @TDataSet_FindNext);
    AType.AddMethod('function FindPrior: Boolean', @TDataSet_FindPrior);
    AType.AddMethod('procedure First', @TDataSet_First);
    AType.AddMethod('procedure GetFieldList(List: TList; const FieldNames: string)', @TDataSet_GetFieldList);
    AType.AddMethod('procedure GetFieldNames(List: TStrings)', @TDataSet_GetFieldNames);
    AType.AddMethod('procedure Insert', @TDataSet_Insert);
    AType.AddMethod('function IsEmpty: Boolean', @TDataSet_IsEmpty);
    AType.AddMethod('function IsLinkedTo(DataSource: TDataSource): Boolean', @TDataSet_IsLinkedTo);
    AType.AddMethod('function IsSequenced: Boolean', @TDataSet_IsSequenced);
    AType.AddMethod('procedure Last', @TDataSet_Last);
    AType.AddMethod('function Locate(const KeyFields: string; const KeyValues: Variant; Options: TLocateOptions): Boolean', @TDataSet_Locate);
    AType.AddMethod('function MoveBy(Distance: Integer): Integer', @TDataSet_MoveBy);
    AType.AddMethod('procedure Next', @TDataSet_Next);
    AType.AddMethod('procedure Open', @TDataSet_Open);
    AType.AddMethod('procedure Post', @TDataSet_Post);
    AType.AddMethod('procedure Prior', @TDataSet_Prior);
    AType.AddMethod('procedure Refresh', @TDataSet_Refresh);
    AType.AddMethod('procedure Resync(Mode: TResyncMode)', @TDataSet_Resync);
    AType.AddMethod('procedure UpdateCursorPos', @TDataSet_UpdateCursorPos);
    AType.AddMethod('procedure UpdateRecord', @TDataSet_UpdateRecord);
    AType.AddMethod('function UpdateStatus: TUpdateStatus', @TDataSet_UpdateStatus);
    AType.AddMethod('function BookmarkValid(ABookmark: TBookmark): Boolean', @TDataSet_BookmarkValid);
    AType.AddMethod('procedure FreeBookmark(ABookmark: TBookmark)', @TDataSet_FreeBookmark);
    AType.AddMethod('function GetBookmark: TBookmark', @TDataSet_GetBookmark);
    AType.AddMethod('procedure GotoBookmark(ABookmark: TBookmark)', @TDataSet_GotoBookmark);

    AType.AddProp('FieldDefs', 'TFieldDefs', @TDataSet_FieldDefsGet, @TDataSet_FieldDefsSet);
    AType.AddProp('Bof', 'Boolean', @TDataSet_Bof, nil);
    AType.AddProp('CanModify', 'Boolean', @TDataSet_CanModify, nil);
    AType.AddProp('Eof', 'Boolean', @TDataSet_Eof, nil);
    AType.AddProp('FieldCount', 'Integer', @TDataSet_FieldCount, nil);
    AType.AddProp('Fields', 'TFields', @TDataSet_Filds_Get, nil);
    AType.AddIndexedProp('FieldValues', 'Variant', 'string', @TDataSet_FieldValues_Get, @TDataSet_FieldValues_Set);
    AType.AddProp('Found', 'Boolean', @TDataSet_Found, nil);
    AType.AddProp('IsUniDirectional', 'Boolean', @TDataSet_IsUniDirectional, nil);
    AType.AddProp('Modified', 'Boolean', @TDataSet_Modified, nil);
    AType.AddProp('RecordCount', 'Integer', @TDataSet_RecordCount, nil);
    AType.AddProp('RecNo', 'Integer', @TDataSet_RecNo_Get, @TDataSet_RecNo_Set);
    AType.AddProp('State', 'TDataSetState', @TDataSet_State, nil);
  end
  else
  if AType.ValueClassType = TCustomConnection then
  begin
    AType.AddMethod('procedure Close', @CustomConnection_Close);
    AType.AddMethod('procedure Open', @CustomConnection_Open);
    AType.AddProp('DataSetCount', 'Longint', @CustomConnection_DataSetCount);
    AType.AddIndexedProp('DataSets', 'TDataSet', 'Longint', @CustomConnection_GetDataSet);
  end;
end;

{TField}

function TDataImport.TField_Bool_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsBoolean;
end;

procedure TDataImport.TField_Bool_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsBoolean := AValue;
end;

function TDataImport.TField_Curen_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsCurrency;
end;

procedure TDataImport.TField_Curen_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsCurrency := AValue;
end;

function TDataImport.TField_DateTime_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsDateTime;
end;

procedure TDataImport.TField_DateTime_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsDateTime := AValue;
end;

function TDataImport.TField_Float_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsFloat;
end;

procedure TDataImport.TField_Float_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsFloat := AValue;
end;

function TDataImport.TField_Int_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsInteger;
end;

procedure TDataImport.TField_Int_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsInteger := AValue;
end;

function TDataImport.TField_LageInt_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsLargeInt;
end;

procedure TDataImport.TField_LageInt_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsLargeInt := AValue;
end;

function TDataImport.TField_String_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsString;
end;

procedure TDataImport.TField_String_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsString := AValue;
end;

function TDataImport.TField_Variant_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).AsVariant;
end;

procedure TDataImport.TField_Variant_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).AsVariant := AValue;
end;

function TDataImport.TField_Value_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).Value;
end;

procedure TDataImport.TField_Value_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).Value := AValue;
end;

function TDataImport.TField_Text_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).Text;
end;

procedure TDataImport.TField_Text_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).Text := AValue;
end;

function TDataImport.TField_IsNull_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).IsNull;
end;

function TDataImport.TField_OldValue_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).OldValue;
end;

function TDataImport.TField_NewValue_Get(Instance: Pointer): Variant;
begin
  Result := TField(Instance).NewValue;
end;

procedure TDataImport.TField_NewValue_Set(Instance: Pointer; AValue: Variant);
begin
  TField(Instance).NewValue := AValue;
end;

function TDataImport.TField_Clear(Instance: TObject; var Params: Variant): Variant;
begin
  TField(Instance).Clear;
end;

{TFields}

function TDataImport.TFields_Add(Instance: TObject;
      var Params: Variant): Variant;
begin
  TFields(Instance).Add(TField(TSuPtr(Params[0])));
end;

function TDataImport.TFields_FindField(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TFields(Instance).FindField(Params[0]));
end;

function TDataImport.TFields_FN(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TFields(Instance).FieldByName(Params[0]));
end;

function TDataImport.TFields_FBN(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TFields(Instance).FieldByNumber(Params[0]));
end;

function TDataImport.TFields_GetFieldNames(Instance: TObject;
      var Params: Variant): Variant;
begin
  TFields(Instance).GetFieldNames(TStrings(TSuPtr(Params[0])));
end;

function TDataImport.TFields_IndexOf(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TFields(Instance).IndexOf(TField(TSuPtr(Params[0])));
end;

function TDataImport.TFields_Remove(Instance: TObject;
      var Params: Variant): Variant;
begin
  TFields(Instance).Remove(TField(TSuPtr(Params[0])));
end;

function TDataImport.TFields_Count_Get(Instance: Pointer): Variant;
begin
  Result := TFields(Instance).Count;
end;

function TDataImport.TFields_DataSet_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TFields(Instance).DataSet);
end;

function TDataImport.TFields_Fields_Get(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TFields(Instance).Fields[Params[0]]);
end;

function TDataImport.TFields_Fields_Set(Instance: TObject;
      var Params: Variant): Variant;
begin
  TFields(Instance).Fields[Params[0]] := TField(TSuPtr(Params[1]));
end;

{TParam}

function TDataImport.TParam_Clear(Instance: TObject;
      var Params: Variant): Variant;
begin
  TParam(Instance).Clear;
end;

function TDataImport.TParam_Bool_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsBoolean;
end;

procedure TDataImport.TParam_Bool_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsBoolean := AValue;
end;

function TDataImport.TParam_Curen_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsCurrency;
end;

procedure TDataImport.TParam_Curen_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsCurrency := AValue;
end;

function TDataImport.TParam_DateTime_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsDateTime;
end;

procedure TDataImport.TParam_DateTime_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsDateTime := AValue;
end;

function TDataImport.TParam_Float_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsFloat;
end;

procedure TDataImport.TParam_Float_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsFloat := AValue;
end;

function TDataImport.TParam_Date_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsDate;
end;

procedure TDataImport.TParam_Date_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsDate := AValue;
end;

function TDataImport.TParam_Time_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsTime;
end;

procedure TDataImport.TParam_Time_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsTime := AValue;
end;

function TDataImport.TParam_Int_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsInteger;
end;

procedure TDataImport.TParam_Int_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsInteger := AValue;
end;

function TDataImport.TParam_LageInt_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsLargeInt;
end;

procedure TDataImport.TParam_LageInt_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsLargeInt := AValue;
end;

function TDataImport.TParam_String_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsString;
end;

procedure TDataImport.TParam_String_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsString := AValue;
end;

function TDataImport.TParam_Value_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).Value;
end;

procedure TDataImport.TParam_Value_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).Value := AValue;
end;

function TDataImport.TParam_Text_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).Text;
end;

procedure TDataImport.TParam_Text_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).Text := AValue;
end;

function TDataImport.TParam_IsNull_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).IsNull;
end;

function TDataImport.TParam_AsBlob_Get(Instance: Pointer): Variant;
begin
  Result := TParam(Instance).AsBlob;
end;

procedure TDataImport.TParam_AsBlob_Set(Instance: Pointer; AValue: Variant);
begin
  TParam(Instance).AsBlob := AValue;
end;


{TParams}

{$IFDEF DelphiXE}
function TDataImport.TParams_AddParameter(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TParams(Instance).AddParameter);
end;
{$ENDIF}

function TDataImport.TParams_AsignValues(Instance: TObject;
      var Params: Variant): Variant;
begin
  TParams(Instance).AssignValues(TParams(TSuPtr(Params[0])));
end;

function TDataImport.TParams_AddParam(Instance: TObject;
      var Params: Variant): Variant;
begin
  TParams(Instance).AddParam(TParam(TSuPtr(Params[0])));
end;

function TDataImport.TParams_RemoveParam(Instance: TObject;
      var Params: Variant): Variant;
begin
  TParams(Instance).RemoveParam(TParam(TSuPtr(Params[0])));
end;

function TDataImport.TParams_CreateParam(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TParams(Instance).CreateParam(TFieldType(Integer(Params[0])), Params[1], TParamType(Integer(Params[2]))));
end;

function TDataImport.TParams_GetParamList(Instance: TObject;
      var Params: Variant): Variant;
begin
  TParams(Instance).GetParamList(TList(TSuPtr(Params[0])), Params[1]);
end;

function TDataImport.TParams_IsEqual(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TParams(Instance).IsEqual(TParams(TSuPtr(Params[0])))
end;

function TDataImport.TParams_PN(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TParams(Instance).ParamByName(Params[0]));
end;

function TDataImport.TParams_FindParam(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TParams(Instance).FindParam(Params[0]));
end;

function TDataImport.TParams_Items_Get(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TParams(Instance).Items[Params[0]]);
end;

function TDataImport.TParam_Items_Set(Instance: TObject;
      var Params: Variant): Variant;
begin
  TParams(Instance).Items[Params[0]] := TParam(TSuPtr(Params[1]));
end;

function TDataImport.TParams_PValues_Get(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TParams(Instance).ParamValues[Params[0]];
end;

function TDataImport.TParams_PValues_Set(Instance: TObject;
      var Params: Variant): Variant;
begin
  TParams(Instance).ParamValues[Params[0]] := Params[1];
end;

{TDataSet}

function TDataImport.TDataSet_Append(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Append;
end;

function TDataImport.TDataSet_Cancel(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Cancel;
end;

function TDataImport.TDataSet_ClearFields(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).ClearFields;
end;

function TDataImport.TDataSet_Close(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Close;
end;

function TDataImport.TDataSet_ControlsDisabled(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).ControlsDisabled;
end;

function TDataImport.TDataSet_CreateBlobStream(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TDataSet(Instance).CreateBlobStream(TField(TSuPtr(Params[0])), TBlobStreamMode(Integer(Params[1]))));
end;

function TDataImport.TDataSet_Delete(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Delete;
end;

function TDataImport.TDataSet_DisabelControls(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).DisableControls;
end;

function TDataImport.TDataSet_Edit(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Edit;
end;

function TDataImport.TDataSet_EnableControls(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).EnableControls;
end;

function TDataImport.TDataSet_FBN(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TDataSet(Instance).FieldByName(Params[0]));
end;

function TDataImport.TDataSet_FindField(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TSuPtr(TDataSet(Instance).FindField(Params[0]));
end;

function TDataImport.TDataSet_FindFirst(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).FindFirst;
end;

function TDataImport.TDataSet_FindLast(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).FindLast;
end;

function TDataImport.TDataSet_FindNext(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).FindNext;
end;

function TDataImport.TDataSet_FindPrior(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).FindPrior;
end;

function TDataImport.TDataSet_First(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).First;
end;

function TDataImport.TDataSet_GetFieldList(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).GetFieldList(TList(TSuPtr(Params[0])), Params[1]);
end;

function TDataImport.TDataSet_GetFieldNames(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).GetFieldNames(TSTrings(TSuPtr(Params[0])));
end;

function TDataImport.TDataSet_Insert(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Insert;
end;

function TDataImport.TDataSet_IsEmpty(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).IsEmpty;
end;

function TDataImport.TDataSet_IsLinkedTo(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).IsLinkedTo(TDataSource(TSuPtr(Params[0])));
end;

function TDataImport.TDataSet_IsSequenced(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).IsSequenced;
end;

function TDataImport.TDataSet_Last(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Last;
end;

type
  PLocateOptions = ^TLocateOptions;

function TDataImport.TDataSet_Locate(Instance: TObject;
      var Params: Variant): Variant;
var
  L: TLocateOptions;
  S: PLocateOptions;
begin
  L := [];
  S := PLocateOptions(TSuPtr(Params[2]));
  L := S^;
  Result := TDataSet(Instance).Locate(Params[0], Params[1], L);
end;


function TDataImport.TDataSet_MoveBy(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).MoveBy(Params[0]);
end;

function TDataImport.TDataSet_Next(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Next;
end;

function TDataImport.TDataSet_Open(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Open;
end;

function TDataImport.TDataSet_Post(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Post;
end;

function TDataImport.TDataSet_Prior(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Prior;
end;

function TDataImport.TDataSet_Refresh(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).Refresh;
end;

function TDataImport.TDataSet_Resync(Instance: TObject;
      var Params: Variant): Variant;
var
  M: TResyncMode;
  S: PDSSet;
begin
  M := [];
  S := PDSSet(TSuPtr(Params[0]));
  if Integer(rmExact) in S^ then Include(M, rmExact);
  if Integer(rmCenter) in S^ then Include(M, rmCenter);
  TDataSet(Instance).Resync(M);
end;

function TDataImport.TDataSet_UpdateCursorPos(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).UpdateCursorPos;
end;

function TDataImport.TDataSet_UpdateRecord(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).UpdateRecord;
end;

function TDataImport.TDataSet_UpdateStatus(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).UpdateStatus;
end;

function TDataImport.TDataSet_Bof(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).Bof;
end;

function TDataImport.TDataSet_CanModify(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).CanModify;
end;

function TDataImport.TDataSet_Eof(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).Eof;
end;

function TDataImport.TDataSet_FieldCount(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).FieldCount;
end;

function TDataImport.TDataSet_Filds_Get(Instance: Pointer): Variant;
begin
  Result := TSuPtr(TDataSet(Instance).Fields);
end;

function TDataImport.TDataSet_FieldValues_Get(Instance: TObject;
      var Params: Variant): Variant;
begin
  Result := TDataSet(Instance).FieldValues[Params[0]];
end;

function TDataImport.TDataSet_FieldValues_Set(Instance: TObject;
      var Params: Variant): Variant;
begin
  TDataSet(Instance).FieldValues[Params[0]] := Params[1];
end;

function TDataImport.TDataSet_Found(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).Found;
end;

function TDataImport.TDataSet_IsUniDirectional(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).IsUniDirectional;
end;

function TDataImport.TDataSet_Modified(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).Modified;
end;

function TDataImport.TDataSet_RecordCount(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).RecordCount;
end;

function TDataImport.TDataSet_RecNo_Get(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).RecNo;
end;

procedure TDataImport.TDataSet_RecNo_Set(Instance: Pointer; AValue: Variant);
begin
  TDataSet(Instance).RecNo := AValue;
end;

function TDataImport.TDataSet_State(Instance: Pointer): Variant;
begin
  Result := TDataSet(Instance).State;
end;


{Event Handlers Support}

function TFilterRecordHandler.GetHandlerAdres: Pointer;
begin
   Result := @TFilterRecordHandler.CallHandler;
end;

procedure TFilterRecordHandler.CallHandler(DataSet: TObject; var Accept: Boolean);
begin
    Proc.Param[0].Value := TSuPtr(DataSet);
    Proc.Param[1].Value := Accept;
    Proc.Exec;
    Accept := Proc.Param[1].Value;
end;

function TDataSetErrorHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDataSetErrorHandler.CallHandler;
end;

procedure TDataSetErrorHandler.CallHandler(DataSet: TDataSet; E: EDatabaseError;
      var Action: TDataAction);
begin
    Proc.Param[0].Value := TSuPtr(DataSet);
    Proc.Param[1].Value := TSuPtr(E);
    Proc.Param[2].Value := Action;
    Proc.Exec;
    Action := Proc.Param[2].Value;
end;

end.

