unit dpEvnthadlrs;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Controls, Variants, dpCompil, Forms, TypInfo, Types, DB,
  ComCtrls, dpUtils, LCLType;

type
  TSuNotifyHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject);
    function GetHandlerAdres: Pointer; override;
  end;

  TSuKeyEventHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject; var Key: Word;
        Shift: TShiftState);
    function GetHandlerAdres: Pointer; override;
  end;

  TSuKeyPressHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject; var Key: Char);
    function GetHandlerAdres: Pointer; override;
  end;

  { TUTF8KeyPressHandler }

  TUTF8KeyPressHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject; var UTF8Key: TUTF8Char);
    function GetHandlerAdres: Pointer; override;
  end;

  TSuMouseHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    function GetHandlerAdres: Pointer; override;
  end;

  TSuMouseMoveHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject; Shift: TShiftState;
      X, Y: Integer);
    function GetHandlerAdres: Pointer; override;
  end;

  TDragOverHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    function GetHandlerAdres: Pointer; override;
  end;

  TDragDropHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender, Source: TObject; X, Y: Integer);
    function GetHandlerAdres: Pointer; override;
  end;

  TStartDragHandler = class(TDpEventHandler)
  public
    procedure CallHandler(Sender: TObject; var DragObject: TDragObject);
    function GetHandlerAdres: Pointer; override;
  end;

  TEndDragHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender, Target: TObject; X, Y: Integer);
  end;

  TDockDropHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Source: TDragDockObject; X, Y: Integer);
  end;

  TDockOverHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Source: TDragDockObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
  end;

  TUnDockHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Client: TControl;
      NewTarget: TWinControl; var Allow: Boolean);
  end;

  TStartDockHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var DragObject: TDragDockObject);
  end;

  TGetSiteInfoHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; DockClient: TControl;
      var InfluenceRect: TRect; MousePos: TPoint; var CanDock: Boolean);
  end;

  TCanResizeHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var NewSize: Integer;
    var Accept: Boolean);
  end;

  TConstrainedResizeHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var MinWidth, MinHeight,
      MaxWidth, MaxHeight: Integer);
  end;

  TMouseWheelHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
  end;

  TMouseWheelUpDownHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Shift: TShiftState;
      MousePos: TPoint; var Handled: Boolean);
  end;

  TContextPopupHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; MousePos: TPoint; var Handled: Boolean);
  end;

  TAlignInsertBeforeHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    function CallHandler(Sender: TWinControl; C1, C2: TControl): Boolean;
  end;

  TObjVarBoolHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var B: Boolean);
  end;

  TDrawTabHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Control: TCustomTabControl; TabIndex: Integer;
      const Rect: TRect; Active: Boolean);
  end;

  TTabGetImageHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; TabIndex: Integer;
      var ImageIndex: Integer);
  end;

  TDrawPanelHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
  end;

  TObjObjVarBoolHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Obj: TObject;
      var B: Boolean);
  end;

  TTVExpandingHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
  end;

  TTooObjectHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Obj: TObject);
  end;

  TTVCompareHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Node1, Node2: TObject;
      Data: Integer; var Compare: Integer);
  end;

  TSenderObjVarStrHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Obj: TObject; var S: string);
  end;

  TTVHintHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; const Node: TTreeNode;
      var Hint: String);
  end;

  TLVChangeHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Item: TListItem;
      Change: TItemChange);
  end;

  TLVChangingHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Item: TListItem;
      Change: TItemChange; var AllowChange: Boolean);
  end;

  TLVColumnRClickHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Column: TListColumn;
      Point: TPoint);
  end;

  TSenderObjBoolHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; Obj: TObject; B: Boolean);
  end;

  TLVOwnerDataHintHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; StartIndex, EndIndex: Integer);
  end;

  TLVOwnerDataStateChangeHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; StartIndex,
      EndIndex: Integer; OldState, NewState: TListItemStates);
  end;

  TSenderIntegerHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; I: Integer);
  end;

  TObjStrHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; S: string);
  end;

  TObjVarStrHandler = class(TDpEventHandler)
  public
    function GetHandlerAdres: Pointer; override;
    procedure CallHandler(Sender: TObject; var S: string);
  end;

implementation

{ TUTF8KeyPressHandler }

procedure TUTF8KeyPressHandler.CallHandler(Sender: TObject;
  var UTF8Key: TUTF8Char);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := UTF8Key;
  Proc.Exec;
end;

function TUTF8KeyPressHandler.GetHandlerAdres: Pointer;
begin
  Result:= @TUTF8KeyPressHandler.CallHandler;
end;

{TSuNotifyHandler}

procedure TSuNotifyHandler.CallHandler(Sender: TObject);
begin
  if Proc <> nil then
  begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Exec;
  end;
end;

function TSuNotifyHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSuNotifyHandler.CallHandler;
end;

{TSuKeyEventHandler}

procedure TSuKeyEventHandler.CallHandler(Sender: TObject; var Key: Word;
        Shift: TShiftState);
var
  PSet: PShiftState;
begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Param[1].Value := Key;
    PSet := PShiftState(TSuPtr(Proc.Param[2].Value));
    PSet^ := Shift;
    Proc.Exec;
    Key := TIdentObject(Proc.Param[1]).Value;
end;

function TSuKeyEventHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSuKeyEventHandler.CallHandler;
end;

{TSuKeyPressHandler}

procedure TSuKeyPressHandler.CallHandler(Sender: TObject; var Key: Char);
begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Param[1].Value := Key;
    Proc.Exec;
    Key := VarToStr(Proc.Param[1].Value)[1];
end;

function TSuKeyPressHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSuKeyPressHandler.CallHandler;
end;

{TSuMouseHandler}

procedure TSuMouseHandler.CallHandler(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
var
  PSet: PShiftState;
begin
    TIdentObject(Proc.Param[0]).Value := TSuPtr(Sender);
    TIdentObject(Proc.Param[1]).Value := Button;
    PSet := PShiftState(TSuPtr(Proc.Param[2].Value));
    PSet^ := Shift;
    TIdentObject(Proc.Param[3]).Value := X;
    TIdentObject(Proc.Param[4]).Value := Y;
    Proc.Exec;
end;

function TSuMouseHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSuMouseHandler.CallHandler;
end;

{TSuMouseMoveHandler}

procedure TSuMouseMoveHandler.CallHandler(Sender: TObject; Shift: TShiftState;
    X, Y: Integer);
var
  PSet: PShiftState;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  PSet := PShiftState(TSuPtr(Proc.Param[1].Value));
  PSet^ := Shift;
  Proc.Param[2].Value := X;
  Proc.Param[3].Value := Y;
  Proc.Exec;
end;

function TSuMouseMoveHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSuMouseMoveHandler.CallHandler;
end;

function TDragOverHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDragOverHandler.CallHandler;
end;

procedure TDragOverHandler.CallHandler(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Source);
  Proc.Param[2].Value := X;
  Proc.Param[3].Value := Y;
  Proc.Param[4].Value := State;
  Proc.Param[5].Value := Accept;
  Proc.Exec;
  Accept := Proc.Param[5].Value;
end;

procedure TDragDropHandler.CallHandler(Sender, Source: TObject; X, Y: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Source);
  Proc.Param[2].Value := X;
  Proc.Param[3].Value := Y;
  Proc.Exec;
end;

function TDragDropHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDragDropHandler.CallHandler;
end;

procedure TStartDragHandler.CallHandler(Sender: TObject; var DragObject: TDragObject);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(DragObject);
  Proc.Exec;
  DragObject := TDragObject(TSuPtr(Proc.Param[1]));
end;

function TStartDragHandler.GetHandlerAdres: Pointer;
begin
  Result := @TStartDragHandler.CallHandler;
end;

function TEndDragHandler.GetHandlerAdres: Pointer;
begin
  Result := @TEndDragHandler.CallHandler;
end;

procedure TEndDragHandler.CallHandler(Sender, Target: TObject; X, Y: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Target);
  Proc.Param[2].Value := X;
  Proc.Param[3].Value := Y;
  Proc.Exec;
end;

function TDockDropHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDockDropHandler.CallHandler;
end;

procedure TDockDropHandler.CallHandler(Sender: TObject; Source: TDragDockObject; X, Y: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Source);
  Proc.Param[2].Value := X;
  Proc.Param[3].Value := Y;
  Proc.Exec;
end;

function TDockOverHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDockOverHandler.CallHandler;
end;

procedure TDockOverHandler.CallHandler(Sender: TObject; Source: TDragDockObject;
      X, Y: Integer; State: TDragState; var Accept: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Source);
  Proc.Param[2].Value := X;
  Proc.Param[3].Value := Y;
  Proc.Param[4].Value := State;
  Proc.Param[5].Value := Accept;
  Proc.Exec;
  Accept := Proc.Param[5].Value;
end;

function TUnDockHandler.GetHandlerAdres: Pointer;
begin
  Result := @TUnDockHandler.CallHandler;
end;

procedure TUnDockHandler.CallHandler(Sender: TObject; Client: TControl;
      NewTarget: TWinControl; var Allow: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Client);
  Proc.Param[2].Value := TSuPtr(NewTarget);
  Proc.Param[3].Value := Allow;
  Proc.Exec;
  Allow := Proc.Param[3].Value;
end;

function TStartDockHandler.GetHandlerAdres: Pointer;
begin
  Result := @TStartDockHandler.CallHandler;
end;

function TGetSiteInfoHandler.GetHandlerAdres: Pointer;
begin
  Result := @TGetSiteInfoHandler.CallHandler;
end;

procedure TGetSiteInfoHandler.CallHandler(Sender: TObject; DockClient: TControl;
      var InfluenceRect: TRect; MousePos: TPoint; var CanDock: Boolean);
var
  PR: PRect;
  PP: PPoint;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(DockClient);
  PR := @InfluenceRect;
  Proc.Param[2].Value := TSuPtr(PR);
  PP := @MousePos;
  Proc.Param[3].Value := TSuPtr(PP);
  Proc.Param[4].Value := CanDock;
  Proc.Exec;
  PR := PRect(TSuPtr(Proc.Param[2].Value));
  InfluenceRect := PR^;
  CanDock := Proc.Param[4].Value;
end;

function TCanResizeHandler.GetHandlerAdres: Pointer;
begin
  Result := @TCanResizeHandler.CallHandler;
end;

procedure TCanResizeHandler.CallHandler(Sender: TObject; var NewSize: Integer;
    var Accept: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := NewSize;
  Proc.Param[2].Value := Accept;
  Proc.Exec;
  Accept := Proc.Param[2].Value;
end;

function TConstrainedResizeHandler.GetHandlerAdres: Pointer;
begin
  Result := @TConstrainedResizeHandler.CallHandler;
end;

procedure TConstrainedResizeHandler.CallHandler(Sender: TObject;
  var MinWidth, MinHeight, MaxWidth, MaxHeight: Integer);
begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Param[1].Value := MinWidth;
    Proc.Param[2].Value := MinHeight;
    Proc.Param[3].Value := MaxWidth;
    Proc.Param[4].Value := MaxHeight;
    Proc.Exec;
    MinWidth := Proc.Param[1].Value;
    MinHeight := Proc.Param[2].Value;
    MaxWidth := Proc.Param[3].Value;
    MaxHeight := Proc.Param[4].Value;
end;


function TMouseWheelHandler.GetHandlerAdres: Pointer;
begin
  Result := @TMouseWheelHandler.CallHandler;
end;

procedure TMouseWheelHandler.CallHandler(Sender: TObject; Shift: TShiftState;
      WheelDelta: Integer; MousePos: TPoint; var Handled: Boolean);
var
  PSet: PShiftState;
  PP: PPoint;
begin
    Proc.Param[0].Value := TSuPtr(Sender);
    PSet := PShiftState(TSuPtr(Proc.Param[1].Value));
    PSet^ := Shift;
    Proc.Param[2].Value := WheelDelta;
    PP := @MousePos;
    Proc.Param[3].Value := TSuPtr(PP);
    Proc.Param[4].Value := Handled;
    Proc.Exec;
    Handled := Proc.Param[4].Value;
end;

function TMouseWheelUpDownHandler.GetHandlerAdres: Pointer;
begin
  Result := @TMouseWheelUpDownHandler.CallHandler;
end;

procedure TMouseWheelUpDownHandler.CallHandler(Sender: TObject;
  Shift: TShiftState; MousePos: TPoint; var Handled: Boolean);
var
  PSet: PShiftState;
  PP: PPoint;
begin
    Proc.Param[0].Value := TSuPtr(Sender);
    PSet := PShiftState(TSuPtr(Proc.Param[1].Value));
    PSet^ := Shift;
    PP := @MousePos;
    Proc.Param[2].Value := TSuPtr(PP);
    Proc.Param[3].Value := Handled;
    Proc.Exec;
    Handled := Proc.Param[3].Value;
end;

function TContextPopupHandler.GetHandlerAdres: Pointer;
begin
  Result := @TContextPopupHandler.CallHandler;
end;

procedure TContextPopupHandler.CallHandler(Sender: TObject; MousePos: TPoint; var Handled: Boolean);
begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Param[1].Value := TSuPtr(@MousePos);
    Proc.Param[2].Value := Handled;
    Proc.Exec;
    Handled := Proc.Param[2].Value;
end;

procedure TStartDockHandler.CallHandler(Sender: TObject;
  var DragObject: TDragDockObject);
begin
    Proc.Param[0].Value := TSuPtr(Sender);
    Proc.Param[1].Value := TSuPtr(DragObject);
    Proc.Exec;
    DragObject := TDragDockObject(TSuPtr(Proc.Param[1].Value));
end;

function TAlignInsertBeforeHandler.GetHandlerAdres: Pointer;
begin
  Result := @TAlignInsertBeforeHandler.CallHandler;
end;

function TAlignInsertBeforeHandler.CallHandler(Sender: TWinControl; C1, C2: TControl): Boolean;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(C1);
  Proc.Param[2].Value := TSuPtr(C2);
  Result := Proc.Value;
end;

function TObjVarBoolHandler.GetHandlerAdres: Pointer;
begin
  Result := @TObjVarBoolHandler.CallHandler
end;

procedure TObjVarBoolHandler.CallHandler(Sender: TObject;
  var B: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := B;
  Proc.Exec;
  B := Proc.Param[1].Value;
end;

function TDrawTabHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDrawTabHandler.CallHandler
end;

procedure TDrawTabHandler.CallHandler(Control: TCustomTabControl; TabIndex: Integer;
      const Rect: TRect; Active: Boolean);
begin
    Proc.Param[0].Value := TSuPtr(Control);
    Proc.Param[1].Value := TabIndex;
    Proc.Param[2].Value := TSuPtr(@Rect);
    Proc.Param[3].Value := Active;
    Proc.Exec;
end;

function TTabGetImageHandler.GetHandlerAdres: Pointer;
begin
  Result := @TTabGetImageHandler.CallHandler
end;

procedure TTabGetImageHandler.CallHandler(Sender: TObject; TabIndex: Integer;
      var ImageIndex: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TabIndex;
  Proc.Param[2].Value := ImageIndex;
  Proc.Exec;
  ImageIndex := Proc.Param[2].Value;
end;

function TDrawPanelHandler.GetHandlerAdres: Pointer;
begin
  Result := @TDrawPanelHandler.CallHandler;
end;

procedure TDrawPanelHandler.CallHandler(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
begin
  Proc.Param[0].Value := TSuPtr(StatusBar);
  Proc.Param[1].Value := TSuPtr(Panel);
  Proc.Param[2].Value := TSuPtr(@Rect);
  Proc.Exec;
end;

function TObjObjVarBoolHandler.GetHandlerAdres: Pointer;
begin
  Result := @TObjObjVarBoolHandler.CallHandler
end;

procedure TObjObjVarBoolHandler.CallHandler(Sender: TObject; Obj: TObject;
      var B: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Obj);
  Proc.Param[2].Value := B;
  Proc.Exec;
  B := Proc.Param[2].Value;
end;

function TTVExpandingHandler.GetHandlerAdres: Pointer;
begin
  Result := @TTVExpandingHandler.CallHandler
end;

procedure TTVExpandingHandler.CallHandler(Sender: TObject; Node: TTreeNode;
      var AllowExpansion: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Node);
  Proc.Param[2].Value := AllowExpansion;
  Proc.Exec;
  AllowExpansion := Proc.Param[2].Value;
end;

function TTooObjectHandler.GetHandlerAdres: Pointer;
begin
  Result := @TTooObjectHandler.CallHandler
end;

procedure TTooObjectHandler.CallHandler(Sender: TObject; Obj: TObject);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Obj);
  Proc.Exec;
end;

function TTVCompareHandler.GetHandlerAdres: Pointer;
begin
  Result := @TTVCompareHandler.CallHandler
end;

procedure TTVCompareHandler.CallHandler(Sender: TObject; Node1, Node2: TObject;
      Data: Integer; var Compare: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Node1);
  Proc.Param[2].Value := TSuPtr(Node2);
  Proc.Param[3].Value := Data;
  Proc.Param[4].Value := Compare;
  Proc.Exec;
  Compare := Proc.Param[4].Value;
end;

function TSenderObjVarStrHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSenderObjVarStrHandler.CallHandler
end;

procedure TSenderObjVarStrHandler.CallHandler(Sender: TObject;
  Obj: TObject; var S: string);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Obj);
  Proc.Param[2].Value := S;
  Proc.Exec;
  S := Proc.Param[2].Value;
end;

function TTVHintHandler.GetHandlerAdres: Pointer;
begin
  Result := @TTVHintHandler.CallHandler
end;

procedure TTVHintHandler.CallHandler(Sender: TObject; const Node: TTreeNode;
      var Hint: String);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Node);
  Proc.Param[2].Value := Hint;
  Proc.Exec;
  Hint := Proc.Param[2].Value;
end;

function TLVChangeHandler.GetHandlerAdres: Pointer;
begin
  Result := @TLVChangeHandler.CallHandler
end;

procedure TLVChangeHandler.CallHandler(Sender: TObject; Item: TListItem;
      Change: TItemChange);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Item);
  Proc.Param[2].Value := Change;
  Proc.Exec;
end;

function TLVChangingHandler.GetHandlerAdres: Pointer;
begin
  Result := @TLVChangingHandler.CallHandler
end;

procedure TLVChangingHandler.CallHandler(Sender: TObject; Item: TListItem;
      Change: TItemChange; var AllowChange: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Item);
  Proc.Param[2].Value := Change;
  Proc.Param[3].Value := AllowChange;
  Proc.Exec;
  AllowChange := Proc.Param[3].Value;
end;

function TLVColumnRClickHandler.GetHandlerAdres: Pointer;
begin
  Result := @TLVColumnRClickHandler.CallHandler
end;

procedure TLVColumnRClickHandler.CallHandler(Sender: TObject; Column: TListColumn;
      Point: TPoint);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Column);
  Proc.Param[2].Value := TSuPtr(@Point);
  Proc.Exec;
end;

function TSenderObjBoolHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSenderObjBoolHandler.CallHandler
end;

procedure TSenderObjBoolHandler.CallHandler(Sender: TObject; Obj: TObject; B: Boolean);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := TSuPtr(Obj);
  Proc.Param[2].Value := TSuPtr(B);
  Proc.Exec;
end;

function TLVOwnerDataHintHandler.GetHandlerAdres: Pointer;
begin
  Result := @TLVOwnerDataHintHandler.CallHandler;
end;

procedure TLVOwnerDataHintHandler.CallHandler(Sender: TObject; StartIndex, EndIndex: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := StartIndex;
  Proc.Param[2].Value := EndIndex;
  Proc.Exec;
end;

function TLVOwnerDataStateChangeHandler.GetHandlerAdres: Pointer;
begin
  Result := @TLVOwnerDataStateChangeHandler.CallHandler
end;

type
  PItemStates = ^TListItemStates;

procedure TLVOwnerDataStateChangeHandler.CallHandler(Sender: TObject; StartIndex,
      EndIndex: Integer; OldState, NewState: TListItemStates);
var
  OS, NS: TDSSet;
  POS, PNS: PDSSet;
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := StartIndex;
  Proc.Param[2].Value := EndIndex;
  POS := @OS;
  PItemStates(POS)^ := OldState;
  Proc.Param[3].Value := TSuPtr(POS);
  PNS := @NS;
  PItemStates(PNS)^ := NewState;
  Proc.Param[4].Value := TSuPtr(PNS);
  Proc.Exec;
end;

function TSenderIntegerHandler.GetHandlerAdres: Pointer;
begin
  Result := @TSenderIntegerHandler.CallHandler;
end;

procedure TSenderIntegerHandler.CallHandler(Sender: TObject; I: Integer);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := I;
  Proc.Exec;
end;

function TObjStrHandler.GetHandlerAdres: Pointer;
begin
  Result := @TObjStrHandler.CallHandler;
end;

procedure TObjStrHandler.CallHandler(Sender: TObject; S: string);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := S;
  Proc.Exec;
end;

function TObjVarStrHandler.GetHandlerAdres: Pointer;
begin
  Result := @TObjVarStrHandler.CallHandler;
end;

procedure TObjVarStrHandler.CallHandler(Sender: TObject; var S: string);
begin
  Proc.Param[0].Value := TSuPtr(Sender);
  Proc.Param[1].Value := S;
  Proc.Exec;
  S := Proc.Param[1].Value;
end;

end.

