unit main;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, LResources, Forms, Controls, Graphics, Dialogs,
  StdCtrls, Buttons, ExtCtrls, FormDesig;

type

  { TForm1 }

  TForm1 = class(TForm)
    Bevel1: TBevel;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    DManager: TDesignerManager;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure DManagerAfterAddComponent(AComponent, ARoot: TComponent);
    procedure DManagerGetIcon(Source: TComponent; var Bmp: TBitmap);
    function DManagerIsObjNameExist(AName: string): Boolean;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
  private
    { private declarations }
  public
    DesForm: TCustomForm;
  end;

var
  Form1: TForm1;

implementation

uses PropEdits, Menus;

{ TForm1 }

procedure TForm1.Button1Click(Sender: TObject);
begin
  if DesForm = nil then
  begin
    DManager.NewDesignPosLeft := 200;
    DManager.NewDesignPosTop := 200;
    DesForm := DManager.NewDesForm;
    DManager.ShowForm(DesForm);
    DManager.AddComponentClass := TEdit;
  end;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  SL: TStringList;
begin
  if DesForm = nil then Exit;

  if SaveDialog1.Execute then
  begin
    SL := TStringList.Create;
    try
      SL.Text := DManager.ObjToText(DesForm);
      SL.SaveToFile(SaveDialog1.FileName);
    finally
      SL.Free;
    end;
  end;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  SL: TStringList;
  ADesObject: TComponent;
begin
  if OpenDialog1.Execute then
  begin
    if DesForm <> nil then DesForm.Free;

    SL := TStringList.Create;
    try
      SL.LoadFromFile(OpenDialog1.FileName);
      ADesObject := nil;
      DesForm := nil;
      DManager.TextToDesignObj(SL.Text, ADesObject, DesForm, True);
      DManager.ShowForm(DesForm);
    finally
      SL.Free;
    end;
  end;
end;

procedure TForm1.DManagerAfterAddComponent(AComponent, ARoot: TComponent);
begin
  SpeedButton1.Down := True;
end;

procedure TForm1.DManagerGetIcon(Source: TComponent; var Bmp: TBitmap);
begin
  if Source is TPopupMenu then
  begin
    Bmp.Assign(SpeedButton2.Glyph);
  end;
end;

function TForm1.DManagerIsObjNameExist(AName: string): Boolean;
begin
  //Используется, когда присваивается имя новой формме,
  //для проверки имени на уникальность
  //Если, формма с именнем существует, то Result := True
  Result := False;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  DesForm := nil;
  GlobalDesignHook := TPropertyEditorHook.Create;
  Classes.RegisterClasses([TPopupMenu, TMenuItem, TLabel, TButton, TEdit]);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Classes.UnRegisterClasses([TPopupMenu, TMenuItem, TLabel, TButton, TEdit]);
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  DManager.AddComponentClass := nil;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  DManager.AddComponentClass := TPopupMenu;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  DManager.AddComponentClass := TButton;
end;

procedure TForm1.SpeedButton4Click(Sender: TObject);
begin
  DManager.AddComponentClass := TEdit;
end;

procedure TForm1.SpeedButton5Click(Sender: TObject);
begin
  DManager.AddComponentClass := TLabel;
end;

initialization
  {$I main.lrs}

end.

