{------------------------------------------------------------------------------}
{                                                                              }
{                              Yuriy Kopnin                                    }
{                            Package VisuaTech                                 }
{                                 LGPL                                         }
{                                                                              }
{------------------------------------------------------------------------------}

unit xGridPropsEdit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, PropEdits, DBPropEdits, XDBGrids, db;

type

  { TxDBGridFieldProperty }

  TxDBGridFieldProperty = class(TFieldProperty)
  public
    procedure FillValues(const Values: TStringList); override;
  end;

implementation

{ TxDBGridFieldProperty }

procedure LoadDataSourceFields(DataSource: TDataSource; List: TStrings);
var
  DataSet: TDataSet;
  i: Integer;
begin
  if Assigned(DataSource) then
  begin
    DataSet := DataSource.DataSet;
    if Assigned(DataSet) then
    begin
      if DataSet.Fields.Count > 0 then
        DataSet.GetFieldNames(List)
      else
      begin
        for i := 0 to DataSet.FieldDefs.Count - 1 do
          List.Add(DataSet.FieldDefs[i].Name);
      end;
    end;
  end;
end;

procedure TxDBGridFieldProperty.FillValues(const Values: TStringList);
var
  Column: TxColumn;
  Grid: TxDBGrid;
begin
  Column:=TxColumn(GetComponent(0));
  if not (Column is TxColumn) then exit;
  Grid:=TxDBGrid(Column.Grid);
  if not (Grid is TxDBGrid) then exit;
  LoadDataSourceFields(Grid.DataSource, Values);
end;

initialization
  RegisterPropertyEditor(TypeInfo(string), TxColumn, 'FieldName', TxDBGridFieldProperty);
  RegisterPropertyEditor(TypeInfo(string), TxColumn, 'xFieldName', TxDBGridFieldProperty);

end.

