{ $Id: wsgrids.pp 31325 2011-06-22 03:46:06Z jesus $}
{
 *****************************************************************************
 *                                WSGrids.pp                                 * 
 *                                ----------                                 * 
 *                                                                           *
 *                                                                           *
 *****************************************************************************

 *****************************************************************************
 *                                                                           *
 *  This file is part of the Lazarus Component Library (LCL)                 *
 *                                                                           *
 *  See the file COPYING.modifiedLGPL.txt, included in this distribution,    *
 *  for details about the copyright.                                         *
 *                                                                           *
 *  This program is distributed in the hope that it will be useful,          *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of           *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     *
 *                                                                           *
 *****************************************************************************
}
unit WSXgrids;

{$mode objfpc}{$H+}

interface
////////////////////////////////////////////////////
// I M P O R T A N T                                
////////////////////////////////////////////////////
// 1) Only class methods allowed
// 2) Class methods have to be published and virtual
// 3) To get as little as posible circles, the uses
//    clause should contain only those LCL units 
//    needed for registration. WSxxx units are OK
// 4) To improve speed, register only classes in the 
//    initialization section which actually 
//    implement something
// 5) To enable your XXX widgetset units, look at
//    the uses clause of the XXXintf.pp
////////////////////////////////////////////////////
uses
////////////////////////////////////////////////////
// To get as little as posible circles,
// uncomment only when needed for registration
////////////////////////////////////////////////////
  LCLType, Controls, StdCtrls, xGrids,
////////////////////////////////////////////////////
  WSLCLClasses, WSControls, WSFactory;

type
  { TWSCustomXGrid }

  TWSCustomXGrid = class(TWSCustomControl)
  published
    class procedure SendCharToEditor(AEditor:TWinControl; Ch: TUTF8Char); virtual;
    class function InvalidateStartY(const FixedHeight, RowOffset: Integer): integer; virtual;
  end;
  TWSCustomXGridClass = class of TWSCustomXGrid;

  { WidgetSetRegistration }

  function RegisterCustomXGrid: Boolean;

implementation
uses
  LCLIntf, LCLProc, LazUTF8;

{ TWSCustomXGrid }

class procedure TWSCustomXGrid.SendCharToEditor(AEditor:TWinControl;
  Ch: TUTF8Char);
var
  GMsg: TxGridMessage;
  GridEditor: boolean;
begin
  GMsg.Grid := nil;
  GMsg.Options:= 0;
  GMsg.LclMsg.Msg:=GM_GETGRID;
  AEditor.Dispatch(GMsg);
  GridEditor := (GMsg.Options and EO_IMPLEMENTED<>0) and (GMsg.Grid<>nil);

  GMsg.LclMsg.Msg:=GM_SETVALUE;

  if Ch=#8 then // backspace
    GMsg.Value:=''
  else
    GMsg.Value:=Ch;

  if GridEditor then
    AEditor.Dispatch(GMsg)
  else begin
    // TODO: Find a generic way ...
    if AEditor is TCustomEdit then begin
      TCustomEdit(AEditor).Text:=GMsg.Value;
      TCustomEdit(AEditor).SelStart:= UTF8Length(GMsg.Value);
    end else
    if AEditor is TCustomCombobox then begin
      TCustomCombobox(AEditor).Text:=GMsg.Value;
      TCustomCombobox(AEditor).SelStart:=UTF8Length(GMsg.Value);
    end;
  end;
end;

class function TWSCustomXGrid.InvalidateStartY(const FixedHeight, RowOffset: Integer): Integer;
begin
  result := FixedHeight;
end;

{ WidgetSetRegistration }

function RegisterCustomXGrid: Boolean;
const
  Done: Boolean = False;
begin
  Result := False;
  if Done then exit;
  if FindWSComponentClass(TCustomXGrid) <> nil then
    RegisterWSComponent(TCustomXGrid, TWSCustomXGrid);
  Done := True;
  Result := True;
end;

end.
