 ///////////////////////////////////////////////
 ////// ADO related constants: /////////////////
 /////////////////////////////////////////////// CursorTypeEnum
 adOpenUnspecified              = -1;         // Does not specify the type of cursor.
 adOpenForwardOnly              = 0;          // Default. Uses a forward-only cursor.
 adOpenKeyset                   = 1;          // Uses a keyset cursor.
 adOpenDynamic                  = 2;          // Uses a dynamic cursor.
 adOpenStatic                   = 3;          // Uses a static cursor.
 /////////////////////////////////////////////// CursorOptionEnum
 adHoldRecords                  = 256;        // Retrieves more records or changes the next position without committing all pending changes
 adMovePrevious                 = 512;        // Supports the MoveFirst and MovePrevious methods, and Move or GetRows methods
 adAddNew                       = 16778240;   // Supports the AddNew method
 adDelete                       = 16779264;   // Supports the Delete method
 adUpdate                       = 16809984;   // Supports the Update method
 adBookmark                     = 8192;       // Supports the Bookmark property
 adApproxPosition               = 16384;      // Supports the AbsolutePosition and AbsolutePage properties
 adUpdateBatch                  = 65536;      // Supports UpdateBatch and CancelBatch methods
 adResync                       = 131072;     // Supports the Resync method
 adNotify                       = 262144;     // Indicates that the data provider supports notifications (which determines whether Recordset events are supported)
 adFind                         = 524288;     // Supports the Find method
 adSeek                         = 4194304;    // Supports the Seek method
 adIndex                        = 8388608;    // Supports the Index property
 /////////////////////////////////////////////// LockTypeEnum
 adLockUnspecified              = -1;         // Unspecified type of lock. Clones inherits lock type from the original Recordset.
 adLockReadOnly                 = 1;          // Read-only records
 adLockPessimistic              = 2;          // Pessimistic locking, record by record. The provider lock records immediately after editing
 adLockOptimistic               = 3;          // Optimistic locking, record by record. The provider lock records only when calling update
 adLockBatchOptimistic          = 4;          // Optimistic batch updates. Required for batch update mode
 ///////////////////////////////////////////////
 adOptionUnspecified            = -1;         //
 adAsyncExecute                 = 16;         //
 adAsyncFetch                   = 32;         //
 adAsyncFetchNonBlocking        = 64;         //
 adExecuteNoRecords             = 128;        //
 /////////////////////////////////////////////// ConnectOptionEnum
 adConnectUnspecified           = -1;         // Default. Opens the connection synchronously (after).
 adAsyncConnect                 = 16;         // Opens the connection asynchronously (before).
 /////////////////////////////////////////////// ObjectStateEnum
 adStateClosed                  = 0;          // The object is closed
 adStateOpen                    = 1;          // The object is open
 adStateConnecting              = 2;          // The object is connecting
 adStateExecuting               = 4;          // The object is executing a command
 adStateFetching                = 8;          // The rows of the object are being retrieved
 /////////////////////////////////////////////// CursorLocationEnum
 adUseNone                      = 1;          // OBSOLETE (appears only for backward compatibility). Does not use cursor services
 adUseServer                    = 2;          // Default. Uses a server-side cursor
 adUseClient                    = 3;          // Uses a client-side cursor supplied by a local cursor library.
 adUseClientBatch               = 3;          // For backward compatibility, the synonym adUseClientBatch is also supported
 /////////////////////////////////////////////// DataTypeEnum
 adEmpty                        = 0;          // No value
 adTinyInt                      = 16;         // A 1-byte signed integer.
 adSmallInt                     = 2;          // A 2-byte signed integer.
 adInteger                      = 3;          // A 4-byte signed integer.
 adBigInt                       = 20;         // An 8-byte signed integer.
 adUnsignedTinyInt              = 17;         // A 1-byte unsigned integer.
 adUnsignedSmallInt             = 18;         // A 2-byte unsigned integer.
 adUnsignedInt                  = 19;         // A 4-byte unsigned integer.
 adUnsignedBigInt               = 21;         // An 8-byte unsigned integer.
 adSingle                       = 4;          // A single-precision floating-point value.
 adDouble                       = 5;          // A double-precision floating-point value.
 adCurrency                     = 6;          // A currency value
 adDecimal                      = 14;         // An exact numeric value with a fixed precision and scale.
 adNumeric                      = 131;        // An exact numeric value with a fixed precision and scale.
 adBoolean                      = 11;         // A boolean value.
 adError                        = 10;         // A 32-bit error code
 adUserDefined                  = 132;        // A user-defined variable.
 adVariant                      = 12;         // An Automation Variant. Note: Currently not supported by ADO.
 adIDispatch                    = 9;          // A pointer to an IDispatch interface on a COM object. Note: Currently not supported by ADO.
 adIUnknown                     = 13;         // A pointer to an IUnknown interface on a COM object. Note: Currently not supported by ADO.
 adGUID                         = 72;         // A globally unique identifier (GUID)
 adDate                         = 7;          // The number of days since December 30, 1899 + the fraction of a day.
 adDBDate                       = 133;        // A date value (yyyymmdd).
 adDBTime                       = 134;        // A time value (hhmmss).
 adDBTimeStamp                  = 135;        // A date/time stamp (yyyymmddhhmmss plus a fraction in billionths).
 adBSTR                         = 8;          // A null-terminated character string.
 adChar                         = 129;        // A string value.
 adVarChar                      = 200;        // A string value (Parameter object only).
 adLongVarChar                  = 201;        // A long string value.
 adWChar                        = 130;        // A null-terminated Unicode character string.
 adVarWChar                     = 202;        // A null-terminated Unicode character string.
 adLongVarWChar                 = 203;        // A long null-terminated Unicode string value.
 adBinary                       = 128;        // A binary value.
 adVarBinary                    = 204;        // A binary value (Parameter object only).
 adLongVarBinary                = 205;        // A long binary value.
 adChapter                      = 136;        // A 4-byte chapter value that identifies rows in a child rowset
 adFileTime                     = 64;         // The number of 100-nanosecond intervals since January 1,1601
 adDBFileTime                   = 137;        // Database file time
 adPropVariant                  = 138;        // An Automation PROPVARIANT.
 adVarNumeric                   = 139;        // A numeric value (Parameter object only).
 adArray                        = 8192;       // A flag value combined with another data type constant. Indicates an array of that other data type.
 /////////////////////////////////////////////// FieldAttributeEnum
 adFldUnspecified               = -1;         // Provider does not specify the field attributes.
 adFldMayDefer                  = 2;          // Field values are not retrieved from the data source with the whole record, but only when you explicitly access them.
 adFldUpdatable                 = 4;          // You can write to the field.
 adFldUnknownUpdatable          = 8;          // The provider cannot determine if you can write to the field.
 adFldFixed                     = 16;         // Field contains fixed-length data.
 adFldIsNullable                = 32;         // Field accepts null values.
 adFldMayBeNull                 = 64;         // You can read null values from the field.
 adFldLong                      = 128;        // Field is a long binary field.
 adFldRowID                     = 256;        // Field contains a persistent row identifier that cannot be written to and has no meaningful value except to identify the row (such as a unique id)
 adFldRowVersion                = 512;        // Field contains some kind of time/date stamp used to track updates.
 adFldCacheDeferred             = 4096;       // Provider caches the field values and reads from the cache.
 adFldIsChapter                 = 8192;       // Field contains a chapter value that specifies a child recordset.
 adFldNegativeScale             = 16384;      // Field represents a numeric value from a column that supports negative scale values.
 adFldKeyColumn                 = 32768;      //
 adFldIsRowURL                  = $10000;     // Field contains the URL that names the resource from the data store represented by the record.
 adFldIsDefaultStream           = $20000;     // Field contains the default stream for the resource represented by the record.
 adFldIsCollection              = $40000;     // The field specifies that the resource represented by the record is a collection of  resources
 /////////////////////////////////////////////// EditModeEnum
 adEditNone                     = 0;          // No editing operation is in progress
 adEditInProgress               = 1;          // The current record has been edited but not saved
 adEditAdd                      = 2;          // The current record in the copy buffer is a new record and has not been saved in the database
 adEditDelete                   = 4;          // The current record has been deleted
 /////////////////////////////////////////////// RecordStatusEnum
 adRecOK                        = 0;          // Record successfully updated
 adRecNew                       = 1;          // Record is new
 adRecModified                  = 2;          // Record modified
 adRecDeleted                   = 4;          // Record deleted
 adRecUnmodified                = 8;          // Record not modified
 adRecInvalid                   = 16;         // Record not saved; invalid bookmark
 adRecMultipleChanges           = 64;         // Record not saved; would have affected multiple records
 adRecPendingChanges            = 128;        // Record not saved; refers to a pending insert
 adRecCanceled                  = 256;        // Record not saved; operation was canceled
 adRecCantRelease               = 1024;       // New record not saved; existing record was locked
 adRecConcurrencyViolation      = 2048;       // Record not saved; optimistic concurrency was in use
 adRecIntegrityViolation        = 4096;       // Record not saved; user violated integrity constraints
 adRecMaxChangesExceeded        = 8192;       // Record not saved; too many pending changes
 adRecObjectOpen                = 16384;      // Record not saved; conflict with an open storage object
 adRecOutOfMemory               = 32768;      // Record not saved; computer has run out of memory
 adRecPermissionDenied          = 65536;      // Record not saved; user has insufficient permissions
 adRecSchemaViolation           = 131072;     // Record not saved; violates the structure of the database
 adRecDBDeleted                 = 262144;     // Record already deleted from the data source
 ///////////////////////////////////////////////
 adGetRowsRest                  = -1;         //
 adPosUnknown                   = -1;         //
 adPosBOF                       = 4294967294; //
 adPosEOF                       = 4294967293; //
 ///////////////////////////////////////////////
 adBookmarkCurrent              = 0;          //
 adBookmarkFirst                = 1;          //
 adBookmarkLast                 = 2;          //
 /////////////////////////////////////////////// MarshalOptionsEnum
 adMarshalAll                   = 0;          // Default. Returns all rows
 adMarshalModifiedOnly          = 1;          // Returns only modified rows
 /////////////////////////////////////////////// AffectEnum
 adAffectCurrent                = 1;          // Affects only the current record
 adAffectGroup                  = 2;          // Affects only records that satisfy the Filter setting
 adAffectAll                    = 3;          // Affects all records if there is no Filter
 adAffectAllChapters            = 4;          // Affects all records in all child Recordset, including those hidden by a currently applied filter
 /////////////////////////////////////////////// ResyncEnum
 adResyncUnderlyingValues       = 1;          // Does not overwrite data, and pending updates are not canceled
 adResyncAllValues              = 2;          // Default. Overwrites data, and pending updates are canceled
 /////////////////////////////////////////////// CompareEnum
 adCompareLessThan              = 0;          // The first bookmark is before the second
 adCompareEqual                 = 1;          // The bookmarks are equal
 adCompareGreaterThan           = 2;          // The first bookmark is after the second
 adCompareNotEqual              = 3;          // The bookmarks are not equal
 adCompareNotComparable         = 4;          // The bookmarks cannot be compared
 /////////////////////////////////////////////// FilterGroupEnum
 adFilterNone                   = 0;          // Removes the current filter
 adFilterPendingRecords         = 1;          // Filter that displays only edited records that have not yet been sent to the server
 adFilterAffectedRecords        = 2;          // Filter that displays only records affected by the last Delete, Resync, UpdateBatch, or CancelBatch call
 adFilterFetchedRecords         = 3;          // Filter that displays the records in the current cache
 adFilterPredicate              = 4;          //
 adFilterConflictingRecords     = 5;          // Filter that displays those records that failed the last batch update
 /////////////////////////////////////////////// SearchDirectionEnum
 adSearchForward                = 1;          // Searches forward from the starting position.
 adSearchBackward               = -1;         // Searches backward from the starting position.
 /////////////////////////////////////////////// PersistFormatEnum
 adPersistADTG                  = 0;          // Saves in a Microsoft Advanced Data TableGram (ADTG) format.
 adPersistXML                   = 1;          // Saves in Extensible Markup Language (XML) format
 adPersistProviderSpecific      = 2;          // The provider will persist the Recordset using its own format
 /////////////////////////////////////////////// StringFormatEnum - GetString
 adClipString                   = 2;          // Delimits rows by the rowdel parameter, columns by the coldel parameter, and null values by the nullexpr parameter
 ///////////////////////////////////////////////
 adPromptAlways                 = 1;          //
 adPromptComplete               = 2;          //
 adPromptCompleteRequired       = 3;          //
 adPromptNever                  = 4;          //
 /////////////////////////////////////////////// ConnectModeEnum
 adModeUnknown                  = 0;          // Default. Permissions have not been set or cannot be determined
 adModeRead                     = 1;          // Read-only
 adModeWrite                    = 2;          // Write-only
 adModeReadWrite                = 3;          // Read/write
 adModeShareDenyRead            = 4;          // Prevents others from opening a connection with read permissions
 adModeShareDenyWrite           = 8;          // Prevents others from opening a connection with write permissions
 adModeShareExclusive           = 12;         // Prevents others from opening a connection
 adModeShareDenyNone            = 16;         // Allows others to open a connection with any permissions
 ///////////////////////////////////////////////
 adXactUnspecified              = -1;         //
 adXactChaos                    = 16;         //
 adXactReadUncommitted          = 256;        //
 adXactBrowse                   = 256;        //
 adXactCursorStability          = 4096;       //
 adXactReadCommitted            = 4096;       //
 adXactRepeatableRead           = 65536;      //
 adXactSerializable             = 1048576;    //
 adXactIsolated                 = 1048576;    //
 adXactCommitRetaining          = 131072;     //
 adXactAbortRetaining           = 262144;     //
 adXactAsyncPhaseOne            = 524288;     //
 adXactSyncPhaseOne             = 1048576;    //
 /////////////////////////////////////////////// PropertyAttributesEnum
 adPropNotSupported             = 0;          // The property is not supported by the provider.
 adPropRequired                 = 1;          // The user must specify a value for this property before the data source is initialized.
 adPropOptional                 = 2;          // The user does not need to specify a value for this property before the data source is initialized.
 adPropRead                     = 512;        // The user can read the property.
 adPropWrite                    = 1024;       // The user can set the property.
 /////////////////////////////////////////////// ErrorValueEnum
 adErrInvalidArgument           = 3001;       // Arguments are of the wrong type, are out of acceptable range, or are in conflict with one another
 adErrNoCurrentRecord           = 3021;       // Either BOF or EOF is True, or the current record has been deleted
 adErrIllegalOperation          = 3219;       // Operation is not allowed in this context
 adErrInTransaction             = 3246;       // Connection object cannot be closed while in a transaction
 adErrFeatureNotAvailable       = 3251;       // Object/Provider is not capable of performing requested operation
 adErrItemNotFound              = 3265;       // Item cannot be found in the collection corresponding to the requested name or ordinal
 adErrObjectInCollection        = 3367;       // Object is already in collection. Cannot append
 adErrObjectNotSet              = 3420;       // Object is no longer valid
 adErrDataConversion            = 3421;       // Application uses a value of the wrong type
 adErrObjectClosed              = 3704;       // Operation not allowed when the object is closed
 adErrObjectOpen                = 3705;       // Operation not allowed when the object is open
 adErrProviderNotFound          = 3706;       // Provider cannot be found
 adErrBoundToCommand            = 3707;       // Cannot change the ActiveConnection property of a Recordset object which has a Command object as its source
 adErrInvalidParamInfo          = 3708;       // Parameter object is improperly defined
 adErrInvalidConnection         = 3709;       // The connection cannot be used to perform this operation. It is either closed or invalid in this context
 adErrNotReentrant              = 3710;       // Cannot perform operation while processing
 adErrStillExecuting            = 3711;       // Cannot perform operation while executing asynchronously
 adErrOperationCancelled        = 3712;       // Operation cancelled by the user
 adErrStillConnecting           = 3713;       // Cannot perform operation while connecting asynchronously
 adErrNotExecuting              = 3715;       // Cannot perform operation while not executing
 adErrUnsafeOperation           = 3716;       // Cannot access data source on another domain
 ///////////////////////////////////////////////
 adParamSigned                  = 16;         //
 adParamNullable                = 64;         //
 adParamLong                    = 128;        //
 adParamUnknown                 = 0;          //
 adParamInput                   = 1;          //
 adParamOutput                  = 2;          //
 adParamInputOutput             = 3;          //
 adParamReturnValue             = 4;          //
 /////////////////////////////////////////////// CommandTypeEnum
 adCmdUnspecified               = -1;         // Does not specify the command type argument.
 adCmdText                      = 1;          // Evaluates CommandText as a textual definition of a command or stored procedure call.
 adCmdTable                     = 2;          // Evaluates CommandText as a table name whose columns are all returned by an internally generated SQL query.
 adCmdStoredProc                = 4;          // Evaluates CommandText as a stored procedure name.
 adCmdUnknown                   = 8;          // Default. Indicates that the type of command in the CommandText property is not known.
 adCmdFile                      = 256;        // Evaluates CommandText as the file name of a persistently stored Recordset. Used with Recordset.Open or Requery only.
 adCmdTableDirect               = 512;        // Evaluates CommandText as a table name whose columns are all returned. Used with Recordset.Open or Requery only.
 ///////////////////////////////////////////////
 adStatusOK                     = 1;          //
 adStatusErrorsOccurred         = 2;          //
 adStatusCantDeny               = 3;          //
 adStatusCancel                 = 4;          //
 adStatusUnwantedEvent          = 5;          //
 ///////////////////////////////////////////////
 adRsnAddNew                    = 1;          //
 adRsnDelete                    = 2;          //
 adRsnUpdate                    = 3;          //
 adRsnUndoUpdate                = 4;          //
 adRsnUndoAddNew                = 5;          //
 adRsnUndoDelete                = 6;          //
 adRsnRequery                   = 7;          //
 adRsnResynch                   = 8;          //
 adRsnClose                     = 9;          //
 adRsnMove                      = 10;         //
 adRsnFirstChange               = 11;         //
 adRsnMoveFirst                 = 12;         //
 adRsnMoveNext                  = 13;         //
 adRsnMovePrevious              = 14;         //
 adRsnMoveLast                  = 15;         //
 ///////////////////////////////////////////////
 adSchemaProviderSpecific       = -1;         //
 adSchemaAsserts                = 0;          //
 adSchemaCatalogs               = 1;          //
 adSchemaCharacterSets          = 2;          //
 adSchemaCollations             = 3;          //
 adSchemaColumns                = 4;          //
 adSchemaCheckConstraints       = 5;          //
 adSchemaConstraintColumnUsage  = 6;          //
 adSchemaConstraintTableUsage   = 7;          //
 adSchemaKeyColumnUsage         = 8;          //
 adSchemaReferentialConstraints = 9;          //
 adSchemaTableConstraints       = 10;         //
 adSchemaColumnsDomainUsage     = 11;         //
 adSchemaIndexes                = 12;         //
 adSchemaColumnPrivileges       = 13;         //
 adSchemaTablePrivileges        = 14;         //
 adSchemaUsagePrivileges        = 15;         //
 adSchemaProcedures             = 16;         //
 adSchemaSchemata               = 17;         //
 adSchemaSQLLanguages           = 18;         //
 adSchemaStatistics             = 19;         //
 adSchemaTables                 = 20;         //
 adSchemaTranslations           = 21;         //
 adSchemaProviderTypes          = 22;         //
 adSchemaViews                  = 23;         //
 adSchemaViewColumnUsage        = 24;         //
 adSchemaViewTableUsage         = 25;         //
 adSchemaProcedureParameters    = 26;         //
 adSchemaForeignKeys            = 27;         //
 adSchemaPrimaryKeys            = 28;         //
 adSchemaProcedureColumns       = 29;         //
 adSchemaDBInfoKeywords         = 30;         //
 adSchemaDBInfoLiterals         = 31;         //
 adSchemaCubes                  = 32;         //
 adSchemaDimensions             = 33;         //
 adSchemaHierarchies            = 34;         //
 adSchemaLevels                 = 35;         //
 adSchemaMeasures               = 36;         //
 adSchemaProperties             = 37;         //
 adSchemaMembers                = 38;         //
 adSchemaTrustees               = 39;         //
 /////////////////////////////////////////////// SeekEnum
 adSeekFirstEQ                  = 1;          // Seeks the first key equal to keyvalues
 adSeekLastEQ                   = 2;          // Seeks the last key equal to keyvalues
 adSeekAfterEQ                  = 4;          // Seeks either a key equal to keyvalues or just after where that match would have occurred
 adSeekAfter                    = 8;          // Seeks a key just after where a match with keyvalues would have occurred
 adSeekBeforeEQ                 = 16;         // Seeks either a key equal to keyvalues or just before where that match would have occurred
 adSeekBefore                   = 32;         // Seeks a key just before where a match with keyvalues would have occurred
 ///////////////////////////////////////////////
 adCriteriaKey                  = 0;          //
 adCriteriaAllCols              = 1;          //
 adCriteriaUpdCols              = 2;          //
 adCriteriaTimeStamp            = 3;          //
 ///////////////////////////////////////////////
 adPriorityLowest               = 1;          //
 adPriorityBelowNormal          = 2;          //
 adPriorityNormal               = 3;          //
 adPriorityAboveNormal          = 4;          //
 adPriorityHighest              = 5;          //
 ///////////////////////////////////////////////
 adResyncNone                   = 0;          //
 adResyncAutoIncrement          = 1;          //
 adResyncConflicts              = 2;          //
 adResyncUpdates                = 4;          //
 adResyncInserts                = 8;          //
 adResyncAll                    = 15;         //
 adRecalcUpFront                = 0;          //
 adRecalcAlways                 = 1;          //
 ///////////////////////////////////////////////
 ////// End of ADO constants.///////////////////
 ///////////////////////////////////////////////
