unit Form_RecodeCodePageDialog;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, graphics, controls, forms, dialogs, stdctrls, buttons,
 extctrls, comctrls, math, lcltype, lclproc, lclintf,
 _crw_alloc, _crw_str, _crw_ef, _crw_fio, _crw_plut, _crw_eldraw, _crw_utf8,
 _crw_appforms, _crw_apptools;

type

  { TFormRecodeCodePageDialog }

  TFormRecodeCodePageDialog = class(TMasterForm)
    ButtonCodePageVersa: TButton;
    ComboBoxCodePageDest: TComboBox;
    ComboBoxCodePageSource: TComboBox;
    LabelCodePageDest: TLabel;
    LabelCodePageSource: TLabel;
    OpenDialog: TOpenDialog;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    PanelControls: TPanel;
    procedure ButtonCodePageVersaClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure BitBtnOkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function FormRecodeCodePageDialogExecute:Integer;

implementation

{$R *.lfm}

function FormRecodeCodePageDialogExecute:Integer;
const
 TheForm : TFormRecodeCodePageDialog = nil;
begin
 Result:=mrCancel;
 if CanShowModal(TheForm) then
 try
  if not TheForm.Ok then begin
   Application.CreateForm(TFormRecodeCodePageDialog, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then begin
   LocateFormToCenterOfScreen(TheForm);
   Result:=mrVoice(TheForm.ShowModal);
  end;
 except
  on E:Exception do BugReport(E,nil,'FormRecodeCodePageDialogExecute');
 end;
end;

procedure TFormRecodeCodePageDialog.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Перекодировка файлов','File codepage recode');
 SmartUpdate(BitBtnOk,mrCaption(mrOk));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
 OpenDialog.Title:=RusEng('Перекодировать файлы...','Recode files...');
 LabelCodePageSource.Caption:=RusEng('Начальная кодировка','Source codepage');
 LabelCodePageDest.Caption:=RusEng('Конечная кодировка','Dest codepage');
 ButtonCodePageVersa.Caption:=RusEng('Наоборот','Vice Versa');
end;

procedure TFormRecodeCodePageDialog.ButtonCodePageVersaClick(Sender: TObject);
var i,j:Integer;
begin
 i:=ComboBoxCodePageSource.ItemIndex;
 j:=ComboBoxCodePageDest.ItemIndex;
 ComboBoxCodePageSource.ItemIndex:=j;
 ComboBoxCodePageDest.ItemIndex:=i;
end;

procedure TFormRecodeCodePageDialog.BitBtnOkClick(Sender: TObject);
var i,cps,cpd:LongInt; sl,dl:Int64; ss,sd,fn,sp:LongString; p:TPoint;
begin
 try
  if IsEmptyStr(OpenDialog.InitialDir)
  then OpenDialog.InitialDir:=HomeDir;
  if (ComboBoxCodePageDest.ItemIndex>=0) then
  if (ComboBoxCodePageSource.ItemIndex>=0) then
  if (ComboBoxCodePageSource.ItemIndex<>ComboBoxCodePageDest.ItemIndex) then
  if GuardOpenDialog(OpenDialog).Execute then begin
   ss:=ComboBoxCodePageSource.Items[ComboBoxCodePageSource.ItemIndex];
   sd:=ComboBoxCodePageDest.Items[ComboBoxCodePageDest.ItemIndex];
   cps:=StrToIntDef(ExtractWord(1,ss,ScanSpaces),0);
   cpd:=StrToIntDef(ExtractWord(1,sd,ScanSpaces),0);
   if (cps=0) or (cpd=0) then begin
    Echo(RusEng('Ошибка: не выбрана кодировка.','Error: no code page selected.'));
    ModalResult:=mrCancel;
    Exit;
   end;
   p:=ClientToScreen(Point(0,Height));
   sp:='';
   sp:=sp+'@set Form.Left '+IntToStr(p.x)+' relative Screen'+EOL;
   sp:=sp+'@set Form.Top  '+IntToStr(p.y)+' relative Screen'+EOL;
   if (YesNo(RusEng('Выбранные файлы будут перезаписаны.'+EOL+'Подтверждаете?',
                   'Selected files will be overwritten.'+EOL+'Confirm?'),sp)<>mrYes)
   then begin
    ModalResult:=mrCancel;
    Exit;
   end;
   for i:=0 to OpenDialog.Files.Count-1 do begin
    fn:=OpenDialog.Files[i];
    sl:=GetFileSize(fn);
    if (sl>0) then begin
     ss:=StringFromFile(fn,sl);
     if (Length(ss)=sl) then begin
      sd:=ConvertCP(ss,cps,cpd,cpd);
      if (sd='') then dl:=0 else begin
       if FileErase(fn)
       then dl:=WriteBufferToFile(fn,sd)
       else dl:=0;
      end;
      if (dl>0)
      then Echo(Format(RusEng('Перекодировал %d->%d %s','Recode %d->%d %s'),[cps,cpd,fn]))
      else Echo(RusEng('Ошибка перекодировки ','Error recode ')+fn);
     end else Echo(RusEng('Ошибка перекодировки ','Error recode ')+fn);
    end;
   end;
   ModalResult:=mrOk;
  end;
 except
  on E:Exception do BugReport(E,Self,'BitBtnOkClick');
 end;
end;

end.
