#!/bin/bash

# https://askubuntu.com/questions/17299/what-do-the-different-colors-mean-in-ls

# For each entry in LS_COLORS, print the type, and description if available,
# in the relevant color.
# If two adjacent colors are the same, keep them on one line.

function show_ls_colors()(
 declare -A descriptions=(
    [bd]="block device"
    [ca]="file with capability"
    [cd]="character device"
    [di]="directory"
    [do]="door"
    [ex]="executable file"
    [fi]="regular file"
    [ln]="symbolic link"
    [mh]="multi-hardlink"
    [mi]="missing file"
    [no]="normal non-filename text"
    [or]="orphan symlink"
    [ow]="other-writable directory"
    [pi]="named pipe, AKA FIFO"
    [rs]="reset to no color"
    [sg]="set-group-ID"
    [so]="socket"
    [st]="sticky directory"
    [su]="set-user-ID"
    [tw]="sticky and other-writable directory"
 );
 clear;
 echo "";
 echo "LS_COLORS=$LS_COLORS";
 echo "";
 echo "Table of LS_COLORS:";
 echo "";
 IFS=":";
 for ls_color in $LS_COLORS; do
  local color="${ls_color#*=}";
  local type="${ls_color%=*}";
  desc="${descriptions[$type]}";
  if [[ $color_prev ]] && [[ $color != "$color_prev" ]]; then echo ""; fi;
  printf "\e[%sm%s%s\e[m " "$color" "$type" "${desc:+ ($desc)}";
  local color_prev="$color";
 done;
 echo "";
 echo "";
 echo "Use [dircolors -p] for details";
 echo "";
 echo "Done";
 echo "";
);
show_ls_colors;
