////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2026 DaqGroup daqgroup@mail.ru under MIT license        //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - addon user program. //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Console program sample.                                                    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20260223 - Created by A.K.                                                 //
////////////////////////////////////////////////////////////////////////////////

program crwpulser;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$R *.res}

uses
 sysutils;

const
 nLoop       : QWord    = 1;
 nCount      : QWord    = High(QWord);
 nSleep      : LongWord = 1000; 
 Terminated  : Boolean  = False;
 Version     = 'crwpulser version 1.0';
 Copyright   = 'Copyright (c) 2026 DaqGroup daqgroup.mail.ru';
 Description = 'Prints sequence numbers (1,2,..) with delay (sleep) after each.';
 Comment     = 'Utility for crwdaq program to generate sequence of numbers (pulses).';
 Usage       = 'Usage:   crwpulser [--version|--help|--sleep ms|--count nmax]';
 Example     = 'Example: crwpulser --sleep 1000 --count 0xFFFFFFFFFFFFFFFF   (by default)';

procedure ParseArgs;
var i,pc:Integer; si,sv:String; vc:Word; vs:QWord;
begin
 i:=1; pc:=ParamCount;
 while (i<=pc) do begin
  si:=ParamStr(i);
  if SameText(si,'--version')
  then begin
   Writeln(Version);
   Terminated:=True;
   Break;
  end else
  if SameText(si,'-h')
  or SameText(si,'-help')
  or SameText(si,'--help')
  then begin
   Writeln(Version);
   Writeln(Copyright);
   Writeln(Description);
   Writeln(Comment);
   Writeln(Usage);
   Writeln(Example);
   Terminated:=True;
   Break;
  end else
  if SameText(si,'-s')
  or SameText(si,'-sleep')
  or SameText(si,'--sleep')
  then begin
   sv:=ParamStr(i+1);
   vs:=nSleep; vc:=0;
   Val(sv,vs,vc);
   if (vc=0) then nSleep:=vs else begin
    Writeln(StdOut,'Error: Invalid sleep value.');
    Terminated:=True;
    Break;
   end; 
   Inc(i);
  end else 
  if SameText(si,'-c')
  or SameText(si,'-count')
  or SameText(si,'--count')
  then begin
   sv:=ParamStr(i+1);
   vs:=nCount; vc:=0;
   Val(sv,vs,vc);
   if (vc=0) then nCount:=vs else begin
    Writeln(StdOut,'Error: Invalid count value.');
    Terminated:=True;
    Break;
   end;
   Inc(i);
  end else 
  if (si<>'') then begin
   if (Pos('-',si)>0) then begin
    Writeln(StdOut,'Error: Invalid option '+si);
    Terminated:=True;
    Break;
   end else begin
    Writeln(StdOut,'Error: Unexpected parameter '+si);
    Terminated:=True;
    Break;
   end; 
  end;
  Inc(i);
 end;
end;

begin

 ParseArgs;

 while (nLoop<=nCount) and not Terminated do begin
  Writeln(Output,nLoop); Flush(Output);
  if IOResult<>0 then Terminated:=True;
  Sleep(nSleep);
  Inc(nLoop);
 end;

end.

//////////////
// END OF FILE
//////////////
