/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version19;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.wire.FbWireDatabase;
import org.firebirdsql.gds.ng.wire.InlineBlob;
import org.firebirdsql.gds.ng.wire.InlineBlobResponse;
import org.firebirdsql.gds.ng.wire.version18.V18Statement;
import org.firebirdsql.gds.ng.wire.version19.V19Database;

public class V19Statement
extends V18Statement {
    public V19Statement(FbWireDatabase database) {
        super(database);
    }

    @Override
    protected void sendExecute(int operation, RowValue parameters) throws IOException, SQLException {
        super.sendExecute(operation, parameters);
        this.getXdrOut().writeInt(this.getMaxInlineBlobSize());
    }

    protected int getMaxInlineBlobSize() {
        return this.getDatabase().getConnectionProperties().getMaxInlineBlobSize();
    }

    @Override
    protected void handleInlineBlobResponse(InlineBlobResponse inlineBlobResponse) {
        FbWireDatabase fbWireDatabase = this.getDatabase();
        if (fbWireDatabase instanceof V19Database) {
            V19Database database = (V19Database)fbWireDatabase;
            InlineBlob inlineBlob = inlineBlobResponse.toInlineBlob(database);
            database.registerInlineBlob(this.getTransaction(), inlineBlob);
        }
    }
}

