unit TestDaqtags;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math,
 _crw_alloc, _crw_ef, _crw_zm, _crw_fpu, _crw_rtc, _crw_fio, _crw_fifo,
 _crw_str, _crw_dynar, _crw_daqtags;

procedure Test_Daqtags;

implementation

procedure Test_Daqtags;
var P:TText; IniFile:ShortString; errors,i,j,k,tag:Integer; r:double; s:LongString;
begin
 randomize;
 errors:=0;
 ClearTags;
 for k:=1 to 200 do begin
  {}
  tag:=InitTag('integer'+d2s(random(100000)),1);
  writeln(tag:5,' ',typetag(tag):5);
  if Typetag(tag)<>1 then inc(errors) else
  for i:=1 to 1000 do begin
   j:=random(MaxInt);
   if not isettag(tag,j) then inc(errors);
   if igettag(tag)<>j then inc(errors);
  end;
  {}
  tag:=InitTag('real'+d2s(random(100000)),2);
  writeln(tag:5,' ',typetag(tag):5);
  if Typetag(tag)<>2 then inc(errors) else
  for i:=1 to 1000 do begin
   r:=random*MaxInt;
   if not rsettag(tag,r) then inc(errors);
   if rgettag(tag)<>r then inc(errors);
  end;
  {}
  s:='';
  tag:=InitTag('string'+d2s(random(100000)),3);
  writeln(tag:5,' ',typetag(tag):5);
  if Typetag(tag)<>3 then inc(errors) else
  for i:=1 to 1000 do begin
   s:=f2s(random(MaxInt));
   if not ssettag(tag,s) then inc(errors);
   if sgettag(tag)<>s then inc(errors);
  end;
  s:='';
 end;
 {}
 cleartags;
 writeln('Errors=',errors);
 {}
 ClearTags;
 IniFile:='daqtags.cfg';
 writeln(fileexists(inifile));
 FileErase('daqtags.txt');
 P:=NewText;
 ReadTags(IniFile,'[TagList]',P);
 GetTagList(P);
 P.WriteFile('daqtags.txt');
 Kill(P);
 ClearTags;
 FreeConfigCache(0);
 writeln(StringFromFile('daqtags.txt',MaxInt));
end;

end.
