unit Form_VoicePreset;

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, math, lclintf, lcltype,
 graphics, controls, forms, dialogs, stdctrls, buttons, extctrls,
 comctrls, checklst,
 _crw_alloc, _crw_fpu, _crw_str, _crw_fio, _crw_eldraw, _crw_snd,
 _crw_ef, _crw_ee, _crw_rtc, _crw_appforms, _crw_apptools, _crw_daqsys;

type
  TFormVoicePreset = class(TMasterForm)
    PanelControls: TPanel;
    GroupBoxVolume: TGroupBox;
    TrackBarVolume: TTrackBar;
    GroupBoxSpeed: TGroupBox;
    TrackBarSpeed: TTrackBar;
    GroupBoxFlags: TGroupBox;
    CheckListBoxFlags: TCheckListBox;
    GroupBoxSayTime: TGroupBox;
    LabelSayTime: TLabel;
    ComboBoxSayTime: TComboBox;
    LabelSayTimeMin: TLabel;
    GroupBoxCache: TGroupBox;
    ComboBoxCache: TComboBox;
    LabelCache: TLabel;
    ComboBoxPeriod: TComboBox;
    LabelPeriod: TLabel;
    GroupBoxTest: TGroupBox;
    ComboBoxTestVoice: TComboBox;
    ButtonTestVoice: TButton;
    ButtonTestTime: TButton;
    PanelButtons: TPanel;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    BitBtnSilence: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure TrackBarVolumeChange(Sender: TObject);
    procedure TrackBarSpeedChange(Sender: TObject);
    procedure CheckListBoxFlagsClickCheck(Sender: TObject);
    procedure ComboBoxSayTimeExit(Sender: TObject);
    procedure ComboBoxCacheExit(Sender: TObject);
    procedure ComboBoxPeriodExit(Sender: TObject);
    procedure ButtonTestVoiceClick(Sender: TObject);
    procedure ButtonTestTimeClick(Sender: TObject);
    procedure BitBtnSilenceClick(Sender: TObject);
  private
    { Private declarations }
    procedure UpdateControls(Flags:Integer);
  public
    { Public declarations }
  end;

function FormVoicePresetExecute(ToMouse:Boolean=true; const Params:LongString=''):Integer;

implementation

{$R *.lfm}

const
  FormVoicePreset: TFormVoicePreset = nil;

function FormVoicePresetExecute(ToMouse:Boolean=true; const Params:LongString=''):Integer;
var L,R,V:Double; epb,ev,esv,ed:Boolean; d1,d2,d3:Integer;
begin
 Result:=mrCancel;
 if CanShowModal(FormVoicePreset) then
 if NoProblem(UsesBlaster,RusEng('Звук недоступен!','Sound is not available!')) then
 try
  if not Assigned(FormVoicePreset) then begin
   Application.CreateForm(TFormVoicePreset, FormVoicePreset);
   FormVoicePreset.Master:=@FormVoicePreset;
  end;
  if Assigned(FormVoicePreset) then begin
   if ToMouse
   then LocateFormToCenterOfMouse(FormVoicePreset)
   else LocateFormToCenterOfScreen(FormVoicePreset);
   ed:=Daq.SoundOn;
   ev:=EnableVoice;
   L:=0; R:=0; V:=0;
   esv:=EnableSystemVoice;
   epb:=EnablePlayBlaster;
   GetBlasterVolume(L,R);
   GetBlasterSpeed(V);
   d1:=SayTimeInterval;
   d2:=BlasterMaxDataSize;
   d3:=BlasterMemoPollPeriod;
   if IsNonEmptyStr(Params)
   then FormVoicePreset.ApplyParams(Params);
   Result:=mrVoice(FormVoicePreset.ShowModal);
   if (Result<>mrOk) then begin
    SayTimeInterval:=d1;
    BlasterMaxDataSize:=d2;
    BlasterMemoPollPeriod:=d3;
    SetBlasterSpeed(V);
    SetBlasterVolume(L,R);
    EnablePlayBlaster:=epb;
    EnableSystemVoice:=esv;
    EnableVoice:=ev;
    Daq.SoundOn:=ed;
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormVoicePresetExecute');
 end;
end;

procedure TFormVoicePreset.UpdateControls(Flags:Integer);
var L,R,V:Double; d:Integer;
begin
 if Ok then
 try
  L:=0; R:=0; V:=0;
  if HasFlags(Flags,$0001) then begin
   SetEnabledControls(UsesBlaster,[TrackBarVolume,TrackBarSpeed,CheckListBoxFlags,
                                   ComboBoxSayTime,ComboBoxCache,ComboBoxPeriod,
                                   ComboBoxTestVoice,ButtonTestVoice,ButtonTestTime]);
   if GetBlasterVolume(L,R)
   then TrackBarVolume.Position:=round(L*TrackBarVolume.Max)
   else TrackBarVolume.Position:=0;
   GroupBoxVolume.Caption:=Format(RusEng('Громкость %3.0f %s','Volume %3.0f %s'),
                                 [100.0*TrackBarVolume.Position/TrackBarVolume.Max,'%']);
   if GetBlasterSpeed(V)
   then TrackBarSpeed.Position:=round(LogN(BlasterMaxSpeed,V)*TrackBarSpeed.Max)
   else TrackBarSpeed.Position:=0;
   GroupBoxSpeed.Caption:=Format(RusEng('Скорость %3.0f %s','Speed %3.0f %s'),
                                [100.0*Power(BlasterMaxSpeed,TrackBarSpeed.Position/TrackBarSpeed.Max),'%']);
   CheckListBoxFlags.Checked[0]:=EnablePlayBlaster;
   CheckListBoxFlags.Checked[1]:=EnableVoice;
   CheckListBoxFlags.Checked[2]:=EnableSystemVoice;
   CheckListBoxFlags.Checked[3]:=Daq.SoundOn;
   ComboBoxSayTime.Text:=Format('%d',[SayTimeInterval]);
   ComboBoxCache.Text:=Format('%d',[BlasterMaxDataSize div 1024]);
   ComboBoxPeriod.Text:=Format('%d',[BlasterMemoPollPeriod div 1000]);
  end;
  if HasFlags(Flags,$0002) then begin
   ComboBoxTestVoice.Items.Text:=AnsiLowerCase(GetSoundLibrary);
  end;
  if HasFlags(Flags,$0010) then begin
   L:=TrackBarVolume.Position/TrackBarVolume.Max;
   R:=TrackBarVolume.Position/TrackBarVolume.Max;
   SetBlasterVolume(L,R);
  end;
  if HasFlags(Flags,$0020) then begin
   V:=Power(BlasterMaxSpeed,TrackBarSpeed.Position/TrackBarSpeed.Max);
   SetBlasterSpeed(V);
  end;
  if HasFlags(Flags,$0040) then begin
   EnablePlayBlaster:=CheckListBoxFlags.Checked[0];
   EnableVoice:=CheckListBoxFlags.Checked[1];
   EnableSystemVoice:=CheckListBoxFlags.Checked[2];
   Daq.SoundOn:=CheckListBoxFlags.Checked[3];
  end;
  if HasFlags(Flags,$0080) then begin
   d:=StrToIntDef(ComboBoxSayTime.Text,SayTimeInterval);
   if (d>=0) and (d<=60*24) then SayTimeInterval:=d;
  end;
  if HasFlags(Flags,$0100) then begin
   d:=StrToIntDef(ComboBoxCache.Text,BlasterMaxDataSize div 1024);
   if (d>=1) and (d<=8192) then BlasterMaxDataSize:=d * 1024;
  end;
  if HasFlags(Flags,$0200) then begin
   d:=StrToIntDef(ComboBoxPeriod.Text,BlasterMemoPollPeriod div 1000);
   if (d>=1) and (d<=60*60) then BlasterMemoPollPeriod:=d*1000;
  end;
 except
  on E:Exception do BugReport(E,Self,'UpdateControls');
 end;
end;

procedure TFormVoicePreset.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Параметры звуковой подсистемы','Sound subsystem preset');
 GroupBoxFlags.Caption:=RusEng('Разрешения','Allowance');
 CheckListBoxFlags.Items.Text:=RusEng('Разрешить звук ','Enable sound')+EOL+
                               RusEng('Разрешить голос','Enable voice')+EOL+
                               RusEng('Системный голос','System voice')+EOL+
                               RusEng('Голос DAQ      ','DAQ voice   ');
 GroupBoxSayTime.Caption:=RusEng('Сообщать время','Say time');
 LabelSayTime.Caption:=RusEng('Через каждые','Every');
 LabelSayTimeMin.Caption:=RusEng('Минут','Minutes');
 GroupBoxCache.Caption:=RusEng('Кеш','Cache');
 LabelCache.Caption:=RusEng('КБ очищать каждые','KB clear every');
 LabelPeriod.Caption:=RusEng('секунд','second');
 GroupBoxTest.Caption:=RusEng('Тест','Test');
 ButtonTestVoice.Caption:=RusEng('Голос','Voice');
 ButtonTestTime.Caption:=RusEng('Время','Time');
 BitBtnOk.Caption:=mrCaption(mrOk);
 BitBtnCancel.Caption:=mrCaption(mrCancel);
 BitBtnSilence.Caption:=RusEng('Молчать!','Silence!');
end;

procedure TFormVoicePreset.FormActivate(Sender: TObject);
begin
 UpdateControls($0001);
 UpdateControls($0002);
end;

procedure TFormVoicePreset.TrackBarVolumeChange(Sender: TObject);
begin
 UpdateControls($0010);
 UpdateControls($0001);
end;

procedure TFormVoicePreset.TrackBarSpeedChange(Sender: TObject);
begin
 UpdateControls($0020);
 UpdateControls($0001);
end;

procedure TFormVoicePreset.CheckListBoxFlagsClickCheck(Sender: TObject);
begin
 UpdateControls($0040);
 UpdateControls($0001);
end;

procedure TFormVoicePreset.ComboBoxSayTimeExit(Sender: TObject);
begin
 UpdateControls($0080);
 UpdateControls($0001);
end;

procedure TFormVoicePreset.ComboBoxCacheExit(Sender: TObject);
begin
 UpdateControls($0100);
 UpdateControls($0001);
end;

procedure TFormVoicePreset.ComboBoxPeriodExit(Sender: TObject);
begin
 UpdateControls($0200);
 UpdateControls($0001);
end;

procedure TFormVoicePreset.ButtonTestVoiceClick(Sender: TObject);
begin
 if Ok then Voice(ComboBoxTestVoice.Text);
end;

procedure TFormVoicePreset.ButtonTestTimeClick(Sender: TObject);
begin
 if UsesBlaster then SayTimeHhMm(MSecToNativeTime(msecnow));
end;

procedure TFormVoicePreset.BitBtnSilenceClick(Sender: TObject);
begin
 StopBlaster;
end;

end.
