#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Access pasdoc.css file (--path or  --cat).            ##
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function main(){
 local css="$scriptHOME/css/pasdoc.css";
 case $1 in
  -c|-cat|--cat)   cat  "$css"; ;;
  -p|-path|--path) echo "$css"; ;;
  --version)       echo "$scriptname version 1.0"; ;;
  -h|-help|--help) echo    "Usage: $scriptname --version|-h|--help|-p|--path|-c|--cat"; ;;
  *)               fatal 1 "Usage: $scriptname --version|-h|--help|-p|--path|-c|--cat"; ;;
 esac;
};

main "$@";

##############
## END OF FILE
##############
