#!/bin/bash

##########################################################
# Copyright (c) 2001-2026 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
# Utility to call sudo with required options.
##########################################################

######
# MAIN
######

function logg(){
 if [[ -n $CRW_DAQ_VAR_TMP_DIR ]] && [[ -d $CRW_DAQ_VAR_TMP_DIR ]]; then
  local logfile="$CRW_DAQ_VAR_TMP_DIR/sudoit.log";
  local time="$(date +%Y.%m.%d-%H:%M:%S.%N)";
  echo "${time:0:23} => INFO/NOTIFY: $(hostname)/$CRW_DAQ_SYS_SESSION_HEAD/Sudoit - $*" >> $logfile;
 fi;
};

function main(){
 # prepare options
 local -a options=();
 options+=("-n");
 # execute sudo with options
 logg sudo "${options[@]}" "$@";
 exec sudo "${options[@]}" "$@";
};

main "$@";

##############
## END OF FILE
##############
