#!/bin/bash

##########################################################
# Copyright (c) 2001-2025 Alexey Kuryakin daqgroup@mail.ru
##########################################################

##########################################################
# Utility to find and execute h2pas from fpcupdeluxe.
##########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

function fpcupdeluxe_lazarus_bin(){
 local bin="/opt/daqgroup/development/tools/fpcupdeluxe/lazarus/lazarus";
 if [[ -x $bin ]]; then echo "$bin"; return 0; fi;
 unix catlnk /opt/crwdaq/resource/fpcupdeluxe.desktop | grep -P '^Exec=' | sed 's/^Exec=\s*//' | cut -d' ' -f1;
};

function exec_h2pas(){
 local bin="$(fpcupdeluxe_lazarus_bin)";
 if [[ -x $bin ]]; then
  dir="$(dirname $bin)"; dir="$(dirname $dir)";
  bin="$(find $dir -type f -executable -name 'h2pas' | head -n1)";
  if [[ -x $bin ]]; then
   exec $bin "$@";
  else
   fatal 1 "Error: could not find h2pas.";
  fi;
 else
  fatal 1 "Error: could not find fpcupdeluxe.";
 fi;
};

######
# MAIN
######

function main(){
 exec_h2pas "$@"; 
};

main "$@";

##############
## END OF FILE
##############
