////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWKIT.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Mouse position viewer.                                                     //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 2021xxxx - Created by A.K.                                                 //
// 20240118 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

program mousepos; // Mouse position viewer

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 {$IFDEF WINDOWS} shellapi, {$ENDIF}
 sysutils, classes, math,
 Forms, Interfaces, // this includes the LCL widgetset
 _crw_alloc, _crw_sesman,
 form_mousepos;

{$R *.res}

begin

 if not SessionManager.Start('$ 1') then begin
  if FindAppActivate(MousePosWndClass,MousePosWndTitle,true)
  then writeln('PID ',FindAppPid(MousePosWndClass,MousePosWndTitle),' activated.');
  Exit;
 end;
 RequireDerivedFormResource:=True;
  Application.Scaled:=True;
 Application.Initialize;
 Application.CreateForm(TFormMousePos, FormMousePos);
 Application.Run;

end.

//////////////
// END OF FILE
//////////////

