#!/bin/bash

##########################################################
# Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru
##########################################################

function note(){ return; };

function fatal(){
 local date="$(date +%Y.%m.%d-%H:%M:%S)"; local script="$(basename ${BASH_SOURCE[0]})";
 if which notify-send; then notify-send -t 30000 -i dialog-error "$date: $script" "$1"; fi;
 echo -ne "\n$1\n\n";
 exit 1;
};

note "Script identification.";
note "######################";
readonly startupdir="$(pwd -LP)";
readonly scriptfile="${BASH_SOURCE[0]}";
readonly scriptname="$(basename $scriptfile)";
readonly scriptbase="$(basename $scriptfile .sh)";
readonly scripthome="$(dirname  $scriptfile)";
readonly scriptFILE="$(realpath $scriptfile)";
readonly scriptHOME="$(dirname  $scriptFILE)";

note "Extract target package name from script name.";
note "#############################################";
readonly targetname="$(echo "$scriptbase" | sed 's/^[a-z]*-//')";

note "###########################";
note "First argument is a nimber?";
note "###########################";
function is_number(){
 case $1 in
  ''|*[!0-9]*)  return 1; ;;
  *)            return 0; ;;
 esac;
};

note "################################";
note "Uses language dependent strings?";
note "################################";
let uses_langstr=1; note "# 1/0=ON/OFF";

note "##############################";
note "Language dependent string echo";
note "langstr en 'Hello' ru 'Привет'";
note "##############################";
function langstr(){
 local lng="en"; local msg="";
 if [ "$uses_langstr" = "1" ]; then lng="${LANG:0:2}"; fi;
 while [ -n "$lng" ] && [ -n "$1" ] && [ -n "$2" ]; do
  if [ "$lng" = "$1" ]; then msg="$2"; break; fi;
  if [ "$lng" = "en" ]; then msg="$2"; fi;
  if [ "$lng" = "us" ]; then msg="$2"; fi;
  if [ "$lng" = "uk" ]; then msg="$2"; fi;
  shift; shift;
 done;
 if [ -n "$msg" ]; then echo "$msg"; fi;
};

note "###################################";
note "Notification messages with timeout.";
note "Example: notify_ok title message 10";
note "Example: notify_ok 10 title message";
note "###################################";
declare -i default_notify_timeout=5;
function notify_info(){
 if which notify-send >/dev/null 2>&1; then
  local timeout="$default_notify_timeout";
  if is_number "$1"; then timeout="$1"; shift; fi;
  if is_number "$3"; then timeout="$3"; fi; timeout="$(echo "$timeout*1000" | bc)";
  notify-send -u low -t $timeout -i dialog-information "$(date +%Y.%m.%d-%H:%M:%S) - $1" "$2";
 fi;
 echo -ne "\n$1 - Information: $2\n\n";
};
function notify_ok(){
 if which notify-send >/dev/null 2>&1; then
  local timeout="$default_notify_timeout";
  if is_number "$1"; then timeout="$1"; shift; fi;
  if is_number "$3"; then timeout="$3"; fi; timeout="$(echo "$timeout*1000" | bc)";
  notify-send -u normal -t $timeout -i dialog-ok "$(date +%Y.%m.%d-%H:%M:%S) - $1" "$2";
 fi;
 echo -ne "\n$1 - Ok: $2\n\n";
};
function notify_ok_apply(){
 if which notify-send >/dev/null 2>&1; then
  local timeout="$default_notify_timeout";
  if is_number "$1"; then timeout="$1"; shift; fi;
  if is_number "$3"; then timeout="$3"; fi; timeout="$(echo "$timeout*1000" | bc)";
  notify-send -u normal -t $timeout -i dialog-ok-apply "$(date +%Y.%m.%d-%H:%M:%S) - $1" "$2";
 fi;
 echo -ne "\n$1 - Ok-apply: $2\n\n";
};
function notify_warning(){
 if which notify-send >/dev/null 2>&1; then
  local timeout="$default_notify_timeout";
  if is_number "$1"; then timeout="$1"; shift; fi;
  if is_number "$3"; then timeout="$3"; fi; timeout="$(echo "$timeout*1000" | bc)";
  notify-send -u normal -t $timeout -i dialog-warning "$(date +%Y.%m.%d-%H:%M:%S) - $1" "$2";
 fi;
 echo -ne "\n$1 - Warning: $2\n\n";
};
function notify_cancel(){
 if which notify-send >/dev/null 2>&1; then
  local timeout="$default_notify_timeout";
  if is_number "$1"; then timeout="$1"; shift; fi;
  if is_number "$3"; then timeout="$3"; fi; timeout="$(echo "$timeout*1000" | bc)";
  notify-send -u critical -t $timeout -i dialog-cancel "$(date +%Y.%m.%d-%H:%M:%S) - $1" "$2";
 fi;
 echo -ne "\n$1 - Cancel: $2\n\n";
};
function notify_error(){
 if which notify-send >/dev/null 2>&1; then
  local timeout="$default_notify_timeout";
  if is_number "$1"; then timeout="$1"; shift; fi;
  if is_number "$3"; then timeout="$3"; fi; timeout="$(echo "$timeout*1000" | bc)";
  notify-send -u critical -t $timeout -i dialog-error "$(date +%Y.%m.%d-%H:%M:%S) - $1" "$2";
 fi;
 echo -ne "\n$1 - Error: $2\n\n";
};

function pack_daqgroup_suite_all(){
 function deletebackuplib(){
  while [ -n "$1" ]; do
   if [ -d "$1" ]; then
    local arch="$(uname -m)";
    local bckfiles="$(find $1 -type d | grep "/backup$")";
    local libfiles="$(find $1 -type d | grep "/lib/$arch-linux$")";
    for f in $bckfiles $libfiles; do rm -fvr $f; done;
   fi;
   shift;
  done;
 };
 if [ -z "$XZ_OPT" ]; then export XZ_OPT="-9"; fi;
 if pushd $scriptHOME; then
  local flist="";
  for d in $(ls -1 .); do
   if [ -d $d ]; then
    flist="$flist $d";
   fi;
  done;
  deletebackuplib $flist;
  echo "XZ_OPT=$XZ_OPT";
  local date="$(date +%Y%m%d)";
  local arch="$date-$targetname.tar.xz";
  if [ -e $arch ]; then rm -fv $arch; fi;
  local command="tar -cpJf $arch $flist $scriptname";
  echo -ne "\n Homedir: $(pwd)\n Execute: $command\n";
  if $command; then
   notify_ok "$scriptname" "$(langstr en 'Created archive' ru 'Создан архив') $arch.";
  else
   notify_error "$scriptname" "$(langstr en 'Failed achive' ru 'Сбой создания архива') $arch.";
  fi;
 fi;
 popd;
 echo -e "\n$(date +%Y.%m.%d-%H:%M:%S) - $scriptname done.\n";
};

pack_daqgroup_suite_all;

##############
## END OF FILE
##############
