@echo off
Title %~nx0
SetLocal EnableExtensions EnableDelayedExpansion
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Copyright (c) 2018-2021 Alexey Kuryakin kouriakine@mail.ru ::
:: Under MIT License, see https://opensource.org/licenses/MIT ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: The script to fix (validate) text files EOL=(End Of Line). ::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

goto :Main

:Version
echo %~n0 version 1.0
goto :EOF

:Copyright
echo Copyright ^(c^) 2002-2023 Alexey Kuryakin daqgroup@mail.ru
goto :EOF

:Help
call :Version
call :Copyright
echo about:
echo  %~n0 is utility to fix ^(validate^) text file^(s^) EOL.
echo  EOL is End Of Line marker use to separate text lines.
echo  Usually it's: CRLF on Windows, LF on Unix, CR on MAC.
echo  %~n0 converts any text EOL to current system's EOL.
echo usage:
echo  %~n0 [options] [parameters]
echo options:
echo  --version - print version
echo  -h,--help - print help screen
echo  -t,--test - run in test mode, no file conversion
echo parameters:
echo  text file^(s^) to fix EOL
echo  if '-' or no parameters
echo  then uses stdin/stdout
echo examples:
echo  %~n0 -h
echo  %~n0 *.txt
echo  %~n0 -t test.txt
echo  type test.txt ^| %~n0 ^> fixed.txt 
goto :EOF

:Main
set /a test=0
set /a code=0
if /i "%~1" == ""          goto :RunFixEol
if /i "%~1" == "-"         goto :RunFixEol
if /i "%~1" == "-h"        goto :Help
if /i "%~1" == "--help"    goto :Help
if /i "%~1" == "--version" goto :Version
if /i "%~1" == "-t"        set /a test=1
if /i "%~1" == "--test"    set /a test=1
if /i "%~1" == "-t"        goto :FixEol
if /i "%~1" == "--test"    goto :FixEol
call :IsOption "%~1" &&    goto :InvalidOption
:FixEol
for %%i in ( %* ) do call :FixEolFile "%%i"
exit /b %code%
goto :EOF

:RunFixEol
call unix unix2dos || set /a code=1
exit /b %code%
goto :EOF

:FixEolFile
if "%~1" == "" goto :EOF
if /i "%~1" == "-t" goto :EOF
if /i "%~1" == "--test" goto :EOF
if not exist "%~1" goto :FileMissed
set "fixeol_tmp=%TEMP%\%~nx1.fixeol.tmp"
if exist "%fixeol_tmp%" del /f /q "%fixeol_tmp%"
call unix unix2dos -n "%~1" "%fixeol_tmp%" 1>nul 2>nul && call :FixEolFileTest "%~1" "%fixeol_tmp%"
if exist "%fixeol_tmp%" del /f /q "%fixeol_tmp%"
goto :EOF

:FixEolFileTest
if "%~1" == "" goto :EOF
if "%~2" == "" goto :EOF
if not exist "%~1" goto :FileMissed
if not exist "%~2" goto :FileMissed
call fc /b "%~1" "%~2" 1>nul 2>nul || goto :FixEolFileReal
goto :FilePassed
goto :EOF

:FixEolFileReal
if "%~1" == "" goto :EOF
if not exist "%~1" goto :FileMissed
if "%test%" == "1" goto :FileFaulty
call unix unix2dos "%~1" 1>nul 2>nul && goto :FileFixed
goto :FileFailed
goto :EOF

:FileFixed
echo fixeol: fixed  - "%~1"
goto :EOF

:FileFaulty
echo fixeol: faulty - "%~1"
set /a code=1
goto :EOF

:FilePassed
echo fixeol: passed - "%~1" 1>&2
goto :EOF

:FileMissed
echo fixeol: missed - "%~1" 1>&2
set /a code=1
goto :EOF

:FileFailed
echo fixeol: failed - "%~1" 1>&2
set /a code=1
goto :EOF

:IsOption
if "%~1" == "" exit /b 1
set "opt=%~1"
if "%opt:~0,1%" == "-" exit /b 0
exit /b 1
goto :EOF

:InvalidOption
echo fixeol: Invalid option "%~1" 1>&2
exit /b 1
goto :EOF
