#!/bin/bash

###########################################################
## Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru
###########################################################

###########################################################
## Find window by title [ and maybe class, pid, exe, host].
## Then list found window(s).
###########################################################

###########################################################
source $(crwkit which crwlib_base.sh); # Use base library #
source $(crwkit which crwlib_file.sh); # Use file library #
###########################################################

let fatal_notify_uses=0;

function do_help(){
 local name="$(basename ${BASH_SOURCE[0]})";
 echo "$name version 1.0";
 if [ $1 -eq 0 ]; then return 0; fi;
 echo "Copyright (c) 2002-2024 Alexey Kuryakin daqgroup@mail.ru";
 echo "$name - find window by title [ class, pid, exe, host ].";
 echo "Then list found window(s).";
 echo "Usage:";
 echo " $name [-options] [parameters]";
 echo "Options:";
 echo " --help           - print help.";
 echo " --version        - print version.";
 echo " -i,--ignore-case - ignore char case";
 echo " -c,--class c     - also match window class (c)";
 echo " -p,--pid p       - also match process PID  (p)";
 echo " -e,--exe e       - also match executable   (e)";
 echo " -h,--host h      - also match host name    (h)";
 echo " --               - end of options, followed params";
 echo "Parameters:";
 echo " title - target window title (optional)";
 echo "         on empty params uses title='*'";
 echo " class - target window class (optional)";
 echo " exe   - target exe or pid   (optional)";
 echo "Notes:";
 echo " 1) -opt and --opt options are equivalent.";
 echo "    for example: -pid and --pid are synonyms.";
 echo " 2) title,class,host may be a regexp like '*'";
 echo " 3) exe must be a basename of executable";
 echo " 4) pid must be a number = process PID";
 echo "Examples:";
 echo " unix $name --help";
 echo " unix $name --version";
 echo " unix $name";
 echo " unix $name 'KCalc'";
 echo " unix $name '*' 'kcalc.*'";
 echo " unix $name '*' '*' kcalc";
};

function main(){
 case $1 in
  -version|--version) do_help 0; exit 0; ;;
  -help|--help)       do_help 1; exit 0; ;;
  '')                 exec $scriptHOME/findwindow.sh "*"; ;;
  *)                  exec $scriptHOME/findwindow.sh "$@"; ;;
 esac;
};

main "$@";

##############
## END OF FILE
##############
