/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.metadata;

import java.sql.PseudoColumnUsage;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.jdbc.DbMetadataMediator;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.metadata.Clause;
import org.firebirdsql.jdbc.metadata.MetadataPattern;
import org.firebirdsql.jdbc.metadata.MetadataPatternMatcher;
import org.firebirdsql.jdbc.metadata.RowValueBuilder;
import org.firebirdsql.util.FirebirdSupportInfo;

public abstract class GetPseudoColumns {
    private static final String PSEUDOCOLUMNS = "PSEUDOCOLUMNS";
    public static final String COLUMN_RELATION_NAME = "RDB$RELATION_NAME";
    private static final RowDescriptor ROW_DESCRIPTOR = DbMetadataMediator.newRowDescriptorBuilder(12).at(0).simple(449, 63, "TABLE_CAT", "PSEUDOCOLUMNS").addField().at(1).simple(449, 63, "TABLE_SCHEM", "PSEUDOCOLUMNS").addField().at(2).simple(448, 63, "TABLE_NAME", "PSEUDOCOLUMNS").addField().at(3).simple(448, 63, "COLUMN_NAME", "PSEUDOCOLUMNS").addField().at(4).simple(496, 0, "DATA_TYPE", "PSEUDOCOLUMNS").addField().at(5).simple(496, 0, "COLUMN_SIZE", "PSEUDOCOLUMNS").addField().at(6).simple(497, 0, "DECIMAL_DIGITS", "PSEUDOCOLUMNS").addField().at(7).simple(496, 0, "NUM_PREC_RADIX", "PSEUDOCOLUMNS").addField().at(8).simple(448, 50, "COLUMN_USAGE", "PSEUDOCOLUMNS").addField().at(9).simple(449, Integer.MAX_VALUE, "REMARKS", "PSEUDOCOLUMNS").addField().at(10).simple(496, 0, "CHAR_OCTET_LENGTH", "PSEUDOCOLUMNS").addField().at(11).simple(448, 3, "IS_NULLABLE", "PSEUDOCOLUMNS").addField().toRowDescriptor();
    private static final String DB_KEY_REMARK = "The RDB$DB_KEY column in a select list will be renamed by Firebird to DB_KEY in the result set (both as column name and label). Result set getters in Jaybird will map this, but in introspection of ResultSetMetaData, DB_KEY will be reported. Identification as a Types.ROWID will only work in a select list (ResultSetMetaData), not for parameters (ParameterMetaData), but Jaybird will allow setting a RowId value.";
    private final DbMetadataMediator mediator;

    private GetPseudoColumns(DbMetadataMediator mediator) {
        this.mediator = mediator;
    }

    public ResultSet getPseudoColumns(String tableNamePattern, String columnNamePattern) throws SQLException {
        boolean retrieveRecordVersion;
        if ("".equals(tableNamePattern) || "".equals(columnNamePattern)) {
            return this.createEmpty();
        }
        MetadataPatternMatcher matcher = MetadataPattern.compile(columnNamePattern).toMetadataPatternMatcher();
        boolean retrieveDbKey = matcher.matches("RDB$DB_KEY");
        boolean bl = retrieveRecordVersion = this.supportsRecordVersion() && matcher.matches("RDB$RECORD_VERSION");
        if (!retrieveDbKey && !retrieveRecordVersion) {
            return this.createEmpty();
        }
        try (ResultSet rs = this.mediator.performMetaDataQuery(this.createGetPseudoColumnsQuery(tableNamePattern));){
            if (!rs.next()) {
                ResultSet resultSet = this.createEmpty();
                return resultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(ROW_DESCRIPTOR);
            do {
                String tableName = rs.getString(COLUMN_RELATION_NAME);
                if (retrieveDbKey) {
                    int dbKeyLength = rs.getInt("RDB$DBKEY_LENGTH");
                    valueBuilder.at(2).setString(tableName).at(3).setString("RDB$DB_KEY").at(4).setInt(-8).at(5).setInt(dbKeyLength).at(7).setInt(10).at(8).setString(PseudoColumnUsage.NO_USAGE_RESTRICTIONS.name()).at(9).setString(DB_KEY_REMARK).at(10).setInt(dbKeyLength).at(11).setString("NO");
                    rows.add(valueBuilder.toRowValue(true));
                }
                if (!retrieveRecordVersion || !rs.getBoolean("HAS_RECORD_VERSION")) continue;
                valueBuilder.at(2).setString(tableName).at(3).setString("RDB$RECORD_VERSION").at(4).setInt(-5).at(5).setInt(19).at(6).setInt(0).at(7).setInt(10).at(8).setString(PseudoColumnUsage.NO_USAGE_RESTRICTIONS.name()).at(11).setString(rs.getString("RECORD_VERSION_NULLABLE"));
                rows.add(valueBuilder.toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(ROW_DESCRIPTOR, rows);
            return fBResultSet;
        }
    }

    abstract boolean supportsRecordVersion();

    abstract DbMetadataMediator.MetadataQuery createGetPseudoColumnsQuery(String var1);

    private ResultSet createEmpty() throws SQLException {
        return new FBResultSet(ROW_DESCRIPTOR, Collections.emptyList());
    }

    public static GetPseudoColumns create(DbMetadataMediator mediator) {
        FirebirdSupportInfo firebirdSupportInfo = mediator.getFirebirdSupportInfo();
        if (firebirdSupportInfo.isVersionEqualOrAbove(3, 0)) {
            return FB3.createInstance(mediator);
        }
        return FB2_5.createInstance(mediator);
    }

    private static final class FB3
    extends GetPseudoColumns {
        private static final String GET_PSEUDO_COLUMNS_FRAGMENT_3 = "select\n  trim(trailing from RDB$RELATION_NAME) as RDB$RELATION_NAME,\n  RDB$DBKEY_LENGTH,\n  RDB$DBKEY_LENGTH = 8 as HAS_RECORD_VERSION,\n  case\n    when RDB$RELATION_TYPE in (0, 1, 4, 5) then 'NO'\n    when RDB$RELATION_TYPE in (2, 3) then 'YES'\n    else ''\n  end as RECORD_VERSION_NULLABLE\nfrom RDB$RELATIONS\n";
        private static final String GET_PSEUDO_COLUMNS_END_3 = "order by RDB$RELATION_NAME";

        private FB3(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetPseudoColumns createInstance(DbMetadataMediator mediator) {
            return new FB3(mediator);
        }

        @Override
        boolean supportsRecordVersion() {
            return true;
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetPseudoColumnsQuery(String tableNamePattern) {
            Clause tableNameClause = new Clause(GetPseudoColumns.COLUMN_RELATION_NAME, tableNamePattern);
            String sql = GET_PSEUDO_COLUMNS_FRAGMENT_3 + tableNameClause.getCondition("where ", "\n") + GET_PSEUDO_COLUMNS_END_3;
            return new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableNameClause));
        }
    }

    private static final class FB2_5
    extends GetPseudoColumns {
        private static final String GET_PSEUDO_COLUMNS_FRAGMENT_2_5 = "select\n RDB$RELATION_NAME,\n RDB$DBKEY_LENGTH,\n 'F' AS HAS_RECORD_VERSION,\n '' AS RECORD_VERSION_NULLABLE\nfrom RDB$RELATIONS\n";
        private static final String GET_PSEUDO_COLUMNS_END_2_5 = "order by RDB$RELATION_NAME";

        private FB2_5(DbMetadataMediator mediator) {
            super(mediator);
        }

        private static GetPseudoColumns createInstance(DbMetadataMediator mediator) {
            return new FB2_5(mediator);
        }

        @Override
        boolean supportsRecordVersion() {
            return false;
        }

        @Override
        DbMetadataMediator.MetadataQuery createGetPseudoColumnsQuery(String tableNamePattern) {
            Clause tableNameClause = new Clause(GetPseudoColumns.COLUMN_RELATION_NAME, tableNamePattern);
            String sql = GET_PSEUDO_COLUMNS_FRAGMENT_2_5 + tableNameClause.getCondition("where ", "\n") + GET_PSEUDO_COLUMNS_END_2_5;
            return new DbMetadataMediator.MetadataQuery(sql, Clause.parameters(tableNameClause));
        }
    }
}

