/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public class FBProcedureParam
implements Cloneable {
    private final boolean isParam;
    private @Nullable Object value;
    private final String paramValue;
    private final int position;
    private int type;
    private int index = -1;
    private boolean valueSet;

    public FBProcedureParam(int position, String paramValue) {
        this.position = position;
        boolean isLiteral = paramValue.startsWith("'") && paramValue.endsWith("'");
        this.isParam = !isLiteral && paramValue.indexOf(63) >= 0;
        this.paramValue = paramValue.trim();
    }

    public final boolean isParam() {
        return this.isParam;
    }

    public final int getPosition() {
        return this.position;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public final String getParamValue() {
        return this.paramValue;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public void setValue(@Nullable Object value) throws SQLException {
        if (!this.isParam) {
            throw new SQLException("Cannot set parameter, since it is constant.", "HY105");
        }
        this.value = value;
        this.valueSet = true;
    }

    public boolean isValueSet() {
        return this.valueSet;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBProcedureParam)) {
            return false;
        }
        FBProcedureParam other = (FBProcedureParam)obj;
        return this.position == other.position && this.value != null ? this.value.equals(other.value) : other.value == null;
    }

    public int hashCode() {
        int hashCode = 887;
        hashCode = 31 * hashCode + this.position;
        hashCode = 31 * hashCode + (this.value != null ? this.value.hashCode() : 0);
        return hashCode;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError("clone() unexpectedly not supported", e);
        }
    }
}

