/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FetchConfig;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.jdbc.ResultSetBehavior;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class AbstractStatement
implements Statement,
FirebirdStatement {
    private static final AtomicInteger STATEMENT_ID_GENERATOR = new AtomicInteger();
    private final int localStatementId = STATEMENT_ID_GENERATOR.incrementAndGet();
    protected final FBConnection connection;
    private @Nullable String cursorName;
    private volatile @Nullable SQLWarning warning;
    private FetchConfig fetchConfig;
    private volatile boolean closed;
    private boolean poolable;
    private boolean closeOnCompletion;

    protected AbstractStatement(FBConnection connection, ResultSetBehavior resultSetBehavior) {
        this.connection = Objects.requireNonNull(connection, "connection");
        this.fetchConfig = new FetchConfig(resultSetBehavior);
    }

    @Override
    public final FBConnection getConnection() throws SQLException {
        this.checkValidity();
        return this.connection;
    }

    protected abstract FbStatement getStatementHandle() throws SQLException;

    public abstract int getStatementType();

    @Override
    public void close() throws SQLException {
        this.warning = null;
        this.closed = true;
    }

    @Override
    public final boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isValid() {
        return !this.closed;
    }

    protected final void checkValidity() throws SQLException {
        if (this.closed) {
            throw FbExceptionBuilder.toNonTransientException(337248303);
        }
    }

    public final void completeStatement() throws SQLException {
        this.completeStatement(CompletionReason.OTHER);
    }

    public abstract void completeStatement(CompletionReason var1) throws SQLException;

    @Override
    public final boolean isPoolable() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            boolean bl = this.poolable;
            return bl;
        }
    }

    @Override
    public final void setPoolable(boolean poolable) throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.poolable = poolable;
        }
    }

    @Override
    public final boolean isCloseOnCompletion() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            boolean bl = this.closeOnCompletion;
            return bl;
        }
    }

    @Override
    public final void closeOnCompletion() throws SQLException {
        try (LockCloseable ignored = this.withLock();){
            this.checkValidity();
            this.closeOnCompletion = true;
        }
    }

    protected final void performCloseOnCompletion() throws SQLException {
        if (this.closeOnCompletion) {
            this.close();
        }
    }

    protected final FetchConfig fetchConfig() {
        try (LockCloseable ignored = this.withLock();){
            FetchConfig fetchConfig = this.fetchConfig;
            return fetchConfig;
        }
    }

    protected final ResultSetBehavior resultSetBehavior() {
        return this.fetchConfig().resultSetBehavior();
    }

    @Override
    public final int getResultSetType() throws SQLException {
        this.checkValidity();
        return this.resultSetBehavior().type();
    }

    @Override
    public final int getResultSetConcurrency() throws SQLException {
        this.checkValidity();
        return this.resultSetBehavior().concurrency();
    }

    @Override
    public final int getResultSetHoldability() throws SQLException {
        this.checkValidity();
        return this.resultSetBehavior().holdability();
    }

    @Override
    public final int getMaxRows() throws SQLException {
        this.checkValidity();
        return this.fetchConfig().maxRows();
    }

    @Override
    public final void setMaxRows(int max) throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.fetchConfig = this.fetchConfig.withMaxRows(max);
        }
    }

    @Override
    public final void setLargeMaxRows(long max) throws SQLException {
        if (max > Integer.MAX_VALUE) {
            this.addWarning(new SQLWarning("Implementation limit: maxRows cannot exceed Integer.MAX_VALUE, value was %d, reset to 0".formatted(max), "HY024"));
            max = 0L;
        }
        this.setMaxRows((int)max);
    }

    @Override
    public final long getLargeMaxRows() throws SQLException {
        return this.getMaxRows();
    }

    @Override
    public final int getFetchSize() throws SQLException {
        this.checkValidity();
        return this.fetchConfig().fetchSize();
    }

    @Override
    public final void setFetchSize(int rows) throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.fetchConfig = this.fetchConfig.withFetchSize(rows);
        }
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        this.checkValidity();
        return this.fetchConfig().direction();
    }

    @Override
    public final void setFetchDirection(int direction) throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.fetchConfig = this.fetchConfig.withDirection(direction);
        }
    }

    @Override
    public final void setCursorName(@Nullable String cursorName) throws SQLException {
        this.checkValidity();
        try (LockCloseable ignored = this.withLock();){
            this.cursorName = cursorName;
        }
    }

    protected final @Nullable String getCursorName() {
        return this.cursorName;
    }

    @Override
    public final @Nullable SQLWarning getWarnings() throws SQLException {
        this.checkValidity();
        return this.warning;
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.checkValidity();
        this.warning = null;
    }

    protected final void addWarning(SQLWarning warning) {
        try (LockCloseable ignored = this.withLock();){
            if (this.connection.isIgnoreSQLWarnings()) {
                return;
            }
            SQLWarning currentWarning = this.warning;
            if (currentWarning == null) {
                this.warning = warning;
            } else {
                currentWarning.setNextWarning(warning);
            }
        }
    }

    @Override
    public final int getLocalStatementId() {
        return this.localStatementId;
    }

    public final int hashCode() {
        return this.localStatementId;
    }

    public final boolean equals(Object other) {
        FirebirdStatement otherStmt;
        return other instanceof FirebirdStatement && this.localStatementId == (otherStmt = (FirebirdStatement)other).getLocalStatementId();
    }

    protected final LockCloseable withLock() {
        return this.connection.withLock();
    }
}

