/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.firebirdsql.ds.FBPooledConnection;
import org.firebirdsql.ds.StatementHandler;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.LockCloseable;
import org.firebirdsql.jaybird.util.ReflectionHelper;
import org.firebirdsql.jaybird.util.SQLExceptionChainBuilder;
import org.firebirdsql.jdbc.FirebirdConnection;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
class PooledConnectionHandler
implements InvocationHandler {
    private final FBPooledConnection owner;
    volatile Connection connection;
    private volatile Connection proxy;
    private volatile boolean forcedClose;
    private final List<StatementHandler> openStatements = new ArrayList<StatementHandler>();
    private static final Method RESET_KNOWN_CLIENT_INFO_PROPERTIES = ReflectionHelper.findMethod(FirebirdConnection.class, "resetKnownClientInfoProperties", new Class[0]);
    private static final Method CONNECTION_IS_CLOSED = ReflectionHelper.findMethod(Connection.class, "isClosed", new Class[0]);
    private static final Method CONNECTION_CLOSE = ReflectionHelper.findMethod(Connection.class, "close", new Class[0]);
    private static final Set<String> STATEMENT_CREATION_METHOD_NAMES = Set.of("createStatement", "prepareCall", "prepareStatement");
    private static final Method TO_STRING = ReflectionHelper.findMethod(Object.class, "toString", new Class[0]);
    private static final Method EQUALS = ReflectionHelper.findMethod(Object.class, "equals", new Class[]{Object.class});
    private static final Method HASH_CODE = ReflectionHelper.findMethod(Object.class, "hashCode", new Class[0]);

    PooledConnectionHandler(Connection connection, FBPooledConnection owner) {
        this.connection = connection;
        this.owner = owner;
        this.proxy = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), ReflectionHelper.getAllInterfaces(connection.getClass()), (InvocationHandler)this);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.equals(TO_STRING)) {
            return "Proxy for " + String.valueOf(this.connection);
        }
        if (method.equals(EQUALS)) {
            return proxy == args[0];
        }
        if (method.equals(HASH_CODE)) {
            return System.identityHashCode(proxy);
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            try {
                return method.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        if (method.equals(CONNECTION_IS_CLOSED)) {
            return this.isClosed();
        }
        if (method.equals(RESET_KNOWN_CLIENT_INFO_PROPERTIES)) {
            try {
                method.invoke((Object)this.connection, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        } else if (this.isClosed() && !method.equals(CONNECTION_CLOSE)) {
            throw this.forcedClose ? FbExceptionBuilder.toNonTransientConnectionException(337248337) : FbExceptionBuilder.connectionClosed();
        }
        try {
            if (method.equals(CONNECTION_CLOSE)) {
                if (!this.isClosed()) {
                    this.handleClose(true);
                }
                return null;
            }
            if (method.getDeclaringClass().equals(Connection.class) && STATEMENT_CREATION_METHOD_NAMES.contains(method.getName())) {
                Statement pstmt = (Statement)method.invoke((Object)this.connection, args);
                StatementHandler stmtHandler = new StatementHandler(this, pstmt);
                try (LockCloseable ignored = this.owner.withLock();){
                    this.openStatements.add(stmtHandler);
                }
                return stmtHandler.getProxy();
            }
            return method.invoke((Object)this.connection, args);
        }
        catch (InvocationTargetException ite) {
            Throwable inner = ite.getTargetException();
            if (inner instanceof SQLException) {
                SQLException se = (SQLException)inner;
                this.owner.fireConnectionError(se);
            }
            throw inner;
        }
        catch (SQLException se) {
            this.owner.fireConnectionError(se);
            throw se;
        }
    }

    boolean isRollbackAllowed() throws SQLException {
        return !this.connection.getAutoCommit();
    }

    void handleClose(boolean notifyOwner) throws SQLException {
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        try {
            this.closeStatements();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
        if (this.isRollbackAllowed()) {
            try {
                this.connection.rollback();
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        } else if (this.connection.getAutoCommit() && this.connection.isWrapperFor(FirebirdConnection.class) && this.connection.unwrap(FirebirdConnection.class).isUseFirebirdAutoCommit()) {
            try {
                this.connection.setAutoCommit(false);
                this.connection.setAutoCommit(true);
            }
            catch (SQLException ex) {
                chain.append(ex);
            }
        }
        try {
            this.connection.clearWarnings();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
        this.proxy = null;
        this.connection = null;
        this.owner.releaseConnectionHandler(this);
        if (notifyOwner) {
            this.owner.fireConnectionClosed();
        }
        chain.throwIfPresent();
    }

    Connection getProxy() {
        return this.proxy;
    }

    void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.handleClose(false);
        }
        finally {
            this.forcedClose = true;
        }
    }

    boolean isClosed() {
        return this.connection == null || this.proxy == null;
    }

    void statementErrorOccurred(StatementHandler stmtHandler, SQLException sqle) {
        this.owner.fireConnectionError(sqle);
    }

    void forgetStatement(StatementHandler stmtHandler) {
        try (LockCloseable ignored = this.owner.withLock();){
            this.openStatements.remove(stmtHandler);
        }
    }

    void closeStatements() throws SQLException {
        SQLExceptionChainBuilder chain = new SQLExceptionChainBuilder();
        try (LockCloseable ignored = this.owner.withLock();){
            for (StatementHandler stmt : new ArrayList<StatementHandler>(this.openStatements)) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    chain.append(ex);
                }
                catch (RuntimeException e) {
                    chain.append(new SQLException("Runtime exception on statement close", e));
                }
            }
            this.openStatements.clear();
        }
        chain.throwIfPresent();
    }
}

