/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.ds;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.BinaryRefAddr;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.firebirdsql.ds.AbstractConnectionPropertiesDataSource;
import org.firebirdsql.ds.DataSourceFactory;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jaybird.props.def.ConnectionProperty;
import org.firebirdsql.jaybird.util.StringUtils;
import org.firebirdsql.jaybird.xca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.FBDataSource;

public class FBSimpleDataSource
extends AbstractConnectionPropertiesDataSource
implements DataSource,
Serializable,
Referenceable {
    private static final long serialVersionUID = 3156578540634970427L;
    static final String REF_DESCRIPTION = "description";
    static final String REF_MCF = "mcf";
    protected final FBManagedConnectionFactory mcf;
    private final ReadWriteLock dsLock = new ReentrantReadWriteLock();
    protected transient FBDataSource ds;
    protected String description;

    public FBSimpleDataSource() {
        this(GDSFactory.getDefaultGDSType());
    }

    public FBSimpleDataSource(GDSType type) {
        this.mcf = new FBManagedConnectionFactory(false, type);
    }

    FBSimpleDataSource(FBManagedConnectionFactory mcf) {
        this.mcf = mcf;
    }

    @Override
    public TransactionParameterBuffer getTransactionParameters(int isolation) {
        return this.mcf.getTransactionParameters(isolation);
    }

    @Override
    public void setTransactionParameters(int isolation, TransactionParameterBuffer tpb) {
        this.mcf.setTransactionParameters(isolation, tpb);
    }

    @Override
    public void setNonStandardProperty(String propertyMapping) {
        this.mcf.setNonStandardProperty(propertyMapping);
    }

    @Override
    public String getProperty(String name) {
        return this.mcf.getProperty(name);
    }

    @Override
    public void setProperty(String name, String value) {
        this.mcf.setProperty(name, value);
    }

    @Override
    public Integer getIntProperty(String name) {
        return this.mcf.getIntProperty(name);
    }

    @Override
    public void setIntProperty(String name, Integer value) {
        this.mcf.setIntProperty(name, value);
    }

    @Override
    public Boolean getBooleanProperty(String name) {
        return this.mcf.getBooleanProperty(name);
    }

    @Override
    public void setBooleanProperty(String name, Boolean value) {
        this.mcf.setBooleanProperty(name, value);
    }

    @Override
    public Map<ConnectionProperty, Object> connectionPropertyValues() {
        return this.mcf.connectionPropertyValues();
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference ref = new Reference(FBSimpleDataSource.class.getName(), DataSourceFactory.class.getName(), null);
        ref.add(new StringRefAddr(REF_DESCRIPTION, this.getDescription()));
        byte[] data = DataSourceFactory.serialize(this.mcf);
        ref.add(new BinaryRefAddr(REF_MCF, data));
        return ref;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.getDataSource().getConnection(username, password);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource getDataSource() throws SQLException {
        Lock readLock = this.dsLock.readLock();
        readLock.lock();
        try {
            if (this.ds != null) {
                FBDataSource fBDataSource = this.ds;
                return fBDataSource;
            }
        }
        finally {
            readLock.unlock();
        }
        Lock writeLock = this.dsLock.writeLock();
        writeLock.lock();
        try {
            if (this.ds != null) {
                FBDataSource fBDataSource = this.ds;
                return fBDataSource;
            }
            if (StringUtils.trimToNull(this.mcf.getDatabaseName()) == null) {
                throw FbExceptionBuilder.toNonTransientConnectionException(337248329);
            }
            FBDataSource fBDataSource = this.ds = (FBDataSource)this.mcf.createConnectionFactory();
            return fBDataSource;
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw FbExceptionBuilder.forException(337248338).messageParameter((Object)(iface != null ? iface.getName() : "(null)")).toSQLException();
        }
        return iface.cast(this);
    }
}

