////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Spectr Fit Preset.                                                    //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231205 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_spectrfitpreset; // Form Spectr Fit Preset

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Menus,
 ActnList, ToolWin, ImgList, Clipbrd, Spin,
 lcltype, lclintf,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_dynar, _crw_snd, _crw_guard,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormSpectrFitPreset = class(TMasterForm)
    LabelAlgorithm: TLabel;
    ComboBoxAlgorithm: TComboBox;
    LabelMaxCalls: TLabel;
    SpinEditMaxCalls: TSpinEdit;
    LabelTolX: TLabel;
    EditTolX: TEdit;
    LabelTolF: TLabel;
    EditTolF: TEdit;
    LabelTolG: TLabel;
    EditTolG: TEdit;
    LabelSize: TLabel;
    EditSize: TEdit;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function FormSpectrFitPresetExecute(var Method   : Integer; { Метод поиска                           }
                                    var MaxCalls : Integer; { Максимальное число обращений к функции }
                                    var TolX     : Double;  { Требуемая точность по аргументу        }
                                    var TolF     : Double;  { Требуемая точность по функции          }
                                    var TolG     : Double;  { Требуемая точность по градиенту        }
                                    var Size     : Double   { Начальный размер симплекса             }
                                               ) : Integer;

implementation

{$R *.lfm}

function FormSpectrFitPresetExecute;
const
 TheForm : TFormSpectrFitPreset = nil;
begin
 Result:=mrCancel;
 if CanShowModal(TheForm) then
 try
  if not TheForm.Ok then begin
   Application.CreateForm(TFormSpectrFitPreset, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then begin
   TheForm.ComboBoxAlgorithm.ItemIndex:=Method;
   TheForm.SpinEditMaxCalls.Value:=MaxCalls;
   TheForm.EditTolX.Text:=Format('%g',[TolX]);
   TheForm.EditTolF.Text:=Format('%g',[TolF]);
   TheForm.EditTolG.Text:=Format('%g',[TolG]);
   TheForm.EditSize.Text:=Format('%g',[Size]);
   if (mrVoice(TheForm.ShowModal)=mrOk) then begin
    Result:=mrOk;
    Method:=TheForm.ComboBoxAlgorithm.ItemIndex;
    MaxCalls:=TheForm.SpinEditMaxCalls.Value;
    SmartStr2Real(TheForm.EditTolX.Text,TolX);
    SmartStr2Real(TheForm.EditTolF.Text,TolF);
    SmartStr2Real(TheForm.EditTolG.Text,TolG);
    SmartStr2Real(TheForm.EditSize.Text,Size);
   end;
  end;
 except
  on E:Exception do BugReport(E,nil,'FormSpectrFitPresetExecute');
 end;
end;

procedure TFormSpectrFitPreset.FormCreate(Sender: TObject);
begin
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 LocateFormToCenterOfScreen(Self);
 Caption:=RusEng('Параметры минимизации','Fit parameters');
 LabelAlgorithm.Caption:=RusEng('Алгоритм минимизации','Minimization algorithm');
 ComboBoxAlgorithm.Items.Text:='Nelder-Mead             : simplex search'+EOL+
                               'Davidon-Fletcher-Powell : quasi-Newton'+EOL+
                               'Broyden                 : quasi-Newton'+EOL+
                               'Pearson-2               : quasi-Newton'+EOL+
                               'Pearson-3               : quasi-Newton'+EOL+
                               'Zoutendijk              : quasi-Newton'+EOL+
                               'Steward                 : D-F-P,digital grad.'+EOL+
                               'Fletcher-Reeves         : conjugate gradients'+EOL+
                               'Davidon-2               : quasi-Newton';
 LabelMaxCalls.Caption:=RusEng('Макс.число вызовов целевой функции',
                               'Max.num. of objective funct. calls');
 LabelTolX.Caption:=RusEng('Допуск по X (аргумент)','Tolerance of X (argument)');
 LabelTolF.Caption:=RusEng('Допуск по F (значение)','Tolerance of F (fun.val.)');
 LabelTolG.Caption:=RusEng('Допуск по G (градиент)','Tolerance of G (gradient)');
 LabelSize.Caption:=RusEng('Начальный симплекс','Initial simplex');
 BitBtnOk.Caption:=mrCaption(mrOk);
 BitBtnCancel.Caption:=mrCaption(mrCancel);
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_spectrfitpreset;
begin
end;

procedure Free_form_spectrfitpreset;
begin
end;

initialization

 Init_form_spectrfitpreset;

finalization

 Free_form_spectrfitpreset;

end.

//////////////
// END OF FILE
//////////////

