////////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2001-2023 Alexey Kuryakin daqgroup@mail.ru under MIT license //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// This file is part of the CRW-DAQ project by DaqGroup - component CRWLIB.   //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// Purpose:                                                                   //
// Form Edit Data Analysis Plugin Arguments.                                  //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
// History:                                                                   //
// 20231201 - Modified for FPC (A.K.)                                         //
////////////////////////////////////////////////////////////////////////////////

unit form_editdataanalysispluginarguments; // Form Edit Data Analysis Plugin Arguments

{$I _crw_sysdef.inc}

{$I _crw_sysmode.inc}

{$WARN 5023 off : Unit "$1" not used in $2}

interface

uses
 //////////////////////////////////////////////////////
 {$I _crw_uses_first.inc} // NB: MUST BE FIRST USES !!!
 //////////////////////////////////////////////////////
 sysutils, classes, strutils, math,
 Graphics, Controls, Forms, Dialogs, LMessages,
 ExtCtrls, ComCtrls, StdCtrls, Buttons, Grids,
 lcltype, lclintf,
 Form_TextEditor,
 _crw_alloc, _crw_fpu, _crw_rtc, _crw_fifo,
 _crw_str, _crw_eldraw, _crw_fio, _crw_plut,
 _crw_appforms, _crw_apptools, _crw_apputils;

type
  TFormEditDataAnalysisArguments = class(TMasterForm)
    PanelControls: TPanel;
    GroupBoxButtons: TGroupBox;
    BitBtnOk: TBitBtn;
    BitBtnCancel: TBitBtn;
    GroupBoxArguments: TGroupBox;
    StringGridArguments: TStringGrid;
    procedure FormCreate(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
    function  GetArguments:LongString;
    procedure ReadArguments(Dpr:LongString);
  public
    { Public declarations }
  end;

function ExecuteFormEditDataAnalysisArguments(Win:TFormTextEditor;
          var Args:LongString; Params:LongString=''):TModalResult;

implementation

{$R *.lfm}

function ExecuteFormEditDataAnalysisArguments(Win:TFormTextEditor;
          var Args:LongString; Params:LongString=''):TModalResult;
const
 TheForm : TFormEditDataAnalysisArguments = nil;
begin
 Result:=mrCancel;
 Args:='';
 if Win.Ok then
 if CanShowModal(TheForm) then
 try
  if not Assigned(TheForm) then begin
   Application.CreateForm(TFormEditDataAnalysisArguments, TheForm);
   TheForm.Master:=@TheForm;
  end;
  if TheForm.Ok then
  with TheForm do begin
   ApplyParams(Params);
   ReadArguments(Win.PathName);
   if Length(GetArguments)=0 then Result:=mrOk else Result:=ShowModal;
   if (Result=mrOk) then Args:=GetArguments;
  end;
 except
  on E:Exception do BugReport(E,nil,'ExecuteFormEditDataAnalysisArguments');
 end;
end;

procedure TFormEditDataAnalysisArguments.FormCreate(Sender: TObject);
begin
 inherited;
 SetStandardFont(Self);
 SetAllButtonsCursor(Self,crHandPoint);
 Caption:=RusEng('Аргументы вызова','Calling arguments');
 SmartUpdate(GroupBoxArguments,RusEng('Список аргументов:','List of arguments:'));
 SmartUpdate(GroupBoxButtons,RusEng('Команды:','Commands:'));
 SmartUpdate(BitBtnOk,RusEng('Пуск','Run'));
 SmartUpdate(BitBtnCancel,mrCaption(mrCancel));
end;

function TFormEditDataAnalysisArguments.GetArguments:LongString;
var P: TText; r:Integer; Ref,Val:LongString;
begin
 Result:='';
 if Ok then
 try
  P:=NewText;
  try
   for r:=0 to StringGridArguments.RowCount-1 do begin
    Ref:=Trim(StringGridArguments.Cells[0,r]);
    Val:=Trim(StringGridArguments.Cells[1,r]);
    if (Ref<>'') then P.Addln(Format('%s=%s',[Ref,Val]));
   end;
   Result:=P.Text;
  finally
   Kill(P);
  end;
 except
  on E:Exception do BugReport(E,Self,'GetArguments');
 end;
end;

procedure TFormEditDataAnalysisArguments.ReadArguments(Dpr:LongString);
var P:TText; Ref,Val:LongString; i,c,r:Integer;
begin
 if Ok then
 try
  Dpr:=UnifyFileAlias(Dpr);
  StringGridArguments.RowCount:=50;
  StringGridArguments.FixedRows:=0;
  StringGridArguments.ColCount:=2;
  StringGridArguments.FixedCols:=1;
  for r:=0 to StringGridArguments.RowCount-1 do
  for c:=0 to StringGridArguments.ColCount-1 do StringGridArguments.Cells[c,r]:='';
  P:=ExtractListSection(Dpr,RusEng('[Arguments.Rus]','[Arguments.Eng]'),efAsIs);
  try
   r:=0;
   for i:=0 to P.Count-1 do begin
    if r>=StringGridArguments.RowCount then break;
    c:=ExtractNameValuePair(P[i],Ref,Val);
    if (c>0) and (Ref<>'') then begin
     StringGridArguments.Cells[0,r]:=Ref;
     StringGridArguments.Cells[1,r]:=Val;
     inc(r);
    end;
   end;
  finally
   Kill(P);
  end;
 except
  on E:Exception do BugReport(E,Self,'ReadArguments');
 end;
end;

procedure TFormEditDataAnalysisArguments.FormResize(Sender: TObject);
begin
 inherited;
 if Ok then
 try
  with StringGridArguments do
  if (ColCount>1) then ColWidths[1]:=Max(135,Width-ColWidths[0]-25);
 except
  on E:Exception do BugReport(E,Self,'FormResize');
 end;
end;

///////////////////////////////////////
// Unit initialization and finalization
///////////////////////////////////////

procedure Init_form_editdataanalysispluginarguments;
begin
end;

procedure Free_form_editdataanalysispluginarguments;
begin
end;

initialization

 Init_form_editdataanalysispluginarguments;

finalization

 Free_form_editdataanalysispluginarguments;

end.

//////////////
// END OF FILE
//////////////

