 {
 Standard routines for Strings:
 function  IsEmptyStr(s:String):Boolean;
 function  IsNonEmptyStr(s:String):Boolean; 
 function  TailStr(S:String; Pos:Integer):String;
 function  RightStr(S:String; Count:Integer):String;
 function  LeftStr(S:String; Count:Integer):String;
 function  StrAheadOf(S:String; Delim:Char):String;
 function  StrAfterOf(S:String; Delim:Char):String;
 function  ContainsStr(AText,ASubText:String):Boolean;
 function  StartsStr(ASubText,AText:String):Boolean;
 function  EndsStr(ASubText,AText:String):Boolean;
 function  ContainsText(AText,ASubText:String):Boolean;
 function  StartsText(aSubText,aText:String):Boolean;
 function  EndsText(aSubText,aText:String):Boolean;
 function  TrimDef(s,def:String):String;
 function  LastPos(Sub,Str:String):Integer;
 function  CountPos(Sub,Str:String):Integer;
 function  NthPos(Sub,Str:String; n:Integer):Integer;
 function  IsSectionName(S:String):Boolean;
 function  IsEnvVarLink(S:String):Boolean;
 function  CharStr(Leng:Integer; Ch:Char):String;
 function  DupeString(S:String; n:Integer):String;
 function  LeftPad(S:String; Leng:Integer; Ch:Char):String;
 function  RightPad(S:String; Leng:Integer; Ch:Char):String;
 function  CenterPad(S:String; Leng:Integer; Ch:Char):String;
 function  iValDef(Data:String; aDefault:Integer):Integer;
 function  rValDef(Data:String; aDefault:Real):Real;
 function  iEvalDef(Data:String; aDefault:Integer):Integer;
 function  rEvalDef(Data:String; aDefault:Real):Real;
 function  WordIndex(s,list:String):Integer;
 function  StrReplace(s,a,b:String; Flags:Integer):String;
 function  StrAddQuotes(s:String; Quote:Char):String;
 function  StrRemoveQuotes(s:String; Quote:Char):String;
 function  StrAddBrackets(s:String; LBracket,RBracket:Char):String;
 function  StrRemoveBrackets(s:String; LBracket,RBracket:Char):String;
 function  ExtractNameValuePair(arg:String; var Name,Value:String; Sign:Char; Mode:Integer):Integer;
 function  ReadIniVar(VarName:String;Mode:Integer):String;
 function  ReadIniStr(Mode:Integer; FName,SecName,VarName:String):String;
 function  ReadIniAlter(arg:String;Mode:Integer):String;
 function  WordCountDelims(Data,Delims:String):Integer;
 function  ExtractWordDelims(Num:Integer;Data,Delims:String):String;
 function  SkipWordsDelims(n:Integer;s,Delims:String):String;
 function  Win2Koi(s:String):String;
 function  Koi2Win(s:String):String;
 procedure Cryptographer(var Data,Key:String; Encrypt:Boolean; CryptKind:Integer);
 function  CharReverseStr(s:String):String;
 function  TextVarScan(var Buff:String; Name:String):String;
 function  TextLineCount(s,delim:String):Integer;
 function  ExtractTextLine(num:Integer; s,delim:String):String;
 function  ColorToString(Color:Integer):String;
 function  StringToColor(Color:String):Integer;
 function  StringToColorDef(Color:String; def:Integer):Integer;
 function  GuiLanguageSign:String;
 function  GuiLanguageCode:Integer;
 function  glc_English:Integer;
 function  glc_Russian:Integer;
 function  RusEngStr(rus,eng:String):String;
 function  IfThenStr(Cond:Boolean; S1,S2:String):String;
 function  CookieScanAlter(Buff,Items:String; Mode:Integer):String;
 procedure ClearStdStrings;
 procedure InitStdStrings;
 procedure FreeStdStrings;
 procedure PollStdStrings;
 }
 {
 Check if string is empty, i.e. zero length or space only.
 }
 function IsEmptyStr(s:String):Boolean;
 begin
  IsEmptyStr:=(Length(Trim(s))=0);
 end;
 {
 Check if string is non-empty, i.e. contains non-space chars.
 }
 function IsNonEmptyStr(s:String):Boolean;
 begin
  IsNonEmptyStr:=(Length(Trim(s))>0);
 end;
 {
 Return tail of string S after Pos.
 }
 function TailStr(S:String; Pos:Integer):String;
 begin
  TailStr:=Copy(S,Pos,length(S)-Pos+1);
 end;
 {
 Return Count trailing chars of string S.
 }
 function RightStr(S:String; Count:Integer):String;
 begin
  if Count<0 then Count:=0;
  if Count>Length(S) then Count:=Length(S);
  RightStr:=Copy(S,Length(S)+1-Count,Count);
 end;
 {
 Return Count leading chars of string S.
 }
 function LeftStr(S:String; Count:Integer):String;
 begin
  if Count<0 then Count:=0;
  LeftStr:=Copy(S,1,Count);
 end;
 {
 Return string S part ahead of delimeter Delim or empty string.
 }
 function StrAheadOf(S:String; Delim:Char):String;
 begin
  StrAheadOf:=Copy(S,1,Pos(Delim,S)-1);
 end;
 {
 Return string S part after of Delim or original string.
 }
 function StrAfterOf(S:String; Delim:Char):String;
 begin
  StrAfterOf:=Copy(S,Pos(Delim,S)+1,Length(S));
 end;
 {
 Return True if AText contains ASubText, case sensitive.
 }
 function ContainsStr(AText,ASubText:String):Boolean;
 begin
  ContainsStr:=(Pos(ASubText,AText)>0);
 end;
 {
 Return True if AText starts with ASubText, case sensitive.
 }
 function StartsStr(ASubText,AText:String):Boolean;
 begin
  if (ASubText='') then StartsStr:=True else
  StartsStr:=(LeftStr(AText,Length(ASubText))=ASubText);
 end;
 {
 Return True if AText ends with ASubText, case sensitive.
 }
 function EndsStr(ASubText,AText:String):Boolean;
 begin
  if (ASubText='') then EndsStr:=True else
  EndsStr:=(RightStr(AText,Length(ASubText))=ASubText);
 end;
 {
 Return True if AText contains ASubText, ignore case.
 }
 function ContainsText(AText,ASubText:String):Boolean;
 begin
  ContainsText:=(Pos(UpCaseStr(ASubText),UpCaseStr(AText))>0);
 end;
 {
 Return True if AText starts with ASubText, ignore case.
 }
 function StartsText(aSubText,aText:String):Boolean;
 begin
  if (aSubText='') then StartsText:=True else
  StartsText:=IsSameText(LeftStr(aText,Length(aSubText)),aSubText);
 end;
 {
 Return True if AText ends with ASubText, ignore case.
 }
 function EndsText(aSubText,aText:String):Boolean;
 begin
  if (aSubText='') then EndsText:=True else
  EndsText:=IsSameText(RightStr(aText,Length(aSubText)),aSubText);
 end;
 {
 Return trimed string (s) or default (def).
 }
 function TrimDef(s,def:String):String;
 begin
  s:=Trim(s);
  if (s='') then s:=Trim(def);
  TrimDef:=s;
 end;
 {
 Return last position of substring (sub) in string (str) or 0.
 }
 function LastPos(Sub,Str:String):Integer;
 var i,p:Integer;
 begin
  p:=0;
  i:=0;
  repeat
   i:=PosEx(Sub,Str,i+1);
   if (i>0) then p:=i;
  until (i<=0);
  LastPos:=p;
 end;
 {
 Return counter of substrings (sub) in string (str) or 0.
 }
 function CountPos(Sub,Str:String):Integer;
 var i,n:Integer;
 begin
  n:=0;
  i:=0;
  repeat
   i:=PosEx(Sub,Str,i+1);
   if (i>0) then n:=n+1;
  until (i<=0);
  CountPos:=n;
 end;
 {
 Return N-th position of substrings (sub) in string (str) or 0.
 }
 function NthPos(Sub,Str:String; n:Integer):Integer;
 var i,p:Integer;
 begin
  p:=0;
  i:=0;
  if (n>0) then
  repeat
   i:=PosEx(Sub,Str,i+1);
   if (i>0) then begin
    if (n=1) then p:=i;
    if (p>0) then i:=0;
    n:=n-1;
   end;
  until (i<=0);
  NthPos:=p;
 end;
 {
 Check if S looks like section name as [Section].
 }
 function IsSectionName(S:String):Boolean;
 begin
  IsSectionName:=IsLexeme(S,lex_Section);
 end;
 {
 Check if S looks like environment variable link as %Variable%.
 }
 function IsEnvVarLink(S:String):Boolean;
 var L:Integer; flag:Boolean;
 begin
  L:=Length(S);
  if (L<2) then flag:=false else
  if (StrFetch(S,1)<>'%') then flag:=false else
  if (StrFetch(S,L)<>'%') then flag:=false else flag:=true;
  IsEnvVarLink:=flag;
 end;
 {
 Return string with Leng chars Ch. For example CharStr(4,'*')='****'.
 }
 function CharStr(Leng:Integer; Ch:Char):String;
 begin
  CharStr:=StringOfChar(Ch,Leng);
 end;
 {
 Creates and concatenates N copies of a string S.
 }
 function DupeString(s:String; n:Integer):String;
 var t:String; i,m:Integer;
 begin
  t:='';
  if (n>0) then
  if (s<>'') then
  if (n<6) then begin
   // Catenate for small n
   for i:=1 to n do t:=t+s;
  end else begin
   m:=(n div 2); // Recursion for big n
   t:=DupeString(s,n-m)+DupeString(s,m);
  end;
  DupeString:=t;
  t:='';
 end;
 {
 Return left-padded string S with Ch and Leng width.
 }
 function LeftPad(S:String; Leng:Integer; Ch:Char):String;
 begin
  Leng:=Leng-Length(S);
  if Leng>0 then LeftPad:=StringOfChar(Ch,Leng)+S else LeftPad:=S;
 end;
 {
 Return right-padded string S with Ch and Leng width.
 }
 function RightPad(S:String; Leng:Integer; Ch:Char):String;
 begin
  Leng:=Leng-Length(S);
  if Leng>0 then RightPad:=S+StringOfChar(Ch,Leng) else RightPad:=S;
 end;
 {
 Return center-padded string S with Ch and Leng width.
 }
 function CenterPad(S:String; Leng:Integer; Ch:Char):String;
 var L,R:Integer;
 begin
  Leng:=Leng-Length(S);
  L:=Leng div 2; R:=Leng-L;
  if L+R>0 then CenterPad:=StringOfChar(Ch,L)+S+StringOfChar(Ch,R) else CenterPad:=S;
 end;
 {
 Return data string as integer or default.
 }
 function iValDef(Data:String; aDefault:Integer):Integer;
 var r:Real;
 begin
  Data:=Trim(Data);
  if Length(Data)=0 then r:=_NaN else r:=rVal(Data);
  if IsNan(r) or IsInf(r) or (r>MaxInt) or (r<MinInt)
  then iValDef:=aDefault else iValDef:=Round(r);
 end;
 {
 Return data string as real or default.
 }
 function rValDef(Data:String; aDefault:Real):Real;
 var r:Real;
 begin
  Data:=Trim(Data);
  if Length(Data)=0 then r:=_NaN else r:=rVal(Data);
  if IsNan(r) or IsInf(r) then rValDef:=aDefault else rValDef:=r;
 end;
 {
 Evaluate data string as integer or return default.
 }
 function iEvalDef(Data:String; aDefault:Integer):Integer;
 var r:Real;
 begin
  Data:=Trim(Data);
  if Length(Data)=0 then r:=_NaN else r:=Eval(Data);
  if IsNan(r) or IsInf(r) or (r>MaxInt) or (r<MinInt)
  then iEvalDef:=aDefault else iEvalDef:=Round(r);
 end;
 {
 Evaluate data string as real or return default.
 }
 function rEvalDef(Data:String; aDefault:Real):Real;
 var r:Real;
 begin
  Data:=Trim(Data);
  if Length(Data)=0 then r:=_NaN else r:=Eval(Data);
  if IsNan(r) or IsInf(r) then rEvalDef:=aDefault else rEvalDef:=r;
 end;
 {
 Find index of word s in list of string items.
 For example, WordIndex('3','1 2 3 4 5')=3.
 }
 function WordIndex(s,list:String):Integer;
 var i,j,n:Integer;
 begin
  i:=1;
  j:=0;
  n:=WordCount(list);
  while i<=n do begin
   if IsSameText(s,ExtractWord(i,list)) then begin
    j:=i;
    i:=n;
   end;
   i:=i+1;
  end;
  WordIndex:=j;
 end;
 {
 Replace all "a" to "b" in string "s".
 Flag = 1 - Replace All, 2 - Not Case sensitive
 }
 function StrReplace(s,a,b:String; Flags:Integer):String;
 var p:Integer;
 begin
  if iAnd(Flags,2)=0
  then p:=Pos(a,s)
  else p:=Pos(UpCaseStr(a),UpCaseStr(s));
  if p=0 then StrReplace:=s else begin
   if iAnd(Flags,1)=0
   then StrReplace:=Copy(s,1,p-1)+b+Copy(s,p+Length(a))
   else StrReplace:=Copy(s,1,p-1)+b+StrReplace(Copy(s,p+Length(a)),a,b,Flags);
  end;
 end;
 {
 Add quotes to string: Y -> 'Y'
 }
 function StrAddQuotes(s:String; Quote:Char):String;
 var I,L,N:Integer;
 begin
  I:=1; L:=Length(s); N:=L;
  if (L>0) then begin
   if (Copy(s,1,1)=Quote) then begin I:=I+1; N:=N-1; end;
   if (Copy(s,L,1)=Quote) then begin N:=N-1; end;
  end;
  if (N=L)
  then StrAddQuotes:=Quote+s+Quote
  else StrAddQuotes:=Quote+Copy(s,I,N)+Quote;
 end;
 {
 Remove quotes from string: 'Y' -> Y
 }
 function StrRemoveQuotes(s:String; Quote:Char):String;
 var I,L,N:Integer;
 begin
  I:=1; L:=Length(s); N:=L;
  if (L>0) then begin
   if (Copy(s,1,1)=Quote) then begin I:=I+1; N:=N-1; end;
   if (Copy(s,L,1)=Quote) then begin N:=N-1; end;
  end;
  if (N=L)
  then StrRemoveQuotes:=s
  else StrRemoveQuotes:=Copy(s,I,N);
 end;
 {
 Add brackets to string: Y -> [Y]
 }
 function StrAddBrackets(s:String; LBracket,RBracket:Char):String;
 var I,L,N:Integer;
 begin
  I:=1; L:=Length(s); N:=L;
  if (L>0) then begin
   if (Copy(s,1,1)=LBracket) then begin I:=I+1; N:=N-1; end;
   if (Copy(s,L,1)=RBracket) then begin N:=N-1; end;
  end;
  if (N=L)
  then StrAddBrackets:=LBracket+s+RBracket
  else StrAddBrackets:=LBracket+Copy(s,I,N)+RBracket;
 end;
 {
 Remove brackets from string: [Y] -> Y
 }
 function StrRemoveBrackets(s:String; LBracket,RBracket:Char):String;
 var I,L,N:Integer;
 begin
  I:=1; L:=Length(s); N:=L;
  if (L>0) then begin
   if (Copy(s,1,1)=LBracket) then begin I:=I+1; N:=N-1; end;
   if (Copy(s,L,1)=RBracket) then begin N:=N-1; end;
  end;
  if (N=L)
  then StrRemoveBrackets:=s
  else StrRemoveBrackets:=Copy(s,I,N);
 end;
 {
 Extract (Name,Value) pair from expression (arg) "Name<sign>Value".
 Mode bits (0,1) or flags (1,2) uses to Trim (Name,Value).
 Return position of Sign in string (arg).
 }
 function ExtractNameValuePair(arg:String; var Name,Value:String; Sign:Char; Mode:Integer):Integer;
 var p:Integer;
 begin
  p:=Pos(Sign,arg);
  if (p>0) then begin
   Name:=Copy(arg,1,p-1);
   Value:=Copy(arg,p+1,Length(arg)-p);
  end else begin
   Name:=arg;
   Value:='';
  end;
  if HasFlags(Mode,1) and (Name<>'') then Name:=Trim(Name);
  if HasFlags(Mode,2) and (Value<>'') then Value:=Trim(Value);
  ExtractNameValuePair:=p;
 end;
 {
 Read a string from ini file
 }
 function ReadIniVar(VarName:String;Mode:Integer):String;
 var i,p,t,q:Integer; s,sn,sv:String;
 begin
  s:=''; sn:=''; sv:='';
  VarName:=Trim(VarName); q:=0;
  if Length(VarName)>0 then begin
   t:=ReadIniSection(text_New,Mode,'','');
   for i:=0 to text_Numln(t)-1 do if (q=0) then begin
    p:=ExtractNameValuePair(text_Getln(t,i),sn,sv,'=',3);
    if (p>0) then if IsSameText(sn,VarName) then begin s:=sv; q:=1; end;
   end;
   bNul(text_Free(t));
  end;
  ReadIniVar:=s;
  s:=''; sn:=''; sv:='';
 end;
 {
 Read a string from ini file
 }
 function ReadIniStr(Mode:Integer; FName,SecName,VarName:String):String;
 var i,p,t,q:Integer; s,sn,sv:String;
 begin
  s:=''; sn:=''; sv:='';
  FName:=Trim(FName); q:=0;
  SecName:=Trim(SecName);
  VarName:=Trim(VarName);
  if Length(FName)>0 then
  if Length(SecName)>0 then
  if Length(VarName)>0 then begin
   FName:=DaqFileRef(FName,'*.cfg');
   if FileExists(FName) then begin
    t:=ReadIniSection(text_New,Mode,FName,SecName);
    for i:=0 to text_Numln(t)-1 do if (q=0) then begin
     p:=ExtractNameValuePair(text_Getln(t,i),sn,sv,'=',3);
     if (p>0) then if IsSameText(sn,VarName) then begin s:=sv; q:=1; end;
    end;
    bNul(text_Free(t));
   end;
  end;
  ReadIniStr:=s;
  s:=''; sn:=''; sv:='';
 end;
 //
 // ReadIniAlter('[demo] test',risModeDefault+risModeAlter);
 // [demo]
 // test = [alterSection] alterName %alterVar% FallbackValue
 //
 function ReadIniAlter(arg:String;Mode:Integer):String;
 var i,wc:Integer; s,sf,ss,sn,si,sr:String;
 begin
  s:=''; sf:=''; ss:=''; sn:=''; si:=''; sr:='';
  wc:=WordCount(arg);
  if (wc=1) then begin sf:=ParamStr('DaqConfigFile'); ss:='['+DevName+']';    sn:=ExtractWord(1,arg); end else
  if (wc=2) then begin sf:=ParamStr('DaqConfigFile'); ss:=ExtractWord(1,arg); sn:=ExtractWord(2,arg); end else
  if (wc=3) then begin sf:=ExtractWord(1,arg);        ss:=ExtractWord(2,arg); sn:=ExtractWord(3,arg); end;
  if (sn<>'') then s:=ReadIniStr(Mode,sf,ss,sn);
  i:=1; wc:=WordCount(s);
  while (i<=wc) and (sr='') do begin
   si:=ExtractWord(i,s);
   if HasFlags(Mode,risAlterSecRef) and IsSectionName(si) then begin
    if (i<wc) then sr:=ReadIniStr(Mode,sf,si,ExtractWord(i+1,s));
    i:=i+1;
   end else
   if HasFlags(Mode,risAlterEnvRef) and IsEnvVarLink(si) then begin
    sr:=ExpEnv(si); if (sr=si) then sr:='';
   end else begin
    if (i=1) then sr:=s else sr:=SkipWords(i-1,s);
   end;
   i:=i+1;
  end;
  ReadIniAlter:=sr;
  s:=''; sf:=''; ss:=''; sn:=''; si:=''; sr:='';
 end;
 {
 Return number of words of Data with delimeters in Delims.
 }
 function WordCountDelims(Data,Delims:String):Integer;
 begin
  Delims:=WordDelims(Delims);
  WordCountDelims:=WordCount(Data);
  Delims:=WordDelims(Delims);
 end;
 {
 Extract word number Num of Data with delimeters in Delims.
 }
 function ExtractWordDelims(Num:Integer;Data,Delims:String):String;
 begin
  Delims:=WordDelims(Delims);
  Data:=ExtractWord(Num,Data);
  Delims:=WordDelims(Delims);
  ExtractWordDelims:=Data;
 end;
 {
 Skip n words of string s, return trailing part of string s after n'th word with delimeters in Delims.
 }
 function SkipWordsDelims(n:Integer;s,Delims:String):String;
 begin
  Delims:=WordDelims(Delims);
  s:=SkipWords(n,s);
  Delims:=WordDelims(Delims);
  SkipWordsDelims:=s;
 end;
 {
 Convert russian string from cp1251 to koi8r...
 }
 function Win2Koi(s:String):String;
 begin
  Win2Koi:=StrConv('win2koi',s);
 end;
 {
 Convert russian string from koi8r to cp1251...
 }
 function Koi2Win(s:String):String;
 begin
  Koi2Win:=StrConv('koi2win',s);
 end;
 {
 Encrypt/decrypt (True/False) Data string, by use Key and CryptKind method.
 0=CURRENT,1=Blowfish,2=Gost,3=RC2,4=RC4,5=RC5,6=RC6,7=BASE64,8=HEX,9=NONE.
 }
 procedure Cryptographer(var Data,Key:String; Encrypt:Boolean; CryptKind:Integer);
 var Kind,Temp:String;
 begin
  Kind:=''; Temp:='';
  if (CryptKind>=0) then
  if (CryptKind<7) then begin
   if (CryptKind>0) then begin
    Kind:=Crypt_Ctrl('Kind');
    Temp:=Crypt_Ctrl('Kind='+ExtractWord(CryptKind,'Blowfish,Gost,RC2,RC4,RC5,RC6'));
   end;
   if Encrypt
   then Data:=Crypt_Encode(Data,Key)
   else Data:=Crypt_Decode(Data,Key);
   if (CryptKind>0) then Temp:=Crypt_Ctrl('Kind='+Kind);
  end else
  if (CryptKind=7) then begin
   if Encrypt
   then Data:=Mime_Encode(Data)
   else Data:=Mime_Decode(Data);
  end else
  if (CryptKind=8) then begin
   if Encrypt
   then Data:=Hex_Encode(Data)
   else Data:=Hex_Decode(Data);
  end;
  Kind:=''; Temp:='';
 end;
 {
 Reverse chars order in string, like adcdef -> fedcba.
 }
 function CharReverseStr(s:String):String;
 var len,mid:Integer;
 begin
  len:=Length(s);
  if len>4 then begin
   mid:=len div 2;
   CharReverseStr:=CharReverseStr(Copy(s,mid+1,len-mid))+CharReverseStr(Copy(s,1,mid));
  end else
  case len of
   0: CharReverseStr:=s;
   1: CharReverseStr:=s;
   2: CharReverseStr:=Copy(s,2,1)+Copy(s,1,1);
   3: CharReverseStr:=Copy(s,3,1)+Copy(s,2,1)+Copy(s,1,1);
   4: CharReverseStr:=Copy(s,4,1)+Copy(s,3,1)+Copy(s,2,1)+Copy(s,1,1);
  end;
 end;
 {
 Scan EOL-delimited text buffer Buff for variable Name=Value and return Value.
 }
 function TextVarScan(var Buff:String; Name:String):String;
 begin
  Name:=Trim(Name);
  TextVarScan:=CookieScan(Buff,Name,0);
 end;
 {
 Return line count in text (s) with line delimiter (delim).
 Usually delim is EOL.
 }
 function TextLineCount(s,delim:String):Integer;
 var i,p,ls,ld,n:Integer;
 begin
  n:=0; ls:=Length(s); ld:=Length(delim);
  if (ls>0) and (ld>0) then begin
   i:=0; p:=1;
   repeat
    i:=PosEx(delim,s,i+1);
    if (i>0) then begin
     n:=n+1;
     p:=i+ld;
    end else begin
     if (p<=ls) then n:=n+1;
    end;
   until (i<=0);
  end;
  TextLineCount:=n;
 end;
 {
 Extract line number (num) from text (s) with line delimiter (delim).
 Usually delim is EOL. Line number (num) going from 0.
 }
 function ExtractTextLine(num:Integer; s,delim:String):String;
 var i,p,ls,ld,n:Integer; r:String;
 begin
  r:='';
  n:=0; ls:=Length(s); ld:=Length(delim);
  if (ls>0) and (ld>0) and (num>=0) then begin
   i:=0; p:=1;
   repeat
    i:=PosEx(delim,s,i+1);
    if (i>0) then begin
     if (n=num) then r:=Copy(s,p,i-p);
     n:=n+1;
     p:=i+ld;
    end else begin
     if (p<=ls) then begin
      if (n=num) then r:=Copy(s,p,ls-p+1);
      n:=n+1;
     end;
    end;
   until (i<=0) or (n>num);
  end;
  ExtractTextLine:=r;
  r:='';
 end;
 {
 Convert Color code to String (color name or hex code).
 }
 function ColorToString(Color:Integer):String;
 begin
  ColorToString:=ParamStr('ColorName '+Str(Color));
 end;
 {
 Convert Color name string to 
 }
 function StringToColor(Color:String):Integer;
 var code:Integer;
 begin
  Color:='$'+ParamStr('ColorCode '+Color);
  code:=iValDef(Color,clNone);
  StringToColor:=code;
 end;
 function StringToColorDef(Color:String; def:Integer):Integer;
 var code:Integer;
 begin
  Color:='$'+ParamStr('ColorCode '+Color);
  code:=iValDef(Color,clNone);
  if (code=clNone) then
  if (def<>clNone) then code:=def;
  StringToColorDef:=code;
 end;
 {
 Get GUI Language Sign/Code like 'rus' or 'eng'.
 }
 function GuiLanguageSign:String;
 begin
  GuiLanguageSign:=Trim(Dump(_GuiLanguageCode_));
 end;
 function GuiLanguageCode:Integer;
 begin
  GuiLanguageCode:=_GuiLanguageCode_;
 end;
 function glc_English:Integer;
 begin
  glc_English:=_glc_English_;
 end;
 function glc_Russian:Integer;
 begin
  glc_Russian:=_glc_Russian_;
 end;
 {
 Return Russian or English string depending on GuiLanguageCode.
 }
 function RusEngStr(rus,eng:String):String;
 begin
  if (GuiLanguageCode=glc_Russian) then if (rus<>'') then eng:=rus;
  if (eng='') and (rus<>'') then eng:=rus;
  RusEngStr:=eng;
 end;
 {
 Return S1 or S2 depending on condition Cond.
 }
 function  IfThenStr(Cond:Boolean; S1,S2:String):String;
 begin
  if Cond
  then IfThenStr:=S1
  else IfThenStr:=S2;
 end;
 {
 CookieScan with comma or semicolon separated name alternatives.
 }
 function CookieScanAlter(Buff,Items:String; Mode:Integer):String;
 var i,wc:Integer; Item,Delims,s:String;
 begin
  s:=''; Item:=''; Delims:='';
  if (Buff<>'') and (Items<>'') then begin
   i:=1; Delims:=CRLF+',;';
   wc:=WordCountDelims(Items,Delims);
   while (i<=wc) do begin
    Item:=Trim(ExtractWordDelims(i,Items,Delims));
    if (Item<>'') then s:=CookieScan(Buff,Item,Mode);
    if (s='') then i:=i+1 else i:=wc+1;
   end;
  end;
  CookieScanAlter:=s;
  s:=''; Item:=''; Delims:='';
 end;
 {
 Clear standard Strings.
 }
 procedure ClearStdStrings;
 begin
  ProgramSourcePas:='';
  ProgramSourceDir:='';
 end;
 {
 Initialize standard Strings.
 }
 procedure InitStdStrings;
 begin
  ProgramSourcePas:=DaqFileRef(AdaptFileName(ReadIni('ProgramSource')),'.pas');
  ProgramSourceDir:=ExtractFilePath(ProgramSourcePas);
  WHEEL_DELTA:=120;
  _GuiLanguageCode_:=Dump2i(LoCaseStr(Copy(GetEnv('CRW_DAQ_SYS_LANG'),1,3)));
  _glc_English_:=Dump2i('eng');
  _glc_Russian_:=Dump2i('rus');
  ShouldPollStdStrings:=false;
 end;
 {
 Finalize standard Strings.
 }
 procedure FreeStdStrings;
 begin
 end;
 {
 Poll standard Strings.
 }
 procedure PollStdStrings;
 begin
 end;
