 {
 Required _typ_StdLibrary.inc
 procedure TStatSum2D_Reset(var R:TStatSum2D);
 procedure TStatSum2D_Init(var R:TStatSum2D);
 procedure TStatSum2D_Add(var R:TStatSum2D; x,y:Real);
 procedure TStatSum2D_Calculate(var R:TStatSum2D; Mode:Integer);
 }
 {
 Reset Statistics Sum record to be ready for new data sampling.
 }
 procedure TStatSum2D_Reset(var R:TStatSum2D);
 begin
  R.Num:=0;
  R.Sum.X:=0.0;     R.Mean.X:=0.0;
  R.Sum.Y:=0.0;     R.Mean.Y:=0.0;
  R.Sum.XX:=0.0;    R.Mean.XX:=0.0;
  R.Sum.XY:=0.0;    R.Mean.XY:=0.0;
  R.Sum.YY:=0.0;    R.Mean.YY:=0.0;
  R.Disp.X:=0.0;    R.Sigma.X:=0.0;
  R.Disp.Y:=0.0;    R.Sigma.Y:=0.0;
  R.Line.C0:=0.0;   R.Line.C1:=0.0;
  R.Line.Disp:=0.0; R.Line.Sigma:=0.0;
  R.Line.Corr:=0.0; R.CovXY:=0.0;
 end;
 {
 Initialize Statistics Sum record.
 }
 procedure TStatSum2D_Init(var R:TStatSum2D);
 begin
  R.TimeStamp:=0.0;
  TStatSum2D_Reset(R);
 end;
 {
 Add (X,Y) point to Statistics Sums.
 }
 procedure TStatSum2D_Add(var R:TStatSum2D; X,Y:Real);
 begin
  if not IsNan(X) and not IsNan(Y) then
  if not IsInf(X) and not IsInf(Y) then begin
   R.Num:=R.Num+1;
   R.Sum.X:=R.Sum.X+X;
   R.Sum.Y:=R.Sum.Y+Y;
   R.Sum.XX:=R.Sum.XX+X*X;
   R.Sum.XY:=R.Sum.XY+X*Y;
   R.Sum.YY:=R.Sum.YY+Y*Y;
  end;
 end;
 {
 Calculate Statistics coefficients by Statistics Sums.
 Mode 0 - Calculate Mean (X,Y) only.
 Mode 1 - Calculate also Disp, Sigma (X,Y).
 Mode 2 - Calculate also covariance CovXY.
 Mode 3 - Calculate also Linear regression.
 }
 procedure TStatSum2D_Calculate(var R:TStatSum2D; Mode:Integer);
 begin
  if (R.Num>0) then begin
   R.Mean.X:=R.Sum.X/R.Num;
   R.Mean.Y:=R.Sum.Y/R.Num;
   if (Mode>=1) then begin
    R.Mean.XX:=R.Sum.XX/R.Num;
    R.Mean.YY:=R.Sum.YY/R.Num;
    R.Disp.X:=R.Mean.XX-Sqr(R.Mean.X);
    R.Disp.Y:=R.Mean.YY-Sqr(R.Mean.Y);
    R.Sigma.X:=Sqrt(R.Disp.X);
    R.Sigma.Y:=Sqrt(R.Disp.Y);
   end;
   if (Mode>=2) then begin
    R.Mean.XY:=R.Sum.XY/R.Num;
    R.CovXY:=R.Mean.XY-R.Mean.X*R.Mean.Y;
   end;
   if (Mode>=3) then begin
    R.Line.C1:=R.CovXY/R.Disp.X;
    R.Line.C0:=R.Mean.Y-R.Line.C1*R.Mean.X;
    R.Line.Disp:=R.Mean.YY-(R.Line.C1*R.Mean.XY+R.Line.C0*R.Mean.Y);
    R.Line.Sigma:=Sqrt(R.Line.Disp);
    R.Line.Corr:=R.CovXY/(R.Sigma.X*R.Sigma.Y);
   end;
  end;
 end;
