 {
 Standard routines for Curves:
 procedure UpdateAo(n:Integer; t,y:Real);
 procedure UpdateDo(n:Integer; t,y:Real);
 function  crvGetLastY(ref:Integer):Real;
 function  GetCrvRange(Crv:Integer; var x1,y1,x2,y2:Real):Integer;
 procedure ClearCurveData(Crv:Integer);
 function  FindNaiByName(name:String):Integer;
 function  FindNdiByName(name:String):Integer;
 function  FindNaoByName(name:String):Integer;
 function  FindNdoByName(name:String):Integer;
 procedure ClearStdCurves;
 procedure InitStdCurves;
 procedure FreeStdCurves;
 procedure PollStdCurves;
 }
 {
 Update Analog Output n: put (t,y) event.
 }
 procedure UpdateAo(n:Integer; t,y:Real);
 begin
  if RefAo(n)<>0 then bNul(PutAo(n,t,y));
 end;
 {
 Update Digital Output n: put (t,y) event.
 }
 procedure UpdateDo(n:Integer; t,y:Real);
 begin
  if RefDo(n)<>0 then bNul(PutDo(n,t,y));
 end;
 {
 Thread safe function to get last point Y of curve.
 }
 function crvGetLastY(ref:Integer):Real;
 begin
  bNul(CrvLock(ref));
  crvGetLastY:=crvY(ref,crvLen(ref));
  bNul(CrvUnlock(ref));
 end;
 {
 Get range contains curve points.
 }
 function GetCrvRange(Crv:Integer; var x1,y1,x2,y2:Real):Integer;
 var i,n:Integer; xi,yi:Real;
 begin
  n:=0;
  x1:=_PlusInf;  y1:=_PlusInf;
  x2:=_MinusInf; y2:=_MinusInf;
  if CrvLock(Crv) then begin
   n:=Round(CrvLen(Crv));
   for i:=1 to n do begin
    xi:=CrvX(Crv,i); yi:=CrvY(Crv,i);
    if xi<x1 then x1:=xi; if yi<y1 then y1:=yi;
    if xi>x2 then x2:=xi; if yi>y2 then y2:=yi;
   end;
   bNul(CrvUnlock(Crv));
  end;
  GetCrvRange:=n;
 end;
 {
 Clear curve data points
 }
 procedure ClearCurveData(Crv:Integer);
 begin
  if IsSameText(RefInfo(Crv,'Type'),'Curve') then begin
   bNul(CrvLock(Crv));
   bNul(CrvDel(Crv,1,CrvLen(Crv))>0);
   bNul(CrvUnlock(Crv));
  end;
 end;
 {
 Initialize AI,DI,AO,DO hashlist.
 }
 procedure _nai_ndi_nao_ndo_hasher_init_;
 var i:Integer;
 begin
  if (_nai_ndi_nao_ndo_hasher_=0) then begin
   _nai_ndi_nao_ndo_hasher_:=HashList_Init(0);
   for i:=0 to NumAis-1 do if (RefAi(i)<>0) then bNul(HashList_SetLink(_nai_ndi_nao_ndo_hasher_,'nai->'+CrvName(RefAi(i)),i+1));
   for i:=0 to NumDis-1 do if (RefDi(i)<>0) then bNul(HashList_SetLink(_nai_ndi_nao_ndo_hasher_,'ndi->'+CrvName(RefDi(i)),i+1));
   for i:=0 to NumAos-1 do if (RefAo(i)<>0) then bNul(HashList_SetLink(_nai_ndi_nao_ndo_hasher_,'nao->'+CrvName(RefAo(i)),i+1));
   for i:=0 to NumDos-1 do if (RefDo(i)<>0) then bNul(HashList_SetLink(_nai_ndi_nao_ndo_hasher_,'ndo->'+CrvName(RefDo(i)),i+1));
  end;
 end;
 {
 Find AI/DI/AO/DO number by curve name.
 }
 function FindNaiByName(name:String):Integer;
 begin
  if (_nai_ndi_nao_ndo_hasher_=0) then _nai_ndi_nao_ndo_hasher_init_;
  FindNaiByName:=HashList_GetLink(_nai_ndi_nao_ndo_hasher_,'nai->'+name)-1;
 end;
 function FindNdiByName(name:String):Integer;
 begin
  if (_nai_ndi_nao_ndo_hasher_=0) then _nai_ndi_nao_ndo_hasher_init_;
  FindNdiByName:=HashList_GetLink(_nai_ndi_nao_ndo_hasher_,'ndi->'+name)-1;
 end;
 function FindNaoByName(name:String):Integer;
 begin
  if (_nai_ndi_nao_ndo_hasher_=0) then _nai_ndi_nao_ndo_hasher_init_;
  FindNaoByName:=HashList_GetLink(_nai_ndi_nao_ndo_hasher_,'nao->'+name)-1;
 end;
 function FindNdoByName(name:String):Integer;
 begin
  if (_nai_ndi_nao_ndo_hasher_=0) then _nai_ndi_nao_ndo_hasher_init_;
  FindNdoByName:=HashList_GetLink(_nai_ndi_nao_ndo_hasher_,'ndo->'+name)-1;
 end;
 {
 Clear standard Curves.
 }
 procedure ClearStdCurves;
 begin
 end;
 {
 Initialize standard Curves.
 }
 procedure InitStdCurves;
 begin
  ShouldPollStdCurves:=false;
  _nai_ndi_nao_ndo_hasher_:=0;
 end;
 {
 Finalize standard Curves.
 }
 procedure FreeStdCurves;
 begin
  if (_nai_ndi_nao_ndo_hasher_<>0) then begin
   bNul(HashList_Free(_nai_ndi_nao_ndo_hasher_));
   _nai_ndi_nao_ndo_hasher_:=0;
  end;
 end;
 {
 Poll standard Curves.
 }
 procedure PollStdCurves;
 begin
 end;
