 {
 Программа-передатчик для организации связи по через RS232.
 Передает данные со входов AnalogInput(...) в виде потока событий <канал,данные>.
 Принимает данные на выходы AnalogOutput(...) в таком же виде.
 Пример конфигурации:
 [DataStorage]
 src1  = Curve      0 1024       Black    15    1
 dst1  = Curve      0 1024       White    15    1
 [TagList]
 TxEnable   = integer 0 ; разрешение передатчика
 RxEnable   = integer 0 ; разрешение приемника
 TxErrors   = real    0 ; счетчик ошибок передатчика
 RxErrors   = real    0 ; счетчик ошибок приемника
 [DeviceList]
 &RSPIPE  = device software program
 [&RSPIPE]
 Comment = Программа связи по RS
 InquiryPeriod = 50
 AnalogFifo = 8192
 AnalogInputs = 1
 AnalogOutputs = 1
 Link AnalogInput  0 with curve  src1
 Link AnalogOutput  0 with curve  dst1 history 5000
 ProgramSource = ..\daqpas\_rspipe
 ComPort = 1            ; номер порта
 TagTxEnable = TxEnable ; имя integer тега разрешения передачи
 TagRxEnable = RxEnable ; имя integer тега разрешения приема
 TagTxErrors = TxErrors ; имя real    тега счетчика ошибок передачи
 TagRxErrors = RxErrors ; имя real    тега счетчика ошибок приема
 }
program _rspipe;
const
 maxai       = 255;
 maxline     = 256;
 test        = false;
var
 b           : boolean;
 Ok          : boolean;
 quit        : boolean;
 errors      : integer;
 tagTxEnable : integer;
 tagRxEnable : integer;
 tagTxErrors : integer;
 tagRxErrors : integer;
 i           : integer;
 n           : integer;
 p           : integer;
 p1          : integer;
 ci          : real;
 xi          : real;
 yi          : real;
 lastxi      : array[0..maxai] of real;
 CR          : string;
 s           : string;
 s1          : string;
 v1          : string;
 v2          : string;
 {
 Фиксация ошибки Tx, инкрементирует счетчик ошибок
 }
 procedure TxError(n:integer);
 var b:boolean;
 begin
  b:=rsettag(tagTxErrors,rgettag(tagTxErrors)+1);
 end;
 {
 Фиксация ошибки Rx, инкрементирует счетчик ошибок
 }
 procedure RxError(n:integer);
 var b:boolean;
 begin
  b:=rsettag(tagRxErrors,rgettag(tagRxErrors)+1);
 end;
 {
 Процедура инициализации и проверки тега
 }      
 procedure InitTag(var tag:integer; name:string; typ:integer);
 begin
  tag:=findtag(name);
  if (typ>0) and (typetag(tag)<>typ) then errors:=errors+1;
 end;
begin
 {
 Действия при старте программы
 }
 if runcount=1 then begin
  {
  Найти число каналов и инициализировать некоторые переменные
  }
  n:=numais;
  if n>maxai+1 then n:=maxai+1;
  for i:=0 to n-1 do lastxi[i]:=0;
  s:='';
  s1:='';
  v1:='';
  v2:='';
  CR:=chr(13);
  errors:=0;
  {
  Прочитать данные из конфигурации и инициализировать теги
  }
  InitTag(tagTxEnable,readini('TagTxEnable'),1);
  InitTag(tagRxEnable,readini('TagRxEnable'),1);
  InitTag(tagTxErrors,readini('TagTxErrors'),2);
  b:=rsettag(tagTxErrors,0);
  InitTag(tagRxErrors,readini('TagRxErrors'),2);
  b:=rsettag(tagRxErrors,0);
  {
  Попытка открыть COM-Port и анализ ошибок
  }
  if test then i:=rewrite('');
  if not comopen('[SerialPort-COM'+readini('ComPort')+']') then errors:=errors+1;
  if errors<>0 then b:=fixerror(9);
  Ok:=(errors=0);
 end else
 {
 Действия при остановке программы
 }
 if isinf(runcount) then begin
  {
  Закрыть COM-порт и сбросить некоторые переменные
  }
  b:=comclose;
  s:='';
  s1:='';
  v1:='';
  v2:='';
 end else
 {
 Действия в цикле опроса программы
 }
 if Ok then begin
  {
  Если передача разрешена - передаем события.
  Данные передаем только если время изменилось, чтобы не передавать данные
  дважды.
  }
  if igettag(tagTxEnable)>0 then begin
   for i:=0 to n-1 do begin
    xi:=getai_xn(i);
    if xi>lastxi[i] then begin
     lastxi[i]:=xi;
     yi:=getai_yn(i);
     if not comwrite(str(i)+','+str(yi)+chr(13)) then TxError(1);
    end;
   end;
  end;
  {
  Прием данных.
  Если приемник разрешен, читаем буфер приемника (до его исчерпания).
  Читаем порциями не более maxline символов. Находим p=положение CR.
  Выделяем строку s1 до символа CR и удаляем ее вместе с CR из s.
  Находим p1=положение ',' и выделяем из s1 подстроки v1,v2 до и после ','.
  Пытаемся преобразовать v1,v2 в числа. Если удалось, помещаем в очередь
  еще одно событие.
  }
  if igettag(tagRxEnable)>0 then begin
   while comcount>0 do begin
    if comcount<maxline then s:=s+comread(comcount) else s:=s+comread(maxline);
    repeat
     p:=pos(CR,s);
     if p>0 then begin
      if p>1 then s1:=copy(s,1,p-1) else s1:='';
      if p<length(s) then s:=copy(s,p+1,length(s)-p) else s:='';
      p1:=pos(',',s1);
      if p1>0 then begin
       if p1>1 then v1:=copy(s1,1,p1-1) else v1:='';
       if p1<length(s1) then v2:=copy(s1,p1+1,length(s1)-p1) else v2:='';
       ci:=rval(v1);
       xi:=time;
       yi:=rval(v2);
       if isnan(ci) or isnan(yi) then RxError(1) else begin
        b:=putao(round(ci),xi,yi);
        if test then begin writeln(ci:1:0,',',yi); if ioresult<>0 then; end;
       end;
      end;
     end;
    until (p<1) or (length(s)=0);
   end;
  end;
  {
  Отработка нажатий сенсоров
  }
  if clickbutton=1 then begin
   {
   Кнопка разрешения передачи
   }
   if clicktag=tagTxEnable then begin
    b:=voice('нажато');
    b:=isettag(tagTxEnable,ord(igettag(tagTxEnable)=0));
   end;
   {
   Кнопка разрешения приема
   }
   if clicktag=tagRxEnable then begin
    b:=voice('нажато');
    b:=isettag(tagRxEnable,ord(igettag(tagRxEnable)=0));
   end;
   {
   Очистка счетчика ошибок передачи
   }
   if clicktag=tagTxErrors then begin
    b:=voice('нажато');
    b:=rsettag(tagTxErrors,0);
   end;
   {
   Очистка счетчика ошибок приема
   }
   if clicktag=tagRxErrors then begin
    b:=voice('нажато');
    b:=rsettag(tagRxErrors,0);
   end;
  end;
 end;
end.
