 {
 ***********************************************************************
 Daq Pascal application program _CRWSVR.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Save Windows  - Save list of windows to CRW file.
| @Save CurveList - Save list of curves to CRW file.
|********************************************************
[]
 ***************************************************************************
 Универсальная программа для сохранения данных в формате CRW по требованию.
 Для сохранения даных есть два способа: старый и новый, как удобнее
 1)Внешняя программа взводит тег запроса WriteEnableTag, программа _CRWSVR
   по тегу запроса сохраняет данные и затем сбрасывает тег.
   Получается как бы "фотоснимок" интересующих данных.
 2)Внешняя программа шлет сообщения:
      @Save Windows WINDOW1,WINDOW2...
      @Save CurveList CURVE1,CURVE2,...
   При этом список указанных окон Curve_Window или кривых сохраняется в файл.
 ***************************************************************************
 Через теги WinCaptionTag, WinTitleTag, WinLabelTag задается текст
 имени, заголовка и метки окна при сохранении списка кривых.
 Тег WriteErrorsTag считает ошибки.
 Список кривых теперь задается в виде
      CurveList = Curve1,Curve2,...Section1,Section2...
 где CurveN - имя кривой, SectionN - имя секции, содержащей список кривых
 ***************************************************************************
 Каталог сохранения задается переменной DataPath.
 Данные сохраняются в файл типа PPYYYYMMDD.CRW (QMS_20050819.CRW)
 в окне под именем типа YYYY.MM.DD\hh:mm:ss-xxx
 где  PP         - префикс, задается переменной FilePrefix
      YYYY,MM,DD - год, месяц, день
      hh,mm,ss   - часы, минуты, секунды
      xxx        - заголовок окна
 ***************************************************************************
 Пример конфигурации:
      [DeviceList]
      &QMS_CRWSVR = device software program
      [&QMS_CRWSVR]
      Comment        = Program to save data to *.CRW files
      InquiryPeriod  = 1
      DevicePolling  = 50, tpNormal
      ProgramSource  = ..\DaqPas\_CRWSVR
      OpenConsole    = 0
      DebugFlags     = 15
      FilePrefix     = QMS_
      DataPath       = ..\data
      WinCaptionTag  = QMS_CrwCaption
      WinTitleTag    = QMS_CrwTitle
      WinLabelTag    = QMS_CrwLable
      WriteEnableTag = QMS_CRWSVR
      WriteErrorsTag = QMS_IoErrors
      FileNameTag    = QMS_LastSavedCRW
      CurveList      = QMS_CH0, QMS_CH1
      CurveList      = [QMS_Curves]     
 ***************************************************************************
 Пример посылки сообщений:
      r:=devPostMsg('&QMS_CRWSVR @Save Windows QMS_Curves'+EOL);
      r:=devPostMsg('&QMS_CRWSVR @Save CurveList QMS_CH0,QMS_CH1'+EOL);
 ***************************************************************************
 }
program _CRWSVR;
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 maxndat           = 32;         { Max. number of saved items       }

var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 tagSave           : Integer;    { Button to save data              }
 tagSaveErr        : Integer;    { Error counter                    }
 tagWinCaption     : Integer;    { Window caption                   }
 tagWinTitle       : Integer;    { Window title                     }
 tagWinLabel       : Integer;    { Window legend                    }
 tagFileName       : Integer;    { Last saved file name             }
 fPath,fPref       : String;     { File path & prefix               }
 fName,wName       : String;     { File & Window name               }
 cList             : String;     { Curve list                       }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }

 {
 Fix file write error
 }
 procedure SaveErr(msg:string);
 begin
  Trouble(msg);
  bNul(rSetTag(tagSaveErr,rGetTag(tagSaveErr)+1));
 end;
 {
 Get date & time, like 20131018_153045.
 }
 function GetDate_Time(ms:Real):String;
 begin
  GetDate_Time:=StrReplace(StrReplace(StrReplace(
   GetDateTime(ms),Dump('.'),'',3),Dump(':'),'',3),Dump('-'),Dump('_'),3);
 end;
 {
 Get file name by datetime ms.
 }
 function GetFName(ms:Real):String;
 begin
  GetFName:=AddPathDelim(fPath)+fPref+GetDate_Time(ms)+'.crw';
 end;
 {
 Get window name by datetime ms.
 }
 function GetWName(ms:Real):String;
  function GetCaption(s:String):String;
  begin
   if WordCount(s)>0
   then GetCaption:='-'+ExtractWord(1,s)
   else GetCaption:='';
  end;
 begin
  GetWName:=StrReplace(GetDateTime(ms),Dump('-'),Dump('\'),3)
           +GetCaption(sGetTag(tagWinCaption));
 end;
 {
 Save curves in list cList
 }
 procedure SaveCurveList(cList:string);
 var ms:Real;
  procedure DoSave(s:String);
  begin
   if SaveCrw(s) then begin
    bNul(sSetTag(tagFileName,ExtractFileName(fName)+ExtractFileExt(fName)));
    ViewExp(s);
   end else SaveErr('Fail: '+s);
  end;
 begin
  bNul(MkDir(fPath));
  ms:=mSecNow;
  fName:=GetFName(ms);
  wName:=GetWName(ms);
  DoSave(fName+' '+wName+
               ' '+ExtractWord(1,sGetTag(tagWinTitle))+
               ' '+ExtractWord(1,sGetTag(tagWinLabel))+
               ' '+cList);
 end;
 {
 Save windows in list wlist
 }
 procedure SaveWindows(wList:string);
 var i:Integer;
 begin
  bNul(MkDir(fPath));
  fName:=GetFName(mSecNow);
  for i:=1 to WordCount(wList)do begin
   if WinDraw(ExtractWord(i,wList)+'|SaveCrw='+fName) then begin
    bNul(sSetTag(tagFileName,ExtractFileName(fName)+ExtractFileExt(fName)));
    ViewExp(ExtractWord(i,wList));
   end else SaveErr('Fail: '+ExtractWord(i,wList));
  end;
 end;
 {
 Clear all strings.
 }
 procedure CRWSVR_CLEAR;
 begin
  cList:='';
  wName:='';
  fName:='';
  fPath:='';
  fPref:='';
 end;
 {
 Initialization.
 }
 procedure CRWSVR_INIT;
 var i,j,txt:Integer; s:String;
 begin
  {
  Read parameters from config file.
  }
  InitTag( tagSave,       ReadIni('WriteEnableTag'), 1);
  InitTag( tagSaveErr,    ReadIni('WriteErrorsTag'), 2);
  InitTag( tagWinCaption, ReadIni('WinCaptionTag'),  3);
  InitTag( tagWinTitle,   ReadIni('WinTitleTag'),    3);
  InitTag( tagWinLabel,   ReadIni('WinLabelTag'),    3);
  InitTag( tagFileName,   ReadIni('FileNameTag'),    3);
  {
  Read & check file path & prefix 
  }
  fPath:=AdaptFileName(ReadIni('DataPath'));
  if Length(fPath)>0 then fPath:=DaqFileRef(fPath,'');
  if IsWindows then fPath:=LoCaseStr(fPath);
  if MkDir(fPath)
  then Success('Data path Ok: '+fPath)
  else Trouble('Data path INVALID: '+fPath);
  fPref:=LoCaseStr(ReadIni('FilePrefix'));
  {
  Read & check data list
  }
  s:='';
  cList:='';
  txt:=ReadIniSection(text_new,28,ParamStr('DaqConfigFile'),'['+devname+']');
  for i:=0 to Text_NumLn(txt)-1 do begin
   s:=Trim(Text_GetLn(txt,i));
   if IsSameText(ExtractWord(1,s),'CurveList') then
   for j:=2 to WordCount(s) do begin
    if Length(cList)>0 then cList:=cList+',';
    cList:=cList+ExtractWord(j,s);
   end;
  end;
  bNul(Text_Free(txt));
  if Length(cList)>0
  then Success('CurveList='+cList)
  else Trouble('CurveList items not found in ['+DevName+'] section');
  s:='';
 end;
 {
 Finalization.
 }
 procedure CRWSVR_FREE;
 begin
 end;
 {
 Polling.
 }
 procedure CRWSVR_POLL;
 begin
  {
  Handle Save button
  }
  if iGetTag(tagSave)<>0 then begin
   bNul(iSetTag(tagSave,0));
   SaveCurveList(cList);
  end;
  {
  Handle button click.
  }
  if (ClickButton=1) then begin
   if ClickTag=tagSave then begin
    bNul(iSetTag(ClickTag,Ord(iGetTag(ClickTag)=0)));
    bNul(Voice(snd_Click));
   end;
   if ClickTag=tagSaveErr then begin
    bNul(iSetTag(ClickTag,0));
    bNul(Voice(snd_Click));
   end;
  end;
 end;

 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  CRWSVR_CLEAR;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  CRWSVR_INIT;
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  CRWSVR_FREE;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  CRWSVR_POLL;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommand(Data,cmd,arg) then begin
   {
   @Save Windows WINDOW1,WINDOW2...
   @Save CurveList CURVE1,CURVE2,...
   }
   if IsSameText(cmd,'@Save') then begin
    if IsSameText(ExtractWord(1,arg),'Windows')
    then SaveWindows(Trim(SkipWords(1,arg)));
    if IsSameText(ExtractWord(1,arg),'CurveList')
    then SaveCurveList(Trim(SkipWords(1,arg)));
   end;
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
