 {
 ***********************************************************************
 Daq Pascal application program I7043_drv.
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Poll Flag - Enable Polling 
| (Flag = 1+2+4+8+16+32+64+128 - Read: DO+WDS+WDT+PODO+WDDO+CONF+VERS+NAME)
| @SetCfg NNTTCCFF - Set Configuration
| NN=New Address(0 to FF), TT - Must be 40, CC - BaudRate,
| FF - 00 (No CheckSum) or 40 (With CheckSum)
| @ReadCfg - Read Module Configuration
| @ReadVer - Read Firmware Version
| @ReadName - Read Module Name
| @SetName NAME - Set Module Name
| (NAME = Name, Maximum Length = 6)
| @ReadDO - Read Digital Output Data
| @SetDO DATA - Set Digital Output Data (DATA = 0000 to FFFF)
| @SetChDO Channel Enabled - Set One Channel Digital Output 
| (Channel - 1 to 16, Enabled - 0 or 1)
| @SetPODO - Set Current Digital Output in Power On
| @ReadPODO - Read Power On Digital Output
| @SetWTDO - Set Current Digital Output in Watchdog event
| @ReadWTDO - Read Watchdog Digital Output
| @ReadWDStatus - Read WatchDog Status
| @ReadWDTimeout - Read WatchDog WatchDog Timeout
| @SetWDStatus T Enabled - Set WatchDog Status
| (T - Timeout 0.1 - 25.5 s, Enbaled - 0 or 1)
| @RstWDStatus - Reset WatchDog Status
| @MenuTools - Open Menu Tools
|********************************************************
[]
 }
program I7043_drv;
const
 {------------------------------}{ Declare uses program constants:                }
 {$I _con_StdLibrary}            { Include all Standard constants,                }
 {------------------------------}{ And add User defined constants:                }
 {$I _con_NetRS485}              { Include RS485Proxy   constants.  }
 cm_SetModuleConf  = 1;          { ID CMD: Set Module Configuration               }
 cm_SetModuleName  = 2;          { ID CMD: Read Module Configuration              }
 cm_SetDigitalOut  = 3;          { ID CMD: Read Firmware Version                  }
 cm_SetDoOneChanl  = 4;          { ID CMD: Read Module Name                       }
 cm_SetPwrOnDigOut = 5;          { ID CMD: Set Module Name                        }
 cm_SetWDTDigOut   = 6;          { ID CMD: Read Digital Outputs                   }
 cm_HostIsOk       = 7;          { ID CMD: Set Digital Outputs                    }
 cm_SetWDTStatus   = 8;          { ID CMD: Set Digital Output in one channel mode }
 cm_RstWDTStatus   = 9;          { ID CMD: Set Digital Output at Power On         }
 cm_ReadDigitalOut = 10;         { ID CMD: Read Digital Output at Power On        }
 cm_ReadModuleConf = 11;         { ID CMD: Set Digital Output at Watchdog         }
 cm_ReadFirmwarVer = 12;         { ID CMD: Read Digital Output at Watchdog        }
 cm_ReadModuleName = 13;         { ID CMD: Host is Ok                             }
 cm_ReadPwrOnDigOut= 14;         { ID CMD: Read WatchDog Status                   }
 cm_ReadWDTDigOut  = 15;         { ID CMD: Read WatchDog Timeout and enabling     }
 cm_ReadWDTStatus  = 16;         { ID CMD: Set WatchDog Timout and enabling       }
 cm_ReadWDTimeOut  = 17;         { ID CMD: Reset WatchDog Status if events        }
 MaxCmdNum         = 17;         { Maximal count of commands                      }
 do_state          = 0;          { DO : State                                     }
 do_dodata         = 1;          { DO : Digital Output                            }
 do_podo           = 2;          { DO : Digital Output at Power On                }
 do_wtdo           = 3;          { DO : Digital Output at WatchDog event          }
 do_rx             = 4;          { DO : Recieve rate                              }
 do_tx             = 5;          { DO : Transmite rate                            }
 stt_Disable       = 0;          { Status flag: Disable                           }
 stt_Work          = 1;          { Status flag: Work                              }
 stt_TimeOut       = 2;          { Status flag: TimeOut                           }
 stt_Refused       = 3;          { Status flag: Refused                           }
 stt_WatchDog      = 4;          { Status flag: WatchDog event                    }
 stt_Simulator     = 5;          { Status flag: Simulator                         }
 defTypeCode       = 64;         { Default Device Type                            }
 defBaudRate       = 10;         { Default Baudrate                               }
 defDataFormat     = 64;         { Default Data Format                            }
 bit_poll_cm_ReadDigitalOut =0;
 bit_poll_cm_ReadWDTStatus  =1;
 bit_poll_cm_ReadWDTimeOut  =2;
 bit_poll_cm_ReadPwrOnDigOut=3;
 bit_poll_cm_ReadWDTDigOut  =4;
 bit_poll_cm_ReadModuleConf =5;
 bit_poll_cm_ReadFirmwarVer =6;
 bit_poll_cm_ReadModuleName =7;
 le_req         = '0D';          { Lineending for request to device }
 DimDeadline    = 5000;
 
 
type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 
var
 {------------------------------}{ Declare uses program variables:      }
 {$I _var_StdLibrary}            { Include all Standard variables,      }
 {------------------------------}{ And add User defined variables:      }
 {$I _var_NetRS485}              { Include RS485Proxy   variables.  }
 cmd_DimCmdMy      : Integer;    { System Command @DIMCMDMY             }
 cmd_DimTagUpdate  : Integer;    { System Command @DimTagUpdate         }
 cmd_RsReply       : Integer;    { Command @RS485.Reply             }
 cmd_RsPoll        : Integer;    { Command @RS485.Poll              }
 cmd_RsRefuse      : Integer;    { Command @RS485.Refuse            }
 cmd_RsTimeout     : Integer;    { Command @RS485.Timeout           }
 cmd_RsClrSumm     : Integer;    { Command @ClearRS485Sum           }
 cmd_Poll          : Integer;    { Console Command @Poll flag           }
 cmd_SetCfg        : Integer;    { Console Command @SetCfg NNTTCCFF     }
 cmd_ReadCfg       : Integer;    { Console Command @ReadCfg             }
 cmd_ReadVer       : Integer;    { Console Command @ReadVer             }
 cmd_ReadName      : Integer;    { Console Command @ReadName            }
 cmd_SetName       : Integer;    { Console Command @SetName NAME        }
 cmd_ReadDO        : Integer;    { Console Command @ReadDO              }
 cmd_SetDO         : Integer;    { Console Command @SetDO Data          }
 cmd_SetChDO       : Integer;    { Console Command @SetChDO Ch En       }
 cmd_SetPODO       : Integer;    { Console Command @SetPODO             }
 cmd_ReadPODO      : Integer;    { Console Command @ReadPODO            }
 cmd_SetWTDO       : Integer;    { Console Command @SetWTDO             }
 cmd_ReadWTDO      : Integer;    { Console Command @ReadWTDO            }
 cmd_ReadWDStatus  : Integer;    { Console Command @ReadWDStatus        }
 cmd_ReadWDTimeout : Integer;    { Console Command @ReadWDTimeout       }
 cmd_SetWDStatus   : Integer;    { Console Command @SetWDStatus T En    }
 cmd_RstWDStatus   : Integer;    { Console Command @RstWDStatus         }
 cmd_MenuTools     : Integer;    { Console Command @MenuTools           }
 I7043             : record      { I7043 Data                           }
  Simulator         : Boolean;   { Simulator Mode                       }
  isCheckSum        : Boolean;
  WDReconnect       : Boolean;   { WatchDog AutoReconnect               }
  ReserveDO         : Integer;   { Reserve Digital Output Data          }
  ChNumber          : Integer;   { Channel Number                       }
  ChState           : Boolean;   { Channel State                        }
  StartPoll         : Integer;
  SERVMODE          : TTagRef;   { Tag: Dim Server Mode?                }
  POLL              : TTagRef;   { Tag: Flags for Poll                  }
  POLL_NOTIFY       : TTagRef;   { Tag: Notify for action confirm       }
  RX                : TTagRef;   { Tag: Recieve rate data               }
  TX                : TTagRef;   { Tag: Transmite rate data             }
  STATE             : TTagRef;   { Tag: State of device                 }
  DOALL             : TTagRef;   { Tag: Digital Outputs control btn     }
  DODATA            : TTagRef;   { Tag: Digital Outputs data            }
  DO1               : TTagRef;   { Tag: Digital Output 1 data           }
  DO2               : TTagRef;   { Tag: Digital Output 2 data           }
  DO3               : TTagRef;   { Tag: Digital Output 3 data           }
  DO4               : TTagRef;   { Tag: Digital Output 4 data           }
  DO5               : TTagRef;   { Tag: Digital Output 5 data           }
  DO6               : TTagRef;   { Tag: Digital Output 6 data           }
  DO7               : TTagRef;   { Tag: Digital Output 7 data           }
  DO8               : TTagRef;   { Tag: Digital Output 8 data           }
  DO9               : TTagRef;   { Tag: Digital Output 9 data           }
  DO10              : TTagRef;   { Tag: Digital Output 10 data          }
  DO11              : TTagRef;   { Tag: Digital Output 11 data          }
  DO12              : TTagRef;   { Tag: Digital Output 12 data          }
  DO13              : TTagRef;   { Tag: Digital Output 13 data          }
  DO14              : TTagRef;   { Tag: Digital Output 14 data          }
  DO15              : TTagRef;   { Tag: Digital Output 15 data          }
  DO16              : TTagRef;   { Tag: Digital Output 16 data          }
  PODO              : TTagRef;   { Tag: Digital Outputs at Power On     }
  WTDO              : TTagRef;   { Tag: Digital Outputs at WatchDog     }
  NAME              : TTagRef;   { Tag: Name of device                  }
  VERSION           : TTagRef;   { Tag: Firmware Version of device      }
  ADDRESS           : TTagRef;   { Tag: Address of device               }
  BAUDRATE          : TTagRef;   { Tag: Baudrate of device              }
  CHECKSUM          : TTagRef;   { Tag: Checksum Enabled?               }
  PARITY            : TTagRef;   { Tag: Parity parameter                }
  PODOSET           : TTagRef;   { Tag: Set Digital Outputs at Power On }
  PODOREAD          : TTagRef;   { Tag: Read Digital Outputs at Power On}
  WTDOSET           : TTagRef;   { Tag: Set Digital Outputs at WatchDog }
  WTDOREAD          : TTagRef;   { Tag: Read Digital Outputs at WatchDog}
  WDTIMEOUT         : TTagRef;   { Tag: WatchDog TimeOut                }
  WDSTATUS          : TTagRef;   { Tag: WatchDog Status                 }
  WDENDIS           : TTagRef;   { Tag: Enable/Disable WatchDog button  }
  CmdTab         : Record
   Num            : Integer;      { Current running command number         }
   Enabled        : array [1..MaxCmdNum] of Boolean; { Enable polling      }
   CmdChar        : array [1..MaxCmdNum] of Char;
   CmdMode        : array [1..MaxCmdNum] of String;
   Acronym        : array [1..MaxCmdNum] of String;  { Accronym of command }
   OpData         : array [1..MaxCmdNum] of String;  { Operation Data      }
   PollCnt        : Integer;
  end;
  RS485             : Record
   Port              : Integer;       { Logical Port on &RS485Proxy         }
   UnitId            : Integer;       { Modbus unit id                       }
   Timeout           : Integer;       { Modbus timeout, ms                   }
   Polling           : Integer;       { Modbus polling period, ms            }
   Deadline          : Integer;       { Modbus deadline time, ms             }
   DelayOnStart      : Integer;       { Command cycle delay on start         }
   Poll              : record
    ref               : Integer;          { Last sent device reference           }
    cid               : Integer;          { Last sent command id                 }
    tim               : Real;             { Last polling time, ms                }
    port              : Integer;          { Last polling port                    }
    uid               : Integer;          { Last polling unit id                 }
    dat               : String;           { Last sent data         }
    Summ              : record
     Rx                : Integer;
     Tx                : Integer;
    end;
    Rate              : record
     Rx                : Integer;
     Tx                : Integer;
    end;
   end;
  end;                         
  WatchdogTime   : Real;         { Watchdog deadline time, sec          }
  HostIsOkPeriod : Integer;      { Watchdog HostIsOk period, ms         }
  TypeCode       : Integer;      { Type code of module                  }
  NewBaudRate    : Integer;      { BaudRate  of module                  }
  DataFormat     : Integer;      { Data format of module                }
  PollConfirm    : Boolean;      { Poll Dialog is Action?               }
  EnableWD       : Integer;      { Enable WatchDog for send             }
  TimeoutWD      : Real;         { TimeOut WatchDog for send            }
 end;

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetRS485}              { Include RS485Proxy   functions.  }
 
 {
 Procedure to show sensor help
 }
 procedure SensorHelp(s:String);
 begin
  StdSensorHelpTooltip(s,15000);
 end;
 {
 Prefix for DIM @remote commands.
 }
 function DimRemote:String;
 var CanRemote:Boolean;
 begin
  CanRemote:=DIM_IsServerMode or DIM_IsClientMode;
  if (DIM_GuiClickTag=0) then CanRemote:=false;
  if (devDimSrv=0) then CanRemote:=false;
  if CanRemote
  then DimRemote:='@remote '
  else DimRemote:='';
 end;
 {
 Clear Strings
 }
 Procedure I7043_ClearStrings;
 var i:Integer;
 begin
  I7043.RS485.Poll.dat:='';
  //I7043.SelfId:='';
  for i:=1 to MaxCmdNum do begin
   I7043.CmdTab.Acronym[i]:='';
   I7043.CmdTab.OpData[i]:='';
   I7043.CmdTab.CmdMode[i]:='';
  end;
 end;
 {
 Clear Data
 }
 Procedure I7043_Clear;
 var i:Integer;
 begin
  I7043.RS485.Port        :=0;
  I7043.RS485.UnitId      :=0;
  I7043.RS485.Timeout     :=0;
  I7043.RS485.Polling     :=0;
  I7043.RS485.Deadline    :=0;
  I7043.RS485.DelayOnStart:=0;
  I7043.RS485.Poll.ref    :=0;
  I7043.RS485.Poll.cid    :=0;
  I7043.RS485.Poll.tim    :=0;
  I7043.RS485.Poll.port   :=0;
  I7043.RS485.Poll.uid    :=0;
  I7043.RS485.Poll.Rate.Rx:=0;
  I7043.RS485.Poll.Rate.Tx:=0;
  I7043.RS485.Poll.Summ.Rx:=0;
  I7043.RS485.Poll.Summ.Tx:=0;
  I7043.CmdTab.Num        :=0;
  for i:=1 to MaxCmdNum do begin
   I7043.CmdTab.Enabled[i]:=false;
  end;
  I7043.HostIsOkPeriod:=0;
 end;
 {
 Initialize tag refreshment value.
 }
 procedure I7043_FillTag(tag:Integer; InitVal:Real);
  procedure Process(var R:TTagRef);
  begin
   if (R.tag=tag) then bNul(ShouldRefresh(R.val,InitVal)>0);
  end;
 begin
  if (TypeTag(tag)>0) then begin
   Process(I7043.POLL);
   Process(I7043.RX);
   Process(I7043.TX);
   Process(I7043.STATE);
   Process(I7043.DOALL);
   Process(I7043.DODATA);
   Process(I7043.DO1);
   Process(I7043.DO2);
   Process(I7043.DO3);
   Process(I7043.DO4);
   Process(I7043.DO5);
   Process(I7043.DO6);
   Process(I7043.DO7);
   Process(I7043.DO8);
   Process(I7043.DO9);
   Process(I7043.DO10);
   Process(I7043.DO11);
   Process(I7043.DO12);
   Process(I7043.DO13);
   Process(I7043.DO14);
   Process(I7043.DO15);
   Process(I7043.DO16);
   Process(I7043.PODO);
   Process(I7043.WTDO);
   Process(I7043.NAME);
   Process(I7043.VERSION);
   Process(I7043.ADDRESS);
   Process(I7043.BAUDRATE);
   Process(I7043.CHECKSUM);
   Process(I7043.PARITY);
   Process(I7043.PODOSET);
   Process(I7043.PODOREAD);
   Process(I7043.WTDOSET);
   Process(I7043.WTDOREAD);
   Process(I7043.WDTIMEOUT);
   Process(I7043.WDSTATUS);
   Process(I7043.WDENDIS);
  end;
 end;
 {
 I7043 tag Initialization
 }
 procedure I7043_FillTags(InitVal:Real);
 begin
  I7043.POLL.val     :=InitVal;
  I7043.RX.val       :=InitVal;
  I7043.TX.val       :=InitVal;
  I7043.STATE.val    :=InitVal;
  I7043.DOALL.val    :=InitVal;
  I7043.DODATA.val   :=InitVal;
  I7043.DO1.val      :=InitVal;
  I7043.DO2.val      :=InitVal;
  I7043.DO3.val      :=InitVal;
  I7043.DO4.val      :=InitVal;
  I7043.DO5.val      :=InitVal;
  I7043.DO6.val      :=InitVal;
  I7043.DO7.val      :=InitVal;
  I7043.DO8.val      :=InitVal;
  I7043.DO9.val      :=InitVal;
  I7043.DO10.val     :=InitVal;
  I7043.DO11.val     :=InitVal;
  I7043.DO12.val     :=InitVal;
  I7043.DO13.val     :=InitVal;
  I7043.DO14.val     :=InitVal;
  I7043.DO15.val     :=InitVal;
  I7043.DO16.val     :=InitVal;
  I7043.PODO.val     :=InitVal;
  I7043.WTDO.val     :=InitVal;
  I7043.NAME.val     :=InitVal;
  I7043.VERSION.val  :=InitVal;
  I7043.ADDRESS.val  :=InitVal;
  I7043.BAUDRATE.val :=InitVal;
  I7043.CHECKSUM.val :=InitVal;
  I7043.PARITY.val   :=InitVal;
  I7043.PODOSET.val  :=InitVal;
  I7043.PODOREAD.val :=InitVal;
  I7043.WTDOSET.val  :=InitVal;
  I7043.WTDOREAD.val :=InitVal;
  I7043.WDTIMEOUT.val:=InitVal;
  I7043.WDSTATUS.val :=InitVal;
  I7043.WDENDIS.val  :=InitVal;
 end;
 procedure I7043_InitTags(Prefix:String; InitVal:Real);
 begin
  if not IsEmptyStr(Prefix) then begin
   DIM_GuiClickInit(Prefix+'.DIMGUICLICK');
   InitTag(I7043.SERVMODE.tag ,Prefix+'.SERVMODE' ,1);
   InitTag(I7043.POLL_NOTIFY.tag, Prefix+'.POLL.NOTIFY' ,1);
   InitTag(I7043.POLL.tag     ,Prefix+'.POLL'     ,1);
   InitTag(I7043.RX.tag       ,Prefix+'.RX'       ,1);
   InitTag(I7043.TX.tag       ,Prefix+'.TX'       ,1);
   InitTag(I7043.STATE.tag    ,Prefix+'.STATE'    ,1);
   InitTag(I7043.DOALL.tag    ,Prefix+'.DOALL'    ,1);
   InitTag(I7043.DODATA.tag   ,Prefix+'.DODATA'   ,1);
   InitTag(I7043.DO1.tag      ,Prefix+'.DO1'      ,1);
   InitTag(I7043.DO2.tag      ,Prefix+'.DO2'      ,1);
   InitTag(I7043.DO3.tag      ,Prefix+'.DO3'      ,1);
   InitTag(I7043.DO4.tag      ,Prefix+'.DO4'      ,1);
   InitTag(I7043.DO5.tag      ,Prefix+'.DO5'      ,1);
   InitTag(I7043.DO6.tag      ,Prefix+'.DO6'      ,1);
   InitTag(I7043.DO7.tag      ,Prefix+'.DO7'      ,1);
   InitTag(I7043.DO8.tag      ,Prefix+'.DO8'      ,1);
   InitTag(I7043.DO9.tag      ,Prefix+'.DO9'      ,1);
   InitTag(I7043.DO10.tag     ,Prefix+'.DO10'     ,1);
   InitTag(I7043.DO11.tag     ,Prefix+'.DO11'     ,1);
   InitTag(I7043.DO12.tag     ,Prefix+'.DO12'     ,1);
   InitTag(I7043.DO13.tag     ,Prefix+'.DO13'     ,1);
   InitTag(I7043.DO14.tag     ,Prefix+'.DO14'     ,1);
   InitTag(I7043.DO15.tag     ,Prefix+'.DO15'     ,1);
   InitTag(I7043.DO16.tag     ,Prefix+'.DO16'     ,1);
   InitTag(I7043.PODO.tag     ,Prefix+'.PODO'     ,1);
   InitTag(I7043.WTDO.tag     ,Prefix+'.WTDO'     ,1);
   InitTag(I7043.NAME.tag     ,Prefix+'.NAME'     ,3);
   InitTag(I7043.VERSION.tag  ,Prefix+'.VERSION'  ,3);
   InitTag(I7043.ADDRESS.tag  ,Prefix+'.ADDRESS'  ,1);
   InitTag(I7043.BAUDRATE.tag ,Prefix+'.BAUDRATE' ,1);
   InitTag(I7043.CHECKSUM.tag ,Prefix+'.CHECKSUM' ,1);
   InitTag(I7043.PARITY.tag   ,Prefix+'.PARITY'   ,1);
   InitTag(I7043.PODOSET.tag  ,Prefix+'.PODOSET'  ,1);
   InitTag(I7043.PODOREAD.tag ,Prefix+'.PODOREAD' ,1);
   InitTag(I7043.WTDOSET.tag  ,Prefix+'.WTDOSET'  ,1);
   InitTag(I7043.WTDOREAD.tag ,Prefix+'.WTDOREAD' ,1);
   InitTag(I7043.WDTIMEOUT.tag,Prefix+'.WDTIMEOUT',2);
   InitTag(I7043.WDSTATUS.tag ,Prefix+'.WDSTATUS' ,1);
   InitTag(I7043.WDENDIS.tag  ,Prefix+'.WDENDIS'  ,1);
   I7043_FillTags(InitVal);
  end;
 end;
 {
 Allowed Success/Trouble/ViewImp/ViewExp/Details.
 }
 function AllowedSuccess:Boolean; begin AllowedSuccess:=iAnd(dfSuccess,DebugFlags)>0; end;
 function AllowedTrouble:Boolean; begin AllowedTrouble:=iAnd(dfTrouble,DebugFlags)>0; end;
 function AllowedViewExp:Boolean; begin AllowedViewExp:=iAnd(dfViewExp,DebugFlags)>0; end;
 function AllowedViewImp:Boolean; begin AllowedViewImp:=iAnd(dfViewImp,DebugFlags)>0; end;
 function AllowedDetails:Boolean; begin AllowedDetails:=iAnd(dfDetails,DebugFlags)>0; end;
 {
 Enable command with given command identifier.
 }
 procedure I7043_EnableCmdId(CmdId:Integer; Enabled:Boolean);
 begin
  if CmdId<=MaxCmdNum then I7043.CmdTab.Enabled[CmdId]:=Enabled;
 end;
 {
 Initialization Command Table
 }
 Procedure I7043_InitCmdItem(CmdId,Enabled:Integer; CmdChar:Char; CmdMode,OpData,Comment:String);
 begin
  I7043.CmdTab.Enabled[CmdId]:=Enabled>0;
  I7043.CmdTab.CmdChar[CmdId]:=CmdChar;
  I7043.CmdTab.CmdMode[CmdId]:=CmdMode;
  if CmdId<>cm_HostIsOk 
  then I7043.CmdTab.Acronym[CmdId]:=CmdChar+HexB(I7043.RS485.UnitId)+CmdMode
  else I7043.CmdTab.Acronym[CmdId]:=CmdChar+CmdMode;
  I7043.CmdTab.OpData[CmdId]:=OpData;
  Details('Command Id: '+str(CmdId)+' - '+I7043.CmdTab.Acronym[CmdId]+' - '+Comment);
 end;
 procedure I7043_InitCmdTable;
 begin
  //                CMD ID           Enabled  CmdChar   CmdMode              OpData  Comment
  I7043_InitCmdItem(cm_SetModuleConf  ,  0 ,   '%'     , ''                  ,'','Set Module Configuration');
  I7043_InitCmdItem(cm_SetModuleName  ,  0 ,   '~'     , stringofchar('O',1) ,'','Set Module Name');
  I7043_InitCmdItem(cm_SetDigitalOut  ,  0 ,   '@'     , ''                  ,'','Set Digital Outputs');
  I7043_InitCmdItem(cm_SetDoOneChanl  ,  0 ,   '#'     , ''                  ,'','Set One Digital Output');
  I7043_InitCmdItem(cm_SetPwrOnDigOut ,  0 ,   '~'     , '5P'                ,'','Set Power On Digital Outputs');
  I7043_InitCmdItem(cm_SetWDTDigOut   ,  0 ,   '~'     , '5S'                ,'','Set WatchDog Digital Outputs');
  I7043_InitCmdItem(cm_HostIsOk       ,  0 ,   '~'     , '**'                ,'','HostIsOk Notification');
  I7043_InitCmdItem(cm_SetWDTStatus   ,  0 ,   '~'     , stringofchar('3',1) ,'','Set WatchDog Timeout Status');
  I7043_InitCmdItem(cm_RstWDTStatus   ,  0 ,   '~'     , stringofchar('1',1) ,'','Reset WatchDog TimeOut Status');
  I7043_InitCmdItem(cm_ReadDigitalOut ,  1 ,   '@'     , ''                  ,'','Read Digital Outputs');
  I7043_InitCmdItem(cm_ReadModuleConf ,  1 ,   '$'     , stringofchar('2',1) ,'','Read Module Configuration');
  I7043_InitCmdItem(cm_ReadFirmwarVer ,  1 ,   '$'     , stringofchar('F',1) ,'','Read Firmware Version');
  I7043_InitCmdItem(cm_ReadModuleName ,  1 ,   '$'     , stringofchar('M',1) ,'','Read Module Name');
  I7043_InitCmdItem(cm_ReadPwrOnDigOut,  1 ,   '~'     , '4P'                ,'','Read Power On Digital Outputs');
  I7043_InitCmdItem(cm_ReadWDTDigOut  ,  1 ,   '~'     , '4S'                ,'','Read WatchDog Digital Outputs');
  I7043_InitCmdItem(cm_ReadWDTStatus  ,  1 ,   '~'     , stringofchar('0',1) ,'','Read WatchDog Status');
  I7043_InitCmdItem(cm_ReadWDTimeOut  ,  1 ,   '~'     , stringofchar('2',1) ,'','Read WatchDog TimeOut Value');
  I7043.CmdTab.PollCnt:=0;
 end;
 {
 Initialize I7043 parameters
 }
 Procedure I7043_Init;
 var r:Real;
 begin
  I7043_Clear;
  I7043_ClearStrings;
  I7043_InitTags(ReadIni('tagPrefix'),-MaxReal);
  I7043.Simulator:=iValDef(ReadIni('Simulator'),0)>0;
  I7043.WDReconnect:=iValDef(ReadIni('WDReconnect'),0)>0;
  I7043.isChecksum:=iValDef(ReadIni('Checksum'),0)>0;
  if not I7043.Simulator then begin
   I7043.RS485.Port        :=iValDef(ReadIni('RS485Port'),1);
   I7043.RS485.UnitId      :=iValDef(ReadIni('RS485UnitId'),1);
   I7043.RS485.Timeout     :=iValDef(ReadIni('RS485Timeout'),250);
   I7043.RS485.Polling     :=iValDef(ReadIni('RS485Polling'),10);
   I7043.RS485.Deadline    :=iValDef(ReadIni('RS485Deadline'),60000);
   I7043.RS485.DelayOnStart:=iValDef(ReadIni('DelayOnStart'),1000);
   r:=Max(0,Min(25.5,rValDef(ReadIni('WatchdogTime'),0)));
   bNul(rSetTag(I7043.WDTIMEOUT.tag,r));
   Success('WatchdogTime = '+Str(rGetTag(I7043.WDTIMEOUT.tag)));
  end else begin
   bNul(sSetTag(I7043.NAME.tag,'Simula'));
   bNul(sSetTag(I7043.VERSION.tag,'SimVer'));
   bNul(iSetTag(I7043.BAUDRATE.tag,3));
  end;
  I7043_InitCmdTable;
  {
  Initialize variables...
  }
  I7043.TypeCode:=defTypeCode;
  I7043.NewBaudRate:=defBaudRate;
  I7043.DataFormat:=defDataFormat;
  {
  Register console commands...
  }
  cmd_DimTagUpdate:= RegisterStdInCmd('@DimTagUpdate','');
  cmd_DimCmdMy    := RegisterStdInCmd('@DIMCMDMY','');
  cmd_RsReply     := RegisterStdInCmd('@RS485.Reply'   ,'');
  cmd_RsPoll      := RegisterStdInCmd('@RS485.Poll'    ,'');
  cmd_RsRefuse    := RegisterStdInCmd('@RS485.Refuse'  ,'');
  cmd_RsTimeout   := RegisterStdInCmd('@RS485.Timeout' ,'');
  cmd_RsClrSumm   := RegisterStdInCmd('@ClearRS485Sum' ,'');
  cmd_Poll         :=RegisterStdInCmd('@Poll','');
  cmd_SetCfg       :=RegisterStdInCmd('@SetCfg','');
  cmd_ReadCfg      :=RegisterStdInCmd('@ReadCfg','');
  cmd_ReadVer      :=RegisterStdInCmd('@ReadVer','');
  cmd_ReadName     :=RegisterStdInCmd('@ReadName','');
  cmd_SetName      :=RegisterStdInCmd('@SetName','');
  cmd_ReadDO       :=RegisterStdInCmd('@ReadDO','');
  cmd_SetDO        :=RegisterStdInCmd('@SetDO','');
  cmd_SetChDO      :=RegisterStdInCmd('@SetChDO','');
  cmd_SetPODO      :=RegisterStdInCmd('@SetPODO','');
  cmd_ReadPODO     :=RegisterStdInCmd('@ReadPODO','');
  cmd_SetWTDO      :=RegisterStdInCmd('@SetWTDO','');
  cmd_ReadWTDO     :=RegisterStdInCmd('@ReadWTDO','');
  cmd_ReadWDStatus :=RegisterStdInCmd('@ReadWDStatus','');
  cmd_ReadWDTimeout:=RegisterStdInCmd('@ReadWDTimeout','');
  cmd_SetWDStatus  :=RegisterStdInCmd('@SetWDStatus','');
  cmd_RstWDStatus  :=RegisterStdInCmd('@RstWDStatus','');
  cmd_MenuTools    :=RegisterStdInCmd('@MenuTools','');
  bNul(iSetTag(I7043.ADDRESS.tag,I7043.RS485.UnitId));
  if DIM_IsServerMode then bNul(iSetTag(I7043.SERVMODE.tag,0)) else
  if DIM_IsClientMode then bNul(iSetTag(I7043.SERVMODE.tag,1));
 end;
 {
 Command cycle routines.
 }
 function IsValidCmdNum(Num:Integer):Boolean;
 begin
  IsValidCmdNum:=(1<=Num) and (Num<=MaxCmdNum);
 end;
 function ValidateCmdNum(Num:Integer):Integer;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then ValidateCmdNum:=Num
  else ValidateCmdNum:=1;
 end;
 function IsEnabledCmdNum(Num:Integer):Boolean;
 begin
  if (1<=Num) and (Num<=MaxCmdNum)
  then IsEnabledCmdNum:=I7043.CmdTab.Enabled[Num]
  else IsEnabledCmdNum:=False;
 end;
 function NextEnabledCmdNum(Num:Integer):Integer;
 var i:Integer; oldNum:Integer;
 begin
  i:=0;
  oldNum:=Num;
  while (i<=MaxCmdNum) do begin
   Num:=ValidateCmdNum(Num+1);
   if IsEnabledCmdNum(Num)
   then i:=MaxCmdNum+1
   else i:=i+1;
  end;
  if Num<=oldNum then I7043.CmdTab.PollCnt:=I7043.CmdTab.PollCnt+1;
  NextEnabledCmdNum:=Num;
 end;
 {
 Find the current Proxy device to send @RS485.Poll message.
 }
 function devTheProxy:Integer;
 begin
  //if I7043.Simulator                // In simulation mode
  //then devTheProxy:=devMySelf       // send messages to himself
  //else devTheProxy:=devModbusProxy; // otherwise use &ModbusProxy
  devTheProxy:=devRS485Proxy;
 end;
 {
 Check if communication port is opened or not.
 As long as we use Proxy device, check Port number & device reference.
 }
 function IsPortOpened:Boolean;
 begin
  IsPortOpened:=(I7043.RS485.Port>0) and (devTheProxy<>0);
 end;
 {
 Assign RS485 last sent polling request record.
 }
 procedure AssignRS485Poll(ref,cid:Integer; tim:Real; port,uid:Integer; dat:String);
 begin
  I7043.RS485.Poll.ref:=ref;     I7043.RS485.Poll.cid:=cid;     I7043.RS485.Poll.tim:=tim;
  I7043.RS485.Poll.port:=port;   I7043.RS485.Poll.uid:=uid;     I7043.RS485.Poll.dat:=dat;
 end;
 {
 Clear RS485 polling request to be ready for next polling.
 }
 procedure ClearRS485Poll;
 begin
  I7043.RS485.Poll.cid:=0;
  I7043.RS485.Poll.dat:='';
 end;
 {
 Clear RS485 pollrate
 }
 procedure ClearRS485Rate;
 begin
  I7043.RS485.Poll.Rate.Rx:=0;
  I7043.RS485.Poll.Rate.Tx:=0;
 end;
 //
 // Increment summ and rate counters.
 //
 procedure IncSummRate(var summ,rate:Integer);
 begin
  summ:=summ+1; rate:=rate+1;
 end;
 //
 // Format error message with with error counter increment.
 // Usage is like: Trouble(GotBug(...)); Problem(GotBug(...));
 //
 function GotBug(msg:String):String;
 begin
  //IncSummRate(I7043.Modbus.Poll.Summ.Ex,I7043.Modbus.Poll.Rate.Ex);
  GotBug:=msg;
 end;
 {
 Validating Type Code
 I7043 Type Code: $40 (hex)
 }
 function ValidateTypeCode(TT:Integer):Integer;
 begin
  ValidateTypeCode:=I7043.TypeCode;
  if eq(TT,64) then ValidateTypeCode:=TT else Problem('Invalid Type Code: '+HexB(TT));
 end;
 {
 Validating BaudRate
 I7043 BaudRate: $03-$0A (hex)
 }
 function ValidateBaudRate(CC:Integer):Integer;
 begin
  ValidateBaudRate:=I7043.NewBaudRate;
  if (ge(CC,3) and le(CC,10)) then ValidateBaudRate:=CC else Problem('Invalid BaudRate: '+HexB(CC));
 end;
 {
 Validating DataFormat
 I7043 DataFormat: $00,$40 (hex)
 }
 function ValidateDataFormat(FF:Integer):Integer;
 begin
  ValidateDataFormat:=I7043.DataFormat;
  if (eq(FF,64) or eq(FF,0)) then ValidateDataFormat:=FF else Problem('Invalid DataFormat: '+HexB(FF));
 end;
 {
 EnablePoll
 }
 Procedure CalcHostIsOkPeriod;
 begin
  I7043.HostIsOkPeriod:=Ord(iGetTag(I7043.WDSTATUS.tag)=1)*Round(rGetTag(I7043.WDTIMEOUT.tag)*1000*0.5);
 end;
 Procedure PollEnable(cmd,bit:Integer);
 begin
  I7043_EnableCmdId(cmd,iGetTagBitState(I7043.POLL.tag,bit));
 end;
 Procedure I7043_EnablePoll(flag:Integer);//flag 1+2+4+8+16+32+64+128
 begin
  I7043_EnableCmdId(cm_ReadDigitalOut,iGetBitState(flag, bit_poll_cm_ReadDigitalOut )); //flag 1
  I7043_EnableCmdId(cm_ReadWDTStatus,iGetBitState(flag,  bit_poll_cm_ReadWDTStatus  ));  //flag 2
  I7043_EnableCmdId(cm_ReadWDTimeOut,iGetBitState(flag,  bit_poll_cm_ReadWDTimeOut  ));  //flag 4
  I7043_EnableCmdId(cm_ReadPwrOnDigOut,iGetBitState(flag,bit_poll_cm_ReadPwrOnDigOut));//flag 8
  I7043_EnableCmdId(cm_ReadWDTDigOut,iGetBitState(flag,  bit_poll_cm_ReadWDTDigOut  ));  //flag 16
  I7043_EnableCmdId(cm_ReadModuleConf,iGetBitState(flag, bit_poll_cm_ReadModuleConf )); //flag 32
  I7043_EnableCmdId(cm_ReadFirmwarVer,iGetBitState(flag, bit_poll_cm_ReadFirmwarVer )); //flag 64
  I7043_EnableCmdId(cm_ReadModuleName,iGetBitState(flag, bit_poll_cm_ReadModuleName )); //flag 128
 end;
 {
 Update data curves & tags
 }
 Procedure UpdateModuleConfig(cfg:String);
 begin
  if AllowedSuccess then Success('ModuleConfig: '+cfg);
  I7043.TypeCode:=ValidateTypeCode(Val('$'+Copy(cfg,3,2)));
  Success('TypeCode: '  +HexB(I7043.TypeCode));
  I7043.NewBaudRate:=ValidateBaudRate(Val('$'+Copy(cfg,5,2)));
  bNul(iSetTag(I7043.BAUDRATE.tag,I7043.NewBaudRate));
  Success('BaudRate: '  +HexB(I7043.NewBaudRate));
  I7043.DataFormat:=ValidateDataFormat(Val('$'+Copy(cfg,7,2)));
  bNul(iSetTagBitState(I7043.CHECKSUM.tag,0,isbit(I7043.DataFormat,6)));
  Success('DataFormat: '+HexB(I7043.DataFormat));
 end;
 procedure UpdateModuleVersion(ver:String);
 begin
  if AllowedSuccess then Success('FirmwareVersion: '+ver);
  bNul(sSetTag(I7043.VERSION.tag,ver));
 end;
 procedure UpdateModuleName(name:String);
 begin
  if AllowedSuccess then Success('ModuleName: '+name);
  bNul(sSetTag(I7043.NAME.tag,name));
 end;
 procedure UpdateDigitalOutput(digo:String);
 begin
  if AllowedSuccess then Success('DigitalOutput: '+digo);
  bNul(iSetTag(I7043.DODATA.tag,val('$'+digo)));
  UpdateDo(do_dodata,time,iGetTag(I7043.DODATA.tag));
 end;
 procedure UpdatePODigitalOutput(digo:String);
 begin
  if AllowedSuccess then Success('PowerOnDigitalOutput: '+digo);
  bNul(iSetTag(I7043.PODO.tag,val('$'+digo)));
  UpdateDo(do_podo,time,iGetTag(I7043.PODO.tag));
 end;
 procedure UpdateWTDigitalOutput(digo:String);
 begin
  if AllowedSuccess then Success('WatchDogDigitalOutput: '+digo);
  bNul(iSetTag(I7043.WTDO.tag,val('$'+digo)));
  UpdateDo(do_wtdo,time,iGetTag(I7043.WTDO.tag));
 end;
 procedure UpdateWDStatus(wds:String);
 begin
  if AllowedSuccess then Success('WatchDogStatus: '+wds);
  if iGetBitState(val('$'+wds),2) then begin
   bNul(iSetTag(I7043.WDSTATUS.tag,2));
   if iGetBitState(val('$'+wds),7) then begin
    bNul(iSetTag(I7043.WDENDIS.tag,1));
   end;
  end else begin
   if iGetBitState(val('$'+wds),7) then begin
    bNul(iSetTag(I7043.WDSTATUS.tag,1));
    bNul(iSetTag(I7043.WDENDIS.tag,1));
   end else begin
    bNul(iSetTag(I7043.WDENDIS.tag,0));
    bNul(iSetTag(I7043.WDSTATUS.tag,0));
   end;
  end;
  CalcHostIsOkPeriod;
 end;
 procedure UpdateWDTimeout(wdt:String);
 begin
  if AllowedSuccess then Success('WatchDogTimeout: '+wdt);
  if not (iGetTag(I7043.WDSTATUS.tag)=2) then bNul(iSetTag(I7043.WDSTATUS.tag,val(copy(wdt,1,1))));
  bNul(rSetTag(I7043.WDTIMEOUT.tag,(rval('$'+copy(wdt,2,2))/10)));
  CalcHostIsOkPeriod;
 end;
 procedure UpdateDigitalOutputs;
 begin
  bNul(iSetTag(I7043.DO1.tag,Ord(iGetTagBitState(I7043.DODATA.tag,0))));
  bNul(iSetTag(I7043.DO2.tag,Ord(iGetTagBitState(I7043.DODATA.tag,1))));
  bNul(iSetTag(I7043.DO3.tag,Ord(iGetTagBitState(I7043.DODATA.tag,2))));
  bNul(iSetTag(I7043.DO4.tag,Ord(iGetTagBitState(I7043.DODATA.tag,3))));
  bNul(iSetTag(I7043.DO5.tag,Ord(iGetTagBitState(I7043.DODATA.tag,4))));
  bNul(iSetTag(I7043.DO6.tag,Ord(iGetTagBitState(I7043.DODATA.tag,5))));
  bNul(iSetTag(I7043.DO7.tag,Ord(iGetTagBitState(I7043.DODATA.tag,6))));
  bNul(iSetTag(I7043.DO8.tag,Ord(iGetTagBitState(I7043.DODATA.tag,7))));
  bNul(iSetTag(I7043.DO9.tag,Ord(iGetTagBitState(I7043.DODATA.tag,8))));
  bNul(iSetTag(I7043.DO10.tag,Ord(iGetTagBitState(I7043.DODATA.tag,9))));
  bNul(iSetTag(I7043.DO11.tag,Ord(iGetTagBitState(I7043.DODATA.tag,10))));
  bNul(iSetTag(I7043.DO12.tag,Ord(iGetTagBitState(I7043.DODATA.tag,11))));
  bNul(iSetTag(I7043.DO13.tag,Ord(iGetTagBitState(I7043.DODATA.tag,12))));
  bNul(iSetTag(I7043.DO14.tag,Ord(iGetTagBitState(I7043.DODATA.tag,13))));
  bNul(iSetTag(I7043.DO15.tag,Ord(iGetTagBitState(I7043.DODATA.tag,14))));
  bNul(iSetTag(I7043.DO16.tag,Ord(iGetTagBitState(I7043.DODATA.tag,15))));
 end;
 {
 Handle "Answer received"...
 }
 function CalcCheckSum(dat:String):String;
 var i,sum:integer;
 begin
   sum:=0;
   for i:=1 to length(dat) do sum:=sum+ord(strfetch(dat,i));
   CalcCheckSum:=HexB(sum);
 end;
 
 function isCorrectChecksum(dat:String; var checkdat:String):boolean;
 var tempchecksum,tempdat:String;
 begin
  tempchecksum:='';tempdat:='';checkdat:='';
  isCorrectChecksum:=false;
  tempdat:=trim(dat);
  if I7043.isCheckSum then begin
   tempchecksum:=copy(dat,length(tempdat)-1);
   tempdat:=copy(dat,1,length(tempdat)-2);
   if CalcCheckSum(tempdat)=tempchecksum then begin
    isCorrectChecksum:=true;
    checkdat:=tempdat;
   end else begin
    Trouble(GotBug('Bad checksum: "'+tempchecksum+'" in answer '+tempdat));
    checkdat:='';
   end;
  end else begin
   isCorrectChecksum:=true;
   checkdat:=tempdat;
  end;
 end;
 function CheckData(cid:Integer; dat:String; var ans:String):Boolean;
 var res:Boolean;tempdat:String;
 begin
  res:=false;
  ans:='';tempdat:='';
  if IsEmptyStr(dat) then begin
   if cid<>cm_HostIsOk then Trouble(GotBug('Answer is empty')) else begin
    res:=true;
   end;
  end else begin
   if StrFetch(dat,1)='?' then Trouble(GotBug('Bad answer : "'+dat+'" on comand '+I7043.CmdTab.Acronym[cid])) else begin
    if isCorrectChecksum(dat,tempdat) then begin
     if (cid=cm_ReadDigitalOut) or (cid=cm_SetDigitalOut) or (cid=cm_SetDoOneChanl) then begin
       if StrFetch(tempdat,1)='>' then begin
         ans:=tempdat;
         res:=true;
       end else Trouble(GotBug('Bad answer : "'+tempdat+'" on comand '+I7043.CmdTab.Acronym[cid]));
     end else begin
       if StrFetch(tempdat,1)='!' then begin
         ans:=tempdat;
         res:=true;
       end else Trouble(GotBug('Bad answer : "'+tempdat+'" on comand '+I7043.CmdTab.Acronym[cid]));
     end;
    end;
   end;
  end;
  CheckData:=res;
  tempdat:='';
 end;
 procedure I7043_OnCommand(cid:Integer; dat:String);
 var v:Real; ans,hexadr:String;
 begin
  ans:='';hexadr:='';
  if CheckData(cid,dat,ans) then begin
   if cid=cm_SetModuleConf then begin
    hexadr:=copy(ans,2,2);
    I7043.RS485.UnitId:=val('$'+hexadr);
    bNul(iSetTag(I7043.ADDRESS.tag,I7043.RS485.UnitId));
    I7043_EnableCmdId(cid,False);
    I7043_EnableCmdId(cm_ReadModuleConf,True);
   end else
   // Read Module Configuration
   if cid=cm_ReadModuleConf then begin
    UpdateModuleConfig(Copy(ans,2));
    PollEnable(cid,bit_poll_cm_ReadModuleConf);
   end else
   // Read Firmware Version
   if cid=cm_ReadFirmwarVer then begin
    UpdateModuleVersion(Copy(ans,4));
    PollEnable(cid,bit_poll_cm_ReadFirmwarVer);
   end else
   // Read Module Name
   if cid=cm_ReadModuleName then begin
    UpdateModuleName(Copy(ans,4));
    PollEnable(cid,bit_poll_cm_ReadModuleName);
   end else
   // Set Module Name
   if cid=cm_SetModuleName then begin
    I7043_EnableCmdId(cid,False);
    I7043_EnableCmdId(cm_ReadModuleName,True);
   end else
   // Read Digital Outputs
   if cid=cm_ReadDigitalOut then begin
     UpdateDigitalOutput(copy(ans,2));
     UpdateDigitalOutputs;
     PollEnable(cid,bit_poll_cm_ReadDigitalOut);
   end else
   // Host is Ok notification
   if (cid=cm_HostIsOk) then begin
   end else
   // Set Digital Outputs or Set One Digital Output
   if ((cid=cm_SetDigitalOut) or (cid=cm_SetDoOneChanl)) then begin
     I7043_EnableCmdId(cid,False);
     I7043_EnableCmdId(cm_ReadDigitalOut,True);
   end else
   // Set Power On Digital Outputs
   if cid=cm_SetPwrOnDigOut then begin
     I7043_EnableCmdId(cid,False);
     I7043_EnableCmdId(cm_ReadPwrOnDigOut,True);
   end else
   // Read Power On Digital Outputs
   if cid=cm_ReadPwrOnDigOut then begin
    UpdatePODigitalOutput(copy(ans,4));
    PollEnable(cid,bit_poll_cm_ReadPwrOnDigOut);
   end else
   // Set WatchDog Digital Outputs
   if cid=cm_SetWDTDigOut then begin
     I7043_EnableCmdId(cid,False);
     I7043_EnableCmdId(cm_ReadWDTDigOut,True);
   end else
   // Read WatchDog Digital Outputs
   if cid=cm_ReadWDTDigOut then begin
    UpdateWTDigitalOutput(copy(ans,4));
    PollEnable(cid,bit_poll_cm_ReadWDTDigOut);
   end else
   // Read WatchDog Status
   if cid=cm_ReadWDTStatus then begin
    UpdateWDStatus(copy(ans,4));
    PollEnable(cid,bit_poll_cm_ReadWDTStatus);
   end else
   // Read WatchDog Timeout
   if cid=cm_ReadWDTimeOut then begin
    UpdateWDTimeout(copy(ans,4));
    PollEnable(cid,bit_poll_cm_ReadWDTimeOut);
   end else
   // Set WatchDog Status
   if cid=cm_SetWDTStatus then begin
     I7043_EnableCmdId(cid,False);
     I7043_EnableCmdId(cm_ReadWDTStatus,True);
     I7043_EnableCmdId(cm_ReadWDTimeOut,True);
   end else
   // Reset WatchDog Status
   if cid=cm_RstWDTStatus then begin
     I7043_EnableCmdId(cid,False);
     I7043_EnableCmdId(cm_ReadWDTStatus,True);
     I7043_EnableCmdId(cm_ReadWDTimeOut,True);
   end;
  end;
  ans:='';hexadr:='';
 end;
 {
 WatchDog AutoReconnect
 }
 procedure I7043_WDAutoReconnect(digo:Integer);
 begin
  DevPostCmdLocal('@RstWDStatus');
  DevPostCmdLocal('@SetDO '+HexW(digo));
  DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7043.WDTIMEOUT.tag))+' 1');
 end;
 {
 Update State of Device
 }
 procedure UpdateState;
 begin
  if I7043.Simulator then bNul(iSetTag(I7043.STATE.tag,stt_Simulator))
  else begin
   if iGetTag(I7043.WDSTATUS.tag)=2 then begin 
    bNul(iSetTag(I7043.STATE.tag,stt_WatchDog));
    UpdateDO(do_state,time,stt_WatchDog);
    Problem('Watchdog in device '+DevName);
    if I7043.WDReconnect then I7043_WDAutoReconnect(I7043.ReserveDO);
   end else if iGetTag(I7043.RX.tag)>0 then begin
    bNul(iSetTag(I7043.STATE.tag,stt_Work));
    UpdateDO(do_state,time,stt_Work);
   end;
  end;
 end;
 {
 DIM Update tag
 }
 procedure UpdateDimTag(tag:Integer);
 var v:Real;
 begin
  if DIM_IsServerMode then
  if (TypeTag(tag)>0) then begin
   v:=GetStampOfTag(tag,_NaN);
   if not IsNan(v) then I7043_FillTag(tag,v);
   DIM_UpdateTag(tag,'');
  end;
 end;
 procedure DimRefreshTag(var R:TTagRef);
 var tag:Integer; v:Real;
 begin
  tag:=R.tag; v:=GetStampOfTag(tag,_NaN);
  if not IsNaN(v) then if ShouldRefresh(R.val,v)>0 then UpdateDimTag(tag);
 end;
 Procedure I7043_DIM_UpdateTag;
 begin
  if DIM_IsServerMode then begin
   // Enforce update each 10 sec
   if SysTimer_Pulse(10000)>0 then I7043_FillTags(-MaxReal);
   DimRefreshTag(I7043.POLL);
   DimRefreshTag(I7043.RX);
   DimRefreshTag(I7043.TX);
   DimRefreshTag(I7043.STATE);
   DimRefreshTag(I7043.DOALL);
   DimRefreshTag(I7043.DODATA);
   DimRefreshTag(I7043.DO1);
   DimRefreshTag(I7043.DO2);
   DimRefreshTag(I7043.DO3);
   DimRefreshTag(I7043.DO4);
   DimRefreshTag(I7043.DO5);
   DimRefreshTag(I7043.DO6);
   DimRefreshTag(I7043.DO7);
   DimRefreshTag(I7043.DO8);
   DimRefreshTag(I7043.DO9);
   DimRefreshTag(I7043.DO10);
   DimRefreshTag(I7043.DO11);
   DimRefreshTag(I7043.DO12);
   DimRefreshTag(I7043.DO13);
   DimRefreshTag(I7043.DO14);
   DimRefreshTag(I7043.DO15);
   DimRefreshTag(I7043.DO16);
   DimRefreshTag(I7043.PODO);
   DimRefreshTag(I7043.WTDO);
   DimRefreshTag(I7043.NAME);
   DimRefreshTag(I7043.VERSION);
   DimRefreshTag(I7043.ADDRESS);
   DimRefreshTag(I7043.BAUDRATE);
   DimRefreshTag(I7043.CHECKSUM);
   DimRefreshTag(I7043.PARITY);
   DimRefreshTag(I7043.PODOSET);
   DimRefreshTag(I7043.PODOREAD);
   DimRefreshTag(I7043.WTDOSET);
   DimRefreshTag(I7043.WTDOREAD);
   DimRefreshTag(I7043.WDTIMEOUT);
   DimRefreshTag(I7043.WDSTATUS);
   DimRefreshTag(I7043.WDENDIS);
  end;
 end;
 {
 Finalize I7043 device.
 }
 procedure I7043_Free;
 begin
 end;
 {
 Data handler on @RS485.Reply event. Process reply comes from RS485 device.
 }
 procedure I7043_OnReply(ref,cid,tim,port,uid:Integer; dat:String);
 var p:Integer;
 begin
  if not IsValidCmdNum(cid) then Trouble(GotBug('Bad reply command '+Str(cid))) else
  if (port<>I7043.RS485.Poll.port) then Trouble(GotBug('Bad reply port '+Str(port))) else
  if (uid<>I7043.RS485.Poll.uid) then Trouble(GotBug('Bad reply unit id '+Str(uid))) else
  if (cid<>I7043.RS485.Poll.cid) then Trouble(GotBug('Bad reply command id '+Str(cid))) else
  if (ref<>I7043.RS485.Poll.ref) then Trouble(GotBug('Bad reply device '+RefInfo(ref,'Name'))) else
  if Length(dat)=0 then Trouble(GotBug('Bad reply answer')) else begin
  IncSummRate(I7043.RS485.Poll.Summ.Rx,I7043.RS485.Poll.Rate.Rx);
   p:=pos('$$',dat);
   dat:=copy(dat,p+2);
   I7043_OnCommand(cid,dat);
  end;
 end;
 {
 Prepare data for send
 }
 Procedure I7043_PrepareData(cid:Integer; var dat:String);
 begin
  dat:=I7043.CmdTab.Acronym[cid];
  if Length(I7043.CmdTab.OpData[cid])>0 then begin
   dat:=dat+I7043.CmdTab.OpData[cid];
   I7043.CmdTab.OpData[cid]:='';
  end;
  if cid=cm_HostIsOk then begin
   I7043_EnableCmdId(cm_HostIsOk,false);
  end;
  if I7043.isChecksum then dat:=dat+CalcCheckSum(dat);
  dat:=RS485_insert_le(dat,le_req);
 end;
 {
 I7043 Polling
 }
 Procedure I7043_Poll;
  Procedure PollRS485Proxy(cid:Integer; var num:Integer);
  var dev,ref,tot,port,uid:Integer; dat:String;
  begin
   dat:='';
   dev:=devTheProxy; ref:=devMySelf; tot:=I7043.RS485.Timeout; port:=I7043.RS485.Port; uid:=I7043.RS485.UnitId;
   if cid=cm_HostIsOk then tot:=0;
   I7043_PrepareData(cid,dat);
   if DevPost(dev,RS485_proxy_poll('@RS485.Poll',ref,cid,tot,port,uid,dat))>0 then begin
    if DebugFlagEnabled(dfViewExp) then ViewExp('COM: '+RS485_proxy_nice('@RS485.Poll',ref,cid,tot,port,uid,dat,32));
    AssignRS485Poll(dev,cid,mSecNow,port,uid,dat);
    IncSummRate(I7043.RS485.Poll.Summ.Tx,I7043.RS485.Poll.Rate.Tx);
   end else begin
    Trouble(GotBug('Fail to send command '+Str(cid)));
    ClearRS485Poll;
   end;
   if cid=cm_HostIsOk then ClearRS485Poll;
   num:=cid;
   dat:='';
  end;
 begin
  if IsPortOpened and not DIM_IsClientMode then begin
   if IsValidCmdNum(I7043.RS485.Poll.cid) then begin
    //
    // Request in progress, waiting @RS485Proxy.Reply/@RS485Proxy.Refuse/@RS485Proxy.Timeout.
    // Handle Deadline if was no responce for too long time: repeat polling again.
    //
    if iGetTag(I7043.POLL.tag)<>0 then begin
     if (mSecNow>I7043.RS485.Poll.tim+I7043.RS485.Deadline) then begin
      Trouble(GotBug('Deadline detected, repeat polling again...'));
      PollRS485Proxy(I7043.RS485.Poll.cid,I7043.CmdTab.Num);
     end;
    end else if iGetTag(I7043.POLL.tag)=0 then begin
     UpdateDo(do_state,time,stt_Disable);
     bNul(iSetTag(I7043.STATE.tag,stt_Disable));
    end;
   end else begin
    //
    // If request is cleared, send new @RS485Proxy.Poll request by timer.
    //
    if iGetTag(I7043.POLL.tag)<>0 then begin
     if (mSecNow>=I7043.RS485.Poll.tim+I7043.RS485.Polling) then begin
      PollRS485Proxy(NextEnabledCmdNum(I7043.CmdTab.Num),I7043.CmdTab.Num);
     end;
    end else begin 
     UpdateDo(do_state,time,stt_Disable);
     bNul(iSetTag(I7043.STATE.tag,stt_Disable));
    end;
   end;
   //
   // Update Poll Rate.
   //
   if SysTimer_Pulse(1000)>0 then begin
    bNul(iSetTag(I7043.RX.tag,I7043.RS485.Poll.Rate.Rx));
    bNul(iSetTag(I7043.TX.tag,I7043.RS485.Poll.Rate.Tx));
    UpdateDo(do_rx,time,I7043.RS485.Poll.Rate.Rx);
    UpdateDo(do_tx,time,I7043.RS485.Poll.Rate.Tx);
    Details('PollRate: Rx='+Str(I7043.RS485.Poll.Rate.Rx)
                   +'  Tx='+Str(I7043.RS485.Poll.Rate.Tx));
    ClearRS485Rate;
   end;
   if (I7043.HostIsOkPeriod>0) and (iGetTag(I7043.WDENDIS.tag)>0) then begin
    if SysTimer_Pulse(I7043.HostIsOkPeriod)>0 then begin
     I7043_EnableCmdId(cm_HostIsOk,true);
     I7043.ReserveDO:=iGetTag(I7043.DODATA.tag);
    end;
   end;
   
  end else if not IsPortOpened then Trouble('Port closed');
 end;
 //
 // Menu Initialize
 //
 procedure MenuToolsStarter;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Команда "Инструменты"... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Просмотр справочной информации (HELP)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@BrowseHelp');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Открыть окно: '+ParamStr('CONSOLE '+DevName));
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@OpenConsole');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: нормальный  (3)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 3');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: ввод-вывод (15)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 15');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Режим отладки консоли: детальный  (31)');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@DebugFlags 31');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Загрузить параметры из INI файла');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@LoadIni');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Сохранить параметры в  INI файле');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SaveIni');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_TOOLS'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuBaudrate;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Выберите Baudrate... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('1200');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'4003'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('2400');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'4004'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('4800');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'4005'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('9600');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'4006'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('19200');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'4007'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('38400');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'4008'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('57600');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'4009'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddInputLn('115200');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetCfg '+HexB(I7043.RS485.UnitId)+'400A'+HexB(I7043.DataFormat));
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_BAUDRATE'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure MenuDigitalOutput;
 var n:Integer;
 begin
  if EditStateReady then begin
   //////////////////////////////////////////
   n:=0+EditAddOpening('Выберите действие... ');
   n:=n+EditAddInputLn('Что выбираете:');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Выключить всё');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetDO 0000');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Включить всё');
   n:=n+EditAddConfirm(EditGetLastInputLn);
   n:=n+EditAddCommand('@SetDO FFFF');
   //////////////////////////////////////////
   n:=n+EditAddInputLn('Считать состояние каналов');
   n:=n+EditAddConfirm('');
   n:=n+EditAddCommand('@ReadDO');
   //////////////////////////////////////////
   n:=n+EditAddSetting('@set ListBox.Font Size:12\Style:[]');
   n:=n+EditAddSetting(SetFormUnderSensorLeftBottom(ClickParams('')));
   //////////////////////////////////////////
   n:=n+EditAddClosing('MenuList',EditGetUID('MENU_DO'),'');
   if (n>0) then Problem('Error initializing MenuList!');
  end else Problem('Cannot edit right now!');
 end;
 procedure EditMenuCustomHandler(id,msg:String;tag:integer;value:string); //
 begin
  if EditStateDone then
  if not IsEmptyStr(id) then begin
   // Menu handler (before confirmation).
   if EditTestResultName(id) then begin
    if EditTestResultCode(mr_OK) then begin
     if LooksLikeCommand(EditGetMenuListSelectedCommand) then
     if IsEmptyStr(EditGetMenuListSelectedConfirm) then begin
      DevPostCmdLocal(EditGetMenuListSelectedCommand);
     end else begin
      EditStartConfirmCommand('Вы действительно хотите выполнить:'+LineEnding+
                              LineEnding+UpCaseStr(EditGetMenuListSelectedConfirm)+' ?'+
                              LineEnding+LineEnding+'Эта операция требует вашего подтверждения!'+
                              LineEnding+LineEnding+msg,
                              id+'::Confirm',EditGetMenuListSelectedCommand,EditGetSettingText);
     end;
    if tag<>0 then begin
     if typetag(tag)=1 then bNul(iSetTag(tag,val(value)));
     if typetag(tag)=2 then bNul(rSetTag(tag,rval(value)));
     if typetag(tag)=3 then bNul(sSetTag(tag,value));
    end;
    end else
    if EditTestResultCode(mr_Cancel) or EditTestResultCode(mr_Close) then begin
     if tag<>0 then begin
      if typetag(tag)=1 then bNul(iSetTag(tag,val(value)));
      if typetag(tag)=2 then bNul(rSetTag(tag,rval(value)));
      if typetag(tag)=3 then bNul(sSetTag(tag,value));
     end;
    end;
    if not EditStateBusy then EditReset;
   end;
   // Menu handler (after confirmation).
   EditMessageBoxDialogExDefaultHandler(id+'::Confirm');
  end;
 end;
 {
 Start Edit Data
 }
 procedure StartEditDataStrEx(Name,Caption,Data,Params:String);
 var n:Integer;
 begin
  if EditStateReady then begin
   n:=0+EditAddOpening('Введите '+Name);
   n:=n+EditAddInputLn(Caption+'|'+Data);
   if (StdEditTagFont<>'') then n:=n+EditAddSetting('@set StringGrid.Font '+StdEditTagFont);
   if (Length(Params)>0) then n:=n+EditAddText(Params,'','@>!');
   n:=n+EditAddClosing('StringGridEdit',EditGetUID(Name),'');
   if (n>0) then Problem('Error starting edit '+Name);
  end else Problem('Could not start edit tag '+Name);
  Data:='';
 end;
 {
 Check if data editing done.
 }
 function CheckEditData(Name:String; var newData:String):Boolean;
 var s:String;
 begin
  s:='';
  CheckEditData:=False;
  if EditStateDone then
   if EditTestResultName(EditGetUID(Name)) then begin
    if EditTestResultCode(mr_OK) then begin
     s:=ExtractWordDelims(2,Edit('?ans 1'),Dump('|'));
     newData:=s;
     CheckEditData:=True;
     EditReset;
    end;
   end;
  s:='';
 end;
 {
 Handle Enableng poll menu
 }
 function HandlePollEnable(act:boolean):boolean;
 var pollen:Integer; handle:boolean;
 begin
  handle:=false;
  if act then begin
   pollen:=iGetTag(I7043.POLL.tag);
   if iGetTag(I7043.POLL_NOTIFY.tag)=1 then begin
    DevPostCmdLocal('@Poll '+str(iGetTag(I7043.POLL.tag)));
    bNul(iSetTag(I7043.POLL_NOTIFY.tag,0));
    handle:=true;
   end else 
   if iGetTag(I7043.POLL_NOTIFY.tag)=2 then begin
    bNul(iSetTag(I7043.POLL_NOTIFY.tag,0));
    bNul(iSetTag(I7043.POLL.tag,pollen));
    handle:=true;
   end;
  end;
  pollen:=0;
  HandlePollEnable:=handle;
 end;
 {
 GUI Handler to process user input...
 }
 procedure I7043_GUI_Poll;
 var s:String; ClickCurve,i:Integer;
 begin
  s:='';
  DIM_GuiClickBuff:='';
  {
  Handle user mouse/keyboard clicks...
  ClickWhat=(cw_Nothing,cw_MouseDown,cw_MouseUp,cw_MouseMove,cw_KeyDown,cw_KeyUp,cw_MouseWheel,...)
  ClickButton=(VK_LBUTTON,VK_RBUTTON,VK_CANCEL,VK_MBUTTON,VK_BACK,VK_TAB,VK_CLEAR,VK_RETURN,...)
  }
  if ClickWhat<>0 then
  repeat
   //
   // Copy GUI click to DIM buffer for remote execution.
   //
   DIM_GuiClickBuff:=DIM_GuiClickCopy;
   {
   Handle MouseDown/KeyDown
   }
   if (ClickWhat=cw_MouseDown) or (ClickWhat=cw_KeyDown) then begin
    {
    Handle Left mouse button click
    }
    if (ClickButton=VK_LBUTTON) then begin
     {
     Click is local
     }
     if ClickIsLocal then begin
      {
      Click Tags
      }
      if ClickTag<>0 then begin
       if ClickTag=I7043.ADDRESS.tag then begin
        StartEditDataStrEx('адрес_устройства','Адрес',str(iGetTag(I7043.ADDRESS.tag)),SetFormUnderSensorLeftBottom(ClickParams('')));
       end else
       if ClickTag=I7043.BAUDRATE.tag then begin
        MenuBaudrate;
       end else
       if ClickTag=I7043.NAME.tag then begin
        StartEditDataStrEx('имя_устройства','Имя',sGetTag(I7043.NAME.tag),SetFormUnderSensorLeftBottom(ClickParams('')));
       end else
       if ClickTag=I7043.CHECKSUM.tag then begin
        if iGetTag(I7043.CHECKSUM.tag)=0 
        then EditStartConfirmCommand('Включить Checksum?'+LineEnding+LineEnding+
        'Для изменения необходимо соединить контакты *INIT и GND, в противном случае - '+
        'дальнейшее подтверждение приведет к ошибке',EditGetUID('Enable_CHK'),'@SetCfg '+
        HexB(iGetTag(I7043.ADDRESS.tag))+'40'+HexB(iGetTag(I7043.BAUDRATE.tag))+
        '40',SetFormUnderSensorLeftBottom(ClickParams('')));
        if iGetTag(I7043.CHECKSUM.tag)=1
        then EditStartConfirmCommand('Выключить Checksum?'+LineEnding+LineEnding+
        'Для изменения необходимо соединить контакты *INIT и GND, в противном случае - '+
        'дальнейшее подтверждение приведет к ошибке',EditGetUID('Disable_CHK'),'@SetCfg '+
        HexB(iGetTag(I7043.ADDRESS.tag))+'40'+HexB(iGetTag(I7043.BAUDRATE.tag))+
        '00',SetFormUnderSensorLeftBottom(ClickParams('')));
       end else
       if ClickTag=I7043.DODATA.tag then begin
        for i:=1 to 16 do begin
         if IsSameText(ClickSensor,'I7043.DO'+str(i)) then begin
          if iGetTagBitState(I7043.DODATA.tag,(i-1))
          then DevPostCmdLocal('@SetChDO '+str(i)+' 0')
          else DevPostCmdLocal('@SetChDO '+str(i)+' 1');
         end else
         if IsSameText(ClickSensor,ReadIni('tagPrefix')+'.DO'+str(i)) then begin
          if iGetTagBitState(I7043.DODATA.tag,(i-1))
          then DevPostCmdLocal('@SetChDO '+str(i)+' 0')
          else DevPostCmdLocal('@SetChDO '+str(i)+' 1');
         end;
        end;
       end else
       if ClickTag=I7043.DO1.tag then begin
        if iGetTag(I7043.DO1.tag)=0 then DevPostCmdLocal('@SetChDO 1 1') else DevPostCmdLocal('@SetChDO 1 0');
       end else
       if ClickTag=I7043.DO2.tag then begin
        if iGetTag(I7043.DO2.tag)=0 then DevPostCmdLocal('@SetChDO 2 1') else DevPostCmdLocal('@SetChDO 2 0');
       end else
       if ClickTag=I7043.DO3.tag then begin
        if iGetTag(I7043.DO3.tag)=0 then DevPostCmdLocal('@SetChDO 3 1') else DevPostCmdLocal('@SetChDO 3 0');
       end else
       if ClickTag=I7043.DO4.tag then begin
        if iGetTag(I7043.DO4.tag)=0 then DevPostCmdLocal('@SetChDO 4 1') else DevPostCmdLocal('@SetChDO 4 0');
       end else
       if ClickTag=I7043.DO5.tag then begin
        if iGetTag(I7043.DO5.tag)=0 then DevPostCmdLocal('@SetChDO 5 1') else DevPostCmdLocal('@SetChDO 5 0');
       end else
       if ClickTag=I7043.DO6.tag then begin
        if iGetTag(I7043.DO6.tag)=0 then DevPostCmdLocal('@SetChDO 6 1') else DevPostCmdLocal('@SetChDO 6 0');
       end else
       if ClickTag=I7043.DO7.tag then begin
        if iGetTag(I7043.DO7.tag)=0 then DevPostCmdLocal('@SetChDO 7 1') else DevPostCmdLocal('@SetChDO 7 0');
       end else
       if ClickTag=I7043.DO8.tag then begin
        if iGetTag(I7043.DO8.tag)=0 then DevPostCmdLocal('@SetChDO 8 1') else DevPostCmdLocal('@SetChDO 8 0');
       end else
       if ClickTag=I7043.DO9.tag then begin
        if iGetTag(I7043.DO9.tag)=0 then DevPostCmdLocal('@SetChDO 9 1') else DevPostCmdLocal('@SetChDO 9 0');
       end else
       if ClickTag=I7043.DO10.tag then begin
        if iGetTag(I7043.DO10.tag)=0 then DevPostCmdLocal('@SetChDO 10 1') else DevPostCmdLocal('@SetChDO 10 0');
       end else
       if ClickTag=I7043.DO11.tag then begin
        if iGetTag(I7043.DO11.tag)=0 then DevPostCmdLocal('@SetChDO 11 1') else DevPostCmdLocal('@SetChDO 11 0');
       end else
       if ClickTag=I7043.DO12.tag then begin
        if iGetTag(I7043.DO12.tag)=0 then DevPostCmdLocal('@SetChDO 12 1') else DevPostCmdLocal('@SetChDO 12 0');
       end else
       if ClickTag=I7043.DO13.tag then begin
        if iGetTag(I7043.DO13.tag)=0 then DevPostCmdLocal('@SetChDO 13 1') else DevPostCmdLocal('@SetChDO 13 0');
       end else
       if ClickTag=I7043.DO14.tag then begin
        if iGetTag(I7043.DO14.tag)=0 then DevPostCmdLocal('@SetChDO 14 1') else DevPostCmdLocal('@SetChDO 14 0');
       end else
       if ClickTag=I7043.DO15.tag then begin
        if iGetTag(I7043.DO15.tag)=0 then DevPostCmdLocal('@SetChDO 15 1') else DevPostCmdLocal('@SetChDO 15 0');
       end else
       if ClickTag=I7043.DO16.tag then begin
        if iGetTag(I7043.DO16.tag)=0 then DevPostCmdLocal('@SetChDO 16 1') else DevPostCmdLocal('@SetChDO 16 0');
       end else
       if ClickTag=I7043.DOALL.tag then begin
        bNul(iSetTag(I7043.DOALL.tag,1));
        MenuDigitalOutput;
       end else
       if ClickTag=I7043.PODOSET.tag then begin
        bNul(iSetTag(I7043.PODOSET.tag,1));
        DevPostCmdLocal('@SetPODO');
       end else
       if ClickTag=I7043.PODOREAD.tag then begin
        bNul(iSetTag(I7043.PODOREAD.tag,1));
        DevPostCmdLocal('@ReadPODO');
       end else
       if ClickTag=I7043.WTDOSET.tag then begin
        bNul(iSetTag(I7043.WTDOSET.tag,1));
        DevPostCmdLocal('@SetWTDO');
       end else
       if ClickTag=I7043.WTDOREAD.tag then begin
        bNul(iSetTag(I7043.WTDOREAD.tag,1));
        DevPostCmdLocal('@ReadWTDO');
       end else
       if ClickTag=I7043.POLL.tag then begin
        I7043.PollConfirm:=action('&'+ReadIni('tagPrefix')+'.POLL.ENABLE');
       end else
       if ClickTag=I7043.WDTIMEOUT.tag then begin
        StartEditTagEx(I7043.WDTIMEOUT.tag,'Введите Watchdog Timeout:',SetFormUnderSensorLeftBottom(ClickParams('')));
       end else
       if ClickTag=I7043.WDENDIS.tag then begin
        if iGetTag(I7043.WDENDIS.tag)=0 
        then DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7043.WDTIMEOUT.tag))+' 1')
        else DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7043.WDTIMEOUT.tag))+' 0');
       end else
       if ClickTag=I7043.WDSTATUS.tag then begin
        I7043_EnableCmdId(cm_RstWDTStatus,True);
       end;
      end;
     end;
     {
     Handle sensor clicks...
     }
     if IsSameText(ClickSensor,'HELP') then begin
      Cron('@Browse '+DaqFileRef(ReadIni('[DAQ] HelpFile'),'.htm'));
      bNul(Voice(snd_Click));
     end;
     if (ClickSensor='I7043.LABEL') then begin
      DevPostCmdLocal('@MenuTools');
     end;
     {
     Select Plot & Tab windows by curve...
     }
     ClickCurve:=RefFind('Curve '+ClickParams('Curve'));
     if IsRefCurve(ClickCurve) then begin
      iNul(WinSelectByCurve(ClickCurve,ClickCurve));
      bNul(Voice(snd_Wheel));
     end;
     {
     Console commands: @url_encoded_sensor ...
     }
     if LooksLikeCommand(ClickSensor) then begin
      DevSendCmdLocal(url_decode(ClickSensor));
      bNul(Voice(snd_Click));
     end;
     //
     // Handle remote clicks comes from DIM via @DimGuiClick message.
     // @DimGuiClick default handler decode and write events to FIFO,
     // so we can find it as clicks and can handle it in usual way.
     //
     if ClickIsRemote then begin
      //
      // Show time difference.
      //
      if DebugFlagEnabled(dfDetails) then
      Details('Remote Click Time Diff '+Str(mSecNow-rVal(ClickParams('When')))+' ms');
      //
      // Handle remote console commands...
      //
      s:=Dim_GuiConsoleRecv(DevName,'');
      if LooksLikeCommand(s) then DevSendCmdLocal(s);
     end;
    end;
    {
    Handle Right mouse button click
    }
    if (ClickButton=VK_RBUTTON) then begin
     SensorHelp(Url_Decode(ClickParams('Hint')));
    end;
   end;
  until (ClickRead=0);
  {
  Edit handling...
  }
  if EditStateDone then begin
   {
   Warning,Information.
   }
   if EditTestResultName('Warning') then EditReset;
   if EditTestResultName('Information') then EditReset;
   EditMenuDefaultHandler(EditGetUID('MENU_TOOLS'));
   EditMenuCustomHandler(EditGetUID('MENU_BAUDRATE'),'Для изменения необходимо '+
   'соединить контакты *INIT и GND, в противном случае - '+
   'дальнейшее подтверждение приведет к ошибке',0,'');
   EditMenuCustomHandler(EditGetUID('MENU_DO'),'',I7043.DOALL.tag,'00');
   EditMessageBoxDialogExDefaultHandler(EditGetUID('Enable_CHK'));
   EditMessageBoxDialogExDefaultHandler(EditGetUID('Disable_CHK'));
   if CheckEditData('адрес_устройства',s) then begin
    if not IsNan(rVal(s))
    then DevPostCmdLocal('@SetCfg '+HexB(val(s))+'40'+HexB(iGetTag(I7043.BAUDRATE.tag))+HexB(I7043.DataFormat))
    else Warning('Invalid input!');
   end;
   if CheckEditData('имя_устройства',s) then begin
    DevPostCmdLocal('@SetName '+s);
   end;
   if CheckEditTag(I7043.WDTIMEOUT.tag,s) then begin
    UpdateTag(I7043.WDTIMEOUT.tag,s,0,25.5);
    DevPostCmdLocal('@SetWDStatus '+str(rGetTag(I7043.WDTIMEOUT.tag))+' '+str(iGetTag(I7043.WDENDIS.tag)));
   end;
  end;
  if EditStateDone then begin
   Problem('Unhandled edit detected!');
   EditReset;
  end else
  if EditStateError then begin
   Problem('Edit error detected!');
   EditReset;
  end;
  {
  Handle Polling Enable
  }
  if HandlePollEnable(I7043.PollConfirm) then I7043.PollConfirm:=False;
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  if Val(ReadIni('CustomIniAutoSave'))=1 then iNul(CustomIniRW('W','',2));
  I7043_ClearStrings;
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  StdIn_SetScripts('','');
  StdIn_SetTimeouts(0,0,0,MaxInt);
  iNul(ClickFilter(ClickFilter(1)));
  iNul(ClickAwaker(ClickAwaker(1)));
  InitNetRS485;
  I7043_Init;
  if Val(ReadIni('CustomIniAutoLoad'))=1 then iNul(CustomIniRw('R','',2));
   I7043.StartPoll:=iGetTag(I7043.Poll.tag);
   DevSendCmdLocal('@Poll '+str(255));
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  I7043_Clear;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  I7043_GUI_Poll;
  if I7043.CmdTab.PollCnt=1 then begin
   bNul(iSetTag(I7043.POLL.tag,I7043.StartPoll));
   I7043.CmdTab.PollCnt:=2;
  end else
  if I7043.CmdTab.PollCnt=maxint then I7043.CmdTab.PollCnt:=2;
  if mSecNow-FixmSecNow>I7043.RS485.DelayOnStart then
  if not DIM_IsClientMode then begin
   if not I7043.Simulator then begin
    I7043_Poll;
    UpdateState;
   end;
  end;
  I7043_DIM_UpdateTag;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg,cdm_arg_nocode,s,dat:String; cmdid,i,tag,ref,cid,tim,port,uid:Integer; r:Real;
 begin
  if DebugFlagEnabled(dfViewImp) then ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  s:='';cmd:='';arg:='';cdm_arg_nocode:='';dat:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   
   {
   @RS485.Reply
   }
   if (cmdid = cmd_RsReply) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then I7043_OnReply(ref,cid,tim,port,uid,dat)
    else Trouble(GotBug('Bad '+cmd+' format'));
    ClearRS485Poll;
    Data:='';
   end else
   {
   @RS485.Refuse
   }
   if (cmdid = cmd_RsRefuse) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Trouble(GotBug(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,0)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_state,time,stt_Refused); bNul(iSetTag(I7043.STATE.tag,stt_Refused));
    ClearRS485Poll;
    Data:='';
   end else
   {
   @RS485.Timeout
   }
   if (cmdid = cmd_RsTimeout) then begin
    if RS485_proxy_reply(cmd,arg,ref,cid,tim,port,uid,dat)
    then Problem(GotBug(RS485_proxy_nice(cmd,ref,cid,tim,port,uid,dat,64)))
    else Trouble(GotBug(cmd+' '+arg));
    UpdateDo(do_state,time,stt_TimeOut); bNul(iSetTag(I7043.STATE.tag,stt_TimeOut));
    ClearRS485Poll;
    Data:='';
   end else
   {
   @DimTagUpdate tag
   }
   if (cmdid=cmd_DimTagUpdate) then begin
    if DIM_IsClientMode and not DIM_IsServerMode then begin
     tag:=FindTag(Trim(arg));
     if tag=I7043.STATE.tag  then UpdateDo(do_state ,  time,iGetTag(tag));
     if tag=I7043.DODATA.tag then UpdateDo(do_dodata,  time,iGetTag(tag));
     if tag=I7043.PODO.tag   then UpdateDo(do_podo  ,  time,iGetTag(tag));
     if tag=I7043.WTDO.tag   then UpdateDo(do_wtdo  ,  time,iGetTag(tag));
     if tag=I7043.RX.tag     then UpdateDo(do_rx    ,  time,iGetTag(tag));
     if tag=I7043.TX.tag     then UpdateDo(do_tx    ,  time,iGetTag(tag));
    end;
   end else
   {
   @DIMCMDMY
   }
   if (cmdid=cmd_DimCmdMy) then begin
    //декодируем из base64
    cdm_arg_nocode:=base64_decode(arg);
    // Избавляемся от символ NUL (\x00).
    cdm_arg_nocode:=Trim(cdm_arg_nocode);
    if LooksLikeCommand(cdm_arg_nocode) then DevPostCmdLocal(cdm_arg_nocode);
    Success('@DIMCMDMY='+cmd+' arg<'+cdm_arg_nocode+'>');
   end else
   {
   @Poll flags (flags)
   }
   if (cmdid = cmd_Poll) then begin
    i:=val(arg);
    if i<=255 then begin
     if not DIM_IsClientMode then begin
      bNul(iSetTag(I7043.POLL.tag,i));
      I7043_EnablePoll(i);
     end else if DIM_IsClientMode then begin
      DevPostCmdLocal('@Remote @Poll '+arg);
     end;
    end else Trouble('Unrecognize parametr in command @Poll');
   end else
   {
   @SetCfg NNTTCCFF
   }
   if (cmdid = cmd_SetCfg) then begin
    if length(arg)=8 then begin
     s:='$'+copy(arg,1,2);
     if not isNan(rval(s)) then begin
      s:=copy(arg,3,2);
      if s='40' then begin
       s:='$'+copy(arg,5,2);
       if ((val(s)>3) or (val(s)<10)) then begin
        s:=copy(arg,7,2);
        if ((s='40') or (s='00')) then begin
         if not DIM_IsClientMode then begin
           if I7043.Simulator then begin
            s:=Copy(arg,1,2);      
            s:='$'+s;
            I7043.RS485.UnitId:=val(s);
            bNul(iSetTag(I7043.ADDRESS.tag,I7043.RS485.UnitId));
            s:='$'+Copy(arg,5,2);
            bNul(iSetTag(I7043.BAUDRATE.tag,val(s)));
            s:='$'+Copy(arg,7,2);
            bNul(iSetTagBitState(I7043.CHECKSUM.tag,0,isbit(val(s),6)));
           end else begin
            I7043.CmdTab.OpData[cm_SetModuleConf]:=arg;
            I7043_EnableCmdId(cm_SetModuleConf,true);
           end;
         end else if DIM_IsClientMode then begin
          DevPostCmdLocal('@Remote @SetCfg '+arg);
         end;
        end else Trouble('Unrecognize "Data Format" in command @SetCfg');
       end else Trouble('Unrecognize "Baudrate" in command @SetCfg');
      end else Trouble('Unrecognize "Type" in command @SetCfg');
     end else Trouble('Unrecognize "Address" in command @SetCfg');
    end else Trouble('Unrecognize parametr in command @SetCfg');
   end else
   {
   @ReadCfg
   }
   if (cmdid = cmd_ReadCfg) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator 
     then Success('Command @ReadCfg complete in simulator mode')
     else I7043_EnableCmdId(cm_ReadModuleConf,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadCfg');
    end;
   end else
   {
   @ReadVer
   }
   if (cmdid = cmd_ReadVer) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then bNul(sSetTag(I7043.VERSION.tag,'SimVer'))
     else I7043_EnableCmdId(cm_ReadFirmwarVer,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadVer');
    end;
   end else
   {
   @ReadName
   }
   if (cmdid = cmd_ReadName) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then Success('Command @ReadName complete in simulator mode')
     else I7043_EnableCmdId(cm_ReadModuleName,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadName');
    end;
   end else
   {
   @SetName
   }
   if (cmdid = cmd_SetName) then begin
    if length(arg)>6 then arg:=copy(arg,1,6);
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then bNul(sSetTag(I7043.NAME.tag,arg))
     else begin
      I7043.CmdTab.OpData[cm_SetModuleName]:=arg;
      I7043_EnableCmdId(cm_SetModuleName,true);
     end;
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @SetName '+arg);
    end;
   end else
   {
   @ReadDO
   }
   if (cmdid = cmd_ReadDO) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then Success('Command @ReadDO complete in simulator mode')
     else I7043_EnableCmdId(cm_ReadDigitalOut,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadDO');
    end;
   end else
   {
   @SetDO BBDD
   }
   if (cmdid = cmd_SetDO) then begin
    if length(arg)=4 then begin
     if not isNan(rVal('$'+arg)) then begin
      if val('$'+arg)>65535 then arg:='FFFF';
      if val('$'+arg)<0 then arg:='0000'
     end else Trouble('Unrecognize parametr in command @SetDO');
     if not DIM_IsClientMode then begin
      if I7043.Simulator then begin
       bNul(iSetTag(I7043.DODATA.tag,val('$'+arg)));
       UpdateDigitalOutputs;
      end else begin
       I7043.CmdTab.OpData[cm_SetDigitalOut]:=arg;
       I7043_EnableCmdId(cm_SetDigitalOut,true);
      end;
     end else if DIM_IsClientMode then begin
      DevPostCmdLocal('@Remote @SetDO '+arg);
     end;
    end else Trouble('Unrecognize parametr in command @SetDO');
    bNul(iSetTag(I7043.DOALL.tag,0));
   end else
   {
   @SetChDO Channel Enabled (Channel - Channel Numaber; Enabled - 0 or 1)
   }
   if (cmdid = cmd_SetChDO) then begin
    if wordcount(arg)=2 then begin
     if not isNan(rval(extractword(1,arg))) then begin
      arg:=str(trunc(rval(extractword(1,arg))))+' '+extractword(2,arg);
      if val(extractword(1,arg))>16 then arg:='16 '+extractword(2,arg);
      if val(extractword(1,arg))<1  then arg:='1 '+extractword(2,arg);
      if not isNan(rval(extractword(2,arg))) then begin
       arg:=extractword(1,arg)+' '+str(trunc(rval(extractword(2,arg))));
       if val(extractword(2,arg))>1 then arg:=extractword(1,arg)+' 1';
       if val(extractword(2,arg))<0 then arg:=extractword(1,arg)+' 0';
       if not DIM_IsClientMode then begin
        I7043.ChNumber:=val(extractword(1,arg));
        I7043.ChState :=val(extractword(2,arg))>0;
        if I7043.Simulator then begin 
         bNul(iSetTagBitState(I7043.DODATA.tag,I7043.ChNumber-1,I7043.ChState));
         UpdateDigitalOutputs;
        end else begin
          if I7043.ChState then begin  
           if (ge(I7043.ChNumber,1) and le(I7043.ChNumber,8)) then s:='A'+str(I7043.ChNumber-1)+'01' else
           if (ge(I7043.ChNumber,9) and le(I7043.ChNumber,16)) then s:='B'+str(I7043.ChNumber-9)+'01' else
           Problem('Invalid Channel Number');
          end else begin
           if (ge(I7043.ChNumber,1) and le(I7043.ChNumber,8)) then s:='A'+str(I7043.ChNumber-1)+'00' else
           if (ge(I7043.ChNumber,9) and le(I7043.ChNumber,16)) then s:='B'+str(I7043.ChNumber-9)+'00' else
           Problem('Invalid Channel Number');
          end;
         I7043.CmdTab.OpData[cm_SetDoOneChanl]:=s;
         I7043_EnableCmdId(cm_SetDoOneChanl,true);
        end;
       end else if DIM_IsClientMode then begin
        DevPostCmdLocal('@Remote @SetChDO '+arg);
       end;
      end else Trouble('Unrecognize "Enabled" in command @SetChDO');
     end else Trouble('Unrecognize "Channel" in command @SetChDO');
    end else Trouble('Unrecognize parameter in command @SetChDO');
   end else
   {
   @SetPODO
   }
   if (cmdid = cmd_SetPODO) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then bNul(iSetTag(I7043.PODO.tag,iGetTag(I7043.DODATA.tag)))
     else begin
      I7043_EnableCmdId(cm_SetPwrOnDigOut,true);
     end;
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @SetPODO');
    end;
    bNul(iSetTag(I7043.PODOSET.tag,0));
   end else
   {
   @ReadPODO
   }
   if (cmdid = cmd_ReadPODO) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then Success('Command @ReadPODO complete in simulator mode')
     else I7043_EnableCmdId(cm_ReadPwrOnDigOut,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadPODO');
    end;
    bNul(iSetTag(I7043.PODOREAD.tag,0));
   end else
   {
   @SetWTDO
   }
   if (cmdid = cmd_SetWTDO) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then bNul(iSetTag(I7043.WTDO.tag,iGetTag(I7043.DODATA.tag)))
     else begin
      I7043_EnableCmdId(cm_SetWDTDigOut,true);
     end;
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @SetWTDO');
    end;
    bNul(iSetTag(I7043.WTDOSET.tag,0));
   end else
   {
   @ReadWTDO
   }
   if (cmdid = cmd_ReadWTDO) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then Success('Command @ReadWTDO complete in simulator mode')
     else I7043_EnableCmdId(cm_ReadWDTDigOut,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadWTDO');
    end;
    bNul(iSetTag(I7043.WTDOREAD.tag,0));
   end else
   {
   @ReadWDStatus
   }
   if (cmdid = cmd_ReadWDStatus) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then Success('Command @ReadWDStatus complete in simulator mode')
     else I7043_EnableCmdId(cm_ReadWDTStatus,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadWDStatus');
    end;
   end else
   {
   @ReadWDTimeout
   }
   if (cmdid = cmd_ReadWDTimeout) then begin
    if not DIM_IsClientMode then begin
     if I7043.Simulator
     then Success('Command @ReadWDTimeout complete in simulator mode')
     else I7043_EnableCmdId(cm_ReadWDTimeOut,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @ReadWDTimeout');
    end;
   end else
   {
   @SetWDStatus TimeOut Enabled (Timeout - time in 0 - 25.5 s, Enabled - 0 or 1)
   }
   if (cmdid = cmd_SetWDStatus) then begin
    if WordCount(arg)=2 then begin
     if not isNan(rVal(extractword(1,arg))) then begin
      if length(str(frac(rVal(extractword(1,arg)))))>3
      then arg:=copy(extractword(1,arg),1,(pos('.',extractword(1,arg))+1))+' '+extractword(2,arg);
      if rVal(extractword(1,arg))>25.5 then arg:='25.5 '+extractword(2,arg);
      if rVal(extractword(1,arg))<0    then arg:='0 '+extractword(2,arg);
      if not isNan(rval(extractword(2,arg))) then begin
       arg:=extractword(1,arg)+' '+str(trunc(rval(extractword(2,arg))));
       if val(extractword(2,arg))>=1 then arg:=extractword(1,arg)+' 1';
       if val(extractword(2,arg))<=0 then arg:=extractword(1,arg)+' 0';
        if not DIM_IsClientMode then begin
         bNul(iSetTag(I7043.WDENDIS.tag,val(extractword(2,arg))));
         I7043.EnableWD:=val(extractword(2,arg));
         bNul(rSetTag(I7043.WDTIMEOUT.tag,rval(extractword(1,arg))));
         I7043.TimeoutWD:=rval(extractword(1,arg));
         if I7043.Simulator
         then bNul(iSetTag(I7043.WDSTATUS.tag,val(extractword(2,arg))))
         else begin
          I7043.CmdTab.OpData[cm_SetWDTStatus]:=str(I7043.EnableWD)+HexB(trunc(I7043.TimeoutWD*10));
          I7043_EnableCmdId(cm_SetWDTStatus,true);
         end;
        end else if DIM_IsClientMode then begin
         DevPostCmdLocal('@Remote @SetWDStatus '+arg);
        end;
      end else Trouble('Unrecognize "Enabled" in command @SetWDStatus');
     end else Trouble('Unrecognize "Timeout" in command @SetWDStatus');
    end else Trouble('Unrecognize parameter in command @SetWDStatus');
   end else
   {
   @RstWDStatus
   }
   if (cmdid = cmd_RstWDStatus) then begin
    if not DIM_IsClientMode then begin
     bNul(iSetTag(I7043.WDENDIS.tag,0));
     if I7043.Simulator
     then bNul(iSetTag(I7043.WDSTATUS.tag,0))
     else I7043_EnableCmdId(cm_RstWDTStatus,true);
    end else if DIM_IsClientMode then begin
     DevPostCmdLocal('@Remote @RstWDStatus');
    end;
   end else
   {
   @MenuTools
   }
   if (cmdid=cmd_MenuTools) then begin
    MenuToolsStarter;
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  s:='';cmd:='';arg:='';cdm_arg_nocode:='';dat:='';
  Data:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{<== Please never change this code ***}
{***************************************************}
