 {
 ***********************************************************************
 PFEIFFER Proxy (Master).
 ***********************************************************************
 Next text uses by @Help command. Do not remove it.
 ***********************************************************************
[@Help]
|StdIn Command list: "@cmd=arg" or "@cmd arg"
|********************************************************
| @Port port decl
|  Open logical PFEIFFER port to connect device nodes.
|  port (1..16) is logical № (i.e. port identifier).
|  decl is port detail declaration, looks like that:
|   @Port 2 com port 8
|   @Port 2 com port 8 baudrate 9600 parity even databits 8 stopbits 1
|   See help on function pipe_init() for details.
| @PortPollRates Rx Tx
| @PortByteRates Rx Tx
| @PortPollCounters Rx Tx
| @PortByteCounters Rx Tx
| @PortErrorRates Rx Tx Ex
| @PortErrorCounters Rx Tx Ex
| @ZeroPortCounters n - Zero all stat. counters on port n (0 mean all).
|  Set polls/bypes/errors counter/rate tag names of type Integer or Real
|  to count errors and rate (per second) on this port:
|  Rx - Receiver polls/bytes/errors (errors is bad request, no answer).
|  Tx - Transmitter polls/bytes/errors (errors is fail to send answer).
|  Ex - PFEIFFER Exceptions              (errors is bad address or data).
| @View n
|  Print information about specified port n (0 mean all).
| @Pfeiffer.Poll ref cid tot port adr par len dat
|  ref  = sender device reference or device name
|  cid  = command id (user defined parameter)  
|  tot  = timeout, ms: 1..MaxInt
|  port = port number: 1..16
|  adr  = unit id: 1..999
|  par  = function id: see device protocol.  
|  len  = data length.  
|  dat  = data unit;
|  Reply to sender may be one of:
|   @Pfeiffer.Reply   ref cid tim port adr par ans - reply   successfully with answer data ans
|   @Pfeiffer.TimeOut ref cid tim port adr par req - timeout on request with original data req
|   @Pfeiffer.Refuse  ref cid tim port adr par msg - refuse  request with error message msg
|  where:
|   ref is &PfeifferProxy reference; tim is response time, ms.
|   cid,port,adr,par should be the same as in request (par also may include exception bit).
|  Example:
|   @Pfeiffer.Poll &Demo.Driver 45 500 8 12 732 6 $$=?         Request to poll from &Demo.Driver command 732
|   @Pfeiffer.Reply &PfeifferProxy 45 16 8 12 732 6 $$100020   Success reply    send to &Demo.Driver
|   @Pfeiffer.Timeout &PfeifferProxy 45 16 8 12 732 $$=?       Timeout detected send to &Demo.Driver
|   @Pfeiffer.Refuse &PfeifferProxy 45 Port closed 1           Refuse notifier  send to &Demo.Driver
| @TimeGap port gap
|  Time gap (time of silence) between i/o transactions
|  port = PfeifferProxy logical port
|  gap  = time gap, ms
| @Pfeiffer.Reply ...
| @Pfeiffer.Refuse ...
| @Pfeiffer.TimeOut ...
|  Uses just for testing and debugging only.
|********************************************************
[]
 }
 
{
[Compiler.Options]            ; Size of table for ... 
Compiler.dtabmax = 1024*40    ; -Data segment ( number of virtual machine data items )
Compiler.stabmax = 1024*16    ; -Strings      ( number of available string var+const )
Compiler.dtabmin = 1024*4     ; Min stack  space at start ( error if free space less )
Compiler.stabmin = 1024*1     ; Min string space at start ( error if free space less )
[]
}
program PfeifferProxy;           { PFEIFFER Proxy (Master)          }
const
 {------------------------------}{ Declare uses program constants:  }
 {$I _con_StdLibrary}            { Include all Standard constants,  }
 {------------------------------}{ And add User defined constants:  }
 {$I _con_NetPfeiff}             { Include AK2 TSS constants,       }
 MaxPortNum = 10;                { Max.number of logical ports      }
 MaxItemNum = 256;               { Max.number of items in fifo      }
 MaxBuffer  = 8192;              { Maximum size of buffer to read   }
 RatePeriod = 1000;              { Statistics poll period           }

type
 {------------------------------}{ Declare uses program types:      }
 {$I _typ_StdLibrary}            { Include all Standard types,      }
 {------------------------------}{ And add User defined types:      }
 TMBIORec   = record             { Pfeiffer I/O record              }
  ref       : Integer;           { Reference of sender device       }
  tot       : Integer;           { Timeout, ms                      }
  cid       : Integer;           { Command Id                       }
  adr       : Integer;           { Unit Id                          }
  par       : Integer;           { Function Id                      }
  dat       : String;            { PDU data; PDU=(par+dat)          }
  len       : Integer;           { Application Data Unit            }
  adu       : String;            { Application Data Unit            }
  tim       : Real;              { Time stamp                       }
 end;                            {                                  }
 
var
 {------------------------------}{ Declare uses program variables:  }
 {$I _var_StdLibrary}            { Include all Standard variables,  }
 {------------------------------}{ And add User defined variables:  }
 {$I _var_NetPfeiff}             { NetLibrary variables             }
 pfeiffer   : record             { PFEIFFER related data            }
  Port      : array[1..MaxPortNum] of record { COM ports            }
   Decl     : String;            { Port declaration                 }
   Pipe     : Integer;           { COM port pipe                    }
   Req      : TMBIORec;          { Request to port                  }
   Ans      : TMBIORec;          { Answer from port                 }
   Last     : record             { Last poll data                   }
    Poll    : Real;              { Last poll time, ms               }
    Rate    : Real;              { Last rate time, ms               }
   end;                          {                                  }
   Stat     : record             { Traffic Statistics               }
    Rate,                        { Rate                             }
    Count   : record             { Count                            }
     Bugs,                       { Errors                           }
     Bytes,                      { Bytes                            }
     Polls  : record             { Polls                            }
      Rx    : TTagRef;           { Received                         }
      Tx    : TTagRef;           { Transmitted                      }
      Ex    : TTagRef;           { Exceptions, for bugs only        }
     end;                        {                                  }
    end;                         {                                  }
   end;
   FIFO     : record             { FIFO buffer                      }
    Count   : Integer;           { Count of items                   }
    Head    : Integer;           { Head index                       }
    Item    : array[0..MaxItemNum] of TMBIORec; { Data items        }
   end;                          {                                  }
   TimeGap  : Integer;           { Gap between poll transactions,ms }
  end;
 end;
 cmd_View            : Integer;  { Command @View                    }
 cmd_Reset           : Integer;  { Command @Reset                   }
 cmd_TimeGap         : Integer;  { Command @TimeGap                 }
 cmd_Port            : Integer;  { Command @Port                    }
 cmd_PortErrorCounters :Integer; { Command @PortErrorCounters       }
 cmd_PortErrorRates  : Integer;  { Command @PortErrorRates          }
 cmd_PortByteCounters : Integer; { Command @PortByteCounters        }
 cmd_PortByteRates    : Integer; { Command @PortByteRates           }
 cmd_PortPollCounters : Integer; { Command @PortPollCounters        }
 cmd_PortPollRates   : Integer;  { Command @PortPollRates           }
 cmd_ZeroPortCounters : Integer; { Command @ZeroPortCounters        }

 {------------------------------}{ Declare procedures & functions:  }
 {$I _fun_StdLibrary}            { Include all Standard functions,  }
 {------------------------------}{ And add User defined functions:  }
 {$I _fun_NetPfeiff}             { Include AK2 TSS functions        }
 
 {
 Check port is good to use.
 }
 function pfeiffer_port_ok(port:Integer):Boolean;
 begin
  pfeiffer_port_ok:=(1<=port) and (port<=MaxPortNum);
 end;
 {
 pfeiffer routine uses to send refuse message and fix error.
 }
 procedure pfeiffer_refuse(tag,code,ref,cid,tot,port,adr,par:Integer; msg:String);
 begin
  if ref<>0 then DevSendCmd(ref,pfeiffer_proxy_nice('@Pfeiffer.Refuse',devMySelf,cid,tot,port,adr,par,0,msg,0));
  pfeiffer_fixerror(tag,code,msg);
 end;
 {
 Pfeiffer I/O record routines. D=Destination, S=Source.
 }
 procedure MBIORec_Assign(var D:TMBIORec; ref,cid,tot,adr,par,len:Integer; dat,adu:String;tim:Real);
 begin
  D.ref:=ref; D.cid:=cid; D.tot:=tot; D.adr:=adr; D.par:=par; D.len:=len; D.dat:=dat; D.adu:=adu; D.tim:=tim;
 end;
 procedure MBIORec_Clear(var D:TMBIORec);
 begin
  MBIORec_Assign(D,0,0,0,0,0,0,'','',0);
 end;
 {
 Zero statistics for specified port (0=all ports).
 }
 procedure pfeiffer_zero_stat(port:Integer);
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do pfeiffer_zero_stat(port);
  end else
  if pfeiffer_port_ok(port) then begin
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Bugs.Rx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Bugs.Tx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Bugs.Ex.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Bytes.Rx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Bytes.Tx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Bytes.Ex.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Polls.Rx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Polls.Tx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Rate.Polls.Ex.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Bugs.Rx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Bugs.Ex.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Bytes.Rx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Bytes.Tx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Bytes.Ex.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Polls.Rx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Polls.Tx.tag,0));
   bNul(pfeiffer_set_tag(pfeiffer.Port[port].Stat.Count.Polls.Ex.tag,0));
   pfeiffer.Port[port].Stat.Rate.Bugs.Rx.val:=0;
   pfeiffer.Port[port].Stat.Rate.Bugs.Tx.val:=0;
   pfeiffer.Port[port].Stat.Rate.Bugs.Ex.val:=0;
   pfeiffer.Port[port].Stat.Rate.Bytes.Rx.val:=0;
   pfeiffer.Port[port].Stat.Rate.Bytes.Tx.val:=0;
   pfeiffer.Port[port].Stat.Rate.Bytes.Ex.val:=0;
   pfeiffer.Port[port].Stat.Rate.Polls.Rx.val:=0;
   pfeiffer.Port[port].Stat.Rate.Polls.Tx.val:=0;
   pfeiffer.Port[port].Stat.Rate.Polls.Ex.val:=0;
   pfeiffer.Port[port].Stat.Count.Bugs.Rx.val:=0;
   pfeiffer.Port[port].Stat.Count.Bugs.Tx.val:=0;
   pfeiffer.Port[port].Stat.Count.Bugs.Ex.val:=0;
   pfeiffer.Port[port].Stat.Count.Bytes.Rx.val:=0;
   pfeiffer.Port[port].Stat.Count.Bytes.Tx.val:=0;
   pfeiffer.Port[port].Stat.Count.Bytes.Ex.val:=0;
   pfeiffer.Port[port].Stat.Count.Polls.Rx.val:=0;
   pfeiffer.Port[port].Stat.Count.Polls.Tx.val:=0;
   pfeiffer.Port[port].Stat.Count.Polls.Ex.val:=0;
  end;
 end;
 {
 Clear pfeiffer variables for specified port (0=all ports).
 }
 procedure pfeiffer_clear(port:Integer);
 var item:Integer;
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do pfeiffer_clear(port);
  end else
  if pfeiffer_port_ok(port) then begin
   pfeiffer.Port[port].Decl:='';
   pfeiffer.Port[port].Pipe:=0;
   pfeiffer.Port[port].Last.Poll:=0;
   pfeiffer.Port[port].Last.Rate:=0;
   MBIORec_Clear(pfeiffer.Port[port].Req);
   MBIORec_Clear(pfeiffer.Port[port].Ans);
   pfeiffer.Port[port].Stat.Rate.Bugs.Rx.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Bugs.Tx.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Bugs.Ex.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Bytes.Rx.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Bytes.Tx.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Bytes.Ex.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Polls.Rx.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Polls.Tx.tag:=0;
   pfeiffer.Port[port].Stat.Rate.Polls.Ex.tag:=0;
   pfeiffer.Port[port].Stat.Count.Bugs.Rx.tag:=0;
   pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag:=0;
   pfeiffer.Port[port].Stat.Count.Bugs.Ex.tag:=0;
   pfeiffer.Port[port].Stat.Count.Bytes.Rx.tag:=0;
   pfeiffer.Port[port].Stat.Count.Bytes.Tx.tag:=0;
   pfeiffer.Port[port].Stat.Count.Bytes.Ex.tag:=0;
   pfeiffer.Port[port].Stat.Count.Polls.Rx.tag:=0;
   pfeiffer.Port[port].Stat.Count.Polls.Tx.tag:=0;
   pfeiffer.Port[port].Stat.Count.Polls.Ex.tag:=0;
   pfeiffer_zero_stat(port);
   pfeiffer.Port[port].Fifo.Count:=0;
   pfeiffer.Port[port].Fifo.Head:=0;
   for item:=0 to MaxItemNum do MBIORec_Clear(pfeiffer.Port[port].Fifo.Item[item]);
   pfeiffer.Port[port].TimeGap:=0;
  end;
 end;
 {
 Close specified port (0=all ports).
 }
 procedure pfeiffer_close(port:Integer);
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do pfeiffer_close(port);
  end else
  if pfeiffer_port_ok(port) then begin
   if pfeiffer.Port[port].Pipe<>0 then
   if pipe_free(pfeiffer.Port[port].Pipe)
   then Success('PORT CLOSE SUCCESS: '+Str(port)
               +' '+pfeiffer.Port[port].Decl)
   else Trouble('PORT CLOSE FAILURE: '+Str(port)
               +' '+pfeiffer.Port[port].Decl);
   pfeiffer_clear(port);
  end;
 end;
 {
 Open PFEIFFER port
 arg = Port Decl
 arg = 1    port 502 client localhost
 arg = 2    port 1 baudrate 9600 parity even databits 8 stopbits 1
 arg = 3    port 2 baudrate 9600 parity even databits 8 stopbits 1
 }
 function pfeiffer_open(arg:String):Integer;
 var Port,Pipe:Integer; Decl:String;
 begin
  Port:=Val(ExtractWord(1,arg));
  Decl:=Trim(SkipWords(1,arg));
  if pfeiffer_port_ok(Port) and not IsEmptyStr(Decl) then begin
   Pipe:=pipe_init(Decl);
   if Pipe<>0 then begin
    pfeiffer_close(Port);
    pfeiffer.Port[Port].Decl:=Decl;
    pfeiffer.Port[Port].Pipe:=Pipe;
   end else Port:=0;
  end else Port:=0;
  pfeiffer_open:=Port;
  Decl:='';
 end;
 {
 Initialize pfeiffer variables.
 }
 procedure pfeiffer_init;
 begin
  pfeiffer_clear(0);
 end;
 {
 Finalize pfeiffer variables.
 }
 procedure pfeiffer_free;
 begin
  pfeiffer_close(0);
  pfeiffer_clear(0);
 end;
 { 
 Reset pfeiffer to initial state.
 }
 procedure pfeiffer_reset;
 begin
  pfeiffer_free;
  pfeiffer_init;
 end;
 {
 Calculate FIFO item index.
 }
 function pfeiffer_item_index(i,L,H:Integer):Integer;
 begin
  if i<L then i:=L;
  pfeiffer_item_index:=L+(i-L) mod (H-L+1);
 end;
 {
 Put message to pfeiffer FIFO. Return 1=OK, 0=FAIL.
 }
 function pfeiffer_fifo_poke(ref,cid,tot,port,adr,par:Integer; dat:String;len:integer; tim:Real):Integer;
 var i,item,poke:Integer;
 begin
  poke:=0;
  if (ref<>0) then if (tot>0) then
  if pfeiffer_port_ok(port) then begin
   for i:=0 to pfeiffer.Port[port].FIFO.Count-1 do if poke=0 then begin
    item:=pfeiffer_item_index(pfeiffer.Port[port].FIFO.Head+i,0,MaxItemNum);
    if pfeiffer.Port[port].FIFO.Item[item].ref = ref then begin
     MBIORec_Assign(pfeiffer.Port[port].FIFO.Item[item],ref,cid,tot,adr,par,len,dat,'',tim);
     poke:=1;
    end;
   end;
   if poke=0 then
   if pfeiffer.Port[port].FIFO.Count<=MaxItemNum then begin
    item:=pfeiffer_item_index(pfeiffer.Port[port].FIFO.Head+pfeiffer.Port[port].FIFO.Count,0,MaxItemNum);
    MBIORec_Assign(pfeiffer.Port[port].FIFO.Item[item],ref,cid,tot,adr,par,len,dat,'',tim);
    pfeiffer.Port[port].FIFO.Count:=pfeiffer.Port[port].FIFO.Count+1;
    poke:=1;
   end;
  end;
  pfeiffer_fifo_poke:=poke;
 end;
 {
 Get message from pfeiffer FIFO.
 }
 function pfeiffer_fifo_peek(var ref,cid,tot:Integer; port:Integer; var adr,par:Integer; var dat:String;var len: Integer;var tim:Real):Integer;
 var i,item,peek:Integer;
 begin
  peek:=0;
  if pfeiffer_port_ok(port) then
  if pfeiffer.Port[port].FIFO.Count>0 then begin
   item:=pfeiffer_item_index(pfeiffer.Port[port].FIFO.Head,0,MaxItemNum);
   pfeiffer.Port[port].FIFO.Head:=pfeiffer_item_index(item+1,0,MaxItemNum);
   pfeiffer.Port[port].FIFO.Count:=pfeiffer.Port[port].FIFO.Count-1;
   ref:=pfeiffer.Port[port].FIFO.Item[item].ref;
   cid:=pfeiffer.Port[port].FIFO.Item[item].cid;
   tot:=pfeiffer.Port[port].FIFO.Item[item].tot;
   adr:=pfeiffer.Port[port].FIFO.Item[item].adr;
   par:=pfeiffer.Port[port].FIFO.Item[item].par;
   dat:=pfeiffer.Port[port].FIFO.Item[item].dat;
   len:=pfeiffer.Port[port].FIFO.Item[item].len;
   tim:=pfeiffer.Port[port].FIFO.Item[item].tim;
   peek:=1;
  end;
  if peek=0 then begin ref:=0; cid:=0; tot:=0; adr:=0; par:=0; dat:=''; len:=0; tim:=0; end;
  pfeiffer_fifo_peek:=peek;
 end;
 {
 View specified port (0=all ports)
 }
 procedure pfeiffer_view(port:Integer);
 var item,i,ref,cid,tot,adr,par,len:Integer; dat:String; tim:Real;
 begin
  if port=0 then begin
   for port:=1 to MaxPortNum do pfeiffer_view(port);
  end else
  if pfeiffer_port_ok(port) then
  if pfeiffer.Port[port].Pipe<>0 then begin
   Success('@Port '+Str(port)
          +' '
          +' '+pfeiffer.Port[port].Decl);
   Success(' Bugs Rate/Count'
          +' Rx='+Str(pfeiffer.Port[port].Stat.Rate.Bugs.Rx.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Bugs.Rx.val)
          +' Tx='+Str(pfeiffer.Port[port].Stat.Rate.Bugs.Tx.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Bugs.Tx.val)
          +' Ex='+Str(pfeiffer.Port[port].Stat.Rate.Bugs.Ex.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Bugs.Ex.val));
   Success(' Byte Rate/Count'
          +' Rx='+Str(pfeiffer.Port[port].Stat.Rate.Bytes.Rx.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Bytes.Rx.val)
          +' Tx='+Str(pfeiffer.Port[port].Stat.Rate.Bytes.Tx.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Bytes.Tx.val)
          +' Ex='+Str(pfeiffer.Port[port].Stat.Rate.Bytes.Ex.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Bytes.Ex.val));
   Success(' Poll Rate/Count'
          +' Rx='+Str(pfeiffer.Port[port].Stat.Rate.Polls.Rx.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Polls.Rx.val)
          +' Tx='+Str(pfeiffer.Port[port].Stat.Rate.Polls.Tx.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Polls.Tx.val)
          +' Ex='+Str(pfeiffer.Port[port].Stat.Rate.Polls.Ex.val)
          +'/'+Str(pfeiffer.Port[port].Stat.Count.Polls.Ex.val));
   Success(' TimeGap '+Str(pfeiffer.Port[port].TimeGap)+' ms');
   Success(' FIFO.Count '+Str(pfeiffer.Port[port].FIFO.Count));
   Success(' FIFO.Head  '+Str(pfeiffer.Port[port].FIFO.Head));
   for i:=0 to pfeiffer.Port[port].FIFO.Count-1 do begin
    item:=pfeiffer_item_index(pfeiffer.Port[port].FIFO.Head+i,0,MaxItemNum);
    ref:=pfeiffer.Port[port].FIFO.Item[item].ref;
    cid:=pfeiffer.Port[port].FIFO.Item[item].cid;
    tot:=pfeiffer.Port[port].FIFO.Item[item].tot;
    adr:=pfeiffer.Port[port].FIFO.Item[item].adr;
    par:=pfeiffer.Port[port].FIFO.Item[item].par;
    dat:=pfeiffer.Port[port].FIFO.Item[item].dat;
    len:=pfeiffer.Port[port].FIFO.Item[item].len;
    tim:=pfeiffer.Port[port].FIFO.Item[item].tim;
    Success(pfeiffer_proxy_nice(' FIFO['+Str(i)+']:',ref,cid,tot,port,adr,par,len,dat,64)+' '+Str(tim));
   end;
  end;
  dat:='';
 end;
 {
 Poll pfeiffer pipe
 }
 procedure pfeiffer_poll;
 var port,pipe,sid,ref,cid,tot,tim,adr,par,len,pdulen1,pdulen2:Integer;
     ms,dt,reqtim:Real; dat,raw,adu,action:String; acceptable:Boolean;
  procedure CalcRate(rtag:Integer; ctag:Integer; var cval:Real; dt:Real);
  var c:Real;
  begin
   if dt>0 then begin
    c:=pfeiffer_get_tag(ctag,0);
    bNul(pfeiffer_set_tag(rtag,1000*(c-cval)/dt));
    cval:=c;
   end;
  end;
  procedure ClearPoll(port:Integer; ms:Real; sid:Integer);
  begin
   if pfeiffer_port_ok(port) then begin
    MBIORec_Clear(pfeiffer.Port[port].Req);
    MBIORec_Clear(pfeiffer.Port[port].Ans);
    pfeiffer.Port[port].Last.Poll:=ms;
   end;
   if pipe_ref(sid)<>0 then begin
    bNul(pipe_txclear(sid));
    bNul(pipe_rxclear(sid));
   end;
  end;
  procedure Response(ref:Integer; msg:String);
  begin
   if DebugFlagEnabled(dfViewExp) then ViewExp(str(port)+' > '+msg);
   DevSendCmd(ref,msg);  
  end;
 begin
  {
  Poll pfeiffer ports: PFEIFFER client.
  }
  ms:=mSecNow;
  dat:=''; raw:=''; adu:='';
  for port:=1 to MaxPortNum do begin
   pipe:=pfeiffer.Port[port].Pipe;
   if pipe<>0 then if pipe_connected(pipe)>0 then begin
    sid:=pipe_stream(pipe,0);
    if pipe_connected(sid)=1 then begin
     if pfeiffer.Port[port].Req.ref=0 then begin
      // Create and sent new request from FIFO
      if ms-pfeiffer.Port[port].Last.Poll>=pfeiffer.Port[port].TimeGap then
      if pfeiffer_fifo_peek(ref,cid,tot,port,adr,par,dat,len,reqtim)<>0 then begin
       ClearPoll(port,ms,sid);
       adu:=pfeiffer_encode_adu(adr,par,len,dat);
       dat:=copy(dat,3,Length(dat));
       MBIORec_Assign(pfeiffer.Port[port].Req,ref,cid,tot,adr,par,len,dat,adu,ms);
       MBIORec_Assign(pfeiffer.Port[port].Ans,ref,cid,tot,adr,par,len,'','',0);
       if pipe_send(sid,pfeiffer.Port[port].Req.adu)=Length(pfeiffer.Port[port].Req.adu) then begin
        bNul(pfeiffer_inc_tag(pfeiffer.Port[port].Stat.Count.Polls.Tx.tag,1));
        bNul(pfeiffer_inc_tag(pfeiffer.Port[port].Stat.Count.Bytes.Tx.tag,Length(pfeiffer.Port[port].Req.adu)));
        if DebugFlagEnabled(dfDetails)
        then Details('Sent '+pfeiffer.Port[port].Req.adu+' bytes to '+str(port));
       end else begin
        pfeiffer_refuse(pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,adr,par,
                              str(port)+' fail to send');
        ClearPoll(port,ms,sid);
       end;
      end;
     end else begin
      // Read and process device answer
      if pipe_rxcount(sid)>0 then begin // Read data from port
       dat:=pipe_recv(sid,MaxBuffer);
       bNul(pfeiffer_inc_tag(pfeiffer.Port[port].Stat.Count.Bytes.Rx.tag,Length(dat)));
       if DebugFlagEnabled(dfViewImp) then ViewImp(str(port)+' < '+dat);
       pfeiffer.Port[port].Ans.adu:=pfeiffer.Port[port].Ans.adu+dat; dat:='';
       if Length(pfeiffer.Port[port].Ans.adu)>MaxBuffer then begin
        pfeiffer_refuse(pfeiffer.Port[port].Stat.Count.Bugs.Rx.tag,ErrorCode,pfeiffer.Port[port].Req.ref,
                      pfeiffer.Port[port].Req.cid,pfeiffer.Port[port].Req.tot,port,
                      pfeiffer.Port[port].Req.adr,pfeiffer.Port[port].Req.par,
                      str(port)+' Rx fifo over');
        ClearPoll(port,ms,sid);
       end;
      end;
      if pfeiffer.Port[port].Req.ref<>0 then // Process received data
      if Length(pfeiffer.Port[port].Ans.adu)>0 then begin
       pdulen1:=pfeiffer_decode_answer(pfeiffer.Port[port].Ans.adu,adr,par,len,dat);
       if pdulen1>0 then pdulen2:=pfeiffer_decode_pdu('A',par,dat,len) else pdulen2:=0;
       if DebugFlagEnabled(dfDetails) then Details('Decode ADU:'
                          +' l:'+Str(pdulen1)+'/'+Str(pdulen2)
                          +' u:'+Str(adr)+'/'+Str(pfeiffer.Port[port].Req.adr)
                          +' f:'+Str(par)+'/'+Str(pfeiffer.Port[port].Req.par)
                          +' '+dat);
       acceptable:=(pdulen1>0) and (pdulen2>0);

       if acceptable then begin
        Response(pfeiffer.Port[port].Req.ref,pfeiffer_proxy_poll('@Pfeiffer.Reply',devMySelf,
                 pfeiffer.Port[port].Req.cid,Round(ms-pfeiffer.Port[port].Req.tim),port,adr,par,len,dat));
        if pfeiffer_is_except(par)
        then bNul(pfeiffer_inc_tag(pfeiffer.Port[port].Stat.Count.Bugs.Ex.tag,1))
        else bNul(pfeiffer_inc_tag(pfeiffer.Port[port].Stat.Count.Polls.Rx.tag,1));
        ClearPoll(port,ms,sid);
       end;
      end;
      if pfeiffer.Port[port].Req.ref<>0 then // Check for TimeOut
      if ms>pfeiffer.Port[port].Req.tim+pfeiffer.Port[port].Req.tot then begin
       Response(pfeiffer.Port[port].Req.ref,pfeiffer_proxy_poll('@Pfeiffer.TimeOut',devMySelf,
                pfeiffer.Port[port].Req.cid,Round(ms-pfeiffer.Port[port].Req.tim),port,
                pfeiffer.Port[port].Req.adr,pfeiffer.Port[port].Req.par,len,pfeiffer.Port[port].Req.dat));
       bNul(pfeiffer_inc_tag(pfeiffer.Port[port].Stat.Count.Bugs.Rx.tag,1));
       ClearPoll(port,ms,sid);
      end;
     end;
    end;
    end;
  end;
  {
  Rate pfeiffer ports.
  }
  if SysTimer_Pulse(RatePeriod)>0 then begin
   ms:=mSecNow;
   for port:=1 to MaxPortNum do begin
    dt:=ms-pfeiffer.Port[port].Last.Rate;
    CalcRate(pfeiffer.Port[port].Stat.Rate.Polls.Rx.tag,
             pfeiffer.Port[port].Stat.Count.Polls.Rx.tag,
             pfeiffer.Port[port].Stat.Count.Polls.Rx.val,dt);
    CalcRate(pfeiffer.Port[port].Stat.Rate.Bytes.Rx.tag,
             pfeiffer.Port[port].Stat.Count.Bytes.Rx.tag,
             pfeiffer.Port[port].Stat.Count.Bytes.Rx.val,dt);
    CalcRate(pfeiffer.Port[port].Stat.Rate.Bugs.Rx.tag,
             pfeiffer.Port[port].Stat.Count.Bugs.Rx.tag,
             pfeiffer.Port[port].Stat.Count.Bugs.Rx.val,dt);
    CalcRate(pfeiffer.Port[port].Stat.Rate.Polls.Tx.tag,
             pfeiffer.Port[port].Stat.Count.Polls.Tx.tag,
             pfeiffer.Port[port].Stat.Count.Polls.Tx.val,dt);
    CalcRate(pfeiffer.Port[port].Stat.Rate.Bytes.Tx.tag,
             pfeiffer.Port[port].Stat.Count.Bytes.Tx.tag,
             pfeiffer.Port[port].Stat.Count.Bytes.Tx.val,dt);
    CalcRate(pfeiffer.Port[port].Stat.Rate.Bugs.Tx.tag,
             pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag,
             pfeiffer.Port[port].Stat.Count.Bugs.Tx.val,dt);
    CalcRate(pfeiffer.Port[port].Stat.Rate.Bugs.Ex.tag,
             pfeiffer.Port[port].Stat.Count.Bugs.Ex.tag,
             pfeiffer.Port[port].Stat.Count.Bugs.Ex.val,dt);
    pfeiffer.Port[port].Last.Rate:=ms;
   end;
  end;
  dat:=''; raw:=''; adu:='';
 end;
 {
 Clear user application strings...
 }
 procedure ClearApplication;
 begin
  ClearNetPfeiffer;
  pfeiffer_clear(0);
 end;
 {
 User application Initialization...
 }
 procedure InitApplication;
 begin
  InitNetPfeiffer;
  pfeiffer_init;
  StdIn_SetScripts('@StartupScript','');
  StdIn_SetTimeouts(0,0,MaxInt,0);
  cmd_View              := RegisterStdInCmd('@View',              '');
  cmd_Reset             := RegisterStdInCmd('@Reset',             '');
  cmd_TimeGap           := RegisterStdInCmd('@TimeGap',           '');
  cmd_Port              := RegisterStdInCmd('@Port',              '');
  cmd_PortErrorCounters := RegisterStdInCmd('@PortErrorCounters', '');
  cmd_PortErrorRates    := RegisterStdInCmd('@PortErrorRates',    '');
  cmd_PortByteCounters  := RegisterStdInCmd('@PortByteCounters',  '');
  cmd_PortByteRates     := RegisterStdInCmd('@PortByteRates',     '');
  cmd_PortPollCounters  := RegisterStdInCmd('@PortPollCounters',  '');
  cmd_PortPollRates     := RegisterStdInCmd('@PortPollRates',     '');
  cmd_ZeroPortCounters  := RegisterStdInCmd('@ZeroPortCounters',  '');
 end;
 {
 User application Finalization...
 }
 procedure FreeApplication;
 begin
  FreeNetPfeiffer;
  pfeiffer_free;
 end;
 {
 User application Polling...
 }
 procedure PollApplication;
 begin
  PollNetPfeiffer;
  pfeiffer_poll;
 end;
 {
 Process data coming from standard input...
 }
 procedure StdIn_Processor(var Data:String);
 var cmd,arg:String; cmdid:Integer; dat:String;
     ref,cid,tot,tim,port,adr,par,poke,peek,tag,len,p:Integer;
 begin
  ViewImp('CON: '+Data);
  {
  Handle "@cmd=arg" or "@cmd arg" commands:
  }
  cmd:='';
  arg:='';
  if GotCommandId(Data,cmd,arg,cmdid) then begin
   dat:='';
   {
   @Pfeiffer.Poll &EDUTC.EDUTC1.CTRL 29 250 8 1 720 3 =?
   }
   if (cmdid = cmd_NetPfeifferPoll) then begin
    cid:=0; tot:=0; port:=0; adr:=0; par:=0; len:=0;
    p:=Pos(' $$',arg);
    if p>1 then begin
     dat:=Copy(arg,p+1);
     arg:=Copy(arg,1,p-1);
     ref:=Val(ExtractWord(1,arg));
     if ref=0 then ref:=RefFind('Device '+ExtractWord(1,arg)); 
     if IsRefDevice(ref) then begin
      cid:=Val(ExtractWord(2,arg));
      tot:=Val(ExtractWord(3,arg));
      if tot>0 then begin
       port:=Val(ExtractWord(4,arg));
       if pfeiffer_port_ok(port) then begin
        if pipe_ref(pfeiffer.Port[port].Pipe)<>0 then begin
         adr:=val(ExtractWord(5,arg));
         if pfeiffer_addr_ok(adr) then begin
          par:=Val(ExtractWord(6,arg));
          len:=Val(ExtractWord(7,arg));
          if pfeiffer_decode_pdu('R',par,dat,len)>0 then begin
           poke:=pfeiffer_fifo_poke(ref,cid,tot,port,adr,par,dat,len,mSecNow);
           if poke=0 then 
            pfeiffer_refuse(pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,adr,par,'FIFO OVER');
           if poke>0 then
            if DebugFlagEnabled(dfDetails) then Details(Cmd+'='+Str(poke));
          end else 
           pfeiffer_refuse(pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,adr,par,'Bad Data '+dat);
         end else 
          pfeiffer_refuse(pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,adr,par,'Bad Unit '+ExtractWord(5,arg));
        end else 
         pfeiffer_refuse(pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag,ErrorCode,ref,cid,tot,port,adr,par,'Port closed '+ExtractWord(4,arg));
       end else pfeiffer_refuse(0,ErrorCode,ref,cid,tot,port,adr,par,'Bad Port '+ExtractWord(4,arg));
      end else pfeiffer_refuse(0,ErrorCode,ref,cid,tot,port,adr,par,'Bad Timeout '+ExtractWord(3,arg));
     end else pfeiffer_refuse(0,ErrorCode,ref,cid,tot,port,adr,par,'Bad Device '+ExtractWord(1,arg));
    end else pfeiffer_refuse(0,ErrorCode,ref,cid,tot,port,adr,par,'Bad Marker $$');
    Data:='';
   end else
   {
   @Pfeiffer.Refuse ...
   }
   if (cmdid = cmd_NetPfeifferRefuse) then begin
    if pfeiffer_proxy_reply(cmd,arg,ref,cid,tim,port,adr,par,len,dat)
    then Problem(pfeiffer_proxy_nice(cmd,ref,cid,tim,port,adr,par,len,dat,0))
    else Problem(cmd+' '+arg);
    Data:='';
   end else
   {
   @Pfeiffer.Reply ...
   }
   if (cmdid = cmd_NetPfeifferReply) then begin
    if pfeiffer_proxy_reply(cmd,arg,ref,cid,tim,port,adr,par,len,dat)
    then Success(pfeiffer_proxy_nice(cmd,ref,cid,tim,port,adr,par,len,dat,MaxInt))
    else Success(cmd+' '+arg);
    Data:='';
   end else
   {
   @Pfeiffer.TimeOut ...
   }
   if (cmdid = cmd_NetPfeifferTimeOut) then begin
    if pfeiffer_proxy_reply(cmd,arg,ref,cid,tim,port,adr,par,len,dat)
    then Problem(pfeiffer_proxy_nice(cmd,ref,cid,tim,port,adr,par,len,dat,MaxInt))
    else Problem(cmd+' '+arg);
    Data:='';
   end else
   {
   @View 1
   }
   if (cmdid = cmd_View) then begin
    pfeiffer_view(iValDef(arg,0));
    Data:='';
   end else
   {
   @Reset
   }
   if (cmdid = cmd_Reset) then begin
    pfeiffer_reset;
    Success(cmd);
    Data:='';
   end else
   {
   @TimeGap 1 10
   }
   if (cmdid = cmd_TimeGap) then begin
    port:=iValDef(ExtractWord(1,arg),-1);
    if pfeiffer_port_ok(port) then begin
     pfeiffer.Port[port].TimeGap:=iValDef(ExtractWord(2,arg),pfeiffer.Port[port].TimeGap);
    end;
    Data:='';
   end else
   {
   @Port 1 com port 502 client localhost
   @Port 2 com port 1 baudrate 9600 parity even databits 8 stopbits 1
   @Port 3 com port 2 baudrate 9600 parity even databits 8 stopbits 1
   @Port PortNum[1..16] Description[see pipe_init()]
   }
   if (cmdid = cmd_Port) then begin
    port:=pfeiffer_open(Trim(arg));
    if pfeiffer_port_ok(port)
    then Success(cmd+' '+Str(port)+' '+pfeiffer.Port[port].Decl)
    else Trouble('Failed: '+Trim(Data));
    Data:='';
   end else
   {
   @PortErrorCounters 1 Pfeiffer.BugsCount.Rx Pfeiffer.BugsCount.Tx Pfeiffer.BugsCount.Ex
   }
   if (cmdid = cmd_PortErrorCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if pfeiffer_port_ok(port) then begin
     pfeiffer.Port[port].Stat.Count.Bugs.Rx.tag:=FindTag(ExtractWord(2,arg));
     pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag:=FindTag(ExtractWord(3,arg));
     pfeiffer.Port[port].Stat.Count.Bugs.Ex.tag:=FindTag(ExtractWord(4,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Count.Bugs.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Count.Bugs.Tx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Count.Bugs.Ex.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortErrorRates 1 Pfeiffer.ErrorRates.Rx Pfeiffer.ErrorRates.Tx Pfeiffer.ErrorRates.Ex
   }
   if (cmdid = cmd_PortErrorRates) then begin
    port:=Val(ExtractWord(1,arg));
    if pfeiffer_port_ok(port) then begin
     pfeiffer.Port[port].Stat.Rate.Bugs.Rx.tag:=FindTag(ExtractWord(2,arg));
     pfeiffer.Port[port].Stat.Rate.Bugs.Tx.tag:=FindTag(ExtractWord(3,arg));
     pfeiffer.Port[port].Stat.Rate.Bugs.Ex.tag:=FindTag(ExtractWord(4,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Rate.Bugs.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Rate.Bugs.Tx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Rate.Bugs.Ex.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortByteCounters 1 Pfeiffer.Bytes.Rx Pfeiffer.Bytes.Tx
   }
   if (cmdid = cmd_PortByteCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if pfeiffer_port_ok(port) then begin
     pfeiffer.Port[port].Stat.Count.Bytes.Rx.tag:=FindTag(ExtractWord(2,arg));
     pfeiffer.Port[port].Stat.Count.Bytes.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Count.Bytes.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Count.Bytes.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortByteRates 1 Pfeiffer.ByteRates.Rx Pfeiffer.ByteRates.Tx
   }
   if (cmdid = cmd_PortByteRates) then begin
    port:=Val(ExtractWord(1,arg));
    if pfeiffer_port_ok(port) then begin
     pfeiffer.Port[port].Stat.Rate.Bytes.Rx.tag:=FindTag(ExtractWord(2,arg));
     pfeiffer.Port[port].Stat.Rate.Bytes.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Rate.Bytes.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Rate.Bytes.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortPollCounters 1 Pfeiffer.Polls.Rx Pfeiffer.Polls.Tx
   }
   if (cmdid = cmd_PortPollCounters) then begin
    port:=Val(ExtractWord(1,arg));
    if pfeiffer_port_ok(port) then begin
     pfeiffer.Port[port].Stat.Count.Polls.Rx.tag:=FindTag(ExtractWord(2,arg));
     pfeiffer.Port[port].Stat.Count.Polls.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Count.Polls.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Count.Polls.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @PortPollRates 1 Pfeiffer.PollRates.Rx Pfeiffer.PollRates.Tx
   }
   if (cmdid = cmd_PortPollRates) then begin
    port:=Val(ExtractWord(1,arg));
    if pfeiffer_port_ok(port) then begin
     pfeiffer.Port[port].Stat.Rate.Polls.Rx.tag:=FindTag(ExtractWord(2,arg));
     pfeiffer.Port[port].Stat.Rate.Polls.Tx.tag:=FindTag(ExtractWord(3,arg));
     Success(cmd+' '+Str(port)+' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Rate.Polls.Rx.tag),'"')
                              +' '+StrAddQuotes(NameTag(pfeiffer.Port[port].Stat.Rate.Polls.Tx.tag),'"'))
    end else Trouble('Invalid command arguments: '+Trim(Data));
    Data:='';
   end else
   {
   @ZeroPortCounters 1
   }
   if (cmdid = cmd_ZeroPortCounters) then begin
    pfeiffer_zero_stat(Val(Trim(arg)));
    Data:='';
   end else
   {
   Handle other commands by default handler...
   }
   StdIn_DefaultHandler(Data,cmd,arg);
  end;
  Data:='';
  cmd:='';
  arg:='';
  dat:='';
 end;

{***************************************************}
{***************************************************}
{***                                             ***}
{***  MMM    MMM        AAA   IIII   NNN    NN   ***}
{***  MMMM  MMMM       AAAA    II    NNNN   NN   ***}
{***  MM MMMM MM      AA AA    II    NN NN  NN   ***}
{***  MM  MM  MM     AA  AA    II    NN  NN NN   ***}
{***  MM      MM    AAAAAAA    II    NN   NNNN   ***}
{***  MM      MM   AA    AA   IIII   NN    NNN   ***}
{***                                             ***}
{***************************************************}
{$I _std_main}{*** Please never change this code ***}
{***************************************************}
